# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['R2BucketEventNotificationArgs', 'R2BucketEventNotification']

@pulumi.input_type
class R2BucketEventNotificationArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 bucket_name: pulumi.Input[_builtins.str],
                 queue_id: pulumi.Input[_builtins.str],
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['R2BucketEventNotificationRuleArgs']]]] = None):
        """
        The set of arguments for constructing a R2BucketEventNotification resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[_builtins.str] queue_id: Queue ID.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        :param pulumi.Input[Sequence[pulumi.Input['R2BucketEventNotificationRuleArgs']]] rules: Array of rules to drive notifications.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "queue_id", queue_id)
        if jurisdiction is not None:
            pulumi.set(__self__, "jurisdiction", jurisdiction)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> pulumi.Input[_builtins.str]:
        """
        Queue ID.
        """
        return pulumi.get(self, "queue_id")

    @queue_id.setter
    def queue_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "queue_id", value)

    @_builtins.property
    @pulumi.getter
    def jurisdiction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @jurisdiction.setter
    def jurisdiction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jurisdiction", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['R2BucketEventNotificationRuleArgs']]]]:
        """
        Array of rules to drive notifications.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['R2BucketEventNotificationRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _R2BucketEventNotificationState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_id: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['R2BucketEventNotificationRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering R2BucketEventNotification resources.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        :param pulumi.Input[_builtins.str] queue_id: Queue ID.
        :param pulumi.Input[_builtins.str] queue_name: Name of the queue.
        :param pulumi.Input[Sequence[pulumi.Input['R2BucketEventNotificationRuleArgs']]] rules: Array of rules to drive notifications.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if jurisdiction is not None:
            pulumi.set(__self__, "jurisdiction", jurisdiction)
        if queue_id is not None:
            pulumi.set(__self__, "queue_id", queue_id)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter
    def jurisdiction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @jurisdiction.setter
    def jurisdiction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jurisdiction", value)

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Queue ID.
        """
        return pulumi.get(self, "queue_id")

    @queue_id.setter
    def queue_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_id", value)

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the queue.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_name", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['R2BucketEventNotificationRuleArgs']]]]:
        """
        Array of rules to drive notifications.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['R2BucketEventNotificationRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.type_token("cloudflare:index/r2BucketEventNotification:R2BucketEventNotification")
class R2BucketEventNotification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['R2BucketEventNotificationRuleArgs', 'R2BucketEventNotificationRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_r2_bucket_event_notification = cloudflare.R2BucketEventNotification("example_r2_bucket_event_notification",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            bucket_name="example-bucket",
            queue_id="queue_id",
            rules=[{
                "actions": [
                    "PutObject",
                    "CopyObject",
                ],
                "description": "Notifications from source bucket to queue",
                "prefix": "img/",
                "suffix": ".jpeg",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        :param pulumi.Input[_builtins.str] queue_id: Queue ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['R2BucketEventNotificationRuleArgs', 'R2BucketEventNotificationRuleArgsDict']]]] rules: Array of rules to drive notifications.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: R2BucketEventNotificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_r2_bucket_event_notification = cloudflare.R2BucketEventNotification("example_r2_bucket_event_notification",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            bucket_name="example-bucket",
            queue_id="queue_id",
            rules=[{
                "actions": [
                    "PutObject",
                    "CopyObject",
                ],
                "description": "Notifications from source bucket to queue",
                "prefix": "img/",
                "suffix": ".jpeg",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param R2BucketEventNotificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(R2BucketEventNotificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['R2BucketEventNotificationRuleArgs', 'R2BucketEventNotificationRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = R2BucketEventNotificationArgs.__new__(R2BucketEventNotificationArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            __props__.__dict__["jurisdiction"] = jurisdiction
            if queue_id is None and not opts.urn:
                raise TypeError("Missing required property 'queue_id'")
            __props__.__dict__["queue_id"] = queue_id
            __props__.__dict__["rules"] = rules
            __props__.__dict__["queue_name"] = None
        super(R2BucketEventNotification, __self__).__init__(
            'cloudflare:index/r2BucketEventNotification:R2BucketEventNotification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            jurisdiction: Optional[pulumi.Input[_builtins.str]] = None,
            queue_id: Optional[pulumi.Input[_builtins.str]] = None,
            queue_name: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['R2BucketEventNotificationRuleArgs', 'R2BucketEventNotificationRuleArgsDict']]]]] = None) -> 'R2BucketEventNotification':
        """
        Get an existing R2BucketEventNotification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] bucket_name: Name of the bucket.
        :param pulumi.Input[_builtins.str] jurisdiction: Jurisdiction of the bucket
        :param pulumi.Input[_builtins.str] queue_id: Queue ID.
        :param pulumi.Input[_builtins.str] queue_name: Name of the queue.
        :param pulumi.Input[Sequence[pulumi.Input[Union['R2BucketEventNotificationRuleArgs', 'R2BucketEventNotificationRuleArgsDict']]]] rules: Array of rules to drive notifications.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _R2BucketEventNotificationState.__new__(_R2BucketEventNotificationState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["jurisdiction"] = jurisdiction
        __props__.__dict__["queue_id"] = queue_id
        __props__.__dict__["queue_name"] = queue_name
        __props__.__dict__["rules"] = rules
        return R2BucketEventNotification(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def jurisdiction(self) -> pulumi.Output[_builtins.str]:
        """
        Jurisdiction of the bucket
        """
        return pulumi.get(self, "jurisdiction")

    @_builtins.property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> pulumi.Output[_builtins.str]:
        """
        Queue ID.
        """
        return pulumi.get(self, "queue_id")

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the queue.
        """
        return pulumi.get(self, "queue_name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.R2BucketEventNotificationRule']]]:
        """
        Array of rules to drive notifications.
        """
        return pulumi.get(self, "rules")

