# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RateLimitArgs', 'RateLimit']

@pulumi.input_type
class RateLimitArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['RateLimitActionArgs'],
                 match: pulumi.Input['RateLimitMatchArgs'],
                 period: pulumi.Input[_builtins.float],
                 threshold: pulumi.Input[_builtins.float],
                 zone_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a RateLimit resource.
        :param pulumi.Input['RateLimitActionArgs'] action: The action to perform when the threshold of matched traffic within the configured period is exceeded.
        :param pulumi.Input['RateLimitMatchArgs'] match: Determines which traffic the rate limit counts towards the threshold.
        :param pulumi.Input[_builtins.float] period: The time in seconds (an integer value) to count matching traffic. If the count exceeds the configured threshold within this period, Cloudflare will perform the configured action.
        :param pulumi.Input[_builtins.float] threshold: The threshold that will trigger the configured mitigation action. Configure this value along with the `period` property to establish a threshold per period.
        :param pulumi.Input[_builtins.str] zone_id: Defines an identifier.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input['RateLimitActionArgs']:
        """
        The action to perform when the threshold of matched traffic within the configured period is exceeded.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['RateLimitActionArgs']):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def match(self) -> pulumi.Input['RateLimitMatchArgs']:
        """
        Determines which traffic the rate limit counts towards the threshold.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input['RateLimitMatchArgs']):
        pulumi.set(self, "match", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Input[_builtins.float]:
        """
        The time in seconds (an integer value) to count matching traffic. If the count exceeds the configured threshold within this period, Cloudflare will perform the configured action.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[_builtins.float]:
        """
        The threshold that will trigger the configured mitigation action. Configure this value along with the `period` property to establish a threshold per period.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "threshold", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _RateLimitState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['RateLimitActionArgs']] = None,
                 bypasses: Optional[pulumi.Input[Sequence[pulumi.Input['RateLimitBypassArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 match: Optional[pulumi.Input['RateLimitMatchArgs']] = None,
                 period: Optional[pulumi.Input[_builtins.float]] = None,
                 threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RateLimit resources.
        :param pulumi.Input['RateLimitActionArgs'] action: The action to perform when the threshold of matched traffic within the configured period is exceeded.
        :param pulumi.Input[Sequence[pulumi.Input['RateLimitBypassArgs']]] bypasses: Criteria specifying when the current rate limit should be bypassed. You can specify that the rate limit should not apply to one or more URLs.
        :param pulumi.Input[_builtins.str] description: An informative summary of the rule. This value is sanitized and any tags will be removed.
        :param pulumi.Input[_builtins.bool] disabled: When true, indicates that the rate limit is currently disabled.
        :param pulumi.Input['RateLimitMatchArgs'] match: Determines which traffic the rate limit counts towards the threshold.
        :param pulumi.Input[_builtins.float] period: The time in seconds (an integer value) to count matching traffic. If the count exceeds the configured threshold within this period, Cloudflare will perform the configured action.
        :param pulumi.Input[_builtins.float] threshold: The threshold that will trigger the configured mitigation action. Configure this value along with the `period` property to establish a threshold per period.
        :param pulumi.Input[_builtins.str] zone_id: Defines an identifier.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if bypasses is not None:
            pulumi.set(__self__, "bypasses", bypasses)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['RateLimitActionArgs']]:
        """
        The action to perform when the threshold of matched traffic within the configured period is exceeded.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['RateLimitActionArgs']]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def bypasses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RateLimitBypassArgs']]]]:
        """
        Criteria specifying when the current rate limit should be bypassed. You can specify that the rate limit should not apply to one or more URLs.
        """
        return pulumi.get(self, "bypasses")

    @bypasses.setter
    def bypasses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RateLimitBypassArgs']]]]):
        pulumi.set(self, "bypasses", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An informative summary of the rule. This value is sanitized and any tags will be removed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When true, indicates that the rate limit is currently disabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['RateLimitMatchArgs']]:
        """
        Determines which traffic the rate limit counts towards the threshold.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['RateLimitMatchArgs']]):
        pulumi.set(self, "match", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The time in seconds (an integer value) to count matching traffic. If the count exceeds the configured threshold within this period, Cloudflare will perform the configured action.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The threshold that will trigger the configured mitigation action. Configure this value along with the `period` property to establish a threshold per period.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "threshold", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/rateLimit:RateLimit")
class RateLimit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['RateLimitActionArgs', 'RateLimitActionArgsDict']]] = None,
                 match: Optional[pulumi.Input[Union['RateLimitMatchArgs', 'RateLimitMatchArgsDict']]] = None,
                 period: Optional[pulumi.Input[_builtins.float]] = None,
                 threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > `RateLimit` is in a deprecation phase until June 15th, 2025.
          During this time period, this resource is still
          fully supported but you are strongly advised to move to the
          `Ruleset` resource. Full details can be found in the
          developer documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_rate_limit = cloudflare.RateLimit("example_rate_limit",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            action={
                "mode": "challenge",
                "response": {
                    "body": "<error>This request has been rate-limited.</error>",
                    "content_type": "text/xml",
                },
                "timeout": 86400,
            },
            match={
                "headers": [{
                    "name": "Cf-Cache-Status",
                    "op": "ne",
                    "value": "HIT",
                }],
                "request": {
                    "methods": [
                        "GET",
                        "POST",
                    ],
                    "schemes": [
                        "HTTP",
                        "HTTPS",
                    ],
                    "url": "*.example.org/path*",
                },
                "response": {
                    "origin_traffic": True,
                },
            },
            period=900,
            threshold=60)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/rateLimit:RateLimit example '<zone_id>/<rate_limit_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RateLimitActionArgs', 'RateLimitActionArgsDict']] action: The action to perform when the threshold of matched traffic within the configured period is exceeded.
        :param pulumi.Input[Union['RateLimitMatchArgs', 'RateLimitMatchArgsDict']] match: Determines which traffic the rate limit counts towards the threshold.
        :param pulumi.Input[_builtins.float] period: The time in seconds (an integer value) to count matching traffic. If the count exceeds the configured threshold within this period, Cloudflare will perform the configured action.
        :param pulumi.Input[_builtins.float] threshold: The threshold that will trigger the configured mitigation action. Configure this value along with the `period` property to establish a threshold per period.
        :param pulumi.Input[_builtins.str] zone_id: Defines an identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RateLimitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > `RateLimit` is in a deprecation phase until June 15th, 2025.
          During this time period, this resource is still
          fully supported but you are strongly advised to move to the
          `Ruleset` resource. Full details can be found in the
          developer documentation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_rate_limit = cloudflare.RateLimit("example_rate_limit",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            action={
                "mode": "challenge",
                "response": {
                    "body": "<error>This request has been rate-limited.</error>",
                    "content_type": "text/xml",
                },
                "timeout": 86400,
            },
            match={
                "headers": [{
                    "name": "Cf-Cache-Status",
                    "op": "ne",
                    "value": "HIT",
                }],
                "request": {
                    "methods": [
                        "GET",
                        "POST",
                    ],
                    "schemes": [
                        "HTTP",
                        "HTTPS",
                    ],
                    "url": "*.example.org/path*",
                },
                "response": {
                    "origin_traffic": True,
                },
            },
            period=900,
            threshold=60)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/rateLimit:RateLimit example '<zone_id>/<rate_limit_id>'
        ```

        :param str resource_name: The name of the resource.
        :param RateLimitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RateLimitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['RateLimitActionArgs', 'RateLimitActionArgsDict']]] = None,
                 match: Optional[pulumi.Input[Union['RateLimitMatchArgs', 'RateLimitMatchArgsDict']]] = None,
                 period: Optional[pulumi.Input[_builtins.float]] = None,
                 threshold: Optional[pulumi.Input[_builtins.float]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RateLimitArgs.__new__(RateLimitArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if match is None and not opts.urn:
                raise TypeError("Missing required property 'match'")
            __props__.__dict__["match"] = match
            if period is None and not opts.urn:
                raise TypeError("Missing required property 'period'")
            __props__.__dict__["period"] = period
            if threshold is None and not opts.urn:
                raise TypeError("Missing required property 'threshold'")
            __props__.__dict__["threshold"] = threshold
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["bypasses"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["disabled"] = None
        super(RateLimit, __self__).__init__(
            'cloudflare:index/rateLimit:RateLimit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[Union['RateLimitActionArgs', 'RateLimitActionArgsDict']]] = None,
            bypasses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RateLimitBypassArgs', 'RateLimitBypassArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            match: Optional[pulumi.Input[Union['RateLimitMatchArgs', 'RateLimitMatchArgsDict']]] = None,
            period: Optional[pulumi.Input[_builtins.float]] = None,
            threshold: Optional[pulumi.Input[_builtins.float]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RateLimit':
        """
        Get an existing RateLimit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RateLimitActionArgs', 'RateLimitActionArgsDict']] action: The action to perform when the threshold of matched traffic within the configured period is exceeded.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RateLimitBypassArgs', 'RateLimitBypassArgsDict']]]] bypasses: Criteria specifying when the current rate limit should be bypassed. You can specify that the rate limit should not apply to one or more URLs.
        :param pulumi.Input[_builtins.str] description: An informative summary of the rule. This value is sanitized and any tags will be removed.
        :param pulumi.Input[_builtins.bool] disabled: When true, indicates that the rate limit is currently disabled.
        :param pulumi.Input[Union['RateLimitMatchArgs', 'RateLimitMatchArgsDict']] match: Determines which traffic the rate limit counts towards the threshold.
        :param pulumi.Input[_builtins.float] period: The time in seconds (an integer value) to count matching traffic. If the count exceeds the configured threshold within this period, Cloudflare will perform the configured action.
        :param pulumi.Input[_builtins.float] threshold: The threshold that will trigger the configured mitigation action. Configure this value along with the `period` property to establish a threshold per period.
        :param pulumi.Input[_builtins.str] zone_id: Defines an identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RateLimitState.__new__(_RateLimitState)

        __props__.__dict__["action"] = action
        __props__.__dict__["bypasses"] = bypasses
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["match"] = match
        __props__.__dict__["period"] = period
        __props__.__dict__["threshold"] = threshold
        __props__.__dict__["zone_id"] = zone_id
        return RateLimit(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output['outputs.RateLimitAction']:
        """
        The action to perform when the threshold of matched traffic within the configured period is exceeded.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def bypasses(self) -> pulumi.Output[Sequence['outputs.RateLimitBypass']]:
        """
        Criteria specifying when the current rate limit should be bypassed. You can specify that the rate limit should not apply to one or more URLs.
        """
        return pulumi.get(self, "bypasses")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        An informative summary of the rule. This value is sanitized and any tags will be removed.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[_builtins.bool]:
        """
        When true, indicates that the rate limit is currently disabled.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def match(self) -> pulumi.Output['outputs.RateLimitMatch']:
        """
        Determines which traffic the rate limit counts towards the threshold.
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[_builtins.float]:
        """
        The time in seconds (an integer value) to count matching traffic. If the count exceeds the configured threshold within this period, Cloudflare will perform the configured action.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[_builtins.float]:
        """
        The threshold that will trigger the configured mitigation action. Configure this value along with the `period` property to establish a threshold per period.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")

