# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TunnelRouteArgs', 'TunnelRoute']

@pulumi.input_type
class TunnelRouteArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 network: pulumi.Input[_builtins.str],
                 tunnel_id: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TunnelRoute resource.
        :param pulumi.Input[_builtins.str] account_id: Cloudflare account ID
        :param pulumi.Input[_builtins.str] network: The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        :param pulumi.Input[_builtins.str] tunnel_id: UUID of the tunnel.
        :param pulumi.Input[_builtins.str] comment: Optional remark describing the route.
        :param pulumi.Input[_builtins.str] virtual_network_id: UUID of the virtual network.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "tunnel_id", tunnel_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> pulumi.Input[_builtins.str]:
        """
        UUID of the tunnel.
        """
        return pulumi.get(self, "tunnel_id")

    @tunnel_id.setter
    def tunnel_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tunnel_id", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional remark describing the route.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID of the virtual network.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.input_type
class _TunnelRouteState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 deleted_at: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TunnelRoute resources.
        :param pulumi.Input[_builtins.str] account_id: Cloudflare account ID
        :param pulumi.Input[_builtins.str] comment: Optional remark describing the route.
        :param pulumi.Input[_builtins.str] created_at: Timestamp of when the resource was created.
        :param pulumi.Input[_builtins.str] deleted_at: Timestamp of when the resource was deleted. If `null`, the resource has not been deleted.
        :param pulumi.Input[_builtins.str] network: The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        :param pulumi.Input[_builtins.str] tunnel_id: UUID of the tunnel.
        :param pulumi.Input[_builtins.str] virtual_network_id: UUID of the virtual network.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deleted_at is not None:
            pulumi.set(__self__, "deleted_at", deleted_at)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if tunnel_id is not None:
            pulumi.set(__self__, "tunnel_id", tunnel_id)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional remark describing the route.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of when the resource was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="deletedAt")
    def deleted_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp of when the resource was deleted. If `null`, the resource has not been deleted.
        """
        return pulumi.get(self, "deleted_at")

    @deleted_at.setter
    def deleted_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deleted_at", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID of the tunnel.
        """
        return pulumi.get(self, "tunnel_id")

    @tunnel_id.setter
    def tunnel_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tunnel_id", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID of the virtual network.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)


warnings.warn("""cloudflare.index/tunnelroute.TunnelRoute has been deprecated in favor of cloudflare.index/zerotrusttunnelcloudflaredroute.ZeroTrustTunnelCloudflaredRoute""", DeprecationWarning)


@pulumi.type_token("cloudflare:index/tunnelRoute:TunnelRoute")
class TunnelRoute(pulumi.CustomResource):
    warnings.warn("""cloudflare.index/tunnelroute.TunnelRoute has been deprecated in favor of cloudflare.index/zerotrusttunnelcloudflaredroute.ZeroTrustTunnelCloudflaredRoute""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_tunnel_cloudflared_route = cloudflare.ZeroTrustTunnelCloudflaredRoute("example_zero_trust_tunnel_cloudflared_route",
            account_id="699d98642c564d2e855e9661899b7252",
            network="172.16.0.0/16",
            tunnel_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
            comment="Example comment for this route.",
            virtual_network_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/tunnelRoute:TunnelRoute example '<account_id>/<route_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Cloudflare account ID
        :param pulumi.Input[_builtins.str] comment: Optional remark describing the route.
        :param pulumi.Input[_builtins.str] network: The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        :param pulumi.Input[_builtins.str] tunnel_id: UUID of the tunnel.
        :param pulumi.Input[_builtins.str] virtual_network_id: UUID of the virtual network.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TunnelRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_tunnel_cloudflared_route = cloudflare.ZeroTrustTunnelCloudflaredRoute("example_zero_trust_tunnel_cloudflared_route",
            account_id="699d98642c564d2e855e9661899b7252",
            network="172.16.0.0/16",
            tunnel_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415",
            comment="Example comment for this route.",
            virtual_network_id="f70ff985-a4ef-4643-bbbc-4a0ed4fc8415")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/tunnelRoute:TunnelRoute example '<account_id>/<route_id>'
        ```

        :param str resource_name: The name of the resource.
        :param TunnelRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TunnelRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 tunnel_id: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""TunnelRoute is deprecated: cloudflare.index/tunnelroute.TunnelRoute has been deprecated in favor of cloudflare.index/zerotrusttunnelcloudflaredroute.ZeroTrustTunnelCloudflaredRoute""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TunnelRouteArgs.__new__(TunnelRouteArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["comment"] = comment
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            if tunnel_id is None and not opts.urn:
                raise TypeError("Missing required property 'tunnel_id'")
            __props__.__dict__["tunnel_id"] = tunnel_id
            __props__.__dict__["virtual_network_id"] = virtual_network_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["deleted_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/tunnelRoute:TunnelRoute")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(TunnelRoute, __self__).__init__(
            'cloudflare:index/tunnelRoute:TunnelRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            deleted_at: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            tunnel_id: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TunnelRoute':
        """
        Get an existing TunnelRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Cloudflare account ID
        :param pulumi.Input[_builtins.str] comment: Optional remark describing the route.
        :param pulumi.Input[_builtins.str] created_at: Timestamp of when the resource was created.
        :param pulumi.Input[_builtins.str] deleted_at: Timestamp of when the resource was deleted. If `null`, the resource has not been deleted.
        :param pulumi.Input[_builtins.str] network: The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        :param pulumi.Input[_builtins.str] tunnel_id: UUID of the tunnel.
        :param pulumi.Input[_builtins.str] virtual_network_id: UUID of the virtual network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TunnelRouteState.__new__(_TunnelRouteState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["comment"] = comment
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deleted_at"] = deleted_at
        __props__.__dict__["network"] = network
        __props__.__dict__["tunnel_id"] = tunnel_id
        __props__.__dict__["virtual_network_id"] = virtual_network_id
        return TunnelRoute(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Cloudflare account ID
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[_builtins.str]:
        """
        Optional remark describing the route.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of when the resource was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="deletedAt")
    def deleted_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp of when the resource was deleted. If `null`, the resource has not been deleted.
        """
        return pulumi.get(self, "deleted_at")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        The private IPv4 or IPv6 range connected by the route, in CIDR notation.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> pulumi.Output[_builtins.str]:
        """
        UUID of the tunnel.
        """
        return pulumi.get(self, "tunnel_id")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        UUID of the virtual network.
        """
        return pulumi.get(self, "virtual_network_id")

