# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WaitingRoomArgs', 'WaitingRoom']

@pulumi.input_type
class WaitingRoomArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 new_users_per_minute: pulumi.Input[_builtins.int],
                 total_active_users: pulumi.Input[_builtins.int],
                 zone_id: pulumi.Input[_builtins.str],
                 additional_routes: Optional[pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]]] = None,
                 cookie_attributes: Optional[pulumi.Input['WaitingRoomCookieAttributesArgs']] = None,
                 cookie_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_page_html: Optional[pulumi.Input[_builtins.str]] = None,
                 default_template_language: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_origin_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 json_response_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_all: Optional[pulumi.Input[_builtins.bool]] = None,
                 queueing_method: Optional[pulumi.Input[_builtins.str]] = None,
                 queueing_status_code: Optional[pulumi.Input[_builtins.int]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 turnstile_action: Optional[pulumi.Input[_builtins.str]] = None,
                 turnstile_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WaitingRoom resource.
        :param pulumi.Input[_builtins.str] host: The host name to which the waiting room will be applied (no wildcards). Please do not include the scheme (http:// or https://). The host and path combination must be unique.
        :param pulumi.Input[_builtins.str] name: A unique name to identify the waiting room. Only alphanumeric characters, hyphens and underscores are allowed.
        :param pulumi.Input[_builtins.int] new_users_per_minute: Sets the number of new users that will be let into the route every minute. This value is used as baseline for the number of users that are let in per minute. So it is possible that there is a little more or little less traffic coming to the route based on the traffic patterns at that time around the world.
        :param pulumi.Input[_builtins.int] total_active_users: Sets the total number of active user sessions on the route at a point in time. A route is a combination of host and path on which a waiting room is available. This value is used as a baseline for the total number of active user sessions on the route. It is possible to have a situation where there are more or less active users sessions on the route based on the traffic patterns at that time around the world.
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        :param pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]] additional_routes: Only available for the Waiting Room Advanced subscription. Additional hostname and path combinations to which this waiting room will be applied. There is an implied wildcard at the end of the path. The hostname and path combination must be unique to this and all other waiting rooms.
        :param pulumi.Input['WaitingRoomCookieAttributesArgs'] cookie_attributes: Configures cookie attributes for the waiting room cookie. This encrypted cookie stores a user's status in the waiting room, such as queue position.
        :param pulumi.Input[_builtins.str] cookie_suffix: Appends a '_' + a custom suffix to the end of Cloudflare Waiting Room's cookie name(_*cf*waitingroom). If `cookie_suffix` is "abcd", the cookie name will be `__cf_waitingroom_abcd`. This field is required if using `additional_routes`.
        :param pulumi.Input[_builtins.str] custom_page_html: Only available for the Waiting Room Advanced subscription. This is a template html file that will be rendered at the edge. If no custom*page*html is provided, the default waiting room will be used. The template is based on mustache ( https://mustache.github.io/ ). There are several variables that are evaluated by the Cloudflare edge:
        :param pulumi.Input[_builtins.str] default_template_language: The language of the default page template. If no default_template_language is provided, then `en-US` (English) will be used.
               Available values: "en-US", "es-ES", "de-DE", "fr-FR", "it-IT", "ja-JP", "ko-KR", "pt-BR", "zh-CN", "zh-TW", "nl-NL", "pl-PL", "id-ID", "tr-TR", "ar-EG", "ru-RU", "fa-IR", "bg-BG", "hr-HR", "cs-CZ", "da-DK", "fi-FI", "lt-LT", "ms-MY", "nb-NO", "ro-RO", "el-GR", "he-IL", "hi-IN", "hu-HU", "sr-BA", "sk-SK", "sl-SI", "sv-SE", "tl-PH", "th-TH", "uk-UA", "vi-VN".
        :param pulumi.Input[_builtins.str] description: A note that you can use to add more details about the waiting room.
        :param pulumi.Input[_builtins.bool] disable_session_renewal: Only available for the Waiting Room Advanced subscription. Disables automatic renewal of session cookies. If `true`, an accepted user will have session_duration minutes to browse the site. After that, they will have to go through the waiting room again. If `false`, a user's session cookie will be automatically renewed on every request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_origin_commands: A list of enabled origin commands.
        :param pulumi.Input[_builtins.bool] json_response_enabled: Only available for the Waiting Room Advanced subscription. If `true`, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object with information on the user's status in the waiting room as opposed to the configured static HTML page. This JSON response object has one property `cfWaitingRoom` which is an object containing the following fields:
               1. `inWaitingRoom`: Boolean indicating if the user is in the waiting room (always **true**).
               2. `waitTimeKnown`: Boolean indicating if the current estimated wait times are accurate. If **false**, they are not available.
               3. `waitTime`: Valid only when `waitTimeKnown` is **true**. Integer indicating the current estimated time in minutes the user will wait in the waiting room. When `queueingMethod` is **random**, this is set to `waitTime50Percentile`.
               4. `waitTime25Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 25% of users that gain entry the fastest (25th percentile).
               5. `waitTime50Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 50% of users that gain entry the fastest (50th percentile). In other words, half of the queued users are expected to let into the origin website before `waitTime50Percentile` and half are expected to be let in after it.
               6. `waitTime75Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 75% of users that gain entry the fastest (75th percentile).
               7. `waitTimeFormatted`: String displaying the `waitTime` formatted in English for users. If `waitTimeKnown` is **false**, `waitTimeFormatted` will display **unavailable**.
               8. `queueIsFull`: Boolean indicating if the waiting room's queue is currently full and not accepting new users at the moment.
               9. `queueAll`: Boolean indicating if all users will be queued in the waiting room and no one will be let into the origin website.
               10. `lastUpdated`: String displaying the timestamp as an ISO 8601 string of the user's last attempt to leave the waiting room and be let into the origin website. The user is able to make another attempt after `refreshIntervalSeconds` past this time. If the user makes a request too soon, it will be ignored and `lastUpdated` will not change.
               11. `refreshIntervalSeconds`: Integer indicating the number of seconds after `lastUpdated` until the user is able to make another attempt to leave the waiting room and be let into the origin website. When the `queueingMethod` is `reject`, there is no specified refresh time —\\_it will always be **zero**.
               12. `queueingMethod`: The queueing method currently used by the waiting room. It is either **fifo**, **random**, **passthrough**, or **reject**.
               13. `isFIFOQueue`: Boolean indicating if the waiting room uses a FIFO (First-In-First-Out) queue.
               14. `isRandomQueue`: Boolean indicating if the waiting room uses a Random queue where users gain access randomly.
               15. `isPassthroughQueue`: Boolean indicating if the waiting room uses a passthrough queue. Keep in mind that when passthrough is enabled, this JSON response will only exist when `queueAll` is **true** or `isEventPrequeueing` is **true** because in all other cases requests will go directly to the origin.
               16. `isRejectQueue`: Boolean indicating if the waiting room uses a reject queue.
               17. `isEventActive`: Boolean indicating if an event is currently occurring. Events are able to change a waiting room's behavior during a specified period of time. For additional information, look at the event properties `prequeue_start_time`, `event_start_time`, and `event_end_time` in the documentation for creating waiting room events. Events are considered active between these start and end times, as well as during the prequeueing period if it exists.
               18. `isEventPrequeueing`: Valid only when `isEventActive` is **true**. Boolean indicating if an event is currently prequeueing users before it starts.
               19. `timeUntilEventStart`: Valid only when `isEventPrequeueing` is **true**. Integer indicating the number of minutes until the event starts.
               20. `timeUntilEventStartFormatted`: String displaying the `timeUntilEventStart` formatted in English for users. If `isEventPrequeueing` is **false**, `timeUntilEventStartFormatted` will display **unavailable**.
               21. `timeUntilEventEnd`: Valid only when `isEventActive` is **true**. Integer indicating the number of minutes until the event ends.
               22. `timeUntilEventEndFormatted`: String displaying the `timeUntilEventEnd` formatted in English for users. If `isEventActive` is **false**, `timeUntilEventEndFormatted` will display **unavailable**.
               23. `shuffleAtEventStart`: Valid only when `isEventActive` is **true**. Boolean indicating if the users in the prequeue are shuffled randomly when the event starts.
               24. `turnstile`: Empty when turnstile isn't enabled. String displaying an html tag to display the Turnstile widget. Please add the `{{{turnstile}}}` tag to the `custom_html` template to ensure the Turnstile widget appears.
               25. `infiniteQueue`: Boolean indicating whether the response is for a user in the infinite queue.
               
               An example cURL to a waiting room could be:
               
               	curl -X GET "https://example.com/waitingroom" \\
               		-H "Accept: application/json"
               
               If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **fifo** and no event is active could be:
               
               	{
               		"cfWaitingRoom": {
               			"inWaitingRoom": true,
               			"waitTimeKnown": true,
               			"waitTime": 10,
               			"waitTime25Percentile": 0,
               			"waitTime50Percentile": 0,
               			"waitTime75Percentile": 0,
               			"waitTimeFormatted": "10 minutes",
               			"queueIsFull": false,
               			"queueAll": false,
               			"lastUpdated": "2020-08-03T23:46:00.000Z",
               			"refreshIntervalSeconds": 20,
               			"queueingMethod": "fifo",
               			"isFIFOQueue": true,
               			"isRandomQueue": false,
               			"isPassthroughQueue": false,
               			"isRejectQueue": false,
               			"isEventActive": false,
               			"isEventPrequeueing": false,
               			"timeUntilEventStart": 0,
               			"timeUntilEventStartFormatted": "unavailable",
               			"timeUntilEventEnd": 0,
               			"timeUntilEventEndFormatted": "unavailable",
               			"shuffleAtEventStart": false
               		}
               	}
               
               If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **random** and an event is active could be:
               
               	{
               		"cfWaitingRoom": {
               			"inWaitingRoom": true,
               			"waitTimeKnown": true,
               			"waitTime": 10,
               			"waitTime25Percentile": 5,
               			"waitTime50Percentile": 10,
               			"waitTime75Percentile": 15,
               			"waitTimeFormatted": "5 minutes to 15 minutes",
               			"queueIsFull": false,
               			"queueAll": false,
               			"lastUpdated": "2020-08-03T23:46:00.000Z",
               			"refreshIntervalSeconds": 20,
               			"queueingMethod": "random",
               			"isFIFOQueue": false,
               			"isRandomQueue": true,
               			"isPassthroughQueue": false,
               			"isRejectQueue": false,
               			"isEventActive": true,
               			"isEventPrequeueing": false,
               			"timeUntilEventStart": 0,
               			"timeUntilEventStartFormatted": "unavailable",
               			"timeUntilEventEnd": 15,
               			"timeUntilEventEndFormatted": "15 minutes",
               			"shuffleAtEventStart": true
               		}
               	}
        :param pulumi.Input[_builtins.str] path: Sets the path within the host to enable the waiting room on. The waiting room will be enabled for all subpaths as well. If there are two waiting rooms on the same subpath, the waiting room for the most specific path will be chosen. Wildcards and query parameters are not supported.
        :param pulumi.Input[_builtins.bool] queue_all: If queue_all is `true`, all the traffic that is coming to a route will be sent to the waiting room. No new traffic can get to the route once this field is set and estimated time will become unavailable.
        :param pulumi.Input[_builtins.str] queueing_method: Sets the queueing method used by the waiting room. Changing this parameter from the **default** queueing method is only available for the Waiting Room Advanced subscription. Regardless of the queueing method, if `queue_all` is enabled or an event is prequeueing, users in the waiting room will not be accepted to the origin. These users will always see a waiting room page that refreshes automatically. The valid queueing methods are:
               1. `fifo` **(default)**: First-In-First-Out queue where customers gain access in the order they arrived.
               2. `random`: Random queue where customers gain access randomly, regardless of arrival time.
               3. `passthrough`: Users will pass directly through the waiting room and into the origin website. As a result, any configured limits will not be respected while this is enabled. This method can be used as an alternative to disabling a waiting room (with `suspended`) so that analytics are still reported. This can be used if you wish to allow all traffic normally, but want to restrict traffic during a waiting room event, or vice versa.
               4. `reject`: Users will be immediately rejected from the waiting room. As a result, no users will reach the origin website while this is enabled. This can be used if you wish to reject all traffic while performing maintenance, block traffic during a specified period of time (an event), or block traffic while events are not occurring. Consider a waiting room used for vaccine distribution that only allows traffic during sign-up events, and otherwise blocks all traffic. For this case, the waiting room uses `reject`, and its events override this with `fifo`, `random`, or `passthrough`. When this queueing method is enabled and neither `queueAll` is enabled nor an event is prequeueing, the waiting room page **will not refresh automatically**.
               Available values: "fifo", "random", "passthrough", "reject".
        :param pulumi.Input[_builtins.int] queueing_status_code: HTTP status code returned to a user while in the queue.
               Available values: 200, 202, 429.
        :param pulumi.Input[_builtins.int] session_duration: Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the route. If a user is not seen by Cloudflare again in that time period, they will be treated as a new user that visits the route.
        :param pulumi.Input[_builtins.bool] suspended: Suspends or allows traffic going to the waiting room. If set to `true`, the traffic will not go to the waiting room.
        :param pulumi.Input[_builtins.str] turnstile_action: Which action to take when a bot is detected using Turnstile. `log` will
               have no impact on queueing behavior, simply keeping track of how many
               bots are detected in Waiting Room Analytics. `infinite_queue` will send
               bots to a false queueing state, where they will never reach your
               origin. `infinite_queue` requires Advanced Waiting Room.
               Available values: "log", "infinite_queue".
        :param pulumi.Input[_builtins.str] turnstile_mode: Which Turnstile widget type to use for detecting bot traffic. See
               [the Turnstile documentation](https://developers.cloudflare.com/turnstile/concepts/widget/#widget-types)
               for the definitions of these widget types. Set to `off` to disable the
               Turnstile integration entirely. Setting this to anything other than
               `off` or `invisible` requires Advanced Waiting Room.
               Available values: "off", "invisible", "visible_non_interactive", "visible_managed".
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "new_users_per_minute", new_users_per_minute)
        pulumi.set(__self__, "total_active_users", total_active_users)
        pulumi.set(__self__, "zone_id", zone_id)
        if additional_routes is not None:
            pulumi.set(__self__, "additional_routes", additional_routes)
        if cookie_attributes is not None:
            pulumi.set(__self__, "cookie_attributes", cookie_attributes)
        if cookie_suffix is not None:
            pulumi.set(__self__, "cookie_suffix", cookie_suffix)
        if custom_page_html is not None:
            pulumi.set(__self__, "custom_page_html", custom_page_html)
        if default_template_language is not None:
            pulumi.set(__self__, "default_template_language", default_template_language)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_session_renewal is not None:
            pulumi.set(__self__, "disable_session_renewal", disable_session_renewal)
        if enabled_origin_commands is not None:
            pulumi.set(__self__, "enabled_origin_commands", enabled_origin_commands)
        if json_response_enabled is not None:
            pulumi.set(__self__, "json_response_enabled", json_response_enabled)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if queue_all is not None:
            pulumi.set(__self__, "queue_all", queue_all)
        if queueing_method is not None:
            pulumi.set(__self__, "queueing_method", queueing_method)
        if queueing_status_code is not None:
            pulumi.set(__self__, "queueing_status_code", queueing_status_code)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if turnstile_action is not None:
            pulumi.set(__self__, "turnstile_action", turnstile_action)
        if turnstile_mode is not None:
            pulumi.set(__self__, "turnstile_mode", turnstile_mode)

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Input[_builtins.str]:
        """
        The host name to which the waiting room will be applied (no wildcards). Please do not include the scheme (http:// or https://). The host and path combination must be unique.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        A unique name to identify the waiting room. Only alphanumeric characters, hyphens and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> pulumi.Input[_builtins.int]:
        """
        Sets the number of new users that will be let into the route every minute. This value is used as baseline for the number of users that are let in per minute. So it is possible that there is a little more or little less traffic coming to the route based on the traffic patterns at that time around the world.
        """
        return pulumi.get(self, "new_users_per_minute")

    @new_users_per_minute.setter
    def new_users_per_minute(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "new_users_per_minute", value)

    @_builtins.property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> pulumi.Input[_builtins.int]:
        """
        Sets the total number of active user sessions on the route at a point in time. A route is a combination of host and path on which a waiting room is available. This value is used as a baseline for the total number of active user sessions on the route. It is possible to have a situation where there are more or less active users sessions on the route based on the traffic patterns at that time around the world.
        """
        return pulumi.get(self, "total_active_users")

    @total_active_users.setter
    def total_active_users(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "total_active_users", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="additionalRoutes")
    def additional_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]]]:
        """
        Only available for the Waiting Room Advanced subscription. Additional hostname and path combinations to which this waiting room will be applied. There is an implied wildcard at the end of the path. The hostname and path combination must be unique to this and all other waiting rooms.
        """
        return pulumi.get(self, "additional_routes")

    @additional_routes.setter
    def additional_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]]]):
        pulumi.set(self, "additional_routes", value)

    @_builtins.property
    @pulumi.getter(name="cookieAttributes")
    def cookie_attributes(self) -> Optional[pulumi.Input['WaitingRoomCookieAttributesArgs']]:
        """
        Configures cookie attributes for the waiting room cookie. This encrypted cookie stores a user's status in the waiting room, such as queue position.
        """
        return pulumi.get(self, "cookie_attributes")

    @cookie_attributes.setter
    def cookie_attributes(self, value: Optional[pulumi.Input['WaitingRoomCookieAttributesArgs']]):
        pulumi.set(self, "cookie_attributes", value)

    @_builtins.property
    @pulumi.getter(name="cookieSuffix")
    def cookie_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Appends a '_' + a custom suffix to the end of Cloudflare Waiting Room's cookie name(_*cf*waitingroom). If `cookie_suffix` is "abcd", the cookie name will be `__cf_waitingroom_abcd`. This field is required if using `additional_routes`.
        """
        return pulumi.get(self, "cookie_suffix")

    @cookie_suffix.setter
    def cookie_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cookie_suffix", value)

    @_builtins.property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only available for the Waiting Room Advanced subscription. This is a template html file that will be rendered at the edge. If no custom*page*html is provided, the default waiting room will be used. The template is based on mustache ( https://mustache.github.io/ ). There are several variables that are evaluated by the Cloudflare edge:
        """
        return pulumi.get(self, "custom_page_html")

    @custom_page_html.setter
    def custom_page_html(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_page_html", value)

    @_builtins.property
    @pulumi.getter(name="defaultTemplateLanguage")
    def default_template_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the default page template. If no default_template_language is provided, then `en-US` (English) will be used.
        Available values: "en-US", "es-ES", "de-DE", "fr-FR", "it-IT", "ja-JP", "ko-KR", "pt-BR", "zh-CN", "zh-TW", "nl-NL", "pl-PL", "id-ID", "tr-TR", "ar-EG", "ru-RU", "fa-IR", "bg-BG", "hr-HR", "cs-CZ", "da-DK", "fi-FI", "lt-LT", "ms-MY", "nb-NO", "ro-RO", "el-GR", "he-IL", "hi-IN", "hu-HU", "sr-BA", "sk-SK", "sl-SI", "sv-SE", "tl-PH", "th-TH", "uk-UA", "vi-VN".
        """
        return pulumi.get(self, "default_template_language")

    @default_template_language.setter
    def default_template_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_template_language", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A note that you can use to add more details about the waiting room.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableSessionRenewal")
    def disable_session_renewal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Only available for the Waiting Room Advanced subscription. Disables automatic renewal of session cookies. If `true`, an accepted user will have session_duration minutes to browse the site. After that, they will have to go through the waiting room again. If `false`, a user's session cookie will be automatically renewed on every request.
        """
        return pulumi.get(self, "disable_session_renewal")

    @disable_session_renewal.setter
    def disable_session_renewal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_session_renewal", value)

    @_builtins.property
    @pulumi.getter(name="enabledOriginCommands")
    def enabled_origin_commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of enabled origin commands.
        """
        return pulumi.get(self, "enabled_origin_commands")

    @enabled_origin_commands.setter
    def enabled_origin_commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_origin_commands", value)

    @_builtins.property
    @pulumi.getter(name="jsonResponseEnabled")
    def json_response_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Only available for the Waiting Room Advanced subscription. If `true`, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object with information on the user's status in the waiting room as opposed to the configured static HTML page. This JSON response object has one property `cfWaitingRoom` which is an object containing the following fields:
        1. `inWaitingRoom`: Boolean indicating if the user is in the waiting room (always **true**).
        2. `waitTimeKnown`: Boolean indicating if the current estimated wait times are accurate. If **false**, they are not available.
        3. `waitTime`: Valid only when `waitTimeKnown` is **true**. Integer indicating the current estimated time in minutes the user will wait in the waiting room. When `queueingMethod` is **random**, this is set to `waitTime50Percentile`.
        4. `waitTime25Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 25% of users that gain entry the fastest (25th percentile).
        5. `waitTime50Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 50% of users that gain entry the fastest (50th percentile). In other words, half of the queued users are expected to let into the origin website before `waitTime50Percentile` and half are expected to be let in after it.
        6. `waitTime75Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 75% of users that gain entry the fastest (75th percentile).
        7. `waitTimeFormatted`: String displaying the `waitTime` formatted in English for users. If `waitTimeKnown` is **false**, `waitTimeFormatted` will display **unavailable**.
        8. `queueIsFull`: Boolean indicating if the waiting room's queue is currently full and not accepting new users at the moment.
        9. `queueAll`: Boolean indicating if all users will be queued in the waiting room and no one will be let into the origin website.
        10. `lastUpdated`: String displaying the timestamp as an ISO 8601 string of the user's last attempt to leave the waiting room and be let into the origin website. The user is able to make another attempt after `refreshIntervalSeconds` past this time. If the user makes a request too soon, it will be ignored and `lastUpdated` will not change.
        11. `refreshIntervalSeconds`: Integer indicating the number of seconds after `lastUpdated` until the user is able to make another attempt to leave the waiting room and be let into the origin website. When the `queueingMethod` is `reject`, there is no specified refresh time —\\_it will always be **zero**.
        12. `queueingMethod`: The queueing method currently used by the waiting room. It is either **fifo**, **random**, **passthrough**, or **reject**.
        13. `isFIFOQueue`: Boolean indicating if the waiting room uses a FIFO (First-In-First-Out) queue.
        14. `isRandomQueue`: Boolean indicating if the waiting room uses a Random queue where users gain access randomly.
        15. `isPassthroughQueue`: Boolean indicating if the waiting room uses a passthrough queue. Keep in mind that when passthrough is enabled, this JSON response will only exist when `queueAll` is **true** or `isEventPrequeueing` is **true** because in all other cases requests will go directly to the origin.
        16. `isRejectQueue`: Boolean indicating if the waiting room uses a reject queue.
        17. `isEventActive`: Boolean indicating if an event is currently occurring. Events are able to change a waiting room's behavior during a specified period of time. For additional information, look at the event properties `prequeue_start_time`, `event_start_time`, and `event_end_time` in the documentation for creating waiting room events. Events are considered active between these start and end times, as well as during the prequeueing period if it exists.
        18. `isEventPrequeueing`: Valid only when `isEventActive` is **true**. Boolean indicating if an event is currently prequeueing users before it starts.
        19. `timeUntilEventStart`: Valid only when `isEventPrequeueing` is **true**. Integer indicating the number of minutes until the event starts.
        20. `timeUntilEventStartFormatted`: String displaying the `timeUntilEventStart` formatted in English for users. If `isEventPrequeueing` is **false**, `timeUntilEventStartFormatted` will display **unavailable**.
        21. `timeUntilEventEnd`: Valid only when `isEventActive` is **true**. Integer indicating the number of minutes until the event ends.
        22. `timeUntilEventEndFormatted`: String displaying the `timeUntilEventEnd` formatted in English for users. If `isEventActive` is **false**, `timeUntilEventEndFormatted` will display **unavailable**.
        23. `shuffleAtEventStart`: Valid only when `isEventActive` is **true**. Boolean indicating if the users in the prequeue are shuffled randomly when the event starts.
        24. `turnstile`: Empty when turnstile isn't enabled. String displaying an html tag to display the Turnstile widget. Please add the `{{{turnstile}}}` tag to the `custom_html` template to ensure the Turnstile widget appears.
        25. `infiniteQueue`: Boolean indicating whether the response is for a user in the infinite queue.

        An example cURL to a waiting room could be:

        	curl -X GET "https://example.com/waitingroom" \\
        		-H "Accept: application/json"

        If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **fifo** and no event is active could be:

        	{
        		"cfWaitingRoom": {
        			"inWaitingRoom": true,
        			"waitTimeKnown": true,
        			"waitTime": 10,
        			"waitTime25Percentile": 0,
        			"waitTime50Percentile": 0,
        			"waitTime75Percentile": 0,
        			"waitTimeFormatted": "10 minutes",
        			"queueIsFull": false,
        			"queueAll": false,
        			"lastUpdated": "2020-08-03T23:46:00.000Z",
        			"refreshIntervalSeconds": 20,
        			"queueingMethod": "fifo",
        			"isFIFOQueue": true,
        			"isRandomQueue": false,
        			"isPassthroughQueue": false,
        			"isRejectQueue": false,
        			"isEventActive": false,
        			"isEventPrequeueing": false,
        			"timeUntilEventStart": 0,
        			"timeUntilEventStartFormatted": "unavailable",
        			"timeUntilEventEnd": 0,
        			"timeUntilEventEndFormatted": "unavailable",
        			"shuffleAtEventStart": false
        		}
        	}

        If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **random** and an event is active could be:

        	{
        		"cfWaitingRoom": {
        			"inWaitingRoom": true,
        			"waitTimeKnown": true,
        			"waitTime": 10,
        			"waitTime25Percentile": 5,
        			"waitTime50Percentile": 10,
        			"waitTime75Percentile": 15,
        			"waitTimeFormatted": "5 minutes to 15 minutes",
        			"queueIsFull": false,
        			"queueAll": false,
        			"lastUpdated": "2020-08-03T23:46:00.000Z",
        			"refreshIntervalSeconds": 20,
        			"queueingMethod": "random",
        			"isFIFOQueue": false,
        			"isRandomQueue": true,
        			"isPassthroughQueue": false,
        			"isRejectQueue": false,
        			"isEventActive": true,
        			"isEventPrequeueing": false,
        			"timeUntilEventStart": 0,
        			"timeUntilEventStartFormatted": "unavailable",
        			"timeUntilEventEnd": 15,
        			"timeUntilEventEndFormatted": "15 minutes",
        			"shuffleAtEventStart": true
        		}
        	}
        """
        return pulumi.get(self, "json_response_enabled")

    @json_response_enabled.setter
    def json_response_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "json_response_enabled", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the path within the host to enable the waiting room on. The waiting room will be enabled for all subpaths as well. If there are two waiting rooms on the same subpath, the waiting room for the most specific path will be chosen. Wildcards and query parameters are not supported.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="queueAll")
    def queue_all(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If queue_all is `true`, all the traffic that is coming to a route will be sent to the waiting room. No new traffic can get to the route once this field is set and estimated time will become unavailable.
        """
        return pulumi.get(self, "queue_all")

    @queue_all.setter
    def queue_all(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "queue_all", value)

    @_builtins.property
    @pulumi.getter(name="queueingMethod")
    def queueing_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the queueing method used by the waiting room. Changing this parameter from the **default** queueing method is only available for the Waiting Room Advanced subscription. Regardless of the queueing method, if `queue_all` is enabled or an event is prequeueing, users in the waiting room will not be accepted to the origin. These users will always see a waiting room page that refreshes automatically. The valid queueing methods are:
        1. `fifo` **(default)**: First-In-First-Out queue where customers gain access in the order they arrived.
        2. `random`: Random queue where customers gain access randomly, regardless of arrival time.
        3. `passthrough`: Users will pass directly through the waiting room and into the origin website. As a result, any configured limits will not be respected while this is enabled. This method can be used as an alternative to disabling a waiting room (with `suspended`) so that analytics are still reported. This can be used if you wish to allow all traffic normally, but want to restrict traffic during a waiting room event, or vice versa.
        4. `reject`: Users will be immediately rejected from the waiting room. As a result, no users will reach the origin website while this is enabled. This can be used if you wish to reject all traffic while performing maintenance, block traffic during a specified period of time (an event), or block traffic while events are not occurring. Consider a waiting room used for vaccine distribution that only allows traffic during sign-up events, and otherwise blocks all traffic. For this case, the waiting room uses `reject`, and its events override this with `fifo`, `random`, or `passthrough`. When this queueing method is enabled and neither `queueAll` is enabled nor an event is prequeueing, the waiting room page **will not refresh automatically**.
        Available values: "fifo", "random", "passthrough", "reject".
        """
        return pulumi.get(self, "queueing_method")

    @queueing_method.setter
    def queueing_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queueing_method", value)

    @_builtins.property
    @pulumi.getter(name="queueingStatusCode")
    def queueing_status_code(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        HTTP status code returned to a user while in the queue.
        Available values: 200, 202, 429.
        """
        return pulumi.get(self, "queueing_status_code")

    @queueing_status_code.setter
    def queueing_status_code(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "queueing_status_code", value)

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the route. If a user is not seen by Cloudflare again in that time period, they will be treated as a new user that visits the route.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "session_duration", value)

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Suspends or allows traffic going to the waiting room. If set to `true`, the traffic will not go to the waiting room.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @_builtins.property
    @pulumi.getter(name="turnstileAction")
    def turnstile_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Which action to take when a bot is detected using Turnstile. `log` will
        have no impact on queueing behavior, simply keeping track of how many
        bots are detected in Waiting Room Analytics. `infinite_queue` will send
        bots to a false queueing state, where they will never reach your
        origin. `infinite_queue` requires Advanced Waiting Room.
        Available values: "log", "infinite_queue".
        """
        return pulumi.get(self, "turnstile_action")

    @turnstile_action.setter
    def turnstile_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "turnstile_action", value)

    @_builtins.property
    @pulumi.getter(name="turnstileMode")
    def turnstile_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Which Turnstile widget type to use for detecting bot traffic. See
        [the Turnstile documentation](https://developers.cloudflare.com/turnstile/concepts/widget/#widget-types)
        for the definitions of these widget types. Set to `off` to disable the
        Turnstile integration entirely. Setting this to anything other than
        `off` or `invisible` requires Advanced Waiting Room.
        Available values: "off", "invisible", "visible_non_interactive", "visible_managed".
        """
        return pulumi.get(self, "turnstile_mode")

    @turnstile_mode.setter
    def turnstile_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "turnstile_mode", value)


@pulumi.input_type
class _WaitingRoomState:
    def __init__(__self__, *,
                 additional_routes: Optional[pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]]] = None,
                 cookie_attributes: Optional[pulumi.Input['WaitingRoomCookieAttributesArgs']] = None,
                 cookie_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_page_html: Optional[pulumi.Input[_builtins.str]] = None,
                 default_template_language: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_origin_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 json_response_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 modified_on: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 next_event_prequeue_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 next_event_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_all: Optional[pulumi.Input[_builtins.bool]] = None,
                 queueing_method: Optional[pulumi.Input[_builtins.str]] = None,
                 queueing_status_code: Optional[pulumi.Input[_builtins.int]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 total_active_users: Optional[pulumi.Input[_builtins.int]] = None,
                 turnstile_action: Optional[pulumi.Input[_builtins.str]] = None,
                 turnstile_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WaitingRoom resources.
        :param pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]] additional_routes: Only available for the Waiting Room Advanced subscription. Additional hostname and path combinations to which this waiting room will be applied. There is an implied wildcard at the end of the path. The hostname and path combination must be unique to this and all other waiting rooms.
        :param pulumi.Input['WaitingRoomCookieAttributesArgs'] cookie_attributes: Configures cookie attributes for the waiting room cookie. This encrypted cookie stores a user's status in the waiting room, such as queue position.
        :param pulumi.Input[_builtins.str] cookie_suffix: Appends a '_' + a custom suffix to the end of Cloudflare Waiting Room's cookie name(_*cf*waitingroom). If `cookie_suffix` is "abcd", the cookie name will be `__cf_waitingroom_abcd`. This field is required if using `additional_routes`.
        :param pulumi.Input[_builtins.str] custom_page_html: Only available for the Waiting Room Advanced subscription. This is a template html file that will be rendered at the edge. If no custom*page*html is provided, the default waiting room will be used. The template is based on mustache ( https://mustache.github.io/ ). There are several variables that are evaluated by the Cloudflare edge:
        :param pulumi.Input[_builtins.str] default_template_language: The language of the default page template. If no default_template_language is provided, then `en-US` (English) will be used.
               Available values: "en-US", "es-ES", "de-DE", "fr-FR", "it-IT", "ja-JP", "ko-KR", "pt-BR", "zh-CN", "zh-TW", "nl-NL", "pl-PL", "id-ID", "tr-TR", "ar-EG", "ru-RU", "fa-IR", "bg-BG", "hr-HR", "cs-CZ", "da-DK", "fi-FI", "lt-LT", "ms-MY", "nb-NO", "ro-RO", "el-GR", "he-IL", "hi-IN", "hu-HU", "sr-BA", "sk-SK", "sl-SI", "sv-SE", "tl-PH", "th-TH", "uk-UA", "vi-VN".
        :param pulumi.Input[_builtins.str] description: A note that you can use to add more details about the waiting room.
        :param pulumi.Input[_builtins.bool] disable_session_renewal: Only available for the Waiting Room Advanced subscription. Disables automatic renewal of session cookies. If `true`, an accepted user will have session_duration minutes to browse the site. After that, they will have to go through the waiting room again. If `false`, a user's session cookie will be automatically renewed on every request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_origin_commands: A list of enabled origin commands.
        :param pulumi.Input[_builtins.str] host: The host name to which the waiting room will be applied (no wildcards). Please do not include the scheme (http:// or https://). The host and path combination must be unique.
        :param pulumi.Input[_builtins.bool] json_response_enabled: Only available for the Waiting Room Advanced subscription. If `true`, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object with information on the user's status in the waiting room as opposed to the configured static HTML page. This JSON response object has one property `cfWaitingRoom` which is an object containing the following fields:
               1. `inWaitingRoom`: Boolean indicating if the user is in the waiting room (always **true**).
               2. `waitTimeKnown`: Boolean indicating if the current estimated wait times are accurate. If **false**, they are not available.
               3. `waitTime`: Valid only when `waitTimeKnown` is **true**. Integer indicating the current estimated time in minutes the user will wait in the waiting room. When `queueingMethod` is **random**, this is set to `waitTime50Percentile`.
               4. `waitTime25Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 25% of users that gain entry the fastest (25th percentile).
               5. `waitTime50Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 50% of users that gain entry the fastest (50th percentile). In other words, half of the queued users are expected to let into the origin website before `waitTime50Percentile` and half are expected to be let in after it.
               6. `waitTime75Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 75% of users that gain entry the fastest (75th percentile).
               7. `waitTimeFormatted`: String displaying the `waitTime` formatted in English for users. If `waitTimeKnown` is **false**, `waitTimeFormatted` will display **unavailable**.
               8. `queueIsFull`: Boolean indicating if the waiting room's queue is currently full and not accepting new users at the moment.
               9. `queueAll`: Boolean indicating if all users will be queued in the waiting room and no one will be let into the origin website.
               10. `lastUpdated`: String displaying the timestamp as an ISO 8601 string of the user's last attempt to leave the waiting room and be let into the origin website. The user is able to make another attempt after `refreshIntervalSeconds` past this time. If the user makes a request too soon, it will be ignored and `lastUpdated` will not change.
               11. `refreshIntervalSeconds`: Integer indicating the number of seconds after `lastUpdated` until the user is able to make another attempt to leave the waiting room and be let into the origin website. When the `queueingMethod` is `reject`, there is no specified refresh time —\\_it will always be **zero**.
               12. `queueingMethod`: The queueing method currently used by the waiting room. It is either **fifo**, **random**, **passthrough**, or **reject**.
               13. `isFIFOQueue`: Boolean indicating if the waiting room uses a FIFO (First-In-First-Out) queue.
               14. `isRandomQueue`: Boolean indicating if the waiting room uses a Random queue where users gain access randomly.
               15. `isPassthroughQueue`: Boolean indicating if the waiting room uses a passthrough queue. Keep in mind that when passthrough is enabled, this JSON response will only exist when `queueAll` is **true** or `isEventPrequeueing` is **true** because in all other cases requests will go directly to the origin.
               16. `isRejectQueue`: Boolean indicating if the waiting room uses a reject queue.
               17. `isEventActive`: Boolean indicating if an event is currently occurring. Events are able to change a waiting room's behavior during a specified period of time. For additional information, look at the event properties `prequeue_start_time`, `event_start_time`, and `event_end_time` in the documentation for creating waiting room events. Events are considered active between these start and end times, as well as during the prequeueing period if it exists.
               18. `isEventPrequeueing`: Valid only when `isEventActive` is **true**. Boolean indicating if an event is currently prequeueing users before it starts.
               19. `timeUntilEventStart`: Valid only when `isEventPrequeueing` is **true**. Integer indicating the number of minutes until the event starts.
               20. `timeUntilEventStartFormatted`: String displaying the `timeUntilEventStart` formatted in English for users. If `isEventPrequeueing` is **false**, `timeUntilEventStartFormatted` will display **unavailable**.
               21. `timeUntilEventEnd`: Valid only when `isEventActive` is **true**. Integer indicating the number of minutes until the event ends.
               22. `timeUntilEventEndFormatted`: String displaying the `timeUntilEventEnd` formatted in English for users. If `isEventActive` is **false**, `timeUntilEventEndFormatted` will display **unavailable**.
               23. `shuffleAtEventStart`: Valid only when `isEventActive` is **true**. Boolean indicating if the users in the prequeue are shuffled randomly when the event starts.
               24. `turnstile`: Empty when turnstile isn't enabled. String displaying an html tag to display the Turnstile widget. Please add the `{{{turnstile}}}` tag to the `custom_html` template to ensure the Turnstile widget appears.
               25. `infiniteQueue`: Boolean indicating whether the response is for a user in the infinite queue.
               
               An example cURL to a waiting room could be:
               
               	curl -X GET "https://example.com/waitingroom" \\
               		-H "Accept: application/json"
               
               If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **fifo** and no event is active could be:
               
               	{
               		"cfWaitingRoom": {
               			"inWaitingRoom": true,
               			"waitTimeKnown": true,
               			"waitTime": 10,
               			"waitTime25Percentile": 0,
               			"waitTime50Percentile": 0,
               			"waitTime75Percentile": 0,
               			"waitTimeFormatted": "10 minutes",
               			"queueIsFull": false,
               			"queueAll": false,
               			"lastUpdated": "2020-08-03T23:46:00.000Z",
               			"refreshIntervalSeconds": 20,
               			"queueingMethod": "fifo",
               			"isFIFOQueue": true,
               			"isRandomQueue": false,
               			"isPassthroughQueue": false,
               			"isRejectQueue": false,
               			"isEventActive": false,
               			"isEventPrequeueing": false,
               			"timeUntilEventStart": 0,
               			"timeUntilEventStartFormatted": "unavailable",
               			"timeUntilEventEnd": 0,
               			"timeUntilEventEndFormatted": "unavailable",
               			"shuffleAtEventStart": false
               		}
               	}
               
               If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **random** and an event is active could be:
               
               	{
               		"cfWaitingRoom": {
               			"inWaitingRoom": true,
               			"waitTimeKnown": true,
               			"waitTime": 10,
               			"waitTime25Percentile": 5,
               			"waitTime50Percentile": 10,
               			"waitTime75Percentile": 15,
               			"waitTimeFormatted": "5 minutes to 15 minutes",
               			"queueIsFull": false,
               			"queueAll": false,
               			"lastUpdated": "2020-08-03T23:46:00.000Z",
               			"refreshIntervalSeconds": 20,
               			"queueingMethod": "random",
               			"isFIFOQueue": false,
               			"isRandomQueue": true,
               			"isPassthroughQueue": false,
               			"isRejectQueue": false,
               			"isEventActive": true,
               			"isEventPrequeueing": false,
               			"timeUntilEventStart": 0,
               			"timeUntilEventStartFormatted": "unavailable",
               			"timeUntilEventEnd": 15,
               			"timeUntilEventEndFormatted": "15 minutes",
               			"shuffleAtEventStart": true
               		}
               	}
        :param pulumi.Input[_builtins.str] name: A unique name to identify the waiting room. Only alphanumeric characters, hyphens and underscores are allowed.
        :param pulumi.Input[_builtins.int] new_users_per_minute: Sets the number of new users that will be let into the route every minute. This value is used as baseline for the number of users that are let in per minute. So it is possible that there is a little more or little less traffic coming to the route based on the traffic patterns at that time around the world.
        :param pulumi.Input[_builtins.str] next_event_prequeue_start_time: An ISO 8601 timestamp that marks when the next event will begin queueing.
        :param pulumi.Input[_builtins.str] next_event_start_time: An ISO 8601 timestamp that marks when the next event will start.
        :param pulumi.Input[_builtins.str] path: Sets the path within the host to enable the waiting room on. The waiting room will be enabled for all subpaths as well. If there are two waiting rooms on the same subpath, the waiting room for the most specific path will be chosen. Wildcards and query parameters are not supported.
        :param pulumi.Input[_builtins.bool] queue_all: If queue_all is `true`, all the traffic that is coming to a route will be sent to the waiting room. No new traffic can get to the route once this field is set and estimated time will become unavailable.
        :param pulumi.Input[_builtins.str] queueing_method: Sets the queueing method used by the waiting room. Changing this parameter from the **default** queueing method is only available for the Waiting Room Advanced subscription. Regardless of the queueing method, if `queue_all` is enabled or an event is prequeueing, users in the waiting room will not be accepted to the origin. These users will always see a waiting room page that refreshes automatically. The valid queueing methods are:
               1. `fifo` **(default)**: First-In-First-Out queue where customers gain access in the order they arrived.
               2. `random`: Random queue where customers gain access randomly, regardless of arrival time.
               3. `passthrough`: Users will pass directly through the waiting room and into the origin website. As a result, any configured limits will not be respected while this is enabled. This method can be used as an alternative to disabling a waiting room (with `suspended`) so that analytics are still reported. This can be used if you wish to allow all traffic normally, but want to restrict traffic during a waiting room event, or vice versa.
               4. `reject`: Users will be immediately rejected from the waiting room. As a result, no users will reach the origin website while this is enabled. This can be used if you wish to reject all traffic while performing maintenance, block traffic during a specified period of time (an event), or block traffic while events are not occurring. Consider a waiting room used for vaccine distribution that only allows traffic during sign-up events, and otherwise blocks all traffic. For this case, the waiting room uses `reject`, and its events override this with `fifo`, `random`, or `passthrough`. When this queueing method is enabled and neither `queueAll` is enabled nor an event is prequeueing, the waiting room page **will not refresh automatically**.
               Available values: "fifo", "random", "passthrough", "reject".
        :param pulumi.Input[_builtins.int] queueing_status_code: HTTP status code returned to a user while in the queue.
               Available values: 200, 202, 429.
        :param pulumi.Input[_builtins.int] session_duration: Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the route. If a user is not seen by Cloudflare again in that time period, they will be treated as a new user that visits the route.
        :param pulumi.Input[_builtins.bool] suspended: Suspends or allows traffic going to the waiting room. If set to `true`, the traffic will not go to the waiting room.
        :param pulumi.Input[_builtins.int] total_active_users: Sets the total number of active user sessions on the route at a point in time. A route is a combination of host and path on which a waiting room is available. This value is used as a baseline for the total number of active user sessions on the route. It is possible to have a situation where there are more or less active users sessions on the route based on the traffic patterns at that time around the world.
        :param pulumi.Input[_builtins.str] turnstile_action: Which action to take when a bot is detected using Turnstile. `log` will
               have no impact on queueing behavior, simply keeping track of how many
               bots are detected in Waiting Room Analytics. `infinite_queue` will send
               bots to a false queueing state, where they will never reach your
               origin. `infinite_queue` requires Advanced Waiting Room.
               Available values: "log", "infinite_queue".
        :param pulumi.Input[_builtins.str] turnstile_mode: Which Turnstile widget type to use for detecting bot traffic. See
               [the Turnstile documentation](https://developers.cloudflare.com/turnstile/concepts/widget/#widget-types)
               for the definitions of these widget types. Set to `off` to disable the
               Turnstile integration entirely. Setting this to anything other than
               `off` or `invisible` requires Advanced Waiting Room.
               Available values: "off", "invisible", "visible_non_interactive", "visible_managed".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        if additional_routes is not None:
            pulumi.set(__self__, "additional_routes", additional_routes)
        if cookie_attributes is not None:
            pulumi.set(__self__, "cookie_attributes", cookie_attributes)
        if cookie_suffix is not None:
            pulumi.set(__self__, "cookie_suffix", cookie_suffix)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if custom_page_html is not None:
            pulumi.set(__self__, "custom_page_html", custom_page_html)
        if default_template_language is not None:
            pulumi.set(__self__, "default_template_language", default_template_language)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_session_renewal is not None:
            pulumi.set(__self__, "disable_session_renewal", disable_session_renewal)
        if enabled_origin_commands is not None:
            pulumi.set(__self__, "enabled_origin_commands", enabled_origin_commands)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if json_response_enabled is not None:
            pulumi.set(__self__, "json_response_enabled", json_response_enabled)
        if modified_on is not None:
            pulumi.set(__self__, "modified_on", modified_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_users_per_minute is not None:
            pulumi.set(__self__, "new_users_per_minute", new_users_per_minute)
        if next_event_prequeue_start_time is not None:
            pulumi.set(__self__, "next_event_prequeue_start_time", next_event_prequeue_start_time)
        if next_event_start_time is not None:
            pulumi.set(__self__, "next_event_start_time", next_event_start_time)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if queue_all is not None:
            pulumi.set(__self__, "queue_all", queue_all)
        if queueing_method is not None:
            pulumi.set(__self__, "queueing_method", queueing_method)
        if queueing_status_code is not None:
            pulumi.set(__self__, "queueing_status_code", queueing_status_code)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if total_active_users is not None:
            pulumi.set(__self__, "total_active_users", total_active_users)
        if turnstile_action is not None:
            pulumi.set(__self__, "turnstile_action", turnstile_action)
        if turnstile_mode is not None:
            pulumi.set(__self__, "turnstile_mode", turnstile_mode)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="additionalRoutes")
    def additional_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]]]:
        """
        Only available for the Waiting Room Advanced subscription. Additional hostname and path combinations to which this waiting room will be applied. There is an implied wildcard at the end of the path. The hostname and path combination must be unique to this and all other waiting rooms.
        """
        return pulumi.get(self, "additional_routes")

    @additional_routes.setter
    def additional_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WaitingRoomAdditionalRouteArgs']]]]):
        pulumi.set(self, "additional_routes", value)

    @_builtins.property
    @pulumi.getter(name="cookieAttributes")
    def cookie_attributes(self) -> Optional[pulumi.Input['WaitingRoomCookieAttributesArgs']]:
        """
        Configures cookie attributes for the waiting room cookie. This encrypted cookie stores a user's status in the waiting room, such as queue position.
        """
        return pulumi.get(self, "cookie_attributes")

    @cookie_attributes.setter
    def cookie_attributes(self, value: Optional[pulumi.Input['WaitingRoomCookieAttributesArgs']]):
        pulumi.set(self, "cookie_attributes", value)

    @_builtins.property
    @pulumi.getter(name="cookieSuffix")
    def cookie_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Appends a '_' + a custom suffix to the end of Cloudflare Waiting Room's cookie name(_*cf*waitingroom). If `cookie_suffix` is "abcd", the cookie name will be `__cf_waitingroom_abcd`. This field is required if using `additional_routes`.
        """
        return pulumi.get(self, "cookie_suffix")

    @cookie_suffix.setter
    def cookie_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cookie_suffix", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only available for the Waiting Room Advanced subscription. This is a template html file that will be rendered at the edge. If no custom*page*html is provided, the default waiting room will be used. The template is based on mustache ( https://mustache.github.io/ ). There are several variables that are evaluated by the Cloudflare edge:
        """
        return pulumi.get(self, "custom_page_html")

    @custom_page_html.setter
    def custom_page_html(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_page_html", value)

    @_builtins.property
    @pulumi.getter(name="defaultTemplateLanguage")
    def default_template_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The language of the default page template. If no default_template_language is provided, then `en-US` (English) will be used.
        Available values: "en-US", "es-ES", "de-DE", "fr-FR", "it-IT", "ja-JP", "ko-KR", "pt-BR", "zh-CN", "zh-TW", "nl-NL", "pl-PL", "id-ID", "tr-TR", "ar-EG", "ru-RU", "fa-IR", "bg-BG", "hr-HR", "cs-CZ", "da-DK", "fi-FI", "lt-LT", "ms-MY", "nb-NO", "ro-RO", "el-GR", "he-IL", "hi-IN", "hu-HU", "sr-BA", "sk-SK", "sl-SI", "sv-SE", "tl-PH", "th-TH", "uk-UA", "vi-VN".
        """
        return pulumi.get(self, "default_template_language")

    @default_template_language.setter
    def default_template_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_template_language", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A note that you can use to add more details about the waiting room.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disableSessionRenewal")
    def disable_session_renewal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Only available for the Waiting Room Advanced subscription. Disables automatic renewal of session cookies. If `true`, an accepted user will have session_duration minutes to browse the site. After that, they will have to go through the waiting room again. If `false`, a user's session cookie will be automatically renewed on every request.
        """
        return pulumi.get(self, "disable_session_renewal")

    @disable_session_renewal.setter
    def disable_session_renewal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_session_renewal", value)

    @_builtins.property
    @pulumi.getter(name="enabledOriginCommands")
    def enabled_origin_commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of enabled origin commands.
        """
        return pulumi.get(self, "enabled_origin_commands")

    @enabled_origin_commands.setter
    def enabled_origin_commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_origin_commands", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host name to which the waiting room will be applied (no wildcards). Please do not include the scheme (http:// or https://). The host and path combination must be unique.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="jsonResponseEnabled")
    def json_response_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Only available for the Waiting Room Advanced subscription. If `true`, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object with information on the user's status in the waiting room as opposed to the configured static HTML page. This JSON response object has one property `cfWaitingRoom` which is an object containing the following fields:
        1. `inWaitingRoom`: Boolean indicating if the user is in the waiting room (always **true**).
        2. `waitTimeKnown`: Boolean indicating if the current estimated wait times are accurate. If **false**, they are not available.
        3. `waitTime`: Valid only when `waitTimeKnown` is **true**. Integer indicating the current estimated time in minutes the user will wait in the waiting room. When `queueingMethod` is **random**, this is set to `waitTime50Percentile`.
        4. `waitTime25Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 25% of users that gain entry the fastest (25th percentile).
        5. `waitTime50Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 50% of users that gain entry the fastest (50th percentile). In other words, half of the queued users are expected to let into the origin website before `waitTime50Percentile` and half are expected to be let in after it.
        6. `waitTime75Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 75% of users that gain entry the fastest (75th percentile).
        7. `waitTimeFormatted`: String displaying the `waitTime` formatted in English for users. If `waitTimeKnown` is **false**, `waitTimeFormatted` will display **unavailable**.
        8. `queueIsFull`: Boolean indicating if the waiting room's queue is currently full and not accepting new users at the moment.
        9. `queueAll`: Boolean indicating if all users will be queued in the waiting room and no one will be let into the origin website.
        10. `lastUpdated`: String displaying the timestamp as an ISO 8601 string of the user's last attempt to leave the waiting room and be let into the origin website. The user is able to make another attempt after `refreshIntervalSeconds` past this time. If the user makes a request too soon, it will be ignored and `lastUpdated` will not change.
        11. `refreshIntervalSeconds`: Integer indicating the number of seconds after `lastUpdated` until the user is able to make another attempt to leave the waiting room and be let into the origin website. When the `queueingMethod` is `reject`, there is no specified refresh time —\\_it will always be **zero**.
        12. `queueingMethod`: The queueing method currently used by the waiting room. It is either **fifo**, **random**, **passthrough**, or **reject**.
        13. `isFIFOQueue`: Boolean indicating if the waiting room uses a FIFO (First-In-First-Out) queue.
        14. `isRandomQueue`: Boolean indicating if the waiting room uses a Random queue where users gain access randomly.
        15. `isPassthroughQueue`: Boolean indicating if the waiting room uses a passthrough queue. Keep in mind that when passthrough is enabled, this JSON response will only exist when `queueAll` is **true** or `isEventPrequeueing` is **true** because in all other cases requests will go directly to the origin.
        16. `isRejectQueue`: Boolean indicating if the waiting room uses a reject queue.
        17. `isEventActive`: Boolean indicating if an event is currently occurring. Events are able to change a waiting room's behavior during a specified period of time. For additional information, look at the event properties `prequeue_start_time`, `event_start_time`, and `event_end_time` in the documentation for creating waiting room events. Events are considered active between these start and end times, as well as during the prequeueing period if it exists.
        18. `isEventPrequeueing`: Valid only when `isEventActive` is **true**. Boolean indicating if an event is currently prequeueing users before it starts.
        19. `timeUntilEventStart`: Valid only when `isEventPrequeueing` is **true**. Integer indicating the number of minutes until the event starts.
        20. `timeUntilEventStartFormatted`: String displaying the `timeUntilEventStart` formatted in English for users. If `isEventPrequeueing` is **false**, `timeUntilEventStartFormatted` will display **unavailable**.
        21. `timeUntilEventEnd`: Valid only when `isEventActive` is **true**. Integer indicating the number of minutes until the event ends.
        22. `timeUntilEventEndFormatted`: String displaying the `timeUntilEventEnd` formatted in English for users. If `isEventActive` is **false**, `timeUntilEventEndFormatted` will display **unavailable**.
        23. `shuffleAtEventStart`: Valid only when `isEventActive` is **true**. Boolean indicating if the users in the prequeue are shuffled randomly when the event starts.
        24. `turnstile`: Empty when turnstile isn't enabled. String displaying an html tag to display the Turnstile widget. Please add the `{{{turnstile}}}` tag to the `custom_html` template to ensure the Turnstile widget appears.
        25. `infiniteQueue`: Boolean indicating whether the response is for a user in the infinite queue.

        An example cURL to a waiting room could be:

        	curl -X GET "https://example.com/waitingroom" \\
        		-H "Accept: application/json"

        If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **fifo** and no event is active could be:

        	{
        		"cfWaitingRoom": {
        			"inWaitingRoom": true,
        			"waitTimeKnown": true,
        			"waitTime": 10,
        			"waitTime25Percentile": 0,
        			"waitTime50Percentile": 0,
        			"waitTime75Percentile": 0,
        			"waitTimeFormatted": "10 minutes",
        			"queueIsFull": false,
        			"queueAll": false,
        			"lastUpdated": "2020-08-03T23:46:00.000Z",
        			"refreshIntervalSeconds": 20,
        			"queueingMethod": "fifo",
        			"isFIFOQueue": true,
        			"isRandomQueue": false,
        			"isPassthroughQueue": false,
        			"isRejectQueue": false,
        			"isEventActive": false,
        			"isEventPrequeueing": false,
        			"timeUntilEventStart": 0,
        			"timeUntilEventStartFormatted": "unavailable",
        			"timeUntilEventEnd": 0,
        			"timeUntilEventEndFormatted": "unavailable",
        			"shuffleAtEventStart": false
        		}
        	}

        If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **random** and an event is active could be:

        	{
        		"cfWaitingRoom": {
        			"inWaitingRoom": true,
        			"waitTimeKnown": true,
        			"waitTime": 10,
        			"waitTime25Percentile": 5,
        			"waitTime50Percentile": 10,
        			"waitTime75Percentile": 15,
        			"waitTimeFormatted": "5 minutes to 15 minutes",
        			"queueIsFull": false,
        			"queueAll": false,
        			"lastUpdated": "2020-08-03T23:46:00.000Z",
        			"refreshIntervalSeconds": 20,
        			"queueingMethod": "random",
        			"isFIFOQueue": false,
        			"isRandomQueue": true,
        			"isPassthroughQueue": false,
        			"isRejectQueue": false,
        			"isEventActive": true,
        			"isEventPrequeueing": false,
        			"timeUntilEventStart": 0,
        			"timeUntilEventStartFormatted": "unavailable",
        			"timeUntilEventEnd": 15,
        			"timeUntilEventEndFormatted": "15 minutes",
        			"shuffleAtEventStart": true
        		}
        	}
        """
        return pulumi.get(self, "json_response_enabled")

    @json_response_enabled.setter
    def json_response_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "json_response_enabled", value)

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "modified_on")

    @modified_on.setter
    def modified_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_on", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique name to identify the waiting room. Only alphanumeric characters, hyphens and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the number of new users that will be let into the route every minute. This value is used as baseline for the number of users that are let in per minute. So it is possible that there is a little more or little less traffic coming to the route based on the traffic patterns at that time around the world.
        """
        return pulumi.get(self, "new_users_per_minute")

    @new_users_per_minute.setter
    def new_users_per_minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "new_users_per_minute", value)

    @_builtins.property
    @pulumi.getter(name="nextEventPrequeueStartTime")
    def next_event_prequeue_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An ISO 8601 timestamp that marks when the next event will begin queueing.
        """
        return pulumi.get(self, "next_event_prequeue_start_time")

    @next_event_prequeue_start_time.setter
    def next_event_prequeue_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_event_prequeue_start_time", value)

    @_builtins.property
    @pulumi.getter(name="nextEventStartTime")
    def next_event_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An ISO 8601 timestamp that marks when the next event will start.
        """
        return pulumi.get(self, "next_event_start_time")

    @next_event_start_time.setter
    def next_event_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_event_start_time", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the path within the host to enable the waiting room on. The waiting room will be enabled for all subpaths as well. If there are two waiting rooms on the same subpath, the waiting room for the most specific path will be chosen. Wildcards and query parameters are not supported.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="queueAll")
    def queue_all(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If queue_all is `true`, all the traffic that is coming to a route will be sent to the waiting room. No new traffic can get to the route once this field is set and estimated time will become unavailable.
        """
        return pulumi.get(self, "queue_all")

    @queue_all.setter
    def queue_all(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "queue_all", value)

    @_builtins.property
    @pulumi.getter(name="queueingMethod")
    def queueing_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the queueing method used by the waiting room. Changing this parameter from the **default** queueing method is only available for the Waiting Room Advanced subscription. Regardless of the queueing method, if `queue_all` is enabled or an event is prequeueing, users in the waiting room will not be accepted to the origin. These users will always see a waiting room page that refreshes automatically. The valid queueing methods are:
        1. `fifo` **(default)**: First-In-First-Out queue where customers gain access in the order they arrived.
        2. `random`: Random queue where customers gain access randomly, regardless of arrival time.
        3. `passthrough`: Users will pass directly through the waiting room and into the origin website. As a result, any configured limits will not be respected while this is enabled. This method can be used as an alternative to disabling a waiting room (with `suspended`) so that analytics are still reported. This can be used if you wish to allow all traffic normally, but want to restrict traffic during a waiting room event, or vice versa.
        4. `reject`: Users will be immediately rejected from the waiting room. As a result, no users will reach the origin website while this is enabled. This can be used if you wish to reject all traffic while performing maintenance, block traffic during a specified period of time (an event), or block traffic while events are not occurring. Consider a waiting room used for vaccine distribution that only allows traffic during sign-up events, and otherwise blocks all traffic. For this case, the waiting room uses `reject`, and its events override this with `fifo`, `random`, or `passthrough`. When this queueing method is enabled and neither `queueAll` is enabled nor an event is prequeueing, the waiting room page **will not refresh automatically**.
        Available values: "fifo", "random", "passthrough", "reject".
        """
        return pulumi.get(self, "queueing_method")

    @queueing_method.setter
    def queueing_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queueing_method", value)

    @_builtins.property
    @pulumi.getter(name="queueingStatusCode")
    def queueing_status_code(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        HTTP status code returned to a user while in the queue.
        Available values: 200, 202, 429.
        """
        return pulumi.get(self, "queueing_status_code")

    @queueing_status_code.setter
    def queueing_status_code(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "queueing_status_code", value)

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the route. If a user is not seen by Cloudflare again in that time period, they will be treated as a new user that visits the route.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "session_duration", value)

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Suspends or allows traffic going to the waiting room. If set to `true`, the traffic will not go to the waiting room.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @_builtins.property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the total number of active user sessions on the route at a point in time. A route is a combination of host and path on which a waiting room is available. This value is used as a baseline for the total number of active user sessions on the route. It is possible to have a situation where there are more or less active users sessions on the route based on the traffic patterns at that time around the world.
        """
        return pulumi.get(self, "total_active_users")

    @total_active_users.setter
    def total_active_users(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_active_users", value)

    @_builtins.property
    @pulumi.getter(name="turnstileAction")
    def turnstile_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Which action to take when a bot is detected using Turnstile. `log` will
        have no impact on queueing behavior, simply keeping track of how many
        bots are detected in Waiting Room Analytics. `infinite_queue` will send
        bots to a false queueing state, where they will never reach your
        origin. `infinite_queue` requires Advanced Waiting Room.
        Available values: "log", "infinite_queue".
        """
        return pulumi.get(self, "turnstile_action")

    @turnstile_action.setter
    def turnstile_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "turnstile_action", value)

    @_builtins.property
    @pulumi.getter(name="turnstileMode")
    def turnstile_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Which Turnstile widget type to use for detecting bot traffic. See
        [the Turnstile documentation](https://developers.cloudflare.com/turnstile/concepts/widget/#widget-types)
        for the definitions of these widget types. Set to `off` to disable the
        Turnstile integration entirely. Setting this to anything other than
        `off` or `invisible` requires Advanced Waiting Room.
        Available values: "off", "invisible", "visible_non_interactive", "visible_managed".
        """
        return pulumi.get(self, "turnstile_mode")

    @turnstile_mode.setter
    def turnstile_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "turnstile_mode", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/waitingRoom:WaitingRoom")
class WaitingRoom(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WaitingRoomAdditionalRouteArgs', 'WaitingRoomAdditionalRouteArgsDict']]]]] = None,
                 cookie_attributes: Optional[pulumi.Input[Union['WaitingRoomCookieAttributesArgs', 'WaitingRoomCookieAttributesArgsDict']]] = None,
                 cookie_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_page_html: Optional[pulumi.Input[_builtins.str]] = None,
                 default_template_language: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_origin_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 json_response_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_all: Optional[pulumi.Input[_builtins.bool]] = None,
                 queueing_method: Optional[pulumi.Input[_builtins.str]] = None,
                 queueing_status_code: Optional[pulumi.Input[_builtins.int]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 total_active_users: Optional[pulumi.Input[_builtins.int]] = None,
                 turnstile_action: Optional[pulumi.Input[_builtins.str]] = None,
                 turnstile_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_waiting_room = cloudflare.WaitingRoom("example_waiting_room",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            host="shop.example.com",
            name="production_webinar",
            new_users_per_minute=200,
            total_active_users=200,
            additional_routes=[{
                "host": "shop2.example.com",
                "path": "/shop2/checkout",
            }],
            cookie_attributes={
                "samesite": "auto",
                "secure": "auto",
            },
            cookie_suffix="abcd",
            custom_page_html="{{#waitTimeKnown}} {{waitTime}} mins {{/waitTimeKnown}} {{^waitTimeKnown}} Queue all enabled {{/waitTimeKnown}}",
            default_template_language="es-ES",
            description="Production - DO NOT MODIFY",
            disable_session_renewal=False,
            enabled_origin_commands=["revoke"],
            json_response_enabled=False,
            path="/shop/checkout",
            queue_all=True,
            queueing_method="fifo",
            queueing_status_code=202,
            session_duration=1,
            suspended=True,
            turnstile_action="log",
            turnstile_mode="off")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/waitingRoom:WaitingRoom example '<zone_id>/<waiting_room_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WaitingRoomAdditionalRouteArgs', 'WaitingRoomAdditionalRouteArgsDict']]]] additional_routes: Only available for the Waiting Room Advanced subscription. Additional hostname and path combinations to which this waiting room will be applied. There is an implied wildcard at the end of the path. The hostname and path combination must be unique to this and all other waiting rooms.
        :param pulumi.Input[Union['WaitingRoomCookieAttributesArgs', 'WaitingRoomCookieAttributesArgsDict']] cookie_attributes: Configures cookie attributes for the waiting room cookie. This encrypted cookie stores a user's status in the waiting room, such as queue position.
        :param pulumi.Input[_builtins.str] cookie_suffix: Appends a '_' + a custom suffix to the end of Cloudflare Waiting Room's cookie name(_*cf*waitingroom). If `cookie_suffix` is "abcd", the cookie name will be `__cf_waitingroom_abcd`. This field is required if using `additional_routes`.
        :param pulumi.Input[_builtins.str] custom_page_html: Only available for the Waiting Room Advanced subscription. This is a template html file that will be rendered at the edge. If no custom*page*html is provided, the default waiting room will be used. The template is based on mustache ( https://mustache.github.io/ ). There are several variables that are evaluated by the Cloudflare edge:
        :param pulumi.Input[_builtins.str] default_template_language: The language of the default page template. If no default_template_language is provided, then `en-US` (English) will be used.
               Available values: "en-US", "es-ES", "de-DE", "fr-FR", "it-IT", "ja-JP", "ko-KR", "pt-BR", "zh-CN", "zh-TW", "nl-NL", "pl-PL", "id-ID", "tr-TR", "ar-EG", "ru-RU", "fa-IR", "bg-BG", "hr-HR", "cs-CZ", "da-DK", "fi-FI", "lt-LT", "ms-MY", "nb-NO", "ro-RO", "el-GR", "he-IL", "hi-IN", "hu-HU", "sr-BA", "sk-SK", "sl-SI", "sv-SE", "tl-PH", "th-TH", "uk-UA", "vi-VN".
        :param pulumi.Input[_builtins.str] description: A note that you can use to add more details about the waiting room.
        :param pulumi.Input[_builtins.bool] disable_session_renewal: Only available for the Waiting Room Advanced subscription. Disables automatic renewal of session cookies. If `true`, an accepted user will have session_duration minutes to browse the site. After that, they will have to go through the waiting room again. If `false`, a user's session cookie will be automatically renewed on every request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_origin_commands: A list of enabled origin commands.
        :param pulumi.Input[_builtins.str] host: The host name to which the waiting room will be applied (no wildcards). Please do not include the scheme (http:// or https://). The host and path combination must be unique.
        :param pulumi.Input[_builtins.bool] json_response_enabled: Only available for the Waiting Room Advanced subscription. If `true`, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object with information on the user's status in the waiting room as opposed to the configured static HTML page. This JSON response object has one property `cfWaitingRoom` which is an object containing the following fields:
               1. `inWaitingRoom`: Boolean indicating if the user is in the waiting room (always **true**).
               2. `waitTimeKnown`: Boolean indicating if the current estimated wait times are accurate. If **false**, they are not available.
               3. `waitTime`: Valid only when `waitTimeKnown` is **true**. Integer indicating the current estimated time in minutes the user will wait in the waiting room. When `queueingMethod` is **random**, this is set to `waitTime50Percentile`.
               4. `waitTime25Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 25% of users that gain entry the fastest (25th percentile).
               5. `waitTime50Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 50% of users that gain entry the fastest (50th percentile). In other words, half of the queued users are expected to let into the origin website before `waitTime50Percentile` and half are expected to be let in after it.
               6. `waitTime75Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 75% of users that gain entry the fastest (75th percentile).
               7. `waitTimeFormatted`: String displaying the `waitTime` formatted in English for users. If `waitTimeKnown` is **false**, `waitTimeFormatted` will display **unavailable**.
               8. `queueIsFull`: Boolean indicating if the waiting room's queue is currently full and not accepting new users at the moment.
               9. `queueAll`: Boolean indicating if all users will be queued in the waiting room and no one will be let into the origin website.
               10. `lastUpdated`: String displaying the timestamp as an ISO 8601 string of the user's last attempt to leave the waiting room and be let into the origin website. The user is able to make another attempt after `refreshIntervalSeconds` past this time. If the user makes a request too soon, it will be ignored and `lastUpdated` will not change.
               11. `refreshIntervalSeconds`: Integer indicating the number of seconds after `lastUpdated` until the user is able to make another attempt to leave the waiting room and be let into the origin website. When the `queueingMethod` is `reject`, there is no specified refresh time —\\_it will always be **zero**.
               12. `queueingMethod`: The queueing method currently used by the waiting room. It is either **fifo**, **random**, **passthrough**, or **reject**.
               13. `isFIFOQueue`: Boolean indicating if the waiting room uses a FIFO (First-In-First-Out) queue.
               14. `isRandomQueue`: Boolean indicating if the waiting room uses a Random queue where users gain access randomly.
               15. `isPassthroughQueue`: Boolean indicating if the waiting room uses a passthrough queue. Keep in mind that when passthrough is enabled, this JSON response will only exist when `queueAll` is **true** or `isEventPrequeueing` is **true** because in all other cases requests will go directly to the origin.
               16. `isRejectQueue`: Boolean indicating if the waiting room uses a reject queue.
               17. `isEventActive`: Boolean indicating if an event is currently occurring. Events are able to change a waiting room's behavior during a specified period of time. For additional information, look at the event properties `prequeue_start_time`, `event_start_time`, and `event_end_time` in the documentation for creating waiting room events. Events are considered active between these start and end times, as well as during the prequeueing period if it exists.
               18. `isEventPrequeueing`: Valid only when `isEventActive` is **true**. Boolean indicating if an event is currently prequeueing users before it starts.
               19. `timeUntilEventStart`: Valid only when `isEventPrequeueing` is **true**. Integer indicating the number of minutes until the event starts.
               20. `timeUntilEventStartFormatted`: String displaying the `timeUntilEventStart` formatted in English for users. If `isEventPrequeueing` is **false**, `timeUntilEventStartFormatted` will display **unavailable**.
               21. `timeUntilEventEnd`: Valid only when `isEventActive` is **true**. Integer indicating the number of minutes until the event ends.
               22. `timeUntilEventEndFormatted`: String displaying the `timeUntilEventEnd` formatted in English for users. If `isEventActive` is **false**, `timeUntilEventEndFormatted` will display **unavailable**.
               23. `shuffleAtEventStart`: Valid only when `isEventActive` is **true**. Boolean indicating if the users in the prequeue are shuffled randomly when the event starts.
               24. `turnstile`: Empty when turnstile isn't enabled. String displaying an html tag to display the Turnstile widget. Please add the `{{{turnstile}}}` tag to the `custom_html` template to ensure the Turnstile widget appears.
               25. `infiniteQueue`: Boolean indicating whether the response is for a user in the infinite queue.
               
               An example cURL to a waiting room could be:
               
               	curl -X GET "https://example.com/waitingroom" \\
               		-H "Accept: application/json"
               
               If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **fifo** and no event is active could be:
               
               	{
               		"cfWaitingRoom": {
               			"inWaitingRoom": true,
               			"waitTimeKnown": true,
               			"waitTime": 10,
               			"waitTime25Percentile": 0,
               			"waitTime50Percentile": 0,
               			"waitTime75Percentile": 0,
               			"waitTimeFormatted": "10 minutes",
               			"queueIsFull": false,
               			"queueAll": false,
               			"lastUpdated": "2020-08-03T23:46:00.000Z",
               			"refreshIntervalSeconds": 20,
               			"queueingMethod": "fifo",
               			"isFIFOQueue": true,
               			"isRandomQueue": false,
               			"isPassthroughQueue": false,
               			"isRejectQueue": false,
               			"isEventActive": false,
               			"isEventPrequeueing": false,
               			"timeUntilEventStart": 0,
               			"timeUntilEventStartFormatted": "unavailable",
               			"timeUntilEventEnd": 0,
               			"timeUntilEventEndFormatted": "unavailable",
               			"shuffleAtEventStart": false
               		}
               	}
               
               If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **random** and an event is active could be:
               
               	{
               		"cfWaitingRoom": {
               			"inWaitingRoom": true,
               			"waitTimeKnown": true,
               			"waitTime": 10,
               			"waitTime25Percentile": 5,
               			"waitTime50Percentile": 10,
               			"waitTime75Percentile": 15,
               			"waitTimeFormatted": "5 minutes to 15 minutes",
               			"queueIsFull": false,
               			"queueAll": false,
               			"lastUpdated": "2020-08-03T23:46:00.000Z",
               			"refreshIntervalSeconds": 20,
               			"queueingMethod": "random",
               			"isFIFOQueue": false,
               			"isRandomQueue": true,
               			"isPassthroughQueue": false,
               			"isRejectQueue": false,
               			"isEventActive": true,
               			"isEventPrequeueing": false,
               			"timeUntilEventStart": 0,
               			"timeUntilEventStartFormatted": "unavailable",
               			"timeUntilEventEnd": 15,
               			"timeUntilEventEndFormatted": "15 minutes",
               			"shuffleAtEventStart": true
               		}
               	}
        :param pulumi.Input[_builtins.str] name: A unique name to identify the waiting room. Only alphanumeric characters, hyphens and underscores are allowed.
        :param pulumi.Input[_builtins.int] new_users_per_minute: Sets the number of new users that will be let into the route every minute. This value is used as baseline for the number of users that are let in per minute. So it is possible that there is a little more or little less traffic coming to the route based on the traffic patterns at that time around the world.
        :param pulumi.Input[_builtins.str] path: Sets the path within the host to enable the waiting room on. The waiting room will be enabled for all subpaths as well. If there are two waiting rooms on the same subpath, the waiting room for the most specific path will be chosen. Wildcards and query parameters are not supported.
        :param pulumi.Input[_builtins.bool] queue_all: If queue_all is `true`, all the traffic that is coming to a route will be sent to the waiting room. No new traffic can get to the route once this field is set and estimated time will become unavailable.
        :param pulumi.Input[_builtins.str] queueing_method: Sets the queueing method used by the waiting room. Changing this parameter from the **default** queueing method is only available for the Waiting Room Advanced subscription. Regardless of the queueing method, if `queue_all` is enabled or an event is prequeueing, users in the waiting room will not be accepted to the origin. These users will always see a waiting room page that refreshes automatically. The valid queueing methods are:
               1. `fifo` **(default)**: First-In-First-Out queue where customers gain access in the order they arrived.
               2. `random`: Random queue where customers gain access randomly, regardless of arrival time.
               3. `passthrough`: Users will pass directly through the waiting room and into the origin website. As a result, any configured limits will not be respected while this is enabled. This method can be used as an alternative to disabling a waiting room (with `suspended`) so that analytics are still reported. This can be used if you wish to allow all traffic normally, but want to restrict traffic during a waiting room event, or vice versa.
               4. `reject`: Users will be immediately rejected from the waiting room. As a result, no users will reach the origin website while this is enabled. This can be used if you wish to reject all traffic while performing maintenance, block traffic during a specified period of time (an event), or block traffic while events are not occurring. Consider a waiting room used for vaccine distribution that only allows traffic during sign-up events, and otherwise blocks all traffic. For this case, the waiting room uses `reject`, and its events override this with `fifo`, `random`, or `passthrough`. When this queueing method is enabled and neither `queueAll` is enabled nor an event is prequeueing, the waiting room page **will not refresh automatically**.
               Available values: "fifo", "random", "passthrough", "reject".
        :param pulumi.Input[_builtins.int] queueing_status_code: HTTP status code returned to a user while in the queue.
               Available values: 200, 202, 429.
        :param pulumi.Input[_builtins.int] session_duration: Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the route. If a user is not seen by Cloudflare again in that time period, they will be treated as a new user that visits the route.
        :param pulumi.Input[_builtins.bool] suspended: Suspends or allows traffic going to the waiting room. If set to `true`, the traffic will not go to the waiting room.
        :param pulumi.Input[_builtins.int] total_active_users: Sets the total number of active user sessions on the route at a point in time. A route is a combination of host and path on which a waiting room is available. This value is used as a baseline for the total number of active user sessions on the route. It is possible to have a situation where there are more or less active users sessions on the route based on the traffic patterns at that time around the world.
        :param pulumi.Input[_builtins.str] turnstile_action: Which action to take when a bot is detected using Turnstile. `log` will
               have no impact on queueing behavior, simply keeping track of how many
               bots are detected in Waiting Room Analytics. `infinite_queue` will send
               bots to a false queueing state, where they will never reach your
               origin. `infinite_queue` requires Advanced Waiting Room.
               Available values: "log", "infinite_queue".
        :param pulumi.Input[_builtins.str] turnstile_mode: Which Turnstile widget type to use for detecting bot traffic. See
               [the Turnstile documentation](https://developers.cloudflare.com/turnstile/concepts/widget/#widget-types)
               for the definitions of these widget types. Set to `off` to disable the
               Turnstile integration entirely. Setting this to anything other than
               `off` or `invisible` requires Advanced Waiting Room.
               Available values: "off", "invisible", "visible_non_interactive", "visible_managed".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WaitingRoomArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_waiting_room = cloudflare.WaitingRoom("example_waiting_room",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            host="shop.example.com",
            name="production_webinar",
            new_users_per_minute=200,
            total_active_users=200,
            additional_routes=[{
                "host": "shop2.example.com",
                "path": "/shop2/checkout",
            }],
            cookie_attributes={
                "samesite": "auto",
                "secure": "auto",
            },
            cookie_suffix="abcd",
            custom_page_html="{{#waitTimeKnown}} {{waitTime}} mins {{/waitTimeKnown}} {{^waitTimeKnown}} Queue all enabled {{/waitTimeKnown}}",
            default_template_language="es-ES",
            description="Production - DO NOT MODIFY",
            disable_session_renewal=False,
            enabled_origin_commands=["revoke"],
            json_response_enabled=False,
            path="/shop/checkout",
            queue_all=True,
            queueing_method="fifo",
            queueing_status_code=202,
            session_duration=1,
            suspended=True,
            turnstile_action="log",
            turnstile_mode="off")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/waitingRoom:WaitingRoom example '<zone_id>/<waiting_room_id>'
        ```

        :param str resource_name: The name of the resource.
        :param WaitingRoomArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WaitingRoomArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WaitingRoomAdditionalRouteArgs', 'WaitingRoomAdditionalRouteArgsDict']]]]] = None,
                 cookie_attributes: Optional[pulumi.Input[Union['WaitingRoomCookieAttributesArgs', 'WaitingRoomCookieAttributesArgsDict']]] = None,
                 cookie_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_page_html: Optional[pulumi.Input[_builtins.str]] = None,
                 default_template_language: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_session_renewal: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_origin_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 json_response_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_users_per_minute: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_all: Optional[pulumi.Input[_builtins.bool]] = None,
                 queueing_method: Optional[pulumi.Input[_builtins.str]] = None,
                 queueing_status_code: Optional[pulumi.Input[_builtins.int]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 total_active_users: Optional[pulumi.Input[_builtins.int]] = None,
                 turnstile_action: Optional[pulumi.Input[_builtins.str]] = None,
                 turnstile_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WaitingRoomArgs.__new__(WaitingRoomArgs)

            __props__.__dict__["additional_routes"] = additional_routes
            __props__.__dict__["cookie_attributes"] = cookie_attributes
            __props__.__dict__["cookie_suffix"] = cookie_suffix
            __props__.__dict__["custom_page_html"] = custom_page_html
            __props__.__dict__["default_template_language"] = default_template_language
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_session_renewal"] = disable_session_renewal
            __props__.__dict__["enabled_origin_commands"] = enabled_origin_commands
            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            __props__.__dict__["json_response_enabled"] = json_response_enabled
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if new_users_per_minute is None and not opts.urn:
                raise TypeError("Missing required property 'new_users_per_minute'")
            __props__.__dict__["new_users_per_minute"] = new_users_per_minute
            __props__.__dict__["path"] = path
            __props__.__dict__["queue_all"] = queue_all
            __props__.__dict__["queueing_method"] = queueing_method
            __props__.__dict__["queueing_status_code"] = queueing_status_code
            __props__.__dict__["session_duration"] = session_duration
            __props__.__dict__["suspended"] = suspended
            if total_active_users is None and not opts.urn:
                raise TypeError("Missing required property 'total_active_users'")
            __props__.__dict__["total_active_users"] = total_active_users
            __props__.__dict__["turnstile_action"] = turnstile_action
            __props__.__dict__["turnstile_mode"] = turnstile_mode
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_on"] = None
            __props__.__dict__["modified_on"] = None
            __props__.__dict__["next_event_prequeue_start_time"] = None
            __props__.__dict__["next_event_start_time"] = None
        super(WaitingRoom, __self__).__init__(
            'cloudflare:index/waitingRoom:WaitingRoom',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WaitingRoomAdditionalRouteArgs', 'WaitingRoomAdditionalRouteArgsDict']]]]] = None,
            cookie_attributes: Optional[pulumi.Input[Union['WaitingRoomCookieAttributesArgs', 'WaitingRoomCookieAttributesArgsDict']]] = None,
            cookie_suffix: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            custom_page_html: Optional[pulumi.Input[_builtins.str]] = None,
            default_template_language: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disable_session_renewal: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled_origin_commands: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            json_response_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            modified_on: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            new_users_per_minute: Optional[pulumi.Input[_builtins.int]] = None,
            next_event_prequeue_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            next_event_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            queue_all: Optional[pulumi.Input[_builtins.bool]] = None,
            queueing_method: Optional[pulumi.Input[_builtins.str]] = None,
            queueing_status_code: Optional[pulumi.Input[_builtins.int]] = None,
            session_duration: Optional[pulumi.Input[_builtins.int]] = None,
            suspended: Optional[pulumi.Input[_builtins.bool]] = None,
            total_active_users: Optional[pulumi.Input[_builtins.int]] = None,
            turnstile_action: Optional[pulumi.Input[_builtins.str]] = None,
            turnstile_mode: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WaitingRoom':
        """
        Get an existing WaitingRoom resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WaitingRoomAdditionalRouteArgs', 'WaitingRoomAdditionalRouteArgsDict']]]] additional_routes: Only available for the Waiting Room Advanced subscription. Additional hostname and path combinations to which this waiting room will be applied. There is an implied wildcard at the end of the path. The hostname and path combination must be unique to this and all other waiting rooms.
        :param pulumi.Input[Union['WaitingRoomCookieAttributesArgs', 'WaitingRoomCookieAttributesArgsDict']] cookie_attributes: Configures cookie attributes for the waiting room cookie. This encrypted cookie stores a user's status in the waiting room, such as queue position.
        :param pulumi.Input[_builtins.str] cookie_suffix: Appends a '_' + a custom suffix to the end of Cloudflare Waiting Room's cookie name(_*cf*waitingroom). If `cookie_suffix` is "abcd", the cookie name will be `__cf_waitingroom_abcd`. This field is required if using `additional_routes`.
        :param pulumi.Input[_builtins.str] custom_page_html: Only available for the Waiting Room Advanced subscription. This is a template html file that will be rendered at the edge. If no custom*page*html is provided, the default waiting room will be used. The template is based on mustache ( https://mustache.github.io/ ). There are several variables that are evaluated by the Cloudflare edge:
        :param pulumi.Input[_builtins.str] default_template_language: The language of the default page template. If no default_template_language is provided, then `en-US` (English) will be used.
               Available values: "en-US", "es-ES", "de-DE", "fr-FR", "it-IT", "ja-JP", "ko-KR", "pt-BR", "zh-CN", "zh-TW", "nl-NL", "pl-PL", "id-ID", "tr-TR", "ar-EG", "ru-RU", "fa-IR", "bg-BG", "hr-HR", "cs-CZ", "da-DK", "fi-FI", "lt-LT", "ms-MY", "nb-NO", "ro-RO", "el-GR", "he-IL", "hi-IN", "hu-HU", "sr-BA", "sk-SK", "sl-SI", "sv-SE", "tl-PH", "th-TH", "uk-UA", "vi-VN".
        :param pulumi.Input[_builtins.str] description: A note that you can use to add more details about the waiting room.
        :param pulumi.Input[_builtins.bool] disable_session_renewal: Only available for the Waiting Room Advanced subscription. Disables automatic renewal of session cookies. If `true`, an accepted user will have session_duration minutes to browse the site. After that, they will have to go through the waiting room again. If `false`, a user's session cookie will be automatically renewed on every request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] enabled_origin_commands: A list of enabled origin commands.
        :param pulumi.Input[_builtins.str] host: The host name to which the waiting room will be applied (no wildcards). Please do not include the scheme (http:// or https://). The host and path combination must be unique.
        :param pulumi.Input[_builtins.bool] json_response_enabled: Only available for the Waiting Room Advanced subscription. If `true`, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object with information on the user's status in the waiting room as opposed to the configured static HTML page. This JSON response object has one property `cfWaitingRoom` which is an object containing the following fields:
               1. `inWaitingRoom`: Boolean indicating if the user is in the waiting room (always **true**).
               2. `waitTimeKnown`: Boolean indicating if the current estimated wait times are accurate. If **false**, they are not available.
               3. `waitTime`: Valid only when `waitTimeKnown` is **true**. Integer indicating the current estimated time in minutes the user will wait in the waiting room. When `queueingMethod` is **random**, this is set to `waitTime50Percentile`.
               4. `waitTime25Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 25% of users that gain entry the fastest (25th percentile).
               5. `waitTime50Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 50% of users that gain entry the fastest (50th percentile). In other words, half of the queued users are expected to let into the origin website before `waitTime50Percentile` and half are expected to be let in after it.
               6. `waitTime75Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 75% of users that gain entry the fastest (75th percentile).
               7. `waitTimeFormatted`: String displaying the `waitTime` formatted in English for users. If `waitTimeKnown` is **false**, `waitTimeFormatted` will display **unavailable**.
               8. `queueIsFull`: Boolean indicating if the waiting room's queue is currently full and not accepting new users at the moment.
               9. `queueAll`: Boolean indicating if all users will be queued in the waiting room and no one will be let into the origin website.
               10. `lastUpdated`: String displaying the timestamp as an ISO 8601 string of the user's last attempt to leave the waiting room and be let into the origin website. The user is able to make another attempt after `refreshIntervalSeconds` past this time. If the user makes a request too soon, it will be ignored and `lastUpdated` will not change.
               11. `refreshIntervalSeconds`: Integer indicating the number of seconds after `lastUpdated` until the user is able to make another attempt to leave the waiting room and be let into the origin website. When the `queueingMethod` is `reject`, there is no specified refresh time —\\_it will always be **zero**.
               12. `queueingMethod`: The queueing method currently used by the waiting room. It is either **fifo**, **random**, **passthrough**, or **reject**.
               13. `isFIFOQueue`: Boolean indicating if the waiting room uses a FIFO (First-In-First-Out) queue.
               14. `isRandomQueue`: Boolean indicating if the waiting room uses a Random queue where users gain access randomly.
               15. `isPassthroughQueue`: Boolean indicating if the waiting room uses a passthrough queue. Keep in mind that when passthrough is enabled, this JSON response will only exist when `queueAll` is **true** or `isEventPrequeueing` is **true** because in all other cases requests will go directly to the origin.
               16. `isRejectQueue`: Boolean indicating if the waiting room uses a reject queue.
               17. `isEventActive`: Boolean indicating if an event is currently occurring. Events are able to change a waiting room's behavior during a specified period of time. For additional information, look at the event properties `prequeue_start_time`, `event_start_time`, and `event_end_time` in the documentation for creating waiting room events. Events are considered active between these start and end times, as well as during the prequeueing period if it exists.
               18. `isEventPrequeueing`: Valid only when `isEventActive` is **true**. Boolean indicating if an event is currently prequeueing users before it starts.
               19. `timeUntilEventStart`: Valid only when `isEventPrequeueing` is **true**. Integer indicating the number of minutes until the event starts.
               20. `timeUntilEventStartFormatted`: String displaying the `timeUntilEventStart` formatted in English for users. If `isEventPrequeueing` is **false**, `timeUntilEventStartFormatted` will display **unavailable**.
               21. `timeUntilEventEnd`: Valid only when `isEventActive` is **true**. Integer indicating the number of minutes until the event ends.
               22. `timeUntilEventEndFormatted`: String displaying the `timeUntilEventEnd` formatted in English for users. If `isEventActive` is **false**, `timeUntilEventEndFormatted` will display **unavailable**.
               23. `shuffleAtEventStart`: Valid only when `isEventActive` is **true**. Boolean indicating if the users in the prequeue are shuffled randomly when the event starts.
               24. `turnstile`: Empty when turnstile isn't enabled. String displaying an html tag to display the Turnstile widget. Please add the `{{{turnstile}}}` tag to the `custom_html` template to ensure the Turnstile widget appears.
               25. `infiniteQueue`: Boolean indicating whether the response is for a user in the infinite queue.
               
               An example cURL to a waiting room could be:
               
               	curl -X GET "https://example.com/waitingroom" \\
               		-H "Accept: application/json"
               
               If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **fifo** and no event is active could be:
               
               	{
               		"cfWaitingRoom": {
               			"inWaitingRoom": true,
               			"waitTimeKnown": true,
               			"waitTime": 10,
               			"waitTime25Percentile": 0,
               			"waitTime50Percentile": 0,
               			"waitTime75Percentile": 0,
               			"waitTimeFormatted": "10 minutes",
               			"queueIsFull": false,
               			"queueAll": false,
               			"lastUpdated": "2020-08-03T23:46:00.000Z",
               			"refreshIntervalSeconds": 20,
               			"queueingMethod": "fifo",
               			"isFIFOQueue": true,
               			"isRandomQueue": false,
               			"isPassthroughQueue": false,
               			"isRejectQueue": false,
               			"isEventActive": false,
               			"isEventPrequeueing": false,
               			"timeUntilEventStart": 0,
               			"timeUntilEventStartFormatted": "unavailable",
               			"timeUntilEventEnd": 0,
               			"timeUntilEventEndFormatted": "unavailable",
               			"shuffleAtEventStart": false
               		}
               	}
               
               If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **random** and an event is active could be:
               
               	{
               		"cfWaitingRoom": {
               			"inWaitingRoom": true,
               			"waitTimeKnown": true,
               			"waitTime": 10,
               			"waitTime25Percentile": 5,
               			"waitTime50Percentile": 10,
               			"waitTime75Percentile": 15,
               			"waitTimeFormatted": "5 minutes to 15 minutes",
               			"queueIsFull": false,
               			"queueAll": false,
               			"lastUpdated": "2020-08-03T23:46:00.000Z",
               			"refreshIntervalSeconds": 20,
               			"queueingMethod": "random",
               			"isFIFOQueue": false,
               			"isRandomQueue": true,
               			"isPassthroughQueue": false,
               			"isRejectQueue": false,
               			"isEventActive": true,
               			"isEventPrequeueing": false,
               			"timeUntilEventStart": 0,
               			"timeUntilEventStartFormatted": "unavailable",
               			"timeUntilEventEnd": 15,
               			"timeUntilEventEndFormatted": "15 minutes",
               			"shuffleAtEventStart": true
               		}
               	}
        :param pulumi.Input[_builtins.str] name: A unique name to identify the waiting room. Only alphanumeric characters, hyphens and underscores are allowed.
        :param pulumi.Input[_builtins.int] new_users_per_minute: Sets the number of new users that will be let into the route every minute. This value is used as baseline for the number of users that are let in per minute. So it is possible that there is a little more or little less traffic coming to the route based on the traffic patterns at that time around the world.
        :param pulumi.Input[_builtins.str] next_event_prequeue_start_time: An ISO 8601 timestamp that marks when the next event will begin queueing.
        :param pulumi.Input[_builtins.str] next_event_start_time: An ISO 8601 timestamp that marks when the next event will start.
        :param pulumi.Input[_builtins.str] path: Sets the path within the host to enable the waiting room on. The waiting room will be enabled for all subpaths as well. If there are two waiting rooms on the same subpath, the waiting room for the most specific path will be chosen. Wildcards and query parameters are not supported.
        :param pulumi.Input[_builtins.bool] queue_all: If queue_all is `true`, all the traffic that is coming to a route will be sent to the waiting room. No new traffic can get to the route once this field is set and estimated time will become unavailable.
        :param pulumi.Input[_builtins.str] queueing_method: Sets the queueing method used by the waiting room. Changing this parameter from the **default** queueing method is only available for the Waiting Room Advanced subscription. Regardless of the queueing method, if `queue_all` is enabled or an event is prequeueing, users in the waiting room will not be accepted to the origin. These users will always see a waiting room page that refreshes automatically. The valid queueing methods are:
               1. `fifo` **(default)**: First-In-First-Out queue where customers gain access in the order they arrived.
               2. `random`: Random queue where customers gain access randomly, regardless of arrival time.
               3. `passthrough`: Users will pass directly through the waiting room and into the origin website. As a result, any configured limits will not be respected while this is enabled. This method can be used as an alternative to disabling a waiting room (with `suspended`) so that analytics are still reported. This can be used if you wish to allow all traffic normally, but want to restrict traffic during a waiting room event, or vice versa.
               4. `reject`: Users will be immediately rejected from the waiting room. As a result, no users will reach the origin website while this is enabled. This can be used if you wish to reject all traffic while performing maintenance, block traffic during a specified period of time (an event), or block traffic while events are not occurring. Consider a waiting room used for vaccine distribution that only allows traffic during sign-up events, and otherwise blocks all traffic. For this case, the waiting room uses `reject`, and its events override this with `fifo`, `random`, or `passthrough`. When this queueing method is enabled and neither `queueAll` is enabled nor an event is prequeueing, the waiting room page **will not refresh automatically**.
               Available values: "fifo", "random", "passthrough", "reject".
        :param pulumi.Input[_builtins.int] queueing_status_code: HTTP status code returned to a user while in the queue.
               Available values: 200, 202, 429.
        :param pulumi.Input[_builtins.int] session_duration: Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the route. If a user is not seen by Cloudflare again in that time period, they will be treated as a new user that visits the route.
        :param pulumi.Input[_builtins.bool] suspended: Suspends or allows traffic going to the waiting room. If set to `true`, the traffic will not go to the waiting room.
        :param pulumi.Input[_builtins.int] total_active_users: Sets the total number of active user sessions on the route at a point in time. A route is a combination of host and path on which a waiting room is available. This value is used as a baseline for the total number of active user sessions on the route. It is possible to have a situation where there are more or less active users sessions on the route based on the traffic patterns at that time around the world.
        :param pulumi.Input[_builtins.str] turnstile_action: Which action to take when a bot is detected using Turnstile. `log` will
               have no impact on queueing behavior, simply keeping track of how many
               bots are detected in Waiting Room Analytics. `infinite_queue` will send
               bots to a false queueing state, where they will never reach your
               origin. `infinite_queue` requires Advanced Waiting Room.
               Available values: "log", "infinite_queue".
        :param pulumi.Input[_builtins.str] turnstile_mode: Which Turnstile widget type to use for detecting bot traffic. See
               [the Turnstile documentation](https://developers.cloudflare.com/turnstile/concepts/widget/#widget-types)
               for the definitions of these widget types. Set to `off` to disable the
               Turnstile integration entirely. Setting this to anything other than
               `off` or `invisible` requires Advanced Waiting Room.
               Available values: "off", "invisible", "visible_non_interactive", "visible_managed".
        :param pulumi.Input[_builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WaitingRoomState.__new__(_WaitingRoomState)

        __props__.__dict__["additional_routes"] = additional_routes
        __props__.__dict__["cookie_attributes"] = cookie_attributes
        __props__.__dict__["cookie_suffix"] = cookie_suffix
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["custom_page_html"] = custom_page_html
        __props__.__dict__["default_template_language"] = default_template_language
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_session_renewal"] = disable_session_renewal
        __props__.__dict__["enabled_origin_commands"] = enabled_origin_commands
        __props__.__dict__["host"] = host
        __props__.__dict__["json_response_enabled"] = json_response_enabled
        __props__.__dict__["modified_on"] = modified_on
        __props__.__dict__["name"] = name
        __props__.__dict__["new_users_per_minute"] = new_users_per_minute
        __props__.__dict__["next_event_prequeue_start_time"] = next_event_prequeue_start_time
        __props__.__dict__["next_event_start_time"] = next_event_start_time
        __props__.__dict__["path"] = path
        __props__.__dict__["queue_all"] = queue_all
        __props__.__dict__["queueing_method"] = queueing_method
        __props__.__dict__["queueing_status_code"] = queueing_status_code
        __props__.__dict__["session_duration"] = session_duration
        __props__.__dict__["suspended"] = suspended
        __props__.__dict__["total_active_users"] = total_active_users
        __props__.__dict__["turnstile_action"] = turnstile_action
        __props__.__dict__["turnstile_mode"] = turnstile_mode
        __props__.__dict__["zone_id"] = zone_id
        return WaitingRoom(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalRoutes")
    def additional_routes(self) -> pulumi.Output[Sequence['outputs.WaitingRoomAdditionalRoute']]:
        """
        Only available for the Waiting Room Advanced subscription. Additional hostname and path combinations to which this waiting room will be applied. There is an implied wildcard at the end of the path. The hostname and path combination must be unique to this and all other waiting rooms.
        """
        return pulumi.get(self, "additional_routes")

    @_builtins.property
    @pulumi.getter(name="cookieAttributes")
    def cookie_attributes(self) -> pulumi.Output['outputs.WaitingRoomCookieAttributes']:
        """
        Configures cookie attributes for the waiting room cookie. This encrypted cookie stores a user's status in the waiting room, such as queue position.
        """
        return pulumi.get(self, "cookie_attributes")

    @_builtins.property
    @pulumi.getter(name="cookieSuffix")
    def cookie_suffix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Appends a '_' + a custom suffix to the end of Cloudflare Waiting Room's cookie name(_*cf*waitingroom). If `cookie_suffix` is "abcd", the cookie name will be `__cf_waitingroom_abcd`. This field is required if using `additional_routes`.
        """
        return pulumi.get(self, "cookie_suffix")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter(name="customPageHtml")
    def custom_page_html(self) -> pulumi.Output[_builtins.str]:
        """
        Only available for the Waiting Room Advanced subscription. This is a template html file that will be rendered at the edge. If no custom*page*html is provided, the default waiting room will be used. The template is based on mustache ( https://mustache.github.io/ ). There are several variables that are evaluated by the Cloudflare edge:
        """
        return pulumi.get(self, "custom_page_html")

    @_builtins.property
    @pulumi.getter(name="defaultTemplateLanguage")
    def default_template_language(self) -> pulumi.Output[_builtins.str]:
        """
        The language of the default page template. If no default_template_language is provided, then `en-US` (English) will be used.
        Available values: "en-US", "es-ES", "de-DE", "fr-FR", "it-IT", "ja-JP", "ko-KR", "pt-BR", "zh-CN", "zh-TW", "nl-NL", "pl-PL", "id-ID", "tr-TR", "ar-EG", "ru-RU", "fa-IR", "bg-BG", "hr-HR", "cs-CZ", "da-DK", "fi-FI", "lt-LT", "ms-MY", "nb-NO", "ro-RO", "el-GR", "he-IL", "hi-IN", "hu-HU", "sr-BA", "sk-SK", "sl-SI", "sv-SE", "tl-PH", "th-TH", "uk-UA", "vi-VN".
        """
        return pulumi.get(self, "default_template_language")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A note that you can use to add more details about the waiting room.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disableSessionRenewal")
    def disable_session_renewal(self) -> pulumi.Output[_builtins.bool]:
        """
        Only available for the Waiting Room Advanced subscription. Disables automatic renewal of session cookies. If `true`, an accepted user will have session_duration minutes to browse the site. After that, they will have to go through the waiting room again. If `false`, a user's session cookie will be automatically renewed on every request.
        """
        return pulumi.get(self, "disable_session_renewal")

    @_builtins.property
    @pulumi.getter(name="enabledOriginCommands")
    def enabled_origin_commands(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of enabled origin commands.
        """
        return pulumi.get(self, "enabled_origin_commands")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        The host name to which the waiting room will be applied (no wildcards). Please do not include the scheme (http:// or https://). The host and path combination must be unique.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="jsonResponseEnabled")
    def json_response_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Only available for the Waiting Room Advanced subscription. If `true`, requests to the waiting room with the header `Accept: application/json` will receive a JSON response object with information on the user's status in the waiting room as opposed to the configured static HTML page. This JSON response object has one property `cfWaitingRoom` which is an object containing the following fields:
        1. `inWaitingRoom`: Boolean indicating if the user is in the waiting room (always **true**).
        2. `waitTimeKnown`: Boolean indicating if the current estimated wait times are accurate. If **false**, they are not available.
        3. `waitTime`: Valid only when `waitTimeKnown` is **true**. Integer indicating the current estimated time in minutes the user will wait in the waiting room. When `queueingMethod` is **random**, this is set to `waitTime50Percentile`.
        4. `waitTime25Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 25% of users that gain entry the fastest (25th percentile).
        5. `waitTime50Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 50% of users that gain entry the fastest (50th percentile). In other words, half of the queued users are expected to let into the origin website before `waitTime50Percentile` and half are expected to be let in after it.
        6. `waitTime75Percentile`: Valid only when `queueingMethod` is **random** and `waitTimeKnown` is **true**. Integer indicating the current estimated maximum wait time for the 75% of users that gain entry the fastest (75th percentile).
        7. `waitTimeFormatted`: String displaying the `waitTime` formatted in English for users. If `waitTimeKnown` is **false**, `waitTimeFormatted` will display **unavailable**.
        8. `queueIsFull`: Boolean indicating if the waiting room's queue is currently full and not accepting new users at the moment.
        9. `queueAll`: Boolean indicating if all users will be queued in the waiting room and no one will be let into the origin website.
        10. `lastUpdated`: String displaying the timestamp as an ISO 8601 string of the user's last attempt to leave the waiting room and be let into the origin website. The user is able to make another attempt after `refreshIntervalSeconds` past this time. If the user makes a request too soon, it will be ignored and `lastUpdated` will not change.
        11. `refreshIntervalSeconds`: Integer indicating the number of seconds after `lastUpdated` until the user is able to make another attempt to leave the waiting room and be let into the origin website. When the `queueingMethod` is `reject`, there is no specified refresh time —\\_it will always be **zero**.
        12. `queueingMethod`: The queueing method currently used by the waiting room. It is either **fifo**, **random**, **passthrough**, or **reject**.
        13. `isFIFOQueue`: Boolean indicating if the waiting room uses a FIFO (First-In-First-Out) queue.
        14. `isRandomQueue`: Boolean indicating if the waiting room uses a Random queue where users gain access randomly.
        15. `isPassthroughQueue`: Boolean indicating if the waiting room uses a passthrough queue. Keep in mind that when passthrough is enabled, this JSON response will only exist when `queueAll` is **true** or `isEventPrequeueing` is **true** because in all other cases requests will go directly to the origin.
        16. `isRejectQueue`: Boolean indicating if the waiting room uses a reject queue.
        17. `isEventActive`: Boolean indicating if an event is currently occurring. Events are able to change a waiting room's behavior during a specified period of time. For additional information, look at the event properties `prequeue_start_time`, `event_start_time`, and `event_end_time` in the documentation for creating waiting room events. Events are considered active between these start and end times, as well as during the prequeueing period if it exists.
        18. `isEventPrequeueing`: Valid only when `isEventActive` is **true**. Boolean indicating if an event is currently prequeueing users before it starts.
        19. `timeUntilEventStart`: Valid only when `isEventPrequeueing` is **true**. Integer indicating the number of minutes until the event starts.
        20. `timeUntilEventStartFormatted`: String displaying the `timeUntilEventStart` formatted in English for users. If `isEventPrequeueing` is **false**, `timeUntilEventStartFormatted` will display **unavailable**.
        21. `timeUntilEventEnd`: Valid only when `isEventActive` is **true**. Integer indicating the number of minutes until the event ends.
        22. `timeUntilEventEndFormatted`: String displaying the `timeUntilEventEnd` formatted in English for users. If `isEventActive` is **false**, `timeUntilEventEndFormatted` will display **unavailable**.
        23. `shuffleAtEventStart`: Valid only when `isEventActive` is **true**. Boolean indicating if the users in the prequeue are shuffled randomly when the event starts.
        24. `turnstile`: Empty when turnstile isn't enabled. String displaying an html tag to display the Turnstile widget. Please add the `{{{turnstile}}}` tag to the `custom_html` template to ensure the Turnstile widget appears.
        25. `infiniteQueue`: Boolean indicating whether the response is for a user in the infinite queue.

        An example cURL to a waiting room could be:

        	curl -X GET "https://example.com/waitingroom" \\
        		-H "Accept: application/json"

        If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **fifo** and no event is active could be:

        	{
        		"cfWaitingRoom": {
        			"inWaitingRoom": true,
        			"waitTimeKnown": true,
        			"waitTime": 10,
        			"waitTime25Percentile": 0,
        			"waitTime50Percentile": 0,
        			"waitTime75Percentile": 0,
        			"waitTimeFormatted": "10 minutes",
        			"queueIsFull": false,
        			"queueAll": false,
        			"lastUpdated": "2020-08-03T23:46:00.000Z",
        			"refreshIntervalSeconds": 20,
        			"queueingMethod": "fifo",
        			"isFIFOQueue": true,
        			"isRandomQueue": false,
        			"isPassthroughQueue": false,
        			"isRejectQueue": false,
        			"isEventActive": false,
        			"isEventPrequeueing": false,
        			"timeUntilEventStart": 0,
        			"timeUntilEventStartFormatted": "unavailable",
        			"timeUntilEventEnd": 0,
        			"timeUntilEventEndFormatted": "unavailable",
        			"shuffleAtEventStart": false
        		}
        	}

        If `json_response_enabled` is **true** and the request hits the waiting room, an example JSON response when `queueingMethod` is **random** and an event is active could be:

        	{
        		"cfWaitingRoom": {
        			"inWaitingRoom": true,
        			"waitTimeKnown": true,
        			"waitTime": 10,
        			"waitTime25Percentile": 5,
        			"waitTime50Percentile": 10,
        			"waitTime75Percentile": 15,
        			"waitTimeFormatted": "5 minutes to 15 minutes",
        			"queueIsFull": false,
        			"queueAll": false,
        			"lastUpdated": "2020-08-03T23:46:00.000Z",
        			"refreshIntervalSeconds": 20,
        			"queueingMethod": "random",
        			"isFIFOQueue": false,
        			"isRandomQueue": true,
        			"isPassthroughQueue": false,
        			"isRejectQueue": false,
        			"isEventActive": true,
        			"isEventPrequeueing": false,
        			"timeUntilEventStart": 0,
        			"timeUntilEventStartFormatted": "unavailable",
        			"timeUntilEventEnd": 15,
        			"timeUntilEventEndFormatted": "15 minutes",
        			"shuffleAtEventStart": true
        		}
        	}
        """
        return pulumi.get(self, "json_response_enabled")

    @_builtins.property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "modified_on")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A unique name to identify the waiting room. Only alphanumeric characters, hyphens and underscores are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="newUsersPerMinute")
    def new_users_per_minute(self) -> pulumi.Output[_builtins.int]:
        """
        Sets the number of new users that will be let into the route every minute. This value is used as baseline for the number of users that are let in per minute. So it is possible that there is a little more or little less traffic coming to the route based on the traffic patterns at that time around the world.
        """
        return pulumi.get(self, "new_users_per_minute")

    @_builtins.property
    @pulumi.getter(name="nextEventPrequeueStartTime")
    def next_event_prequeue_start_time(self) -> pulumi.Output[_builtins.str]:
        """
        An ISO 8601 timestamp that marks when the next event will begin queueing.
        """
        return pulumi.get(self, "next_event_prequeue_start_time")

    @_builtins.property
    @pulumi.getter(name="nextEventStartTime")
    def next_event_start_time(self) -> pulumi.Output[_builtins.str]:
        """
        An ISO 8601 timestamp that marks when the next event will start.
        """
        return pulumi.get(self, "next_event_start_time")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        Sets the path within the host to enable the waiting room on. The waiting room will be enabled for all subpaths as well. If there are two waiting rooms on the same subpath, the waiting room for the most specific path will be chosen. Wildcards and query parameters are not supported.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="queueAll")
    def queue_all(self) -> pulumi.Output[_builtins.bool]:
        """
        If queue_all is `true`, all the traffic that is coming to a route will be sent to the waiting room. No new traffic can get to the route once this field is set and estimated time will become unavailable.
        """
        return pulumi.get(self, "queue_all")

    @_builtins.property
    @pulumi.getter(name="queueingMethod")
    def queueing_method(self) -> pulumi.Output[_builtins.str]:
        """
        Sets the queueing method used by the waiting room. Changing this parameter from the **default** queueing method is only available for the Waiting Room Advanced subscription. Regardless of the queueing method, if `queue_all` is enabled or an event is prequeueing, users in the waiting room will not be accepted to the origin. These users will always see a waiting room page that refreshes automatically. The valid queueing methods are:
        1. `fifo` **(default)**: First-In-First-Out queue where customers gain access in the order they arrived.
        2. `random`: Random queue where customers gain access randomly, regardless of arrival time.
        3. `passthrough`: Users will pass directly through the waiting room and into the origin website. As a result, any configured limits will not be respected while this is enabled. This method can be used as an alternative to disabling a waiting room (with `suspended`) so that analytics are still reported. This can be used if you wish to allow all traffic normally, but want to restrict traffic during a waiting room event, or vice versa.
        4. `reject`: Users will be immediately rejected from the waiting room. As a result, no users will reach the origin website while this is enabled. This can be used if you wish to reject all traffic while performing maintenance, block traffic during a specified period of time (an event), or block traffic while events are not occurring. Consider a waiting room used for vaccine distribution that only allows traffic during sign-up events, and otherwise blocks all traffic. For this case, the waiting room uses `reject`, and its events override this with `fifo`, `random`, or `passthrough`. When this queueing method is enabled and neither `queueAll` is enabled nor an event is prequeueing, the waiting room page **will not refresh automatically**.
        Available values: "fifo", "random", "passthrough", "reject".
        """
        return pulumi.get(self, "queueing_method")

    @_builtins.property
    @pulumi.getter(name="queueingStatusCode")
    def queueing_status_code(self) -> pulumi.Output[_builtins.int]:
        """
        HTTP status code returned to a user while in the queue.
        Available values: 200, 202, 429.
        """
        return pulumi.get(self, "queueing_status_code")

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> pulumi.Output[_builtins.int]:
        """
        Lifetime of a cookie (in minutes) set by Cloudflare for users who get access to the route. If a user is not seen by Cloudflare again in that time period, they will be treated as a new user that visits the route.
        """
        return pulumi.get(self, "session_duration")

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[_builtins.bool]:
        """
        Suspends or allows traffic going to the waiting room. If set to `true`, the traffic will not go to the waiting room.
        """
        return pulumi.get(self, "suspended")

    @_builtins.property
    @pulumi.getter(name="totalActiveUsers")
    def total_active_users(self) -> pulumi.Output[_builtins.int]:
        """
        Sets the total number of active user sessions on the route at a point in time. A route is a combination of host and path on which a waiting room is available. This value is used as a baseline for the total number of active user sessions on the route. It is possible to have a situation where there are more or less active users sessions on the route based on the traffic patterns at that time around the world.
        """
        return pulumi.get(self, "total_active_users")

    @_builtins.property
    @pulumi.getter(name="turnstileAction")
    def turnstile_action(self) -> pulumi.Output[_builtins.str]:
        """
        Which action to take when a bot is detected using Turnstile. `log` will
        have no impact on queueing behavior, simply keeping track of how many
        bots are detected in Waiting Room Analytics. `infinite_queue` will send
        bots to a false queueing state, where they will never reach your
        origin. `infinite_queue` requires Advanced Waiting Room.
        Available values: "log", "infinite_queue".
        """
        return pulumi.get(self, "turnstile_action")

    @_builtins.property
    @pulumi.getter(name="turnstileMode")
    def turnstile_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Which Turnstile widget type to use for detecting bot traffic. See
        [the Turnstile documentation](https://developers.cloudflare.com/turnstile/concepts/widget/#widget-types)
        for the definitions of these widget types. Set to `off` to disable the
        Turnstile integration entirely. Setting this to anything other than
        `off` or `invisible` requires Advanced Waiting Room.
        Available values: "off", "invisible", "visible_non_interactive", "visible_managed".
        """
        return pulumi.get(self, "turnstile_mode")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

