# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkerArgs', 'Worker']

@pulumi.input_type
class WorkerArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 logpush: Optional[pulumi.Input[_builtins.bool]] = None,
                 observability: Optional[pulumi.Input['WorkerObservabilityArgs']] = None,
                 subdomain: Optional[pulumi.Input['WorkerSubdomainArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tail_consumers: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerTailConsumerArgs']]]] = None):
        """
        The set of arguments for constructing a Worker resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] name: Name of the Worker.
        :param pulumi.Input[_builtins.bool] logpush: Whether logpush is enabled for the Worker.
        :param pulumi.Input['WorkerObservabilityArgs'] observability: Observability settings for the Worker.
        :param pulumi.Input['WorkerSubdomainArgs'] subdomain: Subdomain settings for the Worker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the Worker.
        :param pulumi.Input[Sequence[pulumi.Input['WorkerTailConsumerArgs']]] tail_consumers: Other Workers that should consume logs from the Worker.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        if logpush is not None:
            pulumi.set(__self__, "logpush", logpush)
        if observability is not None:
            pulumi.set(__self__, "observability", observability)
        if subdomain is not None:
            pulumi.set(__self__, "subdomain", subdomain)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tail_consumers is not None:
            pulumi.set(__self__, "tail_consumers", tail_consumers)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Worker.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def logpush(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether logpush is enabled for the Worker.
        """
        return pulumi.get(self, "logpush")

    @logpush.setter
    def logpush(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logpush", value)

    @_builtins.property
    @pulumi.getter
    def observability(self) -> Optional[pulumi.Input['WorkerObservabilityArgs']]:
        """
        Observability settings for the Worker.
        """
        return pulumi.get(self, "observability")

    @observability.setter
    def observability(self, value: Optional[pulumi.Input['WorkerObservabilityArgs']]):
        pulumi.set(self, "observability", value)

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> Optional[pulumi.Input['WorkerSubdomainArgs']]:
        """
        Subdomain settings for the Worker.
        """
        return pulumi.get(self, "subdomain")

    @subdomain.setter
    def subdomain(self, value: Optional[pulumi.Input['WorkerSubdomainArgs']]):
        pulumi.set(self, "subdomain", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags associated with the Worker.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tailConsumers")
    def tail_consumers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkerTailConsumerArgs']]]]:
        """
        Other Workers that should consume logs from the Worker.
        """
        return pulumi.get(self, "tail_consumers")

    @tail_consumers.setter
    def tail_consumers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerTailConsumerArgs']]]]):
        pulumi.set(self, "tail_consumers", value)


@pulumi.input_type
class _WorkerState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 logpush: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 observability: Optional[pulumi.Input['WorkerObservabilityArgs']] = None,
                 subdomain: Optional[pulumi.Input['WorkerSubdomainArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tail_consumers: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerTailConsumerArgs']]]] = None,
                 updated_on: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Worker resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] created_on: When the Worker was created.
        :param pulumi.Input[_builtins.bool] logpush: Whether logpush is enabled for the Worker.
        :param pulumi.Input[_builtins.str] name: Name of the Worker.
        :param pulumi.Input['WorkerObservabilityArgs'] observability: Observability settings for the Worker.
        :param pulumi.Input['WorkerSubdomainArgs'] subdomain: Subdomain settings for the Worker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the Worker.
        :param pulumi.Input[Sequence[pulumi.Input['WorkerTailConsumerArgs']]] tail_consumers: Other Workers that should consume logs from the Worker.
        :param pulumi.Input[_builtins.str] updated_on: When the Worker was most recently updated.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if logpush is not None:
            pulumi.set(__self__, "logpush", logpush)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if observability is not None:
            pulumi.set(__self__, "observability", observability)
        if subdomain is not None:
            pulumi.set(__self__, "subdomain", subdomain)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tail_consumers is not None:
            pulumi.set(__self__, "tail_consumers", tail_consumers)
        if updated_on is not None:
            pulumi.set(__self__, "updated_on", updated_on)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the Worker was created.
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter
    def logpush(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether logpush is enabled for the Worker.
        """
        return pulumi.get(self, "logpush")

    @logpush.setter
    def logpush(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logpush", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Worker.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def observability(self) -> Optional[pulumi.Input['WorkerObservabilityArgs']]:
        """
        Observability settings for the Worker.
        """
        return pulumi.get(self, "observability")

    @observability.setter
    def observability(self, value: Optional[pulumi.Input['WorkerObservabilityArgs']]):
        pulumi.set(self, "observability", value)

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> Optional[pulumi.Input['WorkerSubdomainArgs']]:
        """
        Subdomain settings for the Worker.
        """
        return pulumi.get(self, "subdomain")

    @subdomain.setter
    def subdomain(self, value: Optional[pulumi.Input['WorkerSubdomainArgs']]):
        pulumi.set(self, "subdomain", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags associated with the Worker.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tailConsumers")
    def tail_consumers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkerTailConsumerArgs']]]]:
        """
        Other Workers that should consume logs from the Worker.
        """
        return pulumi.get(self, "tail_consumers")

    @tail_consumers.setter
    def tail_consumers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerTailConsumerArgs']]]]):
        pulumi.set(self, "tail_consumers", value)

    @_builtins.property
    @pulumi.getter(name="updatedOn")
    def updated_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the Worker was most recently updated.
        """
        return pulumi.get(self, "updated_on")

    @updated_on.setter
    def updated_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_on", value)


@pulumi.type_token("cloudflare:index/worker:Worker")
class Worker(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logpush: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 observability: Optional[pulumi.Input[Union['WorkerObservabilityArgs', 'WorkerObservabilityArgsDict']]] = None,
                 subdomain: Optional[pulumi.Input[Union['WorkerSubdomainArgs', 'WorkerSubdomainArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tail_consumers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerTailConsumerArgs', 'WorkerTailConsumerArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/worker:Worker example '<account_id>/<worker_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.bool] logpush: Whether logpush is enabled for the Worker.
        :param pulumi.Input[_builtins.str] name: Name of the Worker.
        :param pulumi.Input[Union['WorkerObservabilityArgs', 'WorkerObservabilityArgsDict']] observability: Observability settings for the Worker.
        :param pulumi.Input[Union['WorkerSubdomainArgs', 'WorkerSubdomainArgsDict']] subdomain: Subdomain settings for the Worker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the Worker.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkerTailConsumerArgs', 'WorkerTailConsumerArgsDict']]]] tail_consumers: Other Workers that should consume logs from the Worker.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/worker:Worker example '<account_id>/<worker_id>'
        ```

        :param str resource_name: The name of the resource.
        :param WorkerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logpush: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 observability: Optional[pulumi.Input[Union['WorkerObservabilityArgs', 'WorkerObservabilityArgsDict']]] = None,
                 subdomain: Optional[pulumi.Input[Union['WorkerSubdomainArgs', 'WorkerSubdomainArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tail_consumers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerTailConsumerArgs', 'WorkerTailConsumerArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkerArgs.__new__(WorkerArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["logpush"] = logpush
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["observability"] = observability
            __props__.__dict__["subdomain"] = subdomain
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tail_consumers"] = tail_consumers
            __props__.__dict__["created_on"] = None
            __props__.__dict__["updated_on"] = None
        super(Worker, __self__).__init__(
            'cloudflare:index/worker:Worker',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            logpush: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            observability: Optional[pulumi.Input[Union['WorkerObservabilityArgs', 'WorkerObservabilityArgsDict']]] = None,
            subdomain: Optional[pulumi.Input[Union['WorkerSubdomainArgs', 'WorkerSubdomainArgsDict']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tail_consumers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerTailConsumerArgs', 'WorkerTailConsumerArgsDict']]]]] = None,
            updated_on: Optional[pulumi.Input[_builtins.str]] = None) -> 'Worker':
        """
        Get an existing Worker resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] created_on: When the Worker was created.
        :param pulumi.Input[_builtins.bool] logpush: Whether logpush is enabled for the Worker.
        :param pulumi.Input[_builtins.str] name: Name of the Worker.
        :param pulumi.Input[Union['WorkerObservabilityArgs', 'WorkerObservabilityArgsDict']] observability: Observability settings for the Worker.
        :param pulumi.Input[Union['WorkerSubdomainArgs', 'WorkerSubdomainArgsDict']] subdomain: Subdomain settings for the Worker.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags associated with the Worker.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkerTailConsumerArgs', 'WorkerTailConsumerArgsDict']]]] tail_consumers: Other Workers that should consume logs from the Worker.
        :param pulumi.Input[_builtins.str] updated_on: When the Worker was most recently updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkerState.__new__(_WorkerState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["logpush"] = logpush
        __props__.__dict__["name"] = name
        __props__.__dict__["observability"] = observability
        __props__.__dict__["subdomain"] = subdomain
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tail_consumers"] = tail_consumers
        __props__.__dict__["updated_on"] = updated_on
        return Worker(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the Worker was created.
        """
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter
    def logpush(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether logpush is enabled for the Worker.
        """
        return pulumi.get(self, "logpush")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Worker.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def observability(self) -> pulumi.Output['outputs.WorkerObservability']:
        """
        Observability settings for the Worker.
        """
        return pulumi.get(self, "observability")

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> pulumi.Output['outputs.WorkerSubdomain']:
        """
        Subdomain settings for the Worker.
        """
        return pulumi.get(self, "subdomain")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Tags associated with the Worker.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tailConsumers")
    def tail_consumers(self) -> pulumi.Output[Sequence['outputs.WorkerTailConsumer']]:
        """
        Other Workers that should consume logs from the Worker.
        """
        return pulumi.get(self, "tail_consumers")

    @_builtins.property
    @pulumi.getter(name="updatedOn")
    def updated_on(self) -> pulumi.Output[_builtins.str]:
        """
        When the Worker was most recently updated.
        """
        return pulumi.get(self, "updated_on")

