# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkersDeploymentArgs', 'WorkersDeployment']

@pulumi.input_type
class WorkersDeploymentArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 script_name: pulumi.Input[_builtins.str],
                 strategy: pulumi.Input[_builtins.str],
                 versions: pulumi.Input[Sequence[pulumi.Input['WorkersDeploymentVersionArgs']]],
                 annotations: Optional[pulumi.Input['WorkersDeploymentAnnotationsArgs']] = None):
        """
        The set of arguments for constructing a WorkersDeployment resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] script_name: Name of the script, used in URLs and route configuration.
        :param pulumi.Input[_builtins.str] strategy: Available values: "percentage".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "script_name", script_name)
        pulumi.set(__self__, "strategy", strategy)
        pulumi.set(__self__, "versions", versions)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the script, used in URLs and route configuration.
        """
        return pulumi.get(self, "script_name")

    @script_name.setter
    def script_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "script_name", value)

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> pulumi.Input[_builtins.str]:
        """
        Available values: "percentage".
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "strategy", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Input[Sequence[pulumi.Input['WorkersDeploymentVersionArgs']]]:
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: pulumi.Input[Sequence[pulumi.Input['WorkersDeploymentVersionArgs']]]):
        pulumi.set(self, "versions", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input['WorkersDeploymentAnnotationsArgs']]:
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input['WorkersDeploymentAnnotationsArgs']]):
        pulumi.set(self, "annotations", value)


@pulumi.input_type
class _WorkersDeploymentState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input['WorkersDeploymentAnnotationsArgs']] = None,
                 author_email: Optional[pulumi.Input[_builtins.str]] = None,
                 created_on: Optional[pulumi.Input[_builtins.str]] = None,
                 script_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input['WorkersDeploymentVersionArgs']]]] = None):
        """
        Input properties used for looking up and filtering WorkersDeployment resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] script_name: Name of the script, used in URLs and route configuration.
        :param pulumi.Input[_builtins.str] strategy: Available values: "percentage".
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if author_email is not None:
            pulumi.set(__self__, "author_email", author_email)
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if script_name is not None:
            pulumi.set(__self__, "script_name", script_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input['WorkersDeploymentAnnotationsArgs']]:
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input['WorkersDeploymentAnnotationsArgs']]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="authorEmail")
    def author_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "author_email")

    @author_email.setter
    def author_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "author_email", value)

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_on", value)

    @_builtins.property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the script, used in URLs and route configuration.
        """
        return pulumi.get(self, "script_name")

    @script_name.setter
    def script_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_name", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Available values: "percentage".
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "strategy", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkersDeploymentVersionArgs']]]]:
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkersDeploymentVersionArgs']]]]):
        pulumi.set(self, "versions", value)


@pulumi.type_token("cloudflare:index/workersDeployment:WorkersDeployment")
class WorkersDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Union['WorkersDeploymentAnnotationsArgs', 'WorkersDeploymentAnnotationsArgsDict']]] = None,
                 script_name: Optional[pulumi.Input[_builtins.str]] = None,
                 strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkersDeploymentVersionArgs', 'WorkersDeploymentVersionArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/workersDeployment:WorkersDeployment example '<account_id>/<script_name>/<deployment_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] script_name: Name of the script, used in URLs and route configuration.
        :param pulumi.Input[_builtins.str] strategy: Available values: "percentage".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkersDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/workersDeployment:WorkersDeployment example '<account_id>/<script_name>/<deployment_id>'
        ```

        :param str resource_name: The name of the resource.
        :param WorkersDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkersDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 annotations: Optional[pulumi.Input[Union['WorkersDeploymentAnnotationsArgs', 'WorkersDeploymentAnnotationsArgsDict']]] = None,
                 script_name: Optional[pulumi.Input[_builtins.str]] = None,
                 strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkersDeploymentVersionArgs', 'WorkersDeploymentVersionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkersDeploymentArgs.__new__(WorkersDeploymentArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["annotations"] = annotations
            if script_name is None and not opts.urn:
                raise TypeError("Missing required property 'script_name'")
            __props__.__dict__["script_name"] = script_name
            if strategy is None and not opts.urn:
                raise TypeError("Missing required property 'strategy'")
            __props__.__dict__["strategy"] = strategy
            if versions is None and not opts.urn:
                raise TypeError("Missing required property 'versions'")
            __props__.__dict__["versions"] = versions
            __props__.__dict__["author_email"] = None
            __props__.__dict__["created_on"] = None
            __props__.__dict__["source"] = None
        super(WorkersDeployment, __self__).__init__(
            'cloudflare:index/workersDeployment:WorkersDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            annotations: Optional[pulumi.Input[Union['WorkersDeploymentAnnotationsArgs', 'WorkersDeploymentAnnotationsArgsDict']]] = None,
            author_email: Optional[pulumi.Input[_builtins.str]] = None,
            created_on: Optional[pulumi.Input[_builtins.str]] = None,
            script_name: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            strategy: Optional[pulumi.Input[_builtins.str]] = None,
            versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkersDeploymentVersionArgs', 'WorkersDeploymentVersionArgsDict']]]]] = None) -> 'WorkersDeployment':
        """
        Get an existing WorkersDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] script_name: Name of the script, used in URLs and route configuration.
        :param pulumi.Input[_builtins.str] strategy: Available values: "percentage".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkersDeploymentState.__new__(_WorkersDeploymentState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["author_email"] = author_email
        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["script_name"] = script_name
        __props__.__dict__["source"] = source
        __props__.__dict__["strategy"] = strategy
        __props__.__dict__["versions"] = versions
        return WorkersDeployment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output['outputs.WorkersDeploymentAnnotations']:
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="authorEmail")
    def author_email(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "author_email")

    @_builtins.property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_on")

    @_builtins.property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the script, used in URLs and route configuration.
        """
        return pulumi.get(self, "script_name")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> pulumi.Output[_builtins.str]:
        """
        Available values: "percentage".
        """
        return pulumi.get(self, "strategy")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Output[Sequence['outputs.WorkersDeploymentVersion']]:
        return pulumi.get(self, "versions")

