# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WorkersKvArgs', 'WorkersKv']

@pulumi.input_type
class WorkersKvArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 key_name: pulumi.Input[_builtins.str],
                 namespace_id: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str],
                 metadata: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkersKv resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] key_name: A key's name. The name may be at most 512 bytes. All printable, non-whitespace characters are valid. Use percent-encoding to define key names as part of a URL.
        :param pulumi.Input[_builtins.str] namespace_id: Namespace identifier tag.
        :param pulumi.Input[_builtins.str] value: A byte sequence to be stored, up to 25 MiB in length.
        :param pulumi.Input[_builtins.str] metadata: Associates arbitrary JSON data with a key/value pair.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "namespace_id", namespace_id)
        pulumi.set(__self__, "value", value)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Input[_builtins.str]:
        """
        A key's name. The name may be at most 512 bytes. All printable, non-whitespace characters are valid. Use percent-encoding to define key names as part of a URL.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Input[_builtins.str]:
        """
        Namespace identifier tag.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace_id", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        A byte sequence to be stored, up to 25 MiB in length.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Associates arbitrary JSON data with a key/value pair.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class _WorkersKvState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkersKv resources.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] key_name: A key's name. The name may be at most 512 bytes. All printable, non-whitespace characters are valid. Use percent-encoding to define key names as part of a URL.
        :param pulumi.Input[_builtins.str] metadata: Associates arbitrary JSON data with a key/value pair.
        :param pulumi.Input[_builtins.str] namespace_id: Namespace identifier tag.
        :param pulumi.Input[_builtins.str] value: A byte sequence to be stored, up to 25 MiB in length.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A key's name. The name may be at most 512 bytes. All printable, non-whitespace characters are valid. Use percent-encoding to define key names as part of a URL.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Associates arbitrary JSON data with a key/value pair.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Namespace identifier tag.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_id", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A byte sequence to be stored, up to 25 MiB in length.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("cloudflare:index/workersKv:WorkersKv")
class WorkersKv(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_workers_kv = cloudflare.WorkersKv("example_workers_kv",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            namespace_id="0f2ac74b498b48028cb68387c421e279",
            key_name="My-Key",
            value="Some Value",
            metadata={})
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/workersKv:WorkersKv example '<account_id>/<namespace_id>/<key_name>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] key_name: A key's name. The name may be at most 512 bytes. All printable, non-whitespace characters are valid. Use percent-encoding to define key names as part of a URL.
        :param pulumi.Input[_builtins.str] metadata: Associates arbitrary JSON data with a key/value pair.
        :param pulumi.Input[_builtins.str] namespace_id: Namespace identifier tag.
        :param pulumi.Input[_builtins.str] value: A byte sequence to be stored, up to 25 MiB in length.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkersKvArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_workers_kv = cloudflare.WorkersKv("example_workers_kv",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            namespace_id="0f2ac74b498b48028cb68387c421e279",
            key_name="My-Key",
            value="Some Value",
            metadata={})
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/workersKv:WorkersKv example '<account_id>/<namespace_id>/<key_name>'
        ```

        :param str resource_name: The name of the resource.
        :param WorkersKvArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkersKvArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkersKvArgs.__new__(WorkersKvArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if key_name is None and not opts.urn:
                raise TypeError("Missing required property 'key_name'")
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["metadata"] = metadata
            if namespace_id is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_id'")
            __props__.__dict__["namespace_id"] = namespace_id
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(WorkersKv, __self__).__init__(
            'cloudflare:index/workersKv:WorkersKv',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_name: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkersKv':
        """
        Get an existing WorkersKv resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Identifier.
        :param pulumi.Input[_builtins.str] key_name: A key's name. The name may be at most 512 bytes. All printable, non-whitespace characters are valid. Use percent-encoding to define key names as part of a URL.
        :param pulumi.Input[_builtins.str] metadata: Associates arbitrary JSON data with a key/value pair.
        :param pulumi.Input[_builtins.str] namespace_id: Namespace identifier tag.
        :param pulumi.Input[_builtins.str] value: A byte sequence to be stored, up to 25 MiB in length.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkersKvState.__new__(_WorkersKvState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["namespace_id"] = namespace_id
        __props__.__dict__["value"] = value
        return WorkersKv(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[_builtins.str]:
        """
        A key's name. The name may be at most 512 bytes. All printable, non-whitespace characters are valid. Use percent-encoding to define key names as part of a URL.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Associates arbitrary JSON data with a key/value pair.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Output[_builtins.str]:
        """
        Namespace identifier tag.
        """
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.str]:
        """
        A byte sequence to be stored, up to 25 MiB in length.
        """
        return pulumi.get(self, "value")

