# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZeroTrustDlpCustomProfileArgs', 'ZeroTrustDlpCustomProfile']

@pulumi.input_type
class ZeroTrustDlpCustomProfileArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 ai_context_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_match_count: Optional[pulumi.Input[_builtins.int]] = None,
                 confidence_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 context_awareness: Optional[pulumi.Input['ZeroTrustDlpCustomProfileContextAwarenessArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileEntryArgs']]]] = None,
                 ocr_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 shared_entries: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileSharedEntryArgs']]]] = None):
        """
        The set of arguments for constructing a ZeroTrustDlpCustomProfile resource.
        :param pulumi.Input[_builtins.int] allowed_match_count: Related DLP policies will trigger when the match count exceeds the number set.
        :param pulumi.Input['ZeroTrustDlpCustomProfileContextAwarenessArgs'] context_awareness: Scan the context of predefined entries to only return matches surrounded by keywords.
        :param pulumi.Input[_builtins.str] description: The description of the profile.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileEntryArgs']]] entries: Custom entries from this profile.
               If this field is omitted, entries owned by this profile will not be changed.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileSharedEntryArgs']]] shared_entries: Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        if ai_context_enabled is not None:
            pulumi.set(__self__, "ai_context_enabled", ai_context_enabled)
        if allowed_match_count is not None:
            pulumi.set(__self__, "allowed_match_count", allowed_match_count)
        if confidence_threshold is not None:
            pulumi.set(__self__, "confidence_threshold", confidence_threshold)
        if context_awareness is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""context_awareness is deprecated: This attribute is deprecated.""")
        if context_awareness is not None:
            pulumi.set(__self__, "context_awareness", context_awareness)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entries is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""entries is deprecated: This attribute is deprecated.""")
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if ocr_enabled is not None:
            pulumi.set(__self__, "ocr_enabled", ocr_enabled)
        if shared_entries is not None:
            pulumi.set(__self__, "shared_entries", shared_entries)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="aiContextEnabled")
    def ai_context_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ai_context_enabled")

    @ai_context_enabled.setter
    def ai_context_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ai_context_enabled", value)

    @_builtins.property
    @pulumi.getter(name="allowedMatchCount")
    def allowed_match_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Related DLP policies will trigger when the match count exceeds the number set.
        """
        return pulumi.get(self, "allowed_match_count")

    @allowed_match_count.setter
    def allowed_match_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allowed_match_count", value)

    @_builtins.property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "confidence_threshold")

    @confidence_threshold.setter
    def confidence_threshold(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "confidence_threshold", value)

    @_builtins.property
    @pulumi.getter(name="contextAwareness")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def context_awareness(self) -> Optional[pulumi.Input['ZeroTrustDlpCustomProfileContextAwarenessArgs']]:
        """
        Scan the context of predefined entries to only return matches surrounded by keywords.
        """
        return pulumi.get(self, "context_awareness")

    @context_awareness.setter
    def context_awareness(self, value: Optional[pulumi.Input['ZeroTrustDlpCustomProfileContextAwarenessArgs']]):
        pulumi.set(self, "context_awareness", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileEntryArgs']]]]:
        """
        Custom entries from this profile.
        If this field is omitted, entries owned by this profile will not be changed.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileEntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter(name="ocrEnabled")
    def ocr_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ocr_enabled")

    @ocr_enabled.setter
    def ocr_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ocr_enabled", value)

    @_builtins.property
    @pulumi.getter(name="sharedEntries")
    def shared_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileSharedEntryArgs']]]]:
        """
        Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        """
        return pulumi.get(self, "shared_entries")

    @shared_entries.setter
    def shared_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileSharedEntryArgs']]]]):
        pulumi.set(self, "shared_entries", value)


@pulumi.input_type
class _ZeroTrustDlpCustomProfileState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ai_context_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_match_count: Optional[pulumi.Input[_builtins.int]] = None,
                 confidence_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 context_awareness: Optional[pulumi.Input['ZeroTrustDlpCustomProfileContextAwarenessArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileEntryArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ocr_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 open_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 shared_entries: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileSharedEntryArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustDlpCustomProfile resources.
        :param pulumi.Input[_builtins.int] allowed_match_count: Related DLP policies will trigger when the match count exceeds the number set.
        :param pulumi.Input['ZeroTrustDlpCustomProfileContextAwarenessArgs'] context_awareness: Scan the context of predefined entries to only return matches surrounded by keywords.
        :param pulumi.Input[_builtins.str] created_at: When the profile was created.
        :param pulumi.Input[_builtins.str] description: The description of the profile.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileEntryArgs']]] entries: Custom entries from this profile.
               If this field is omitted, entries owned by this profile will not be changed.
        :param pulumi.Input[_builtins.bool] open_access: Whether this profile can be accessed by anyone.
        :param pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileSharedEntryArgs']]] shared_entries: Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        :param pulumi.Input[_builtins.str] type: Available values: "custom", "predefined", "integration".
        :param pulumi.Input[_builtins.str] updated_at: When the profile was lasted updated.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if ai_context_enabled is not None:
            pulumi.set(__self__, "ai_context_enabled", ai_context_enabled)
        if allowed_match_count is not None:
            pulumi.set(__self__, "allowed_match_count", allowed_match_count)
        if confidence_threshold is not None:
            pulumi.set(__self__, "confidence_threshold", confidence_threshold)
        if context_awareness is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""context_awareness is deprecated: This attribute is deprecated.""")
        if context_awareness is not None:
            pulumi.set(__self__, "context_awareness", context_awareness)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entries is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""entries is deprecated: This attribute is deprecated.""")
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocr_enabled is not None:
            pulumi.set(__self__, "ocr_enabled", ocr_enabled)
        if open_access is not None:
            pulumi.set(__self__, "open_access", open_access)
        if shared_entries is not None:
            pulumi.set(__self__, "shared_entries", shared_entries)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="aiContextEnabled")
    def ai_context_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ai_context_enabled")

    @ai_context_enabled.setter
    def ai_context_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ai_context_enabled", value)

    @_builtins.property
    @pulumi.getter(name="allowedMatchCount")
    def allowed_match_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Related DLP policies will trigger when the match count exceeds the number set.
        """
        return pulumi.get(self, "allowed_match_count")

    @allowed_match_count.setter
    def allowed_match_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allowed_match_count", value)

    @_builtins.property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "confidence_threshold")

    @confidence_threshold.setter
    def confidence_threshold(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "confidence_threshold", value)

    @_builtins.property
    @pulumi.getter(name="contextAwareness")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def context_awareness(self) -> Optional[pulumi.Input['ZeroTrustDlpCustomProfileContextAwarenessArgs']]:
        """
        Scan the context of predefined entries to only return matches surrounded by keywords.
        """
        return pulumi.get(self, "context_awareness")

    @context_awareness.setter
    def context_awareness(self, value: Optional[pulumi.Input['ZeroTrustDlpCustomProfileContextAwarenessArgs']]):
        pulumi.set(self, "context_awareness", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the profile was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileEntryArgs']]]]:
        """
        Custom entries from this profile.
        If this field is omitted, entries owned by this profile will not be changed.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileEntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ocrEnabled")
    def ocr_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ocr_enabled")

    @ocr_enabled.setter
    def ocr_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ocr_enabled", value)

    @_builtins.property
    @pulumi.getter(name="openAccess")
    def open_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this profile can be accessed by anyone.
        """
        return pulumi.get(self, "open_access")

    @open_access.setter
    def open_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "open_access", value)

    @_builtins.property
    @pulumi.getter(name="sharedEntries")
    def shared_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileSharedEntryArgs']]]]:
        """
        Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        """
        return pulumi.get(self, "shared_entries")

    @shared_entries.setter
    def shared_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZeroTrustDlpCustomProfileSharedEntryArgs']]]]):
        pulumi.set(self, "shared_entries", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Available values: "custom", "predefined", "integration".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the profile was lasted updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("cloudflare:index/zeroTrustDlpCustomProfile:ZeroTrustDlpCustomProfile")
class ZeroTrustDlpCustomProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ai_context_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_match_count: Optional[pulumi.Input[_builtins.int]] = None,
                 confidence_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 context_awareness: Optional[pulumi.Input[Union['ZeroTrustDlpCustomProfileContextAwarenessArgs', 'ZeroTrustDlpCustomProfileContextAwarenessArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpCustomProfileEntryArgs', 'ZeroTrustDlpCustomProfileEntryArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ocr_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 shared_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpCustomProfileSharedEntryArgs', 'ZeroTrustDlpCustomProfileSharedEntryArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDlpCustomProfile:ZeroTrustDlpCustomProfile example '<account_id>/<profile_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] allowed_match_count: Related DLP policies will trigger when the match count exceeds the number set.
        :param pulumi.Input[Union['ZeroTrustDlpCustomProfileContextAwarenessArgs', 'ZeroTrustDlpCustomProfileContextAwarenessArgsDict']] context_awareness: Scan the context of predefined entries to only return matches surrounded by keywords.
        :param pulumi.Input[_builtins.str] description: The description of the profile.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpCustomProfileEntryArgs', 'ZeroTrustDlpCustomProfileEntryArgsDict']]]] entries: Custom entries from this profile.
               If this field is omitted, entries owned by this profile will not be changed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpCustomProfileSharedEntryArgs', 'ZeroTrustDlpCustomProfileSharedEntryArgsDict']]]] shared_entries: Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustDlpCustomProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/zeroTrustDlpCustomProfile:ZeroTrustDlpCustomProfile example '<account_id>/<profile_id>'
        ```

        :param str resource_name: The name of the resource.
        :param ZeroTrustDlpCustomProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustDlpCustomProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ai_context_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 allowed_match_count: Optional[pulumi.Input[_builtins.int]] = None,
                 confidence_threshold: Optional[pulumi.Input[_builtins.str]] = None,
                 context_awareness: Optional[pulumi.Input[Union['ZeroTrustDlpCustomProfileContextAwarenessArgs', 'ZeroTrustDlpCustomProfileContextAwarenessArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpCustomProfileEntryArgs', 'ZeroTrustDlpCustomProfileEntryArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ocr_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 shared_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpCustomProfileSharedEntryArgs', 'ZeroTrustDlpCustomProfileSharedEntryArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustDlpCustomProfileArgs.__new__(ZeroTrustDlpCustomProfileArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["ai_context_enabled"] = ai_context_enabled
            __props__.__dict__["allowed_match_count"] = allowed_match_count
            __props__.__dict__["confidence_threshold"] = confidence_threshold
            __props__.__dict__["context_awareness"] = context_awareness
            __props__.__dict__["description"] = description
            __props__.__dict__["entries"] = entries
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["ocr_enabled"] = ocr_enabled
            __props__.__dict__["shared_entries"] = shared_entries
            __props__.__dict__["created_at"] = None
            __props__.__dict__["open_access"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/dlpCustomProfile:DlpCustomProfile")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ZeroTrustDlpCustomProfile, __self__).__init__(
            'cloudflare:index/zeroTrustDlpCustomProfile:ZeroTrustDlpCustomProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            ai_context_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            allowed_match_count: Optional[pulumi.Input[_builtins.int]] = None,
            confidence_threshold: Optional[pulumi.Input[_builtins.str]] = None,
            context_awareness: Optional[pulumi.Input[Union['ZeroTrustDlpCustomProfileContextAwarenessArgs', 'ZeroTrustDlpCustomProfileContextAwarenessArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpCustomProfileEntryArgs', 'ZeroTrustDlpCustomProfileEntryArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ocr_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            open_access: Optional[pulumi.Input[_builtins.bool]] = None,
            shared_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpCustomProfileSharedEntryArgs', 'ZeroTrustDlpCustomProfileSharedEntryArgsDict']]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'ZeroTrustDlpCustomProfile':
        """
        Get an existing ZeroTrustDlpCustomProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] allowed_match_count: Related DLP policies will trigger when the match count exceeds the number set.
        :param pulumi.Input[Union['ZeroTrustDlpCustomProfileContextAwarenessArgs', 'ZeroTrustDlpCustomProfileContextAwarenessArgsDict']] context_awareness: Scan the context of predefined entries to only return matches surrounded by keywords.
        :param pulumi.Input[_builtins.str] created_at: When the profile was created.
        :param pulumi.Input[_builtins.str] description: The description of the profile.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpCustomProfileEntryArgs', 'ZeroTrustDlpCustomProfileEntryArgsDict']]]] entries: Custom entries from this profile.
               If this field is omitted, entries owned by this profile will not be changed.
        :param pulumi.Input[_builtins.bool] open_access: Whether this profile can be accessed by anyone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZeroTrustDlpCustomProfileSharedEntryArgs', 'ZeroTrustDlpCustomProfileSharedEntryArgsDict']]]] shared_entries: Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        :param pulumi.Input[_builtins.str] type: Available values: "custom", "predefined", "integration".
        :param pulumi.Input[_builtins.str] updated_at: When the profile was lasted updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustDlpCustomProfileState.__new__(_ZeroTrustDlpCustomProfileState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["ai_context_enabled"] = ai_context_enabled
        __props__.__dict__["allowed_match_count"] = allowed_match_count
        __props__.__dict__["confidence_threshold"] = confidence_threshold
        __props__.__dict__["context_awareness"] = context_awareness
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["entries"] = entries
        __props__.__dict__["name"] = name
        __props__.__dict__["ocr_enabled"] = ocr_enabled
        __props__.__dict__["open_access"] = open_access
        __props__.__dict__["shared_entries"] = shared_entries
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        return ZeroTrustDlpCustomProfile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="aiContextEnabled")
    def ai_context_enabled(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "ai_context_enabled")

    @_builtins.property
    @pulumi.getter(name="allowedMatchCount")
    def allowed_match_count(self) -> pulumi.Output[_builtins.int]:
        """
        Related DLP policies will trigger when the match count exceeds the number set.
        """
        return pulumi.get(self, "allowed_match_count")

    @_builtins.property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "confidence_threshold")

    @_builtins.property
    @pulumi.getter(name="contextAwareness")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def context_awareness(self) -> pulumi.Output[Optional['outputs.ZeroTrustDlpCustomProfileContextAwareness']]:
        """
        Scan the context of predefined entries to only return matches surrounded by keywords.
        """
        return pulumi.get(self, "context_awareness")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        When the profile was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the profile.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def entries(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustDlpCustomProfileEntry']]]:
        """
        Custom entries from this profile.
        If this field is omitted, entries owned by this profile will not be changed.
        """
        return pulumi.get(self, "entries")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ocrEnabled")
    def ocr_enabled(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "ocr_enabled")

    @_builtins.property
    @pulumi.getter(name="openAccess")
    def open_access(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this profile can be accessed by anyone.
        """
        return pulumi.get(self, "open_access")

    @_builtins.property
    @pulumi.getter(name="sharedEntries")
    def shared_entries(self) -> pulumi.Output[Optional[Sequence['outputs.ZeroTrustDlpCustomProfileSharedEntry']]]:
        """
        Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        """
        return pulumi.get(self, "shared_entries")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Available values: "custom", "predefined", "integration".
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        When the profile was lasted updated.
        """
        return pulumi.get(self, "updated_at")

