# mypy-boto3-application-autoscaling

[![PyPI - mypy-boto3-application-autoscaling](https://img.shields.io/pypi/v/mypy-boto3-application-autoscaling.svg?color=blue)](https://pypi.org/project/mypy-boto3-application-autoscaling)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-application-autoscaling.svg?color=blue)](https://pypi.org/project/mypy-boto3-application-autoscaling)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ApplicationAutoScaling 1.14.54](https://boto3.amazonaws.com/v1/documentation/api/1.14.54/reference/services/application-autoscaling.html#ApplicationAutoScaling) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.0.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-application-autoscaling](#mypy-boto3-application-autoscaling)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `ApplicationAutoScaling` service.

```bash
python -m pip install boto3-stubs[application-autoscaling]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[application-autoscaling]` in your environment: `python -m pip install 'boto3-stubs[application-autoscaling]'`

Both type checking and auto-complete should work for `ApplicationAutoScaling` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[application-autoscaling]` in your environment: `python -m pip install 'boto3-stubs[application-autoscaling]'`

Both type checking and auto-complete should work for `ApplicationAutoScaling` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[application-autoscaling]` in your environment: `python -m pip install 'boto3-stubs[application-autoscaling]'`
- Run `mypy` as usual

Type checking should work for `ApplicationAutoScaling` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[application-autoscaling]` in your environment: `python -m pip install 'boto3-stubs[application-autoscaling]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ApplicationAutoScaling` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ApplicationAutoScalingClient` provides annotations for `boto3.client("application-autoscaling")`.

```python
import boto3

from mypy_boto3_application_autoscaling import ApplicationAutoScalingClient

client: ApplicationAutoScalingClient = boto3.client("application-autoscaling")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ApplicationAutoScalingClient = session.client("application-autoscaling")
```

### Paginators annotations

`mypy_boto3_application_autoscaling.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_application_autoscaling import ApplicationAutoScalingClient
from mypy_boto3_application_autoscaling.paginator import (
    DescribeScalableTargetsPaginator,
    DescribeScalingActivitiesPaginator,
    DescribeScalingPoliciesPaginator,
    DescribeScheduledActionsPaginator,
)

client: ApplicationAutoScalingClient = boto3.client("application-autoscaling")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_scalable_targets_paginator: DescribeScalableTargetsPaginator = client.get_paginator("describe_scalable_targets")
describe_scaling_activities_paginator: DescribeScalingActivitiesPaginator = client.get_paginator("describe_scaling_activities")
describe_scaling_policies_paginator: DescribeScalingPoliciesPaginator = client.get_paginator("describe_scaling_policies")
describe_scheduled_actions_paginator: DescribeScheduledActionsPaginator = client.get_paginator("describe_scheduled_actions")
```







### Typed dictionations

`mypy_boto3_application_autoscaling.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_application_autoscaling.type_defs import (
    AlarmTypeDef,
    CustomizedMetricSpecificationTypeDef,
    DescribeScalableTargetsResponseTypeDef,
    DescribeScalingActivitiesResponseTypeDef,
    DescribeScalingPoliciesResponseTypeDef,
    DescribeScheduledActionsResponseTypeDef,
    MetricDimensionTypeDef,
    PaginatorConfigTypeDef,
    PredefinedMetricSpecificationTypeDef,
    PutScalingPolicyResponseTypeDef,
    ScalableTargetActionTypeDef,
    ScalableTargetTypeDef,
    ScalingActivityTypeDef,
    ScalingPolicyTypeDef,
    ScheduledActionTypeDef,
    StepAdjustmentTypeDef,
    StepScalingPolicyConfigurationTypeDef,
    SuspendedStateTypeDef,
    TargetTrackingScalingPolicyConfigurationTypeDef,
)


def get_structure() -> AlarmTypeDef:
    return {
      ...
    }
```
