"""
Main interface for application-autoscaling service.

Usage::

    ```python
    import boto3
    from mypy_boto3_application_autoscaling import (
        ApplicationAutoScalingClient,
        Client,
        DescribeScalableTargetsPaginator,
        DescribeScalingActivitiesPaginator,
        DescribeScalingPoliciesPaginator,
        DescribeScheduledActionsPaginator,
    )

    session = boto3.Session()

    client: ApplicationAutoScalingClient = boto3.client("application-autoscaling")
    session_client: ApplicationAutoScalingClient = session.client("application-autoscaling")

    describe_scalable_targets_paginator: DescribeScalableTargetsPaginator = client.get_paginator("describe_scalable_targets")
    describe_scaling_activities_paginator: DescribeScalingActivitiesPaginator = client.get_paginator("describe_scaling_activities")
    describe_scaling_policies_paginator: DescribeScalingPoliciesPaginator = client.get_paginator("describe_scaling_policies")
    describe_scheduled_actions_paginator: DescribeScheduledActionsPaginator = client.get_paginator("describe_scheduled_actions")
    ```
"""
from mypy_boto3_application_autoscaling.client import ApplicationAutoScalingClient
from mypy_boto3_application_autoscaling.paginator import (
    DescribeScalableTargetsPaginator,
    DescribeScalingActivitiesPaginator,
    DescribeScalingPoliciesPaginator,
    DescribeScheduledActionsPaginator,
)

Client = ApplicationAutoScalingClient

__all__ = (
    "ApplicationAutoScalingClient",
    "Client",
    "DescribeScalableTargetsPaginator",
    "DescribeScalingActivitiesPaginator",
    "DescribeScalingPoliciesPaginator",
    "DescribeScheduledActionsPaginator",
)
