"""create vfolder_invitations table

Revision ID: 26d0c387e764
Revises: f8a71c3bffa2
Create Date: 2018-07-04 14:57:46.517587

"""
from alembic import op
import sqlalchemy as sa
from ai.backend.manager.models.base import GUID


# revision identifiers, used by Alembic.
revision = '26d0c387e764'
down_revision = 'f8a71c3bffa2'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'vfolder_invitations',
        sa.Column('id', GUID(), server_default=sa.text('uuid_generate_v4()'), nullable=False),
        sa.Column('permission', sa.String(length=2), nullable=True),
        sa.Column('invitee', sa.String(length=256), nullable=False),
        sa.Column('vfolder', GUID(), nullable=False),
        sa.ForeignKeyConstraint(['vfolder'], ['vfolders.id'],
                                name=op.f('fk_vfolder_invitations_vfolder_vfolders'),
                                onupdate='CASCADE', ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_vfolder_invitations'))
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('vfolder_invitations')
    # ### end Alembic commands ###
