"""init

Revision ID: 5de06da3c2b5
Revises:
Create Date: 2017-06-08 15:08:23.166237

"""
from alembic import op
import sqlalchemy as sa
from ai.backend.manager.models.base import GUID


# revision identifiers, used by Alembic.
revision = '5de06da3c2b5'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    op.execute('CREATE EXTENSION IF NOT EXISTS "uuid-ossp";')
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'keypairs',
        sa.Column('user_id', sa.Integer(), nullable=True),
        sa.Column('access_key', sa.String(length=20), nullable=False),
        sa.Column('secret_key', sa.String(length=40), nullable=True),
        sa.Column('is_active', sa.Boolean(), nullable=True),
        sa.Column('billing_plan', sa.String(), nullable=True),
        sa.Column('created_at', sa.DateTime(timezone=True),
                  server_default=sa.text('now()'), nullable=True),
        sa.Column('last_used', sa.DateTime(timezone=True), nullable=True),
        sa.Column('concurrency_limit', sa.Integer(), nullable=True),
        sa.Column('concurrency_used', sa.Integer(), nullable=True),
        sa.Column('rate_limit', sa.Integer(), nullable=True),
        sa.Column('num_queries', sa.Integer(), server_default='0', nullable=True),
        sa.PrimaryKeyConstraint('access_key')
    )
    op.create_table(
        'kernels',
        sa.Column('sess_id', GUID(), server_default=sa.text('uuid_generate_v4()'), nullable=False),
        sa.Column('lang', sa.String(length=64), nullable=True),
        sa.Column('access_key', sa.String(length=20), nullable=True),
        sa.Column('created_at', sa.DateTime(timezone=True),
                  server_default=sa.text('now()'), nullable=True),
        sa.Column('terminated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('status', sa.String(), nullable=True),
        sa.Column('agent_id', sa.String(), nullable=True),
        sa.Column('container_id', sa.String(), nullable=True),
        sa.ForeignKeyConstraint(['access_key'], ['keypairs.access_key'], ),
        sa.PrimaryKeyConstraint('sess_id')
    )
    op.create_table(
        'usage',
        sa.Column('id', GUID(), server_default=sa.text('uuid_generate_v4()'), nullable=False),
        sa.Column('access_key_id', sa.String(length=20), nullable=True),
        sa.Column('kernel_type', sa.String(), nullable=True),
        sa.Column('kernel_id', sa.String(), nullable=True),
        sa.Column('started_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('terminated_at', sa.DateTime(timezone=True), nullable=True),
        sa.Column('cpu_used', sa.Integer(), server_default='0', nullable=True),
        sa.Column('mem_used', sa.Integer(), server_default='0', nullable=True),
        sa.Column('io_used', sa.Integer(), server_default='0', nullable=True),
        sa.Column('net_used', sa.Integer(), server_default='0', nullable=True),
        sa.ForeignKeyConstraint(['access_key_id'], ['keypairs.access_key'], ),
        sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('usage')
    op.drop_table('kernels')
    op.drop_table('keypairs')
    # ### end Alembic commands ###
