"""vfolder_invitation_state_to_enum_type

Revision ID: 6f5fe19894b7
Revises: 48ab2dfefba9
Create Date: 2019-09-28 21:05:55.409422

"""
from alembic import op
import sqlalchemy as sa
from ai.backend.manager.models import VFolderInvitationState
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '6f5fe19894b7'
down_revision = '48ab2dfefba9'
branch_labels = None
depends_on = None

vfinvs_choices = list(map(lambda v: v.value, VFolderInvitationState))
vfolderinvitationstate = postgresql.ENUM(
    *vfinvs_choices,
    name='vfolderinvitationstate',
)


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
    vfolderinvitationstate.create(op.get_bind())
    op.alter_column('vfolder_invitations', column_name='state',
                    type_=sa.Enum(*vfinvs_choices, name='vfolderinvitationstate'),
                    postgresql_using='state::vfolderinvitationstate')


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
    vfolderinvitationstate.create(op.get_bind())
    op.alter_column('vfolder_invitations', column_name='state',
                    type_=sa.String(length=10),
                    postgresql_using='state::text::vfolderinvitationstate')
    vfolderinvitationstate.drop(op.get_bind())
