from setuptools import setup, find_packages

setup(
    name="cleanframes",
    version="0.2.9",
    author="Abdullah Almutairi",
    author_email="abdullah@example.com",
    description="A professional tool for cleaning duplicate or near-duplicate image frames using perceptual hashing and embeddings.",
    long_description=open("README.md", encoding="utf-8").read(),
    long_description_content_type="text/markdown",
    url="https://github.com/abdullahalmutairi/cleanframes",
    packages=find_packages(),
    install_requires=[
        "torch",
        "torchvision",
        "transformers",
        "timm",
        "open_clip_torch",
        "scikit-learn",
        "tqdm",
        "pillow",
        "pandas",
        "numpy",
        "imagehash",
        "matplotlib"
    ],
    python_requires=">=3.8",
    license="MIT",
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
)