"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sentry_protos.snuba.v1.request_common_pb2
import sentry_protos.snuba.v1.trace_item_attribute_pb2
import sentry_protos.snuba.v1.trace_item_filter_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class TraceItemAttributeNamesRequest(google.protobuf.message.Message):
    """TraceItemAttributeNamesRequest is a request to the TraceItemAttributeNames endpoint,
    it returns the names of all queryable "TraceItemAttributes" that exist in the given projects,
    date range, and other filters.

    TraceItem are things like: span, error, log, replay
    TraceItemAttributes could be things like: sentry.duration,user_id cart_total, etc.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    META_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    VALUE_SUBSTRING_MATCH_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    INTERSECTING_ATTRIBUTES_FILTER_FIELD_NUMBER: builtins.int
    limit: builtins.int
    """maximum number of attributes to return"""
    offset: builtins.int
    """offset is deprecated, please use `page_token` instead"""
    type: sentry_protos.snuba.v1.trace_item_attribute_pb2.AttributeKey.Type.ValueType
    """The type of the attributes to return, must be specified,
    only TYPE_STRING and TYPE_FLOAT are supported, anything else will return empty response
    """
    value_substring_match: builtins.str
    """optionalfilter to only return attribute names that match the given substring"""
    @property
    def meta(self) -> sentry_protos.snuba.v1.request_common_pb2.RequestMeta:
        """metadata about the request
        this is where you specify organization, project, time range etc.
        """

    @property
    def page_token(self) -> sentry_protos.snuba.v1.request_common_pb2.PageToken:
        """optional, used for pagination, the next page token will be returned in the response"""

    @property
    def intersecting_attributes_filter(self) -> sentry_protos.snuba.v1.trace_item_filter_pb2.TraceItemFilter:
        """A filter to only get relevant attribute keys
        including this makes sure that only attribute keys are returned
        which *intersect* with the ones specified in the filter.
        This is a BEST-EFFORT operation. If no co-occurring keys are found within
        1 second, the endpoint returns without taking the intersecing attributes into account
        """

    def __init__(
        self,
        *,
        meta: sentry_protos.snuba.v1.request_common_pb2.RequestMeta | None = ...,
        limit: builtins.int = ...,
        offset: builtins.int = ...,
        type: sentry_protos.snuba.v1.trace_item_attribute_pb2.AttributeKey.Type.ValueType = ...,
        value_substring_match: builtins.str = ...,
        page_token: sentry_protos.snuba.v1.request_common_pb2.PageToken | None = ...,
        intersecting_attributes_filter: sentry_protos.snuba.v1.trace_item_filter_pb2.TraceItemFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["intersecting_attributes_filter", b"intersecting_attributes_filter", "meta", b"meta", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["intersecting_attributes_filter", b"intersecting_attributes_filter", "limit", b"limit", "meta", b"meta", "offset", b"offset", "page_token", b"page_token", "type", b"type", "value_substring_match", b"value_substring_match"]) -> None: ...

global___TraceItemAttributeNamesRequest = TraceItemAttributeNamesRequest

@typing.final
class TraceItemAttributeNamesResponse(google.protobuf.message.Message):
    """TraceItemAttributeNamesResponse is the response returned by the TraceItemAttributeNames endpoint.
    It is the counterpart to TraceItemAttributeNamesRequest.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Attribute(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        name: builtins.str
        type: sentry_protos.snuba.v1.trace_item_attribute_pb2.AttributeKey.Type.ValueType
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            type: sentry_protos.snuba.v1.trace_item_attribute_pb2.AttributeKey.Type.ValueType = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["name", b"name", "type", b"type"]) -> None: ...

    ATTRIBUTES_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    META_FIELD_NUMBER: builtins.int
    @property
    def attributes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___TraceItemAttributeNamesResponse.Attribute]:
        """all attributes that matched the filters in the request"""

    @property
    def page_token(self) -> sentry_protos.snuba.v1.request_common_pb2.PageToken:
        """page token for the next page of results"""

    @property
    def meta(self) -> sentry_protos.snuba.v1.request_common_pb2.ResponseMeta:
        """metadata about the response"""

    def __init__(
        self,
        *,
        attributes: collections.abc.Iterable[global___TraceItemAttributeNamesResponse.Attribute] | None = ...,
        page_token: sentry_protos.snuba.v1.request_common_pb2.PageToken | None = ...,
        meta: sentry_protos.snuba.v1.request_common_pb2.ResponseMeta | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["meta", b"meta", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["attributes", b"attributes", "meta", b"meta", "page_token", b"page_token"]) -> None: ...

global___TraceItemAttributeNamesResponse = TraceItemAttributeNamesResponse

@typing.final
class TraceItemAttributeValuesRequest(google.protobuf.message.Message):
    """TraceItemAttributeValuesRequest is a request to the TraceItemAttributeValues endpoint,
    it returns the set of all possible values for the given attribute key, across the given
    organization, project_id, timerange etc (specified in meta).

    This endpoint only supports string values, it does not make sense
    to get all the possible values of a numerical attribute
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    META_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    VALUE_SUBSTRING_MATCH_FIELD_NUMBER: builtins.int
    LIMIT_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    name: builtins.str
    """deprecated, please use the `key` field instead"""
    value_substring_match: builtins.str
    """a substring of the value being searched for,
    only values matching this substring will be returned.
    only strict substring supported, no regex
    """
    limit: builtins.int
    """max number of values to return"""
    @property
    def meta(self) -> sentry_protos.snuba.v1.request_common_pb2.RequestMeta:
        """metadata about the request
        this is where you specify organization, project, time range etc.
        """

    @property
    def key(self) -> sentry_protos.snuba.v1.trace_item_attribute_pb2.AttributeKey:
        """attribute you want the values of"""

    @property
    def page_token(self) -> sentry_protos.snuba.v1.request_common_pb2.PageToken:
        """optional, used for pagination, the next page token will be returned in the response"""

    def __init__(
        self,
        *,
        meta: sentry_protos.snuba.v1.request_common_pb2.RequestMeta | None = ...,
        key: sentry_protos.snuba.v1.trace_item_attribute_pb2.AttributeKey | None = ...,
        name: builtins.str = ...,
        value_substring_match: builtins.str = ...,
        limit: builtins.int = ...,
        page_token: sentry_protos.snuba.v1.request_common_pb2.PageToken | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["key", b"key", "meta", b"meta", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["key", b"key", "limit", b"limit", "meta", b"meta", "name", b"name", "page_token", b"page_token", "value_substring_match", b"value_substring_match"]) -> None: ...

global___TraceItemAttributeValuesRequest = TraceItemAttributeValuesRequest

@typing.final
class TraceItemAttributeValuesResponse(google.protobuf.message.Message):
    """TraceItemAttributeValuesResponse is a response from the TraceItemAttributeValues endpoint
    it is the counterpart to TraceItemAttributesRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUES_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    META_FIELD_NUMBER: builtins.int
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """all the values that matched the criteria specified in the request"""

    @property
    def page_token(self) -> sentry_protos.snuba.v1.request_common_pb2.PageToken:
        """page token for the next page of results"""

    @property
    def meta(self) -> sentry_protos.snuba.v1.request_common_pb2.ResponseMeta:
        """metadata about the response"""

    def __init__(
        self,
        *,
        values: collections.abc.Iterable[builtins.str] | None = ...,
        page_token: sentry_protos.snuba.v1.request_common_pb2.PageToken | None = ...,
        meta: sentry_protos.snuba.v1.request_common_pb2.ResponseMeta | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["meta", b"meta", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["meta", b"meta", "page_token", b"page_token", "values", b"values"]) -> None: ...

global___TraceItemAttributeValuesResponse = TraceItemAttributeValuesResponse
