<p align="center">
<img src="https://raw.githubusercontent.com/KissmeBro/rubigram-python/refs/heads/main/logo.png" alt="Rubigram Logo" width="180" />
</p>

# Rubigram
> A modern, asynchronous Python library for Rubika bot and client development

---

## Overview
Rubigram is a high-performance Python library for interacting with the Rubika API.
It provides a clean and Pythonic interface to build both Rubika bots and user clients,
allowing developers to manage messages, handle updates, and automate tasks efficiently.

---

## Features
- Fully asynchronous operations with `asyncio` and `aiohttp`
- Optional synchronous interface for simplicity in scripts and small projects
- Support for both bot and user client functionalities
- Modular and extensible design for custom features and integrations
- High-performance and optimized for concurrency
- Clear and intuitive API for messaging, chat management, updates handling, and automation

---

## Examples
- [example_one.py](https://github.com/KissmeBro/rubigram-python/blob/main/examples/example_one.py)
- [example_two.py](https://github.com/KissmeBro/rubigram-python/blob/main/examples/example_two.py)

---

## Installation
```bash
pip install rubigram-python
```