## Overview
WebScrapBook is an application that can host one or more directories, with
each host containing one or more scrapbooks.

A WebScrapBook host for a diretory `<root>` has 3 levels of configuration:

* default: written in the source code
* user: at `~/.config/wsb/config.ini` and `~/.wsbconfig`
* host: at `<root>/.wsb/config.ini`

with the latters overwriting the formers.

A config file can be generated using the command `wsb config`. Run
`wsb config --help` for more details.

Configs are loaded only at process starting, and a config change won't affect
an already running process. For example, a running WebScrapBook host needs
to be shut off and restarted to get new configs take effect.


## Configuration Format

A WebScrapBook config file is written in "ini" format, which looks like:

    # A "#" or ";" at line beginning starts a comment, causing the whole
    # line ignored when run. A comment can also be used to temporarily
    # disable a setting for testing or debugging purpose.

    # "[" and "]" define a section.
    [server]
    # A key-value pair separated by "=" or ":". Spaces around the separator
    # and the value are stripped. For example, "theme=default" is equivalent
    # to "theme  =    default  "
    theme = default

    # Use true/false, on/off, yes/no, or 1/0 for a boolean value.
    ssl_on = false

    # A section may be subsected using syntax [section "subsection"]. In such
    # case [section] also means [section ""].
    [auth "user1"]
    user = myuser1
    #...

    [auth "user2"]
    user = myuser2
    #...

For convenience, `key` of `[section]` is also denoted as `section.key`,
and `key` of `[section "subsection"]` is also denoted as
`section.subsection.key`.


## Available values


### `[app]` section

The `[app]` section defines the behavior of the WSGI application of the host.

The host can run with the built-in web server (as the `[server]` section says)
or with a specialized WSGI server, such as mod_wsgi, uWSGI, or Gunicorn, by
providing the `.wsb/app.py` script (which can be generated by `wsb config -ba`)
to it.


#### `name`

The name of the served website, which is used as the site title, the label of
the top level of breadcrumbs, etc.

(default: `WebScrapBook`)


#### `theme`

The theme name of the served website. A custom theme can be defined at
`<root>/.wsb/themes/<name>`. Run `wsb help themes` for more details.

(default: `default`)


#### `locale`

The locale code of web interface of the served website. It should follow
RFC 1766 format case insensitively and can use `-` or `_` as the tag separator.
The localized string will be searched from the theme or package in a
hierarchical way. For example, `zh_TW` will be looked up in `zh_TW`, `zh`, and
then `en` as the final fallback.

(default: )


#### `root`

The chrooted directory to host. Files outside this directory are not directly
accessible by the web app. It's an absolute path or relative to the real root
directory.

(default: `.`)


#### `index`

The index page for the WebScrapBook application. It is, for example, visited
when server starts and launches the local browser. This is a URL path under
the (ch)root path the application is served, without leading slash.

(default: )


#### `backup_dir`

The backup directory for the WebScrapBook application to save backup files at.
It's a directory path under the root, without leading or trailing slash.

(default: `.wsb/backup`)


#### `content_security_policy`

Whether to send response with a content security policy header, which restricts
AJAX and form actions for data pages to prevent a potential attack from a
malicious script. Currently only the value `strict` is used. Set this to empty
if you really need such features, but make sure that scripts and forms in the
captured pages are all safe!

(default: `strict`)


#### `allowed_x_for`

Number of values to trust for `X-Forwarded-For` header(s) when this app is
run behind a reverse proxy.

For example, if the app is served behind one reverse proxy that appends
`X-Forwarded-For` header, set this value to `1` and the last value will be
taken as the client address.

(default: `0`)


#### `allowed_x_proto`

Number of values to trust for `X-Forwarded-Proto` header(s) when this app is
run behind a reverse proxy.

By convention the header set by a reverse proxy is in an overwriting way.
In most cases this value can be set to `1` if a trusted reverse proxy sets it,
and `0` otherwise.

(default: `0`)


#### `allowed_x_host`

Number of values to trust for `X-Forwarded-Host` header(s) when this app is
run behind a reverse proxy.

See `allowed_x_proto` for convention of usage.

(default: `0`)


#### `allowed_x_port`

Number of values to trust for `X-Forwarded-Port` header(s) when this app is
run behind a reverse proxy.

See `allowed_x_proto` for convention of usage.

(default: `0`)


#### `allowed_x_prefix`

Number of values to trust for `X-Forwarded-Prefix` header(s) when this app is
run behind a reverse proxy.

See `allowed_x_proto` for convention of usage.

(default: `0`)


### `[book]` section(s)

The book section(s) define scrapbooks of a host. It can be subsected as
`[book "identifier"]` (with an identifier being alphanumeric and starts with an
alphabet). The primary scrapbook (`[book]` or `[book ""]`) is used by default.
Additional scrapbooks can be defined and be switched into.


#### `name`

Defines the name of the scrapbook.

(default: `scrapbook`)


#### `top_dir`

The top directory of the scrapbook. It's a directory path under the (ch)root,
without leading or trailing slash.

(default: )


#### `data_dir`

The directory where scrapbook data should be stored in. It's a directory path
under `<top_dir>`, without leading or trailing slash, and cannot be under
`<tree_dir>` or `.wsb`. Use `data` if the scrapbook is migrated from legacy
ScrapBook.

(default: )


#### `tree_dir`

The directory where scrapbook index tree should be stored in. It's a directory
path under `<top_dir>`, without leading or trailing slash. It should not be
under `<data_dir>` unless it's under `<data_dir>/.wsb` (recommended to be
`<data_dir>/.wsb/tree`). Use `tree` if the scrapbook is migrated from legacy
ScrapBook.

(default: `.wsb/tree`)


#### `index`

The path where the scrapbook index page resides. It's a URL path under
`<top_dir>`, without leading slash. Use `tree/map.html` or `tree/index.html` if
the scrapbook is migrated from legacy ScrapBook.

(default: `.wsb/tree/index.html`)


#### `no_tree`

Set true to disable virtual tree and index of the book.

(default: `false`)


#### `new_at_top`

Put newly added items at the top of the scrapbook tree rather than at the
bottom. Multiple items will remain the original order when inserted together.
(e.g. Moving items `A, B, C` into another item having children `X, Y, Z`
gets `A, B, C, X, Y, Z`.)

(default: `false`)


#### `inclusive_frames`

Cache the content of frame pages as part of the main page. The fulltext cache
should be recreated if this config is changed, to prevent an inconsistency.

(default: `true`)


#### `static_index`

Set true to generate an additional `index.html` page when generating static
site pages. The page provides a static list of data items, for SEO and for a
client not supporting JavaScript to browse. However, the page takes more time
to generate and usually loads slower than the dynamic `map.html`.

(default: `false`)


#### `rss_root`

The public absolute root URL of the site, to be used by the generated RSS feed.
No RSS feed will be generated if left blank.

(default: )


#### `rss_item_count`

Items in the generated RSS feed.

(default: `50`)


### `[auth]` section(s)

The `[auth]` section(s) define authorization rules. It can be subsected as
`[auth "identifier"]` (with an identifier being alphanumeric and starts with an
alphabet). Authorization requirement is activated when at least one `[auth]`
section exists. Each section defines a rule, and the user must fullfill at
least one to be allowed to access.

An encrypted password can be generated with the `encrypt` sub-command. For
example:

    webscrapbook encrypt -m pbkdf2:sha256:600000 -s 32

You'll then be prompted to input a password, and the output can be used as the
value of `pw`.

To specify permission for an anonymous user, create an `[auth]` section with
empty user and password.

NOTE: Use HTTPS protocol as possible when password authorization is activated,
as input user name and password are unencrypted during HTTP transmission.


#### `user`

The user's name.

(default: )


#### `pw`

The user's password in hashed form, or empty for no password.

(default: )


#### `permission`

The permission for those who fullfills this authorization condition.
* `all`: unrestricted access.
* `read`: read-only. APIs for data modification are disabled. Note that
  essential server information is still exposed. Recommended for read-only
  WebScrapBook browser extension access.
* `view`: web browsing only. Most APIs are disabled and access via
  WebScrapBook browser extension is not allowed. Recommended for general public
  access.

(default: `all`)


### `[server]` section

The `[server]` section defines the behavior of the built-in HTTP server, which
can be run by `wsb serve` command or by executing the `.wsb/serve.py` shortcut
generated by `wsb config -ba`.


#### `port`

A port integer ranged from 0 to 65535 to host. Pick a port >= 1024 to avoid a
conflict with system ports. Consider the default port (`80` for HTTP and `443`
for HTTPS) for public hosting.

(default: `8080`)


#### `host`

Host identity of the server, as a domain name, IPv4, or IPv6 address. The
server will only react to connections targeting a matching value. As a rule of
thumb, use `localhost` for local hosting, `0.0.0.0` or `::` for world wide web
hosting, and another value for specific subnet hosting.

Configuration of firewall and router(s) may be needed for the server to be
actually accessible from wide area network.

(default: `localhost`)


#### `ssl_on`

Set true to enable HTTPS, and false otherwise.

Set `ssl_key` and `ssl_cert` to define the certificate for SSL.

A simple self-signed certificate can be generated using OpenSSL for testing
purpose or for private usage, e.g.:

    openssl req \
      -newkey rsa:2048 -nodes -keyout domain.key \
      -x509 -days 365 -out domain.crt

and use "domain.key" for `ssl_key` and "domain.crt" for `ssl_cert`.

An "adhoc" certificate can be used by setting `ssl_on` with empty `ssl_key` and
`ssl_cert`, and a temporary certificate will be auto-generated every time when
the server starts. However, this feature requires extra dependency, which can
be installed via `pip install webscrapbook[adhoc_ssl]`.

(default: `false`)


#### `ssl_key`

The SSL key file for HTTPS hosting. Use absolute path or relative to the root
directory.

(default: )


#### `ssl_cert`

The SSL certificate file for HTTPS hosting. Use absolute path or relative to
the root directory.

(default: )


#### `browse`

Set true to launch the browser when the server starts, and false otherwise.

(default: `false`)


### `[browser]` section

The `[browser]` section defines the desired browser to launch when needed. The
browser may be launched when the server starts or for viewing an archive file.


#### `command`

The browser path with CLI arguments to launch. Use `%s` to represent the URL
and append `&` at end to launch browser in the background, which is generally
preferred to avoid interruption. Leave empty to use system default browser.

Example:

    # Launch a Chrome incognito window
    command = "C:\Program Files (x86)\Google\Chrome\Application\chrome.exe" --incognito %s &

    # Launch a Firefox private window
    command = "C:\Program Files\Mozilla Firefox\firefox.exe" -private-window %s &

(default: )


#### `cache_prefix`

The prefix for caches for viewing archive files under the system temporary
directory. Assign a unique string if the default one conflicts with another
application.

(default: `webscrapbook.`)


#### `cache_expire`

The duration in seconds for cache files for viewing archive files to be purged.

(default: `259200` (3 days))


#### `use_jar`

Whether to use JAR protocol for viewing archive files. JAR protocol, supported
by Firefox (Gecko) based browsers, allows accessing ZIP content files directly
without extracting them in prior.

(default: `false`)
