# lg-rez

[![PyPI](https://img.shields.io/pypi/v/lg-rez)](https://pypi.org/project/lg-rez)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/lg-rez)](https://pypi.org/project/lg-rez)
[![PyPI - Wheel](https://img.shields.io/pypi/wheel/lg-rez)](https://pypi.org/project/lg-rez)
[![Read the Docs](https://img.shields.io/readthedocs/lg-rez)](https://lg-rez.readthedocs.io)

Discord bot for organizing boisterous Werewolf RP games ESPCI-style.

*Please not that this project's source code (comments, docstrings) is written
exclusively in French. The bot itself uses only French language; no
internationalization is available at this time.*


## NOTE AUX GRIS / MJS

Tout ce qui suit est du blabla READMEsque peu intéressant.

Pour les trucs intéressants, c'est-à-dire les instructions pour lancer une 
nouvelle saison, voir [`Nouvelle saison.md`](Nouvelle%20saison.md).


## What's New in LG-Rez

Only major features are reported here; see [`CHANGELOG.md`](CHANGELOG.md)
or in [the doc](https://lg-rez.readthedocs.io/fr/2.4.2/changelog.html) for
details.

# 3.0

* Changed all commands to Discord builtin slash commands, using Discordpy 2.0
* Several major commands changes

### 2.4

* New commands ``!mp``, ``!setup``, ``!cfini``
* New subcommand ``!boudoir find``
* Minor improvements and command changes.

### 2.3

* New subcommand ``!boudoir ping``
* Command ``!roles`` partially splitted to ``!camps``.

### 2.2

* New command ``!modif``.

### 2.1

* New Actions System with actions / vote history and better action request;
* New *Boudoirs* management system and new command ``!boudoir``;
* New command ``!lore``.

### 2.0

* Major refactoring of data management and internal structure;
* New ``config`` namespace module for easier customization.


## Installation

Use the package manager [pip](https://pypi.org/project/pip) to install lg-rez:
```bash
pip install lg-rez
```

We strongly recommand to install this package in a dedicated virtualenv
(`python3 -m venv <yourfolder>`).


### Dependencies

* Python 3.10+
* Packages: see [`requirements.txt`](requirements.txt)



## Configuration

To run correctly, the bot needs to be connected to several external services,
each needing more or less sensitive tokens, stocked as environments variables.
We support and encourage the use of
[`python-dotenv`](https://pypi.org/project/python-dotenv/) to read them from
a `.env` file, but you may prefer exporting them as environment variables.

All necessary variables, prefixed by `LGREZ_`, are listed in
[`model.env`](model.env).


### Configuration Assistant Tool

We provide a command-line assistant tool to help you set up every services and
generate the `.env` file (which you can later `source` and delete if you wish).

Run it simply with:
```bash
python -m lgrez
```

This tool also creates a `start_bot.py` file containing the minimal code
needed to run the bot (see *Usage* section below).


### Manual configuration

You may prefer to manually write your environment variables, or just check
instructions regarding a specific one: they can be found in
[`CONFIGURE.md`](CONFIGURE.md).

**Warning**: the Configuration Assistant Tool checks every variable by
running specific tests, which is not the case for manual configuration,
so be sure of what you do!



## Usage

This package's external API consists essentially in a
[`discord.ext.commands.Bot`](https://discordpy.readthedocs.io/en/latest/ext/commands/api.html#bot)
subclass, **`LGBot`**, which implements every features needed to play.

The minimal code needed to run the bot in a configured folder (generated by the
configuration assistant tool) is:
```py
from lgrez import LGBot

bot = LGBot()
bot.run()
```

### Bot usage

Once the bot connected to your Discord server, send `!help` to see every
available commands (note: some commands are only visible by specific roles;
grant yourself the "MJ" AND "Joueur en vie" roles to see everything.) \
Use `!help command` to get more information about a command.

For precisions relative to non-command features (such as "IA" reactions to
messages), look at the corresponding
[documentation](https://lg-rez.readthedocs.io/) section.


### Customization

Since `LGBot` is a subclass of
[`discord.ext.commands.Bot`](https://discordpy.readthedocs.io/en/latest/ext/commands/api.html#bot),
you can use every arguments and methods it supports or subclass it to override
existing behavior.

We also provide a direct way to customize some parameters of the game and
of the Discord server through [`config`](lgrez/config.py) module:
roles/channels/emoji names, date of season beginning, inscription
customization... See
[the doc](https://lg-rez.readthedocs.io/fr/2.4.2/config.html)
for full API usage information.

See additional attributes and overriden methods on
[the doc](https://lg-rez.readthedocs.io/) (mostly in French)

Some useful examples:

#### Change command prefix
```py
from lgrez import LGBot

bot = LGBot(command_prefix="?")
bot.run()
```

#### Customize some config options
```py
from lgrez import LGBot, config

config.debut_saison = "27 octobre"
config.Role.mj = "Game-Master"

bot = LGBot()
bot.run()
```


#### Delete a command or alias
```py
from lgrez import LGBot

bot = LGBot()
bot.remove_command("command_name")
bot.run()
```

#### Add a command or change the behavior of a command
```py
from discord.ext import commands
from lgrez import LGBot

@commands.command()
async def mycommand(ctx, ...):
    ...

bot = LGBot()
bot.remove_command("mycommand")     # If replacing an existing command
bot.add_command(mycommand)
bot.run()
```

#### Enhance or replace the reaction to a Discord event
```py
from lgrez import LGBot

async def say_hello(bot, member):
    await member.send("Hey!")

class MyBot(LGBot):
    """Your customized bot class"""
    async def on_member_join(self, member):
        await say_hello(self, member)
        super().on_member_join(member)      # Invoke the original reaction

bot = MyBot()
bot.run()
```

See [discord.py documentation](https://discordpy.readthedocs.io) for more
ideas.



## Contributing

Community contributions are not welcome for now. Get in touch with the authors
(see below) for any question or suggestion about this project.



## License
This work is shared under [the MIT license](LICENSE).

© 2020 - 2022 Loïc Simon, Tom Lacoma et al. – Club BD-Jeux × GRIs –
ESPCI Paris - PSL

Reach us on Discord:
[LaCarpe#1674](https://discordapp.com/users/264482202966818825),
[TaupeOrAfk#3218](https://discordapp.com/users/176763552202358785) or by mail: [loic.simon@espci.org](mailto:loic.simon@espci.org),
[tom.lacoma@espci.org](mailto:tom.lacoma@espci.org)
