import { Container } from './container';
import * as k8s from './imports/k8s';
/**
 * Utility class to implement the conversion between our API and the k8s action
 * structure. Used both for probes and handlers.
 *
 * @internal
 */
export declare class Action {
    static fromTcpSocket(container: Container, options?: {
        port?: number;
        host?: string;
    }): k8s.TcpSocketAction;
    static fromCommand(command: string[]): k8s.ExecAction;
    static fromHttpGet(container: Container, path: string, options?: {
        port?: number;
    }): k8s.HttpGetAction;
}
