# 給懂中文的程式設計師

## 命名原則及數字處理

本程式庫設計哲學就是函數以中文命名且能簡明表達功能，
函數命名係以「動詞」加「受詞」為原則，受詞表達傳入參數，動詞表達函數功能。
另以簡體名稱表示處理簡體中文情形，
繁體名稱表示處理繁體中文情形。
舉如中文數字處理模組(zhongwen.數)用法示例： 

    from zhongwen.數 import 取中文數字, 取中文数字, 取大寫中文數字
    取中文數字(10600)
    >>> '一萬零六百'
    取中文数字(10600)
    >>> '一万零六百'
    取大寫中文數字(23232.00518)
    >>> '貳萬參仟貳佰參拾貳點零零伍壹捌'

## 民國日期處理

臺灣地區使用民國紀年，
【取日期】函數可將民國日期字串轉成時間資料(pd.Timestamp)，
而【取民國日期】可將時間資料轉成表達民國紀年日期之字串，示例如次：

    from zhongwen.時 import 取日期
    from pandas import Timestamp
    取日期('111.9.23')
    >>> Timestamp(2022,9,23,0,0)
    取日期('110/12/27')
    >>> Timestamp(2021,12,27,0,0)

    from zhongwen.時 import 取民國日期
    取民國日期(datetime(2021,12,27,0,0), '%Y年%M月%d日')
    >>> '110年12月27日'

## 中文字元判斷

中文字元判斷功能示例如次：

    from zhongwen.文 import 是否為中文字元

    是否為中文字元('繁')
    >>> True
    是否為中文字元('简')
    >>> True
    是否為中文字元('a')
    >>> False

## 校正重碼字

字型相似編碼相異之中文字元稱【重碼字】，
如【車】編碼為\u8eca(正式字集)，
而【車】編碼為\uf902(中日韓相容表意文字區)，
其細明體字形幾無差異。
而中日韓相容表意文字區[\uF900-\uFAFF]字元依字源分離原則未與正式字集（包括擴展 A、B、C、D 區）中的字形統一的字，因為許多「第三方字型」都沒有實作這個區域的文字，
【校正中文字】可將重碼字均轉為正體字，即輸入法優先輸出的編碼，以因使用字型未包含中日韓相容表意文字編碼，而以細明體字型表示造成同字卻字型不一問題。

校正中文字示例：

    校正中文字('汽車')
    >>> '汽車'

## 查中文字典

示例：

    查萌典('查')
    >>> ['ㄔㄚˊ：考察、檢查。翻閱、檢尋。大筏，水中的浮木。', 
         'ㄓㄚ：姓。如五代時南唐有查文徽。我。同「咱」(一)。']

## 翻譯

【翻譯】可將外國文字譯為中文，示例如次：

    from zhongwen.文 import 翻譯
    翻譯('test')
    >>> '測試'
    翻譯('取り')
    >>> '拿'

## 安裝

安裝步驟如次：
    
    py -m pip install zhongwen
    py -m zhongwen.pdf --setup
