"""
In this file, we have all DB functions for the project

Author: Qichen Xu mxjk851@gmail.com/qichenx@kth.se

2023-7-10

Wish you have 'sommartid'(summer time) everyday!

"""
import sqlite3
from os import path


def check_profile(db_path):
    """
    This function is used to check the table in the database (one selected profile)
    """
    # check_path is exist or not
    if path.exists(path.expanduser(db_path)):
        select_db = sqlite3.connect(path.expanduser(db_path))
        new_cur = select_db.cursor()
        sql_query = """SELECT name FROM sqlite_master WHERE type='table';"""
        new_cur.execute(sql_query)
        tables_name_list = new_cur.fetchall()
        select_db.close()
    else:
        tables_name_list = ["This profile is not exist"]

    return tables_name_list


def read_property(db_path, table_name, vis_property_name):
    if path.exists(path.expanduser(db_path)):
        con = sqlite3.connect(path.expanduser(db_path))
        cur = con.cursor()
        res = cur.execute(
            "SELECT values_from_key FROM {} WHERE keys_name= '{}'".format(
                table_name, vis_property_name
            )
        )
        values = res.fetchone()
        con.close()
    else:
        raise Exception("Can not find database {}".format(db_path))
    return values[0]


def creat_new_table(db_path, table_name):
    if path.exists(path.expanduser(db_path)):
        con = sqlite3.connect(path.expanduser(db_path))
        cur = con.cursor()
        cur.execute("CREATE TABLE {}(keys_name,values_from_key)".format(table_name))
        con.commit()
        con.close()
    else:
        raise Exception("Can not find database {}".format(db_path))


def creat_new_keys(db_path, table_name, vis_property_name, vis_property_values):
    if path.exists(path.expanduser(db_path)):
        con = sqlite3.connect(path.expanduser(db_path))
        cur = con.cursor()
        cur.execute(
            """INSERT INTO {} VALUES ('{}', '{}')""".format(
                table_name, vis_property_name, vis_property_values
            )
        )
        con.commit()
        con.close()
    else:
        raise Exception("Can not find database {}".format(db_path))


def delete_table(db_path, table_name):
    if path.exists(path.expanduser(db_path)):
        con = sqlite3.connect(path.expanduser(db_path))
        cur = con.cursor()
        cur.execute("DROP TABLE {}".format(table_name))
        con.commit()
        con.close()
    else:
        raise Exception("Can not find database {}".format(db_path))


def initial_profile(
    db_path=None,
    table_name="Initial_profile",
    table_name_store="Initial_profile_store",
):
    """
    This function is used to check the table in the database (one selected profile)
    """

    select_db = sqlite3.connect(path.expanduser(db_path))
    select_db.close()
    creat_new_table(db_path, table_name)
    name_list = [
        "table_name",
        "code_init_indicator_cmap",
        "code_init_indicator_frame",
        "code_init_indicator_metallic",
        "code_init_indicator_opacity",
        "code_init_indicator_roughness",
        "code_init_indicator_resolutions",
        "code_init_indicator_Ratio",
        "code_init_indicator_cone_highth",
        "code_init_indicator_cone_Radius",
        "code_init_indicator_cs",
        "code_init_indicator_Cut_X",
        "code_init_indicator_Cut_Y",
        "code_init_indicator_Cut_Z",
        "code_init_indicator_fxyzc",
        "frame_number",
        "color_map_index",
        "antialiasing",
        "x_compoment_filter_min",
        "x_compoment_filter_max",
        "y_compoment_filter_min",
        "y_compoment_filter_max",
        "z_compoment_filter_min",
        "z_compoment_filter_max",
        "a1_plane_slicer",
        "a1_clip_plane_x",
        "a1_clip_plane_y",
        "a1_clip_plane_z",
        "a2_plane_slicer",
        "a2_clip_plane_x",
        "a2_clip_plane_y",
        "a2_clip_plane_z",
        "b1_plane_slicer",
        "b1_clip_plane_x",
        "b1_clip_plane_y",
        "b1_clip_plane_z",
        "b2_plane_slicer",
        "b2_clip_plane_x",
        "b2_clip_plane_y",
        "b2_clip_plane_z",
        "c1_plane_slicer",
        "c1_clip_plane_x",
        "c1_clip_plane_y",
        "c1_clip_plane_z",
        "c2_plane_slicer",
        "c2_clip_plane_x",
        "c2_clip_plane_y",
        "c2_clip_plane_z",
        "resolutions",
        "radius_record",
        "height_record",
        "metallic_record",
        "opacity_record",
        "roughness_record",
        "Ratio_record",
        "cmap_record",
        "cone_highth_record",
        "cone_Radius_record",
        "cs_record",
        "camera_position",
        "camera_focal_point",
        "camera_up",
        "camera_zoom",
        "pbr",
        "Cone_center",
        "Arrow_center",
        "add_cone",
        "coord_name",
        "mom_name",
        "ovf_name",
        "outputfile_type",
        "bgc",
        "moment_file_indicator",
        "coord_file_indicator",
        "ovf_file_indicator",
        "bgc_indicator",
        "pbr_indicator",
        "add_glyphs",
        "add_arrow",
        "start_arrow",
        "tip_length_arrow",
        "tip_radius_arrow",
        "tip_resolution_arrow",
        "shaft_radius_arrow",
        "shaft_resolution_arrow",
        "Ratio_record_arrow",
        "pbr_arrow",
        "metallic_arrow",
        "roughness_arrow",
        "do_clip_component",
        "do_clip_plane_fix_origin_and_normal",
        "do_clip_box",
        "clip_plane_x_min",
        "clip_plane_x_max",
        "clip_plane_y_min",
        "clip_plane_y_max",
        "clip_plane_z_min",
        "clip_plane_z_max",
        "do_scale_arrow",
        "do_scale_cone",
        "do_scale_sphere",
        "do_scale_plane",
        "do_scale_box",
        "do_scale_own",
        "show_scalar_bar",
        "opacity_index",
        "add_sphere",
        "radius_sphere",
        "center_sphere",
        "theta_resolution_sphere",
        "phi_resolution_sphere",
        "Ratio_record_sphere",
        "pbr_sphere",
        "metallic_sphere",
        "roughness_sphere",
        "add_plane",
        "center_plane",
        "pbr_plane",
        "metallic_plane",
        "roughness_plane",
        "Ratio_record_plane",
        "add_box",
        "bounds_box",
        "Ratio_record_box",
        "pbr_box",
        "metallic_box",
        "roughness_box",
        "add_own_glyphs",
        "Ratio_record_own",
        "pbr_own",
        "metallic_own",
        "roughness_own",
        "add_rectangle_mesh",
        "rectangle_mesh_interpolate_before_map",
        "system_size",
        "rectrangle_color_index",
        "rectrangle_spacing",
        "rectrangle_opacity_index",
        "show_rectangle_mesh_scalar_bar",
        "add_unstructured_mesh",
        "unstructured_mesh_color_map_index",
        "unstructured_mesh_color_map_opacity_index",
        "show_unstructured_mesh_scalar_bar",
        "unstructured_mesh_interpolate_before_map",
        "phi_compoment_filter_max",
        "phi_compoment_filter_min",
        "theta_compoment_filter_max",
        "theta_compoment_filter_min",
        "do_glyph_cone_rescale",
        "do_glyph_sphere_rescale",
        "do_glyph_plane_rescale",
        "do_glyph_box_rescale",
        "do_glyph_own_rescale",
        "do_glyph_arrow_rescale",
        "rescale_cone_factor",
        "rescale_sphere_factor",
        "rescale_plane_factor",
        "rescale_box_factor",
        "rescale_own_factor",
        "rescale_arrow_factor",
        "rescale_arrow_index",
        "rescale_cone_index",
        "rescale_sphere_index",
        "rescale_plane_index",
        "rescale_box_index",
        "rescale_own_index",
        "rescale_arrow_norm",
        "rescale_cone_norm",
        "rescale_sphere_norm",
        "rescale_plane_norm",
        "rescale_box_norm",
        "rescale_own_norm",
        "add_projection_plane_1",
        "add_projection_plane_2",
        "add_projection_plane_3",
        "add_projection_plane_4",
        "add_projection_plane_5",
        "add_projection_plane_6",
        "interpolate_plane_1",
        "interpolate_plane_2",
        "interpolate_plane_3",
        "interpolate_plane_4",
        "interpolate_plane_5",
        "interpolate_plane_6",
        "do_rectangle_mesh_contour",
        "do_multi_rectangle_surface_contour",
        "rectangle_mesh_contour_isosurface_number",
        "rectangle_mesh_contour_isosurface_value",
        "rectangle_mesh_contour_method_indicator",
        "do_unstructured_mesh_contour",
        "do_multi_unstructured_surface_contour",
        "unstructured_mesh_contour_isosurface_value",
        "unstructured_mesh_contour_isosurface_number",
        "unstructured_mesh_contour_method_indicator",
        "do_rectangle_mesh_slice_along_axis",
        "rectangle_number_of_slice_along_axis",
        "rectangle_axis_of_slice_along_axis",
        "do_unstructured_mesh_slice_along_axis",
        "unstructured_number_of_slice_along_axis",
        "unstructured_axis_of_slice_along_axis",
        "do_rectangle_mesh_rescale",
        "rescale_rectangle_mesh_factor",
        "rescale_rectangle_mesh_norm",
        "do_unstructured_mesh_rescale",
        "rescale_unstructured_mesh_factor",
        "rescale_unstructured_mesh_norm",
        "do_rectangle_mesh_clip_scalar",
        "rectangle_mesh_clip_scalar_max_xyz",
        "rectangle_mesh_clip_scalar_min_xyz",
        "rectangle_mesh_clip_scalar_max_theta",
        "rectangle_mesh_clip_scalar_min_theta",
        "rectangle_mesh_clip_scalar_max_phi",
        "rectangle_mesh_clip_scalar_min_phi",
        "do_unstructured_mesh_clip_scalar",
        "unstructured_mesh_clip_scalar_max_xyz",
        "unstructured_mesh_clip_scalar_min_xyz",
        "unstructured_mesh_clip_scalar_max_theta",
        "unstructured_mesh_clip_scalar_min_theta",
        "unstructured_mesh_clip_scalar_max_phi",
        "unstructured_mesh_clip_scalar_min_phi",
        "dataset_clip_plane_free_normal_1",
        "dataset_clip_plane_free_normal_2",
        "clip_plane_free_1",
        "clip_plane_free_2",
        "do_rectangle_mesh_clip",
        "rectangle_mesh_clip_plane_x_min",
        "rectangle_mesh_clip_plane_x_max",
        "rectangle_mesh_clip_plane_y_min",
        "rectangle_mesh_clip_plane_y_max",
        "rectangle_mesh_clip_plane_z_min",
        "rectangle_mesh_clip_plane_z_max",
        "do_clip_rectangle_mesh_free_normal",
        "rectangle_mesh_clip_plane_free_normal_1",
        "rectangle_mesh_clip_plane_free_normal_2",
        "clip_rectangle_mesh_free_1",
        "clip_rectangle_mesh_free_2",
        "do_unstructured_mesh_clip",
        "unstructured_mesh_clip_plane_x_min",
        "unstructured_mesh_clip_plane_x_max",
        "unstructured_mesh_clip_plane_y_min",
        "unstructured_mesh_clip_plane_y_max",
        "unstructured_mesh_clip_plane_z_min",
        "unstructured_mesh_clip_plane_z_max",
        "do_clip_unstructured_mesh_free_normal",
        "unstructured_mesh_clip_plane_free_normal_1",
        "unstructured_mesh_clip_plane_free_normal_2",
        "clip_unstructured_mesh_free_1",
        "clip_unstructured_mesh_free_2",
        "do_rectangle_mesh_slice",
        "rectangle_mesh_slice_contour_option",
        "rectangle_mesh_slice_origin",
        "rectangle_mesh_slice_normal",
        "do_unstructured_mesh_slice",
        "unstructured_mesh_slice_contour_option",
        "unstructured_mesh_slice_origin",
        "unstructured_mesh_slice_normal",
        "do_rectangle_mesh_clip_box",
        "rectangle_mesh_clip_box_x_min",
        "rectangle_mesh_clip_box_x_max",
        "rectangle_mesh_clip_box_y_min",
        "rectangle_mesh_clip_box_y_max",
        "rectangle_mesh_clip_box_z_min",
        "rectangle_mesh_clip_box_z_max",
        "invert_rectangle_mesh_clip_box",
        "rectangle_mesh_clip_implicit_or_explict",
        "rectangle_mesh_clip_box_factor",
        "do_unstructured_mesh_clip_box",
        "unstructured_mesh_clip_box_x_min",
        "unstructured_mesh_clip_box_x_max",
        "unstructured_mesh_clip_box_y_min",
        "unstructured_mesh_clip_box_y_max",
        "unstructured_mesh_clip_box_z_min",
        "unstructured_mesh_clip_box_z_max",
        "invert_unstructured_mesh_clip_box",
        "unstructured_mesh_clip_implicit_or_explict",
        "unstructured_mesh_clip_box_factor",
        "do_clip_plane_free_normal",
        "pbr_rectangle",
        "pbr_unstructured",
        "add_simple_point",
        "do_glyph_simple_point_rescale",
        "rescale_simple_point_index",
        "simple_point_size",
        "local_rendering_sinmple_point_as_spheres",
        "rescale_simple_point_factor",
        "rescale_simple_point_norm",
        "mom_name1",
        "mom_name2",
        "mom_name3",
        "do_delaunay",
        "antialiasing_indicator",
        "download_screenshot_resolution",
        "download_screenshot_indicator",
        "activate_glyphs_indicator",
        "activate_rectangle_mesh_indicator",
        "activate_unstructured_mesh_indicator",
        "excu_from_other_place",
        "nothing_show",
        "frame_change",
        "projection_plane_1_added",
        "projection_plane_2_added",
        "projection_plane_3_added",
        "projection_plane_4_added",
        "projection_plane_5_added",
        "projection_plane_6_added",
        "cone_added_1",
        "cone_added_2",
        "cone_added_3",
        "cone_added_4",
        "arrow_added_1",
        "arrow_added_2",
        "arrow_added_3",
        "arrow_added_4",
        "sphere_added_1",
        "sphere_added_2",
        "sphere_added_3",
        "sphere_added_4",
        "box_added_1",
        "box_added_2",
        "box_added_3",
        "box_added_4",
        "own_glyphs_added_1",
        "own_glyphs_added_2",
        "own_glyphs_added_3",
        "own_glyphs_added_4",
        "plane_added_1",
        "plane_added_2",
        "plane_added_3",
        "plane_added_4",
        "tmesh_op_indicator",
        "unstructured_mesh_added_1",
        "unstructured_mesh_added_2",
        "unstructured_mesh_added_3",
        "unstructured_mesh_added_4",
        "rectangle_mesh_added_1",
        "rectangle_mesh_added_2",
        "rectangle_mesh_added_3",
        "rectangle_mesh_added_4",
        "rectangle_mesh_contour_isosurface_value_x",
        "rectangle_mesh_contour_isosurface_value_y",
        "rectangle_mesh_contour_isosurface_value_z",
        "simple_point_added_1",
        "simple_point_added_2",
        "simple_point_added_3",
        "simple_point_added_4",
        "excu_from_other_place_welcome_image",
        "nothing_show_welcome_image",
        "first_time_nothing_show",
        "cubemap_exist",
        "activate_cone_indicator",
        "activate_arrow_indicator",
        "activate_sphere_indicator",
        "activate_box_indicator",
        "activate_own_glyphs_indicator",
        "activate_plane_indicator",
        "sub_frame_number",
        "scalar_bar_indicator",
        "moive_size_x",
        "moive_size_y",
        "welcome_image_not_created",
        "cone_cmap_index_indicator",
        "glyph_cmap_vbtn",
        "glyph_opaciy_vbtn",
        "do_clip_component_indicator",
        "activate_point_indicator",
        "point_rescale_indicator",
        "point_size_indicator",
        "point_rescale_factor_indicator",
        "warp_sphere_radius",
        "do_warp_sphere",
        "add_warpped_sphere_kernel",
        "warpped_sphere_kernel",
        "warp_kernel_color",
        "swk_c_indicator",
        "swk_added",
        "warp_sphere_radius_indicator",
        "skw_ratio_indicator",
        "warp_kernel_color_changed",
        "start_desoning_filter_index",
        "low_pass_filter_order",
        "low_pass_normalized_freq",
        "fft_rec_windows_X",
        "fft_rec_windows_Y",
        "fft_rec_windows_Z",
        "projection_plane_added_1_1",
        "projection_plane_added_1_2",
        "projection_plane_added_1_3",
        "projection_plane_added_1_4",
        "projection_plane_added_2_1",
        "projection_plane_added_2_2",
        "projection_plane_added_2_3",
        "projection_plane_added_2_4",
        "projection_plane_added_3_1",
        "projection_plane_added_3_2",
        "projection_plane_added_3_3",
        "projection_plane_added_3_4",
        "projection_plane_added_4_1",
        "projection_plane_added_4_2",
        "projection_plane_added_4_3",
        "projection_plane_added_4_4",
        "projection_plane_added_5_1",
        "projection_plane_added_5_2",
        "projection_plane_added_5_3",
        "projection_plane_added_5_4",
        "projection_plane_added_6_1",
        "projection_plane_added_6_2",
        "projection_plane_added_6_3",
        "projection_plane_added_6_4",
        "do_glyph_projection_fft",
        "do_glyph_projection_fft_indicator",
        "cut_phi_indicator",
        "cut_theta_indicator",
        "rectangle_cmap_vbtn",
        "rectangle_opaciy_vbtn",
        "Tmesh_cmap_vbtn",
        "Tmesh_opaciy_vbtn",
        "rectangle_mesh_contour_isosurface_value_t",
        "rectangle_mesh_contour_isosurface_value_p",
        "unstructured_mesh_contour_isosurface_value_t",
        "unstructured_mesh_contour_isosurface_value_p",
        "opacity_record_tmesh",
        "opacity_record_rectangle_mesh",
        "change_mom1",
        "change_mom2",
        "change_mom3",
        "change_mom4",
        "rec_mesh_color_scalar",
        "rectangle_mesh_clip_scalar_max_x",
        "rectangle_mesh_clip_scalar_min_x",
        "rectangle_mesh_clip_scalar_max_y",
        "rectangle_mesh_clip_scalar_min_y",
        "rectangle_mesh_clip_scalar_max_z",
        "rectangle_mesh_clip_scalar_min_z",
        "roughness_rmesh",
        "metallic_rmesh",
        "metallic_tmesh",
        "roughness_tmesh",
        "pyvista_backend_interactive_ratio",
        "pyvista_backend_still_ratio",
        "do_interpolated_projection",
        "t_mesh_contour_isosurface_value_x",
        "t_mesh_contour_isosurface_value_y",
        "t_mesh_contour_isosurface_value_z",
        "t_mesh_clip_scalar_max_x",
        "t_mesh_clip_scalar_min_x",
        "t_mesh_clip_scalar_max_y",
        "t_mesh_clip_scalar_min_y",
        "t_mesh_clip_scalar_max_z",
        "t_mesh_clip_scalar_min_z",
    ]  # start from Cone_center is new added

    default_value_list = [
        '["Initial_profile"]',
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        '["fxaa"]',
        "-1",
        "1",
        "-1",
        "1",
        "-1",
        "1  ",
        "-100",
        "1",
        "0",
        "0 ",
        "100",
        "1",
        "0",
        "0 ",
        "-100",
        "0",
        "1",
        "0 ",
        "100",
        "0",
        "1",
        "0 ",
        "-100",
        "0",
        "0",
        "1 ",
        "100",
        "0",
        "0",
        "1 ",
        "10",
        "0.1",
        "1.0",
        "0.1",
        "1.0",
        "0.1",
        "1.0",
        '["jet"]',
        "1.0",
        "0.1",
        "[0,0,0]",
        "(62.74231442817803, 62.74242118009682, 52.74208870538826)",
        "(14.500156238675117, 14.50026299059391, 4.499930515885353)",
        "(0.0, 0.0, 1.0)",
        "1.0",
        "[False]",
        "(0.0, 0.0, 0.0)",
        "(0.0, 0.0, 0.0)",
        "[False]",
        '["coord*"]',
        '["restart*"]',
        '["*.ovf"]',
        '["auto"]',
        '["white"]',
        "0",
        "0",
        "0",
        "0",
        "0",
        "[True]",
        "[False]",
        "(0.0, 0.0, 0.0)",
        "0.25",
        "0.1",
        "6",
        "0.05",
        "6",
        "1.0",
        "[False]",
        "0.1",
        "0.1",
        "[False]",
        "[False]",
        "[False]",
        "0.0",
        "1.0",
        "0.0",
        "1.0",
        "0.0",
        "1.0",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[True]",
        "6",
        "[False]",
        "0.5",
        "(0.0, 0.0, 0.0)",
        "6",
        "6",
        "1.0",
        "[False]",
        "0.1",
        "0.1",
        "[False]",
        "(0.0, 0.0, 0.0)",
        "[False]",
        "0.1",
        "0.1",
        "1.0",
        "[False]",
        "(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0)",
        "1.0",
        "[False]",
        "0.1",
        "0.1",
        "[False]",
        "1.0",
        "[False]",
        "0.1",
        "0.1",
        "[False]",
        "[False]",
        "(1.0, 1.0, 1.0)",
        "0",
        "(1.0,1.0, 1.0)",
        "6",
        "[True]",
        "[False]",
        "0",
        "6",
        "[True]",
        "[False]",
        "180",
        "-180",
        "180",
        "0.0",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "1.0",
        "1.0",
        "1.0",
        "1.0",
        "1.0",
        "1.0",
        "4",
        "4",
        "4",
        "4",
        "4",
        "4",
        "(0.0, 0.0, 1.0)",
        "(0.0, 0.0, 1.0)",
        "(0.0, 0.0, 1.0)",
        "(0.0, 0.0, 1.0)",
        "(0.0, 0.0, 1.0)",
        "(0.0, 0.0, 1.0)",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[True]",
        "10",
        "0.0",
        "0",
        "[False]",
        "[True]",
        "0.0",
        "10",
        "0",
        "[False]",
        "3",
        "0",
        "[False]",
        "3",
        "0",
        "[False]",
        "1.0",
        "(0.0, 0.0, 1.0)",
        "[False]",
        "1.0",
        "(0.0, 0.0, 1.0)",
        "[False]",
        "1.0",
        "-1.0",
        "180",
        "0.0",
        "180",
        "-180",
        "[False]",
        "1.0",
        "-1.0",
        "180",
        "0.0",
        "180",
        "-180",
        "(0.0, 0.0, 1.0)",
        "(0.0, 0.0, 1.0)",
        "0.0",
        "0.0",
        "[False]",
        "0.0",
        "1.0",
        "0.0",
        "1.0",
        "0.0",
        "1.0",
        "[False]",
        "(0.0, 0.0, 1.0)",
        "(0.0, 0.0, 1.0)",
        "0.0",
        "0.0",
        "[False]",
        "0.0",
        "1.0",
        "0.0",
        "1.0",
        "0.0",
        "1.0",
        "[False]",
        "(0.0, 0.0, 1.0)",
        "(0.0, 0.0, 1.0)",
        "0.0",
        "1.0",
        "[False]",
        "[False]",
        "(0.0, 0.0, 0.0)",
        "(0.0, 0.0, 1.0)",
        "[False]",
        "[False]",
        "(0.0, 0.0, 0.0)",
        "(0.0, 0.0, 1.0)",
        "[False]",
        "0.0",
        "1.0",
        "0.0",
        "1.0",
        "0.0",
        "1.0",
        "[False]",
        "[True]",
        "0.3",
        "[False]",
        "0.0",
        "1.0",
        "0.0",
        "1.0",
        "0.0",
        "1.0",
        "[False]",
        "[True]",
        "0.3",
        "[False]",
        "[False]",
        "[False]",
        "[True]",
        "[False]",
        "0",
        "10",
        "[True]",
        "1.0",
        "(0.0, 0.0, 1.0)",
        '["restart*"]',
        '["restart*"]',
        '["restart*"]',
        "[True]",
        "0",
        "1",
        "0",
        "0",
        "0",
        "0",
        "[False]",
        "[False]",
        "[True] ",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[None]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "0",
        "0",
        "0",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[True]",
        "[False]",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "1",
        "0",
        "1500",
        "1500",
        "[True]",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "10",
        "[False]",
        "[False]",
        "0.8",
        '["grey"]',
        "0",
        "[False]",
        "0",
        "0",
        "[False]",
        "0",
        "10",
        "0.3",
        "6",
        "6",
        "6",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[False]",
        "[True]",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "0",
        "1",
        "0",
        "90",
        "0",
        "1",
        "1",
        "0",
        "0",
        "0",
        "0",
        '["x_com"]',
        "1",
        "-1",
        "1",
        "-1",
        "1",
        "-1",
        "0.1",
        "0.1",
        "0.1",
        "0.1",
        "1",
        "1",
        "[False]",
        "0",
        "0",
        "0",
        "1",
        "-1",
        "1",
        "-1",
        "1",
        "-1",
    ]

    for i in range(len(name_list)):
        creat_new_keys(db_path, table_name, name_list[i], default_value_list[i])


if __name__ == "__main__":
    initial_profile()
