from typing import overload
import abc
import typing

import System
import System.Runtime.Intrinsics
import System.Runtime.Intrinsics.X86


class X86Base(System.Object, metaclass=abc.ABCMeta):
    """This class provides access to the x86 base hardware instructions via intrinsics"""

    class X64(System.Object, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
            """
            unsigned __int64 _udiv128(unsigned __int64 highdividend, unsigned __int64 lowdividend, unsigned __int64 divisor, unsigned __int64* remainder)
              DIV reg/m64
            """
            ...

        @staticmethod
        @overload
        def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
            """
            __int64 _div128(__int64 highdividend, __int64 lowdividend, __int64 divisor, __int64* remainder)
              DIV reg/m64
            """
            ...

        @staticmethod
        @overload
        def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
            """
            unsigned __int64 _udiv128(unsigned __int64 highdividend, unsigned __int64 lowdividend, unsigned __int64 divisor, unsigned __int64* remainder)
              DIV reg/m64
            """
            ...

        @staticmethod
        @overload
        def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
            """
            __int64 _div128(__int64 highdividend, __int64 lowdividend, __int64 divisor, __int64* remainder)
              DIV reg/m64
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def CpuId(functionId: int, subFunctionId: int) -> System.ValueTuple[int, int, int, int]:
        """
        void __cpuidex (int cpuInfo[4], int function_id, int subfunction_id);
          CPUID
        """
        ...

    @staticmethod
    @overload
    def CpuId(functionId: int, subFunctionId: int) -> System.ValueTuple[int, int, int, int]:
        """
        void __cpuidex (int cpuInfo[4], int function_id, int subfunction_id);
          CPUID
        """
        ...

    @staticmethod
    @overload
    def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
        """DIV reg/m32"""
        ...

    @staticmethod
    @overload
    def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
        """IDIV reg/m32"""
        ...

    @staticmethod
    @overload
    def DivRem(lower: System.UIntPtr, upper: System.UIntPtr, divisor: System.UIntPtr) -> System.ValueTuple[System.UIntPtr, System.UIntPtr]:
        """IDIV reg/m"""
        ...

    @staticmethod
    @overload
    def DivRem(lower: System.UIntPtr, upper: System.IntPtr, divisor: System.IntPtr) -> System.ValueTuple[System.IntPtr, System.IntPtr]:
        """IDIV reg/m"""
        ...

    @staticmethod
    @overload
    def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
        """
        unsigned _udiv64(unsigned __int64 dividend, unsigned divisor, unsigned* remainder)
          DIV reg/m32
        """
        ...

    @staticmethod
    @overload
    def DivRem(lower: int, upper: int, divisor: int) -> System.ValueTuple[int, int]:
        """
        int _div64(__int64 dividend, int divisor, int* remainder)
          IDIV reg/m32
        """
        ...

    @staticmethod
    @overload
    def DivRem(lower: System.UIntPtr, upper: System.UIntPtr, divisor: System.UIntPtr) -> System.ValueTuple[System.UIntPtr, System.UIntPtr]:
        """IDIV reg/m"""
        ...

    @staticmethod
    @overload
    def DivRem(lower: System.UIntPtr, upper: System.IntPtr, divisor: System.IntPtr) -> System.ValueTuple[System.IntPtr, System.IntPtr]:
        """IDIV reg/m"""
        ...

    @staticmethod
    @overload
    def Pause() -> None:
        """
        void _mm_pause (void);
          PAUSE
        """
        ...

    @staticmethod
    @overload
    def Pause() -> None:
        """
        void _mm_pause (void);
          PAUSE
        """
        ...


class Sse(System.Runtime.Intrinsics.X86.X86Base, metaclass=abc.ABCMeta):
    """This class provides access to Intel SSE hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.X86Base.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def ConvertScalarToVector128Single(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """
            __m128 _mm_cvtsi64_ss (__m128 a, __int64 b)
               CVTSI2SS xmm1,       r/m64
              VCVTSI2SS xmm1, xmm2, r/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertScalarToVector128Single(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """
            __m128 _mm_cvtsi64_ss (__m128 a, __int64 b)
               CVTSI2SS xmm1,       r/m64
              VCVTSI2SS xmm1, xmm2, r/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvtss_si64 (__m128 a)
               CVTSS2SI r64, xmm1/m32
              VCVTSS2SI r64, xmm1/m32
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvtss_si64 (__m128 a)
               CVTSS2SI r64, xmm1/m32
              VCVTSS2SI r64, xmm1/m32
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvttss_si64 (__m128 a)
               CVTTSS2SI r64, xmm1/m32
              VCVTTSS2SI r64, xmm1/m32
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvttss_si64 (__m128 a)
               CVTTSS2SI r64, xmm1/m32
              VCVTTSS2SI r64, xmm1/m32
            This intrinsic is only available on 64-bit processes
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_add_ps (__m128 a,  __m128 b)
           ADDPS xmm1,               xmm2/m128
          VADDPS xmm1,         xmm2, xmm3/m128
          VADDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_add_ps (__m128 a,  __m128 b)
           ADDPS xmm1,               xmm2/m128
          VADDPS xmm1,         xmm2, xmm3/m128
          VADDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AddScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_add_ss (__m128 a,  __m128 b)
           ADDSS xmm1,               xmm2/m32
          VADDSS xmm1,         xmm2, xmm3/m32
          VADDSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}
        """
        ...

    @staticmethod
    @overload
    def AddScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_add_ss (__m128 a,  __m128 b)
           ADDSS xmm1,               xmm2/m32
          VADDSS xmm1,         xmm2, xmm3/m32
          VADDSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_and_ps (__m128 a, __m128 b)
           ANDPS xmm1,               xmm2/m128
          VANDPS xmm1,         xmm2, xmm3/m128
          VANDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_and_ps (__m128 a, __m128 b)
           ANDPS xmm1,               xmm2/m128
          VANDPS xmm1,         xmm2, xmm3/m128
          VANDPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_andnot_ps (__m128 a, __m128 b)
           ANDNPS xmm1,               xmm2/m128
          VANDNPS xmm1,         xmm2, xmm3/m128
          VANDNPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_andnot_ps (__m128 a, __m128 b)
           ANDNPS xmm1,               xmm2/m128
          VANDNPS xmm1,         xmm2, xmm3/m128
          VANDNPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpeq_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(0)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpeq_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(0)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpgt_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(1)   ; with swapped operands
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(1)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpgt_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(1)   ; with swapped operands
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(1)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpge_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(2)   ; with swapped operands
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(2)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpge_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(2)   ; with swapped operands
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(2)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmplt_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(1)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmplt_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(1)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmple_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(2)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmple_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(2)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpneq_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(4)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpneq_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(4)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpngt_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(5)   ; with swapped operands
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(5)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpngt_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(5)   ; with swapped operands
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(5)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnge_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(6)   ; with swapped operands
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(6)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnge_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(6)   ; with swapped operands
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(6)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnlt_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(5)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnlt_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(5)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnle_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(6)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnle_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(6)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpord_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(7)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpord_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(7)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpeq_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(0)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpeq_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(0)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpgt_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(1)   ; with swapped operands
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(1)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpgt_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(1)   ; with swapped operands
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(1)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpge_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(2)   ; with swapped operands
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(2)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpge_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(2)   ; with swapped operands
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(2)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmplt_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(1)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmplt_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(1)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmple_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(2)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmple_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(2)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpneq_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(4)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpneq_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(4)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpngt_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(5)   ; with swapped operands
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(5)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpngt_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(5)   ; with swapped operands
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(5)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnge_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(6)   ; with swapped operands
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(6)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnge_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(6)   ; with swapped operands
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(6)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnlt_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(5)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnlt_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(5)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnle_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(6)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpnle_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(6)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpord_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(7)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpord_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(7)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comieq_ss (__m128 a, __m128 b)
           COMISS xmm1, xmm2/m32        ; ZF=1 && PF=0
          VCOMISS xmm1, xmm2/m32        ; ZF=1 && PF=0
          VCOMISS xmm1, xmm2/m32{sae}   ; ZF=1 && PF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comieq_ss (__m128 a, __m128 b)
           COMISS xmm1, xmm2/m32        ; ZF=1 && PF=0
          VCOMISS xmm1, xmm2/m32        ; ZF=1 && PF=0
          VCOMISS xmm1, xmm2/m32{sae}   ; ZF=1 && PF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comigt_ss (__m128 a, __m128 b)
           COMISS xmm1, xmm2/m32        ; ZF=0 && CF=0
          VCOMISS xmm1, xmm2/m32        ; ZF=0 && CF=0
          VCOMISS xmm1, xmm2/m32{sae}   ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comigt_ss (__m128 a, __m128 b)
           COMISS xmm1, xmm2/m32        ; ZF=0 && CF=0
          VCOMISS xmm1, xmm2/m32        ; ZF=0 && CF=0
          VCOMISS xmm1, xmm2/m32{sae}   ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comige_ss (__m128 a, __m128 b)
           COMISS xmm1, xmm2/m32        ; CF=0
          VCOMISS xmm1, xmm2/m32        ; CF=0
          VCOMISS xmm1, xmm2/m32{sae}   ; CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comige_ss (__m128 a, __m128 b)
           COMISS xmm1, xmm2/m32        ; CF=0
          VCOMISS xmm1, xmm2/m32        ; CF=0
          VCOMISS xmm1, xmm2/m32{sae}   ; CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comilt_ss (__m128 a, __m128 b)
           COMISS xmm1, xmm2/m32        ; PF=0 && CF=1
          VCOMISS xmm1, xmm2/m32        ; PF=0 && CF=1
          VCOMISS xmm1, xmm2/m32{sae}   ; PF=0 && CF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comilt_ss (__m128 a, __m128 b)
           COMISS xmm1, xmm2/m32        ; PF=0 && CF=1
          VCOMISS xmm1, xmm2/m32        ; PF=0 && CF=1
          VCOMISS xmm1, xmm2/m32{sae}   ; PF=0 && CF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comile_ss (__m128 a, __m128 b)
           COMISS xmm1, xmm2/m32        ; PF=0 && (ZF=1 || CF=1)
          VCOMISS xmm1, xmm2/m32        ; PF=0 && (ZF=1 || CF=1)
          VCOMISS xmm1, xmm2/m32{sae}   ; PF=0 && (ZF=1 || CF=1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comile_ss (__m128 a, __m128 b)
           COMISS xmm1, xmm2/m32        ; PF=0 && (ZF=1 || CF=1)
          VCOMISS xmm1, xmm2/m32        ; PF=0 && (ZF=1 || CF=1)
          VCOMISS xmm1, xmm2/m32{sae}   ; PF=0 && (ZF=1 || CF=1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comineq_ss (__m128 a, __m128 b)
           COMISS xmm1, xmm2/m32        ; ZF=0 || PF=1
          VCOMISS xmm1, xmm2/m32        ; ZF=0 || PF=1
          VCOMISS xmm1, xmm2/m32{sae}   ; ZF=0 || PF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comineq_ss (__m128 a, __m128 b)
           COMISS xmm1, xmm2/m32        ; ZF=0 || PF=1
          VCOMISS xmm1, xmm2/m32        ; ZF=0 || PF=1
          VCOMISS xmm1, xmm2/m32{sae}   ; ZF=0 || PF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpunord_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(3)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpunord_ss (__m128 a,  __m128 b)
           CMPSS xmm1,       xmm2/m32, imm8(3)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomieq_ss (__m128 a, __m128 b)
           UCOMISS xmm1, xmm2/m32       ; ZF=1 && PF=0
          VUCOMISS xmm1, xmm2/m32       ; ZF=1 && PF=0
          VUCOMISS xmm1, xmm2/m32{sae}  ; ZF=1 && PF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomieq_ss (__m128 a, __m128 b)
           UCOMISS xmm1, xmm2/m32       ; ZF=1 && PF=0
          VUCOMISS xmm1, xmm2/m32       ; ZF=1 && PF=0
          VUCOMISS xmm1, xmm2/m32{sae}  ; ZF=1 && PF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomigt_ss (__m128 a, __m128 b)
           UCOMISS xmm1, xmm2/m32       ; ZF=0 && CF=0
          VUCOMISS xmm1, xmm2/m32       ; ZF=0 && CF=0
          VUCOMISS xmm1, xmm2/m32{sae}  ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomigt_ss (__m128 a, __m128 b)
           UCOMISS xmm1, xmm2/m32       ; ZF=0 && CF=0
          VUCOMISS xmm1, xmm2/m32       ; ZF=0 && CF=0
          VUCOMISS xmm1, xmm2/m32{sae}  ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomige_ss (__m128 a, __m128 b)
           UCOMISS xmm1, xmm2/m32       ; CF=0
          VUCOMISS xmm1, xmm2/m32       ; CF=0
          VUCOMISS xmm1, xmm2/m32{sae}  ; CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomige_ss (__m128 a, __m128 b)
           UCOMISS xmm1, xmm2/m32       ; CF=0
          VUCOMISS xmm1, xmm2/m32       ; CF=0
          VUCOMISS xmm1, xmm2/m32{sae}  ; CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomilt_ss (__m128 a, __m128 b)
           UCOMISS xmm1, xmm2/m32       ; PF=0 && CF=1
          VUCOMISS xmm1, xmm2/m32       ; PF=0 && CF=1
          VUCOMISS xmm1, xmm2/m32{sae}  ; PF=0 && CF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomilt_ss (__m128 a, __m128 b)
           UCOMISS xmm1, xmm2/m32       ; PF=0 && CF=1
          VUCOMISS xmm1, xmm2/m32       ; PF=0 && CF=1
          VUCOMISS xmm1, xmm2/m32{sae}  ; PF=0 && CF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomile_ss (__m128 a, __m128 b)
           UCOMISS xmm1, xmm2/m32       ; PF=0 && (ZF=1 || CF=1)
          VUCOMISS xmm1, xmm2/m32       ; PF=0 && (ZF=1 || CF=1)
          VUCOMISS xmm1, xmm2/m32{sae}  ; PF=0 && (ZF=1 || CF=1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomile_ss (__m128 a, __m128 b)
           UCOMISS xmm1, xmm2/m32       ; PF=0 && (ZF=1 || CF=1)
          VUCOMISS xmm1, xmm2/m32       ; PF=0 && (ZF=1 || CF=1)
          VUCOMISS xmm1, xmm2/m32{sae}  ; PF=0 && (ZF=1 || CF=1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomineq_ss (__m128 a, __m128 b)
           UCOMISS xmm1, xmm2/m32       ; ZF=0 || PF=1
          VUCOMISS xmm1, xmm2/m32       ; ZF=0 || PF=1
          VUCOMISS xmm1, xmm2/m32{sae}  ; ZF=0 || PF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomineq_ss (__m128 a, __m128 b)
           UCOMISS xmm1, xmm2/m32       ; ZF=0 || PF=1
          VUCOMISS xmm1, xmm2/m32       ; ZF=0 || PF=1
          VUCOMISS xmm1, xmm2/m32{sae}  ; ZF=0 || PF=1
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpunord_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(3)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmpunord_ps (__m128 a,  __m128 b)
           CMPPS xmm1,       xmm2/m128, imm8(3)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Single(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtsi32_ss (__m128 a, int b)
           CVTSI2SS xmm1,       r/m32
          VCVTSI2SS xmm1, xmm2, r/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Single(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtsi32_ss (__m128 a, int b)
           CVTSI2SS xmm1,       r/m32
          VCVTSI2SS xmm1, xmm2, r/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvtss_si32 (__m128 a)
           CVTSS2SI r32, xmm1/m32
          VCVTSS2SI r32, xmm1/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvtss_si32 (__m128 a)
           CVTSS2SI r32, xmm1/m32
          VCVTSS2SI r32, xmm1/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvttss_si32 (__m128 a)
           CVTTSS2SI r32, xmm1/m32
          VCVTTSS2SI r32, xmm1/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvttss_si32 (__m128 a)
           CVTTSS2SI r32, xmm1/m32
          VCVTTSS2SI r32, xmm1/m32
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_div_ps (__m128 a,  __m128 b)
           DIVPS xmm,                xmm2/m128
          VDIVPS xmm1,         xmm2, xmm3/m128
          VDIVPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_div_ps (__m128 a,  __m128 b)
           DIVPS xmm,                xmm2/m128
          VDIVPS xmm1,         xmm2, xmm3/m128
          VDIVPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def DivideScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_div_ss (__m128 a,  __m128 b)
           DIVSS xmm1,       xmm2/m32
          VDIVSS xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def DivideScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_div_ss (__m128 a,  __m128 b)
           DIVSs xmm1,       xmm2/m32
          VDIVSs xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_load_ps (float const* mem_address)
           MOVAPS xmm1,         m128
          VMOVAPS xmm1,         m128
          VMOVAPS xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_load_ps (float const* mem_address)
           MOVAPS xmm1,         m128
          VMOVAPS xmm1,         m128
          VMOVAPS xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadHigh(lower: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_loadh_pi (__m128 a, __m64 const* mem_addr)
           MOVHPS xmm1,       m64
          VMOVHPS xmm1, xmm2, m64
        """
        ...

    @staticmethod
    @overload
    def LoadHigh(lower: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_loadh_pi (__m128 a, __m64 const* mem_addr)
           MOVHPS xmm1,       m64
          VMOVHPS xmm1, xmm2, m64
        """
        ...

    @staticmethod
    @overload
    def LoadLow(upper: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_loadl_pi (__m128 a, __m64 const* mem_addr)
           MOVLPS xmm1,       m64
          VMOVLPS xmm1, xmm2, m64
        """
        ...

    @staticmethod
    @overload
    def LoadLow(upper: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_loadl_pi (__m128 a, __m64 const* mem_addr)
           MOVLPS xmm1,       m64
          VMOVLPS xmm1, xmm2, m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_load_ss (float const* mem_address)
           MOVSS xmm1,      m32
          VMOVSS xmm1,      m32
          VMOVSS xmm1 {k1}, m32
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_load_ss (float const* mem_address)
           MOVSS xmm1,      m32
          VMOVSS xmm1,      m32
          VMOVSS xmm1 {k1}, m32
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_loadu_ps (float const* mem_address)
           MOVUPS xmm1,         m128
          VMOVUPS xmm1,         m128
          VMOVUPS xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_loadu_ps (float const* mem_address)
           MOVUPS xmm1,         m128
          VMOVUPS xmm1,         m128
          VMOVUPS xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_max_ps (__m128 a,  __m128 b)
           MAXPS xmm1,               xmm2/m128
          VMAXPS xmm1,         xmm2, xmm3/m128
          VMAXPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_max_ps (__m128 a,  __m128 b)
           MAXPS xmm1,               xmm2/m128
          VMAXPS xmm1,         xmm2, xmm3/m128
          VMAXPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def MaxScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_max_ss (__m128 a,  __m128 b)
           MAXSS xmm1,       xmm2/m32
          VMAXSS xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def MaxScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_max_ss (__m128 a,  __m128 b)
           MAXSS xmm1,       xmm2/m32
          VMAXSS xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_min_ps (__m128 a,  __m128 b)
           MINPS xmm1,               xmm2/m128
          VMINPS xmm1,         xmm2, xmm3/m128
          VMINPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_min_ps (__m128 a,  __m128 b)
           MINPS xmm1,               xmm2/m128
          VMINPS xmm1,         xmm2, xmm3/m128
          VMINPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def MinScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_min_ss (__m128 a,  __m128 b)
           MINSS xmm1,       xmm2/m32
          VMINSS xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def MinScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_min_ss (__m128 a,  __m128 b)
           MINSS xmm1,       xmm2/m32
          VMINSS xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def MoveHighToLow(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_movehl_ps (__m128 a,  __m128 b)
           MOVHLPS xmm1,       xmm2
          VMOVHLPS xmm1, xmm2, xmm3
        """
        ...

    @staticmethod
    @overload
    def MoveHighToLow(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_movehl_ps (__m128 a,  __m128 b)
           MOVHLPS xmm1,       xmm2
          VMOVHLPS xmm1, xmm2, xmm3
        """
        ...

    @staticmethod
    @overload
    def MoveLowToHigh(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_movelh_ps (__m128 a,  __m128 b)
           MOVLHPS xmm1,       xmm2
          VMOVLHPS xmm1, xmm2, xmm3
        """
        ...

    @staticmethod
    @overload
    def MoveLowToHigh(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_movelh_ps (__m128 a,  __m128 b)
           MOVLHPS xmm1,       xmm2
          VMOVLHPS xmm1, xmm2, xmm3
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_movemask_ps (__m128 a)
           MOVMSKPS r32, xmm1
          VMOVMSKPS r32, xmm1
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_movemask_ps (__m128 a)
           MOVMSKPS r32, xmm1
          VMOVMSKPS r32, xmm1
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_move_ss (__m128 a, __m128 b)
           MOVSS xmm1,         xmm2
          VMOVSS xmm1,         xmm2, xmm3
          VMOVSS xmm1 {k1}{z}, xmm2, xmm3
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_move_ss (__m128 a, __m128 b)
           MOVSS xmm1,         xmm2
          VMOVSS xmm1,         xmm2, xmm3
          VMOVSS xmm1 {k1}{z}, xmm2, xmm3
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mul_ps (__m128 a, __m128 b)
           MULPS xmm1,               xmm2/m128
          VMULPS xmm1,         xmm2, xmm3/m128
          VMULPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mul_ps (__m128 a, __m128 b)
           MULPS xmm1,               xmm2/m128
          VMULPS xmm1,         xmm2, xmm3/m128
          VMULPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def MultiplyScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mul_ss (__m128 a, __m128 b)
           MULSS xmm1,       xmm2/m32
          VMULSS xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def MultiplyScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mul_ss (__m128 a, __m128 b)
           MULSS xmm1,       xmm2/m32
          VMULSS xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_or_ps (__m128 a,  __m128 b)
           ORPS xmm1,               xmm2/m128
          VORPS xmm1,         xmm2, xmm3/m128
          VORPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_or_ps (__m128 a,  __m128 b)
           ORPS xmm1,               xmm2/m128
          VORPS xmm1,         xmm2, xmm3/m128
          VORPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Prefetch0(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHT0 m8
        """
        ...

    @staticmethod
    @overload
    def Prefetch0(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHT0 m8
        """
        ...

    @staticmethod
    @overload
    def Prefetch1(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHT1 m8
        """
        ...

    @staticmethod
    @overload
    def Prefetch1(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHT1 m8
        """
        ...

    @staticmethod
    @overload
    def Prefetch2(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHT2 m8
        """
        ...

    @staticmethod
    @overload
    def Prefetch2(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHT2 m8
        """
        ...

    @staticmethod
    @overload
    def PrefetchNonTemporal(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHNTA m8
        """
        ...

    @staticmethod
    @overload
    def PrefetchNonTemporal(address: typing.Any) -> None:
        """
        void _mm_prefetch(char* p, int i)
          PREFETCHNTA m8
        """
        ...

    @staticmethod
    @overload
    def Reciprocal(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rcp_ps (__m128 a)
           RCPPS xmm1, xmm2/m128
          VRCPPS xmm1, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def Reciprocal(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rcp_ps (__m128 a)
           RCPPS xmm1, xmm2/m128
          VRCPPS xmm1, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ReciprocalScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rcp_ss (__m128 a)
           RCPSS xmm1,       xmm2/m32
          VRCPSS xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def ReciprocalScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rcp_ss (__m128 a, __m128 b)
           RCPSS xmm1,       xmm2/m32
          VRCPSS xmm1, xmm2, xmm3/m32
        The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs.
        """
        ...

    @staticmethod
    @overload
    def ReciprocalScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rcp_ss (__m128 a)
           RCPSS xmm1,       xmm2/m32
          VRCPSS xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def ReciprocalScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rcp_ss (__m128 a, __m128 b)
           RCPSS xmm1,       xmm2/m32
          VRCPSS xmm1, xmm2, xmm3/m32
        The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs.
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rsqrt_ps (__m128 a)
           RSQRTPS xmm1, xmm2/m128
          VRSQRTPS xmm1, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rsqrt_ps (__m128 a)
           RSQRTPS xmm1, xmm2/m128
          VRSQRTPS xmm1, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrtScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rsqrt_ss (__m128 a)
           RSQRTSS xmm1,       xmm2/m32
          VRSQRTSS xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrtScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rsqrt_ss (__m128 a, __m128 b)
           RSQRTSS xmm1,       xmm2/m32
          VRSQRTSS xmm1, xmm2, xmm3/m32
        The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs.
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrtScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rsqrt_ss (__m128 a)
           RSQRTSS xmm1,       xmm2/m32
          VRSQRTSS xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrtScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_rsqrt_ss (__m128 a, __m128 b)
           RSQRTSS xmm1,       xmm2/m32
          VRSQRTSS xmm1, xmm2, xmm3/m32
        The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs.
        """
        ...

    @staticmethod
    @overload
    def Shuffle(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_shuffle_ps (__m128 a,  __m128 b, unsigned int control)
           SHUFPS xmm1,               xmm2/m128,         imm8
          VSHUFPS xmm1,         xmm2, xmm3/m128,         imm8
          VSHUFPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_shuffle_ps (__m128 a,  __m128 b, unsigned int control)
           SHUFPS xmm1,               xmm2/m128,         imm8
          VSHUFPS xmm1,         xmm2, xmm3/m128,         imm8
          VSHUFPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sqrt_ps (__m128 a)
           SQRTPS xmm1,         xmm2/m128
          VSQRTPS xmm1,         xmm2/m128
          VSQRTPS xmm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sqrt_ps (__m128 a)
           SQRTPS xmm1,         xmm2/m128
          VSQRTPS xmm1,         xmm2/m128
          VSQRTPS xmm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sqrt_ss (__m128 a)
           SQRTSS xmm1,               xmm2/m32
          VSQRTSS xmm1,         xmm2, xmm3/m32
          VSQRTSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sqrt_ss (__m128 a, __m128 b)
           SQRTSS xmm1,               xmm2/m32
          VSQRTSS xmm1,         xmm2, xmm3/m32
          VSQRTSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}
        The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs.
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sqrt_ss (__m128 a)
           SQRTSS xmm1,               xmm2/m32
          VSQRTSS xmm1,         xmm2, xmm3/m32
          VSQRTSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sqrt_ss (__m128 a, __m128 b)
           SQRTSS xmm1,               xmm2/m32
          VSQRTSS xmm1,         xmm2, xmm3/m32
          VSQRTSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}
        The above native signature does not exist. We provide this additional overload for consistency with the other scalar APIs.
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeu_ps (float* mem_addr, __m128 a)
           MOVUPS m128,         xmm1
          VMOVUPS m128,         xmm1
          VMOVUPS m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeu_ps (float* mem_addr, __m128 a)
           MOVAPS m128,         xmm1
          VMOVAPS m128,         xmm1
          VMOVAPS m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_ps (float* mem_addr, __m128 a)
           MOVAPS m128,         xmm1
          VMOVAPS m128,         xmm1
          VMOVAPS m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_ps (float* mem_addr, __m128 a)
           MOVAPS m128,         xmm1
          VMOVAPS m128,         xmm1
          VMOVAPS m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_stream_ps (float* mem_addr, __m128 a)
           MOVNTPS m128, xmm1
          VMOVNTPS m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_stream_ps (float* mem_addr, __m128 a)
           MOVNTPS m128, xmm1
          VMOVNTPS m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreFence() -> None:
        """
        void _mm_sfence(void)
          SFENCE
        """
        ...

    @staticmethod
    @overload
    def StoreFence() -> None:
        """
        void _mm_sfence(void)
          SFENCE
        """
        ...

    @staticmethod
    @overload
    def StoreHigh(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeh_pi (__m64* mem_addr, __m128 a)
           MOVHPS m64, xmm1
          VMOVHPS m64, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreHigh(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeh_pi (__m64* mem_addr, __m128 a)
           MOVHPS m64, xmm1
          VMOVHPS m64, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreLow(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storel_pi (__m64* mem_addr, __m128 a)
           MOVLPS m64, xmm1
          VMOVLPS m64, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreLow(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storel_pi (__m64* mem_addr, __m128 a)
           MOVLPS m64, xmm1
          VMOVLPS m64, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_ss (float* mem_addr, __m128 a)
           MOVSS m32,      xmm1
          VMOVSS m32,      xmm1
          VMOVSS m32 {k1}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_ss (float* mem_addr, __m128 a)
           MOVSS m32,      xmm1
          VMOVSS m32,      xmm1
          VMOVSS m32 {k1}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sub_ps (__m128d a, __m128d b)
           SUBPS xmm1,               xmm2/m128
          VSUBPS xmm1,         xmm2, xmm3/m128
          VSUBPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sub_ps (__m128d a, __m128d b)
           SUBPS xmm1,               xmm2/m128
          VSUBPS xmm1,         xmm2, xmm3/m128
          VSUBPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def SubtractScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sub_ss (__m128 a, __m128 b)
           SUBSS xmm1,               xmm2/m32
          VSUBSS xmm1,         xmm2, xmm3/m32
          VSUBSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}
        """
        ...

    @staticmethod
    @overload
    def SubtractScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_sub_ss (__m128 a, __m128 b)
           SUBSS xmm1,               xmm2/m32
          VSUBSS xmm1,         xmm2, xmm3/m32
          VSUBSS xmm1 {k1}{z}, xmm2, xmm3/m32{er}
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_unpackhi_ps (__m128 a,  __m128 b)
           UNPCKHPS xmm1,               xmm2/m128
          VUNPCKHPS xmm1,         xmm2, xmm3/m128
          VUNPCKHPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_unpackhi_ps (__m128 a,  __m128 b)
           UNPCKHPS xmm1,               xmm2/m128
          VUNPCKHPS xmm1,         xmm2, xmm3/m128
          VUNPCKHPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_unpacklo_ps (__m128 a,  __m128 b)
           UNPCKLPS xmm1,               xmm2/m128
          VUNPCKLPS xmm1,         xmm2, xmm3/m128
          VUNPCKLPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_unpacklo_ps (__m128 a,  __m128 b)
           UNPCKLPS xmm1,               xmm2/m128
          VUNPCKLPS xmm1,         xmm2, xmm3/m128
          VUNPCKLPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_xor_ps (__m128 a,  __m128 b)
           XORPS xmm1,               xmm2/m128
          VXORPS xmm1,         xmm2, xmm3/m128
          VXORPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_xor_ps (__m128 a,  __m128 b)
           XORPS xmm1,               xmm2/m128
          VXORPS xmm1,         xmm2, xmm3/m128
          VXORPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...


class Sse2(System.Runtime.Intrinsics.X86.Sse, metaclass=abc.ABCMeta):
    """This class provides access to Intel SSE2 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def ConvertScalarToVector128Double(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """
            __m128d _mm_cvtsi64_sd (__m128d a, __int64 b)
               CVTSI2SD xmm1,       r/m64
              VCVTSI2SD xmm1, xmm2, r/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertScalarToVector128Double(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
            """
            __m128d _mm_cvtsi64_sd (__m128d a, __int64 b)
               CVTSI2SD xmm1,       r/m64
              VCVTSI2SD xmm1, xmm2, r/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertScalarToVector128Int64(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_cvtsi64_si128 (__int64 a)
               MOVQ xmm1, r/m64
              VMOVQ xmm1, r/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertScalarToVector128Int64(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_cvtsi64_si128 (__int64 a)
               MOVQ xmm1, r/m64
              VMOVQ xmm1, r/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertScalarToVector128UInt64(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_cvtsi64_si128 (__int64 a)
               MOVQ xmm1, r/m64
              VMOVQ xmm1, r/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertScalarToVector128UInt64(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_cvtsi64_si128 (__int64 a)
               MOVQ xmm1, r/m64
              VMOVQ xmm1, r/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
            """
            __int64 _mm_cvtsi128_si64 (__m128i a)
               MOVQ r/m64, xmm1
              VMOVQ r/m64, xmm1
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvtsd_si64 (__m128d a)
               CVTSD2SI r64, xmm1/m64
              VCVTSD2SI r64, xmm1/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
            """
            __int64 _mm_cvtsi128_si64 (__m128i a)
               MOVQ r/m64, xmm1
              VMOVQ r/m64, xmm1
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvtsd_si64 (__m128d a)
               CVTSD2SI r64, xmm1/m64
              VCVTSD2SI r64, xmm1/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvttsd_si64 (__m128d a)
               CVTTSD2SI r64, xmm1/m64
              VCVTTSD2SI r64, xmm1/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToInt64WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
            """
            __int64 _mm_cvttsd_si64 (__m128d a)
               CVTTSD2SI r64, xmm1/m64
              VCVTTSD2SI r64, xmm1/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToUInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
            """
            __int64 _mm_cvtsi128_si64 (__m128i a)
               MOVQ r/m64, xmm1
              VMOVQ r/m64, xmm1
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def ConvertToUInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
            """
            __int64 _mm_cvtsi128_si64 (__m128i a)
               MOVQ r/m64, xmm1
              VMOVQ r/m64, xmm1
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def StoreNonTemporal(address: typing.Any, value: int) -> None:
            """
            void _mm_stream_si64(__int64 *p, __int64 a)
              MOVNTI m64, r64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def StoreNonTemporal(address: typing.Any, value: int) -> None:
            """
            void _mm_stream_si64(__int64 *p, __int64 a)
              MOVNTI m64, r64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def StoreNonTemporal(address: typing.Any, value: int) -> None:
            """
            void _mm_stream_si64(__int64 *p, __int64 a)
              MOVNTI m64, r64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def StoreNonTemporal(address: typing.Any, value: int) -> None:
            """
            void _mm_stream_si64(__int64 *p, __int64 a)
              MOVNTI m64, r64
            This intrinsic is only available on 64-bit processes
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi8 (__m128i a,  __m128i b)
           PADDB xmm1,               xmm2/m128
          VPADDB xmm1,         xmm2, xmm3/m128
          VPADDB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi8 (__m128i a,  __m128i b)
           PADDB xmm1,               xmm2/m128
          VPADDB xmm1,         xmm2, xmm3/m128
          VPADDB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi16 (__m128i a,  __m128i b)
           PADDW xmm1,               xmm2/m128
          VPADDW xmm1,         xmm2, xmm3/m128
          VPADDW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi16 (__m128i a,  __m128i b)
           PADDW xmm1,               xmm2/m128
          VPADDW xmm1,         xmm2, xmm3/m128
          VPADDW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi32 (__m128i a,  __m128i b)
           PADDD xmm1,               xmm2/m128
          VPADDD xmm1,         xmm2, xmm3/m128
          VPADDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi32 (__m128i a,  __m128i b)
           PADDD xmm1,               xmm2/m128
          VPADDD xmm1,         xmm2, xmm3/m128
          VPADDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi64 (__m128i a,  __m128i b)
           PADDQ xmm1,               xmm2/m128
          VPADDQ xmm1,         xmm2, xmm3/m128
          VPADDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi64 (__m128i a,  __m128i b)
           PADDQ xmm1,               xmm2/m128
          VPADDQ xmm1,         xmm2, xmm3/m128
          VPADDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_add_pd (__m128d a,  __m128d b)
           ADDPD xmm1,               xmm2/m128
          VADDPD xmm1,         xmm2, xmm3/m128
          VADDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi8 (__m128i a,  __m128i b)
           PADDB xmm1,               xmm2/m128
          VPADDB xmm1,         xmm2, xmm3/m128
          VPADDB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi8 (__m128i a,  __m128i b)
           PADDB xmm1,               xmm2/m128
          VPADDB xmm1,         xmm2, xmm3/m128
          VPADDB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi16 (__m128i a,  __m128i b)
           PADDW xmm1,               xmm2/m128
          VPADDW xmm1,         xmm2, xmm3/m128
          VPADDW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi16 (__m128i a,  __m128i b)
           PADDW xmm1,               xmm2/m128
          VPADDW xmm1,         xmm2, xmm3/m128
          VPADDW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi32 (__m128i a,  __m128i b)
           PADDD xmm1,               xmm2/m128
          VPADDD xmm1,         xmm2, xmm3/m128
          VPADDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi32 (__m128i a,  __m128i b)
           PADDD xmm1,               xmm2/m128
          VPADDD xmm1,         xmm2, xmm3/m128
          VPADDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi64 (__m128i a,  __m128i b)
           PADDQ xmm1,               xmm2/m128
          VPADDQ xmm1,         xmm2, xmm3/m128
          VPADDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_add_epi64 (__m128i a,  __m128i b)
           PADDQ xmm1,               xmm2/m128
          VPADDQ xmm1,         xmm2, xmm3/m128
          VPADDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_add_pd (__m128d a,  __m128d b)
           ADDPD xmm1,               xmm2/m128
          VADDPD xmm1,         xmm2, xmm3/m128
          VADDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epi8 (__m128i a,  __m128i b)
           PADDSB xmm1,               xmm2/m128
          VPADDSB xmm1,         xmm2, xmm3/m128
          VPADDSB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epu8 (__m128i a,  __m128i b)
           PADDUSB xmm1,               xmm2/m128
          VPADDUSB xmm1,         xmm2, xmm3/m128
          VPADDUSB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epi16 (__m128i a,  __m128i b)
           PADDSW xmm1,               xmm2/m128
          VPADDSW xmm1,         xmm2, xmm3/m128
          VPADDSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epu16 (__m128i a,  __m128i b)
           PADDUSW xmm1,               xmm2/m128
          VPADDUSW xmm1,         xmm2, xmm3/m128
          VPADDUSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epi8 (__m128i a,  __m128i b)
           PADDSB xmm1,               xmm2/m128
          VPADDSB xmm1,         xmm2, xmm3/m128
          VPADDSB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epu8 (__m128i a,  __m128i b)
           PADDUSB xmm1,               xmm2/m128
          VPADDUSB xmm1,         xmm2, xmm3/m128
          VPADDUSB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epi16 (__m128i a,  __m128i b)
           PADDSW xmm1,               xmm2/m128
          VPADDSW xmm1,         xmm2, xmm3/m128
          VPADDSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_adds_epu16 (__m128i a,  __m128i b)
           PADDUSW xmm1,               xmm2/m128
          VPADDUSW xmm1,         xmm2, xmm3/m128
          VPADDUSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AddScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_add_sd (__m128d a,  __m128d b)
           ADDSD xmm1,               xmm2/m64
          VADDSD xmm1,         xmm2, xmm3/m64
          VADDSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}
        """
        ...

    @staticmethod
    @overload
    def AddScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_add_sd (__m128d a,  __m128d b)
           ADDSD xmm1,               xmm2/m64
          VADDSD xmm1,         xmm2, xmm3/m64
          VADDSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND xmm1,       xmm2/m128
          VPAND xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND xmm1,       xmm2/m128
          VPAND xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND xmm1,       xmm2/m128
          VPAND xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND xmm1,       xmm2/m128
          VPAND xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND  xmm1,               xmm2/m128
          VPAND  xmm1,         xmm2, xmm3/m128
          VPANDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND  xmm1,               xmm2/m128
          VPAND  xmm1,         xmm2, xmm3/m128
          VPANDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND  xmm1,               xmm2/m128
          VPAND  xmm1,         xmm2, xmm3/m128
          VPANDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND  xmm1,               xmm2/m128
          VPAND  xmm1,         xmm2, xmm3/m128
          VPANDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_and_pd (__m128d a, __m128d b)
           ANDPD xmm1,               xmm2/m128
          VANDPD xmm1,         xmm2, xmm3/m128
          VANDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND xmm1,       xmm2/m128
          VPAND xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND xmm1,       xmm2/m128
          VPAND xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND xmm1,       xmm2/m128
          VPAND xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND xmm1,       xmm2/m128
          VPAND xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND  xmm1,               xmm2/m128
          VPAND  xmm1,         xmm2, xmm3/m128
          VPANDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND  xmm1,               xmm2/m128
          VPAND  xmm1,         xmm2, xmm3/m128
          VPANDD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND  xmm1,               xmm2/m128
          VPAND  xmm1,         xmm2, xmm3/m128
          VPANDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_and_si128 (__m128i a,  __m128i b)
           PAND  xmm1,               xmm2/m128
          VPAND  xmm1,         xmm2, xmm3/m128
          VPANDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_and_pd (__m128d a, __m128d b)
           ANDPD xmm1,               xmm2/m128
          VANDPD xmm1,         xmm2, xmm3/m128
          VANDPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN xmm1,       xmm2/m128
          VPANDN xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN xmm1,       xmm2/m128
          VPANDN xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN xmm1,       xmm2/m128
          VPANDN xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN xmm1,       xmm2/m128
          VPANDN xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN  xmm1,               xmm2/m128
          VPANDN  xmm1,         xmm2, xmm3/m128
          VPANDND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN  xmm1,               xmm2/m128
          VPANDN  xmm1,         xmm2, xmm3/m128
          VPANDND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN  xmm1,               xmm2/m128
          VPANDN  xmm1,         xmm2, xmm3/m128
          VPANDNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN  xmm1,               xmm2/m128
          VPANDN  xmm1,         xmm2, xmm3/m128
          VPANDNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_andnot_pd (__m128d a, __m128d b)
           ANDNPD xmm1,               xmm2/m128
          VANDNPD xmm1,         xmm2, xmm3/m128
          VANDNPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN xmm1,       xmm2/m128
          VPANDN xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN xmm1,       xmm2/m128
          VPANDN xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN xmm1,       xmm2/m128
          VPANDN xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN xmm1,       xmm2/m128
          VPANDN xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN  xmm1,               xmm2/m128
          VPANDN  xmm1,         xmm2, xmm3/m128
          VPANDND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN  xmm1,               xmm2/m128
          VPANDN  xmm1,         xmm2, xmm3/m128
          VPANDND xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN  xmm1,               xmm2/m128
          VPANDN  xmm1,         xmm2, xmm3/m128
          VPANDNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_andnot_si128 (__m128i a,  __m128i b)
           PANDN  xmm1,               xmm2/m128
          VPANDN  xmm1,         xmm2, xmm3/m128
          VPANDNQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_andnot_pd (__m128d a, __m128d b)
           ANDNPD xmm1,               xmm2/m128
          VANDNPD xmm1,         xmm2, xmm3/m128
          VANDNPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_avg_epu8 (__m128i a,  __m128i b)
           PAVGB xmm1,               xmm2/m128
          VPAVGB xmm1,         xmm2, xmm3/m128
          VPAVGB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_avg_epu16 (__m128i a,  __m128i b)
           PAVGW xmm1,               xmm2/m128
          VPAVGW xmm1,         xmm2, xmm3/m128
          VPAVGW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_avg_epu8 (__m128i a,  __m128i b)
           PAVGB xmm1,               xmm2/m128
          VPAVGB xmm1,         xmm2, xmm3/m128
          VPAVGB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_avg_epu16 (__m128i a,  __m128i b)
           PAVGW xmm1,               xmm2/m128
          VPAVGW xmm1,         xmm2, xmm3/m128
          VPAVGW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi8 (__m128i a,  __m128i b)
           PCMPEQB xmm1,       xmm2/m128
          VPCMPEQB xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi8 (__m128i a,  __m128i b)
           PCMPEQB xmm1,       xmm2/m128
          VPCMPEQB xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi16 (__m128i a,  __m128i b)
           PCMPEQW xmm1,       xmm2/m128
          VPCMPEQW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi16 (__m128i a,  __m128i b)
           PCMPEQW xmm1,       xmm2/m128
          VPCMPEQW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi32 (__m128i a,  __m128i b)
           PCMPEQD xmm1,       xmm2/m128
          VPCMPEQD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi32 (__m128i a,  __m128i b)
           PCMPEQD xmm1,       xmm2/m128
          VPCMPEQD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpeq_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(0)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi8 (__m128i a,  __m128i b)
           PCMPEQB xmm1,       xmm2/m128
          VPCMPEQB xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi8 (__m128i a,  __m128i b)
           PCMPEQB xmm1,       xmm2/m128
          VPCMPEQB xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi16 (__m128i a,  __m128i b)
           PCMPEQW xmm1,       xmm2/m128
          VPCMPEQW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi16 (__m128i a,  __m128i b)
           PCMPEQW xmm1,       xmm2/m128
          VPCMPEQW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi32 (__m128i a,  __m128i b)
           PCMPEQD xmm1,       xmm2/m128
          VPCMPEQD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi32 (__m128i a,  __m128i b)
           PCMPEQD xmm1,       xmm2/m128
          VPCMPEQD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpeq_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(0)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi8 (__m128i a,  __m128i b)
           PCMPGTB xmm1,       xmm2/m128
          VPCMPGTB xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi16 (__m128i a,  __m128i b)
           PCMPGTW xmm1,       xmm2/m128
          VPCMPGTW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi32 (__m128i a,  __m128i b)
           PCMPGTD xmm1,       xmm2/m128
          VPCMPGTD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpgt_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(1)   ; with swapped operands
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(1)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi8 (__m128i a,  __m128i b)
           PCMPGTB xmm1,       xmm2/m128
          VPCMPGTB xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi16 (__m128i a,  __m128i b)
           PCMPGTW xmm1,       xmm2/m128
          VPCMPGTW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi32 (__m128i a,  __m128i b)
           PCMPGTD xmm1,       xmm2/m128
          VPCMPGTD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpgt_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(1)   ; with swapped operands
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(1)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpge_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(2)   ; with swapped operands
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(2)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpge_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(2)   ; with swapped operands
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(2)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmplt_epi8 (__m128i a,  __m128i b)
           PCMPGTB xmm1,       xmm2/m128    ; with swapped operands
          VPCMPGTB xmm1, xmm2, xmm3/m128    ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmplt_epi16 (__m128i a,  __m128i b)
           PCMPGTW xmm1,       xmm2/m128    ; with swapped operands
          VPCMPGTW xmm1, xmm2, xmm3/m128    ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmplt_epi32 (__m128i a,  __m128i b)
           PCMPGTD xmm1,       xmm2/m128    ; with swapped operands
          VPCMPGTD xmm1, xmm2, xmm3/m128    ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmplt_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(1)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmplt_epi8 (__m128i a,  __m128i b)
           PCMPGTB xmm1,       xmm2/m128    ; with swapped operands
          VPCMPGTB xmm1, xmm2, xmm3/m128    ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmplt_epi16 (__m128i a,  __m128i b)
           PCMPGTW xmm1,       xmm2/m128    ; with swapped operands
          VPCMPGTW xmm1, xmm2, xmm3/m128    ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmplt_epi32 (__m128i a,  __m128i b)
           PCMPGTD xmm1,       xmm2/m128    ; with swapped operands
          VPCMPGTD xmm1, xmm2, xmm3/m128    ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmplt_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(1)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmple_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(2)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmple_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(2)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpneq_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(4)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpneq_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(4)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpngt_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(5)   ; with swapped operands
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(5)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpngt_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(5)   ; with swapped operands
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(5)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnge_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(6)   ; with swapped operands
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(6)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnge_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(6)   ; with swapped operands
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(6)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnlt_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(5)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnlt_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(5)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnle_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(6)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnle_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(6)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpord_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(7)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpord_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(7)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpeq_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(0)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpeq_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(0)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(0)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpgt_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(1)   ; with swapped operands
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(1)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpgt_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(1)   ; with swapped operands
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(1)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpge_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(2)   ; with swapped operands
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(2)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpge_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(2)   ; with swapped operands
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(2)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmplt_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(1)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmplt_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(1)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmple_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(2)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmple_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(2)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(2)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpneq_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(4)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpneq_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(4)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(4)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpngt_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(5)   ; with swapped operands
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(5)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpngt_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(5)   ; with swapped operands
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(5)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnge_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(6)   ; with swapped operands
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(6)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnge_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(6)   ; with swapped operands
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(6)   ; with swapped operands
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnlt_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(5)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnlt_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(5)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(5)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnle_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(6)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpnle_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(6)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(6)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpord_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(7)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrdered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpord_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(7)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(7)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comieq_sd (__m128d a, __m128d b)
           COMISD xmm1, xmm2/m64        ; ZF=1 && PF=0
          VCOMISD xmm1, xmm2/m64        ; ZF=1 && PF=0
          VCOMISD xmm1, xmm2/m64{sae}   ; ZF=1 && PF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comieq_sd (__m128d a, __m128d b)
           COMISD xmm1, xmm2/m64        ; ZF=1 && PF=0
          VCOMISD xmm1, xmm2/m64        ; ZF=1 && PF=0
          VCOMISD xmm1, xmm2/m64{sae}   ; ZF=1 && PF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comigt_sd (__m128d a, __m128d b)
           COMISD xmm1, xmm2/m64        ; ZF=0 && CF=0
          VCOMISD xmm1, xmm2/m64        ; ZF=0 && CF=0
          VCOMISD xmm1, xmm2/m64{sae}   ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comigt_sd (__m128d a, __m128d b)
           COMISD xmm1, xmm2/m64        ; ZF=0 && CF=0
          VCOMISD xmm1, xmm2/m64        ; ZF=0 && CF=0
          VCOMISD xmm1, xmm2/m64{sae}   ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comige_sd (__m128d a, __m128d b)
           COMISD xmm1, xmm2/m64        ; CF=0
          VCOMISD xmm1, xmm2/m64        ; CF=0
          VCOMISD xmm1, xmm2/m64{sae}   ; CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comige_sd (__m128d a, __m128d b)
           COMISD xmm1, xmm2/m64        ; CF=0
          VCOMISD xmm1, xmm2/m64        ; CF=0
          VCOMISD xmm1, xmm2/m64{sae}   ; CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comilt_sd (__m128d a, __m128d b)
           COMISD xmm1, xmm2/m64        ; PF=0 && CF=1
          VCOMISD xmm1, xmm2/m64        ; PF=0 && CF=1
          VCOMISD xmm1, xmm2/m64{sae}   ; PF=0 && CF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comilt_sd (__m128d a, __m128d b)
           COMISD xmm1, xmm2/m64        ; PF=0 && CF=1
          VCOMISD xmm1, xmm2/m64        ; PF=0 && CF=1
          VCOMISD xmm1, xmm2/m64{sae}   ; PF=0 && CF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comile_sd (__m128d a, __m128d b)
           COMISD xmm1, xmm2/m64        ; PF=0 && (ZF=1 || CF=1)
          VCOMISD xmm1, xmm2/m64        ; PF=0 && (ZF=1 || CF=1)
          VCOMISD xmm1, xmm2/m64{sae}   ; PF=0 && (ZF=1 || CF=1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comile_sd (__m128d a, __m128d b)
           COMISD xmm1, xmm2/m64        ; PF=0 && (ZF=1 || CF=1)
          VCOMISD xmm1, xmm2/m64        ; PF=0 && (ZF=1 || CF=1)
          VCOMISD xmm1, xmm2/m64{sae}   ; PF=0 && (ZF=1 || CF=1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comineq_sd (__m128d a, __m128d b)
           COMISD xmm1, xmm2/m64        ; ZF=0 || PF=1
          VCOMISD xmm1, xmm2/m64        ; ZF=0 || PF=1
          VCOMISD xmm1, xmm2/m64{sae}   ; ZF=0 || PF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarOrderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_comineq_sd (__m128d a, __m128d b)
           COMISD xmm1, xmm2/m64        ; ZF=0 || PF=1
          VCOMISD xmm1, xmm2/m64        ; ZF=0 || PF=1
          VCOMISD xmm1, xmm2/m64{sae}   ; ZF=0 || PF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpunord_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(3)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpunord_sd (__m128d a,  __m128d b)
           CMPDS xmm1,       xmm2/m64, imm8(3)
          VCMPDS xmm1, xmm2, xmm3/m64, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomieq_sd (__m128d a, __m128d b)
           UCOMISD xmm1, xmm2/m64       ; ZF=1 && PF=0
          VUCOMISD xmm1, xmm2/m64       ; ZF=1 && PF=0
          VUCOMISD xmm1, xmm2/m64{sae}  ; ZF=1 && PF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomieq_sd (__m128d a, __m128d b)
           UCOMISD xmm1, xmm2/m64       ; ZF=1 && PF=0
          VUCOMISD xmm1, xmm2/m64       ; ZF=1 && PF=0
          VUCOMISD xmm1, xmm2/m64{sae}  ; ZF=1 && PF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomigt_sd (__m128d a, __m128d b)
           UCOMISD xmm1, xmm2/m64       ; ZF=0 && CF=0
          VUCOMISD xmm1, xmm2/m64       ; ZF=0 && CF=0
          VUCOMISD xmm1, xmm2/m64{sae}  ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomigt_sd (__m128d a, __m128d b)
           UCOMISD xmm1, xmm2/m64       ; ZF=0 && CF=0
          VUCOMISD xmm1, xmm2/m64       ; ZF=0 && CF=0
          VUCOMISD xmm1, xmm2/m64{sae}  ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomige_sd (__m128d a, __m128d b)
           UCOMISD xmm1, xmm2/m64       ; CF=0
          VUCOMISD xmm1, xmm2/m64       ; CF=0
          VUCOMISD xmm1, xmm2/m64{sae}  ; CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomige_sd (__m128d a, __m128d b)
           UCOMISD xmm1, xmm2/m64       ; CF=0
          VUCOMISD xmm1, xmm2/m64       ; CF=0
          VUCOMISD xmm1, xmm2/m64{sae}  ; CF=0
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomilt_sd (__m128d a, __m128d b)
           UCOMISD xmm1, xmm2/m64       ; PF=0 && CF=1
          VUCOMISD xmm1, xmm2/m64       ; PF=0 && CF=1
          VUCOMISD xmm1, xmm2/m64{sae}  ; PF=0 && CF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThan(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomilt_sd (__m128d a, __m128d b)
           UCOMISD xmm1, xmm2/m64       ; PF=0 && CF=1
          VUCOMISD xmm1, xmm2/m64       ; PF=0 && CF=1
          VUCOMISD xmm1, xmm2/m64{sae}  ; PF=0 && CF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomile_sd (__m128d a, __m128d b)
           UCOMISD xmm1, xmm2/m64       ; PF=0 && (ZF=1 || CF=1)
          VUCOMISD xmm1, xmm2/m64       ; PF=0 && (ZF=1 || CF=1)
          VUCOMISD xmm1, xmm2/m64{sae}  ; PF=0 && (ZF=1 || CF=1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedLessThanOrEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomile_sd (__m128d a, __m128d b)
           UCOMISD xmm1, xmm2/m64       ; PF=0 && (ZF=1 || CF=1)
          VUCOMISD xmm1, xmm2/m64       ; PF=0 && (ZF=1 || CF=1)
          VUCOMISD xmm1, xmm2/m64{sae}  ; PF=0 && (ZF=1 || CF=1)
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomineq_sd (__m128d a, __m128d b)
           UCOMISD xmm1, xmm2/m64       ; ZF=0 || PF=1
          VUCOMISD xmm1, xmm2/m64       ; ZF=0 || PF=1
          VUCOMISD xmm1, xmm2/m64{sae}  ; ZF=0 || PF=1
        """
        ...

    @staticmethod
    @overload
    def CompareScalarUnorderedNotEqual(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_ucomineq_sd (__m128d a, __m128d b)
           UCOMISD xmm1, xmm2/m64       ; ZF=0 || PF=1
          VUCOMISD xmm1, xmm2/m64       ; ZF=0 || PF=1
          VUCOMISD xmm1, xmm2/m64{sae}  ; ZF=0 || PF=1
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpunord_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(3)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmpunord_pd (__m128d a,  __m128d b)
           CMPPD xmm1,       xmm2/m128, imm8(3)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8(3)
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Double(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtsi32_sd (__m128d a, int b)
           CVTSI2SD xmm1,       r/m32
          VCVTSI2SD xmm1, xmm2, r/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Double(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtss_sd (__m128d a, __m128 b)
           CVTSS2SD xmm1,       xmm2/m32
          VCVTSS2SD xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Double(upper: System.Runtime.Intrinsics.Vector128[float], value: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtsi32_sd (__m128d a, int b)
           CVTSI2SD xmm1,       r/m32
          VCVTSI2SD xmm1, xmm2, r/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Double(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtss_sd (__m128d a, __m128 b)
           CVTSS2SD xmm1,       xmm2/m32
          VCVTSS2SD xmm1, xmm2, xmm3/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Int32(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtsi32_si128 (int a)
           MOVD xmm1, r/m32
          VMOVD xmm1, r/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Int32(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtsi32_si128 (int a)
           MOVD xmm1, r/m32
          VMOVD xmm1, r/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Single(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtsd_ss (__m128 a, __m128d b)
           CVTSD2SS xmm1,       xmm2/m64
          VCVTSD2SS xmm1, xmm2, xmm3/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128Single(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtsd_ss (__m128 a, __m128d b)
           CVTSD2SS xmm1,       xmm2/m64
          VCVTSD2SS xmm1, xmm2, xmm3/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128UInt32(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtsi32_si128 (int a)
           MOVD xmm1, r/m32
          VMOVD xmm1, r/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertScalarToVector128UInt32(value: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtsi32_si128 (int a)
           MOVD xmm1, r/m32
          VMOVD xmm1, r/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_cvtsi128_si32 (__m128i a)
           MOVD r/m32, xmm1
          VMOVD r/m32, xmm1
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvtsd_si32 (__m128d a)
           CVTSD2SI r32, xmm1/m64
          VCVTSD2SI r32, xmm1/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_cvtsi128_si32 (__m128i a)
           MOVD r/m32, xmm1
          VMOVD r/m32, xmm1
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvtsd_si32 (__m128d a)
           CVTSD2SI r32, xmm1/m64
          VCVTSD2SI r32, xmm1/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvttsd_si32 (__m128d a)
           CVTTSD2SI r32, xmm1/m64
          VCVTTSD2SI r32, xmm1/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_cvttsd_si32 (__m128d a)
           CVTTSD2SI r32, xmm1/m64
          VCVTTSD2SI r32, xmm1/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToUInt32(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_cvtsi128_si32 (__m128i a)
           MOVD r/m32, xmm1
          VMOVD r/m32, xmm1
        """
        ...

    @staticmethod
    @overload
    def ConvertToUInt32(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_cvtsi128_si32 (__m128i a)
           MOVD r/m32, xmm1
          VMOVD r/m32, xmm1
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtepi32_pd (__m128i a)
           CVTDQ2PD xmm1,         xmm2/m64
          VCVTDQ2PD xmm1,         xmm2/m64
          VCVTDQ2PD xmm1 {k1}{z}, xmm2/m64/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Double(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtps_pd (__m128 a)
           CVTPS2PD xmm1,         xmm2/m64
          VCVTPS2PD xmm1,         xmm2/m64
          VCVTPS2PD xmm1 {k1}{z}, xmm2/m64/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtepi32_pd (__m128i a)
           CVTDQ2PD xmm1,         xmm2/m64
          VCVTDQ2PD xmm1,         xmm2/m64
          VCVTDQ2PD xmm1 {k1}{z}, xmm2/m64/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Double(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cvtps_pd (__m128 a)
           CVTPS2PD xmm1,         xmm2/m64
          VCVTPS2PD xmm1,         xmm2/m64
          VCVTPS2PD xmm1 {k1}{z}, xmm2/m64/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtps_epi32 (__m128 a)
           CVTPS2DQ xmm1,         xmm2/m128
          VCVTPS2DQ xmm1,         xmm2/m128
          VCVTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtpd_epi32 (__m128d a)
           CVTPD2DQ xmm1,         xmm2/m128
          VCVTPD2DQ xmm1,         xmm2/m128
          VCVTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtps_epi32 (__m128 a)
           CVTPS2DQ xmm1,         xmm2/m128
          VCVTPS2DQ xmm1,         xmm2/m128
          VCVTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtpd_epi32 (__m128d a)
           CVTPD2DQ xmm1,         xmm2/m128
          VCVTPD2DQ xmm1,         xmm2/m128
          VCVTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvttps_epi32 (__m128 a)
           CVTTPS2DQ xmm1,         xmm2/m128
          VCVTTPS2DQ xmm1,         xmm2/m128
          VCVTTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvttpd_epi32 (__m128d a)
           CVTTPD2DQ xmm1,         xmm2/m128
          VCVTTPD2DQ xmm1,         xmm2/m128
          VCVTTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvttps_epi32 (__m128 a)
           CVTTPS2DQ xmm1,         xmm2/m128
          VCVTTPS2DQ xmm1,         xmm2/m128
          VCVTTPS2DQ xmm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32WithTruncation(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvttpd_epi32 (__m128d a)
           CVTTPD2DQ xmm1,         xmm2/m128
          VCVTTPD2DQ xmm1,         xmm2/m128
          VCVTTPD2DQ xmm1 {k1}{z}, xmm2/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Single(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtepi32_ps (__m128i a)
           CVTDQ2PS xmm1,         xmm2/m128
          VCVTDQ2PS xmm1,         xmm2/m128
          VCVTDQ2PS xmm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Single(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtpd_ps (__m128d a)
           CVTPD2PS xmm1,         xmm2/m128
          VCVTPD2PS xmm1,         xmm2/m128
          VCVTPD2PS xmm1 {k1}{z}, xmm2/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Single(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtepi32_ps (__m128i a)
           CVTDQ2PS xmm1,         xmm2/m128
          VCVTDQ2PS xmm1,         xmm2/m128
          VCVTDQ2PS xmm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Single(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cvtpd_ps (__m128d a)
           CVTPD2PS xmm1,         xmm2/m128
          VCVTPD2PS xmm1,         xmm2/m128
          VCVTPD2PS xmm1 {k1}{z}, xmm2/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_div_pd (__m128d a,  __m128d b)
           DIVPD xmm1,               xmm2/m128
          VDIVPD xmm1,         xmm2, xmm3/m128
          VDIVPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_div_pd (__m128d a,  __m128d b)
           DIVPD xmm1,               xmm2/m128
          VDIVPD xmm1,         xmm2, xmm3/m128
          VDIVPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def DivideScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_div_sd (__m128d a,  __m128d b)
           DIVSD xmm1,       xmm2/m64
          VDIVSD xmm1, xmm2, xmm3/m64
        """
        ...

    @staticmethod
    @overload
    def DivideScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_div_sd (__m128d a,  __m128d b)
           DIVSD xmm1,       xmm2/m64
          VDIVSD xmm1, xmm2, xmm3/m64
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi16 (__m128i a,  int immediate)
           PEXTRW r/m16, xmm1, imm8
          VPEXTRW r/m16, xmm1, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi16 (__m128i a,  int immediate)
           PEXTRW r/m16, xmm1, imm8
          VPEXTRW r/m16, xmm1, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi16 (__m128i a,  int i, int immediate)
           PINSRW xmm1,       r/m16, imm8
          VPINSRW xmm1, xmm2, r/m16, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi16 (__m128i a,  int i, int immediate)
           PINSRW xmm1,       r/m16, imm8
          VPINSRW xmm1, xmm2, r/m16, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi16 (__m128i a,  int i, int immediate)
           PINSRW xmm1,       r/m16, imm8
          VPINSRW xmm1, xmm2, r/m16, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi16 (__m128i a,  int i, int immediate)
           PINSRW xmm1,       r/m16, imm8
          VPINSRW xmm1, xmm2, r/m16, imm8
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
          MOVDQA xmm, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA64 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA64 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_load_pd (double const* mem_address)
           MOVAPD xmm1,         m128
          VMOVAPD xmm1,         m128
          VMOVAPD xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA64 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_load_si128 (__m128i const* mem_address)
           MOVDQA   xmm1,         m128
          VMOVDQA   xmm1,         m128
          VMOVDQA64 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_load_pd (double const* mem_address)
           MOVAPD xmm1,         m128
          VMOVAPD xmm1,         m128
          VMOVAPD xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadFence() -> None:
        """
        void _mm_lfence(void)
          LFENCE
        """
        ...

    @staticmethod
    @overload
    def LoadFence() -> None:
        """
        void _mm_lfence(void)
          LFENCE
        """
        ...

    @staticmethod
    @overload
    def LoadHigh(lower: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loadh_pd (__m128d a, double const* mem_addr)
           MOVHPD xmm1,       m64
          VMOVHPD xmm1, xmm2, m64
        """
        ...

    @staticmethod
    @overload
    def LoadHigh(lower: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loadh_pd (__m128d a, double const* mem_addr)
           MOVHPD xmm1,       m64
          VMOVHPD xmm1, xmm2, m64
        """
        ...

    @staticmethod
    @overload
    def LoadLow(upper: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loadl_pd (__m128d a, double const* mem_addr)
           MOVLPD xmm1,       m64
          VMOVLPD xmm1, xmm2, m64
        """
        ...

    @staticmethod
    @overload
    def LoadLow(upper: System.Runtime.Intrinsics.Vector128[float], address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loadl_pd (__m128d a, double const* mem_addr)
           MOVLPD xmm1,       m64
          VMOVLPD xmm1, xmm2, m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si32 (void const* mem_addr)
           MOVD xmm1, m32
          VMOVD xmm1, m32
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si32 (void const* mem_addr)
           MOVD xmm1, m32
          VMOVD xmm1, m32
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadl_epi64 (__m128i const* mem_addr)
           MOVQ xmm1, m64
          VMOVQ xmm1, m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadl_epi64 (__m128i const* mem_addr)
           MOVQ xmm1, m64
          VMOVQ xmm1, m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_load_sd (double const* mem_address)
           MOVSD xmm1,      m64
          VMOVSD xmm1,      m64
          VMOVSD xmm1 {k1}, m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si32 (void const* mem_addr)
           MOVD xmm1, m32
          VMOVD xmm1, m32
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si32 (void const* mem_addr)
           MOVD xmm1, m32
          VMOVD xmm1, m32
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadl_epi64 (__m128i const* mem_addr)
           MOVQ xmm1, m64
          VMOVQ xmm1, m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadl_epi64 (__m128i const* mem_addr)
           MOVQ xmm1, m64
          VMOVQ xmm1, m64
        """
        ...

    @staticmethod
    @overload
    def LoadScalarVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_load_sd (double const* mem_address)
           MOVSD xmm1,      m64
          VMOVSD xmm1,      m64
          VMOVSD xmm1 {k1}, m64
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU  xmm1,         m128
          VMOVDQU  xmm1,         m128
          VMOVDQU8 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU  xmm1,         m128
          VMOVDQU  xmm1,         m128
          VMOVDQU8 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU   xmm1,         m128
          VMOVDQU   xmm1,         m128
          VMOVDQU16 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU   xmm1,         m128
          VMOVDQU   xmm1,         m128
          VMOVDQU16 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU   xmm1,         m128
          VMOVDQU   xmm1,         m128
          VMOVDQU32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU   xmm1,         m128
          VMOVDQU   xmm1,         m128
          VMOVDQU32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU   xmm1,         m128
          VMOVDQU   xmm1,         m128
          VMOVDQU64 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU   xmm1,         m128
          VMOVDQU   xmm1,         m128
          VMOVDQU64 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loadu_pd (double const* mem_address)
           MOVUPD xmm1,         m128
          VMOVUPD xmm1,         m128
          VMOVUPD xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU  xmm1,         m128
          VMOVDQU  xmm1,         m128
          VMOVDQU8 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU  xmm1,         m128
          VMOVDQU  xmm1,         m128
          VMOVDQU8 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU   xmm1,         m128
          VMOVDQU   xmm1,         m128
          VMOVDQU16 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU   xmm1,         m128
          VMOVDQU   xmm1,         m128
          VMOVDQU16 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU   xmm1,         m128
          VMOVDQU   xmm1,         m128
          VMOVDQU32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU   xmm1,         m128
          VMOVDQU   xmm1,         m128
          VMOVDQU32 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU   xmm1,         m128
          VMOVDQU   xmm1,         m128
          VMOVDQU64 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_loadu_si128 (__m128i const* mem_address)
           MOVDQU   xmm1,         m128
          VMOVDQU   xmm1,         m128
          VMOVDQU64 xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def LoadVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loadu_pd (double const* mem_address)
           MOVUPD xmm1,         m128
          VMOVUPD xmm1,         m128
          VMOVUPD xmm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def MaskMove(source: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], address: typing.Any) -> None:
        """
        void _mm_maskmoveu_si128 (__m128i a,  __m128i mask, char* mem_address)
           MASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI
          VMASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI
        """
        ...

    @staticmethod
    @overload
    def MaskMove(source: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], address: typing.Any) -> None:
        """
        void _mm_maskmoveu_si128 (__m128i a,  __m128i mask, char* mem_address)
           MASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI
          VMASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI
        """
        ...

    @staticmethod
    @overload
    def MaskMove(source: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], address: typing.Any) -> None:
        """
        void _mm_maskmoveu_si128 (__m128i a,  __m128i mask, char* mem_address)
           MASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI
          VMASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI
        """
        ...

    @staticmethod
    @overload
    def MaskMove(source: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], address: typing.Any) -> None:
        """
        void _mm_maskmoveu_si128 (__m128i a,  __m128i mask, char* mem_address)
           MASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI
          VMASKMOVDQU xmm1, xmm2    ; Address: EDI/RDI
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epu8 (__m128i a,  __m128i b)
           PMAXUB xmm1,               xmm2/m128
          VPMAXUB xmm1,         xmm2, xmm3/m128
          VPMAXUB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epi16 (__m128i a,  __m128i b)
           PMAXSW xmm1,               xmm2/m128
          VPMAXSW xmm1,         xmm2, xmm3/m128
          VPMAXSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_max_pd (__m128d a,  __m128d b)
           MAXPD xmm1,               xmm2/m128
          VMAXPD xmm1,         xmm2, xmm3/m128
          VMAXPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epu8 (__m128i a,  __m128i b)
           PMAXUB xmm1,               xmm2/m128
          VPMAXUB xmm1,         xmm2, xmm3/m128
          VPMAXUB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epi16 (__m128i a,  __m128i b)
           PMAXSW xmm1,               xmm2/m128
          VPMAXSW xmm1,         xmm2, xmm3/m128
          VPMAXSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_max_pd (__m128d a,  __m128d b)
           MAXPD xmm1,               xmm2/m128
          VMAXPD xmm1,         xmm2, xmm3/m128
          VMAXPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def MaxScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_max_sd (__m128d a,  __m128d b)
           MAXSD xmm1,       xmm2/m64
          VMAXSD xmm1, xmm2, xmm3/m64
        """
        ...

    @staticmethod
    @overload
    def MaxScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_max_sd (__m128d a,  __m128d b)
           MAXSD xmm1,       xmm2/m64
          VMAXSD xmm1, xmm2, xmm3/m64
        """
        ...

    @staticmethod
    @overload
    def MemoryFence() -> None:
        """
        void _mm_mfence(void)
          MFENCE
        """
        ...

    @staticmethod
    @overload
    def MemoryFence() -> None:
        """
        void _mm_mfence(void)
          MFENCE
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epu8 (__m128i a,  __m128i b)
           PMINUB xmm1,               xmm2/m128
          VPMINUB xmm1,         xmm2, xmm3/m128
          VPMINUB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epi16 (__m128i a,  __m128i b)
           PMINSW xmm1,               xmm2/m128
          VPMINSW xmm1,         xmm2, xmm3/m128
          VPMINSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_min_pd (__m128d a,  __m128d b)
           MINPD xmm1,               xmm2/m128
          VMINPD xmm1,         xmm2, xmm3/m128
          VMINPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epu8 (__m128i a,  __m128i b)
           PMINUB xmm1,               xmm2/m128
          VPMINUB xmm1,         xmm2, xmm3/m128
          VPMINUB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epi16 (__m128i a,  __m128i b)
           PMINSW xmm1,               xmm2/m128
          VPMINSW xmm1,         xmm2, xmm3/m128
          VPMINSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_min_pd (__m128d a,  __m128d b)
           MINPD xmm1,               xmm2/m128
          VMINPD xmm1,         xmm2, xmm3/m128
          VMINPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def MinScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_min_sd (__m128d a,  __m128d b)
           MINSD xmm1,       xmm2/m64
          VMINSD xmm1, xmm2, xmm3/m64
        """
        ...

    @staticmethod
    @overload
    def MinScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_min_sd (__m128d a,  __m128d b)
           MINSD xmm1,       xmm2/m64
          VMINSD xmm1, xmm2, xmm3/m64
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_movemask_epi8 (__m128i a)
           PMOVMSKB r32, xmm1
          VPMOVMSKB r32, xmm1
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_movemask_epi8 (__m128i a)
           PMOVMSKB r32, xmm1
          VPMOVMSKB r32, xmm1
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_movemask_pd (__m128d a)
           MOVMSKPD r32, xmm1
          VMOVMSKPD r32, xmm1
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_movemask_epi8 (__m128i a)
           PMOVMSKB r32, xmm1
          VPMOVMSKB r32, xmm1
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[int]) -> int:
        """
        int _mm_movemask_epi8 (__m128i a)
           PMOVMSKB r32, xmm1
          VPMOVMSKB r32, xmm1
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector128[float]) -> int:
        """
        int _mm_movemask_pd (__m128d a)
           MOVMSKPD r32, xmm1
          VMOVMSKPD r32, xmm1
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_move_epi64 (__m128i a)
           MOVQ xmm1, xmm2
          VMOVQ xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_move_epi64 (__m128i a)
           MOVQ xmm1, xmm2
          VMOVQ xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_move_sd (__m128d a, __m128d b)
           MOVSD xmm1,               xmm2
          VMOVSD xmm1,         xmm2, xmm3
          VMOVSD xmm1 {k1}{z}, xmm2, xmm3
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_move_epi64 (__m128i a)
           MOVQ xmm1, xmm2
          VMOVQ xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_move_epi64 (__m128i a)
           MOVQ xmm1, xmm2
          VMOVQ xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MoveScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_move_sd (__m128d a, __m128d b)
           MOVSD xmm1,               xmm2
          VMOVSD xmm1,         xmm2, xmm3
          VMOVSD xmm1 {k1}{z}, xmm2, xmm3
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mul_epu32 (__m128i a,  __m128i b)
           PMULUDQ xmm1,               xmm2/m128
          VPMULUDQ xmm1,         xmm2, xmm3/m128
          VPMULUDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mul_pd (__m128d a,  __m128d b)
           MULPD xmm1,               xmm2/m128
          VMULPD xmm1,         xmm2, xmm3/m128
          VMULPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mul_epu32 (__m128i a,  __m128i b)
           PMULUDQ xmm1,               xmm2/m128
          VPMULUDQ xmm1,         xmm2, xmm3/m128
          VPMULUDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mul_pd (__m128d a,  __m128d b)
           MULPD xmm1,               xmm2/m128
          VMULPD xmm1,         xmm2, xmm3/m128
          VMULPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_madd_epi16 (__m128i a,  __m128i b)
           PMADDWD xmm1,               xmm2/m128
          VPMADDWD xmm1,         xmm2, xmm3/m128
          VPMADDWD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_madd_epi16 (__m128i a,  __m128i b)
           PMADDWD xmm1,               xmm2/m128
          VPMADDWD xmm1,         xmm2, xmm3/m128
          VPMADDWD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mulhi_epi16 (__m128i a,  __m128i b)
           PMULHW xmm1,               xmm2/m128
          VPMULHW xmm1,         xmm2, xmm3/m128
          VPMULHW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mulhi_epu16 (__m128i a,  __m128i b)
           PMULHUW xmm1,               xmm2/m128
          VPMULHUW xmm1,         xmm2, xmm3/m128
          VPMULHUW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mulhi_epi16 (__m128i a,  __m128i b)
           PMULHW xmm1,               xmm2/m128
          VPMULHW xmm1,         xmm2, xmm3/m128
          VPMULHW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mulhi_epu16 (__m128i a,  __m128i b)
           PMULHUW xmm1,               xmm2/m128
          VPMULHUW xmm1,         xmm2, xmm3/m128
          VPMULHUW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi16 (__m128i a,  __m128i b)
           PMULLW xmm1,               xmm2/m128
          VPMULLW xmm1,         xmm2, xmm3/m128
          VPMULLW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi16 (__m128i a,  __m128i b)
           PMULLW xmm1,               xmm2/m128
          VPMULLW xmm1,         xmm2, xmm3/m128
          VPMULLW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi16 (__m128i a,  __m128i b)
           PMULLW xmm1,               xmm2/m128
          VPMULLW xmm1,         xmm2, xmm3/m128
          VPMULLW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi16 (__m128i a,  __m128i b)
           PMULLW xmm1,               xmm2/m128
          VPMULLW xmm1,         xmm2, xmm3/m128
          VPMULLW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mul_sd (__m128d a,  __m128d b)
           MULSD xmm1,       xmm2/m64
          VMULSD xmm1, xmm2, xmm3/m64
        """
        ...

    @staticmethod
    @overload
    def MultiplyScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mul_sd (__m128d a,  __m128d b)
           MULSD xmm1,       xmm2/m64
          VMULSD xmm1, xmm2, xmm3/m64
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR xmm1,       xmm2/m128
          VPOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR xmm1,       xmm2/m128
          VPOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR xmm1,       xmm2/m128
          VPOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR  xmm1,       xmm2/m128
          VPOR  xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR  xmm1,               xmm2/m128
          VPOR  xmm1,         xmm2, xmm3/m128
          VPORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR  xmm1,               xmm2/m128
          VPOR  xmm1,         xmm2, xmm3/m128
          VPORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR  xmm1,               xmm2/m128
          VPOR  xmm1,         xmm2, xmm3/m128
          VPORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR  xmm1,               xmm2/m128
          VPOR  xmm1,         xmm2, xmm3/m128
          VPORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_or_pd (__m128d a,  __m128d b)
           ORPD xmm1,               xmm2/m128
          VORPD xmm1,         xmm2, xmm3/m128
          VORPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR xmm1,       xmm2/m128
          VPOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR xmm1,       xmm2/m128
          VPOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR xmm1,       xmm2/m128
          VPOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR xmm1,       xmm2/m128
          VPOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR  xmm1,               xmm2/m128
          VPOR  xmm1,         xmm2, xmm3/m128
          VPORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR  xmm1,               xmm2/m128
          VPOR  xmm1,         xmm2, xmm3/m128
          VPORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR  xmm1,               xmm2/m128
          VPOR  xmm1,         xmm2, xmm3/m128
          VPORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_or_si128 (__m128i a,  __m128i b)
           POR  xmm1,               xmm2/m128
          VPOR  xmm1,         xmm2, xmm3/m128
          VPORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_or_pd (__m128d a,  __m128d b)
           ORPD xmm1,               xmm2/m128
          VORPD xmm1,         xmm2, xmm3/m128
          VORPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packs_epi16 (__m128i a,  __m128i b)
           PACKSSWB xmm1,               xmm2/m128
          VPACKSSWB xmm1,         xmm2, xmm3/m128
          VPACKSSWB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packs_epi32 (__m128i a,  __m128i b)
           PACKSSDW xmm1,               xmm2/m128
          VPACKSSDW xmm1,         xmm2, xmm3/m128
          VPACKSSDW xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packs_epi16 (__m128i a,  __m128i b)
           PACKSSWB xmm1,               xmm2/m128
          VPACKSSWB xmm1,         xmm2, xmm3/m128
          VPACKSSWB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packs_epi32 (__m128i a,  __m128i b)
           PACKSSDW xmm1,               xmm2/m128
          VPACKSSDW xmm1,         xmm2, xmm3/m128
          VPACKSSDW xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packus_epi16 (__m128i a,  __m128i b)
           PACKUSWB xmm1,               xmm2/m128
          VPACKUSWB xmm1,         xmm2, xmm3/m128
          VPACKUSWB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packus_epi16 (__m128i a,  __m128i b)
           PACKUSWB xmm1,               xmm2/m128
          VPACKUSWB xmm1,         xmm2, xmm3/m128
          VPACKUSWB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi16 (__m128i a, __m128i count)
           PSLLW xmm1,               xmm2/m128
          VPSLLW xmm1,         xmm2, xmm3/m128
          VPSLLW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi16 (__m128i a,  __m128i count)
           PSLLW xmm1,               xmm2/m128
          VPSLLW xmm1,         xmm2, xmm3/m128
          VPSLLW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi32 (__m128i a, __m128i count)
           PSLLD xmm1,               xmm2/m128
          VPSLLD xmm1,         xmm2, xmm3/m128
          VPSLLD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi32 (__m128i a, __m128i count)
           PSLLD xmm1,               xmm2/m128
          VPSLLD xmm1,         xmm2, xmm3/m128
          VPSLLD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi64 (__m128i a, __m128i count)
           PSLLQ xmm1,               xmm2/m128
          VPSLLQ xmm1,         xmm2, xmm3/m128
          VPSLLQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi64 (__m128i a, __m128i count)
           PSLLQ xmm1,               xmm2/m128
          VPSLLQ xmm1,         xmm2, xmm3/m128
          VPSLLQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi16 (__m128i a,  int immediate)
           PSLLW xmm1,               imm8
          VPSLLW xmm1,         xmm2, imm8
          VPSLLW xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi16 (__m128i a,  int immediate)
           PSLLW xmm1,               imm8
          VPSLLW xmm1,         xmm2, imm8
          VPSLLW xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi32 (__m128i a,  int immediate)
           PSLLD xmm1,               imm8
          VPSLLD xmm1,         xmm2, imm8
          VPSLLD xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi32 (__m128i a,  int immediate)
           PSLLD xmm1,               imm8
          VPSLLD xmm1,         xmm2, imm8
          VPSLLD xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi64 (__m128i a,  int immediate)
           PSLLQ xmm1,               imm8
          VPSLLQ xmm1,         xmm2, imm8
          VPSLLQ xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi64 (__m128i a,  int immediate)
           PSLLQ xmm1,               imm8
          VPSLLQ xmm1,         xmm2, imm8
          VPSLLQ xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi16 (__m128i a, __m128i count)
           PSLLW xmm1,               xmm2/m128
          VPSLLW xmm1,         xmm2, xmm3/m128
          VPSLLW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi16 (__m128i a,  __m128i count)
           PSLLW xmm1,               xmm2/m128
          VPSLLW xmm1,         xmm2, xmm3/m128
          VPSLLW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi32 (__m128i a, __m128i count)
           PSLLD xmm1,               xmm2/m128
          VPSLLD xmm1,         xmm2, xmm3/m128
          VPSLLD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi32 (__m128i a, __m128i count)
           PSLLD xmm1,               xmm2/m128
          VPSLLD xmm1,         xmm2, xmm3/m128
          VPSLLD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi64 (__m128i a, __m128i count)
           PSLLQ xmm1,               xmm2/m128
          VPSLLQ xmm1,         xmm2, xmm3/m128
          VPSLLQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sll_epi64 (__m128i a, __m128i count)
           PSLLQ xmm1,               xmm2/m128
          VPSLLQ xmm1,         xmm2, xmm3/m128
          VPSLLQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi16 (__m128i a,  int immediate)
           PSLLW xmm1,               imm8
          VPSLLW xmm1,         xmm2, imm8
          VPSLLW xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi16 (__m128i a,  int immediate)
           PSLLW xmm1,               imm8
          VPSLLW xmm1,         xmm2, imm8
          VPSLLW xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi32 (__m128i a,  int immediate)
           PSLLD xmm1,               imm8
          VPSLLD xmm1,         xmm2, imm8
          VPSLLD xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi32 (__m128i a,  int immediate)
           PSLLD xmm1,               imm8
          VPSLLD xmm1,         xmm2, imm8
          VPSLLD xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi64 (__m128i a,  int immediate)
           PSLLQ xmm1,               imm8
          VPSLLQ xmm1,         xmm2, imm8
          VPSLLQ xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_slli_epi64 (__m128i a,  int immediate)
           PSLLQ xmm1,               imm8
          VPSLLQ xmm1,         xmm2, imm8
          VPSLLQ xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bslli_si128 (__m128i a, int imm8)
           PSLLDQ xmm1,            imm8
          VPSLLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sra_epi16 (__m128i a, __m128i count)
           PSRAW xmm1,               xmm2/m128
          VPSRAW xmm1,         xmm2, xmm3/m128
          VPSRAW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sra_epi32 (__m128i a, __m128i count)
           PSRAD xmm1,               xmm2/m128
          VPSRAD xmm1,         xmm2, xmm3/m128
          VPSRAD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srai_epi16 (__m128i a,  int immediate)
           PSRAW xmm1,               imm8
          VPSRAW xmm1,         xmm2, imm8
          VPSRAW xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srai_epi32 (__m128i a,  int immediate)
           PSRAD xmm1,               imm8
          VPSRAD xmm1,         xmm2, imm8
          VPSRAD xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sra_epi16 (__m128i a, __m128i count)
           PSRAW xmm1,               xmm2/m128
          VPSRAW xmm1,         xmm2, xmm3/m128
          VPSRAW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sra_epi32 (__m128i a, __m128i count)
           PSRAD xmm1,               xmm2/m128
          VPSRAD xmm1,         xmm2, xmm3/m128
          VPSRAD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srai_epi16 (__m128i a,  int immediate)
           PSRAW xmm1,               imm8
          VPSRAW xmm1,         xmm2, imm8
          VPSRAW xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srai_epi32 (__m128i a,  int immediate)
           PSRAD xmm1,               imm8
          VPSRAD xmm1,         xmm2, imm8
          VPSRAD xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi16 (__m128i a, __m128i count)
           PSRLW xmm1,               xmm2/m128
          VPSRLW xmm1,         xmm2, xmm3/m128
          VPSRLW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi16 (__m128i a, __m128i count)
           PSRLW xmm1,               xmm2/m128
          VPSRLW xmm1,         xmm2, xmm3/m128
          VPSRLW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi32 (__m128i a, __m128i count)
           PSRLD xmm1,               xmm2/m128
          VPSRLD xmm1,         xmm2, xmm3/m128
          VPSRLD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi32 (__m128i a, __m128i count)
           PSRLD xmm1,               xmm2/m128
          VPSRLD xmm1,         xmm2, xmm3/m128
          VPSRLD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi64 (__m128i a, __m128i count)
           PSRLQ xmm1,               xmm2/m128
          VPSRLQ xmm1,         xmm2, xmm3/m128
          VPSRLQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi64 (__m128i a, __m128i count)
           PSRLQ xmm1,               xmm2/m128
          VPSRLQ xmm1,         xmm2, xmm3/m128
          VPSRLQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi16 (__m128i a,  int immediate)
           PSRLW xmm1,               imm8
          VPSRLW xmm1,         xmm2, imm8
          VPSRLW xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi16 (__m128i a,  int immediate)
           PSRLW xmm1,               imm8
          VPSRLW xmm1,         xmm2, imm8
          VPSRLW xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi32 (__m128i a,  int immediate)
           PSRLD xmm1,               imm8
          VPSRLD xmm1,         xmm2, imm8
          VPSRLD xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi32 (__m128i a,  int immediate)
           PSRLD xmm1,               imm8
          VPSRLD xmm1,         xmm2, imm8
          VPSRLD xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi64 (__m128i a,  int immediate)
           PSRLQ xmm1,               imm8
          VPSRLQ xmm1,         xmm2, imm8
          VPSRLQ xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi64 (__m128i a,  int immediate)
           PSRLQ xmm1,               imm8
          VPSRLQ xmm1,         xmm2, imm8
          VPSRLQ xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi16 (__m128i a, __m128i count)
           PSRLW xmm1,               xmm2/m128
          VPSRLW xmm1,         xmm2, xmm3/m128
          VPSRLW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi16 (__m128i a, __m128i count)
           PSRLW xmm1,               xmm2/m128
          VPSRLW xmm1,         xmm2, xmm3/m128
          VPSRLW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi32 (__m128i a, __m128i count)
           PSRLD xmm1,               xmm2/m128
          VPSRLD xmm1,         xmm2, xmm3/m128
          VPSRLD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi32 (__m128i a, __m128i count)
           PSRLD xmm1,               xmm2/m128
          VPSRLD xmm1,         xmm2, xmm3/m128
          VPSRLD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi64 (__m128i a, __m128i count)
           PSRLQ xmm1,               xmm2/m128
          VPSRLQ xmm1,         xmm2, xmm3/m128
          VPSRLQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srl_epi64 (__m128i a, __m128i count)
           PSRLQ xmm1,               xmm2/m128
          VPSRLQ xmm1,         xmm2, xmm3/m128
          VPSRLQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi16 (__m128i a,  int immediate)
           PSRLW xmm1,               imm8
          VPSRLW xmm1,         xmm2, imm8
          VPSRLW xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi16 (__m128i a,  int immediate)
           PSRLW xmm1,               imm8
          VPSRLW xmm1,         xmm2, imm8
          VPSRLW xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi32 (__m128i a,  int immediate)
           PSRLD xmm1,               imm8
          VPSRLD xmm1,         xmm2, imm8
          VPSRLD xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi32 (__m128i a,  int immediate)
           PSRLD xmm1,               imm8
          VPSRLD xmm1,         xmm2, imm8
          VPSRLD xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi64 (__m128i a,  int immediate)
           PSRLQ xmm1,               imm8
          VPSRLQ xmm1,         xmm2, imm8
          VPSRLQ xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srli_epi64 (__m128i a,  int immediate)
           PSRLQ xmm1,               imm8
          VPSRLQ xmm1,         xmm2, imm8
          VPSRLQ xmm1 {k1}{z}, xmm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector128[int], numBytes: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_bsrli_si128 (__m128i a, int imm8)
           PSRLDQ xmm1,            imm8
          VPSRLDQ xmm1, xmm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi32 (__m128i a,  int immediate)
           PSHUFD xmm1,         xmm2/m128,         imm8
          VPSHUFD xmm1,         xmm2/m128,         imm8
          VPSHUFD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi32 (__m128i a,  int immediate)
           PSHUFD xmm1,         xmm2/m128,         imm8
          VPSHUFD xmm1,         xmm2/m128,         imm8
          VPSHUFD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_shuffle_pd (__m128d a,  __m128d b, int immediate)
           SHUFPD xmm1,               xmm2/m128,         imm8
          VSHUFPD xmm1,         xmm2, xmm3/m128,         imm8
          VSHUFPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi32 (__m128i a,  int immediate)
           PSHUFD xmm1,         xmm2/m128,         imm8
          VPSHUFD xmm1,         xmm2/m128,         imm8
          VPSHUFD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi32 (__m128i a,  int immediate)
           PSHUFD xmm1,         xmm2/m128,         imm8
          VPSHUFD xmm1,         xmm2/m128,         imm8
          VPSHUFD xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_shuffle_pd (__m128d a,  __m128d b, int immediate)
           SHUFPD xmm1,               xmm2/m128,         imm8
          VSHUFPD xmm1,         xmm2, xmm3/m128,         imm8
          VSHUFPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflehi_epi16 (__m128i a,  int immediate)
           PSHUFHW xmm1,         xmm2/m128, imm8
          VPSHUFHW xmm1,         xmm2/m128, imm8
          VPSHUFHW xmm1 {k1}{z}, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflehi_epi16 (__m128i a,  int control)
           PSHUFHW xmm1,         xmm2/m128, imm8
          VPSHUFHW xmm1,         xmm2/m128, imm8
          VPSHUFHW xmm1 {k1}{z}, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflehi_epi16 (__m128i a,  int immediate)
           PSHUFHW xmm1,         xmm2/m128, imm8
          VPSHUFHW xmm1,         xmm2/m128, imm8
          VPSHUFHW xmm1 {k1}{z}, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflehi_epi16 (__m128i a,  int control)
           PSHUFHW xmm1,         xmm2/m128, imm8
          VPSHUFHW xmm1,         xmm2/m128, imm8
          VPSHUFHW xmm1 {k1}{z}, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflelo_epi16 (__m128i a,  int control)
           PSHUFLW xmm1,         xmm2/m128, imm8
          VPSHUFLW xmm1,         xmm2/m128, imm8
          VPSHUFLW xmm1 {k1}{z}, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflelo_epi16 (__m128i a,  int control)
           PSHUFLW xmm1,         xmm2/m128, imm8
          VPSHUFLW xmm1,         xmm2/m128, imm8
          VPSHUFLW xmm1 {k1}{z}, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflelo_epi16 (__m128i a,  int control)
           PSHUFLW xmm1,         xmm2/m128, imm8
          VPSHUFLW xmm1,         xmm2/m128, imm8
          VPSHUFLW xmm1 {k1}{z}, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shufflelo_epi16 (__m128i a,  int control)
           PSHUFLW xmm1,         xmm2/m128, imm8
          VPSHUFLW xmm1,         xmm2/m128, imm8
          VPSHUFLW xmm1 {k1}{z}, xmm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sqrt_pd (__m128d a)
           SQRTPD xmm1,         xmm2/m128
          VSQRTPD xmm1,         xmm2/m128
          VSQRTPD xmm1 {k1}{z}, xmm2/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sqrt_pd (__m128d a)
           SQRTPD xmm1,         xmm2/m128
          VSQRTPD xmm1,         xmm2/m128
          VSQRTPD xmm1 {k1}{z}, xmm2/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sqrt_sd (__m128d a)
           SQRTSD xmm1,               xmm2/m64
          VSQRTSD xmm1,         xmm2, xmm3/m64
          VSQRTSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sqrt_sd (__m128d a, __m128d b)
           SQRTSD xmm1,               xmm2/m64
          VSQRTSD xmm1,         xmm2, xmm3/m64
          VSQRTSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sqrt_sd (__m128d a)
           SQRTSD xmm1,               xmm2/m64
          VSQRTSD xmm1,         xmm2, xmm3/m64
          VSQRTSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def SqrtScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sqrt_sd (__m128d a, __m128d b)
           SQRTSD xmm1,               xmm2/m64
          VSQRTSD xmm1,         xmm2, xmm3/m64
          VSQRTSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU  m128,         xmm1
          VMOVDQU  m128,         xmm1
          VMOVDQU8 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU  m128,         xmm1
          VMOVDQU  m128,         xmm1
          VMOVDQU8 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU   m128,         xmm1
          VMOVDQU   m128,         xmm1
          VMOVDQU16 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU   m128,         xmm1
          VMOVDQU   m128,         xmm1
          VMOVDQU16 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU   m128,         xmm1
          VMOVDQU   m128,         xmm1
          VMOVDQU32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU   m128,         xmm1
          VMOVDQU   m128,         xmm1
          VMOVDQU32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU   m128,         xmm1
          VMOVDQU   m128,         xmm1
          VMOVDQU64 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU   m128,         xmm1
          VMOVDQU   m128,         xmm1
          VMOVDQU64 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeu_pd (double* mem_addr, __m128d a)
           MOVAPD m128,         xmm1
          VMOVAPD m128,         xmm1
          VMOVAPD m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU  m128,         xmm1
          VMOVDQU  m128,         xmm1
          VMOVDQU8 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU  m128,         xmm1
          VMOVDQU  m128,         xmm1
          VMOVDQU8 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU   m128,         xmm1
          VMOVDQU   m128,         xmm1
          VMOVDQU16 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU   m128,         xmm1
          VMOVDQU   m128,         xmm1
          VMOVDQU16 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU   m128,         xmm1
          VMOVDQU   m128,         xmm1
          VMOVDQU32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU   m128,         xmm1
          VMOVDQU   m128,         xmm1
          VMOVDQU32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU   m128,         xmm1
          VMOVDQU   m128,         xmm1
          VMOVDQU64 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si128 (__m128i* mem_addr, __m128i a)
           MOVDQU   m128,         xmm1
          VMOVDQU   m128,         xmm1
          VMOVDQU64 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeu_pd (double* mem_addr, __m128d a)
           MOVUPD m128,         xmm1
          VMOVUPD m128,         xmm1
          VMOVUPD m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA64 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA64 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_pd (double* mem_addr, __m128d a)
           MOVAPD m128,         xmm1
          VMOVAPD m128,         xmm1
          VMOVAPD m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA32 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA64 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_store_si128 (__m128i* mem_addr, __m128i a)
           MOVDQA   m128,         xmm1
          VMOVDQA   m128,         xmm1
          VMOVDQA64 m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_pd (double* mem_addr, __m128d a)
           MOVAPD m128,         xmm1
          VMOVAPD m128,         xmm1
          VMOVAPD m128 {k1}{z}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_stream_pd (double* mem_addr, __m128d a)
           MOVNTPD m128, xmm1
          VMOVNTPD m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_stream_si128 (__m128i* mem_addr, __m128i a)
           MOVNTDQ m128, xmm1
          VMOVNTDQ m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_stream_pd (double* mem_addr, __m128d a)
           MOVNTPD m128, xmm1
          VMOVNTPD m128, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreHigh(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeh_pd (double* mem_addr, __m128d a)
           MOVHPD m64, xmm1
          VMOVHPD m64, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreHigh(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storeh_pd (double* mem_addr, __m128d a)
           MOVHPD m64, xmm1
          VMOVHPD m64, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreLow(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storel_pd (double* mem_addr, __m128d a)
           MOVLPD m64, xmm1
          VMOVLPD m64, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreLow(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_storel_pd (double* mem_addr, __m128d a)
           MOVLPD m64, xmm1
          VMOVLPD m64, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreNonTemporal(address: typing.Any, value: int) -> None:
        """
        void _mm_stream_si32(int *p, int a)
          MOVNTI m32, r32
        """
        ...

    @staticmethod
    @overload
    def StoreNonTemporal(address: typing.Any, value: int) -> None:
        """
        void _mm_stream_si32(int *p, int a)
          MOVNTI m32, r32
        """
        ...

    @staticmethod
    @overload
    def StoreNonTemporal(address: typing.Any, value: int) -> None:
        """
        void _mm_stream_si32(int *p, int a)
          MOVNTI m32, r32
        """
        ...

    @staticmethod
    @overload
    def StoreNonTemporal(address: typing.Any, value: int) -> None:
        """
        void _mm_stream_si32(int *p, int a)
          MOVNTI m32, r32
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si32 (void* mem_addr, __m128i a)
           MOVD m32, xmm1
          VMOVD m32, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si32 (void* mem_addr, __m128i a)
           MOVD m32, xmm1
          VMOVD m32, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storel_epi64 (__m128i* mem_addr, __m128i a)
           MOVQ m64, xmm1
          VMOVQ m64, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storel_epi64 (__m128i* mem_addr, __m128i a)
           MOVQ m64, xmm1
          VMOVQ m64, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_sd (double* mem_addr, __m128d a)
           MOVSD m64,      xmm1
          VMOVSD m64,      xmm1
          VMOVSD m64 {k1}, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si32 (void* mem_addr, __m128i a)
           MOVD m32, xmm1
          VMOVD m32, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storeu_si32 (void* mem_addr, __m128i a)
           MOVD m32, xmm1
          VMOVD m32, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storel_epi64 (__m128i* mem_addr, __m128i a)
           MOVQ m64, xmm1
          VMOVQ m64, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_storel_epi64 (__m128i* mem_addr, __m128i a)
           MOVQ m64, xmm1
          VMOVQ m64, xmm1
        """
        ...

    @staticmethod
    @overload
    def StoreScalar(address: typing.Any, source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_store_sd (double* mem_addr, __m128d a)
           MOVSD m64,      xmm1
          VMOVSD m64,      xmm1
          VMOVSD m64 {k1}, xmm1
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi8 (__m128i a,  __m128i b)
           PSUBB xmm1,               xmm2/m128
          VPSUBB xmm1,         xmm2, xmm3/m128
          VPSUBB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi8 (__m128i a,  __m128i b)
           PSUBB xmm1,               xmm2/m128
          VPSUBB xmm1,         xmm2, xmm3/m128
          VPSUBB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi16 (__m128i a,  __m128i b)
           PSUBW xmm1,               xmm2/m128
          VPSUBW xmm1,         xmm2, xmm3/m128
          VPSUBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi16 (__m128i a,  __m128i b)
           PSUBW xmm1,               xmm2/m128
          VPSUBW xmm1,         xmm2, xmm3/m128
          VPSUBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi32 (__m128i a,  __m128i b)
           PSUBD xmm1,               xmm2/m128
          VPSUBD xmm1,         xmm2, xmm3/m128
          VPSUBD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi32 (__m128i a,  __m128i b)
           PSUBD xmm1,               xmm2/m128
          VPSUBD xmm1,         xmm2, xmm3/m128
          VPSUBD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi64 (__m128i a,  __m128i b)
           PSUBQ xmm1,               xmm2/m128
          VPSUBQ xmm1,         xmm2, xmm3/m128
          VPSUBQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi64 (__m128i a,  __m128i b)
           PSUBQ xmm1,               xmm2/m128
          VPSUBQ xmm1,         xmm2, xmm3/m128
          VPSUBQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sub_pd (__m128d a, __m128d b)
           SUBPD xmm1,               xmm2/m128
          VSUBPD xmm1,         xmm2, xmm3/m128
          VSUBPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi8 (__m128i a,  __m128i b)
           PSUBB xmm1,               xmm2/m128
          VPSUBB xmm1,         xmm2, xmm3/m128
          VPSUBB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi8 (__m128i a,  __m128i b)
           PSUBB xmm1,               xmm2/m128
          VPSUBB xmm1,         xmm2, xmm3/m128
          VPSUBB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi16 (__m128i a,  __m128i b)
           PSUBW xmm1,               xmm2/m128
          VPSUBW xmm1,         xmm2, xmm3/m128
          VPSUBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi16 (__m128i a,  __m128i b)
           PSUBW xmm1,               xmm2/m128
          VPSUBW xmm1,         xmm2, xmm3/m128
          VPSUBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi32 (__m128i a,  __m128i b)
           PSUBD xmm1,               xmm2/m128
          VPSUBD xmm1,         xmm2, xmm3/m128
          VPSUBD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi32 (__m128i a,  __m128i b)
           PSUBD xmm1,               xmm2/m128
          VPSUBD xmm1,         xmm2, xmm3/m128
          VPSUBD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi64 (__m128i a,  __m128i b)
           PSUBQ xmm1,               xmm2/m128
          VPSUBQ xmm1,         xmm2, xmm3/m128
          VPSUBQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sub_epi64 (__m128i a,  __m128i b)
           PSUBQ xmm1,               xmm2/m128
          VPSUBQ xmm1,         xmm2, xmm3/m128
          VPSUBQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sub_pd (__m128d a, __m128d b)
           SUBPD xmm1,               xmm2/m128
          VSUBPD xmm1,         xmm2, xmm3/m128
          VSUBPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epi8 (__m128i a,  __m128i b)
           PSUBSB xmm1,               xmm2/m128
          VPSUBSB xmm1,         xmm2, xmm3/m128
          VPSUBSB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epi16 (__m128i a,  __m128i b)
           PSUBSW xmm1,               xmm2/m128
          VPSUBSW xmm1,         xmm2, xmm3/m128
          VPSUBSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epu8 (__m128i a,  __m128i b)
           PSUBUSB xmm1,               xmm2/m128
          VPSUBUSB xmm1,         xmm2, xmm3/m128
          VPSUBUSB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epu16 (__m128i a,  __m128i b)
           PSUBUSW xmm1,               xmm2/m128
          VPSUBUSW xmm1,         xmm2, xmm3/m128
          VPSUBUSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epi8 (__m128i a,  __m128i b)
           PSUBSB xmm1,               xmm2/m128
          VPSUBSB xmm1,         xmm2, xmm3/m128
          VPSUBSB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epi16 (__m128i a,  __m128i b)
           PSUBSW xmm1,               xmm2/m128
          VPSUBSW xmm1,         xmm2, xmm3/m128
          VPSUBSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epu8 (__m128i a,  __m128i b)
           PSUBUSB xmm1,               xmm2/m128
          VPSUBUSB xmm1,         xmm2, xmm3/m128
          VPSUBUSB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_subs_epu16 (__m128i a,  __m128i b)
           PSUBUSW xmm1,               xmm2/m128
          VPSUBUSW xmm1,         xmm2, xmm3/m128
          VPSUBUSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sub_sd (__m128d a, __m128d b)
           SUBSD xmm1,               xmm2/m64
          VSUBSD xmm1,         xmm2, xmm3/m64
          VSUBSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}
        """
        ...

    @staticmethod
    @overload
    def SubtractScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_sub_sd (__m128d a, __m128d b)
           SUBSD xmm1,               xmm2/m64
          VSUBSD xmm1,         xmm2, xmm3/m64
          VSUBSD xmm1 {k1}{z}, xmm2, xmm3/m64{er}
        """
        ...

    @staticmethod
    @overload
    def SumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sad_epu8 (__m128i a,  __m128i b)
           PSADBW xmm1,               xmm2/m128
          VPSADBW xmm1,         xmm2, xmm3/m128
          VPSADBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def SumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sad_epu8 (__m128i a,  __m128i b)
           PSADBW xmm1,               xmm2/m128
          VPSADBW xmm1,         xmm2, xmm3/m128
          VPSADBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi8 (__m128i a,  __m128i b)
           PUNPCKHBW xmm1,               xmm2/m128
          VPUNPCKHBW xmm1,         xmm2, xmm3/m128
          VPUNPCKHBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi8 (__m128i a,  __m128i b)
           PUNPCKHBW xmm1,               xmm2/m128
          VPUNPCKHBW xmm1,         xmm2, xmm3/m128
          VPUNPCKHBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi16 (__m128i a,  __m128i b)
           PUNPCKHWD xmm1,               xmm2/m128
          VPUNPCKHWD xmm1,         xmm2, xmm3/m128
          VPUNPCKHWD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi16 (__m128i a,  __m128i b)
           PUNPCKHWD xmm1,               xmm2/m128
          VPUNPCKHWD xmm1,         xmm2, xmm3/m128
          VPUNPCKHWD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi32 (__m128i a,  __m128i b)
           PUNPCKHDQ xmm1,               xmm2/m128
          VPUNPCKHDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKHDQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi32 (__m128i a,  __m128i b)
           PUNPCKHDQ xmm1,               xmm2/m128
          VPUNPCKHDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKHDQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi64 (__m128i a,  __m128i b)
           PUNPCKHQDQ xmm1,               xmm2/m128
          VPUNPCKHQDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKHQDQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi64 (__m128i a,  __m128i b)
           PUNPCKHQDQ xmm1,               xmm2/m128
          VPUNPCKHQDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKHQDQ xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_unpackhi_pd (__m128d a,  __m128d b)
           UNPCKHPD xmm1,               xmm2/m128
          VUNPCKHPD xmm1,         xmm2, xmm3/m128
          VUNPCKHPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi8 (__m128i a,  __m128i b)
           PUNPCKHBW xmm1,               xmm2/m128
          VPUNPCKHBW xmm1,         xmm2, xmm3/m128
          VPUNPCKHBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi8 (__m128i a,  __m128i b)
           PUNPCKHBW xmm1,               xmm2/m128
          VPUNPCKHBW xmm1,         xmm2, xmm3/m128
          VPUNPCKHBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi16 (__m128i a,  __m128i b)
           PUNPCKHWD xmm1,               xmm2/m128
          VPUNPCKHWD xmm1,         xmm2, xmm3/m128
          VPUNPCKHWD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi16 (__m128i a,  __m128i b)
           PUNPCKHWD xmm1,               xmm2/m128
          VPUNPCKHWD xmm1,         xmm2, xmm3/m128
          VPUNPCKHWD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi32 (__m128i a,  __m128i b)
           PUNPCKHDQ xmm1,               xmm2/m128
          VPUNPCKHDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKHDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi32 (__m128i a,  __m128i b)
           PUNPCKHDQ xmm1,               xmm2/m128
          VPUNPCKHDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKHDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi64 (__m128i a,  __m128i b)
           PUNPCKHQDQ xmm1,               xmm2/m128
          VPUNPCKHQDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKHQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpackhi_epi64 (__m128i a,  __m128i b)
           PUNPCKHQDQ xmm1,               xmm2/m128
          VPUNPCKHQDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKHQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_unpackhi_pd (__m128d a,  __m128d b)
           UNPCKHPD xmm1,               xmm2/m128
          VUNPCKHPD xmm1,         xmm2, xmm3/m128
          VUNPCKHPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi8 (__m128i a,  __m128i b)
           PUNPCKLBW xmm1,               xmm2/m128
          VPUNPCKLBW xmm1,         xmm2, xmm3/m128
          VPUNPCKLBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi8 (__m128i a,  __m128i b)
           PUNPCKLBW xmm1,               xmm2/m128
          VPUNPCKLBW xmm1,         xmm2, xmm3/m128
          VPUNPCKLBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi16 (__m128i a,  __m128i b)
           PUNPCKLWD xmm1,               xmm2/m128
          VPUNPCKLWD xmm1,         xmm2, xmm3/m128
          VPUNPCKLWD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi16 (__m128i a,  __m128i b)
           PUNPCKLWD xmm1,               xmm2/m128
          VPUNPCKLWD xmm1,         xmm2, xmm3/m128
          VPUNPCKLWD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi32 (__m128i a,  __m128i b)
           PUNPCKLDQ xmm1,               xmm2/m128
          VPUNPCKLDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKLDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi32 (__m128i a,  __m128i b)
           PUNPCKLDQ xmm1,               xmm2/m128
          VPUNPCKLDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKLDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi64 (__m128i a,  __m128i b)
           PUNPCKLQDQ xmm1,               xmm2/m128
          VPUNPCKLQDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKLQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi64 (__m128i a,  __m128i b)
           PUNPCKLQDQ xmm1,               xmm2/m128
          VPUNPCKLQDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKLQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_unpacklo_pd (__m128d a,  __m128d b)
           UNPCKLPD xmm1,               xmm2/m128
          VUNPCKLPD xmm1,         xmm2, xmm3/m128
          VUNPCKLPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi8 (__m128i a,  __m128i b)
           PUNPCKLBW xmm1,               xmm2/m128
          VPUNPCKLBW xmm1,         xmm2, xmm3/m128
          VPUNPCKLBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi8 (__m128i a,  __m128i b)
           PUNPCKLBW xmm1,               xmm2/m128
          VPUNPCKLBW xmm1,         xmm2, xmm3/m128
          VPUNPCKLBW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi16 (__m128i a,  __m128i b)
           PUNPCKLWD xmm1,               xmm2/m128
          VPUNPCKLWD xmm1,         xmm2, xmm3/m128
          VPUNPCKLWD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi16 (__m128i a,  __m128i b)
           PUNPCKLWD xmm1,               xmm2/m128
          VPUNPCKLWD xmm1,         xmm2, xmm3/m128
          VPUNPCKLWD xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi32 (__m128i a,  __m128i b)
           PUNPCKLDQ xmm1,               xmm2/m128
          VPUNPCKLDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKLDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi32 (__m128i a,  __m128i b)
           PUNPCKLDQ xmm1,               xmm2/m128
          VPUNPCKLDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKLDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi64 (__m128i a,  __m128i b)
           PUNPCKLQDQ xmm1,               xmm2/m128
          VPUNPCKLQDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKLQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_unpacklo_epi64 (__m128i a,  __m128i b)
           PUNPCKLQDQ xmm1,               xmm2/m128
          VPUNPCKLQDQ xmm1,         xmm2, xmm3/m128
          VPUNPCKLQDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_unpacklo_pd (__m128d a,  __m128d b)
           UNPCKLPD xmm1,               xmm2/m128
          VUNPCKLPD xmm1,         xmm2, xmm3/m128
          VUNPCKLPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR xmm1,       xmm2/m128
          VPXOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR xmm1,       xmm2/m128
          VPXOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR xmm1,       xmm2/m128
          VPXOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR xmm1,       xmm2/m128
          VPXOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR  xmm1,               xmm2/m128
          VPXOR  xmm1,         xmm2, xmm3/m128
          VPXORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR  xmm1,               xmm2/m128
          VPXOR  xmm1,         xmm2, xmm3/m128
          VPXORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR  xmm1,               xmm2/m128
          VPXOR  xmm1,         xmm2, xmm3/m128
          VPXORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR  xmm1,               xmm2/m128
          VPXOR  xmm1,         xmm2, xmm3/m128
          VPXORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_xor_pd (__m128d a,  __m128d b)
           XORPD xmm1,               xmm2/m128
          VXORPD xmm1,         xmm2, xmm3/m128
          VXORPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR xmm1,       xmm2/m128
          VPXOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR xmm1,       xmm2/m128
          VPXOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR xmm1,       xmm2/m128
          VPXOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR xmm1,       xmm2/m128
          VPXOR xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR  xmm1,               xmm2/m128
          VPXOR  xmm1,         xmm2, xmm3/m128
          VPXORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR  xmm1,               xmm2/m128
          VPXOR  xmm1,         xmm2, xmm3/m128
          VPXORD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR  xmm1,               xmm2/m128
          VPXOR  xmm1,         xmm2, xmm3/m128
          VPXORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_xor_si128 (__m128i a,  __m128i b)
           PXOR  xmm1,               xmm2/m128
          VPXOR  xmm1,         xmm2, xmm3/m128
          VPXORQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_xor_pd (__m128d a,  __m128d b)
           XORPD xmm1,               xmm2/m128
          VXORPD xmm1,         xmm2, xmm3/m128
          VXORPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...


class Sse3(System.Runtime.Intrinsics.X86.Sse2, metaclass=abc.ABCMeta):
    """This class provides access to Intel SSE3 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse2.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_addsub_ps (__m128 a, __m128 b)
           ADDSUBPS xmm1,       xmm2/m128
          VADDSUBPS xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_addsub_pd (__m128d a, __m128d b)
           ADDSUBPD xmm1,       xmm2/m128
          VADDSUBPD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_addsub_ps (__m128 a, __m128 b)
           ADDSUBPS xmm1,       xmm2/m128
          VADDSUBPS xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_addsub_pd (__m128d a, __m128d b)
           ADDSUBPD xmm1,       xmm2/m128
          VADDSUBPD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_hadd_ps (__m128 a, __m128 b)
           HADDPS xmm1,       xmm2/m128
          VHADDPS xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_hadd_pd (__m128d a, __m128d b)
           HADDPD xmm1,       xmm2/m128
          VHADDPD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_hadd_ps (__m128 a, __m128 b)
           HADDPS xmm1,       xmm2/m128
          VHADDPS xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_hadd_pd (__m128d a, __m128d b)
           HADDPD xmm1,       xmm2/m128
          VHADDPD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_hsub_ps (__m128 a, __m128 b)
           HSUBPS xmm1,       xmm2/m128
          VHSUBPS xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_hsub_pd (__m128d a, __m128d b)
           HSUBPD xmm1,       xmm2/m128
          VHSUBPD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_hsub_ps (__m128 a, __m128 b)
           HSUBPS xmm1,       xmm2/m128
          VHSUBPS xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_hsub_pd (__m128d a, __m128d b)
           HSUBPD xmm1,       xmm2/m128
          VHSUBPD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def LoadAndDuplicateToVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loaddup_pd (double const* mem_addr)
           MOVDDUP xmm1,         m64
          VMOVDDUP xmm1,         m64
          VMOVDDUP xmm1 {k1}{z}, m64
        """
        ...

    @staticmethod
    @overload
    def LoadAndDuplicateToVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_loaddup_pd (double const* mem_addr)
           MOVDDUP xmm1,         m64
          VMOVDDUP xmm1,         m64
          VMOVDDUP xmm1 {k1}{z}, m64
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector128(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_lddqu_si128 (__m128i const* mem_addr)
           LDDQU xmm1, m128
          VLDDQU xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def MoveAndDuplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_movedup_pd (__m128d a)
           MOVDDUP xmm1,         xmm2/m64
          VMOVDDUP xmm1,         xmm2/m64
          VMOVDDUP xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def MoveAndDuplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_movedup_pd (__m128d a)
           MOVDDUP xmm1,         xmm2/m64
          VMOVDDUP xmm1,         xmm2/m64
          VMOVDDUP xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def MoveHighAndDuplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_movehdup_ps (__m128 a)
           MOVSHDUP xmm1,         xmm2/m128
          VMOVSHDUP xmm1,         xmm2/m128
          VMOVSHDUP xmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def MoveHighAndDuplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_movehdup_ps (__m128 a)
           MOVSHDUP xmm1,         xmm2/m128
          VMOVSHDUP xmm1,         xmm2/m128
          VMOVSHDUP xmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def MoveLowAndDuplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_moveldup_ps (__m128 a)
           MOVSLDUP xmm1,         xmm2/m128
          VMOVSLDUP xmm1,         xmm2/m128
          VMOVSLDUP xmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def MoveLowAndDuplicate(source: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_moveldup_ps (__m128 a)
           MOVSLDUP xmm1,         xmm2/m128
          VMOVSLDUP xmm1,         xmm2/m128
          VMOVSLDUP xmm1 {k1}{z}, xmm2/m128
        """
        ...


class Ssse3(System.Runtime.Intrinsics.X86.Sse3, metaclass=abc.ABCMeta):
    """This class provides access to Intel SSSE3 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse3.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_abs_epi8 (__m128i a)
           PABSB xmm1,         xmm2/m128
          VPABSB xmm1,         xmm2/m128
          VPABSB xmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_abs_epi16 (__m128i a)
           PABSW xmm1,         xmm2/m128
          VPABSW xmm1,         xmm2/m128
          VPABSW xmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_abs_epi32 (__m128i a)
           PABSD xmm1,         xmm2/m128
          VPABSD xmm1,         xmm2/m128
          VPABSD xmm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_abs_epi8 (__m128i a)
           PABSB xmm1,         xmm2/m128
          VPABSB xmm1,         xmm2/m128
          VPABSB xmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_abs_epi16 (__m128i a)
           PABSW xmm1,         xmm2/m128
          VPABSW xmm1,         xmm2/m128
          VPABSW xmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_abs_epi32 (__m128i a)
           PABSD xmm1,         xmm2/m128
          VPABSD xmm1,         xmm2/m128
          VPABSD xmm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        This intrinsic generates PALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_alignr_epi8 (__m128i a, __m128i b, int count)
           PALIGNR xmm1,               xmm2/m128, imm8
          VPALIGNR xmm1,         xmm2, xmm3/m128, imm8
          VPALIGNR xmm1 {k1}{z}, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hadd_epi16 (__m128i a, __m128i b)
           PHADDW xmm1,       xmm2/m128
          VPHADDW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hadd_epi32 (__m128i a, __m128i b)
           PHADDD xmm1,       xmm2/m128
          VPHADDD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hadd_epi16 (__m128i a, __m128i b)
           PHADDW xmm1,       xmm2/m128
          VPHADDW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hadd_epi32 (__m128i a, __m128i b)
           PHADDD xmm1,       xmm2/m128
          VPHADDD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hadds_epi16 (__m128i a, __m128i b)
           PHADDSW xmm1,       xmm2/m128
          VPHADDSW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalAddSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hadds_epi16 (__m128i a, __m128i b)
           PHADDSW xmm1,       xmm2/m128
          VPHADDSW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hsub_epi16 (__m128i a, __m128i b)
           PHSUBW xmm1,       xmm2/m128
          VPHSUBW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hsub_epi32 (__m128i a, __m128i b)
           PHSUBD xmm1,       xmm2/m128
          VPHSUBD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hsub_epi16 (__m128i a, __m128i b)
           PHSUBW xmm1,       xmm2/m128
          VPHSUBW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hsub_epi32 (__m128i a, __m128i b)
           PHSUBD xmm1,       xmm2/m128
          VPHSUBD xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hsubs_epi16 (__m128i a, __m128i b)
           PHSUBSW xmm1,       xmm2/m128
          VPHSUBSW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtractSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_hsubs_epi16 (__m128i a, __m128i b)
           PHSUBSW xmm1,       xmm2/m128
          VPHSUBSW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maddubs_epi16 (__m128i a, __m128i b)
           PMADDUBSW xmm1,               xmm2/m128
          VPMADDUBSW xmm1,         xmm2, xmm3/m128
          VPMADDUBSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maddubs_epi16 (__m128i a, __m128i b)
           PMADDUBSW xmm1,               xmm2/m128
          VPMADDUBSW xmm1,         xmm2, xmm3/m128
          VPMADDUBSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyHighRoundScale(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mulhrs_epi16 (__m128i a, __m128i b)
           PMULHRSW xmm1,               xmm2/m128
          VPMULHRSW xmm1,         xmm2, xmm3/m128
          VPMULHRSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def MultiplyHighRoundScale(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mulhrs_epi16 (__m128i a, __m128i b)
           PMULHRSW xmm1,               xmm2/m128
          VPMULHRSW xmm1,         xmm2, xmm3/m128
          VPMULHRSW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi8 (__m128i a, __m128i b)
           PSHUFB xmm1,               xmm2/m128
          VPSHUFB xmm1,         xmm2, xmm3/m128
          VPSHUFB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi8 (__m128i a, __m128i b)
           PSHUFB xmm1,               xmm2/m128
          VPSHUFB xmm1,         xmm2, xmm3/m128
          VPSHUFB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi8 (__m128i a, __m128i b)
           PSHUFB xmm1,               xmm2/m128
          VPSHUFB xmm1,         xmm2, xmm3/m128
          VPSHUFB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_shuffle_epi8 (__m128i a, __m128i b)
           PSHUFB xmm1,               xmm2/m128
          VPSHUFB xmm1,         xmm2, xmm3/m128
          VPSHUFB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sign_epi8 (__m128i a, __m128i b)
           PSIGNB xmm1,       xmm2/m128
          VPSIGNB xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sign_epi16 (__m128i a, __m128i b)
           PSIGNW xmm1,       xmm2/m128
          VPSIGNW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sign_epi32 (__m128i a, __m128i b)
           PSIGND xmm1,       xmm2/m128
          VPSIGND xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sign_epi8 (__m128i a, __m128i b)
           PSIGNB xmm1,       xmm2/m128
          VPSIGNB xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sign_epi16 (__m128i a, __m128i b)
           PSIGNW xmm1,       xmm2/m128
          VPSIGNW xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sign_epi32 (__m128i a, __m128i b)
           PSIGND xmm1,       xmm2/m128
          VPSIGND xmm1, xmm2, xmm3/m128
        """
        ...


class Sse41(System.Runtime.Intrinsics.X86.Ssse3, metaclass=abc.ABCMeta):
    """This class provides access to Intel SSE4.1 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Ssse3.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
            """
            __int64 _mm_extract_epi64 (__m128i a, const int imm8)
               PEXTRQ r/m64, xmm1, imm8
              VPEXTRQ r/m64, xmm1, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
            """
            __int64 _mm_extract_epi64 (__m128i a, const int imm8)
               PEXTRQ r/m64, xmm1, imm8
              VPEXTRQ r/m64, xmm1, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
            """
            __int64 _mm_extract_epi64 (__m128i a, const int imm8)
               PEXTRQ r/m64, xmm1, imm8
              VPEXTRQ r/m64, xmm1, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
            """
            __int64 _mm_extract_epi64 (__m128i a, const int imm8)
               PEXTRQ r/m64, xmm1, imm8
              VPEXTRQ r/m64, xmm1, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_insert_epi64 (__m128i a, __int64 i, const int imm8)
               PINSRQ xmm1,       r/m64, imm8
              VPINSRQ xmm1, xmm2, r/m64, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_insert_epi64 (__m128i a, __int64 i, const int imm8)
               PINSRQ xmm1,       r/m64, imm8
              VPINSRQ xmm1, xmm2, r/m64, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_insert_epi64 (__m128i a, __int64 i, const int imm8)
               PINSRQ xmm1,       r/m64, imm8
              VPINSRQ xmm1, xmm2, r/m64, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_insert_epi64 (__m128i a, __int64 i, const int imm8)
               PINSRQ xmm1,       r/m64, imm8
              VPINSRQ xmm1, xmm2, r/m64, imm8
            This intrinsic is only available on 64-bit processes
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi16 (__m128i a, __m128i b, const int imm8)
           PBLENDW xmm1,       xmm2/m128 imm8
          VPBLENDW xmm1, xmm2, xmm3/m128 imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi16 (__m128i a, __m128i b, const int imm8)
           PBLENDW xmm1,       xmm2/m128 imm8
          VPBLENDW xmm1, xmm2, xmm3/m128 imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_blend_ps (__m128 a, __m128 b, const int imm8)
           BLENDPS xmm1,       xmm2/m128, imm8
          VBLENDPS xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_blend_pd (__m128d a, __m128d b, const int imm8)
           BLENDPD xmm1,       xmm2/m128, imm8
          VBLENDPD xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi16 (__m128i a, __m128i b, const int imm8)
           PBLENDW xmm1,       xmm2/m128 imm8
          VPBLENDW xmm1, xmm2, xmm3/m128 imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi16 (__m128i a, __m128i b, const int imm8)
           PBLENDW xmm1,       xmm2/m128 imm8
          VPBLENDW xmm1, xmm2, xmm3/m128 imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_blend_ps (__m128 a, __m128 b, const int imm8)
           BLENDPS xmm1,       xmm2/m128, imm8
          VBLENDPS xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_blend_pd (__m128d a, __m128d b, const int imm8)
           BLENDPD xmm1,       xmm2/m128, imm8
          VBLENDPD xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_blendv_ps (__m128 a, __m128 b, __m128 mask)
           BLENDVPS xmm1,       xmm2/m128, <XMM0>
          VBLENDVPS xmm1, xmm2, xmm3/m128, xmm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_blendv_pd (__m128d a, __m128d b, __m128d mask)
           BLENDVPD xmm1,       xmm2/m128, <XMM0>
          VBLENDVPD xmm1, xmm2, xmm3/m128, xmm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blendv_epi8 (__m128i a, __m128i b, __m128i mask)
           PBLENDVB xmm1,       xmm2/m128, <XMM0>
          VPBLENDVB xmm1, xmm2, xmm3/m128, xmm4
        This intrinsic generates PBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_blendv_ps (__m128 a, __m128 b, __m128 mask)
           BLENDVPS xmm1,       xmm2/m128, <XMM0>
          VBLENDVPS xmm1, xmm2, xmm3/m128, xmm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_blendv_pd (__m128d a, __m128d b, __m128d mask)
           BLENDVPD xmm1,       xmm2/m128, <XMM0>
          VBLENDVPD xmm1, xmm2, xmm3/m128, xmm4
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_ceil_ps (__m128 a)
           ROUNDPS xmm1, xmm2/m128, imm8(10)
          VROUNDPS xmm1, xmm2/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_ceil_pd (__m128d a)
           ROUNDPD xmm1, xmm2/m128, imm8(10)
          VROUNDPD xmm1, xmm2/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_ceil_ps (__m128 a)
           ROUNDPS xmm1, xmm2/m128, imm8(10)
          VROUNDPS xmm1, xmm2/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_ceil_pd (__m128d a)
           ROUNDPD xmm1, xmm2/m128, imm8(10)
          VROUNDPD xmm1, xmm2/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_ceil_ss (__m128 a)
           ROUNDSS xmm1,       xmm2/m128, imm8(10)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_ceil_ss (__m128 a, __m128 b)
           ROUNDSS xmm1,       xmm2/m128, imm8(10)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_ceil_sd (__m128d a)
           ROUNDSD xmm1,       xmm2/m128, imm8(10)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_ceil_sd (__m128d a, __m128d b)
           ROUNDSD xmm1,       xmm2/m128, imm8(10)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_ceil_ss (__m128 a)
           ROUNDSS xmm1,       xmm2/m128, imm8(10)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_ceil_ss (__m128 a, __m128 b)
           ROUNDSS xmm1,       xmm2/m128, imm8(10)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_ceil_sd (__m128d a)
           ROUNDSD xmm1,       xmm2/m128, imm8(10)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def CeilingScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_ceil_sd (__m128d a, __m128d b)
           ROUNDSD xmm1,       xmm2/m128, imm8(10)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi64 (__m128i a, __m128i b)
           PCMPEQQ xmm1,       xmm2/m128
          VPCMPEQQ xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi64 (__m128i a, __m128i b)
           PCMPEQQ xmm1,       xmm2/m128
          VPCMPEQQ xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi64 (__m128i a, __m128i b)
           PCMPEQQ xmm1,       xmm2/m128
          VPCMPEQQ xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpeq_epi64 (__m128i a, __m128i b)
           PCMPEQQ xmm1,       xmm2/m128
          VPCMPEQQ xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi8_epi16 (__m128i a)
           PMOVSXBW xmm1,         xmm2/m64
          VPMOVSXBW xmm1,         xmm2/m64
          VPMOVSXBW xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu8_epi16 (__m128i a)
           PMOVZXBW xmm1,         xmm2/m64
          VPMOVZXBW xmm1,         xmm2/m64
          VPMOVZXBW xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXBW xmm1,         m64
          VPMOVSXBW xmm1,         m64
          VPMOVSXBW xmm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXBW xmm1,         m64
          VPMOVZXBW xmm1,         m64
          VPMOVZXBW xmm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi8_epi16 (__m128i a)
           PMOVSXBW xmm1,         xmm2/m64
          VPMOVSXBW xmm1,         xmm2/m64
          VPMOVSXBW xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu8_epi16 (__m128i a)
           PMOVZXBW xmm1,         xmm2/m64
          VPMOVZXBW xmm1,         xmm2/m64
          VPMOVZXBW xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXBW xmm1,         m64
          VPMOVSXBW xmm1,         m64
          VPMOVSXBW xmm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXBW xmm1,         m64
          VPMOVZXBW xmm1,         m64
          VPMOVZXBW xmm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi8_epi32 (__m128i a)
           PMOVSXBD xmm1,         xmm2/m32
          VPMOVSXBD xmm1,         xmm2/m32
          VPMOVSXBD xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu8_epi32 (__m128i a)
           PMOVZXBD xmm1,         xmm2/m32
          VPMOVZXBD xmm1,         xmm2/m32
          VPMOVZXBD xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi16_epi32 (__m128i a)
           PMOVSXWD xmm1,         xmm2/m64
          VPMOVSXWD xmm1,         xmm2/m64
          VPMOVSXWD xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu16_epi32 (__m128i a)
           PMOVZXWD xmm1,         xmm2/m64
          VPMOVZXWD xmm1,         xmm2/m64
          VPMOVZXWD xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXBD xmm1,         m32
          VPMOVSXBD xmm1,         m32
          VPMOVSXBD xmm1 {k1}{z}, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXBD xmm1,         m32
          VPMOVZXBD xmm1,         m32
          VPMOVZXBD xmm1 {k1}{z}, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXWD xmm1,         m64
          VPMOVSXWD xmm1,         m64
          VPMOVSXWD xmm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXWD xmm1,         m64
          VPMOVZXWD xmm1,         m64
          VPMOVZXWD xmm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi8_epi32 (__m128i a)
           PMOVSXBD xmm1,         xmm2/m32
          VPMOVSXBD xmm1,         xmm2/m32
          VPMOVSXBD xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu8_epi32 (__m128i a)
           PMOVZXBD xmm1,         xmm2/m32
          VPMOVZXBD xmm1,         xmm2/m32
          VPMOVZXBD xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi16_epi32 (__m128i a)
           PMOVSXWD xmm1,         xmm2/m64
          VPMOVSXWD xmm1,         xmm2/m64
          VPMOVSXWD xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu16_epi32 (__m128i a)
           PMOVZXWD xmm1,         xmm2/m64
          VPMOVZXWD xmm1,         xmm2/m64
          VPMOVZXWD xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXBD xmm1,         m32
          VPMOVSXBD xmm1,         m32
          VPMOVSXBD xmm1 {k1}{z}, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXBD xmm1,         m32
          VPMOVZXBD xmm1,         m32
          VPMOVZXBD xmm1 {k1}{z}, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXWD xmm1,         m64
          VPMOVSXWD xmm1,         m64
          VPMOVSXWD xmm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXWD xmm1,         m64
          VPMOVZXWD xmm1,         m64
          VPMOVZXWD xmm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi8_epi64 (__m128i a)
           PMOVSXBQ xmm1,         xmm2/m16
          VPMOVSXBQ xmm1,         xmm2/m16
          VPMOVSXBQ xmm1 {k1}{z}, xmm2/m16
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu8_epi64 (__m128i a)
           PMOVZXBQ xmm1,         xmm2/m16
          VPMOVZXBQ xmm1,         xmm2/m16
          VPMOVZXBQ xmm1 {k1}{z}, xmm2/m16
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi16_epi64 (__m128i a)
           PMOVSXWQ xmm1,         xmm2/m32
          VPMOVSXWQ xmm1,         xmm2/m32
          VPMOVSXWQ xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu16_epi64 (__m128i a)
           PMOVZXWQ xmm1,         xmm2/m32
          VPMOVZXWQ xmm1,         xmm2/m32
          VPMOVZXWQ xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi32_epi64 (__m128i a)
           PMOVSXDQ xmm1,         xmm2/m64
          VPMOVSXDQ xmm1,         xmm2/m64
          VPMOVSXDQ xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu32_epi64 (__m128i a)
           PMOVZXDQ xmm1,         xmm2/m64
          VPMOVZXDQ xmm1,         xmm2/m64
          VPMOVZXDQ xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXBQ xmm1,         m16
          VPMOVSXBQ xmm1,         m16
          VPMOVSXBQ xmm1 {k1}{z}, m16
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXBQ xmm1,         m16
          VPMOVZXBQ xmm1,         m16
          VPMOVZXBQ xmm1 {k1}{z}, m16
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXWQ xmm1,         m32
          VPMOVSXWQ xmm1,         m32
          VPMOVSXWQ xmm1 {k1}{z}, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXWQ xmm1,         m32
          VPMOVZXWQ xmm1,         m32
          VPMOVZXWQ xmm1 {k1}{z}, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXDQ xmm1,         m64
          VPMOVSXDQ xmm1,         m64
          VPMOVSXDQ xmm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXDQ xmm1,         m64
          VPMOVZXDQ xmm1,         m64
          VPMOVZXDQ xmm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi8_epi64 (__m128i a)
           PMOVSXBQ xmm1,         xmm2/m16
          VPMOVSXBQ xmm1,         xmm2/m16
          VPMOVSXBQ xmm1 {k1}{z}, xmm2/m16
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu8_epi64 (__m128i a)
           PMOVZXBQ xmm1,         xmm2/m16
          VPMOVZXBQ xmm1,         xmm2/m16
          VPMOVZXBQ xmm1 {k1}{z}, xmm2/m16
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi16_epi64 (__m128i a)
           PMOVSXWQ xmm1,         xmm2/m32
          VPMOVSXWQ xmm1,         xmm2/m32
          VPMOVSXWQ xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu16_epi64 (__m128i a)
           PMOVZXWQ xmm1,         xmm2/m32
          VPMOVZXWQ xmm1,         xmm2/m32
          VPMOVZXWQ xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepi32_epi64 (__m128i a)
           PMOVSXDQ xmm1,         xmm2/m64
          VPMOVSXDQ xmm1,         xmm2/m64
          VPMOVSXDQ xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cvtepu32_epi64 (__m128i a)
           PMOVZXDQ xmm1,         xmm2/m64
          VPMOVZXDQ xmm1,         xmm2/m64
          VPMOVZXDQ xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXBQ xmm1,         m16
          VPMOVSXBQ xmm1,         m16
          VPMOVSXBQ xmm1 {k1}{z}, m16
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXBQ xmm1,         m16
          VPMOVZXBQ xmm1,         m16
          VPMOVZXBQ xmm1 {k1}{z}, m16
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXWQ xmm1,         m32
          VPMOVSXWQ xmm1,         m32
          VPMOVSXWQ xmm1 {k1}{z}, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXWQ xmm1,         m32
          VPMOVZXWQ xmm1,         m32
          VPMOVZXWQ xmm1 {k1}{z}, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVSXDQ xmm1,         m64
          VPMOVSXDQ xmm1,         m64
          VPMOVSXDQ xmm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        PMOVZXDQ xmm1,         m64
          VPMOVZXDQ xmm1,         m64
          VPMOVZXDQ xmm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def DotProduct(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_dp_ps (__m128 a, __m128 b, const int imm8)
           DPPS xmm1,       xmm2/m128, imm8
          VDPPS xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def DotProduct(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_dp_pd (__m128d a, __m128d b, const int imm8)
           DPPD xmm1,       xmm2/m128, imm8
          VDPPD xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def DotProduct(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_dp_ps (__m128 a, __m128 b, const int imm8)
           DPPS xmm1,       xmm2/m128, imm8
          VDPPS xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def DotProduct(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_dp_pd (__m128d a, __m128d b, const int imm8)
           DPPD xmm1,       xmm2/m128, imm8
          VDPPD xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi8 (__m128i a, const int imm8)
           PEXTRB r/m8, xmm1, imm8
          VPEXTRB r/m8, xmm1, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi32 (__m128i a, const int imm8)
           PEXTRD r/m32, xmm1, imm8
          VPEXTRD r/m32, xmm1, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi32 (__m128i a, const int imm8)
           PEXTRD r/m32, xmm1, imm8
          VPEXTRD r/m32, xmm1, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[float], index: int) -> float:
        """
        int _mm_extract_ps (__m128 a, const int imm8)
           EXTRACTPS r/m32, xmm1, imm8
          VEXTRACTPS r/m32, xmm1, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi8 (__m128i a, const int imm8)
           PEXTRB r/m8, xmm1, imm8
          VPEXTRB r/m8, xmm1, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi32 (__m128i a, const int imm8)
           PEXTRD r/m32, xmm1, imm8
          VPEXTRD r/m32, xmm1, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[int], index: int) -> int:
        """
        int _mm_extract_epi32 (__m128i a, const int imm8)
           PEXTRD r/m32, xmm1, imm8
          VPEXTRD r/m32, xmm1, imm8
        """
        ...

    @staticmethod
    @overload
    def Extract(value: System.Runtime.Intrinsics.Vector128[float], index: int) -> float:
        """
        int _mm_extract_ps (__m128 a, const int imm8)
           EXTRACTPS r/m32, xmm1, imm8
          VEXTRACTPS r/m32, xmm1, imm8
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_floor_ps (__m128 a)
           ROUNDPS xmm1, xmm2/m128, imm8(9)
          VROUNDPS xmm1, xmm2/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_floor_pd (__m128d a)
           ROUNDPD xmm1, xmm2/m128, imm8(9)
          VROUNDPD xmm1, xmm2/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_floor_ps (__m128 a)
           ROUNDPS xmm1, xmm2/m128, imm8(9)
          VROUNDPS xmm1, xmm2/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_floor_pd (__m128d a)
           ROUNDPD xmm1, xmm2/m128, imm8(9)
          VROUNDPD xmm1, xmm2/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_floor_ss (__m128 a)
           ROUNDSS xmm1,       xmm2/m128, imm8(9)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_floor_ss (__m128 a, __m128 b)
           ROUNDSS xmm1,       xmm2/m128, imm8(9)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_floor_sd (__m128d a)
           ROUNDSD xmm1,       xmm2/m128, imm8(9)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_floor_sd (__m128d a, __m128d b)
           ROUNDSD xmm1,       xmm2/m128, imm8(9)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_floor_ss (__m128 a)
           ROUNDSS xmm1,       xmm2/m128, imm8(9)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_floor_ss (__m128 a, __m128 b)
           ROUNDSS xmm1,       xmm2/m128, imm8(9)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_floor_sd (__m128d a)
           ROUNDSD xmm1,       xmm2/m128, imm8(9)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def FloorScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_floor_sd (__m128d a, __m128d b)
           ROUNDSD xmm1,       xmm2/m128, imm8(9)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi8 (__m128i a, int i, const int imm8)
           PINSRB xmm1,       r/m8, imm8
          VPINSRB xmm1, xmm2, r/m8, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi8 (__m128i a, int i, const int imm8)
           PINSRB xmm1,       r/m8, imm8
          VPINSRB xmm1, xmm2, r/m8, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi32 (__m128i a, int i, const int imm8)
           PINSRD xmm1,       r/m32, imm8
          VPINSRD xmm1, xmm2, r/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi32 (__m128i a, int i, const int imm8)
           PINSRD xmm1,       r/m32, imm8
          VPINSRD xmm1, xmm2, r/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_insert_ps (__m128 a, __m128 b, const int imm8)
           INSERTPS xmm1,       xmm2/m32, imm8
          VINSERTPS xmm1, xmm2, xmm3/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi8 (__m128i a, int i, const int imm8)
           PINSRB xmm1,       r/m8, imm8
          VPINSRB xmm1, xmm2, r/m8, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi8 (__m128i a, int i, const int imm8)
           PINSRB xmm1,       r/m8, imm8
          VPINSRB xmm1, xmm2, r/m8, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi32 (__m128i a, int i, const int imm8)
           PINSRD xmm1,       r/m32, imm8
          VPINSRD xmm1, xmm2, r/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[int], data: int, index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_insert_epi32 (__m128i a, int i, const int imm8)
           PINSRD xmm1,       r/m32, imm8
          VPINSRD xmm1, xmm2, r/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def Insert(value: System.Runtime.Intrinsics.Vector128[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_insert_ps (__m128 a, __m128 b, const int imm8)
           INSERTPS xmm1,       xmm2/m32, imm8
          VINSERTPS xmm1, xmm2, xmm3/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector128NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_stream_load_si128 (const __m128i* mem_addr)
           MOVNTDQA xmm1, m128
          VMOVNTDQA xmm1, m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epi8 (__m128i a, __m128i b)
           PMAXSB xmm1,               xmm2/m128
          VPMAXSB xmm1,         xmm2, xmm3/m128
          VPMAXSB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epu16 (__m128i a, __m128i b)
           PMAXUW xmm1,               xmm2/m128
          VPMAXUW xmm1,         xmm2, xmm3/m128
          VPMAXUW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epi32 (__m128i a, __m128i b)
           PMAXSD xmm1,               xmm2/m128
          VPMAXSD xmm1,         xmm2, xmm3/m128
          VPMAXSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epu32 (__m128i a, __m128i b)
           PMAXUD xmm1,               xmm2/m128
          VPMAXUD xmm1,         xmm2, xmm3/m128
          VPMAXUD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epi8 (__m128i a, __m128i b)
           PMAXSB xmm1,               xmm2/m128
          VPMAXSB xmm1,         xmm2, xmm3/m128
          VPMAXSB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epu16 (__m128i a, __m128i b)
           PMAXUW xmm1,               xmm2/m128
          VPMAXUW xmm1,         xmm2, xmm3/m128
          VPMAXUW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epi32 (__m128i a, __m128i b)
           PMAXSD xmm1,               xmm2/m128
          VPMAXSD xmm1,         xmm2, xmm3/m128
          VPMAXSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_max_epu32 (__m128i a, __m128i b)
           PMAXUD xmm1,               xmm2/m128
          VPMAXUD xmm1,         xmm2, xmm3/m128
          VPMAXUD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epi8 (__m128i a, __m128i b)
           PMINSB xmm1,               xmm2/m128
          VPMINSB xmm1,         xmm2, xmm3/m128
          VPMINSB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epu16 (__m128i a, __m128i b)
           PMINUW xmm1,               xmm2/m128
          VPMINUW xmm1,         xmm2, xmm3/m128
          VPMINUW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epi32 (__m128i a, __m128i b)
           PMINSD xmm1,               xmm2/m128
          VPMINSD xmm1,         xmm2, xmm3/m128
          VPMINSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epu32 (__m128i a, __m128i b)
           PMINUD xmm1,               xmm2/m128
          VPMINUD xmm1,         xmm2, xmm3/m128
          VPMINUD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epi8 (__m128i a, __m128i b)
           PMINSB xmm1,               xmm2/m128
          VPMINSB xmm1,         xmm2, xmm3/m128
          VPMINSB xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epu16 (__m128i a, __m128i b)
           PMINUW xmm1,               xmm2/m128
          VPMINUW xmm1,         xmm2, xmm3/m128
          VPMINUW xmm1 {k1}{z}, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epi32 (__m128i a, __m128i b)
           PMINSD xmm1,               xmm2/m128
          VPMINSD xmm1,         xmm2, xmm3/m128
          VPMINSD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_min_epu32 (__m128i a, __m128i b)
           PMINUD xmm1,               xmm2/m128
          VPMINUD xmm1,         xmm2, xmm3/m128
          VPMINUD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def MinHorizontal(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_minpos_epu16 (__m128i a)
           PHMINPOSUW xmm1, xmm2/m128
          VPHMINPOSUW xmm1, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def MinHorizontal(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_minpos_epu16 (__m128i a)
           PHMINPOSUW xmm1, xmm2/m128
          VPHMINPOSUW xmm1, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def MultipleSumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mpsadbw_epu8 (__m128i a, __m128i b, const int imm8)
           MPSADBW xmm1,       xmm2/m128, imm8
          VMPSADBW xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def MultipleSumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], mask: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mpsadbw_epu8 (__m128i a, __m128i b, const int imm8)
           MPSADBW xmm1,       xmm2/m128, imm8
          VMPSADBW xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mul_epi32 (__m128i a, __m128i b)
           PMULDQ xmm1,               xmm2/m128
          VPMULDQ xmm1,         xmm2, xmm3/m128
          VPMULDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mul_epi32 (__m128i a, __m128i b)
           PMULDQ xmm1,               xmm2/m128
          VPMULDQ xmm1,         xmm2, xmm3/m128
          VPMULDQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi32 (__m128i a, __m128i b)
           PMULLD xmm1,               xmm2/m128
          VPMULLD xmm1,         xmm2, xmm3/m128
          VPMULLD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi32 (__m128i a, __m128i b)
           PMULLD xmm1,               xmm2/m128
          VPMULLD xmm1,         xmm2, xmm3/m128
          VPMULLD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi32 (__m128i a, __m128i b)
           PMULLD xmm1,               xmm2/m128
          VPMULLD xmm1,         xmm2, xmm3/m128
          VPMULLD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mullo_epi32 (__m128i a, __m128i b)
           PMULLD xmm1,               xmm2/m128
          VPMULLD xmm1,         xmm2, xmm3/m128
          VPMULLD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packus_epi32 (__m128i a, __m128i b)
           PACKUSDW xmm1,               xmm2/m128
          VPACKUSDW xmm1,         xmm2, xmm3/m128
          VPACKUSDW xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_packus_epi32 (__m128i a, __m128i b)
           PACKUSDW xmm1,               xmm2/m128
          VPACKUSDW xmm1,         xmm2, xmm3/m128
          VPACKUSDW xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ps (__m128 a, _MM_FROUND_CUR_DIRECTION)
           ROUNDPS xmm1, xmm2/m128, imm8(4)
          VROUNDPS xmm1, xmm2/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_pd (__m128d a, _MM_FROUND_CUR_DIRECTION)
           ROUNDPD xmm1, xmm2/m128, imm8(4)
          VROUNDPD xmm1, xmm2/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ps (__m128 a, _MM_FROUND_CUR_DIRECTION)
           ROUNDPS xmm1, xmm2/m128, imm8(4)
          VROUNDPS xmm1, xmm2/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_pd (__m128d a, _MM_FROUND_CUR_DIRECTION)
           ROUNDPD xmm1, xmm2/m128, imm8(4)
          VROUNDPD xmm1, xmm2/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_CUR_DIRECTION)
           ROUNDSS xmm1,       xmm2/m128, imm8(4)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_CUR_DIRECTION)
           ROUNDSS xmm1,       xmm2/m128, imm8(4)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_CUR_DIRECTION)
           ROUNDSD xmm1,       xmm2/m128, imm8(4)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_CUR_DIRECTION)
           ROUNDSD xmm1,       xmm2/m128, imm8(4)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_CUR_DIRECTION)
           ROUNDSS xmm1,       xmm2/m128, imm8(4)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_CUR_DIRECTION)
           ROUNDSS xmm1,       xmm2/m128, imm8(4)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_CUR_DIRECTION)
           ROUNDSD xmm1,       xmm2/m128, imm8(4)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirectionScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_CUR_DIRECTION)
           ROUNDSD xmm1,       xmm2/m128, imm8(4)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC)
           ROUNDPS xmm1, xmm2/m128, imm8(8)
          VROUNDPS xmm1, xmm2/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC)
           ROUNDPD xmm1, xmm2/m128, imm8(8)
          VROUNDPD xmm1, xmm2/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC)
           ROUNDPS xmm1, xmm2/m128, imm8(8)
          VROUNDPS xmm1, xmm2/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_NEAREST_INT |_MM_FROUND_NO_EXC)
           ROUNDPD xmm1, xmm2/m128, imm8(8)
          VROUNDPD xmm1, xmm2/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(8)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(8)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(8)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(8)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(8)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(8)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(8)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestIntegerScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_NEAREST_INT | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(8)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC)
           ROUNDPS xmm1, xmm2/m128, imm8(9)
          VROUNDPS xmm1, xmm2/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC)
           ROUNDPD xmm1, xmm2/m128, imm8(9)
          VROUNDPD xmm1, xmm2/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC)
           ROUNDPS xmm1, xmm2/m128, imm8(9)
          VROUNDPS xmm1, xmm2/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_NEG_INF |_MM_FROUND_NO_EXC)
           ROUNDPD xmm1, xmm2/m128, imm8(9)
          VROUNDPD xmm1, xmm2/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(9)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(9)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(9)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(9)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(9)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(9)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(9)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(9)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC)
           ROUNDPS xmm1, xmm2/m128, imm8(10)
          VROUNDPS xmm1, xmm2/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC)
           ROUNDPD xmm1, xmm2/m128, imm8(10)
          VROUNDPD xmm1, xmm2/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC)
           ROUNDPS xmm1, xmm2/m128, imm8(10)
          VROUNDPS xmm1, xmm2/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_POS_INF |_MM_FROUND_NO_EXC)
           ROUNDPD xmm1, xmm2/m128, imm8(10)
          VROUNDPD xmm1, xmm2/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(10)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(10)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(10)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(10)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(10)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(10)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(10)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinityScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128d b, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(10)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC)
           ROUNDPS xmm1, xmm2/m128, imm8(11)
          VROUNDPS xmm1, xmm2/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC)
           ROUNDPD xmm1, xmm2/m128, imm8(11)
          VROUNDPD xmm1, xmm2/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ps (__m128 a, _MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC)
           ROUNDPS xmm1, xmm2/m128, imm8(11)
          VROUNDPS xmm1, xmm2/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_pd (__m128 a, _MM_FROUND_TO_ZERO |_MM_FROUND_NO_EXC)
           ROUNDPD xmm1, xmm2/m128, imm8(11)
          VROUNDPD xmm1, xmm2/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(11)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(11)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(11)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128 b, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(11)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(11)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_round_ss (__m128 a, __m128 b, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
           ROUNDSS xmm1,       xmm2/m128, imm8(11)
          VROUNDSS xmm1, xmm2, xmm3/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(11)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZeroScalar(upper: System.Runtime.Intrinsics.Vector128[float], value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_round_sd (__m128d a, __m128 b, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
           ROUNDSD xmm1,       xmm2/m128, imm8(11)
          VROUNDSD xmm1, xmm2, xmm3/m128, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; CF=1
          VPTEST xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testnzc_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
          VPTEST xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> bool:
        """
        int _mm_testz_si128 (__m128i a, __m128i b)
           PTEST xmm1, xmm2/m128    ; ZF=1
          VPTEST xmm1, xmm2/m128    ; ZF=1
        """
        ...


class Sse42(System.Runtime.Intrinsics.X86.Sse41, metaclass=abc.ABCMeta):
    """This class provides access to Intel SSE4.2 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse41.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def Crc32(crc: int, data: int) -> int:
            """
            unsigned __int64 _mm_crc32_u64 (unsigned __int64 crc, unsigned __int64 v)
              CRC32 r64, r/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def Crc32(crc: int, data: int) -> int:
            """
            unsigned __int64 _mm_crc32_u64 (unsigned __int64 crc, unsigned __int64 v)
              CRC32 r64, r/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi64 (__m128i a, __m128i b)
           PCMPGTQ xmm1,       xmm2/m128
          VPCMPGTQ xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_cmpgt_epi64 (__m128i a, __m128i b)
           PCMPGTQ xmm1,       xmm2/m128
          VPCMPGTQ xmm1, xmm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def Crc32(crc: int, data: int) -> int:
        """
        unsigned int _mm_crc32_u8 (unsigned int crc, unsigned char v)
          CRC32 r32, r/m8
        """
        ...

    @staticmethod
    @overload
    def Crc32(crc: int, data: int) -> int:
        """
        unsigned int _mm_crc32_u16 (unsigned int crc, unsigned short v)
          CRC32 r32, r/m16
        """
        ...

    @staticmethod
    @overload
    def Crc32(crc: int, data: int) -> int:
        """
        unsigned int _mm_crc32_u32 (unsigned int crc, unsigned int v)
          CRC32 r32, r/m32
        """
        ...

    @staticmethod
    @overload
    def Crc32(crc: int, data: int) -> int:
        """
        unsigned int _mm_crc32_u8 (unsigned int crc, unsigned char v)
          CRC32 r32, r/m8
        """
        ...

    @staticmethod
    @overload
    def Crc32(crc: int, data: int) -> int:
        """
        unsigned int _mm_crc32_u16 (unsigned int crc, unsigned short v)
          CRC32 r32, r/m16
        """
        ...

    @staticmethod
    @overload
    def Crc32(crc: int, data: int) -> int:
        """
        unsigned int _mm_crc32_u32 (unsigned int crc, unsigned int v)
          CRC32 r32, r/m32
        """
        ...


class Popcnt(System.Runtime.Intrinsics.X86.Sse42, metaclass=abc.ABCMeta):
    """This class provides access to Intel POPCNT hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse42.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def PopCount(value: int) -> int:
            """
            __int64 _mm_popcnt_u64 (unsigned __int64 a)
              POPCNT r64, r/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

        @staticmethod
        @overload
        def PopCount(value: int) -> int:
            """
            __int64 _mm_popcnt_u64 (unsigned __int64 a)
              POPCNT r64, r/m64
            This intrinsic is only available on 64-bit processes
            """
            ...

    IsSupported: bool

    @staticmethod
    @overload
    def PopCount(value: int) -> int:
        """
        int _mm_popcnt_u32 (unsigned int a)
          POPCNT r32, r/m32
        """
        ...

    @staticmethod
    @overload
    def PopCount(value: int) -> int:
        """
        int _mm_popcnt_u32 (unsigned int a)
          POPCNT r32, r/m32
        """
        ...


class FloatComparisonMode(System.Enum):
    """This class has no documentation."""

    OrderedEqualNonSignaling = 0
    """_CMP_EQ_OQ"""

    OrderedLessThanSignaling = 1
    """_CMP_LT_OS"""

    OrderedLessThanOrEqualSignaling = 2
    """_CMP_LE_OS"""

    UnorderedNonSignaling = 3
    """_CMP_UNORD_Q"""

    UnorderedNotEqualNonSignaling = 4
    """_CMP_NEQ_UQ"""

    UnorderedNotLessThanSignaling = 5
    """_CMP_NLT_US"""

    UnorderedNotLessThanOrEqualSignaling = 6
    """_CMP_NLE_US"""

    OrderedNonSignaling = 7
    """_CMP_ORD_Q"""

    UnorderedEqualNonSignaling = 8
    """_CMP_EQ_UQ"""

    UnorderedNotGreaterThanOrEqualSignaling = 9
    """_CMP_NGE_US"""

    UnorderedNotGreaterThanSignaling = 10
    """_CMP_NGT_US"""

    OrderedFalseNonSignaling = 11
    """_CMP_FALSE_OQ"""

    OrderedNotEqualNonSignaling = 12
    """_CMP_NEQ_OQ"""

    OrderedGreaterThanOrEqualSignaling = 13
    """_CMP_GE_OS"""

    OrderedGreaterThanSignaling = 14
    """_CMP_GT_OS"""

    UnorderedTrueNonSignaling = 15
    """_CMP_TRUE_UQ"""

    OrderedEqualSignaling = 16
    """_CMP_EQ_OS"""

    OrderedLessThanNonSignaling = 17
    """_CMP_LT_OQ"""

    OrderedLessThanOrEqualNonSignaling = 18
    """_CMP_LE_OQ"""

    UnorderedSignaling = 19
    """_CMP_UNORD_S"""

    UnorderedNotEqualSignaling = 20
    """_CMP_NEQ_US"""

    UnorderedNotLessThanNonSignaling = 21
    """_CMP_NLT_UQ"""

    UnorderedNotLessThanOrEqualNonSignaling = 22
    """_CMP_NLE_UQ"""

    OrderedSignaling = 23
    """_CMP_ORD_S"""

    UnorderedEqualSignaling = 24
    """_CMP_EQ_US"""

    UnorderedNotGreaterThanOrEqualNonSignaling = 25
    """_CMP_NGE_UQ"""

    UnorderedNotGreaterThanNonSignaling = 26
    """_CMP_NGT_UQ"""

    OrderedFalseSignaling = 27
    """_CMP_FALSE_OS"""

    OrderedNotEqualSignaling = 28
    """_CMP_NEQ_OS"""

    OrderedGreaterThanOrEqualNonSignaling = 29
    """_CMP_GE_OQ"""

    OrderedGreaterThanNonSignaling = 30
    """_CMP_GT_OQ"""

    UnorderedTrueSignaling = 31
    """_CMP_TRUE_US"""


class Avx(System.Runtime.Intrinsics.X86.Sse42, metaclass=abc.ABCMeta):
    """This class provides access to Intel AVX hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Sse42.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_add_ps (__m256 a, __m256 b)
          VADDPS ymm1,         ymm2, ymm3/m256
          VADDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_add_pd (__m256d a, __m256d b)
          VADDPD ymm1,         ymm2, ymm3/m256
          VADDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_add_ps (__m256 a, __m256 b)
          VADDPS ymm1,         ymm2, ymm3/m256
          VADDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_add_pd (__m256d a, __m256d b)
          VADDPD ymm1,         ymm2, ymm3/m256
          VADDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_addsub_ps (__m256 a, __m256 b)
          VADDSUBPS ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_addsub_pd (__m256d a, __m256d b)
          VADDSUBPD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_addsub_ps (__m256 a, __m256 b)
          VADDSUBPS ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AddSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_addsub_pd (__m256d a, __m256d b)
          VADDSUBPD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_and_ps (__m256 a, __m256 b)
          VANDPS ymm1,         ymm2, ymm2/m256
          VANDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_and_pd (__m256d a, __m256d b)
          VANDPD ymm1,         ymm2, ymm2/m256
          VANDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_and_ps (__m256 a, __m256 b)
          VANDPS ymm1,         ymm2, ymm2/m256
          VANDPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_and_pd (__m256d a, __m256d b)
          VANDPD ymm1,         ymm2, ymm2/m256
          VANDPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_andnot_ps (__m256 a, __m256 b)
          VANDNPS ymm1,         ymm2, ymm2/m256
          VANDNPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_andnot_pd (__m256d a, __m256d b)
          VANDNPD ymm1,         ymm2, ymm2/m256
          VANDNPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_andnot_ps (__m256 a, __m256 b)
          VANDNPS ymm1,         ymm2, ymm2/m256
          VANDNPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_andnot_pd (__m256d a, __m256d b)
          VANDNPD ymm1,         ymm2, ymm2/m256
          VANDNPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_blend_ps (__m256 a, __m256 b, const int imm8)
          VBLENDPS ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_blend_pd (__m256d a, __m256d b, const int imm8)
          VBLENDPD ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_blend_ps (__m256 a, __m256 b, const int imm8)
          VBLENDPS ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_blend_pd (__m256d a, __m256d b, const int imm8)
          VBLENDPD ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_blendv_ps (__m256 a, __m256 b, __m256 mask)
          VBLENDVPS ymm1, ymm2, ymm3/m256, ymm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_blendv_pd (__m256d a, __m256d b, __m256d mask)
          VBLENDVPD ymm1, ymm2, ymm3/m256, ymm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_blendv_ps (__m256 a, __m256 b, __m256 mask)
          VBLENDVPS ymm1, ymm2, ymm3/m256, ymm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_blendv_pd (__m256d a, __m256d b, __m256d mask)
          VBLENDVPD ymm1, ymm2, ymm3/m256, ymm4
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_broadcast_ss (float const * mem_addr)
          VBROADCASTSS xmm1,         m32
          VBROADCASTSS xmm1 {k1}{z}, m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_broadcast_ss (float const * mem_addr)
          VBROADCASTSS xmm1,         m32
          VBROADCASTSS xmm1 {k1}{z}, m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_broadcast_ss (float const * mem_addr)
          VBROADCASTSS ymm1,         m32
          VBROADCASTSS ymm1 {k1}{z}, m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_broadcast_sd (double const * mem_addr)
          VBROADCASTSD ymm1,         m64
          VBROADCASTSD ymm1 {k1}{z}, m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_broadcast_ss (float const * mem_addr)
          VBROADCASTSS ymm1,         m32
          VBROADCASTSS ymm1 {k1}{z}, m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_broadcast_sd (double const * mem_addr)
          VBROADCASTSD ymm1,         m64
          VBROADCASTSD ymm1 {k1}{z}, m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_broadcast_ps (__m128 const * mem_addr)
          VBROADCASTF128  ymm1,         m128
          VBROADCASTF32x4 ymm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_broadcast_pd (__m128d const * mem_addr)
          VBROADCASTF128  ymm1,         m128
          VBROADCASTF64x2 ymm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_broadcast_ps (__m128 const * mem_addr)
          VBROADCASTF128  ymm1,         m128
          VBROADCASTF32x4 ymm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_broadcast_pd (__m128d const * mem_addr)
          VBROADCASTF128  ymm1,         m128
          VBROADCASTF64x2 ymm1 {k1}{z}, m128
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_ceil_ps (__m128 a)
          VROUNDPS ymm1, ymm2/m256, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_ceil_pd (__m128d a)
          VROUNDPD ymm1, ymm2/m256, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_ceil_ps (__m128 a)
          VROUNDPS ymm1, ymm2/m256, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Ceiling(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_ceil_pd (__m128d a)
          VROUNDPD ymm1, ymm2/m256, imm8(10)
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmp_ps (__m128 a, __m128 b, const int imm8)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmp_ps (__m256 a, __m256 b, const int imm8)
          VCMPPS ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmp_pd (__m128d a, __m128d b, const int imm8)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmp_pd (__m256d a, __m256d b, const int imm8)
          VCMPPD ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmp_ps (__m128 a, __m128 b, const int imm8)
          VCMPPS xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmp_ps (__m256 a, __m256 b, const int imm8)
          VCMPPS ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmp_pd (__m128d a, __m128d b, const int imm8)
          VCMPPD xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Compare(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmp_pd (__m256d a, __m256d b, const int imm8)
          VCMPPD ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpeq_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(0)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpeq_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(0)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpeq_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(0)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpeq_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(0)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpgt_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(14)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpgt_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(14)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpgt_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(14)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpgt_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(14)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpge_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(13)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpge_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(13)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpge_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(13)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpge_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(13)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmplt_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(1)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmplt_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(1)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmplt_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(1)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmplt_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(1)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmple_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(2)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmple_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(2)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmple_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(2)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmple_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(2)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpneq_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(4)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpneq_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(4)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpneq_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(4)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpneq_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(4)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpngt_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(10)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpngt_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(10)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpngt_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(10)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpngt_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(10)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpnge_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(9)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpnge_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(9)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpnge_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(9)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotGreaterThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpnge_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(9)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpnlt_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(5)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpnlt_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(5)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpnlt_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(5)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThan(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpnlt_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(5)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpnle_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(6)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpnle_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(6)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpnle_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(6)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareNotLessThanOrEqual(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpnle_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(6)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpord_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(7)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpord_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(7)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpord_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(7)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareOrdered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpord_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(7)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmp_ss (__m128 a, __m128 b, const int imm8)
          VCMPSD xmm1, xmm2, xmm3/m64, imm8
        """
        ...

    @staticmethod
    @overload
    def CompareScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmp_sd (__m128d a, __m128d b, const int imm8)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def CompareScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_cmp_ss (__m128 a, __m128 b, const int imm8)
          VCMPSD xmm1, xmm2, xmm3/m64, imm8
        """
        ...

    @staticmethod
    @overload
    def CompareScalar(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float], mode: System.Runtime.Intrinsics.X86.FloatComparisonMode) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_cmp_sd (__m128d a, __m128d b, const int imm8)
          VCMPSS xmm1, xmm2, xmm3/m32, imm8
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpunord_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(3)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpunord_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(3)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cmpunord_ps (__m256 a,  __m256 b)
          VCMPPS ymm1, ymm2/m256, imm8(3)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def CompareUnordered(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cmpunord_pd (__m256d a,  __m256d b)
          VCMPPD ymm1, ymm2/m256, imm8(3)
        The above native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_cvtpd_epi32 (__m256d a)
          VCVTPD2DQ xmm1,         ymm2/m256
          VCVTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_cvtpd_epi32 (__m256d a)
          VCVTPD2DQ xmm1,         ymm2/m256
          VCVTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32WithTruncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_cvttpd_epi32 (__m256d a)
          VCVTTPD2DQ xmm1,         ymm2/m256
          VCVTTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Int32WithTruncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_cvttpd_epi32 (__m256d a)
          VCVTTPD2DQ xmm1,         ymm2/m256
          VCVTTPD2DQ xmm1 {k1}{z}, ymm2/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Single(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_cvtpd_ps (__m256d a)
          VCVTPD2PS xmm1,         ymm2/m256
          VCVTPD2PS xmm1 {k1}{z}, ymm2/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector128Single(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_cvtpd_ps (__m256d a)
          VCVTPD2PS xmm1,         ymm2/m256
          VCVTPD2PS xmm1 {k1}{z}, ymm2/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cvtepi32_pd (__m128i a)
          VCVTDQ2PD ymm1,         xmm2/m128
          VCVTDQ2PD ymm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Double(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cvtps_pd (__m128 a)
          VCVTPS2PD ymm1,         xmm2/m128
          VCVTPS2PD ymm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Double(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cvtepi32_pd (__m128i a)
          VCVTDQ2PD ymm1,         xmm2/m128
          VCVTDQ2PD ymm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Double(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_cvtps_pd (__m128 a)
          VCVTPS2PD ymm1,         xmm2/m128
          VCVTPS2PD ymm1 {k1}{z}, xmm2/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtps_epi32 (__m256 a)
          VCVTPS2DQ ymm1,         ymm2/m256
          VCVTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtps_epi32 (__m256 a)
          VCVTPS2DQ ymm1,         ymm2/m256
          VCVTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32WithTruncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvttps_epi32 (__m256 a)
          VCVTTPS2DQ ymm1,         ymm2/m256
          VCVTTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32WithTruncation(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvttps_epi32 (__m256 a)
          VCVTTPS2DQ ymm1,         ymm2/m256
          VCVTTPS2DQ ymm1 {k1}{z}, ymm2/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Single(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cvtepi32_ps (__m256i a)
          VCVTDQ2PS ymm1,         ymm2/m256
          VCVTDQ2PS ymm1 {k1}{z}, ymm2/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Single(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_cvtepi32_ps (__m256i a)
          VCVTDQ2PS ymm1,         ymm2/m256
          VCVTDQ2PS ymm1 {k1}{z}, ymm2/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_div_ps (__m256 a, __m256 b)
          VDIVPS ymm1,         ymm2, ymm3/m256
          VDIVPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_div_pd (__m256d a, __m256d b)
          VDIVPD ymm1,         ymm2, ymm3/m256
          VDIVPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_div_ps (__m256 a, __m256 b)
          VDIVPS ymm1,         ymm2, ymm3/m256
          VDIVPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_div_pd (__m256d a, __m256d b)
          VDIVPD ymm1,         ymm2, ymm3/m256
          VDIVPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def DotProduct(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_dp_ps (__m256 a, __m256 b, const int imm8)
          VDPPS ymm, ymm, ymm/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def DotProduct(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_dp_ps (__m256 a, __m256 b, const int imm8)
          VDPPS ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def DuplicateEvenIndexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_moveldup_ps (__m256 a)
          VMOVSLDUP ymm1,         ymm2/m256
          VMOVSLDUP ymm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def DuplicateEvenIndexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_movedup_pd (__m256d a)
          VMOVDDUP ymm1,         ymm2/m256
          VMOVDDUP ymm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def DuplicateEvenIndexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_moveldup_ps (__m256 a)
          VMOVSLDUP ymm1,         ymm2/m256
          VMOVSLDUP ymm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def DuplicateEvenIndexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_movedup_pd (__m256d a)
          VMOVDDUP ymm1,         ymm2/m256
          VMOVDDUP ymm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def DuplicateOddIndexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_movehdup_ps (__m256 a)
          VMOVSHDUP ymm1,         ymm2/m256
          VMOVSHDUP ymm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def DuplicateOddIndexed(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_movehdup_ps (__m256 a)
          VMOVSHDUP ymm1,         ymm2/m256
          VMOVSHDUP ymm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF64x2 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF64x2 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_extractf128_ps (__m256 a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm256_extractf128_pd (__m256d a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF64x2 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF64x2 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extractf128_si256 (__m256i a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF64x2 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_extractf128_ps (__m256 a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[float], index: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm256_extractf128_pd (__m256d a, const int imm8)
          VEXTRACTF128  xmm1/m128,         ymm2, imm8
          VEXTRACTF64x2 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_floor_ps (__m256 a)
          VROUNDPS ymm1, ymm2/m256, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_floor_pd (__m256d a)
          VROUNDPD ymm1, ymm2/m256, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_ceil_ps (__m128 a)
          VROUNDPS ymm1, ymm2/m256, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def Floor(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_ceil_pd (__m128d a)
          VROUNDPD ymm1, ymm2/m256, imm8(9)
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_hadd_ps (__m256 a, __m256 b)
          VHADDPS ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_hadd_pd (__m256d a, __m256d b)
          VHADDPD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_hadd_ps (__m256 a, __m256 b)
          VHADDPS ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_hadd_pd (__m256d a, __m256d b)
          VHADDPD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_hsub_ps (__m256 a, __m256 b)
          VHSUBPS ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_hsub_pd (__m256d a, __m256d b)
          VHSUBPD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_hsub_ps (__m256 a, __m256 b)
          VHSUBPS ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_hsub_pd (__m256d a, __m256d b)
          VHSUBPD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_insertf128_ps (__m256 a, __m128 b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_insertf128_pd (__m256d a, __m128d b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_insertf128_si256 (__m256i a, __m128i b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_insertf128_ps (__m256 a, __m128 b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[float], data: System.Runtime.Intrinsics.Vector128[float], index: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_insertf128_pd (__m256d a, __m128d b, int imm8)
          VINSERTF128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTF64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA64 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA64 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_load_ps (float const * mem_addr)
          VMOVAPS ymm1,         m256
          VMOVAPS ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_load_pd (double const * mem_addr)
          VMOVAPD ymm1,         m256
          VMOVAPD ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA64 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_load_si256 (__m256i const * mem_addr)
          VMOVDQA   ymm1,         m256
          VMOVDQA64 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_load_ps (float const * mem_addr)
          VMOVAPS ymm1,         m256
          VMOVAPS ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_load_pd (double const * mem_addr)
          VMOVAPD ymm1,         m256
          VMOVAPD ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadDquVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_lddqu_si256 (__m256i const * mem_addr)
          VLDDQU ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU  ymm1,         m256
          VMOVDQU8 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU  ymm1,         m256
          VMOVDQU8 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU   ymm1,         m256
          VMOVDQU16 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU   ymm1,         m256
          VMOVDQU16 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU   ymm1,         m256
          VMOVDQU32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU   ymm1,         m256
          VMOVDQU32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU   ymm1,         m256
          VMOVDQU64 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU   ymm1,         m256
          VMOVDQU64 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_loadu_ps (float const * mem_addr)
          VMOVUPS ymm1,         m256
          VMOVUPS ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_loadu_pd (double const * mem_addr)
          VMOVUPD ymm1,         m256
          VMOVUPD ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU  ymm1,         m256
          VMOVDQU8 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU  ymm1,         m256
          VMOVDQU8 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU   ymm1,         m256
          VMOVDQU16 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU   ymm1,         m256
          VMOVDQU16 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU   ymm1,         m256
          VMOVDQU32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU   ymm1,         m256
          VMOVDQU32 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU   ymm1,         m256
          VMOVDQU64 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_loadu_si256 (__m256i const * mem_addr)
          VMOVDQU   ymm1,         m256
          VMOVDQU64 ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_loadu_ps (float const * mem_addr)
          VMOVUPS ymm1,         m256
          VMOVUPS ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def LoadVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_loadu_pd (double const * mem_addr)
          VMOVUPD ymm1,         m256
          VMOVUPD ymm1 {k1}{z}, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_maskload_ps (float const * mem_addr, __m128i mask)
          VMASKMOVPS xmm1, xmm2, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_maskload_pd (double const * mem_addr, __m128i mask)
          VMASKMOVPD xmm1, xmm2, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_maskload_ps (float const * mem_addr, __m256i mask)
          VMASKMOVPS ymm1, ymm2, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_maskload_pd (double const * mem_addr, __m256i mask)
          VMASKMOVPD ymm1, ymm2, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_maskload_ps (float const * mem_addr, __m128i mask)
          VMASKMOVPS xmm1, xmm2, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_maskload_pd (double const * mem_addr, __m128i mask)
          VMASKMOVPD xmm1, xmm2, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_maskload_ps (float const * mem_addr, __m256i mask)
          VMASKMOVPS ymm1, ymm2, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_maskload_pd (double const * mem_addr, __m256i mask)
          VMASKMOVPD ymm1, ymm2, m256
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float], source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_maskstore_ps (float * mem_addr, __m128i mask, __m128 a)
          VMASKMOVPS m128, xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float], source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_maskstore_pd (double * mem_addr, __m128i mask, __m128d a)
          VMASKMOVPD m128, xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float], source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_maskstore_ps (float * mem_addr, __m256i mask, __m256 a)
          VMASKMOVPS m256, ymm1, ymm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float], source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_maskstore_pd (double * mem_addr, __m256i mask, __m256d a)
          VMASKMOVPD m256, ymm1, ymm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float], source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_maskstore_ps (float * mem_addr, __m128i mask, __m128 a)
          VMASKMOVPS m128, xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[float], source: System.Runtime.Intrinsics.Vector128[float]) -> None:
        """
        void _mm_maskstore_pd (double * mem_addr, __m128i mask, __m128d a)
          VMASKMOVPD m128, xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float], source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_maskstore_ps (float * mem_addr, __m256i mask, __m256 a)
          VMASKMOVPS m256, ymm1, ymm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[float], source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_maskstore_pd (double * mem_addr, __m256i mask, __m256d a)
          VMASKMOVPD m256, ymm1, ymm2
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_max_ps (__m256 a, __m256 b)
          VMAXPS ymm1,         ymm2, ymm3/m256
          VMAXPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_max_pd (__m256d a, __m256d b)
          VMAXPD ymm1,         ymm2, ymm3/m256
          VMAXPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_max_ps (__m256 a, __m256 b)
          VMAXPS ymm1,         ymm2, ymm3/m256
          VMAXPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_max_pd (__m256d a, __m256d b)
          VMAXPD ymm1,         ymm2, ymm3/m256
          VMAXPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_min_ps (__m256 a, __m256 b)
          VMINPS ymm1,         ymm2, ymm3/m256
          VMINPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_min_pd (__m256d a, __m256d b)
          VMINPD ymm1,         ymm2, ymm3/m256
          VMINPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_min_ps (__m256 a, __m256 b)
          VMINPS ymm1,         ymm2, ymm3/m256
          VMINPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_min_pd (__m256d a, __m256d b)
          VMINPD ymm1,         ymm2, ymm3/m256
          VMINPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[float]) -> int:
        """
        int _mm256_movemask_ps (__m256 a)
          VMOVMSKPS r32, ymm1
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[float]) -> int:
        """
        int _mm256_movemask_pd (__m256d a)
          VMOVMSKPD r32, ymm1
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[float]) -> int:
        """
        int _mm256_movemask_ps (__m256 a)
          VMOVMSKPS r32, ymm1
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[float]) -> int:
        """
        int _mm256_movemask_pd (__m256d a)
          VMOVMSKPD r32, ymm1
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_mul_ps (__m256 a, __m256 b)
          VMULPS ymm1,         ymm2, ymm3/m256
          VMULPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_mul_pd (__m256d a, __m256d b)
          VMULPD ymm1,         ymm2, ymm3/m256
          VMULPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_mul_ps (__m256 a, __m256 b)
          VMULPS ymm1,         ymm2, ymm3/m256
          VMULPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_mul_pd (__m256d a, __m256d b)
          VMULPD ymm1,         ymm2, ymm3/m256
          VMULPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_or_ps (__m256 a, __m256 b)
          VORPS ymm1,         ymm2, ymm3/m256
          VORPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_or_pd (__m256d a, __m256d b)
          VORPD ymm1,         ymm2, ymm3/m256
          VORPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_or_ps (__m256 a, __m256 b)
          VORPS ymm1,         ymm2, ymm3/m256
          VORPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_or_pd (__m256d a, __m256d b)
          VORPD ymm1,         ymm2, ymm3/m256
          VORPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_permute_ps (__m128 a, int imm8)
          VPERMILPS xmm1,         xmm2/m128,         imm8
          VPERMILPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_permute_pd (__m128d a, int imm8)
          VPERMILPD xmm1,         xmm2/m128,         imm8
          VPERMILPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permute_ps (__m256 a, int imm8)
          VPERMILPS ymm1,         ymm2/m256,         imm8
          VPERMILPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permute_pd (__m256d a, int imm8)
          VPERMILPD ymm1,         ymm2/m256,         imm8
          VPERMILPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_permute_ps (__m128 a, int imm8)
          VPERMILPS xmm1,         xmm2/m128,         imm8
          VPERMILPS xmm1 {k1}{z}, xmm2/m128/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector128[float], control: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_permute_pd (__m128d a, int imm8)
          VPERMILPD xmm1,         xmm2/m128,         imm8
          VPERMILPD xmm1 {k1}{z}, xmm2/m128/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permute_ps (__m256 a, int imm8)
          VPERMILPS ymm1,         ymm2/m256,         imm8
          VPERMILPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permute_pd (__m256d a, int imm8)
          VPERMILPD ymm1,         ymm2/m256,         imm8
          VPERMILPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permute2f128_ps (__m256 a, __m256 b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permute2f128_pd (__m256d a, __m256d b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2f128_si256 (__m256i a, __m256i b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permute2f128_ps (__m256 a, __m256 b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permute2f128_pd (__m256d a, __m256d b, int imm8)
          VPERM2F128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector128[float], control: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_permutevar_ps (__m128 a, __m128i b)
          VPERMILPS xmm1,         xmm2, xmm3/m128
          VPERMILPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector128[float], control: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_permutevar_pd (__m128d a, __m128i b)
          VPERMILPD xmm1,         xmm2, xmm3/m128
          VPERMILPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permutevar_ps (__m256 a, __m256i b)
          VPERMILPS ymm1,         ymm2, ymm3/m256
          VPERMILPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permutevar_pd (__m256d a, __m256i b)
          VPERMILPD ymm1,         ymm2, ymm3/m256
          VPERMILPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector128[float], control: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_permutevar_ps (__m128 a, __m128i b)
          VPERMILPS xmm1,         xmm2, xmm3/m128
          VPERMILPS xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector128[float], control: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_permutevar_pd (__m128d a, __m128i b)
          VPERMILPD xmm1,         xmm2, xmm3/m128
          VPERMILPD xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permutevar_ps (__m256 a, __m256i b)
          VPERMILPS ymm1,         ymm2, ymm3/m256
          VPERMILPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def PermuteVar(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permutevar_pd (__m256d a, __m256i b)
          VPERMILPD ymm1,         ymm2, ymm3/m256
          VPERMILPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Reciprocal(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_rcp_ps (__m256 a)
          VRCPPS ymm1, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def Reciprocal(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_rcp_ps (__m256 a)
          VRCPPS ymm1, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_rsqrt_ps (__m256 a)
          VRSQRTPS ymm1, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ReciprocalSqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_rsqrt_ps (__m256 a)
          VRSQRTPS ymm1, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_CUR_DIRECTION)
          VROUNDPS ymm1, ymm2/m256, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_ps (__m256d a, _MM_FROUND_CUR_DIRECTION)
          VROUNDPD ymm1, ymm2/m256, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_CUR_DIRECTION)
          VROUNDPS ymm1, ymm2/m256, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundCurrentDirection(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_ps (__m256d a, _MM_FROUND_CUR_DIRECTION)
          VROUNDPD ymm1, ymm2/m256, imm8(4)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_NEAREST_INT)
          VROUNDPS ymm1, ymm2/m256, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_NEAREST_INT)
          VROUNDPD ymm1, ymm2/m256, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_NEAREST_INT)
          VROUNDPS ymm1, ymm2/m256, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNearestInteger(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_NEAREST_INT)
          VROUNDPD ymm1, ymm2/m256, imm8(8)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
          VROUNDPS ymm1, ymm2/m256, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
          VROUNDPD ymm1, ymm2/m256, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
          VROUNDPS ymm1, ymm2/m256, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToNegativeInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_NEG_INF | _MM_FROUND_NO_EXC)
          VROUNDPD ymm1, ymm2/m256, imm8(9)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
          VROUNDPS ymm1, ymm2/m256, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
          VROUNDPD ymm1, ymm2/m256, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
          VROUNDPS ymm1, ymm2/m256, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToPositiveInfinity(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_POS_INF | _MM_FROUND_NO_EXC)
          VROUNDPD ymm1, ymm2/m256, imm8(10)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
          VROUNDPS ymm1, ymm2/m256, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
          VROUNDPD ymm1, ymm2/m256, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_round_ps (__m256 a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
          VROUNDPS ymm1, ymm2/m256, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def RoundToZero(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_round_pd (__m256d a, _MM_FROUND_TO_ZERO | _MM_FROUND_NO_EXC)
          VROUNDPD ymm1, ymm2/m256, imm8(11)
        The above native signature does not exist. We provide this additional overload for the recommended use case of this intrinsic.
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_shuffle_ps (__m256 a, __m256 b, const int imm8)
          VSHUFPS ymm1,         ymm2, ymm3/m256,         imm8
          VSHUFPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_shuffle_pd (__m256d a, __m256d b, const int imm8)
          VSHUFPD ymm1,         ymm2, ymm3/m256,         imm8
          VSHUFPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_shuffle_ps (__m256 a, __m256 b, const int imm8)
          VSHUFPS ymm1,         ymm2, ymm3/m256,         imm8
          VSHUFPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_shuffle_pd (__m256d a, __m256d b, const int imm8)
          VSHUFPD ymm1,         ymm2, ymm3/m256,         imm8
          VSHUFPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_sqrt_ps (__m256 a)
          VSQRTPS ymm1,         ymm2/m256
          VSQRTPS ymm1 {k1}{z}, ymm2/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_sqrt_pd (__m256d a)
          VSQRTPD ymm1,         ymm2/m256
          VSQRTPD ymm1 {k1}{z}, ymm2/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_sqrt_ps (__m256 a)
          VSQRTPS ymm1,         ymm2/m256
          VSQRTPS ymm1 {k1}{z}, ymm2/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Sqrt(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_sqrt_pd (__m256d a)
          VSQRTPD ymm1,         ymm2/m256
          VSQRTPD ymm1 {k1}{z}, ymm2/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU  m256,         ymm1
          VMOVDQU8 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU  m256,         ymm1
          VMOVDQU8 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU   m256,         ymm1
          VMOVDQU16 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU   m256,         ymm1
          VMOVDQU16 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU   m256,         ymm1
          VMOVDQU32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU   m256,         ymm1
          VMOVDQU32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU   m256,         ymm1
          VMOVDQU64 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU   m256,         ymm1
          VMOVDQU64 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_storeu_ps (float * mem_addr, __m256 a)
          VMOVUPS m256,         ymm1
          VMOVUPS m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_storeu_pd (double * mem_addr, __m256d a)
          VMOVUPD m256,         ymm1
          VMOVUPD m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU  m256,         ymm1
          VMOVDQU8 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU  m256,         ymm1
          VMOVDQU8 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU   m256,         ymm1
          VMOVDQU16 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU   m256,         ymm1
          VMOVDQU16 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU   m256,         ymm1
          VMOVDQU32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU   m256,         ymm1
          VMOVDQU32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU   m256,         ymm1
          VMOVDQU64 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_storeu_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQU   m256,         ymm1
          VMOVDQU64 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_storeu_ps (float * mem_addr, __m256 a)
          VMOVUPS m256,         ymm1
          VMOVUPS m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def Store(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_storeu_pd (double * mem_addr, __m256d a)
          VMOVUPD m256,         ymm1
          VMOVUPD m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA64 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA64 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_store_ps (float * mem_addr, __m256 a)
          VMOVAPS m256,         ymm1
          VMOVAPS m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_store_pd (double * mem_addr, __m256d a)
          VMOVAPD m256,         ymm1
          VMOVAPD m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA32 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA64 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_store_si256 (__m256i * mem_addr, __m256i a)
          VMOVDQA   m256,         ymm1
          VMOVDQA64 m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_store_ps (float * mem_addr, __m256 a)
          VMOVAPS m256,         ymm1
          VMOVAPS m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAligned(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_store_pd (double * mem_addr, __m256d a)
          VMOVAPD m256,         ymm1
          VMOVAPD m256 {k1}{z}, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_stream_ps (float * mem_addr, __m256 a)
          VMOVNTPS m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_stream_pd (double * mem_addr, __m256d a)
          VMOVNTPD m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_stream_si256 (__m256i * mem_addr, __m256i a)
          VMOVNTDQ m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_stream_ps (float * mem_addr, __m256 a)
          VMOVNTPS m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def StoreAlignedNonTemporal(address: typing.Any, source: System.Runtime.Intrinsics.Vector256[float]) -> None:
        """
        void _mm256_stream_pd (double * mem_addr, __m256d a)
          VMOVNTPD m256, ymm1
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_sub_ps (__m256 a, __m256 b)
          VSUBPS ymm1,         ymm2, ymm3/m256
          VSUBPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_sub_pd (__m256d a, __m256d b)
          VSUBPD ymm1,         ymm2, ymm3/m256
          VSUBPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_sub_ps (__m256 a, __m256 b)
          VSUBPS ymm1,         ymm2, ymm3/m256
          VSUBPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_sub_pd (__m256d a, __m256d b)
          VSUBPD ymm1,         ymm2, ymm3/m256
          VSUBPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testc_ps (__m128 a, __m128 b)
          VTESTPS xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testc_pd (__m128d a, __m128d b)
          VTESTPD xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testc_ps (__m256 a, __m256 b)
          VTESTPS ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testc_pd (__m256d a, __m256d b)
          VTESTPD ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testc_ps (__m128 a, __m128 b)
          VTESTPS xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testc_pd (__m128d a, __m128d b)
          VTESTPD xmm1, xmm2/m128    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testc_ps (__m256 a, __m256 b)
          VTESTPS ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testc_pd (__m256d a, __m256d b)
          VTESTPD ymm1, ymm2/m256    ; CF=1
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testnzc_ps (__m128 a, __m128 b)
          VTESTPS xmm1, ymm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testnzc_pd (__m128d a, __m128d b)
          VTESTPD xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testnzc_ps (__m256 a, __m256 b)
          VTESTPS ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testnzc_pd (__m256d a, __m256d b)
          VTESTPD ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testnzc_ps (__m128 a, __m128 b)
          VTESTPS xmm1, ymm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testnzc_pd (__m128d a, __m128d b)
          VTESTPD xmm1, xmm2/m128    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testnzc_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testnzc_ps (__m256 a, __m256 b)
          VTESTPS ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestNotZAndNotC(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testnzc_pd (__m256d a, __m256d b)
          VTESTPD ymm1, ymm2/m256    ; ZF=0 && CF=0
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testz_ps (__m128 a, __m128 b)
          VTESTPS xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testz_pd (__m128d a, __m128d b)
          VTESTPD xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testz_ps (__m256 a, __m256 b)
          VTESTPS ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testz_pd (__m256d a, __m256d b)
          VTESTPD ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testz_ps (__m128 a, __m128 b)
          VTESTPS xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector128[float], right: System.Runtime.Intrinsics.Vector128[float]) -> bool:
        """
        int _mm_testz_pd (__m128d a, __m128d b)
          VTESTPD xmm1, xmm2/m128    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> bool:
        """
        int _mm256_testz_si256 (__m256i a, __m256i b)
          VPTEST ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testz_ps (__m256 a, __m256 b)
          VTESTPS ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def TestZ(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> bool:
        """
        int _mm256_testz_pd (__m256d a, __m256d b)
          VTESTPD ymm1, ymm2/m256    ; ZF=1
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_unpackhi_ps (__m256 a, __m256 b)
          VUNPCKHPS ymm1,         ymm2, ymm3/m256
          VUNPCKHPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_unpackhi_pd (__m256d a, __m256d b)
          VUNPCKHPD ymm1,         ymm2, ymm3/m256
          VUNPCKHPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_unpackhi_ps (__m256 a, __m256 b)
          VUNPCKHPS ymm1,         ymm2, ymm3/m256
          VUNPCKHPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_unpackhi_pd (__m256d a, __m256d b)
          VUNPCKHPD ymm1,         ymm2, ymm3/m256
          VUNPCKHPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_unpacklo_ps (__m256 a, __m256 b)
          VUNPCKLPS ymm1,         ymm2, ymm3/m256
          VUNPCKLPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_unpacklo_pd (__m256d a, __m256d b)
          VUNPCKLPD ymm1,         ymm2, ymm3/m256
          VUNPCKLPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_unpacklo_ps (__m256 a, __m256 b)
          VUNPCKLPS ymm1,         ymm2, ymm3/m256
          VUNPCKLPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_unpacklo_pd (__m256d a, __m256d b)
          VUNPCKLPD ymm1,         ymm2, ymm3/m256
          VUNPCKLPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_xor_ps (__m256 a, __m256 b)
          VXORPS ymm1,         ymm2, ymm3/m256
          VXORPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_xor_pd (__m256d a, __m256d b)
          VXORPD ymm1,         ymm2, ymm3/m256
          VXORPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_xor_ps (__m256 a, __m256 b)
          VXORPS ymm1,         ymm2, ymm3/m256
          VXORPS ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[float], right: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_xor_pd (__m256d a, __m256d b)
          VXORPD ymm1,         ymm2, ymm3/m256
          VXORPD ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...


class Avx2(System.Runtime.Intrinsics.X86.Avx, metaclass=abc.ABCMeta):
    """This class provides access to Intel AVX2 hardware instructions via intrinsics"""

    class X64(System.Runtime.Intrinsics.X86.Avx.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_abs_epi8 (__m256i a)
          VPABSB ymm1,         ymm2/m256
          VPABSB ymm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_abs_epi16 (__m256i a)
          VPABSW ymm1,         ymm2/m256
          VPABSW ymm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_abs_epi32 (__m256i a)
          VPABSD ymm1,         ymm2/m256
          VPABSD ymm1 {k1}{z}, ymm2/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_abs_epi8 (__m256i a)
          VPABSB ymm1,         ymm2/m256
          VPABSB ymm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_abs_epi16 (__m256i a)
          VPABSW ymm1,         ymm2/m256
          VPABSW ymm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_abs_epi32 (__m256i a)
          VPABSD ymm1,         ymm2/m256
          VPABSD ymm1 {k1}{z}, ymm2/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi8 (__m256i a, __m256i b)
          VPADDB ymm1,         ymm2, ymm3/m256
          VPADDB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi8 (__m256i a, __m256i b)
          VPADDB ymm1,         ymm2, ymm3/m256
          VPADDB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi16 (__m256i a, __m256i b)
          VPADDW ymm1,         ymm2, ymm3/m256
          VPADDW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi16 (__m256i a, __m256i b)
          VPADDW ymm1,         ymm2, ymm3/m256
          VPADDW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi32 (__m256i a, __m256i b)
          VPADDD ymm1,         ymm2, ymm3/m256
          VPADDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi32 (__m256i a, __m256i b)
          VPADDD ymm1,         ymm2, ymm3/m256
          VPADDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi64 (__m256i a, __m256i b)
          VPADDQ ymm1,         ymm2, ymm3/m256
          VPADDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi64 (__m256i a, __m256i b)
          VPADDQ ymm1,         ymm2, ymm3/m256
          VPADDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi8 (__m256i a, __m256i b)
          VPADDB ymm1,         ymm2, ymm3/m256
          VPADDB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi8 (__m256i a, __m256i b)
          VPADDB ymm1,         ymm2, ymm3/m256
          VPADDB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi16 (__m256i a, __m256i b)
          VPADDW ymm1,         ymm2, ymm3/m256
          VPADDW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi16 (__m256i a, __m256i b)
          VPADDW ymm1,         ymm2, ymm3/m256
          VPADDW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi32 (__m256i a, __m256i b)
          VPADDD ymm1,         ymm2, ymm3/m256
          VPADDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi32 (__m256i a, __m256i b)
          VPADDD ymm1,         ymm2, ymm3/m256
          VPADDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi64 (__m256i a, __m256i b)
          VPADDQ ymm1,         ymm2, ymm3/m256
          VPADDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_add_epi64 (__m256i a, __m256i b)
          VPADDQ ymm1,         ymm2, ymm3/m256
          VPADDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epi8 (__m256i a, __m256i b)
          VPADDSB ymm1,         ymm2, ymm3/m256
          VPADDSB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epu8 (__m256i a, __m256i b)
          VPADDUSB ymm1,         ymm2, ymm3/m256
          VPADDUSB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epi16 (__m256i a, __m256i b)
          VPADDSW ymm1,         ymm2, ymm3/m256
          VPADDSW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epu16 (__m256i a, __m256i b)
          VPADDUSW ymm1,         ymm2, ymm3/m256
          VPADDUSW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epi8 (__m256i a, __m256i b)
          VPADDSB ymm1,         ymm2, ymm3/m256
          VPADDSB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epu8 (__m256i a, __m256i b)
          VPADDUSB ymm1,         ymm2, ymm3/m256
          VPADDUSB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epi16 (__m256i a, __m256i b)
          VPADDSW ymm1,         ymm2, ymm3/m256
          VPADDSW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_adds_epu16 (__m256i a, __m256i b)
          VPADDUSW ymm1,         ymm2, ymm3/m256
          VPADDUSW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def AlignRight(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_alignr_epi8 (__m256i a, __m256i b, const int count)
          VPALIGNR ymm1,         ymm2, ymm3/m256, imm8
          VPALIGNR ymm1 {k1}{z}, ymm2, ymm3/m256, imm8
        This intrinsic generates VPALIGNR that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND  ymm1,         ymm2, ymm3/m256
          VPANDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND  ymm1,         ymm2, ymm3/m256
          VPANDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND  ymm1,         ymm2, ymm3/m256
          VPANDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND  ymm1,         ymm2, ymm3/m256
          VPANDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND  ymm1,         ymm2, ymm3/m256
          VPANDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND  ymm1,         ymm2, ymm3/m256
          VPANDD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND  ymm1,         ymm2, ymm3/m256
          VPANDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_and_si256 (__m256i a, __m256i b)
          VPAND  ymm1,         ymm2, ymm3/m256
          VPANDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN  ymm1,         ymm2, ymm3/m256
          VPANDND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN  ymm1,         ymm2, ymm3/m256
          VPANDND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN  ymm1,         ymm2, ymm3/m256
          VPANDNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN  ymm1,         ymm2, ymm3/m256
          VPANDNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN  ymm1,         ymm2, ymm3/m256
          VPANDND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN  ymm1,         ymm2, ymm3/m256
          VPANDND ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN  ymm1,         ymm2, ymm3/m256
          VPANDNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_andnot_si256 (__m256i a, __m256i b)
          VPANDN  ymm1,         ymm2, ymm3/m256
          VPANDNQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_avg_epu8 (__m256i a, __m256i b)
          VPAVGB ymm1,         ymm2, ymm3/m256
          VPAVGB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_avg_epu16 (__m256i a, __m256i b)
          VPAVGW ymm1,         ymm2, ymm3/m256
          VPAVGW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_avg_epu8 (__m256i a, __m256i b)
          VPAVGB ymm1,         ymm2, ymm3/m256
          VPAVGB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Average(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_avg_epu16 (__m256i a, __m256i b)
          VPAVGW ymm1,         ymm2, ymm3/m256
          VPAVGW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi32 (__m128i a, __m128i b, const int imm8)
          VPBLENDD xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi32 (__m128i a, __m128i b, const int imm8)
          VPBLENDD xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi16 (__m256i a, __m256i b, const int imm8)
          VPBLENDW ymm1, ymm2, ymm3/m256 imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi16 (__m256i a, __m256i b, const int imm8)
          VPBLENDW ymm1, ymm2, ymm3/m256 imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi32 (__m256i a, __m256i b, const int imm8)
          VPBLENDD ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi32 (__m256i a, __m256i b, const int imm8)
          VPBLENDD ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi32 (__m128i a, __m128i b, const int imm8)
          VPBLENDD xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int], control: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_blend_epi32 (__m128i a, __m128i b, const int imm8)
          VPBLENDD xmm1, xmm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi16 (__m256i a, __m256i b, const int imm8)
          VPBLENDW ymm1, ymm2, ymm3/m256 imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi16 (__m256i a, __m256i b, const int imm8)
          VPBLENDW ymm1, ymm2, ymm3/m256 imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi32 (__m256i a, __m256i b, const int imm8)
          VPBLENDD ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Blend(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blend_epi32 (__m256i a, __m256i b, const int imm8)
          VPBLENDD ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BlendVariable(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_blendv_epi8 (__m256i a, __m256i b, __m256i mask)
          VPBLENDVB ymm1, ymm2, ymm3/m256, ymm4
        This intrinsic generates VPBLENDVB that needs a BYTE mask-vector, so users should correctly set each mask byte for the selected elements.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm1,         xmm2/m8
          VPBROADCASTB xmm1 {k1}{z}, xmm2/m8
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm1,         xmm2/m8
          VPBROADCASTB xmm1 {k1}{z}, xmm2/m8
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm1,         xmm2/m16
          VPBROADCASTW xmm1 {k1}{z}, xmm2/m16
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm1,         xmm2/m16
          VPBROADCASTW xmm1 {k1}{z}, xmm2/m16
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm1,         xmm2/m32
          VPBROADCASTD xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm1,         xmm2/m32
          VPBROADCASTD xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm1,         xmm2/m64
          VPBROADCASTQ xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm1,         xmm2/m64
          VPBROADCASTQ xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_broadcastss_ps (__m128 a)
          VBROADCASTSS xmm1,         xmm2/m32
          VBROADCASTSS xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_broadcastsd_pd (__m128d a)
          VMOVDDUP xmm1, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm1,         m8
          VPBROADCASTB xmm1 {k1}{z}, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm1,         m8
          VPBROADCASTB xmm1 {k1}{z}, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm1,         m16
          VPBROADCASTW xmm1 {k1}{z}, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm1,         m16
          VPBROADCASTW xmm1 {k1}{z}, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm1,         m32
          VPBROADCASTD xmm1 {k1}{z}, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm1,         m32
          VPBROADCASTD xmm1 {k1}{z}, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm1,         m64
          VPBROADCASTQ xmm1 {k1}{z}, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm1,         m64
          VPBROADCASTQ xmm1 {k1}{z}, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm1,         xmm2/m8
          VPBROADCASTB xmm1 {k1}{z}, xmm2/m8
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm1,         xmm2/m8
          VPBROADCASTB xmm1 {k1}{z}, xmm2/m8
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm1,         xmm2/m16
          VPBROADCASTW xmm1 {k1}{z}, xmm2/m16
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm1,         xmm2/m16
          VPBROADCASTW xmm1 {k1}{z}, xmm2/m16
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm1,         xmm2/m32
          VPBROADCASTD xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm1,         xmm2/m32
          VPBROADCASTD xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm1,         xmm2/m64
          VPBROADCASTQ xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm1,         xmm2/m64
          VPBROADCASTQ xmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_broadcastss_ps (__m128 a)
          VBROADCASTSS xmm1,         xmm2/m32
          VBROADCASTSS xmm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_broadcastsd_pd (__m128d a)
          VMOVDDUP xmm1, xmm/m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm1,         m8
          VPBROADCASTB xmm1 {k1}{z}, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastb_epi8 (__m128i a)
          VPBROADCASTB xmm1,         m8
          VPBROADCASTB xmm1 {k1}{z}, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm1,         m16
          VPBROADCASTW xmm1 {k1}{z}, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastw_epi16 (__m128i a)
          VPBROADCASTW xmm1,         m16
          VPBROADCASTW xmm1 {k1}{z}, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm1,         m32
          VPBROADCASTD xmm1 {k1}{z}, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastd_epi32 (__m128i a)
          VPBROADCASTD xmm1,         m32
          VPBROADCASTD xmm1 {k1}{z}, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm1,         m64
          VPBROADCASTQ xmm1 {k1}{z}, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector128(source: typing.Any) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ xmm1,         m64
          VPBROADCASTQ xmm1 {k1}{z}, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm1,         xmm2/m8
          VPBROADCASTB ymm1 {k1}{z}, xmm2/m8
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm1,         xmm2/m8
          VPBROADCASTB ymm1 {k1}{z}, xmm2/m8
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm1,         xmm2/m16
          VPBROADCASTW ymm1 {k1}{z}, xmm2/m16
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm1,         xmm2/m16
          VPBROADCASTW ymm1 {k1}{z}, xmm2/m16
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm1,         xmm2/m32
          VPBROADCASTD ymm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm1,         xmm2/m32
          VPBROADCASTD ymm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm1,         xmm2/m64
          VPBROADCASTQ ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm1,         xmm2/m64
          VPBROADCASTQ ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_broadcastss_ps (__m128 a)
          VBROADCASTSS ymm1,         xmm2/m32
          VBROADCASTSS ymm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_broadcastsd_pd (__m128d a)
          VBROADCASTSD ymm1,         xmm2/m64
          VBROADCASTSD ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm1,         m8
          VPBROADCASTB ymm1 {k1}{z}, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm1,         m8
          VPBROADCASTB ymm1 {k1}{z}, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm1,         m16
          VPBROADCASTW ymm1 {k1}{z}, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm1,         m16
          VPBROADCASTW ymm1 {k1}{z}, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm1,         m32
          VPBROADCASTD ymm1 {k1}{z}, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm1,         m32
          VPBROADCASTD ymm1 {k1}{z}, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm1,         m64
          VPBROADCASTQ ymm1 {k1}{z}, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm1,         m64
          VPBROADCASTQ ymm1 {k1}{z}, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm1,         xmm2/m8
          VPBROADCASTB ymm1 {k1}{z}, xmm2/m8
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm1,         xmm2/m8
          VPBROADCASTB ymm1 {k1}{z}, xmm2/m8
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm1,         xmm2/m16
          VPBROADCASTW ymm1 {k1}{z}, xmm2/m16
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm1,         xmm2/m16
          VPBROADCASTW ymm1 {k1}{z}, xmm2/m16
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm1,         xmm2/m32
          VPBROADCASTD ymm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm1,         xmm2/m32
          VPBROADCASTD ymm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm1,         xmm2/m64
          VPBROADCASTQ ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm1,         xmm2/m64
          VPBROADCASTQ ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_broadcastss_ps (__m128 a)
          VBROADCASTSS ymm1,         xmm2/m32
          VBROADCASTSS ymm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(value: System.Runtime.Intrinsics.Vector128[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_broadcastsd_pd (__m128d a)
          VBROADCASTSD ymm1,         xmm2/m64
          VBROADCASTSD ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm1,         m8
          VPBROADCASTB ymm1 {k1}{z}, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastb_epi8 (__m128i a)
          VPBROADCASTB ymm1,         m8
          VPBROADCASTB ymm1 {k1}{z}, m8
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm1,         m16
          VPBROADCASTW ymm1 {k1}{z}, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastw_epi16 (__m128i a)
          VPBROADCASTW ymm1,         m16
          VPBROADCASTW ymm1 {k1}{z}, m16
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm1,         m32
          VPBROADCASTD ymm1 {k1}{z}, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastd_epi32 (__m128i a)
          VPBROADCASTD ymm1,         m32
          VPBROADCASTD ymm1 {k1}{z}, m32
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm1,         m64
          VPBROADCASTQ ymm1 {k1}{z}, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastScalarToVector256(source: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastq_epi64 (__m128i a)
          VPBROADCASTQ ymm1,         m64
          VPBROADCASTQ ymm1 {k1}{z}, m64
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI32x4 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI32x4 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI32x4 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI32x4 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI32x4 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI32x4 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI64x2 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI64x2 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI32x4 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI32x4 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI32x4 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI32x4 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI32x4 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI32x4 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI64x2 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def BroadcastVector128ToVector256(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_broadcastsi128_si256 (__m128i a)
          VBROADCASTI128  ymm1,         m128
          VBROADCASTI64x2 ymm1 {k1}{z}, m128
        The above native signature does not directly correspond to the managed signature.
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi8 (__m256i a, __m256i b)
          VPCMPEQB ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi8 (__m256i a, __m256i b)
          VPCMPEQB ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi16 (__m256i a, __m256i b)
          VPCMPEQW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi16 (__m256i a, __m256i b)
          VPCMPEQW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi32 (__m256i a, __m256i b)
          VPCMPEQD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi32 (__m256i a, __m256i b)
          VPCMPEQD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi64 (__m256i a, __m256i b)
          VPCMPEQQ ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi64 (__m256i a, __m256i b)
          VPCMPEQQ ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi8 (__m256i a, __m256i b)
          VPCMPEQB ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi8 (__m256i a, __m256i b)
          VPCMPEQB ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi16 (__m256i a, __m256i b)
          VPCMPEQW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi16 (__m256i a, __m256i b)
          VPCMPEQW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi32 (__m256i a, __m256i b)
          VPCMPEQD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi32 (__m256i a, __m256i b)
          VPCMPEQD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi64 (__m256i a, __m256i b)
          VPCMPEQQ ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareEqual(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpeq_epi64 (__m256i a, __m256i b)
          VPCMPEQQ ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi8 (__m256i a, __m256i b)
          VPCMPGTB ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi16 (__m256i a, __m256i b)
          VPCMPGTW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi32 (__m256i a, __m256i b)
          VPCMPGTD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi64 (__m256i a, __m256i b)
          VPCMPGTQ ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi8 (__m256i a, __m256i b)
          VPCMPGTB ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi16 (__m256i a, __m256i b)
          VPCMPGTW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi32 (__m256i a, __m256i b)
          VPCMPGTD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def CompareGreaterThan(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cmpgt_epi64 (__m256i a, __m256i b)
          VPCMPGTQ ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_cvtsi256_si32 (__m256i a)
          VMOVD r/m32, ymm1
        """
        ...

    @staticmethod
    @overload
    def ConvertToInt32(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_cvtsi256_si32 (__m256i a)
          VMOVD r/m32, ymm1
        """
        ...

    @staticmethod
    @overload
    def ConvertToUInt32(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_cvtsi256_si32 (__m256i a)
          VMOVD r/m32, ymm1
        """
        ...

    @staticmethod
    @overload
    def ConvertToUInt32(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_cvtsi256_si32 (__m256i a)
          VMOVD r/m32, ymm1
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi8_epi16 (__m128i a)
          VPMOVSXBW ymm1,         xmm2/m128
          VPMOVSXBW ymm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu8_epi16 (__m128i a)
          VPMOVZXBW ymm1,         xmm2/m128
          VPMOVZXBW ymm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXBW ymm1,         m128
          VPMOVSXBW ymm1 {k1}{z}, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXBW ymm1,         m128
          VPMOVZXBW ymm1 {k1}{z}, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi8_epi16 (__m128i a)
          VPMOVSXBW ymm1,         xmm2/m128
          VPMOVSXBW ymm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu8_epi16 (__m128i a)
          VPMOVZXBW ymm1,         xmm2/m128
          VPMOVZXBW ymm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXBW ymm1,         m128
          VPMOVSXBW ymm1 {k1}{z}, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int16(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXBW ymm1,         m128
          VPMOVZXBW ymm1 {k1}{z}, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi8_epi32 (__m128i a)
          VPMOVSXBD ymm1,         xmm2/m64
          VPMOVSXBD ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu8_epi32 (__m128i a)
          VPMOVZXBD ymm1,         xmm2/m64
          VPMOVZXBD ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi16_epi32 (__m128i a)
          VPMOVSXWD ymm1,         xmm2/m128
          VPMOVSXWD ymm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu16_epi32 (__m128i a)
          VPMOVZXWD ymm1,         xmm2/m128
          VPMOVZXWD ymm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXBD ymm1,         m64
          VPMOVSXBD ymm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXBD ymm1,         m64
          VPMOVZXBD ymm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXWD ymm1,         m128
          VPMOVSXWD ymm1 {k1}{z}, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXWD ymm1,         m128
          VPMOVZXWD ymm1 {k1}{z}, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi8_epi32 (__m128i a)
          VPMOVSXBD ymm1,         xmm2/m64
          VPMOVSXBD ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu8_epi32 (__m128i a)
          VPMOVZXBD ymm1,         xmm2/m64
          VPMOVZXBD ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi16_epi32 (__m128i a)
          VPMOVSXWD ymm1,         xmm2/m128
          VPMOVSXWD ymm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu16_epi32 (__m128i a)
          VPMOVZXWD ymm1,         xmm2/m128
          VPMOVZXWD ymm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXBD ymm1,         m64
          VPMOVSXBD ymm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXBD ymm1,         m64
          VPMOVZXBD ymm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXWD ymm1,         m128
          VPMOVSXWD ymm1 {k1}{z}, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXWD ymm1,         m128
          VPMOVZXWD ymm1 {k1}{z}, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi8_epi64 (__m128i a)
          VPMOVSXBQ ymm1,         xmm2/m32
          VPMOVSXBQ ymm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu8_epi64 (__m128i a)
          VPMOVZXBQ ymm1,         xmm2/m32
          VPMOVZXBQ ymm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi16_epi64 (__m128i a)
          VPMOVSXWQ ymm1,         xmm2/m64
          VPMOVSXWQ ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu16_epi64 (__m128i a)
          VPMOVZXWQ ymm1,         xmm2/m64
          VPMOVZXWQ ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi32_epi64 (__m128i a)
          VPMOVSXDQ ymm1,         xmm2/m128
          VPMOVSXDQ ymm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu32_epi64 (__m128i a)
          VPMOVZXDQ ymm1,         xmm2/m128
          VPMOVZXDQ ymm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXBQ ymm1,         m32
          VPMOVSXBQ ymm1 {k1}{z}, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXBQ ymm1,         m32
          VPMOVZXBQ ymm1 {k1}{z}, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXWQ ymm1,         m64
          VPMOVSXWQ ymm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXWQ ymm1,         m64
          VPMOVZXWQ ymm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXDQ ymm1,         m128
          VPMOVSXDQ ymm1 {k1}{z}, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXDQ ymm1,         m128
          VPMOVZXDQ ymm1 {k1}{z}, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi8_epi64 (__m128i a)
          VPMOVSXBQ ymm1,         xmm2/m32
          VPMOVSXBQ ymm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu8_epi64 (__m128i a)
          VPMOVZXBQ ymm1,         xmm2/m32
          VPMOVZXBQ ymm1 {k1}{z}, xmm2/m32
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi16_epi64 (__m128i a)
          VPMOVSXWQ ymm1,         xmm2/m64
          VPMOVSXWQ ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu16_epi64 (__m128i a)
          VPMOVZXWQ ymm1,         xmm2/m64
          VPMOVZXWQ ymm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepi32_epi64 (__m128i a)
          VPMOVSXDQ ymm1,         xmm2/m128
          VPMOVSXDQ ymm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_cvtepu32_epi64 (__m128i a)
          VPMOVZXDQ ymm1,         xmm2/m128
          VPMOVZXDQ ymm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXBQ ymm1,         m32
          VPMOVSXBQ ymm1 {k1}{z}, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXBQ ymm1,         m32
          VPMOVZXBQ ymm1 {k1}{z}, m32
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXWQ ymm1,         m64
          VPMOVSXWQ ymm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXWQ ymm1,         m64
          VPMOVZXWQ ymm1 {k1}{z}, m64
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVSXDQ ymm1,         m128
          VPMOVSXDQ ymm1 {k1}{z}, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int64(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        VPMOVZXDQ ymm1,         m128
          VPMOVZXDQ ymm1 {k1}{z}, m128
        The native signature does not exist. We provide this additional overload for completeness.
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI64x2 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI64x2 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI32x4 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI64x2 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ExtractVector128(value: System.Runtime.Intrinsics.Vector256[int], index: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_extracti128_si256 (__m256i a, const int imm8)
          VEXTRACTI128  xmm1/m128,         ymm2, imm8
          VEXTRACTI64x2 xmm1/m128 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDD xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDD xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDQ xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDQ xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mask_i32gather_ps (__m128 src, float const* base_addr, __m128i vindex, __m128 mask, const int scale)
          VGATHERDPS xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mask_i32gather_pd (__m128d src, double const* base_addr, __m128i vindex, __m128d mask, const int scale)
          VGATHERDPD xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQQ xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQQ xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mask_i64gather_ps (__m128 src, float const* base_addr, __m128i vindex, __m128 mask, const int scale)
          VGATHERQPS xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mask_i64gather_pd (__m128d src, double const* base_addr, __m128i vindex, __m128d mask, const int scale)
          VGATHERQPD xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m256i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm1, vm32y, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m256i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm1, vm32y, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_mask_i64gather_ps (__m128 src, float const* base_addr, __m256i vindex, __m128 mask, const int scale)
          VGATHERQPS xmm1, vm32y, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDD xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDD xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDQ xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i32gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERDQ xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mask_i32gather_ps (__m128 src, float const* base_addr, __m128i vindex, __m128 mask, const int scale)
          VGATHERDPS xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mask_i32gather_pd (__m128d src, double const* base_addr, __m128i vindex, __m128d mask, const int scale)
          VGATHERDPD xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQQ xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_mask_i64gather_epi64 (__m128i src, __int64 const* base_addr, __m128i vindex, __m128i mask, const int scale)
          VPGATHERQQ xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_mask_i64gather_ps (__m128 src, float const* base_addr, __m128i vindex, __m128 mask, const int scale)
          VGATHERQPS xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_mask_i64gather_pd (__m128d src, double const* base_addr, __m128i vindex, __m128d mask, const int scale)
          VGATHERQPD xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m256i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm1, vm32y, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_mask_i64gather_epi32 (__m128i src, int const* base_addr, __m256i vindex, __m128i mask, const int scale)
          VPGATHERQD xmm1, vm32y, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector128(source: System.Runtime.Intrinsics.Vector128[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector128[float], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_mask_i64gather_ps (__m128 src, float const* base_addr, __m256i vindex, __m128 mask, const int scale)
          VGATHERQPS xmm1, vm32y, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi32 (__m256i src, int const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERDD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi32 (__m256i src, int const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERDD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi64 (__m256i src, __int64 const* base_addr, __m128i vindex, __m256i mask, const int scale)
          VPGATHERDQ ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi64 (__m256i src, __int64 const* base_addr, __m128i vindex, __m256i mask, const int scale)
          VPGATHERDQ ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_mask_i32gather_ps (__m256 src, float const* base_addr, __m256i vindex, __m256 mask, const int scale)
          VPGATHERDPS ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_mask_i32gather_pd (__m256d src, double const* base_addr, __m128i vindex, __m256d mask, const int scale)
          VPGATHERDPD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i64gather_epi64 (__m256i src, __int64 const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERQQ ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i64gather_epi64 (__m256i src, __int64 const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERQQ ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_mask_i64gather_pd (__m256d src, double const* base_addr, __m256i vindex, __m256d mask, const int scale)
          VGATHERQPD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi32 (__m256i src, int const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERDD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi32 (__m256i src, int const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERDD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi64 (__m256i src, __int64 const* base_addr, __m128i vindex, __m256i mask, const int scale)
          VPGATHERDQ ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i32gather_epi64 (__m256i src, __int64 const* base_addr, __m128i vindex, __m256i mask, const int scale)
          VPGATHERDQ ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_mask_i32gather_ps (__m256 src, float const* base_addr, __m256i vindex, __m256 mask, const int scale)
          VPGATHERDPS ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_mask_i32gather_pd (__m256d src, double const* base_addr, __m128i vindex, __m256d mask, const int scale)
          VPGATHERDPD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i64gather_epi64 (__m256i src, __int64 const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERQQ ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[int], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mask_i64gather_epi64 (__m256i src, __int64 const* base_addr, __m256i vindex, __m256i mask, const int scale)
          VPGATHERQQ ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherMaskVector256(source: System.Runtime.Intrinsics.Vector256[float], baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[float], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_mask_i64gather_pd (__m256d src, double const* base_addr, __m256i vindex, __m256d mask, const int scale)
          VGATHERQPD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERDD xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERDD xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_i32gather_ps (float const* base_addr, __m128i vindex, const int scale)
          VGATHERDPS xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_i32gather_pd (double const* base_addr, __m128i vindex, const int scale)
          VGATHERDPD xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERQD xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERQD xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERQQ xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERQQ xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_i64gather_ps (float const* base_addr, __m128i vindex, const int scale)
          VGATHERQPS xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_i64gather_pd (double const* base_addr, __m128i vindex, const int scale)
          VGATHERQPD xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_i64gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERQD xmm1, vm64y, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_i64gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERQD xmm1, vm64y, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_i64gather_ps (float const* base_addr, __m256i vindex, const int scale)
          VGATHERQPS xmm1, vm64y, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERDD xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERDD xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_i32gather_ps (float const* base_addr, __m128i vindex, const int scale)
          VGATHERDPS xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_i32gather_pd (double const* base_addr, __m128i vindex, const int scale)
          VGATHERDPD xmm1, vm32x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERQD xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi32 (int const* base_addr, __m128i vindex, const int scale)
          VPGATHERQD xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERQQ xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_i64gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERQQ xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm_i64gather_ps (float const* base_addr, __m128i vindex, const int scale)
          VGATHERQPS xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128d _mm_i64gather_pd (double const* base_addr, __m128i vindex, const int scale)
          VGATHERQPD xmm1, vm64x, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_i64gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERQD xmm1, vm64y, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm256_i64gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERQD xmm1, vm64y, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector128(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector128[float]:
        """
        __m128 _mm256_i64gather_ps (float const* base_addr, __m256i vindex, const int scale)
          VGATHERQPS xmm1, vm64y, xmm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERDD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERDD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_i32gather_ps (float const* base_addr, __m256i vindex, const int scale)
          VGATHERDPS ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_i32gather_pd (double const* base_addr, __m128i vindex, const int scale)
          VGATHERDPD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i64gather_epi64 (__int64 const* base_addr, __m256i vindex, const int scale)
          VPGATHERQQ ymm1, vm64y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i64gather_epi64 (__int64 const* base_addr, __m256i vindex, const int scale)
          VPGATHERQQ ymm1, vm64y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_i64gather_pd (double const* base_addr, __m256i vindex, const int scale)
          VGATHERQPD ymm1, vm64y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERDD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi32 (int const* base_addr, __m256i vindex, const int scale)
          VPGATHERDD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i32gather_epi64 (__int64 const* base_addr, __m128i vindex, const int scale)
          VPGATHERDQ ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_i32gather_ps (float const* base_addr, __m256i vindex, const int scale)
          VGATHERDPS ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector128[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_i32gather_pd (double const* base_addr, __m128i vindex, const int scale)
          VGATHERDPD ymm1, vm32y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i64gather_epi64 (__int64 const* base_addr, __m256i vindex, const int scale)
          VPGATHERQQ ymm1, vm64y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_i64gather_epi64 (__int64 const* base_addr, __m256i vindex, const int scale)
          VPGATHERQQ ymm1, vm64y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def GatherVector256(baseAddress: typing.Any, index: System.Runtime.Intrinsics.Vector256[int], scale: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_i64gather_pd (double const* base_addr, __m256i vindex, const int scale)
          VGATHERQPD ymm1, vm64y, ymm2
        The scale parameter should be 1, 2, 4 or 8, otherwise, ArgumentOutOfRangeException will be thrown.
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hadd_epi16 (__m256i a, __m256i b)
          VPHADDW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hadd_epi32 (__m256i a, __m256i b)
          VPHADDD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hadd_epi16 (__m256i a, __m256i b)
          VPHADDW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAdd(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hadd_epi32 (__m256i a, __m256i b)
          VPHADDD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hadds_epi16 (__m256i a, __m256i b)
          VPHADDSW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalAddSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hadds_epi16 (__m256i a, __m256i b)
          VPHADDSW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hsub_epi16 (__m256i a, __m256i b)
          VPHSUBW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hsub_epi32 (__m256i a, __m256i b)
          VPHSUBD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hsub_epi16 (__m256i a, __m256i b)
          VPHSUBW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hsub_epi32 (__m256i a, __m256i b)
          VPHSUBD ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hsubs_epi16 (__m256i a, __m256i b)
          VPHSUBSW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def HorizontalSubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_hsubs_epi16 (__m256i a, __m256i b)
          VPHSUBSW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI32x4 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def InsertVector128(value: System.Runtime.Intrinsics.Vector256[int], data: System.Runtime.Intrinsics.Vector128[int], index: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_inserti128_si256 (__m256i a, __m128i b, const int imm8)
          VINSERTI128  ymm1,         ymm2, xmm3/m128, imm8
          VINSERTI64x2 ymm1 {k1}{z}, ymm2, xmm3/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector256NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_stream_load_si256 (__m256i const* mem_addr)
          VMOVNTDQA ymm1, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi32 (int const* mem_addr, __m128i mask)
          VPMASKMOVD xmm1, xmm2, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi32 (int const* mem_addr, __m128i mask)
          VPMASKMOVD xmm1, xmm2, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi64 (__int64 const* mem_addr, __m128i mask)
          VPMASKMOVQ xmm1, xmm2, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi64 (__int64 const* mem_addr, __m128i mask)
          VPMASKMOVQ xmm1, xmm2, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi32 (int const* mem_addr, __m256i mask)
          VPMASKMOVD ymm1, ymm2, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi32 (int const* mem_addr, __m256i mask)
          VPMASKMOVD ymm1, ymm2, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi64 (__int64 const* mem_addr, __m256i mask)
          VPMASKMOVQ ymm1, ymm2, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi64 (__int64 const* mem_addr, __m256i mask)
          VPMASKMOVQ ymm1, ymm2, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi32 (int const* mem_addr, __m128i mask)
          VPMASKMOVD xmm1, xmm2, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi32 (int const* mem_addr, __m128i mask)
          VPMASKMOVD xmm1, xmm2, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi64 (__int64 const* mem_addr, __m128i mask)
          VPMASKMOVQ xmm1, xmm2, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_maskload_epi64 (__int64 const* mem_addr, __m128i mask)
          VPMASKMOVQ xmm1, xmm2, m128
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi32 (int const* mem_addr, __m256i mask)
          VPMASKMOVD ymm1, ymm2, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi32 (int const* mem_addr, __m256i mask)
          VPMASKMOVD ymm1, ymm2, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi64 (__int64 const* mem_addr, __m256i mask)
          VPMASKMOVQ ymm1, ymm2, m256
        """
        ...

    @staticmethod
    @overload
    def MaskLoad(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maskload_epi64 (__int64 const* mem_addr, __m256i mask)
          VPMASKMOVQ ymm1, ymm2, m256
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi32 (int* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVD m128, xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi32 (int* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVD m128, xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi64 (__int64* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVQ m128, xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi64 (__int64* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVQ m128, xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi32 (int* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVD m256, ymm1, ymm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi32 (int* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVD m256, ymm1, ymm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi64 (__int64* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVQ m256, ymm1, ymm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi64 (__int64* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVQ m256, ymm1, ymm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi32 (int* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVD m128, xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi32 (int* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVD m128, xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi64 (__int64* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVQ m128, xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector128[int], source: System.Runtime.Intrinsics.Vector128[int]) -> None:
        """
        void _mm_maskstore_epi64 (__int64* mem_addr, __m128i mask, __m128i a)
          VPMASKMOVQ m128, xmm1, xmm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi32 (int* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVD m256, ymm1, ymm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi32 (int* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVD m256, ymm1, ymm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi64 (__int64* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVQ m256, ymm1, ymm2
        """
        ...

    @staticmethod
    @overload
    def MaskStore(address: typing.Any, mask: System.Runtime.Intrinsics.Vector256[int], source: System.Runtime.Intrinsics.Vector256[int]) -> None:
        """
        void _mm256_maskstore_epi64 (__int64* mem_addr, __m256i mask, __m256i a)
          VPMASKMOVQ m256, ymm1, ymm2
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epi8 (__m256i a, __m256i b)
          VPMAXSB ymm1,         ymm2, ymm3/m256
          VPMAXSB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epu8 (__m256i a, __m256i b)
          VPMAXUB ymm1,         ymm2, ymm3/m256
          VPMAXUB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epi16 (__m256i a, __m256i b)
          VPMAXSW ymm1,         ymm2, ymm3/m256
          VPMAXSW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epu16 (__m256i a, __m256i b)
          VPMAXUW ymm1,         ymm2, ymm3/m256
          VPMAXUW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epi32 (__m256i a, __m256i b)
          VPMAXSD ymm1,         ymm2, ymm3/m256
          VPMAXSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epu32 (__m256i a, __m256i b)
          VPMAXUD ymm1,         ymm2, ymm3/m256
          VPMAXUD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epi8 (__m256i a, __m256i b)
          VPMAXSB ymm1,         ymm2, ymm3/m256
          VPMAXSB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epu8 (__m256i a, __m256i b)
          VPMAXUB ymm1,         ymm2, ymm3/m256
          VPMAXUB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epi16 (__m256i a, __m256i b)
          VPMAXSW ymm1,         ymm2, ymm3/m256
          VPMAXSW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epu16 (__m256i a, __m256i b)
          VPMAXUW ymm1,         ymm2, ymm3/m256
          VPMAXUW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epi32 (__m256i a, __m256i b)
          VPMAXSD ymm1,         ymm2, ymm3/m256
          VPMAXSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_max_epu32 (__m256i a, __m256i b)
          VPMAXUD ymm1,         ymm2, ymm3/m256
          VPMAXUD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epi8 (__m256i a, __m256i b)
          VPMINSB ymm1,         ymm2, ymm3/m256
          VPMINSB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epu8 (__m256i a, __m256i b)
          VPMINUB ymm1,         ymm2, ymm3/m256
          VPMINUB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epi16 (__m256i a, __m256i b)
          VPMINSW ymm1,         ymm2, ymm3/m256
          VPMINSW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epu16 (__m256i a, __m256i b)
          VPMINUW ymm1,         ymm2, ymm3/m256
          VPMINUW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epi32 (__m256i a, __m256i b)
          VPMINSD ymm1,         ymm2, ymm3/m256
          VPMINSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epu32 (__m256i a, __m256i b)
          VPMINUD ymm1,         ymm2, ymm3/m256
          VPMINUD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epi8 (__m256i a, __m256i b)
          VPMINSB ymm1,         ymm2, ymm3/m256
          VPMINSB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epu8 (__m256i a, __m256i b)
          VPMINUB ymm1,         ymm2, ymm3/m256
          VPMINUB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epi16 (__m256i a, __m256i b)
          VPMINSW ymm1,         ymm2, ymm3/m256
          VPMINSW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epu16 (__m256i a, __m256i b)
          VPMINUW ymm1,         ymm2, ymm3/m256
          VPMINUW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epi32 (__m256i a, __m256i b)
          VPMINSD ymm1,         ymm2, ymm3/m256
          VPMINSD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_min_epu32 (__m256i a, __m256i b)
          VPMINUD ymm1,         ymm2, ymm3/m256
          VPMINUD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_movemask_epi8 (__m256i a)
          VPMOVMSKB r32, ymm1
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_movemask_epi8 (__m256i a)
          VPMOVMSKB r32, ymm1
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_movemask_epi8 (__m256i a)
          VPMOVMSKB r32, ymm1
        """
        ...

    @staticmethod
    @overload
    def MoveMask(value: System.Runtime.Intrinsics.Vector256[int]) -> int:
        """
        int _mm256_movemask_epi8 (__m256i a)
          VPMOVMSKB r32, ymm1
        """
        ...

    @staticmethod
    @overload
    def MultipleSumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mpsadbw_epu8 (__m256i a, __m256i b, const int imm8)
          VMPSADBW ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def MultipleSumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], mask: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mpsadbw_epu8 (__m256i a, __m256i b, const int imm8)
          VMPSADBW ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mul_epi32 (__m256i a, __m256i b)
          VPMULDQ ymm1,         ymm2, ymm3/m256
          VPMULDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mul_epu32 (__m256i a, __m256i b)
          VPMULUDQ ymm1,         ymm2, ymm3/m256
          VPMULUDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mul_epi32 (__m256i a, __m256i b)
          VPMULDQ ymm1,         ymm2, ymm3/m256
          VPMULDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Multiply(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mul_epu32 (__m256i a, __m256i b)
          VPMULUDQ ymm1,         ymm2, ymm3/m256
          VPMULUDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_madd_epi16 (__m256i a, __m256i b)
          VPMADDWD ymm1,         ymm2, ymm3/m256
          VPMADDWD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maddubs_epi16 (__m256i a, __m256i b)
          VPMADDUBSW ymm1,         ymm2, ymm3/m256
          VPMADDUBSW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_madd_epi16 (__m256i a, __m256i b)
          VPMADDWD ymm1,         ymm2, ymm3/m256
          VPMADDWD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyAddAdjacent(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_maddubs_epi16 (__m256i a, __m256i b)
          VPMADDUBSW ymm1,         ymm2, ymm3/m256
          VPMADDUBSW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mulhi_epi16 (__m256i a, __m256i b)
          VPMULHW ymm1,         ymm2, ymm3/m256
          VPMULHW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mulhi_epu16 (__m256i a, __m256i b)
          VPMULHUW ymm1,         ymm2, ymm3/m256
          VPMULHUW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mulhi_epi16 (__m256i a, __m256i b)
          VPMULHW ymm1,         ymm2, ymm3/m256
          VPMULHW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mulhi_epu16 (__m256i a, __m256i b)
          VPMULHUW ymm1,         ymm2, ymm3/m256
          VPMULHUW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyHighRoundScale(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mulhrs_epi16 (__m256i a, __m256i b)
          VPMULHRSW ymm1,         ymm2, ymm3/m256
          VPMULHRSW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyHighRoundScale(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mulhrs_epi16 (__m256i a, __m256i b)
          VPMULHRSW ymm1,         ymm2, ymm3/m256
          VPMULHRSW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi16 (__m256i a, __m256i b)
          VPMULLW ymm1,         ymm2, ymm3/m256
          VPMULLW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi16 (__m256i a, __m256i b)
          VPMULLW ymm1,         ymm2, ymm3/m256
          VPMULLW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi32 (__m256i a, __m256i b)
          VPMULLD ymm1,         ymm2, ymm3/m256
          VPMULLD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi32 (__m256i a, __m256i b)
          VPMULLD ymm1,         ymm2, ymm3/m256
          VPMULLD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi16 (__m256i a, __m256i b)
          VPMULLW ymm1,         ymm2, ymm3/m256
          VPMULLW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi16 (__m256i a, __m256i b)
          VPMULLW ymm1,         ymm2, ymm3/m256
          VPMULLW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi32 (__m256i a, __m256i b)
          VPMULLD ymm1,         ymm2, ymm3/m256
          VPMULLD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def MultiplyLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_mullo_epi32 (__m256i a, __m256i b)
          VPMULLD ymm1,         ymm2, ymm3/m256
          VPMULLD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR  ymm1,         ymm2, ymm3/m256
          VPORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR  ymm1,         ymm2, ymm3/m256
          VPORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR  ymm1,         ymm2, ymm3/m256
          VPORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR  ymm1,         ymm2, ymm3/m256
          VPORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR  ymm1,         ymm2, ymm3/m256
          VPORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR  ymm1,         ymm2, ymm3/m256
          VPORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR  ymm1,         ymm2, ymm3/m256
          VPORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Or(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_or_si256 (__m256i a, __m256i b)
          VPOR  ymm1,         ymm2, ymm3/m256
          VPORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packs_epi16 (__m256i a, __m256i b)
          VPACKSSWB ymm1,         ymm2, ymm3/m256
          VPACKSSWB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packs_epi32 (__m256i a, __m256i b)
          VPACKSSDW ymm1,         ymm2, ymm3/m256
          VPACKSSDW ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packs_epi16 (__m256i a, __m256i b)
          VPACKSSWB ymm1,         ymm2, ymm3/m256
          VPACKSSWB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def PackSignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packs_epi32 (__m256i a, __m256i b)
          VPACKSSDW ymm1,         ymm2, ymm3/m256
          VPACKSSDW ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packus_epi16 (__m256i a, __m256i b)
          VPACKUSWB ymm1,         ymm2, ymm3/m256
          VPACKUSWB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packus_epi32 (__m256i a, __m256i b)
          VPACKUSDW ymm1,         ymm2, ymm3/m256
          VPACKUSDW ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packus_epi16 (__m256i a, __m256i b)
          VPACKUSWB ymm1,         ymm2, ymm3/m256
          VPACKUSWB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def PackUnsignedSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_packus_epi32 (__m256i a, __m256i b)
          VPACKUSDW ymm1,         ymm2, ymm3/m256
          VPACKUSDW ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute2x128(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute2x128_si256 (__m256i a, __m256i b, const int imm8)
          VPERM2I128 ymm1, ymm2, ymm3/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute4x64(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute4x64_epi64 (__m256i a, const int imm8)
          VPERMQ ymm1,         ymm2/m256,         imm8
          VPERMQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute4x64(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute4x64_epi64 (__m256i a, const int imm8)
          VPERMQ ymm1,         ymm2/m256,         imm8
          VPERMQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute4x64(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permute4x64_pd (__m256d a, const int imm8)
          VPERMPD ymm1,         ymm2/m256,         imm8
          VPERMPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute4x64(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute4x64_epi64 (__m256i a, const int imm8)
          VPERMQ ymm1,         ymm2/m256,         imm8
          VPERMQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute4x64(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permute4x64_epi64 (__m256i a, const int imm8)
          VPERMQ ymm1,         ymm2/m256,         imm8
          VPERMQ ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Permute4x64(value: System.Runtime.Intrinsics.Vector256[float], control: int) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256d _mm256_permute4x64_pd (__m256d a, const int imm8)
          VPERMPD ymm1,         ymm2/m256,         imm8
          VPERMPD ymm1 {k1}{z}, ymm2/m256/m64bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def PermuteVar8x32(left: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permutevar8x32_epi32 (__m256i a, __m256i idx)
          VPERMD ymm1,         ymm2/m256,         imm8
          VPERMD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def PermuteVar8x32(left: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permutevar8x32_epi32 (__m256i a, __m256i idx)
          VPERMD ymm1,         ymm2/m256,         imm8
          VPERMD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def PermuteVar8x32(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permutevar8x32_ps (__m256 a, __m256i idx)
          VPERMPS ymm1,         ymm2/m256,         imm8
          VPERMPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def PermuteVar8x32(left: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permutevar8x32_epi32 (__m256i a, __m256i idx)
          VPERMD ymm1,         ymm2/m256,         imm8
          VPERMD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def PermuteVar8x32(left: System.Runtime.Intrinsics.Vector256[int], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_permutevar8x32_epi32 (__m256i a, __m256i idx)
          VPERMD ymm1,         ymm2/m256,         imm8
          VPERMD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def PermuteVar8x32(left: System.Runtime.Intrinsics.Vector256[float], control: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm256_permutevar8x32_ps (__m256 a, __m256i idx)
          VPERMPS ymm1,         ymm2/m256,         imm8
          VPERMPS ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi16 (__m256i a, __m128i count)
          VPSLLW ymm1,         ymm2, xmm3/m128
          VPSLLW ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi16 (__m256i a, __m128i count)
          VPSLLW ymm1,         ymm2, xmm3/m128
          VPSLLW ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi32 (__m256i a, __m128i count)
          VPSLLD ymm1,         ymm2, xmm3/m128
          VPSLLD ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi32 (__m256i a, __m128i count)
          VPSLLD ymm1,         ymm2, xmm3/m128
          VPSLLD ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi64 (__m256i a, __m128i count)
          VPSLLQ ymm1,         ymm2, xmm3/m128
          VPSLLQ ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi64 (__m256i a, __m128i count)
          VPSLLQ ymm1,         ymm2, xmm3/m128
          VPSLLQ ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi16 (__m256i a, int imm8)
          VPSLLW ymm1,         ymm2, imm8
          VPSLLW ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi16 (__m256i a, int imm8)
          VPSLLW ymm1,         ymm2, imm8
          VPSLLW ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi32 (__m256i a, int imm8)
          VPSLLD ymm1,         ymm2, imm8
          VPSLLD ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi32 (__m256i a, int imm8)
          VPSLLD ymm1,         ymm2, imm8
          VPSLLD ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi64 (__m256i a, int imm8)
          VPSLLQ ymm1,         ymm2, imm8
          VPSLLQ ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi64 (__m256i a, int imm8)
          VPSLLQ ymm1,         ymm2, imm8
          VPSLLQ ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi16 (__m256i a, __m128i count)
          VPSLLW ymm1,         ymm2, xmm3/m128
          VPSLLW ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi16 (__m256i a, __m128i count)
          VPSLLW ymm1,         ymm2, xmm3/m128
          VPSLLW ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi32 (__m256i a, __m128i count)
          VPSLLD ymm1,         ymm2, xmm3/m128
          VPSLLD ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi32 (__m256i a, __m128i count)
          VPSLLD ymm1,         ymm2, xmm3/m128
          VPSLLD ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi64 (__m256i a, __m128i count)
          VPSLLQ ymm1,         ymm2, xmm3/m128
          VPSLLQ ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sll_epi64 (__m256i a, __m128i count)
          VPSLLQ ymm1,         ymm2, xmm3/m128
          VPSLLQ ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi16 (__m256i a, int imm8)
          VPSLLW ymm1,         ymm2, imm8
          VPSLLW ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi16 (__m256i a, int imm8)
          VPSLLW ymm1,         ymm2, imm8
          VPSLLW ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi32 (__m256i a, int imm8)
          VPSLLD ymm1,         ymm2, imm8
          VPSLLD ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi32 (__m256i a, int imm8)
          VPSLLD ymm1,         ymm2, imm8
          VPSLLD ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi64 (__m256i a, int imm8)
          VPSLLQ ymm1,         ymm2, imm8
          VPSLLQ ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_slli_epi64 (__m256i a, int imm8)
          VPSLLQ ymm1,         ymm2, imm8
          VPSLLQ ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bslli_epi128 (__m256i a, const int imm8)
          VPSLLDQ ymm1, ymm2/m256, imm8
        This intrinsic generates PSLLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi32 (__m128i a, __m128i count)
          VPSLLVD xmm1,         xmm2, xmm3/m128
          VPSLLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi32 (__m128i a, __m128i count)
          VPSLLVD xmm1,         xmm2, xmm3/m128
          VPSLLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi64 (__m128i a, __m128i count)
          VPSLLVQ xmm1,         xmm2, xmm3/m128
          VPSLLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi64 (__m128i a, __m128i count)
          VPSLLVQ xmm1,         xmm2, xmm3/m128
          VPSLLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi32 (__m256i a, __m256i count)
          VPSLLVD ymm1,         ymm2, ymm3/m256
          VPSLLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi32 (__m256i a, __m256i count)
          VPSLLVD ymm1,         ymm2, ymm3/m256
          VPSLLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi64 (__m256i a, __m256i count)
          VPSLLVQ ymm1,         ymm2, ymm3/m256
          VPSLLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi64 (__m256i a, __m256i count)
          VPSLLVQ ymm1,         ymm2, ymm3/m256
          VPSLLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi32 (__m128i a, __m128i count)
          VPSLLVD xmm1,         xmm2, xmm3/m128
          VPSLLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi32 (__m128i a, __m128i count)
          VPSLLVD xmm1,         xmm2, xmm3/m128
          VPSLLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi64 (__m128i a, __m128i count)
          VPSLLVQ xmm1,         xmm2, xmm3/m128
          VPSLLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_sllv_epi64 (__m128i a, __m128i count)
          VPSLLVQ xmm1,         xmm2, xmm3/m128
          VPSLLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi32 (__m256i a, __m256i count)
          VPSLLVD ymm1,         ymm2, ymm3/m256
          VPSLLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi32 (__m256i a, __m256i count)
          VPSLLVD ymm1,         ymm2, ymm3/m256
          VPSLLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi64 (__m256i a, __m256i count)
          VPSLLVQ ymm1,         ymm2, ymm3/m256
          VPSLLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftLeftLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sllv_epi64 (__m256i a, __m256i count)
          VPSLLVQ ymm1,         ymm2, ymm3/m256
          VPSLLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        _mm256_sra_epi16 (__m256i a, __m128i count)
          VPSRAW ymm1,         ymm2, xmm3/m128
          VPSRAW ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        _mm256_sra_epi32 (__m256i a, __m128i count)
          VPSRAD ymm1,         ymm2, xmm3/m128
          VPSRAD ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srai_epi16 (__m256i a, int imm8)
          VPSRAW ymm1,         ymm2, imm8
          VPSRAW ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srai_epi32 (__m256i a, int imm8)
          VPSRAD ymm1,         ymm2, imm8
          VPSRAD ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        _mm256_sra_epi16 (__m256i a, __m128i count)
          VPSRAW ymm1,         ymm2, xmm3/m128
          VPSRAW ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        _mm256_sra_epi32 (__m256i a, __m128i count)
          VPSRAD ymm1,         ymm2, xmm3/m128
          VPSRAD ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srai_epi16 (__m256i a, int imm8)
          VPSRAW ymm1,         ymm2, imm8
          VPSRAW ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srai_epi32 (__m256i a, int imm8)
          VPSRAD ymm1,         ymm2, imm8
          VPSRAD ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmeticVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srav_epi32 (__m128i a, __m128i count)
          VPSRAVD xmm1,         xmm2, xmm3/m128
          VPSRAVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmeticVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srav_epi32 (__m256i a, __m256i count)
          VPSRAVD ymm1,         ymm2, ymm3/m256
          VPSRAVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmeticVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srav_epi32 (__m128i a, __m128i count)
          VPSRAVD xmm1,         xmm2, xmm3/m128
          VPSRAVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightArithmeticVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srav_epi32 (__m256i a, __m256i count)
          VPSRAVD ymm1,         ymm2, ymm3/m256
          VPSRAVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi16 (__m256i a, __m128i count)
          VPSRLW ymm1,         ymm2, xmm3/m128
          VPSRLW ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi16 (__m256i a, __m128i count)
          VPSRLW ymm1,         ymm2, xmm3/m128
          VPSRLW ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi32 (__m256i a, __m128i count)
          VPSRLD ymm1,         ymm2, xmm3/m128
          VPSRLD ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi32 (__m256i a, __m128i count)
          VPSRLD ymm1,         ymm2, xmm3/m128
          VPSRLD ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi64 (__m256i a, __m128i count)
          VPSRLQ ymm1,         ymm2, xmm3/m128
          VPSRLQ ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi64 (__m256i a, __m128i count)
          VPSRLQ ymm1,         ymm2, xmm3/m128
          VPSRLQ ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi16 (__m256i a, int imm8)
          VPSRLW ymm1,         ymm2, imm8
          VPSRLW ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi16 (__m256i a, int imm8)
          VPSRLW ymm1,         ymm2, imm8
          VPSRLW ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi32 (__m256i a, int imm8)
          VPSRLD ymm1,         ymm2, imm8
          VPSRLD ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi32 (__m256i a, int imm8)
          VPSRLD ymm1,         ymm2, imm8
          VPSRLD ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi64 (__m256i a, int imm8)
          VPSRLQ ymm1,         ymm2, imm8
          VPSRLQ ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi64 (__m256i a, int imm8)
          VPSRLQ ymm1,         ymm2, imm8
          VPSRLQ ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi16 (__m256i a, __m128i count)
          VPSRLW ymm1,         ymm2, xmm3/m128
          VPSRLW ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi16 (__m256i a, __m128i count)
          VPSRLW ymm1,         ymm2, xmm3/m128
          VPSRLW ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi32 (__m256i a, __m128i count)
          VPSRLD ymm1,         ymm2, xmm3/m128
          VPSRLD ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi32 (__m256i a, __m128i count)
          VPSRLD ymm1,         ymm2, xmm3/m128
          VPSRLD ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi64 (__m256i a, __m128i count)
          VPSRLQ ymm1,         ymm2, xmm3/m128
          VPSRLQ ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srl_epi64 (__m256i a, __m128i count)
          VPSRLQ ymm1,         ymm2, xmm3/m128
          VPSRLQ ymm1 {k1}{z}, ymm2, xmm3/m128
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi16 (__m256i a, int imm8)
          VPSRLW ymm1,         ymm2, imm8
          VPSRLW ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi16 (__m256i a, int imm8)
          VPSRLW ymm1,         ymm2, imm8
          VPSRLW ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi32 (__m256i a, int imm8)
          VPSRLD ymm1,         ymm2, imm8
          VPSRLD ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi32 (__m256i a, int imm8)
          VPSRLD ymm1,         ymm2, imm8
          VPSRLD ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi64 (__m256i a, int imm8)
          VPSRLQ ymm1,         ymm2, imm8
          VPSRLQ ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srli_epi64 (__m256i a, int imm8)
          VPSRLQ ymm1,         ymm2, imm8
          VPSRLQ ymm1 {k1}{z}, ymm2, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogical128BitLane(value: System.Runtime.Intrinsics.Vector256[int], numBytes: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_bsrli_epi128 (__m256i a, const int imm8)
          VPSRLDQ ymm1, ymm2/m128, imm8
        This intrinsic generates PSRLDQ that operates over bytes rather than elements of the vectors.
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi32 (__m128i a, __m128i count)
          VPSRLVD xmm1,         xmm2, xmm3/m128
          VPSRLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi32 (__m128i a, __m128i count)
          VPSRLVD xmm1,         xmm2, xmm3/m128
          VPSRLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi64 (__m128i a, __m128i count)
          VPSRLVQ xmm1,         xmm2, xmm3/m128
          VPSRLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi64 (__m128i a, __m128i count)
          VPSRLVQ xmm1,         xmm2, xmm3/m128
          VPSRLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi32 (__m256i a, __m256i count)
          VPSRLVD ymm1,         ymm2, ymm3/m256
          VPSRLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi32 (__m256i a, __m256i count)
          VPSRLVD ymm1,         ymm2, ymm3/m256
          VPSRLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi64 (__m256i a, __m256i count)
          VPSRLVQ ymm1,         ymm2, ymm3/m256
          VPSRLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi64 (__m256i a, __m256i count)
          VPSRLVQ ymm1,         ymm2, ymm3/m256
          VPSRLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi32 (__m128i a, __m128i count)
          VPSRLVD xmm1,         xmm2, xmm3/m128
          VPSRLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi32 (__m128i a, __m128i count)
          VPSRLVD xmm1,         xmm2, xmm3/m128
          VPSRLVD xmm1 {k1}{z}, xmm2, xmm3/m128/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi64 (__m128i a, __m128i count)
          VPSRLVQ xmm1,         xmm2, xmm3/m128
          VPSRLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
        """
        __m128i _mm_srlv_epi64 (__m128i a, __m128i count)
          VPSRLVQ xmm1,         xmm2, xmm3/m128
          VPSRLVQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi32 (__m256i a, __m256i count)
          VPSRLVD ymm1,         ymm2, ymm3/m256
          VPSRLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi32 (__m256i a, __m256i count)
          VPSRLVD ymm1,         ymm2, ymm3/m256
          VPSRLVD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi64 (__m256i a, __m256i count)
          VPSRLVQ ymm1,         ymm2, ymm3/m256
          VPSRLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ShiftRightLogicalVariable(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_srlv_epi64 (__m256i a, __m256i count)
          VPSRLVQ ymm1,         ymm2, ymm3/m256
          VPSRLVQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi8 (__m256i a, __m256i b)
          VPSHUFB ymm1,         ymm2, ymm3/m256
          VPSHUFB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi8 (__m256i a, __m256i b)
          VPSHUFB ymm1,         ymm2, ymm3/m256
          VPSHUFB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi32 (__m256i a, const int imm8)
          VPSHUFD ymm1,         ymm2/m256,         imm8
          VPSHUFD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi32 (__m256i a, const int imm8)
          VPSHUFD ymm1,         ymm2/m256,         imm8
          VPSHUFD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi8 (__m256i a, __m256i b)
          VPSHUFB ymm1,         ymm2, ymm3/m256
          VPSHUFB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], mask: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi8 (__m256i a, __m256i b)
          VPSHUFB ymm1,         ymm2, ymm3/m256
          VPSHUFB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi32 (__m256i a, const int imm8)
          VPSHUFD ymm1,         ymm2/m256,         imm8
          VPSHUFD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def Shuffle(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shuffle_epi32 (__m256i a, const int imm8)
          VPSHUFD ymm1,         ymm2/m256,         imm8
          VPSHUFD ymm1 {k1}{z}, ymm2/m256/m32bcst, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflehi_epi16 (__m256i a, const int imm8)
          VPSHUFHW ymm1,         ymm2/m256, imm8
          VPSHUFHW ymm1 {k1}{z}, ymm2/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflehi_epi16 (__m256i a, const int imm8)
          VPSHUFHW ymm1,         ymm2/m256, imm8
          VPSHUFHW ymm1 {k1}{z}, ymm2/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflehi_epi16 (__m256i a, const int imm8)
          VPSHUFHW ymm1,         ymm2/m256, imm8
          VPSHUFHW ymm1 {k1}{z}, ymm2/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleHigh(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflehi_epi16 (__m256i a, const int imm8)
          VPSHUFHW ymm1,         ymm2/m256, imm8
          VPSHUFHW ymm1 {k1}{z}, ymm2/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflelo_epi16 (__m256i a, const int imm8)
          VPSHUFLW ymm1,         ymm2/m256, imm8
          VPSHUFLW ymm1 {k1}{z}, ymm2/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflelo_epi16 (__m256i a, const int imm8)
          VPSHUFLW ymm1,         ymm2/m256, imm8
          VPSHUFLW ymm1 {k1}{z}, ymm2/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflelo_epi16 (__m256i a, const int imm8)
          VPSHUFLW ymm1,         ymm2/m256, imm8
          VPSHUFLW ymm1 {k1}{z}, ymm2/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def ShuffleLow(value: System.Runtime.Intrinsics.Vector256[int], control: int) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_shufflelo_epi16 (__m256i a, const int imm8)
          VPSHUFLW ymm1,         ymm2/m256, imm8
          VPSHUFLW ymm1 {k1}{z}, ymm2/m256, imm8
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sign_epi8 (__m256i a, __m256i b)
          VPSIGNB ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sign_epi16 (__m256i a, __m256i b)
          VPSIGNW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sign_epi32 (__m256i a, __m256i b)
          VPSIGND ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sign_epi8 (__m256i a, __m256i b)
          VPSIGNB ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sign_epi16 (__m256i a, __m256i b)
          VPSIGNW ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Sign(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sign_epi32 (__m256i a, __m256i b)
          VPSIGND ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi8 (__m256i a, __m256i b)
          VPSUBB ymm1,         ymm2, ymm3/m256
          VPSUBB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi8 (__m256i a, __m256i b)
          VPSUBB ymm1,         ymm2, ymm3/m256
          VPSUBB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi16 (__m256i a, __m256i b)
          VPSUBW ymm1,         ymm2, ymm3/m256
          VPSUBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi16 (__m256i a, __m256i b)
          VPSUBW ymm1,         ymm2, ymm3/m256
          VPSUBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi32 (__m256i a, __m256i b)
          VPSUBD ymm1,         ymm2, ymm3/m256
          VPSUBD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi32 (__m256i a, __m256i b)
          VPSUBD ymm1,         ymm2, ymm3/m256
          VPSUBD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi64 (__m256i a, __m256i b)
          VPSUBQ ymm1,         ymm2, ymm3/m256
          VPSUBQ ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi64 (__m256i a, __m256i b)
          VPSUBQ ymm1,         ymm2, ymm3/m256
          VPSUBQ ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi8 (__m256i a, __m256i b)
          VPSUBB ymm1,         ymm2, ymm3/m256
          VPSUBB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi8 (__m256i a, __m256i b)
          VPSUBB ymm1,         ymm2, ymm3/m256
          VPSUBB ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi16 (__m256i a, __m256i b)
          VPSUBW ymm1,         ymm2, ymm3/m256
          VPSUBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi16 (__m256i a, __m256i b)
          VPSUBW ymm1,         ymm2, ymm3/m256
          VPSUBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi32 (__m256i a, __m256i b)
          VPSUBD ymm1,         ymm2, ymm3/m256
          VPSUBD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi32 (__m256i a, __m256i b)
          VPSUBD ymm1,         ymm2, ymm3/m256
          VPSUBD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi64 (__m256i a, __m256i b)
          VPSUBQ ymm1,         ymm2, ymm3/m256
          VPSUBQ ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Subtract(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sub_epi64 (__m256i a, __m256i b)
          VPSUBQ ymm1,         ymm2, ymm3/m256
          VPSUBQ ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epi8 (__m256i a, __m256i b)
          VPSUBSB ymm1,         ymm2, ymm3/m128
          VPSUBSB ymm1 {k1}{z}, ymm2, ymm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epi16 (__m256i a, __m256i b)
          VPSUBSW ymm1,         ymm2, ymm3/m128
          VPSUBSW ymm1 {k1}{z}, ymm2, ymm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epu8 (__m256i a, __m256i b)
          VPSUBUSB ymm1,         ymm2, ymm3/m128
          VPSUBUSB ymm1 {k1}{z}, ymm2, ymm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epu16 (__m256i a, __m256i b)
          VPSUBUSW ymm1,         ymm2, ymm3/m128
          VPSUBUSW ymm1 {k1}{z}, ymm2, ymm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epi8 (__m256i a, __m256i b)
          VPSUBSB ymm1,         ymm2, ymm3/m128
          VPSUBSB ymm1 {k1}{z}, ymm2, ymm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epi16 (__m256i a, __m256i b)
          VPSUBSW ymm1,         ymm2, ymm3/m128
          VPSUBSW ymm1 {k1}{z}, ymm2, ymm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epu8 (__m256i a, __m256i b)
          VPSUBUSB ymm1,         ymm2, ymm3/m128
          VPSUBUSB ymm1 {k1}{z}, ymm2, ymm3/m128
        """
        ...

    @staticmethod
    @overload
    def SubtractSaturate(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_subs_epu16 (__m256i a, __m256i b)
          VPSUBUSW ymm1,         ymm2, ymm3/m128
          VPSUBUSW ymm1 {k1}{z}, ymm2, ymm3/m128
        """
        ...

    @staticmethod
    @overload
    def SumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sad_epu8 (__m256i a, __m256i b)
          VPSADBW ymm1,         ymm2, ymm3/m256
          VPSADBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def SumAbsoluteDifferences(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_sad_epu8 (__m256i a, __m256i b)
          VPSADBW ymm1,         ymm2, ymm3/m256
          VPSADBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi8 (__m256i a, __m256i b)
          VPUNPCKHBW ymm1,         ymm2, ymm3/m256
          VPUNPCKHBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi8 (__m256i a, __m256i b)
          VPUNPCKHBW ymm1,         ymm2, ymm3/m256
          VPUNPCKHBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi16 (__m256i a, __m256i b)
          VPUNPCKHWD ymm1,         ymm2, ymm3/m256
          VPUNPCKHWD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi16 (__m256i a, __m256i b)
          VPUNPCKHWD ymm1,         ymm2, ymm3/m256
          VPUNPCKHWD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi32 (__m256i a, __m256i b)
          VPUNPCKHDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKHDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi32 (__m256i a, __m256i b)
          VPUNPCKHDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKHDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi64 (__m256i a, __m256i b)
          VPUNPCKHQDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKHQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi64 (__m256i a, __m256i b)
          VPUNPCKHQDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKHQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi8 (__m256i a, __m256i b)
          VPUNPCKHBW ymm1,         ymm2, ymm3/m256
          VPUNPCKHBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi8 (__m256i a, __m256i b)
          VPUNPCKHBW ymm1,         ymm2, ymm3/m256
          VPUNPCKHBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi16 (__m256i a, __m256i b)
          VPUNPCKHWD ymm1,         ymm2, ymm3/m256
          VPUNPCKHWD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi16 (__m256i a, __m256i b)
          VPUNPCKHWD ymm1,         ymm2, ymm3/m256
          VPUNPCKHWD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi32 (__m256i a, __m256i b)
          VPUNPCKHDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKHDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi32 (__m256i a, __m256i b)
          VPUNPCKHDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKHDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi64 (__m256i a, __m256i b)
          VPUNPCKHQDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKHQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackHigh(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpackhi_epi64 (__m256i a, __m256i b)
          VPUNPCKHQDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKHQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi8 (__m256i a, __m256i b)
          VPUNPCKLBW ymm1,         ymm2, ymm3/m256
          VPUNPCKLBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi8 (__m256i a, __m256i b)
          VPUNPCKLBW ymm1,         ymm2, ymm3/m256
          VPUNPCKLBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi16 (__m256i a, __m256i b)
          VPUNPCKLWD ymm1,         ymm2, ymm3/m256
          VPUNPCKLWD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi16 (__m256i a, __m256i b)
          VPUNPCKLWD ymm1,         ymm2, ymm3/m256
          VPUNPCKLWD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi32 (__m256i a, __m256i b)
          VPUNPCKLDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKLDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi32 (__m256i a, __m256i b)
          VPUNPCKLDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKLDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi64 (__m256i a, __m256i b)
          VPUNPCKLQDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKLQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi64 (__m256i a, __m256i b)
          VPUNPCKLQDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKLQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi8 (__m256i a, __m256i b)
          VPUNPCKLBW ymm1,         ymm2, ymm3/m256
          VPUNPCKLBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi8 (__m256i a, __m256i b)
          VPUNPCKLBW ymm1,         ymm2, ymm3/m256
          VPUNPCKLBW ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi16 (__m256i a, __m256i b)
          VPUNPCKLWD ymm1,         ymm2, ymm3/m256
          VPUNPCKLWD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi16 (__m256i a, __m256i b)
          VPUNPCKLWD ymm1,         ymm2, ymm3/m256
          VPUNPCKLWD ymm1 {k1}{z}, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi32 (__m256i a, __m256i b)
          VPUNPCKLDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKLDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi32 (__m256i a, __m256i b)
          VPUNPCKLDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKLDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi64 (__m256i a, __m256i b)
          VPUNPCKLQDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKLQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def UnpackLow(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_unpacklo_epi64 (__m256i a, __m256i b)
          VPUNPCKLQDQ ymm1,         ymm2, ymm3/m256
          VPUNPCKLQDQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR  ymm1,         ymm2, ymm3/m256
          VPXORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR  ymm1,         ymm2, ymm3/m256
          VPXORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR  ymm1,         ymm2, ymm3/m256
          VPXORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR  ymm1,         ymm2, ymm3/m256
          VPXORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR ymm1, ymm2, ymm3/m256
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR  ymm1,         ymm2, ymm3/m256
          VPXORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR  ymm1,         ymm2, ymm3/m256
          VPXORD ymm1 {k1}{z}, ymm2, ymm3/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR  ymm1,         ymm2, ymm3/m256
          VPXORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Xor(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm256_xor_si256 (__m256i a, __m256i b)
          VPXOR  ymm1,         ymm2, ymm3/m256
          VPXORQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
        """
        ...


class Avx512F(System.Runtime.Intrinsics.X86.Avx2, metaclass=abc.ABCMeta):
    """This class provides access to X86 AVX512F hardware instructions via intrinsics"""

    class VL(System.Object, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

        @staticmethod
        @overload
        def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_abs_epi64 (__m128i a)
              VPABSQ xmm1 {k1}{z}, xmm2/m128/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_abs_epi64 (__m128i a)
              VPABSQ ymm1 {k1}{z}, ymm2/m256/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Abs(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_abs_epi64 (__m128i a)
              VPABSQ xmm1 {k1}{z}, xmm2/m128/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Abs(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_abs_epi64 (__m128i a)
              VPABSQ ymm1 {k1}{z}, ymm2/m256/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_max_epi64 (__m128i a, __m128i b)
              VPMAXSQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_max_epu64 (__m128i a, __m128i b)
              VPMAXUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_max_epi64 (__m256i a, __m256i b)
              VPMAXSQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_max_epu64 (__m256i a, __m256i b)
              VPMAXUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_max_epi64 (__m128i a, __m128i b)
              VPMAXSQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Max(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_max_epu64 (__m128i a, __m128i b)
              VPMAXUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_max_epi64 (__m256i a, __m256i b)
              VPMAXSQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Max(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_max_epu64 (__m256i a, __m256i b)
              VPMAXUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_min_epi64 (__m128i a, __m128i b)
              VPMINSQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_min_epu64 (__m128i a, __m128i b)
              VPMINUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_min_epi64 (__m256i a, __m256i b)
              VPMINSQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_min_epu64 (__m256i a, __m256i b)
              VPMINUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_min_epi64 (__m128i a, __m128i b)
              VPMINSQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Min(left: System.Runtime.Intrinsics.Vector128[int], right: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_min_epu64 (__m128i a, __m128i b)
              VPMINUQ xmm1 {k1}{z}, xmm2, xmm3/m128/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_min_epi64 (__m256i a, __m256i b)
              VPMINSQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
            """
            ...

        @staticmethod
        @overload
        def Min(left: System.Runtime.Intrinsics.Vector256[int], right: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_min_epu64 (__m256i a, __m256i b)
              VPMINUQ ymm1 {k1}{z}, ymm2, ymm3/m256/m64bcst
            """
            ...

        @staticmethod
        @overload
        def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_sra_epi64 (__m128i a, __m128i count)
              VPSRAQ xmm1 {k1}{z}, xmm2, xmm3/m128
            """
            ...

        @staticmethod
        @overload
        def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_sra_epi64 (__m256i a, __m128i count)
              VPSRAQ ymm1 {k1}{z}, ymm2, xmm3/m128
            """
            ...

        @staticmethod
        @overload
        def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __128i _mm_srai_epi64 (__m128i a, int imm8)
              VPSRAQ xmm1 {k1}{z}, xmm2, imm8
            """
            ...

        @staticmethod
        @overload
        def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_srai_epi64 (__m256i a, int imm8)
              VPSRAQ ymm1 {k1}{z}, ymm2, imm8
            """
            ...

        @staticmethod
        @overload
        def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __m128i _mm_sra_epi64 (__m128i a, __m128i count)
              VPSRAQ xmm1 {k1}{z}, xmm2, xmm3/m128
            """
            ...

        @staticmethod
        @overload
        def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_sra_epi64 (__m256i a, __m128i count)
              VPSRAQ ymm1 {k1}{z}, ymm2, xmm3/m128
            """
            ...

        @staticmethod
        @overload
        def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector128[int], count: int) -> System.Runtime.Intrinsics.Vector128[int]:
            """
            __128i _mm_srai_epi64 (__m128i a, int imm8)
              VPSRAQ xmm1 {k1}{z}, xmm2, imm8
            """
            ...

        @staticmethod
        @overload
        def ShiftRightArithmetic(value: System.Runtime.Intrinsics.Vector256[int], count: int) -> System.Runtime.Intrinsics.Vector256[int]:
            """
            __m256i _mm256_srai_epi64 (__m256i a, int imm8)
              VPSRAQ ymm1 {k1}{z}, ymm2, imm8
            """
            ...

    class X64(System.Runtime.Intrinsics.X86.Avx2.X64, metaclass=abc.ABCMeta):
        """This class has no documentation."""

        IsSupported: bool

    IsSupported: bool

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_abs_epi32 (__m512i a)
          VPABSD zmm1 {k1}{z}, zmm2/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_abs_epi64 (__m512i a)
          VPABSQ zmm1 {k1}{z}, zmm2/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_abs_epi32 (__m512i a)
          VPABSD zmm1 {k1}{z}, zmm2/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Abs(value: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_abs_epi64 (__m512i a)
          VPABSQ zmm1 {k1}{z}, zmm2/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_add_epi32 (__m512i a, __m512i b)
          VPADDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_add_epi32 (__m512i a, __m512i b)
          VPADDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_add_epi64 (__m512i a, __m512i b)
          VPADDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_add_epi64 (__m512i a, __m512i b)
          VPADDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector512[float], right: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512d _mm512_add_pd (__m512d a, __m512d b)
          VADDPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector512[float], right: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512 _mm512_add_ps (__m512 a, __m512 b)
          VADDPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_add_epi32 (__m512i a, __m512i b)
          VPADDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_add_epi32 (__m512i a, __m512i b)
          VPADDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_add_epi64 (__m512i a, __m512i b)
          VPADDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_add_epi64 (__m512i a, __m512i b)
          VPADDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector512[float], right: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512d _mm512_add_pd (__m512d a, __m512d b)
          VADDPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}
        """
        ...

    @staticmethod
    @overload
    def Add(left: System.Runtime.Intrinsics.Vector512[float], right: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512 _mm512_add_ps (__m512 a, __m512 b)
          VADDPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_si512 (__m512i a, __m512i b)
          VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_si512 (__m512i a, __m512i b)
          VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_si512 (__m512i a, __m512i b)
          VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_si512 (__m512i a, __m512i b)
          VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_epi32 (__m512i a, __m512i b)
          VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_epi32 (__m512i a, __m512i b)
          VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_epi64 (__m512i a, __m512i b)
          VPANDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_epi64 (__m512i a, __m512i b)
          VPANDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_si512 (__m512i a, __m512i b)
          VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_si512 (__m512i a, __m512i b)
          VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_si512 (__m512i a, __m512i b)
          VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_si512 (__m512i a, __m512i b)
          VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_epi32 (__m512i a, __m512i b)
          VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_epi32 (__m512i a, __m512i b)
          VPANDD zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_epi64 (__m512i a, __m512i b)
          VPANDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def And(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_and_epi64 (__m512i a, __m512i b)
          VPANDQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_si512 (__m512i a, __m512i b)
          VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_si512 (__m512i a, __m512i b)
          VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_si512 (__m512i a, __m512i b)
          VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_si512 (__m512i a, __m512i b)
          VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_epi32 (__m512i a, __m512i b)
          VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_epi32 (__m512i a, __m512i b)
          VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_epi64 (__m512i a, __m512i b)
          VPANDNQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_epi64 (__m512i a, __m512i b)
          VPANDNQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_si512 (__m512i a, __m512i b)
          VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_si512 (__m512i a, __m512i b)
          VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_si512 (__m512i a, __m512i b)
          VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_si512 (__m512i a, __m512i b)
          VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_epi32 (__m512i a, __m512i b)
          VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_epi32 (__m512i a, __m512i b)
          VPANDND zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_epi64 (__m512i a, __m512i b)
          VPANDNQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def AndNot(left: System.Runtime.Intrinsics.Vector512[int], right: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_andnot_epi64 (__m512i a, __m512i b)
          VPANDNQ zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm512_cvtpd_epi32 (__m512d a)
          VCVTPD2DQ ymm1 {k1}{z}, zmm2/m512/m64bcst{er}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm512_cvtpd_epi32 (__m512d a)
          VCVTPD2DQ ymm1 {k1}{z}, zmm2/m512/m64bcst{er}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32WithTruncation(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm512_cvttpd_epi32 (__m512d a)
          VCVTTPD2DQ ymm1 {k1}{z}, zmm2/m512/m64bcst{sae}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Int32WithTruncation(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector256[int]:
        """
        __m256i _mm512_cvttpd_epi32 (__m512d a)
          VCVTTPD2DQ ymm1 {k1}{z}, zmm2/m512/m64bcst{sae}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Single(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm512_cvtpd_ps (__m512d a)
          VCVTPD2PS ymm1,         zmm2/m512
          VCVTPD2PS ymm1 {k1}{z}, zmm2/m512/m64bcst{er}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector256Single(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector256[float]:
        """
        __m256 _mm512_cvtpd_ps (__m512d a)
          VCVTPD2PS ymm1,         zmm2/m512
          VCVTPD2PS ymm1 {k1}{z}, zmm2/m512/m64bcst{er}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Double(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512d _mm512_cvtepi32_pd (__m256i a)
          VCVTDQ2PD zmm1 {k1}{z}, ymm2/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Double(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512d _mm512_cvtps_pd (__m256 a)
          VCVTPS2PD zmm1 {k1}{z}, ymm2/m256/m32bcst{sae}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Double(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512d _mm512_cvtepi32_pd (__m256i a)
          VCVTDQ2PD zmm1 {k1}{z}, ymm2/m256/m32bcst
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Double(value: System.Runtime.Intrinsics.Vector256[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512d _mm512_cvtps_pd (__m256 a)
          VCVTPS2PD zmm1 {k1}{z}, ymm2/m256/m32bcst{sae}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi8_epi32 (__m128i a)
          VPMOVSXBD zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu8_epi32 (__m128i a)
          VPMOVZXBD zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi16_epi32 (__m128i a)
          VPMOVSXWD zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu16_epi32 (__m128i a)
          VPMOVZXWD zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int32(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtps_epi32 (__m512 a)
          VCVTPS2DQ zmm1 {k1}{z}, zmm2/m512/m32bcst{er}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi8_epi32 (__m128i a)
          VPMOVSXBD zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu8_epi32 (__m128i a)
          VPMOVZXBD zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi16_epi32 (__m128i a)
          VPMOVSXWD zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu16_epi32 (__m128i a)
          VPMOVZXWD zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int32(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtps_epi32 (__m512 a)
          VCVTPS2DQ zmm1 {k1}{z}, zmm2/m512/m32bcst{er}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int32WithTruncation(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvttps_epi32 (__m512 a)
          VCVTTPS2DQ zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int32WithTruncation(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvttps_epi32 (__m512 a)
          VCVTTPS2DQ zmm1 {k1}{z}, zmm2/m512/m32bcst{sae}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi8_epi64 (__m128i a)
          VPMOVSXBQ zmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu8_epi64 (__m128i a)
          VPMOVZXBQ zmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi16_epi64 (__m128i a)
          VPMOVSXWQ zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu16_epi64 (__m128i a)
          VPMOVZXWQ zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int64(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi32_epi64 (__m128i a)
          VPMOVSXDQ zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int64(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu32_epi64 (__m128i a)
          VPMOVZXDQ zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi8_epi64 (__m128i a)
          VPMOVSXBQ zmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu8_epi64 (__m128i a)
          VPMOVZXBQ zmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi16_epi64 (__m128i a)
          VPMOVSXWQ zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu16_epi64 (__m128i a)
          VPMOVZXWQ zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int64(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi32_epi64 (__m128i a)
          VPMOVSXDQ zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Int64(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu32_epi64 (__m128i a)
          VPMOVZXDQ zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Single(value: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512 _mm512_cvtepi32_ps (__m512i a)
          VCVTDQ2PS zmm1 {k1}{z}, zmm2/m512/m32bcst{er}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512Single(value: System.Runtime.Intrinsics.Vector512[int]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512 _mm512_cvtepi32_ps (__m512i a)
          VCVTDQ2PS zmm1 {k1}{z}, zmm2/m512/m32bcst{er}
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi8_epi32 (__m128i a)
          VPMOVSXBD zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu8_epi32 (__m128i a)
          VPMOVZXBD zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi16_epi32 (__m128i a)
          VPMOVSXWD zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu16_epi32 (__m128i a)
          VPMOVZXWD zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi8_epi32 (__m128i a)
          VPMOVSXBD zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt32(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu8_epi32 (__m128i a)
          VPMOVZXBD zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi16_epi32 (__m128i a)
          VPMOVSXWD zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt32(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu16_epi32 (__m128i a)
          VPMOVZXWD zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi8_epi64 (__m128i a)
          VPMOVSXBQ zmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu8_epi64 (__m128i a)
          VPMOVZXBQ zmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi16_epi64 (__m128i a)
          VPMOVSXWQ zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu16_epi64 (__m128i a)
          VPMOVZXWQ zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt64(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi32_epi64 (__m128i a)
          VPMOVSXDQ zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt64(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu32_epi64 (__m128i a)
          VPMOVZXDQ zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi8_epi64 (__m128i a)
          VPMOVSXBQ zmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu8_epi64 (__m128i a)
          VPMOVZXBQ zmm1 {k1}{z}, xmm2/m64
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi16_epi64 (__m128i a)
          VPMOVSXWQ zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt64(value: System.Runtime.Intrinsics.Vector128[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu16_epi64 (__m128i a)
          VPMOVZXWQ zmm1 {k1}{z}, xmm2/m128
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt64(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepi32_epi64 (__m128i a)
          VPMOVSXDQ zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def ConvertToVector512UInt64(value: System.Runtime.Intrinsics.Vector256[int]) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_cvtepu32_epi64 (__m128i a)
          VPMOVZXDQ zmm1 {k1}{z}, ymm2/m256
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector512[float], right: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512 _mm512_div_ps (__m512 a, __m512 b)
          VDIVPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector512[float], right: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512d _mm512_div_pd (__m512d a, __m512d b)
          VDIVPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector512[float], right: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512 _mm512_div_ps (__m512 a, __m512 b)
          VDIVPS zmm1 {k1}{z}, zmm2, zmm3/m512/m32bcst{er}
        """
        ...

    @staticmethod
    @overload
    def Divide(left: System.Runtime.Intrinsics.Vector512[float], right: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512d _mm512_div_pd (__m512d a, __m512d b)
          VDIVPD zmm1 {k1}{z}, zmm2, zmm3/m512/m64bcst{er}
        """
        ...

    @staticmethod
    @overload
    def DuplicateEvenIndexed(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512 _mm512_moveldup_ps (__m512 a)
          VMOVSLDUP zmm1 {k1}{z}, zmm2/m512
        """
        ...

    @staticmethod
    @overload
    def DuplicateEvenIndexed(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512d _mm512_movedup_pd (__m512d a)
          VMOVDDUP zmm1 {k1}{z}, zmm2/m512
        """
        ...

    @staticmethod
    @overload
    def DuplicateEvenIndexed(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512 _mm512_moveldup_ps (__m512 a)
          VMOVSLDUP zmm1 {k1}{z}, zmm2/m512
        """
        ...

    @staticmethod
    @overload
    def DuplicateEvenIndexed(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512d _mm512_movedup_pd (__m512d a)
          VMOVDDUP zmm1 {k1}{z}, zmm2/m512
        """
        ...

    @staticmethod
    @overload
    def DuplicateOddIndexed(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512 _mm512_movehdup_ps (__m512 a)
          VMOVSHDUP zmm1 {k1}{z}, zmm2/m512
        """
        ...

    @staticmethod
    @overload
    def DuplicateOddIndexed(value: System.Runtime.Intrinsics.Vector512[float]) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512 _mm512_movehdup_ps (__m512 a)
          VMOVSHDUP zmm1 {k1}{z}, zmm2/m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_si512 (__m512i const * mem_addr)
          VMOVDQA32 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_si512 (__m512i const * mem_addr)
          VMOVDQA32 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_si512 (__m512i const * mem_addr)
          VMOVDQA32 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_si512 (__m512i const * mem_addr)
          VMOVDQA32 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_epi32 (__m512i const * mem_addr)
          VMOVDQA32 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_epi32 (__m512i const * mem_addr)
          VMOVDQA32 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_epi64 (__m512i const * mem_addr)
          VMOVDQA64 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_epi64 (__m512i const * mem_addr)
          VMOVDQA64 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512 _mm512_load_ps (float const * mem_addr)
          VMOVAPS zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512d _mm512_load_pd (double const * mem_addr)
          VMOVAPD zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_si512 (__m512i const * mem_addr)
          VMOVDQA32 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_si512 (__m512i const * mem_addr)
          VMOVDQA32 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_si512 (__m512i const * mem_addr)
          VMOVDQA32 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_si512 (__m512i const * mem_addr)
          VMOVDQA32 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_epi32 (__m512i const * mem_addr)
          VMOVDQA32 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_epi32 (__m512i const * mem_addr)
          VMOVDQA32 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_epi64 (__m512i const * mem_addr)
          VMOVDQA64 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_load_epi64 (__m512i const * mem_addr)
          VMOVDQA64 zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512 _mm512_load_ps (float const * mem_addr)
          VMOVAPS zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[float]:
        """
        __m512d _mm512_load_pd (double const * mem_addr)
          VMOVAPD zmm1 {k1}{z}, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_stream_load_si512 (__m512i const* mem_addr)
          VMOVNTDQA zmm1, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_stream_load_si512 (__m512i const* mem_addr)
          VMOVNTDQA zmm1, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_stream_load_si512 (__m512i const* mem_addr)
          VMOVNTDQA zmm1, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_stream_load_si512 (__m512i const* mem_addr)
          VMOVNTDQA zmm1, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_stream_load_si512 (__m512i const* mem_addr)
          VMOVNTDQA zmm1, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_stream_load_si512 (__m512i const* mem_addr)
          VMOVNTDQA zmm1, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_stream_load_si512 (__m512i const* mem_addr)
          VMOVNTDQA zmm1, m512
        """
        ...

    @staticmethod
    @overload
    def LoadAlignedVector512NonTemporal(address: typing.Any) -> System.Runtime.Intrinsics.Vector512[int]:
        """
        __m512i _mm512_stream_load_si512 (__m512i const* mem_addr)
          VMOVNTDQA zmm1, m512
        """
       