"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Peer = exports.Port = exports.Protocol = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
/**
 * Protocol for use in Connection Rules
 *
 * https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
 */
var Protocol;
(function (Protocol) {
    Protocol["TCP"] = "TCP";
    Protocol["UDP"] = "UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * Interface for classes that provide the connection-specification parts of a security group rule
 */
class Port {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_gamelift_alpha_PortProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Port);
            }
            throw error;
        }
    }
    /**
       * A single TCP port
       */
    static tcp(port) {
        return new Port({
            protocol: Protocol.TCP,
            fromPort: port,
            toPort: port,
        });
    }
    /**
       * A TCP port range
       */
    static tcpRange(startPort, endPort) {
        return new Port({
            protocol: Protocol.TCP,
            fromPort: startPort,
            toPort: endPort,
        });
    }
    /**
       * Any TCP traffic
       */
    static allTcp() {
        return new Port({
            protocol: Protocol.TCP,
            fromPort: 1026,
            toPort: 60000,
        });
    }
    /**
       * A single UDP port
       */
    static udp(port) {
        return new Port({
            protocol: Protocol.UDP,
            fromPort: port,
            toPort: port,
        });
    }
    /**
       * A UDP port range
       */
    static udpRange(startPort, endPort) {
        return new Port({
            protocol: Protocol.UDP,
            fromPort: startPort,
            toPort: endPort,
        });
    }
    /**
       * Any UDP traffic
       */
    static allUdp() {
        return new Port({
            protocol: Protocol.UDP,
            fromPort: 1026,
            toPort: 60000,
        });
    }
    /**
     * Produce the ingress rule JSON for the given connection
     */
    toJson() {
        return {
            protocol: this.props.protocol,
            fromPort: this.props.fromPort,
            toPort: this.props.toPort,
        };
    }
}
exports.Port = Port;
_a = JSII_RTTI_SYMBOL_1;
Port[_a] = { fqn: "@aws-cdk/aws-gamelift-alpha.Port", version: "2.65.0-alpha.0" };
/**
   * Peer object factories
   *
   * The static methods on this object can be used to create peer objects
   * which represent a connection partner in inbound permission rules.
   *
   * Use this object if you need to represent connection partners using plain IP addresses.
   */
class Peer {
    constructor() {
    }
    /**
       * Create an IPv4 peer from a CIDR
       */
    static ipv4(cidrIp) {
        return new CidrIPv4(cidrIp);
    }
    /**
       * Any IPv4 address
       */
    static anyIpv4() {
        return new AnyIPv4();
    }
}
exports.Peer = Peer;
_b = JSII_RTTI_SYMBOL_1;
Peer[_b] = { fqn: "@aws-cdk/aws-gamelift-alpha.Peer", version: "2.65.0-alpha.0" };
/**
   * A connection to and from a given IP range
   */
class CidrIPv4 {
    constructor(cidrIp) {
        this.cidrIp = cidrIp;
        this.canInlineRule = true;
        if (!cdk.Token.isUnresolved(cidrIp)) {
            const cidrMatch = cidrIp.match(/^(\d{1,3}\.){3}\d{1,3}(\/\d+)?$/);
            if (!cidrMatch) {
                throw new Error(`Invalid IPv4 CIDR: "${cidrIp}"`);
            }
            if (!cidrMatch[2]) {
                throw new Error(`CIDR mask is missing in IPv4: "${cidrIp}". Did you mean "${cidrIp}/32"?`);
            }
        }
        this.uniqueId = cidrIp;
    }
    /**
       * Produce the ingress rule JSON for the given connection
       */
    toJson() {
        return { ipRange: this.cidrIp };
    }
}
/**
   * Any IPv4 address
   */
class AnyIPv4 extends CidrIPv4 {
    constructor() {
        super('0.0.0.0/0');
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5ncmVzcy1ydWxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW5ncmVzcy1ydWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLG1DQUFtQztBQUVuQzs7OztHQUlHO0FBQ0gsSUFBWSxRQUdYO0FBSEQsV0FBWSxRQUFRO0lBQ2xCLHVCQUFXLENBQUE7SUFDWCx1QkFBVyxDQUFBO0FBQ2IsQ0FBQyxFQUhXLFFBQVEsR0FBUixnQkFBUSxLQUFSLGdCQUFRLFFBR25CO0FBNkJEOztHQUVHO0FBQ0gsTUFBYSxJQUFJO0lBbUVmLFlBQTZCLEtBQWdCO1FBQWhCLFVBQUssR0FBTCxLQUFLLENBQVc7Ozs7OzsrQ0FuRWxDLElBQUk7Ozs7S0FtRWtDO0lBbEVqRDs7U0FFSztJQUNFLE1BQU0sQ0FBQyxHQUFHLENBQUMsSUFBWTtRQUM1QixPQUFPLElBQUksSUFBSSxDQUFDO1lBQ2QsUUFBUSxFQUFFLFFBQVEsQ0FBQyxHQUFHO1lBQ3RCLFFBQVEsRUFBRSxJQUFJO1lBQ2QsTUFBTSxFQUFFLElBQUk7U0FDYixDQUFDLENBQUM7S0FDSjtJQUVEOztTQUVLO0lBQ0UsTUFBTSxDQUFDLFFBQVEsQ0FBQyxTQUFpQixFQUFFLE9BQWU7UUFDdkQsT0FBTyxJQUFJLElBQUksQ0FBQztZQUNkLFFBQVEsRUFBRSxRQUFRLENBQUMsR0FBRztZQUN0QixRQUFRLEVBQUUsU0FBUztZQUNuQixNQUFNLEVBQUUsT0FBTztTQUNoQixDQUFDLENBQUM7S0FDSjtJQUVEOztTQUVLO0lBQ0UsTUFBTSxDQUFDLE1BQU07UUFDbEIsT0FBTyxJQUFJLElBQUksQ0FBQztZQUNkLFFBQVEsRUFBRSxRQUFRLENBQUMsR0FBRztZQUN0QixRQUFRLEVBQUUsSUFBSTtZQUNkLE1BQU0sRUFBRSxLQUFLO1NBQ2QsQ0FBQyxDQUFDO0tBQ0o7SUFFRDs7U0FFSztJQUNFLE1BQU0sQ0FBQyxHQUFHLENBQUMsSUFBWTtRQUM1QixPQUFPLElBQUksSUFBSSxDQUFDO1lBQ2QsUUFBUSxFQUFFLFFBQVEsQ0FBQyxHQUFHO1lBQ3RCLFFBQVEsRUFBRSxJQUFJO1lBQ2QsTUFBTSxFQUFFLElBQUk7U0FDYixDQUFDLENBQUM7S0FDSjtJQUVEOztTQUVLO0lBQ0UsTUFBTSxDQUFDLFFBQVEsQ0FBQyxTQUFpQixFQUFFLE9BQWU7UUFDdkQsT0FBTyxJQUFJLElBQUksQ0FBQztZQUNkLFFBQVEsRUFBRSxRQUFRLENBQUMsR0FBRztZQUN0QixRQUFRLEVBQUUsU0FBUztZQUNuQixNQUFNLEVBQUUsT0FBTztTQUNoQixDQUFDLENBQUM7S0FDSjtJQUVEOztTQUVLO0lBQ0UsTUFBTSxDQUFDLE1BQU07UUFDbEIsT0FBTyxJQUFJLElBQUksQ0FBQztZQUNkLFFBQVEsRUFBRSxRQUFRLENBQUMsR0FBRztZQUN0QixRQUFRLEVBQUUsSUFBSTtZQUNkLE1BQU0sRUFBRSxLQUFLO1NBQ2QsQ0FBQyxDQUFDO0tBQ0o7SUFJRDs7T0FFRztJQUNJLE1BQU07UUFDWCxPQUFPO1lBQ0wsUUFBUSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUTtZQUM3QixRQUFRLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRO1lBQzdCLE1BQU0sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU07U0FDMUIsQ0FBQztLQUNIOztBQTlFSCxvQkErRUM7OztBQWtCRDs7Ozs7OztLQU9LO0FBQ0wsTUFBYSxJQUFJO0lBZWY7S0FDQztJQWZEOztTQUVLO0lBQ0UsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFjO1FBQy9CLE9BQU8sSUFBSSxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUM7S0FDN0I7SUFFRDs7U0FFSztJQUNFLE1BQU0sQ0FBQyxPQUFPO1FBQ25CLE9BQU8sSUFBSSxPQUFPLEVBQUUsQ0FBQztLQUN0Qjs7QUFiSCxvQkFpQkM7OztBQUVEOztLQUVLO0FBQ0wsTUFBTSxRQUFRO0lBSVosWUFBNkIsTUFBYztRQUFkLFdBQU0sR0FBTixNQUFNLENBQVE7UUFIM0Isa0JBQWEsR0FBRyxJQUFJLENBQUM7UUFJbkMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1lBQ25DLE1BQU0sU0FBUyxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUMsaUNBQWlDLENBQUMsQ0FBQztZQUVsRSxJQUFJLENBQUMsU0FBUyxFQUFFO2dCQUNkLE1BQU0sSUFBSSxLQUFLLENBQUMsdUJBQXVCLE1BQU0sR0FBRyxDQUFDLENBQUM7YUFDbkQ7WUFFRCxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxFQUFFO2dCQUNqQixNQUFNLElBQUksS0FBSyxDQUFDLGtDQUFrQyxNQUFNLG9CQUFvQixNQUFNLE9BQU8sQ0FBQyxDQUFDO2FBQzVGO1NBQ0Y7UUFFRCxJQUFJLENBQUMsUUFBUSxHQUFHLE1BQU0sQ0FBQztLQUN4QjtJQUVEOztTQUVLO0lBQ0UsTUFBTTtRQUNYLE9BQU8sRUFBRSxPQUFPLEVBQUUsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO0tBQ2pDO0NBQ0Y7QUFFRDs7S0FFSztBQUNMLE1BQU0sT0FBUSxTQUFRLFFBQVE7SUFDNUI7UUFDRSxLQUFLLENBQUMsV0FBVyxDQUFDLENBQUM7S0FDcEI7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdhd3MtY2RrLWxpYic7XG5cbi8qKlxuICogUHJvdG9jb2wgZm9yIHVzZSBpbiBDb25uZWN0aW9uIFJ1bGVzXG4gKlxuICogaHR0cHM6Ly93d3cuaWFuYS5vcmcvYXNzaWdubWVudHMvcHJvdG9jb2wtbnVtYmVycy9wcm90b2NvbC1udW1iZXJzLnhodG1sXG4gKi9cbmV4cG9ydCBlbnVtIFByb3RvY29sIHtcbiAgVENQID0gJ1RDUCcsXG4gIFVEUCA9ICdVRFAnLFxufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgdG8gY3JlYXRlIGEgcG9ydCByYW5nZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIFBvcnRQcm9wcyB7XG4gIC8qKlxuICAgICAqIFRoZSBwcm90b2NvbCBmb3IgdGhlIHJhbmdlXG4gICAgICovXG4gIHJlYWRvbmx5IHByb3RvY29sOiBQcm90b2NvbDtcblxuICAvKipcbiAgICAgKiBBIHN0YXJ0aW5nIHZhbHVlIGZvciBhIHJhbmdlIG9mIGFsbG93ZWQgcG9ydCBudW1iZXJzLlxuICAgICAqXG4gICAgICogRm9yIGZsZWV0cyB1c2luZyBXaW5kb3dzIGFuZCBMaW51eCBidWlsZHMsIG9ubHkgcG9ydHMgMTAyNi02MDAwMCBhcmUgdmFsaWQuXG4gICAgICovXG4gIHJlYWRvbmx5IGZyb21Qb3J0OiBudW1iZXI7XG5cbiAgLyoqXG4gICAgICogQW4gZW5kaW5nIHZhbHVlIGZvciBhIHJhbmdlIG9mIGFsbG93ZWQgcG9ydCBudW1iZXJzLiBQb3J0IG51bWJlcnMgYXJlIGVuZC1pbmNsdXNpdmUuXG4gICAgICogVGhpcyB2YWx1ZSBtdXN0IGJlIGhpZ2hlciB0aGFuIGBmcm9tUG9ydGAuXG4gICAgICpcbiAgICAgKiBGb3IgZmxlZXRzIHVzaW5nIFdpbmRvd3MgYW5kIExpbnV4IGJ1aWxkcywgb25seSBwb3J0cyAxMDI2LTYwMDAwIGFyZSB2YWxpZC5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IHRoZSBgZnJvbVBvcnRgIHZhbHVlXG4gICAgICovXG4gIHJlYWRvbmx5IHRvUG9ydD86IG51bWJlcjtcbn1cblxuLyoqXG4gKiBJbnRlcmZhY2UgZm9yIGNsYXNzZXMgdGhhdCBwcm92aWRlIHRoZSBjb25uZWN0aW9uLXNwZWNpZmljYXRpb24gcGFydHMgb2YgYSBzZWN1cml0eSBncm91cCBydWxlXG4gKi9cbmV4cG9ydCBjbGFzcyBQb3J0IHtcbiAgLyoqXG4gICAgICogQSBzaW5nbGUgVENQIHBvcnRcbiAgICAgKi9cbiAgcHVibGljIHN0YXRpYyB0Y3AocG9ydDogbnVtYmVyKTogUG9ydCB7XG4gICAgcmV0dXJuIG5ldyBQb3J0KHtcbiAgICAgIHByb3RvY29sOiBQcm90b2NvbC5UQ1AsXG4gICAgICBmcm9tUG9ydDogcG9ydCxcbiAgICAgIHRvUG9ydDogcG9ydCxcbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgICAqIEEgVENQIHBvcnQgcmFuZ2VcbiAgICAgKi9cbiAgcHVibGljIHN0YXRpYyB0Y3BSYW5nZShzdGFydFBvcnQ6IG51bWJlciwgZW5kUG9ydDogbnVtYmVyKSB7XG4gICAgcmV0dXJuIG5ldyBQb3J0KHtcbiAgICAgIHByb3RvY29sOiBQcm90b2NvbC5UQ1AsXG4gICAgICBmcm9tUG9ydDogc3RhcnRQb3J0LFxuICAgICAgdG9Qb3J0OiBlbmRQb3J0LFxuICAgIH0pO1xuICB9XG5cbiAgLyoqXG4gICAgICogQW55IFRDUCB0cmFmZmljXG4gICAgICovXG4gIHB1YmxpYyBzdGF0aWMgYWxsVGNwKCkge1xuICAgIHJldHVybiBuZXcgUG9ydCh7XG4gICAgICBwcm90b2NvbDogUHJvdG9jb2wuVENQLFxuICAgICAgZnJvbVBvcnQ6IDEwMjYsXG4gICAgICB0b1BvcnQ6IDYwMDAwLFxuICAgIH0pO1xuICB9XG5cbiAgLyoqXG4gICAgICogQSBzaW5nbGUgVURQIHBvcnRcbiAgICAgKi9cbiAgcHVibGljIHN0YXRpYyB1ZHAocG9ydDogbnVtYmVyKTogUG9ydCB7XG4gICAgcmV0dXJuIG5ldyBQb3J0KHtcbiAgICAgIHByb3RvY29sOiBQcm90b2NvbC5VRFAsXG4gICAgICBmcm9tUG9ydDogcG9ydCxcbiAgICAgIHRvUG9ydDogcG9ydCxcbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgICAqIEEgVURQIHBvcnQgcmFuZ2VcbiAgICAgKi9cbiAgcHVibGljIHN0YXRpYyB1ZHBSYW5nZShzdGFydFBvcnQ6IG51bWJlciwgZW5kUG9ydDogbnVtYmVyKSB7XG4gICAgcmV0dXJuIG5ldyBQb3J0KHtcbiAgICAgIHByb3RvY29sOiBQcm90b2NvbC5VRFAsXG4gICAgICBmcm9tUG9ydDogc3RhcnRQb3J0LFxuICAgICAgdG9Qb3J0OiBlbmRQb3J0LFxuICAgIH0pO1xuICB9XG5cbiAgLyoqXG4gICAgICogQW55IFVEUCB0cmFmZmljXG4gICAgICovXG4gIHB1YmxpYyBzdGF0aWMgYWxsVWRwKCkge1xuICAgIHJldHVybiBuZXcgUG9ydCh7XG4gICAgICBwcm90b2NvbDogUHJvdG9jb2wuVURQLFxuICAgICAgZnJvbVBvcnQ6IDEwMjYsXG4gICAgICB0b1BvcnQ6IDYwMDAwLFxuICAgIH0pO1xuICB9XG5cbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwcm9wczogUG9ydFByb3BzKSB7fVxuXG4gIC8qKlxuICAgKiBQcm9kdWNlIHRoZSBpbmdyZXNzIHJ1bGUgSlNPTiBmb3IgdGhlIGdpdmVuIGNvbm5lY3Rpb25cbiAgICovXG4gIHB1YmxpYyB0b0pzb24oKTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgcHJvdG9jb2w6IHRoaXMucHJvcHMucHJvdG9jb2wsXG4gICAgICBmcm9tUG9ydDogdGhpcy5wcm9wcy5mcm9tUG9ydCxcbiAgICAgIHRvUG9ydDogdGhpcy5wcm9wcy50b1BvcnQsXG4gICAgfTtcbiAgfVxufVxuXG4vKipcbiAqIEludGVyZmFjZSBmb3IgY2xhc3NlcyB0aGF0IHByb3ZpZGUgdGhlIHBlZXItc3BlY2lmaWNhdGlvbiBwYXJ0cyBvZiBhbiBpbmJvdW5kIHBlcm1pc3Npb25cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJUGVlciB7XG5cbiAgLyoqXG4gICAgICogQSB1bmlxdWUgaWRlbnRpZmllciBmb3IgdGhpcyBjb25uZWN0aW9uIHBlZXJcbiAgICAgKi9cbiAgcmVhZG9ubHkgdW5pcXVlSWQ6IHN0cmluZztcblxuICAvKipcbiAgICAgKiBQcm9kdWNlIHRoZSBpbmdyZXNzIHJ1bGUgSlNPTiBmb3IgdGhlIGdpdmVuIGNvbm5lY3Rpb25cbiAgICAgKi9cbiAgdG9Kc29uKCk6IGFueTtcbn1cblxuLyoqXG4gICAqIFBlZXIgb2JqZWN0IGZhY3Rvcmllc1xuICAgKlxuICAgKiBUaGUgc3RhdGljIG1ldGhvZHMgb24gdGhpcyBvYmplY3QgY2FuIGJlIHVzZWQgdG8gY3JlYXRlIHBlZXIgb2JqZWN0c1xuICAgKiB3aGljaCByZXByZXNlbnQgYSBjb25uZWN0aW9uIHBhcnRuZXIgaW4gaW5ib3VuZCBwZXJtaXNzaW9uIHJ1bGVzLlxuICAgKlxuICAgKiBVc2UgdGhpcyBvYmplY3QgaWYgeW91IG5lZWQgdG8gcmVwcmVzZW50IGNvbm5lY3Rpb24gcGFydG5lcnMgdXNpbmcgcGxhaW4gSVAgYWRkcmVzc2VzLlxuICAgKi9cbmV4cG9ydCBjbGFzcyBQZWVyIHtcbiAgLyoqXG4gICAgICogQ3JlYXRlIGFuIElQdjQgcGVlciBmcm9tIGEgQ0lEUlxuICAgICAqL1xuICBwdWJsaWMgc3RhdGljIGlwdjQoY2lkcklwOiBzdHJpbmcpOiBJUGVlciB7XG4gICAgcmV0dXJuIG5ldyBDaWRySVB2NChjaWRySXApO1xuICB9XG5cbiAgLyoqXG4gICAgICogQW55IElQdjQgYWRkcmVzc1xuICAgICAqL1xuICBwdWJsaWMgc3RhdGljIGFueUlwdjQoKTogSVBlZXIge1xuICAgIHJldHVybiBuZXcgQW55SVB2NCgpO1xuICB9XG5cbiAgcHJvdGVjdGVkIGNvbnN0cnVjdG9yKCkge1xuICB9XG59XG5cbi8qKlxuICAgKiBBIGNvbm5lY3Rpb24gdG8gYW5kIGZyb20gYSBnaXZlbiBJUCByYW5nZVxuICAgKi9cbmNsYXNzIENpZHJJUHY0IGltcGxlbWVudHMgSVBlZXIge1xuICBwdWJsaWMgcmVhZG9ubHkgY2FuSW5saW5lUnVsZSA9IHRydWU7XG4gIHB1YmxpYyByZWFkb25seSB1bmlxdWVJZDogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgY2lkcklwOiBzdHJpbmcpIHtcbiAgICBpZiAoIWNkay5Ub2tlbi5pc1VucmVzb2x2ZWQoY2lkcklwKSkge1xuICAgICAgY29uc3QgY2lkck1hdGNoID0gY2lkcklwLm1hdGNoKC9eKFxcZHsxLDN9XFwuKXszfVxcZHsxLDN9KFxcL1xcZCspPyQvKTtcblxuICAgICAgaWYgKCFjaWRyTWF0Y2gpIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBJbnZhbGlkIElQdjQgQ0lEUjogXCIke2NpZHJJcH1cImApO1xuICAgICAgfVxuXG4gICAgICBpZiAoIWNpZHJNYXRjaFsyXSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoYENJRFIgbWFzayBpcyBtaXNzaW5nIGluIElQdjQ6IFwiJHtjaWRySXB9XCIuIERpZCB5b3UgbWVhbiBcIiR7Y2lkcklwfS8zMlwiP2ApO1xuICAgICAgfVxuICAgIH1cblxuICAgIHRoaXMudW5pcXVlSWQgPSBjaWRySXA7XG4gIH1cblxuICAvKipcbiAgICAgKiBQcm9kdWNlIHRoZSBpbmdyZXNzIHJ1bGUgSlNPTiBmb3IgdGhlIGdpdmVuIGNvbm5lY3Rpb25cbiAgICAgKi9cbiAgcHVibGljIHRvSnNvbigpOiBhbnkge1xuICAgIHJldHVybiB7IGlwUmFuZ2U6IHRoaXMuY2lkcklwIH07XG4gIH1cbn1cblxuLyoqXG4gICAqIEFueSBJUHY0IGFkZHJlc3NcbiAgICovXG5jbGFzcyBBbnlJUHY0IGV4dGVuZHMgQ2lkcklQdjQge1xuICBjb25zdHJ1Y3RvcigpIHtcbiAgICBzdXBlcignMC4wLjAuMC8wJyk7XG4gIH1cbn1cblxuLyoqXG4gKiBBIHJhbmdlIG9mIElQIGFkZHJlc3NlcyBhbmQgcG9ydCBzZXR0aW5ncyB0aGF0IGFsbG93IGluYm91bmQgdHJhZmZpYyB0byBjb25uZWN0IHRvIHNlcnZlciBwcm9jZXNzZXMgb24gYW4gaW5zdGFuY2UgaW4gYSBmbGVldC5cbiAqIE5ldyBnYW1lIHNlc3Npb25zIGFyZSBhc3NpZ25lZCBhbiBJUCBhZGRyZXNzL3BvcnQgbnVtYmVyIGNvbWJpbmF0aW9uLCB3aGljaCBtdXN0IGZhbGwgaW50byB0aGUgZmxlZXQncyBhbGxvd2VkIHJhbmdlcy5cbiAqXG4gKiBGbGVldHMgd2l0aCBjdXN0b20gZ2FtZSBidWlsZHMgbXVzdCBoYXZlIHBlcm1pc3Npb25zIGV4cGxpY2l0bHkgc2V0LlxuICogRm9yIFJlYWx0aW1lIFNlcnZlcnMgZmxlZXRzLCBHYW1lTGlmdCBhdXRvbWF0aWNhbGx5IG9wZW5zIHR3byBwb3J0IHJhbmdlcywgb25lIGZvciBUQ1AgbWVzc2FnaW5nIGFuZCBvbmUgZm9yIFVEUC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJbmdyZXNzUnVsZSB7XG4gIC8qKlxuICAgICAqIFRoZSBwb3J0IHJhbmdlIHVzZWQgZm9yIGluZ3Jlc3MgdHJhZmZpY1xuICAgICAqL1xuICByZWFkb25seSBwb3J0OiBQb3J0O1xuXG4gIC8qKlxuICAgKiBBIHJhbmdlIG9mIGFsbG93ZWQgSVAgYWRkcmVzc2VzIC5cbiAgICovXG4gIHJlYWRvbmx5IHNvdXJjZTogSVBlZXI7XG59Il19