"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchmakingConfigurationBase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const cdk = require("aws-cdk-lib");
/**
 * Base class for new and imported GameLift Matchmaking configuration.
 */
class MatchmakingConfigurationBase extends cdk.Resource {
    /**
     * Import an existing matchmaking configuration from its attributes.
     */
    static fromMatchmakingConfigurationAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_gamelift_alpha_MatchmakingConfigurationAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromMatchmakingConfigurationAttributes);
            }
            throw error;
        }
        if (!attrs.matchmakingConfigurationName && !attrs.matchmakingConfigurationArn) {
            throw new Error('Either matchmakingConfigurationName or matchmakingConfigurationArn must be provided in MatchmakingConfigurationAttributes');
        }
        const matchmakingConfigurationName = attrs.matchmakingConfigurationName ??
            cdk.Stack.of(scope).splitArn(attrs.matchmakingConfigurationArn, cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
        if (!matchmakingConfigurationName) {
            throw new Error(`No matchmaking configuration name found in ARN: '${attrs.matchmakingConfigurationArn}'`);
        }
        const matchmakingConfigurationArn = attrs.matchmakingConfigurationArn ?? cdk.Stack.of(scope).formatArn({
            service: 'gamelift',
            resource: 'matchmakingconfiguration',
            resourceName: attrs.matchmakingConfigurationName,
            arnFormat: cdk.ArnFormat.SLASH_RESOURCE_NAME,
        });
        class Import extends MatchmakingConfigurationBase {
            constructor(s, i) {
                super(s, i, {
                    environmentFromArn: matchmakingConfigurationArn,
                });
                this.matchmakingConfigurationName = matchmakingConfigurationName;
                this.matchmakingConfigurationArn = matchmakingConfigurationArn;
                this.notificationTarget = attrs.notificationTarget;
            }
        }
        return new Import(scope, id);
    }
    metric(metricName, props) {
        return new cloudwatch.Metric({
            namespace: 'AWS/GameLift',
            metricName: metricName,
            dimensionsMap: {
                MatchmakingConfigurationName: this.matchmakingConfigurationName,
            },
            ...props,
        }).attachTo(this);
    }
    metricCurrentTickets(props) {
        return this.metric('CurrentTickets', props);
    }
    metricMatchesAccepted(props) {
        return this.metric('MatchesAccepted', props);
    }
    metricMatchesCreated(props) {
        return this.metric('MatchesCreated', props);
    }
    metricMatchesPlaced(props) {
        return this.metric('MatchesPlaced', props);
    }
    metricMatchesRejected(props) {
        return this.metric('MatchesRejected', props);
    }
    metricPlayersStarted(props) {
        return this.metric('PlayersStarted', props);
    }
    metricTimeToMatch(props) {
        return this.metric('TimeToMatch', props);
    }
}
exports.MatchmakingConfigurationBase = MatchmakingConfigurationBase;
_a = JSII_RTTI_SYMBOL_1;
MatchmakingConfigurationBase[_a] = { fqn: "@aws-cdk/aws-gamelift-alpha.MatchmakingConfigurationBase", version: "2.65.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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