"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuleSetContent = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
/**
 * The rule set determines the two key elements of a match: your game's team structure and size, and how to group players together for the best possible match.
 *
 * For example, a rule set might describe a match like this:
 * - Create a match with two teams of five players each, one team is the defenders and the other team the invaders.
 * - A team can have novice and experienced players, but the average skill of the two teams must be within 10 points of each other.
 * - If no match is made after 30 seconds, gradually relax the skill requirements.
 */
class RuleSetContent {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_gamelift_alpha_RuleSetContentProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RuleSetContent);
            }
            throw error;
        }
        this.content = props.content || {};
    }
    /**
     * Matchmaking ruleSet body from a file
     * @returns `RuleSetContentBase` based on JSON file content.
     * @param path The path to the ruleSet body file
     */
    static fromJsonFile(path) {
        if (!fs.existsSync(path)) {
            throw new Error(`RuleSet path does not exist, please verify it, actual ${path}`);
        }
        if (!fs.lstatSync(path).isFile()) {
            throw new Error(`RuleSet path is not link to a single file, please verify your path, actual ${path}`);
        }
        const file = fs.readFileSync(path);
        return this.fromInline(file.toString());
    }
    /**
     * Inline body for Matchmaking ruleSet
     * @returns `RuleSetContent` with inline code.
     * @param body The actual ruleSet body (maximum 65535 characters)
     */
    static fromInline(body) {
        if (body && body.length > 65535) {
            throw new Error(`RuleSet body cannot exceed 65535 characters, actual ${body.length}`);
        }
        try {
            return new RuleSetContent({
                content: JSON.parse(body),
            });
        }
        catch (err) {
            throw new Error('RuleSet body has an invalid Json format');
        }
    }
    /**
      * Called when the matchmaking ruleSet is initialized to allow this object to bind
      * to the stack and add resources.
      *
      * @param _scope The binding scope.
      */
    bind(_scope) {
        return {
            ruleSetBody: JSON.stringify(this.content),
        };
    }
}
exports.RuleSetContent = RuleSetContent;
_a = JSII_RTTI_SYMBOL_1;
RuleSetContent[_a] = { fqn: "@aws-cdk/aws-gamelift-alpha.RuleSetContent", version: "2.65.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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