"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchmakingRuleSet = exports.MatchmakingRuleSetBase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const cdk = require("aws-cdk-lib");
const aws_gamelift_1 = require("aws-cdk-lib/aws-gamelift");
/**
 * Base class for new and imported GameLift matchmaking ruleSet.
 */
class MatchmakingRuleSetBase extends cdk.Resource {
    metric(metricName, props) {
        return new cloudwatch.Metric({
            namespace: 'AWS/GameLift',
            metricName: metricName,
            dimensionsMap: {
                MatchmakingRuleSetName: this.matchmakingRuleSetName,
            },
            ...props,
        }).attachTo(this);
    }
    metricRuleEvaluationsPassed(props) {
        return this.metric('RuleEvaluationsPassed', props);
    }
    metricRuleEvaluationsFailed(props) {
        return this.metric('RuleEvaluationsFailed', props);
    }
}
exports.MatchmakingRuleSetBase = MatchmakingRuleSetBase;
_a = JSII_RTTI_SYMBOL_1;
MatchmakingRuleSetBase[_a] = { fqn: "@aws-cdk/aws-gamelift-alpha.MatchmakingRuleSetBase", version: "2.65.0-alpha.0" };
/**
 * Creates a new rule set for FlexMatch matchmaking.
 *
 * The rule set determines the two key elements of a match: your game's team structure and size, and how to group players together for the best possible match.
 *
 * For example, a rule set might describe a match like this:
 *  - Create a match with two teams of five players each, one team is the defenders and the other team the invaders.
 *  - A team can have novice and experienced players, but the average skill of the two teams must be within 10 points of each other.
 *  - If no match is made after 30 seconds, gradually relax the skill requirements.
 *
 * Rule sets must be defined in the same Region as the matchmaking configuration they are used with.
 *
 * @see https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html
 *
 * @resource AWS::GameLift::MatchmakingRuleSet
 */
class MatchmakingRuleSet extends MatchmakingRuleSetBase {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.matchmakingRuleSetName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_gamelift_alpha_MatchmakingRuleSetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, MatchmakingRuleSet);
            }
            throw error;
        }
        if (!cdk.Token.isUnresolved(props.matchmakingRuleSetName)) {
            if (props.matchmakingRuleSetName.length > 128) {
                throw new Error(`RuleSet name can not be longer than 128 characters but has ${props.matchmakingRuleSetName.length} characters.`);
            }
            if (!/^[a-zA-Z0-9-\.]+$/.test(props.matchmakingRuleSetName)) {
                throw new Error(`RuleSet name ${props.matchmakingRuleSetName} can contain only letters, numbers, hyphens, back slash or dot with no spaces.`);
            }
        }
        const content = props.content.bind(this);
        const resource = new aws_gamelift_1.CfnMatchmakingRuleSet(this, 'Resource', {
            name: props.matchmakingRuleSetName,
            ruleSetBody: content.ruleSetBody,
        });
        this.matchmakingRuleSetName = this.getResourceNameAttribute(resource.ref);
        this.matchmakingRuleSetArn = this.getResourceArnAttribute(resource.attrArn, {
            service: 'gamelift',
            resource: 'matchmakingruleset',
            resourceName: this.physicalName,
            arnFormat: cdk.ArnFormat.SLASH_RESOURCE_NAME,
        });
    }
    /**
       * Import a ruleSet into CDK using its name
       */
    static fromMatchmakingRuleSetName(scope, id, matchmakingRuleSetName) {
        return this.fromMatchmakingRuleSetAttributes(scope, id, { matchmakingRuleSetName });
    }
    /**
       * Import a ruleSet into CDK using its ARN
       */
    static fromMatchmakingRuleSetArn(scope, id, matchmakingRuleSetArn) {
        return this.fromMatchmakingRuleSetAttributes(scope, id, { matchmakingRuleSetArn });
    }
    /**
     * Import an existing matchmaking ruleSet from its attributes.
     */
    static fromMatchmakingRuleSetAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_gamelift_alpha_MatchmakingRuleSetAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromMatchmakingRuleSetAttributes);
            }
            throw error;
        }
        if (!attrs.matchmakingRuleSetName && !attrs.matchmakingRuleSetArn) {
            throw new Error('Either matchmakingRuleSetName or matchmakingRuleSetArn must be provided in MatchmakingRuleSetAttributes');
        }
        const matchmakingRuleSetName = attrs.matchmakingRuleSetName ??
            cdk.Stack.of(scope).splitArn(attrs.matchmakingRuleSetArn, cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
        if (!matchmakingRuleSetName) {
            throw new Error(`No matchmaking ruleSet identifier found in ARN: '${attrs.matchmakingRuleSetArn}'`);
        }
        const matchmakingRuleSetArn = attrs.matchmakingRuleSetArn ?? cdk.Stack.of(scope).formatArn({
            service: 'gamelift',
            resource: 'matchmakingruleset',
            resourceName: attrs.matchmakingRuleSetName,
            arnFormat: cdk.ArnFormat.SLASH_RESOURCE_NAME,
        });
        class Import extends MatchmakingRuleSetBase {
            constructor(s, i) {
                super(s, i, {
                    environmentFromArn: matchmakingRuleSetArn,
                });
                this.matchmakingRuleSetName = matchmakingRuleSetName;
                this.matchmakingRuleSetArn = matchmakingRuleSetArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.MatchmakingRuleSet = MatchmakingRuleSet;
_b = JSII_RTTI_SYMBOL_1;
MatchmakingRuleSet[_b] = { fqn: "@aws-cdk/aws-gamelift-alpha.MatchmakingRuleSet", version: "2.65.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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