import * as sns from 'aws-cdk-lib/aws-sns';
import { Construct } from 'constructs';
import { MatchmakingConfigurationProps, MatchmakingConfigurationBase, IMatchmakingConfiguration } from './matchmaking-configuration';
/**
 * Properties for a new standalone matchmaking configuration
 */
export interface StandaloneMatchmakingConfigurationProps extends MatchmakingConfigurationProps {
}
/**
 * A FlexMatch matchmaker process does the work of building a game match.
 * It manages the pool of matchmaking requests received, forms teams for a match, processes and selects players to find the best possible player groups, and initiates the process of placing and starting a game session for the match.
 * This topic describes the key aspects of a matchmaker and how to configure one customized for your game.
 *
 * @see https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html
 *
 * @resource AWS::GameLift::MatchmakingConfiguration
 */
export declare class StandaloneMatchmakingConfiguration extends MatchmakingConfigurationBase {
    /**
       * Import an existing matchmaking configuration from its name.
       */
    static fromStandaloneMatchmakingConfigurationName(scope: Construct, id: string, matchmakingConfigurationName: string): IMatchmakingConfiguration;
    /**
       * Import an existing matchmaking configuration from its ARN.
       */
    static fromStandaloneMatchmakingConfigurationArn(scope: Construct, id: string, matchmakingConfigurationArn: string): IMatchmakingConfiguration;
    /**
     * The Identifier of the matchmaking configuration.
     */
    readonly matchmakingConfigurationName: string;
    /**
     * The ARN of the matchmaking configuration.
     */
    readonly matchmakingConfigurationArn: string;
    /**
     * The notification target for matchmaking events
     */
    readonly notificationTarget?: sns.ITopic;
    constructor(scope: Construct, id: string, props: StandaloneMatchmakingConfigurationProps);
}
