# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Any, Dict, List


class DataResultValue(TeaModel):
    def __init__(
        self,
        sql_id: str = None,
        instance_id: str = None,
        count: int = None,
    ):
        # The SQL ID.
        self.sql_id = sql_id
        # The instance ID.
        self.instance_id = instance_id
        # The number of failed executions.
        self.count = count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sql_id is not None:
            result['sqlId'] = self.sql_id
        if self.instance_id is not None:
            result['instanceId'] = self.instance_id
        if self.count is not None:
            result['count'] = self.count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('sqlId') is not None:
            self.sql_id = m.get('sqlId')
        if m.get('instanceId') is not None:
            self.instance_id = m.get('instanceId')
        if m.get('count') is not None:
            self.count = m.get('count')
        return self


class DataSessionStatClientStatsValue(TeaModel):
    def __init__(
        self,
        active_count: int = None,
        total_count: int = None,
    ):
        # The number of clients whose IP addresses are active.
        self.active_count = active_count
        # The total number of IP addresses of clients.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_count is not None:
            result['ActiveCount'] = self.active_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveCount') is not None:
            self.active_count = m.get('ActiveCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DataSessionStatDbStatsValue(TeaModel):
    def __init__(
        self,
        active_count: int = None,
        total_count: int = None,
    ):
        # The number of active namespaces.
        self.active_count = active_count
        # The total number of namespaces.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_count is not None:
            result['ActiveCount'] = self.active_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveCount') is not None:
            self.active_count = m.get('ActiveCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DataValue(TeaModel):
    def __init__(
        self,
        timestamp: str = None,
        value: Any = None,
    ):
        # The timestamp. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp
        # The value of the metric.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddHDMInstanceRequest(TeaModel):
    def __init__(
        self,
        engine: str = None,
        flush_account: str = None,
        instance_alias: str = None,
        instance_area: str = None,
        instance_id: str = None,
        ip: str = None,
        network_type: str = None,
        password: str = None,
        port: str = None,
        region: str = None,
        username: str = None,
        vpc_id: str = None,
        context: str = None,
    ):
        # The database engine. Valid values:
        # 
        # *   **MySQL**\
        # *   **PostgreSQL**\
        # *   **SQLServer**\
        # *   **PolarDBMySQL**\
        # *   **PolarDBPostgreSQL**\
        # *   **Redis**\
        # *   **MongoDB**\
        # *   **PolarDBOracle**\
        # *   **PolarDBX**\
        self.engine = engine
        # The reserved parameter.
        self.flush_account = flush_account
        # The name of the instance.
        self.instance_alias = instance_alias
        # The type of the instance on which the database is deployed. Valid values:
        # 
        # *   **RDS**: an Alibaba Cloud database instance.
        # *   **ECS**: an Elastic Compute Service (ECS) instance on which a self-managed database is deployed.
        # *   **IDC**: a self-managed database instance that is not deployed on Alibaba Cloud.
        # 
        # >  IDC refers to your data center.
        self.instance_area = instance_area
        # The instance ID.
        self.instance_id = instance_id
        # The endpoint that is used to access the instance over internal networks.
        self.ip = ip
        # The network type of the instance.
        self.network_type = network_type
        # The password for the username.
        self.password = password
        # The port that is used to access the instance over internal networks.
        self.port = port
        # The ID of the region in which the instance resides.
        self.region = region
        # The username that is used to log on to the database.
        self.username = username
        # The virtual private cloud (VPC) ID.
        self.vpc_id = vpc_id
        # The reserved parameter.
        self.context = context

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.flush_account is not None:
            result['FlushAccount'] = self.flush_account
        if self.instance_alias is not None:
            result['InstanceAlias'] = self.instance_alias
        if self.instance_area is not None:
            result['InstanceArea'] = self.instance_area
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.password is not None:
            result['Password'] = self.password
        if self.port is not None:
            result['Port'] = self.port
        if self.region is not None:
            result['Region'] = self.region
        if self.username is not None:
            result['Username'] = self.username
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.context is not None:
            result['__context'] = self.context
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('FlushAccount') is not None:
            self.flush_account = m.get('FlushAccount')
        if m.get('InstanceAlias') is not None:
            self.instance_alias = m.get('InstanceAlias')
        if m.get('InstanceArea') is not None:
            self.instance_area = m.get('InstanceArea')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('__context') is not None:
            self.context = m.get('__context')
        return self


class AddHDMInstanceResponseBodyData(TeaModel):
    def __init__(
        self,
        caller_uid: str = None,
        code: int = None,
        error: str = None,
        instance_id: str = None,
        ip: str = None,
        owner_id: str = None,
        port: int = None,
        role: str = None,
        tenant_id: str = None,
        token: str = None,
        uuid: str = None,
        vpc_id: str = None,
    ):
        # The user ID of the caller.
        self.caller_uid = caller_uid
        # The HTTP status code returned.
        self.code = code
        # The error message returned if the request failed.
        self.error = error
        # The instance ID.
        self.instance_id = instance_id
        # The endpoint of the instance.
        self.ip = ip
        # The ID of the instance owner.
        self.owner_id = owner_id
        # The port number of the instance that you want to access.
        self.port = port
        # The role of the current API caller.
        self.role = role
        # The tenant ID.
        self.tenant_id = tenant_id
        # The client token that is used to ensure the idempotence of the request.
        self.token = token
        # The unique identifier of the instance.
        self.uuid = uuid
        # The VPC ID.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caller_uid is not None:
            result['CallerUid'] = self.caller_uid
        if self.code is not None:
            result['Code'] = self.code
        if self.error is not None:
            result['Error'] = self.error
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port is not None:
            result['Port'] = self.port
        if self.role is not None:
            result['Role'] = self.role
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.token is not None:
            result['Token'] = self.token
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallerUid') is not None:
            self.caller_uid = m.get('CallerUid')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Error') is not None:
            self.error = m.get('Error')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class AddHDMInstanceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AddHDMInstanceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
        synchro: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information, including the error codes and the number of entries that are returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success
        # The reserved parameter.
        self.synchro = synchro

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.synchro is not None:
            result['Synchro'] = self.synchro
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddHDMInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Synchro') is not None:
            self.synchro = m.get('Synchro')
        return self


class AddHDMInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddHDMInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddHDMInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAdamBenchTaskRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        dst_instance_id: str = None,
        dst_super_account: str = None,
        dst_super_password: str = None,
        rate: int = None,
        request_duration: int = None,
        request_start_time: int = None,
        src_engine: str = None,
        src_engine_version: str = None,
        src_max_qps: float = None,
        src_mean_qps: float = None,
        src_sql_oss_addr: str = None,
    ):
        # The description of the stress testing task.
        self.description = description
        # The ID of the destination instance. The instance must be an ApsaraDB RDS for MySQL instance or a PolarDB for MySQL instance. You can call the [GetInstanceInspections](~~202857~~) operation to query the ID.
        self.dst_instance_id = dst_instance_id
        # The name of the privileged account for the destination instance.
        self.dst_super_account = dst_super_account
        # The password of the privileged account for the destination instance.
        self.dst_super_password = dst_super_password
        # The rate at which the traffic captured from the source database instance is replayed on the destination database instance. Valid values: 1 to 30. Default value: 1.
        self.rate = rate
        # The duration of the stress testing task for which the traffic is captured from the source instance. Unit: milliseconds.
        self.request_duration = request_duration
        # The start time of the stress testing task. Specify the time in the UNIX timestamp format. Unit: milliseconds.
        self.request_start_time = request_start_time
        # The database engine that the source database instance runs.
        self.src_engine = src_engine
        # The version of the database engine that the source database instance runs.
        self.src_engine_version = src_engine_version
        # The maximum number of queries per second (QPS) within the time period during which traffic on the source database instance is captured. The value must be accurate to two decimal places.
        self.src_max_qps = src_max_qps
        # The average QPS within the time period in which traffic on the source database instance is captured. The value must be accurate to two decimal places.
        self.src_mean_qps = src_mean_qps
        # The URL of the Object Storage Service (OSS) folder in which the archived objects for SQL statements that run on the source database instance are stored. You can obtain the URL after you upload the archived files to OSS.
        self.src_sql_oss_addr = src_sql_oss_addr

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dst_instance_id is not None:
            result['DstInstanceId'] = self.dst_instance_id
        if self.dst_super_account is not None:
            result['DstSuperAccount'] = self.dst_super_account
        if self.dst_super_password is not None:
            result['DstSuperPassword'] = self.dst_super_password
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.request_duration is not None:
            result['RequestDuration'] = self.request_duration
        if self.request_start_time is not None:
            result['RequestStartTime'] = self.request_start_time
        if self.src_engine is not None:
            result['SrcEngine'] = self.src_engine
        if self.src_engine_version is not None:
            result['SrcEngineVersion'] = self.src_engine_version
        if self.src_max_qps is not None:
            result['SrcMaxQps'] = self.src_max_qps
        if self.src_mean_qps is not None:
            result['SrcMeanQps'] = self.src_mean_qps
        if self.src_sql_oss_addr is not None:
            result['SrcSqlOssAddr'] = self.src_sql_oss_addr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DstInstanceId') is not None:
            self.dst_instance_id = m.get('DstInstanceId')
        if m.get('DstSuperAccount') is not None:
            self.dst_super_account = m.get('DstSuperAccount')
        if m.get('DstSuperPassword') is not None:
            self.dst_super_password = m.get('DstSuperPassword')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('RequestDuration') is not None:
            self.request_duration = m.get('RequestDuration')
        if m.get('RequestStartTime') is not None:
            self.request_start_time = m.get('RequestStartTime')
        if m.get('SrcEngine') is not None:
            self.src_engine = m.get('SrcEngine')
        if m.get('SrcEngineVersion') is not None:
            self.src_engine_version = m.get('SrcEngineVersion')
        if m.get('SrcMaxQps') is not None:
            self.src_max_qps = m.get('SrcMaxQps')
        if m.get('SrcMeanQps') is not None:
            self.src_mean_qps = m.get('SrcMeanQps')
        if m.get('SrcSqlOssAddr') is not None:
            self.src_sql_oss_addr = m.get('SrcSqlOssAddr')
        return self


class CreateAdamBenchTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information, including the error codes and the number of entries that are returned.
        self.data = data
        # The returned message.
        # 
        # > If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateAdamBenchTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAdamBenchTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAdamBenchTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCacheAnalysisJobRequest(TeaModel):
    def __init__(
        self,
        backup_set_id: str = None,
        instance_id: str = None,
        node_id: str = None,
        separators: str = None,
    ):
        # The ID of the backup file. You can call the [DescribeBackups](~~61081~~) operation to query the ID.
        # 
        # *   If you need to specify multiple backup file IDs, separate them with commas (,). For example, you can set this parameter to `12345,67890`.
        # *   If you do not specify this parameter, the system automatically backs up the task and performs cache analysis on the backup file.
        self.backup_set_id = backup_set_id
        # The ID of the ApsaraDB for Redis instance.
        self.instance_id = instance_id
        # The ID of the data node on the instance. You can specify this parameter to query the monitoring information about the specified node.
        # 
        # >  If you specify the BackupSetId parameter, the system ignores the NodeId parameter. You can call the [DescribeLogicInstanceTopology](~~94665~~) operation to query the node ID.
        self.node_id = node_id
        # The delimiters used to identify the prefixes of keys. You do not need to specify this parameter if one or more of the following default delimiters are used: `: ; , _ - + @ = | #`
        self.separators = separators

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_set_id is not None:
            result['BackupSetId'] = self.backup_set_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.separators is not None:
            result['Separators'] = self.separators
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupSetId') is not None:
            self.backup_set_id = m.get('BackupSetId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Separators') is not None:
            self.separators = m.get('Separators')
        return self


class CreateCacheAnalysisJobResponseBodyDataBigKeysKeyInfo(TeaModel):
    def __init__(
        self,
        bytes: int = None,
        count: int = None,
        db: int = None,
        encoding: str = None,
        expiration_time_millis: int = None,
        key: str = None,
        node_id: str = None,
        type: str = None,
    ):
        # The number of bytes that are occupied by the key.
        self.bytes = bytes
        # The number of elements in the key.
        self.count = count
        # The name of the database.
        self.db = db
        # The data type of the key.
        self.encoding = encoding
        # The expiration period of the key. Unit: milliseconds. A value of 0 indicates that the key does not expire.
        self.expiration_time_millis = expiration_time_millis
        # The name of the key.
        self.key = key
        # The ID of the data node on the instance.
        self.node_id = node_id
        # The data type of the ApsaraDB for Redis instance.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bytes is not None:
            result['Bytes'] = self.bytes
        if self.count is not None:
            result['Count'] = self.count
        if self.db is not None:
            result['Db'] = self.db
        if self.encoding is not None:
            result['Encoding'] = self.encoding
        if self.expiration_time_millis is not None:
            result['ExpirationTimeMillis'] = self.expiration_time_millis
        if self.key is not None:
            result['Key'] = self.key
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bytes') is not None:
            self.bytes = m.get('Bytes')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('Encoding') is not None:
            self.encoding = m.get('Encoding')
        if m.get('ExpirationTimeMillis') is not None:
            self.expiration_time_millis = m.get('ExpirationTimeMillis')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateCacheAnalysisJobResponseBodyDataBigKeys(TeaModel):
    def __init__(
        self,
        key_info: List[CreateCacheAnalysisJobResponseBodyDataBigKeysKeyInfo] = None,
    ):
        self.key_info = key_info

    def validate(self):
        if self.key_info:
            for k in self.key_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['KeyInfo'] = []
        if self.key_info is not None:
            for k in self.key_info:
                result['KeyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.key_info = []
        if m.get('KeyInfo') is not None:
            for k in m.get('KeyInfo'):
                temp_model = CreateCacheAnalysisJobResponseBodyDataBigKeysKeyInfo()
                self.key_info.append(temp_model.from_map(k))
        return self


class CreateCacheAnalysisJobResponseBodyData(TeaModel):
    def __init__(
        self,
        big_keys: CreateCacheAnalysisJobResponseBodyDataBigKeys = None,
        instance_id: str = None,
        job_id: str = None,
        message: str = None,
        node_id: str = None,
        task_state: str = None,
    ):
        # The number of elements in the key.
        self.big_keys = big_keys
        # The instance ID.
        self.instance_id = instance_id
        # The ID of the cache analysis task.
        # 
        # >  This parameter can be used to query a specific cache analysis task. When you call the CreateCacheAnalysisJob operation, it takes some time to create a cache analysis task. As a result, the analysis results cannot be immediately returned. You can call the [DescribeCacheAnalysisJob](~~180983~~) operation to query the analysis results of the specified cache analysis task.
        self.job_id = job_id
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The ID of the data node on the instance.
        self.node_id = node_id
        # The state of the cache analysis task. Valid values:
        # 
        # *   **BACKUP**: The data is being backed up.
        # *   **ANALYZING**: The data is being analyzed.
        # *   **FINISHED**: The data is analyzed.
        # *   **FAILED**: An error occurred.
        self.task_state = task_state

    def validate(self):
        if self.big_keys:
            self.big_keys.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.big_keys is not None:
            result['BigKeys'] = self.big_keys.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BigKeys') is not None:
            temp_model = CreateCacheAnalysisJobResponseBodyDataBigKeys()
            self.big_keys = temp_model.from_map(m['BigKeys'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        return self


class CreateCacheAnalysisJobResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateCacheAnalysisJobResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateCacheAnalysisJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateCacheAnalysisJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCacheAnalysisJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCacheAnalysisJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCloudBenchTasksRequest(TeaModel):
    def __init__(
        self,
        amount: str = None,
        backup_id: str = None,
        backup_time: str = None,
        client_type: str = None,
        description: str = None,
        dst_connection_string: str = None,
        dst_instance_id: str = None,
        dst_port: str = None,
        dst_super_account: str = None,
        dst_super_password: str = None,
        dst_type: str = None,
        dts_job_class: str = None,
        dts_job_id: str = None,
        end_state: str = None,
        gateway_vpc_id: str = None,
        gateway_vpc_ip: str = None,
        rate: str = None,
        request_duration: str = None,
        request_end_time: str = None,
        request_start_time: str = None,
        smart_pressure_time: str = None,
        src_instance_id: str = None,
        src_public_ip: str = None,
        src_super_account: str = None,
        src_super_password: str = None,
        task_type: str = None,
        work_dir: str = None,
    ):
        # The total number of stress testing tasks that you want to create. Valid values: **0** to **30**. Default value: **1**.
        self.amount = amount
        # The ID of the backup set. You can call the [DescribeBackups](~~26273~~) operation to query the ID of the backup set.
        self.backup_id = backup_id
        # The time when the backup starts. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.backup_time = backup_time
        # The type of the stress testing client. Valid values:
        # 
        # *   **ECS**: indicates that you must create the [DBGateway](~~64905~~).
        # *   **DAS_ECS**: indicates that DAS automatically purchases and deploys an Elastic Compute Service (ECS) instance for stress testing.
        self.client_type = client_type
        # The description of the stress testing task.
        self.description = description
        # The endpoint of the destination instance. The specified endpoint must be the endpoint of an ApsaraDB RDS for MySQL instance or a PolarDB for MySQL instance.
        # 
        # >  This parameter takes effect only if you set **DstType** to **ConnectionString**.
        self.dst_connection_string = dst_connection_string
        # The ID of the destination instance. The instance must be an ApsaraDB RDS for MySQL instance or a PolarDB for MySQL instance. You can call the [GetInstanceInspections](~~202857~~) operation to query the ID.
        # 
        # >  This parameter must be specified if you set **DstType** to **Instance**.
        self.dst_instance_id = dst_instance_id
        # The port number of the instance that you want to access.
        # 
        # >  This parameter takes effect only if you set **DstType** to **ConnectionString**.
        self.dst_port = dst_port
        # The name of the privileged account for the destination instance.
        self.dst_super_account = dst_super_account
        # The password of the privileged account for the destination instance.
        self.dst_super_password = dst_super_password
        # The type of the identifier that is used to indicate the destination instance. Valid values:
        # 
        # *   **Instance**: the instance ID. This is the default value.
        # *   **ConnectionString**: the endpoint of the instance.
        self.dst_type = dst_type
        # The specification of the Data Transmission Service (DTS) migration task. You can call the [DescribeCloudbenchTask](~~230669~~) operation to query the specification.
        # 
        # >  You must migrate the basic data in the source instance to the destination instance before you start a stress testing task. When you create a DTS migration task, you must specify this parameter.
        self.dts_job_class = dts_job_class
        # The ID of the DTS migration task. You can call the [ConfigureDtsJob](~~208399~~) operation to query the ID.
        # 
        # >  After a DTS migration task is created in the DTS console, you must specify this parameter.
        self.dts_job_id = dts_job_id
        # The state that specifies the last operation that is performed for the stress testing task. Valid values:
        # 
        # *   **WAIT_TARGET**: prepares the destination instance
        # *   **WAIT_DBGATEWAY**: prepares the DBGateway
        # *   **WAIT_SQL**: prepares the full SQL statistics
        # *   **WAIT_LOGIC**: prepares to replay the traffic
        # 
        # >  When the state of a stress testing task changes to the state that is specified by the EndState parameter, the stress testing task becomes completed.
        self.end_state = end_state
        # The ID of the virtual private cloud (VPC) in which the database gateway (DBGateway) is deployed.
        # 
        # >  This parameter must be specified if you set **ClientType** to **ECS**.
        self.gateway_vpc_id = gateway_vpc_id
        # The IP address or domain name of the DBGateway.
        # 
        # >  This parameter must be specified if you set **ClientType** to **ECS**.
        self.gateway_vpc_ip = gateway_vpc_ip
        # The rate at which the traffic captured from the source instance is replayed on the destination instance. The value must be a positive integer. Valid values: **1** to **30**. Default value: **1**.
        self.rate = rate
        # The duration of the stress testing task for which the traffic is captured from the source instance. Unit: milliseconds.
        self.request_duration = request_duration
        # The time when the stress testing task ends. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.request_end_time = request_end_time
        # The time when the stress testing task starts. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.request_start_time = request_start_time
        # The duration within which the traffic generation stressing test takes effect. Unit: milliseconds.
        # 
        # >  This parameter must be specified if you set **TaskType** to **smart pressure test**.
        self.smart_pressure_time = smart_pressure_time
        # The ID of the source instance. The instance must be an ApsaraDB RDS for MySQL instance or a PolarDB for MySQL instance. You can call the [GetInstanceInspections](~~202857~~) operation to query the ID.
        # 
        # >  This parameter must be specified if you set **DstType** to **Instance**.
        self.src_instance_id = src_instance_id
        # The reserved parameter.
        self.src_public_ip = src_public_ip
        # The name of the privileged account for the source instance. Set the value to **admin**.
        # 
        # >  This parameter must be specified if you set **DstType** to **Instance**.
        self.src_super_account = src_super_account
        # The password of the privileged account for the source instance.
        # 
        # >  This parameter must be specified if you set **DstType** to **Instance**.
        self.src_super_password = src_super_password
        # The type of the stress testing task. Valid values:
        # 
        # *   **pressure test** (default): A task of this type replays the traffic that is captured from the source instance on the destination instance at the maximum playback rate that is supported by the destination instance.
        # *   **smart pressure test**: A task of this type analyzes the traffic that is captured from the source instance over a short period of time and generates traffic on the destination instance for continuous stress testing. The business model based on which the traffic is generated on the destination instance and the traffic distribution are consistent with those on the source instance. Stress testing tasks of this type can help you reduce the amount of time that is consumed to collect data from the source instance and reduce storage costs and performance overheads.
        self.task_type = task_type
        # The temporary directory generated for stress testing.
        self.work_dir = work_dir

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_time is not None:
            result['BackupTime'] = self.backup_time
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.description is not None:
            result['Description'] = self.description
        if self.dst_connection_string is not None:
            result['DstConnectionString'] = self.dst_connection_string
        if self.dst_instance_id is not None:
            result['DstInstanceId'] = self.dst_instance_id
        if self.dst_port is not None:
            result['DstPort'] = self.dst_port
        if self.dst_super_account is not None:
            result['DstSuperAccount'] = self.dst_super_account
        if self.dst_super_password is not None:
            result['DstSuperPassword'] = self.dst_super_password
        if self.dst_type is not None:
            result['DstType'] = self.dst_type
        if self.dts_job_class is not None:
            result['DtsJobClass'] = self.dts_job_class
        if self.dts_job_id is not None:
            result['DtsJobId'] = self.dts_job_id
        if self.end_state is not None:
            result['EndState'] = self.end_state
        if self.gateway_vpc_id is not None:
            result['GatewayVpcId'] = self.gateway_vpc_id
        if self.gateway_vpc_ip is not None:
            result['GatewayVpcIp'] = self.gateway_vpc_ip
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.request_duration is not None:
            result['RequestDuration'] = self.request_duration
        if self.request_end_time is not None:
            result['RequestEndTime'] = self.request_end_time
        if self.request_start_time is not None:
            result['RequestStartTime'] = self.request_start_time
        if self.smart_pressure_time is not None:
            result['SmartPressureTime'] = self.smart_pressure_time
        if self.src_instance_id is not None:
            result['SrcInstanceId'] = self.src_instance_id
        if self.src_public_ip is not None:
            result['SrcPublicIp'] = self.src_public_ip
        if self.src_super_account is not None:
            result['SrcSuperAccount'] = self.src_super_account
        if self.src_super_password is not None:
            result['SrcSuperPassword'] = self.src_super_password
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.work_dir is not None:
            result['WorkDir'] = self.work_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupTime') is not None:
            self.backup_time = m.get('BackupTime')
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DstConnectionString') is not None:
            self.dst_connection_string = m.get('DstConnectionString')
        if m.get('DstInstanceId') is not None:
            self.dst_instance_id = m.get('DstInstanceId')
        if m.get('DstPort') is not None:
            self.dst_port = m.get('DstPort')
        if m.get('DstSuperAccount') is not None:
            self.dst_super_account = m.get('DstSuperAccount')
        if m.get('DstSuperPassword') is not None:
            self.dst_super_password = m.get('DstSuperPassword')
        if m.get('DstType') is not None:
            self.dst_type = m.get('DstType')
        if m.get('DtsJobClass') is not None:
            self.dts_job_class = m.get('DtsJobClass')
        if m.get('DtsJobId') is not None:
            self.dts_job_id = m.get('DtsJobId')
        if m.get('EndState') is not None:
            self.end_state = m.get('EndState')
        if m.get('GatewayVpcId') is not None:
            self.gateway_vpc_id = m.get('GatewayVpcId')
        if m.get('GatewayVpcIp') is not None:
            self.gateway_vpc_ip = m.get('GatewayVpcIp')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('RequestDuration') is not None:
            self.request_duration = m.get('RequestDuration')
        if m.get('RequestEndTime') is not None:
            self.request_end_time = m.get('RequestEndTime')
        if m.get('RequestStartTime') is not None:
            self.request_start_time = m.get('RequestStartTime')
        if m.get('SmartPressureTime') is not None:
            self.smart_pressure_time = m.get('SmartPressureTime')
        if m.get('SrcInstanceId') is not None:
            self.src_instance_id = m.get('SrcInstanceId')
        if m.get('SrcPublicIp') is not None:
            self.src_public_ip = m.get('SrcPublicIp')
        if m.get('SrcSuperAccount') is not None:
            self.src_super_account = m.get('SrcSuperAccount')
        if m.get('SrcSuperPassword') is not None:
            self.src_super_password = m.get('SrcSuperPassword')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('WorkDir') is not None:
            self.work_dir = m.get('WorkDir')
        return self


class CreateCloudBenchTasksResponseBodyData(TeaModel):
    def __init__(
        self,
        task_ids: List[str] = None,
    ):
        self.task_ids = task_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_ids is not None:
            result['taskIds'] = self.task_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('taskIds') is not None:
            self.task_ids = m.get('taskIds')
        return self


class CreateCloudBenchTasksResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateCloudBenchTasksResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateCloudBenchTasksResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateCloudBenchTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCloudBenchTasksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCloudBenchTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiagnosticReportRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        end_time: str = None,
        start_time: str = None,
    ):
        # The instance ID.
        self.dbinstance_id = dbinstance_id
        # The end of the time range to create the diagnostic report. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The start time must be later than the end time.
        self.end_time = end_time
        # The beginning of the time range to create the diagnostic report. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateDiagnosticReportResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDiagnosticReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDiagnosticReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDiagnosticReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateKillInstanceSessionTaskRequest(TeaModel):
    def __init__(
        self,
        db_user: str = None,
        db_user_password: str = None,
        ignored_users: str = None,
        instance_id: str = None,
        kill_all_sessions: bool = None,
        node_id: str = None,
        session_ids: str = None,
    ):
        # The database account that has the permissions to terminate sessions.
        self.db_user = db_user
        # The password of the database account.
        self.db_user_password = db_user_password
        # The account whose sessions do not need to be terminated.
        # 
        # >  Set this parameter to a JSON array. Separate database accounts with commas (,). Example: \[\"Database account 1\",\"Database account 2\"].
        self.ignored_users = ignored_users
        # The instance ID.
        self.instance_id = instance_id
        # Specifies whether to terminate all sessions.
        # 
        # *   **true**\
        # *   **false**\
        # 
        # >  If you set this parameter to **true**, sessions of the accounts that are specified by **IgnoredUsers**, sessions of internal O\&M accounts of Alibaba Cloud, and **Binlog Dump** sessions are not terminated.
        self.kill_all_sessions = kill_all_sessions
        # The node ID.
        # 
        # >  This parameter must be specified if the database instance is a PolarDB for MySQL cluster. If you do not specify a node ID and set **KillAllSessions** to **true**, the system traverses all nodes in the PolarDB for MySQL cluster and terminates the active sessions on each node.
        self.node_id = node_id
        # The IDs of sessions that need to be terminated.
        # 
        # >  Set this parameter to a JSON array. Separate session IDs with commas (,). Example: \[\"Session ID1\",\"Session ID2\"]. If **KillAllSessions** is set to **true**, this parameter does not take effect.
        self.session_ids = session_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_user is not None:
            result['DbUser'] = self.db_user
        if self.db_user_password is not None:
            result['DbUserPassword'] = self.db_user_password
        if self.ignored_users is not None:
            result['IgnoredUsers'] = self.ignored_users
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.kill_all_sessions is not None:
            result['KillAllSessions'] = self.kill_all_sessions
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.session_ids is not None:
            result['SessionIds'] = self.session_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DbUser') is not None:
            self.db_user = m.get('DbUser')
        if m.get('DbUserPassword') is not None:
            self.db_user_password = m.get('DbUserPassword')
        if m.get('IgnoredUsers') is not None:
            self.ignored_users = m.get('IgnoredUsers')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('KillAllSessions') is not None:
            self.kill_all_sessions = m.get('KillAllSessions')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('SessionIds') is not None:
            self.session_ids = m.get('SessionIds')
        return self


class CreateKillInstanceSessionTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The ID of the task that terminated the sessions.
        # 
        # >  If the sessions of a PolarDB for MySQL cluster were terminated, **NodeId** is left empty, and **KillAllSessions** is set to **true**, the task IDs are returned based on the number of nodes. Example: \["f77d535b45405bd462b21caa3ee8\*\*\*\*", "e93ab549abb081eb5dcd5396a29b\*\*\*\*"].
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateKillInstanceSessionTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateKillInstanceSessionTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateKillInstanceSessionTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateKillInstanceSessionTaskWithMaintainUserRequest(TeaModel):
    def __init__(
        self,
        ignored_users: str = None,
        instance_id: str = None,
        kill_all_sessions: bool = None,
        node_id: str = None,
        session_ids: str = None,
    ):
        self.ignored_users = ignored_users
        self.instance_id = instance_id
        self.kill_all_sessions = kill_all_sessions
        self.node_id = node_id
        self.session_ids = session_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignored_users is not None:
            result['IgnoredUsers'] = self.ignored_users
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.kill_all_sessions is not None:
            result['KillAllSessions'] = self.kill_all_sessions
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.session_ids is not None:
            result['SessionIds'] = self.session_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IgnoredUsers') is not None:
            self.ignored_users = m.get('IgnoredUsers')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('KillAllSessions') is not None:
            self.kill_all_sessions = m.get('KillAllSessions')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('SessionIds') is not None:
            self.session_ids = m.get('SessionIds')
        return self


class CreateKillInstanceSessionTaskWithMaintainUserResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateKillInstanceSessionTaskWithMaintainUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateKillInstanceSessionTaskWithMaintainUserResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateKillInstanceSessionTaskWithMaintainUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQueryOptimizeTagRequest(TeaModel):
    def __init__(
        self,
        comments: str = None,
        engine: str = None,
        instance_id: str = None,
        sql_ids: str = None,
        status: int = None,
        tags: str = None,
    ):
        # The remarks.
        # 
        # The remarks can be 1 to 300 characters in length.
        self.comments = comments
        # The database engine. Valid values:
        # 
        # *   **MySQL**: ApsaraDB RDS for MySQL
        # *   **PolarDBMySQL**: PolarDB for MySQL
        # *   **PostgreSQL**: ApsaraDB RDS for PostgreSQL
        self.engine = engine
        # The instance ID.
        self.instance_id = instance_id
        # The SQL template IDs. You can call the [GetQueryOptimizeExecErrorStats](~~405261~~) operation to obtain the SQL template ID. Separate multiple SQL template IDs with commas (,).
        self.sql_ids = sql_ids
        # The status of **Tags**. Valid values:
        # 
        # *   **0**: removes all tags added to the SQL templates that are specified by **SqlIds** and leaves **Tags** empty.
        # *   **1**: adds the tags specified by **Tags** to the SQL templates that are specified by **SqlIds**.
        self.status = status
        # The SQL tags. Separate multiple SQL tags with commas (,). Valid values:
        # 
        # *   **DAS_IMPORTANT**: The SQL template is important.
        # *   **DAS_NOT_IMPORTANT**: The SQL template is unimportant.
        # *   **USER_IGNORE**: The scheduling of the SQL template does not need to be optimized.
        # *   **DAS_IN_PLAN**: The scheduling of the SQL template needs to be optimized.
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comments is not None:
            result['Comments'] = self.comments
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.sql_ids is not None:
            result['SqlIds'] = self.sql_ids
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comments') is not None:
            self.comments = m.get('Comments')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SqlIds') is not None:
            self.sql_ids = m.get('SqlIds')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class CreateQueryOptimizeTagResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # Indicates whether the tags were added to the SQL templates.
        # 
        # *   **true**\
        # *   **false**\
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQueryOptimizeTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateQueryOptimizeTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateQueryOptimizeTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRequestDiagnosisRequest(TeaModel):
    def __init__(
        self,
        database: str = None,
        instance_id: str = None,
        node_id: str = None,
        sql: str = None,
    ):
        # The name of the database.
        self.database = database
        # The instance ID.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  This parameter must be specified for PolarDB for MySQL, PolarDB for PostgreSQL (Compatible with Oracle), and ApsaraDB for MongoDB instances.
        self.node_id = node_id
        # The SQL statement that you want to diagnose.
        self.sql = sql

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.sql is not None:
            result['Sql'] = self.sql
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Sql') is not None:
            self.sql = m.get('Sql')
        return self


class CreateRequestDiagnosisResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The diagnostics ID, which is the unique identifier of the diagnosis. This parameter can be used to query the result of the diagnosis.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateRequestDiagnosisResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRequestDiagnosisResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRequestDiagnosisResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStorageAnalysisTaskRequest(TeaModel):
    def __init__(
        self,
        db_name: str = None,
        instance_id: str = None,
        node_id: str = None,
        table_name: str = None,
    ):
        # The database name. If you specify a database, the operation analyzes the storage usage of the specified database.
        self.db_name = db_name
        # The instance ID.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  This parameter is reserved.
        self.node_id = node_id
        # The table name. If you specify a table in the specified database, the operation analyzes the storage usage of the specified table. If you specify a table, you must also specify the database to which the table belongs by using **DbName**.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class CreateStorageAnalysisTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        create_task_success: bool = None,
        error_message: str = None,
        task_id: str = None,
    ):
        # Indicates whether the task is created. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.create_task_success = create_task_success
        # The error message returned.
        self.error_message = error_message
        # The task ID.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_task_success is not None:
            result['CreateTaskSuccess'] = self.create_task_success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTaskSuccess') is not None:
            self.create_task_success = m.get('CreateTaskSuccess')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateStorageAnalysisTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: CreateStorageAnalysisTaskResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        # 
        # >  If the request is successful, **Successful** is returned. Otherwise, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateStorageAnalysisTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateStorageAnalysisTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateStorageAnalysisTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateStorageAnalysisTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCloudBenchTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        # The ID of the stress testing task. You can call the [DescribeCloudBenchTasks](~~230670~~) operation to query the ID.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteCloudBenchTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The reserved parameter.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCloudBenchTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCloudBenchTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCloudBenchTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStopGatewayRequest(TeaModel):
    def __init__(
        self,
        gateway_id: str = None,
    ):
        # The ID that can uniquely identify the DBGateway. You can obtain the DBGateway ID by calling the [DescribeCloudbenchTask](~~230669~~) operation. The DBGateway ID is the value of the **ClientGatewayId** field in the response.
        self.gateway_id = gateway_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        return self


class DeleteStopGatewayResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The result of the DeleteStopGateway operation. Valid values:
        # 
        # *   **0**: The metadata of the DBGateway is deleted.
        # *   **-1**: A system error occurs.
        # *   **-2**: The DBGateway does not exist.
        # *   **-3**: The DBGateway is not stopped and the metadata cannot be deleted.
        # *   **-4**: The metadata of the DBGateway fails to be deleted.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteStopGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteStopGatewayResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStopGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoScalingConfigRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The instance ID.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeAutoScalingConfigResponseBodyDataBandwidth(TeaModel):
    def __init__(
        self,
        bandwidth_usage_lower_threshold: int = None,
        bandwidth_usage_upper_threshold: int = None,
        downgrade: bool = None,
        observation_window_size: str = None,
        upgrade: bool = None,
    ):
        # The average bandwidth usage threshold that triggers automatic bandwidth downgrade. Unit: %.
        self.bandwidth_usage_lower_threshold = bandwidth_usage_lower_threshold
        # The average bandwidth usage threshold that triggers automatic bandwidth adjustment. Unit: %.
        self.bandwidth_usage_upper_threshold = bandwidth_usage_upper_threshold
        # Indicates whether the automatic bandwidth downgrade feature is enabled. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.downgrade = downgrade
        # The observation window of the automatic bandwidth adjustment feature. The return value consists of a numeric value and a time unit suffix. Valid values of the time unit suffix:
        # 
        # *   **s**: seconds.
        # *   **m**: minutes.
        # *   **h**: hours.
        # *   **d**: days.
        # 
        # >  A value of **5m** indicates 5 minutes.
        self.observation_window_size = observation_window_size
        # Indicates whether the automatic bandwidth adjustment feature is enabled. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.upgrade = upgrade

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_usage_lower_threshold is not None:
            result['BandwidthUsageLowerThreshold'] = self.bandwidth_usage_lower_threshold
        if self.bandwidth_usage_upper_threshold is not None:
            result['BandwidthUsageUpperThreshold'] = self.bandwidth_usage_upper_threshold
        if self.downgrade is not None:
            result['Downgrade'] = self.downgrade
        if self.observation_window_size is not None:
            result['ObservationWindowSize'] = self.observation_window_size
        if self.upgrade is not None:
            result['Upgrade'] = self.upgrade
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BandwidthUsageLowerThreshold') is not None:
            self.bandwidth_usage_lower_threshold = m.get('BandwidthUsageLowerThreshold')
        if m.get('BandwidthUsageUpperThreshold') is not None:
            self.bandwidth_usage_upper_threshold = m.get('BandwidthUsageUpperThreshold')
        if m.get('Downgrade') is not None:
            self.downgrade = m.get('Downgrade')
        if m.get('ObservationWindowSize') is not None:
            self.observation_window_size = m.get('ObservationWindowSize')
        if m.get('Upgrade') is not None:
            self.upgrade = m.get('Upgrade')
        return self


class DescribeAutoScalingConfigResponseBodyDataResource(TeaModel):
    def __init__(
        self,
        cpu_step: int = None,
        cpu_usage_upper_threshold: int = None,
        downgrade_observation_window_size: str = None,
        enable: bool = None,
        upgrade_observation_window_size: str = None,
    ):
        # The scale-out step size of CPU.
        self.cpu_step = cpu_step
        # The average CPU utilization threshold that triggers automatic scale-out of local resources. Unit: %.
        self.cpu_usage_upper_threshold = cpu_usage_upper_threshold
        # The observation window of the automatic scale-in feature for local resources. The return value consists of a numeric value and a time unit suffix. Valid values of the time unit suffix:
        # 
        # *   **s**: seconds.
        # *   **m**: minutes.
        # *   **h**: hours.
        # *   **d**: days.
        # 
        # >  A value of **5m** indicates 5 minutes.
        self.downgrade_observation_window_size = downgrade_observation_window_size
        # Indicates whether the auto scaling feature is enabled for local resources. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.enable = enable
        # The observation window of the automatic scale-out feature for local resources. The return value consists of a numeric value and a time unit suffix. Valid values of the time unit suffix:
        # 
        # *   **s**: seconds.
        # *   **m**: minutes.
        # *   **h**: hours.
        # *   **d**: days.
        # 
        # >  A value of **5m** indicates 5 minutes.
        self.upgrade_observation_window_size = upgrade_observation_window_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_step is not None:
            result['CpuStep'] = self.cpu_step
        if self.cpu_usage_upper_threshold is not None:
            result['CpuUsageUpperThreshold'] = self.cpu_usage_upper_threshold
        if self.downgrade_observation_window_size is not None:
            result['DowngradeObservationWindowSize'] = self.downgrade_observation_window_size
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.upgrade_observation_window_size is not None:
            result['UpgradeObservationWindowSize'] = self.upgrade_observation_window_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CpuStep') is not None:
            self.cpu_step = m.get('CpuStep')
        if m.get('CpuUsageUpperThreshold') is not None:
            self.cpu_usage_upper_threshold = m.get('CpuUsageUpperThreshold')
        if m.get('DowngradeObservationWindowSize') is not None:
            self.downgrade_observation_window_size = m.get('DowngradeObservationWindowSize')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('UpgradeObservationWindowSize') is not None:
            self.upgrade_observation_window_size = m.get('UpgradeObservationWindowSize')
        return self


class DescribeAutoScalingConfigResponseBodyDataShard(TeaModel):
    def __init__(
        self,
        downgrade: bool = None,
        downgrade_observation_window_size: str = None,
        max_shards: int = None,
        mem_usage_lower_threshold: int = None,
        mem_usage_upper_threshold: int = None,
        min_shards: int = None,
        upgrade: bool = None,
        upgrade_observation_window_size: str = None,
    ):
        # Indicates whether the feature of automatically removing shards is enabled. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.downgrade = downgrade
        # The observation window of the feature of automatically removing shards. The return value consists of a numeric value and a time unit suffix. Valid values of the time unit suffix:
        # 
        # *   **s**: seconds.
        # *   **m**: minutes.
        # *   **h**: hours.
        # *   **d**: days.
        # 
        # >  A value of **1d** indicates one day.
        self.downgrade_observation_window_size = downgrade_observation_window_size
        # The maximum number of shards in the instance.
        self.max_shards = max_shards
        # The average memory usage threshold that triggers automatic removal of shards. Unit: %.
        self.mem_usage_lower_threshold = mem_usage_lower_threshold
        # The average memory usage threshold that triggers automatic adding of shards. Unit: %.
        self.mem_usage_upper_threshold = mem_usage_upper_threshold
        # The minimum number of shards in the instance.
        self.min_shards = min_shards
        # Indicates whether the feature of automatically adding shards is enabled. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.upgrade = upgrade
        # The observation window of the feature of automatically adding shards. The return value consists of a numeric value and a time unit suffix. Valid values of the time unit suffix:
        # 
        # *   **s**: seconds.
        # *   **m**: minutes.
        # *   **h**: hours.
        # *   **d**: days.
        # 
        # >  A value of **5m** indicates 5 minutes.
        self.upgrade_observation_window_size = upgrade_observation_window_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.downgrade is not None:
            result['Downgrade'] = self.downgrade
        if self.downgrade_observation_window_size is not None:
            result['DowngradeObservationWindowSize'] = self.downgrade_observation_window_size
        if self.max_shards is not None:
            result['MaxShards'] = self.max_shards
        if self.mem_usage_lower_threshold is not None:
            result['MemUsageLowerThreshold'] = self.mem_usage_lower_threshold
        if self.mem_usage_upper_threshold is not None:
            result['MemUsageUpperThreshold'] = self.mem_usage_upper_threshold
        if self.min_shards is not None:
            result['MinShards'] = self.min_shards
        if self.upgrade is not None:
            result['Upgrade'] = self.upgrade
        if self.upgrade_observation_window_size is not None:
            result['UpgradeObservationWindowSize'] = self.upgrade_observation_window_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Downgrade') is not None:
            self.downgrade = m.get('Downgrade')
        if m.get('DowngradeObservationWindowSize') is not None:
            self.downgrade_observation_window_size = m.get('DowngradeObservationWindowSize')
        if m.get('MaxShards') is not None:
            self.max_shards = m.get('MaxShards')
        if m.get('MemUsageLowerThreshold') is not None:
            self.mem_usage_lower_threshold = m.get('MemUsageLowerThreshold')
        if m.get('MemUsageUpperThreshold') is not None:
            self.mem_usage_upper_threshold = m.get('MemUsageUpperThreshold')
        if m.get('MinShards') is not None:
            self.min_shards = m.get('MinShards')
        if m.get('Upgrade') is not None:
            self.upgrade = m.get('Upgrade')
        if m.get('UpgradeObservationWindowSize') is not None:
            self.upgrade_observation_window_size = m.get('UpgradeObservationWindowSize')
        return self


class DescribeAutoScalingConfigResponseBodyDataSpec(TeaModel):
    def __init__(
        self,
        cool_down_time: str = None,
        cpu_usage_upper_threshold: int = None,
        downgrade: bool = None,
        max_read_only_nodes: int = None,
        max_spec: str = None,
        mem_usage_upper_threshold: int = None,
        observation_window_size: str = None,
        upgrade: bool = None,
    ):
        # The quiescent period. The return value consists of a numeric value and a time unit suffix. Valid values of the time unit suffix:
        # 
        # *   **s**: seconds.
        # *   **m**: minutes.
        # *   **h**: hours.
        # *   **d**: days.
        # 
        # >  A value of **5m** indicates 5 minutes.
        self.cool_down_time = cool_down_time
        # The average CPU utilization threshold that triggers automatic specification scale-up. Unit: %.
        self.cpu_usage_upper_threshold = cpu_usage_upper_threshold
        # Indicates whether the automatic specification scale-down feature is enabled. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.downgrade = downgrade
        # The maximum number of read-only nodes of the instance.
        self.max_read_only_nodes = max_read_only_nodes
        # The maximum specifications to which the database instance can be upgraded. For more information about the specifications of each type of supported database instances, see the following topics:
        # 
        # *   PolarDB for MySQL Cluster Edition instances: [Specifications of compute nodes](~~102542~~).
        # *   ApsaraDB RDS for MySQL High-availability Edition instances that use standard SSDs or enhanced SSDs (ESSDs): [Specifications](~~276974~~).
        self.max_spec = max_spec
        # The average memory usage threshold that triggers automatic specification scale-up. Unit: %.
        self.mem_usage_upper_threshold = mem_usage_upper_threshold
        # The observation window. The return value consists of a numeric value and a time unit suffix. Valid values of the time unit suffix:
        # 
        # *   **s**: seconds.
        # *   **m**: minutes.
        # *   **h**: hours.
        # *   **d**: days.
        # 
        # >  A value of **5m** indicates 5 minutes.
        self.observation_window_size = observation_window_size
        # Indicates whether the automatic specification scale-up feature is enabled. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.upgrade = upgrade

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cool_down_time is not None:
            result['CoolDownTime'] = self.cool_down_time
        if self.cpu_usage_upper_threshold is not None:
            result['CpuUsageUpperThreshold'] = self.cpu_usage_upper_threshold
        if self.downgrade is not None:
            result['Downgrade'] = self.downgrade
        if self.max_read_only_nodes is not None:
            result['MaxReadOnlyNodes'] = self.max_read_only_nodes
        if self.max_spec is not None:
            result['MaxSpec'] = self.max_spec
        if self.mem_usage_upper_threshold is not None:
            result['MemUsageUpperThreshold'] = self.mem_usage_upper_threshold
        if self.observation_window_size is not None:
            result['ObservationWindowSize'] = self.observation_window_size
        if self.upgrade is not None:
            result['Upgrade'] = self.upgrade
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoolDownTime') is not None:
            self.cool_down_time = m.get('CoolDownTime')
        if m.get('CpuUsageUpperThreshold') is not None:
            self.cpu_usage_upper_threshold = m.get('CpuUsageUpperThreshold')
        if m.get('Downgrade') is not None:
            self.downgrade = m.get('Downgrade')
        if m.get('MaxReadOnlyNodes') is not None:
            self.max_read_only_nodes = m.get('MaxReadOnlyNodes')
        if m.get('MaxSpec') is not None:
            self.max_spec = m.get('MaxSpec')
        if m.get('MemUsageUpperThreshold') is not None:
            self.mem_usage_upper_threshold = m.get('MemUsageUpperThreshold')
        if m.get('ObservationWindowSize') is not None:
            self.observation_window_size = m.get('ObservationWindowSize')
        if m.get('Upgrade') is not None:
            self.upgrade = m.get('Upgrade')
        return self


class DescribeAutoScalingConfigResponseBodyDataStorage(TeaModel):
    def __init__(
        self,
        disk_usage_upper_threshold: int = None,
        max_storage: int = None,
        upgrade: bool = None,
    ):
        # The average storage usage threshold that triggers automatic storage expansion. Unit: %.
        self.disk_usage_upper_threshold = disk_usage_upper_threshold
        # The maximum storage size. Unit: GB.
        self.max_storage = max_storage
        # Indicates whether the automatic storage expansion feature is enabled. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.upgrade = upgrade

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_usage_upper_threshold is not None:
            result['DiskUsageUpperThreshold'] = self.disk_usage_upper_threshold
        if self.max_storage is not None:
            result['MaxStorage'] = self.max_storage
        if self.upgrade is not None:
            result['Upgrade'] = self.upgrade
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskUsageUpperThreshold') is not None:
            self.disk_usage_upper_threshold = m.get('DiskUsageUpperThreshold')
        if m.get('MaxStorage') is not None:
            self.max_storage = m.get('MaxStorage')
        if m.get('Upgrade') is not None:
            self.upgrade = m.get('Upgrade')
        return self


class DescribeAutoScalingConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        bandwidth: DescribeAutoScalingConfigResponseBodyDataBandwidth = None,
        resource: DescribeAutoScalingConfigResponseBodyDataResource = None,
        shard: DescribeAutoScalingConfigResponseBodyDataShard = None,
        spec: DescribeAutoScalingConfigResponseBodyDataSpec = None,
        storage: DescribeAutoScalingConfigResponseBodyDataStorage = None,
    ):
        # The configurations of the automatic bandwidth adjustment feature.
        self.bandwidth = bandwidth
        # The configurations of the auto scaling feature for local resources.
        self.resource = resource
        # The configurations of the auto scaling feature for shards.
        self.shard = shard
        # The configurations of the auto scaling feature for specifications.
        self.spec = spec
        # The configurations of the automatic storage expansion feature.
        self.storage = storage

    def validate(self):
        if self.bandwidth:
            self.bandwidth.validate()
        if self.resource:
            self.resource.validate()
        if self.shard:
            self.shard.validate()
        if self.spec:
            self.spec.validate()
        if self.storage:
            self.storage.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth.to_map()
        if self.resource is not None:
            result['Resource'] = self.resource.to_map()
        if self.shard is not None:
            result['Shard'] = self.shard.to_map()
        if self.spec is not None:
            result['Spec'] = self.spec.to_map()
        if self.storage is not None:
            result['Storage'] = self.storage.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            temp_model = DescribeAutoScalingConfigResponseBodyDataBandwidth()
            self.bandwidth = temp_model.from_map(m['Bandwidth'])
        if m.get('Resource') is not None:
            temp_model = DescribeAutoScalingConfigResponseBodyDataResource()
            self.resource = temp_model.from_map(m['Resource'])
        if m.get('Shard') is not None:
            temp_model = DescribeAutoScalingConfigResponseBodyDataShard()
            self.shard = temp_model.from_map(m['Shard'])
        if m.get('Spec') is not None:
            temp_model = DescribeAutoScalingConfigResponseBodyDataSpec()
            self.spec = temp_model.from_map(m['Spec'])
        if m.get('Storage') is not None:
            temp_model = DescribeAutoScalingConfigResponseBodyDataStorage()
            self.storage = temp_model.from_map(m['Storage'])
        return self


class DescribeAutoScalingConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeAutoScalingConfigResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The configurations of the auto scaling feature.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeAutoScalingConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeAutoScalingConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAutoScalingConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAutoScalingConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoScalingHistoryRequest(TeaModel):
    def __init__(
        self,
        auto_scaling_task_type: str = None,
        end_time: int = None,
        instance_id: str = None,
        start_time: int = None,
    ):
        # The type of the auto scaling task that you want to query. Set the value to **SPEC**, which indicates that you can query the history of only automatic performance scaling tasks.
        self.auto_scaling_task_type = auto_scaling_task_type
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # > The end time must be later than the start time.
        self.end_time = end_time
        # The instance ID.
        # 
        # > Only ApsaraDB RDS for MySQL instances are supported.
        self.instance_id = instance_id
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # > The maximum time range that can be specified is 45 days.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_scaling_task_type is not None:
            result['AutoScalingTaskType'] = self.auto_scaling_task_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoScalingTaskType') is not None:
            self.auto_scaling_task_type = m.get('AutoScalingTaskType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeAutoScalingHistoryResponseBodyDataSpecHistory(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        origin_core: int = None,
        origin_instance_class: str = None,
        origin_memory: float = None,
        scale_type: str = None,
        target_core: int = None,
        target_instance_class: str = None,
        target_memory: float = None,
        task_excute_status: bool = None,
        task_time: int = None,
    ):
        # The error code returned by the scaling task. Valid values:
        # 
        # *   **Insufficient_Balance**: The account has insufficient balance or an unpaid order.
        # *   **REACH_SPEC_UPPERBOUND**: The instance type reaches the upper limit.
        # *   **Control_Error_Timeout_Msg**: The management task timed out.
        # *   **Invoke_Rds_Api_Error_Msg**: Failed to call the ApsaraDB RDS API.
        self.error_code = error_code
        # The original number of CPU cores of the instance.
        self.origin_core = origin_core
        # The original instance type.
        self.origin_instance_class = origin_instance_class
        # The original memory size of the instance. Unit: GB.
        self.origin_memory = origin_memory
        # The type of the automatic performance scaling task. Valid values:
        # 
        # *   **SCALE_UP**: automatic instance type scale-up task.
        # *   **SCALE_DOWN**: automatic instance type scale-down task.
        self.scale_type = scale_type
        # The destination number of CPU cores of the instance.
        self.target_core = target_core
        # The destination instance type.
        self.target_instance_class = target_instance_class
        # The destination memory size of the instance. Unit: GB.
        self.target_memory = target_memory
        # The status of the task. Valid values:
        # 
        # *   **true**: The task was successful.
        # *   **false**: The task failed.
        self.task_excute_status = task_excute_status
        # The time when the task was run. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.task_time = task_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.origin_core is not None:
            result['OriginCore'] = self.origin_core
        if self.origin_instance_class is not None:
            result['OriginInstanceClass'] = self.origin_instance_class
        if self.origin_memory is not None:
            result['OriginMemory'] = self.origin_memory
        if self.scale_type is not None:
            result['ScaleType'] = self.scale_type
        if self.target_core is not None:
            result['TargetCore'] = self.target_core
        if self.target_instance_class is not None:
            result['TargetInstanceClass'] = self.target_instance_class
        if self.target_memory is not None:
            result['TargetMemory'] = self.target_memory
        if self.task_excute_status is not None:
            result['TaskExcuteStatus'] = self.task_excute_status
        if self.task_time is not None:
            result['TaskTime'] = self.task_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('OriginCore') is not None:
            self.origin_core = m.get('OriginCore')
        if m.get('OriginInstanceClass') is not None:
            self.origin_instance_class = m.get('OriginInstanceClass')
        if m.get('OriginMemory') is not None:
            self.origin_memory = m.get('OriginMemory')
        if m.get('ScaleType') is not None:
            self.scale_type = m.get('ScaleType')
        if m.get('TargetCore') is not None:
            self.target_core = m.get('TargetCore')
        if m.get('TargetInstanceClass') is not None:
            self.target_instance_class = m.get('TargetInstanceClass')
        if m.get('TargetMemory') is not None:
            self.target_memory = m.get('TargetMemory')
        if m.get('TaskExcuteStatus') is not None:
            self.task_excute_status = m.get('TaskExcuteStatus')
        if m.get('TaskTime') is not None:
            self.task_time = m.get('TaskTime')
        return self


class DescribeAutoScalingHistoryResponseBodyData(TeaModel):
    def __init__(
        self,
        bandwidth: List[Dict[str, Any]] = None,
        instance_id: str = None,
        resource: List[Dict[str, Any]] = None,
        shard: List[Dict[str, Any]] = None,
        spec_history: List[DescribeAutoScalingHistoryResponseBodyDataSpecHistory] = None,
        storage: List[Dict[str, Any]] = None,
    ):
        # The history of automatic bandwidth scaling of ApsaraDB for Redis instances. This feature is not supported.
        self.bandwidth = bandwidth
        # The instance ID.
        self.instance_id = instance_id
        # The history of resource scale-out of ApsaraDB for Redis instances. This feature is not supported.
        self.resource = resource
        # The history of automatic shard scale-out of ApsaraDB for Redis instances. This feature is not supported.
        self.shard = shard
        # The history of automatic performance scaling.
        self.spec_history = spec_history
        # The history of storage expansion. This feature is not supported.
        self.storage = storage

    def validate(self):
        if self.spec_history:
            for k in self.spec_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource is not None:
            result['Resource'] = self.resource
        if self.shard is not None:
            result['Shard'] = self.shard
        result['SpecHistory'] = []
        if self.spec_history is not None:
            for k in self.spec_history:
                result['SpecHistory'].append(k.to_map() if k else None)
        if self.storage is not None:
            result['Storage'] = self.storage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Resource') is not None:
            self.resource = m.get('Resource')
        if m.get('Shard') is not None:
            self.shard = m.get('Shard')
        self.spec_history = []
        if m.get('SpecHistory') is not None:
            for k in m.get('SpecHistory'):
                temp_model = DescribeAutoScalingHistoryResponseBodyDataSpecHistory()
                self.spec_history.append(temp_model.from_map(k))
        if m.get('Storage') is not None:
            self.storage = m.get('Storage')
        return self


class DescribeAutoScalingHistoryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeAutoScalingHistoryResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned. The status code 200 indicates that the request was successful.
        self.code = code
        # The history of auto scaling.
        self.data = data
        # The returned message.
        # 
        # > If the request was successful, **Successful** is returned. Otherwise, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeAutoScalingHistoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeAutoScalingHistoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAutoScalingHistoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAutoScalingHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCacheAnalysisJobRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        job_id: str = None,
    ):
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the cache analysis task. You can obtain the task ID from the response parameters of the [CreateCacheAnalysisJob](~~180982~~) operation.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DescribeCacheAnalysisJobResponseBodyDataBigKeysKeyInfo(TeaModel):
    def __init__(
        self,
        bytes: int = None,
        count: int = None,
        db: int = None,
        encoding: str = None,
        expiration_time_millis: int = None,
        key: str = None,
        node_id: str = None,
        type: str = None,
    ):
        # The number of bytes that are occupied by the key.
        self.bytes = bytes
        # The number of elements in the key.
        self.count = count
        # The name of the database.
        self.db = db
        # The data type of the key.
        self.encoding = encoding
        # The expiration period of the key. Unit: milliseconds. A value of 0 indicates that the key does not expire.
        self.expiration_time_millis = expiration_time_millis
        # The name of the key.
        self.key = key
        # The ID of the data node on the instance.
        self.node_id = node_id
        # The data type of the instance.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bytes is not None:
            result['Bytes'] = self.bytes
        if self.count is not None:
            result['Count'] = self.count
        if self.db is not None:
            result['Db'] = self.db
        if self.encoding is not None:
            result['Encoding'] = self.encoding
        if self.expiration_time_millis is not None:
            result['ExpirationTimeMillis'] = self.expiration_time_millis
        if self.key is not None:
            result['Key'] = self.key
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bytes') is not None:
            self.bytes = m.get('Bytes')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('Encoding') is not None:
            self.encoding = m.get('Encoding')
        if m.get('ExpirationTimeMillis') is not None:
            self.expiration_time_millis = m.get('ExpirationTimeMillis')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCacheAnalysisJobResponseBodyDataBigKeys(TeaModel):
    def __init__(
        self,
        key_info: List[DescribeCacheAnalysisJobResponseBodyDataBigKeysKeyInfo] = None,
    ):
        self.key_info = key_info

    def validate(self):
        if self.key_info:
            for k in self.key_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['KeyInfo'] = []
        if self.key_info is not None:
            for k in self.key_info:
                result['KeyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.key_info = []
        if m.get('KeyInfo') is not None:
            for k in m.get('KeyInfo'):
                temp_model = DescribeCacheAnalysisJobResponseBodyDataBigKeysKeyInfo()
                self.key_info.append(temp_model.from_map(k))
        return self


class DescribeCacheAnalysisJobResponseBodyDataBigKeysOfNumKeyInfo(TeaModel):
    def __init__(
        self,
        bytes: int = None,
        count: int = None,
        db: int = None,
        encoding: str = None,
        expiration_time_millis: int = None,
        key: str = None,
        node_id: str = None,
        type: str = None,
    ):
        # The number of bytes that are occupied by the key.
        self.bytes = bytes
        # The number of elements in the key.
        self.count = count
        # The name of the database.
        self.db = db
        # The data type of the key.
        self.encoding = encoding
        # The expiration period of the key. Unit: milliseconds. A value of 0 indicates that the key does not expire.
        self.expiration_time_millis = expiration_time_millis
        # The name of the key.
        self.key = key
        # The ID of the data node on the instance.
        self.node_id = node_id
        # The data type of the instance.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bytes is not None:
            result['Bytes'] = self.bytes
        if self.count is not None:
            result['Count'] = self.count
        if self.db is not None:
            result['Db'] = self.db
        if self.encoding is not None:
            result['Encoding'] = self.encoding
        if self.expiration_time_millis is not None:
            result['ExpirationTimeMillis'] = self.expiration_time_millis
        if self.key is not None:
            result['Key'] = self.key
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bytes') is not None:
            self.bytes = m.get('Bytes')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('Encoding') is not None:
            self.encoding = m.get('Encoding')
        if m.get('ExpirationTimeMillis') is not None:
            self.expiration_time_millis = m.get('ExpirationTimeMillis')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCacheAnalysisJobResponseBodyDataBigKeysOfNum(TeaModel):
    def __init__(
        self,
        key_info: List[DescribeCacheAnalysisJobResponseBodyDataBigKeysOfNumKeyInfo] = None,
    ):
        self.key_info = key_info

    def validate(self):
        if self.key_info:
            for k in self.key_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['KeyInfo'] = []
        if self.key_info is not None:
            for k in self.key_info:
                result['KeyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.key_info = []
        if m.get('KeyInfo') is not None:
            for k in m.get('KeyInfo'):
                temp_model = DescribeCacheAnalysisJobResponseBodyDataBigKeysOfNumKeyInfo()
                self.key_info.append(temp_model.from_map(k))
        return self


class DescribeCacheAnalysisJobResponseBodyDataKeyPrefixesPrefix(TeaModel):
    def __init__(
        self,
        bytes: int = None,
        count: int = None,
        key_num: int = None,
        prefix: str = None,
        type: str = None,
    ):
        # The number of bytes that are occupied by the key.
        self.bytes = bytes
        # The number of elements in the key.
        self.count = count
        # The number of keys that contain the prefix.
        self.key_num = key_num
        # The prefix of the key.
        self.prefix = prefix
        # The data type of the instance.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bytes is not None:
            result['Bytes'] = self.bytes
        if self.count is not None:
            result['Count'] = self.count
        if self.key_num is not None:
            result['KeyNum'] = self.key_num
        if self.prefix is not None:
            result['Prefix'] = self.prefix
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bytes') is not None:
            self.bytes = m.get('Bytes')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('KeyNum') is not None:
            self.key_num = m.get('KeyNum')
        if m.get('Prefix') is not None:
            self.prefix = m.get('Prefix')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCacheAnalysisJobResponseBodyDataKeyPrefixes(TeaModel):
    def __init__(
        self,
        prefix: List[DescribeCacheAnalysisJobResponseBodyDataKeyPrefixesPrefix] = None,
    ):
        self.prefix = prefix

    def validate(self):
        if self.prefix:
            for k in self.prefix:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Prefix'] = []
        if self.prefix is not None:
            for k in self.prefix:
                result['Prefix'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.prefix = []
        if m.get('Prefix') is not None:
            for k in m.get('Prefix'):
                temp_model = DescribeCacheAnalysisJobResponseBodyDataKeyPrefixesPrefix()
                self.prefix.append(temp_model.from_map(k))
        return self


class DescribeCacheAnalysisJobResponseBodyDataUnexBigKeysOfBytesKeyInfo(TeaModel):
    def __init__(
        self,
        bytes: int = None,
        count: int = None,
        db: int = None,
        encoding: str = None,
        expiration_time_millis: int = None,
        key: str = None,
        node_id: str = None,
        type: str = None,
    ):
        # The number of bytes that are occupied by the key.
        self.bytes = bytes
        # The number of elements in the key.
        self.count = count
        # The name of the database.
        self.db = db
        # The data type of the key.
        self.encoding = encoding
        # The expiration period of the key. Unit: milliseconds. A value of 0 indicates that the key does not expire.
        self.expiration_time_millis = expiration_time_millis
        # The name of the key.
        self.key = key
        # The ID of the data node on the instance.
        self.node_id = node_id
        # The data type of the instance.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bytes is not None:
            result['Bytes'] = self.bytes
        if self.count is not None:
            result['Count'] = self.count
        if self.db is not None:
            result['Db'] = self.db
        if self.encoding is not None:
            result['Encoding'] = self.encoding
        if self.expiration_time_millis is not None:
            result['ExpirationTimeMillis'] = self.expiration_time_millis
        if self.key is not None:
            result['Key'] = self.key
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bytes') is not None:
            self.bytes = m.get('Bytes')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('Encoding') is not None:
            self.encoding = m.get('Encoding')
        if m.get('ExpirationTimeMillis') is not None:
            self.expiration_time_millis = m.get('ExpirationTimeMillis')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCacheAnalysisJobResponseBodyDataUnexBigKeysOfBytes(TeaModel):
    def __init__(
        self,
        key_info: List[DescribeCacheAnalysisJobResponseBodyDataUnexBigKeysOfBytesKeyInfo] = None,
    ):
        self.key_info = key_info

    def validate(self):
        if self.key_info:
            for k in self.key_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['KeyInfo'] = []
        if self.key_info is not None:
            for k in self.key_info:
                result['KeyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.key_info = []
        if m.get('KeyInfo') is not None:
            for k in m.get('KeyInfo'):
                temp_model = DescribeCacheAnalysisJobResponseBodyDataUnexBigKeysOfBytesKeyInfo()
                self.key_info.append(temp_model.from_map(k))
        return self


class DescribeCacheAnalysisJobResponseBodyDataUnexBigKeysOfNumKeyInfo(TeaModel):
    def __init__(
        self,
        bytes: int = None,
        count: int = None,
        db: int = None,
        encoding: str = None,
        expiration_time_millis: int = None,
        key: str = None,
        node_id: str = None,
        type: str = None,
    ):
        # The number of bytes that are occupied by the key.
        self.bytes = bytes
        # The number of elements in the key.
        self.count = count
        # The name of the database.
        self.db = db
        # The data type of the key.
        self.encoding = encoding
        # The expiration period of the key. Unit: milliseconds. A value of 0 indicates that the key does not expire.
        self.expiration_time_millis = expiration_time_millis
        # The name of the key.
        self.key = key
        # The ID of the data node on the instance.
        self.node_id = node_id
        # The data type of the instance.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bytes is not None:
            result['Bytes'] = self.bytes
        if self.count is not None:
            result['Count'] = self.count
        if self.db is not None:
            result['Db'] = self.db
        if self.encoding is not None:
            result['Encoding'] = self.encoding
        if self.expiration_time_millis is not None:
            result['ExpirationTimeMillis'] = self.expiration_time_millis
        if self.key is not None:
            result['Key'] = self.key
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bytes') is not None:
            self.bytes = m.get('Bytes')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('Encoding') is not None:
            self.encoding = m.get('Encoding')
        if m.get('ExpirationTimeMillis') is not None:
            self.expiration_time_millis = m.get('ExpirationTimeMillis')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCacheAnalysisJobResponseBodyDataUnexBigKeysOfNum(TeaModel):
    def __init__(
        self,
        key_info: List[DescribeCacheAnalysisJobResponseBodyDataUnexBigKeysOfNumKeyInfo] = None,
    ):
        self.key_info = key_info

    def validate(self):
        if self.key_info:
            for k in self.key_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['KeyInfo'] = []
        if self.key_info is not None:
            for k in self.key_info:
                result['KeyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.key_info = []
        if m.get('KeyInfo') is not None:
            for k in m.get('KeyInfo'):
                temp_model = DescribeCacheAnalysisJobResponseBodyDataUnexBigKeysOfNumKeyInfo()
                self.key_info.append(temp_model.from_map(k))
        return self


class DescribeCacheAnalysisJobResponseBodyData(TeaModel):
    def __init__(
        self,
        big_keys: DescribeCacheAnalysisJobResponseBodyDataBigKeys = None,
        big_keys_of_num: DescribeCacheAnalysisJobResponseBodyDataBigKeysOfNum = None,
        instance_id: str = None,
        job_id: str = None,
        key_prefixes: DescribeCacheAnalysisJobResponseBodyDataKeyPrefixes = None,
        message: str = None,
        node_id: str = None,
        task_state: str = None,
        unex_big_keys_of_bytes: DescribeCacheAnalysisJobResponseBodyDataUnexBigKeysOfBytes = None,
        unex_big_keys_of_num: DescribeCacheAnalysisJobResponseBodyDataUnexBigKeysOfNum = None,
    ):
        # The details of the large keys. The returned large keys are sorted in descending order based on the number of bytes occupied by the keys.
        self.big_keys = big_keys
        # The details of the large keys. The returned large keys are sorted in descending order based on the number of keys.
        self.big_keys_of_num = big_keys_of_num
        # The instance ID.
        self.instance_id = instance_id
        # The ID of the cache analysis task.
        self.job_id = job_id
        # The prefixes of the keys.
        self.key_prefixes = key_prefixes
        # The message that is returned for the request.
        # 
        # >  If the request is successful, **Successful** is returned. If the request fails, an error message that contains information such as an error code is returned.
        self.message = message
        # The ID of the data node on the instance.
        self.node_id = node_id
        # The state of the cache analysis task. Valid values:
        # 
        # *   **BACKUP**: The data is being backed up.
        # *   **ANALYZING**: The data is being analyzed.
        # *   **FINISHED**: The data is analyzed.
        # *   **FAILED**: An error occurred.
        self.task_state = task_state
        # The details of permanent keys. The returned keys are sorted in descending order based on the number of bytes occupied by the keys.
        self.unex_big_keys_of_bytes = unex_big_keys_of_bytes
        # The details of permanent keys. The returned keys are sorted in descending order based on the number of keys.
        self.unex_big_keys_of_num = unex_big_keys_of_num

    def validate(self):
        if self.big_keys:
            self.big_keys.validate()
        if self.big_keys_of_num:
            self.big_keys_of_num.validate()
        if self.key_prefixes:
            self.key_prefixes.validate()
        if self.unex_big_keys_of_bytes:
            self.unex_big_keys_of_bytes.validate()
        if self.unex_big_keys_of_num:
            self.unex_big_keys_of_num.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.big_keys is not None:
            result['BigKeys'] = self.big_keys.to_map()
        if self.big_keys_of_num is not None:
            result['BigKeysOfNum'] = self.big_keys_of_num.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.key_prefixes is not None:
            result['KeyPrefixes'] = self.key_prefixes.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.unex_big_keys_of_bytes is not None:
            result['UnexBigKeysOfBytes'] = self.unex_big_keys_of_bytes.to_map()
        if self.unex_big_keys_of_num is not None:
            result['UnexBigKeysOfNum'] = self.unex_big_keys_of_num.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BigKeys') is not None:
            temp_model = DescribeCacheAnalysisJobResponseBodyDataBigKeys()
            self.big_keys = temp_model.from_map(m['BigKeys'])
        if m.get('BigKeysOfNum') is not None:
            temp_model = DescribeCacheAnalysisJobResponseBodyDataBigKeysOfNum()
            self.big_keys_of_num = temp_model.from_map(m['BigKeysOfNum'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('KeyPrefixes') is not None:
            temp_model = DescribeCacheAnalysisJobResponseBodyDataKeyPrefixes()
            self.key_prefixes = temp_model.from_map(m['KeyPrefixes'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('UnexBigKeysOfBytes') is not None:
            temp_model = DescribeCacheAnalysisJobResponseBodyDataUnexBigKeysOfBytes()
            self.unex_big_keys_of_bytes = temp_model.from_map(m['UnexBigKeysOfBytes'])
        if m.get('UnexBigKeysOfNum') is not None:
            temp_model = DescribeCacheAnalysisJobResponseBodyDataUnexBigKeysOfNum()
            self.unex_big_keys_of_num = temp_model.from_map(m['UnexBigKeysOfNum'])
        return self


class DescribeCacheAnalysisJobResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeCacheAnalysisJobResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The details of the task.
        self.data = data
        # The message that is returned for the request.
        # 
        # >  If the request is successful, **Successful** is returned. If the request fails, an error message that contains information such as an error code is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeCacheAnalysisJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCacheAnalysisJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCacheAnalysisJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCacheAnalysisJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCacheAnalysisJobsRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        instance_id: str = None,
        page_no: str = None,
        page_size: str = None,
        start_time: str = None,
    ):
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time
        # The instance ID.
        self.instance_id = instance_id
        # The page number. The value must be an integer that is greater than 0. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeCacheAnalysisJobsResponseBodyDataListCacheAnalysisJobBigKeysKeyInfo(TeaModel):
    def __init__(
        self,
        bytes: int = None,
        count: int = None,
        db: int = None,
        encoding: str = None,
        expiration_time_millis: int = None,
        key: str = None,
        node_id: str = None,
        type: str = None,
    ):
        # The number of bytes that are occupied by the key.
        self.bytes = bytes
        # The number of elements in the key.
        self.count = count
        # The name of the database.
        self.db = db
        # The data type of the key.
        self.encoding = encoding
        # The expiration period of the key. Unit: milliseconds. A value of 0 indicates that the key does not expire.
        self.expiration_time_millis = expiration_time_millis
        # The name of the key.
        self.key = key
        # The ID of the data node on the instance.
        self.node_id = node_id
        # The data type of the instance.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bytes is not None:
            result['Bytes'] = self.bytes
        if self.count is not None:
            result['Count'] = self.count
        if self.db is not None:
            result['Db'] = self.db
        if self.encoding is not None:
            result['Encoding'] = self.encoding
        if self.expiration_time_millis is not None:
            result['ExpirationTimeMillis'] = self.expiration_time_millis
        if self.key is not None:
            result['Key'] = self.key
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bytes') is not None:
            self.bytes = m.get('Bytes')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('Encoding') is not None:
            self.encoding = m.get('Encoding')
        if m.get('ExpirationTimeMillis') is not None:
            self.expiration_time_millis = m.get('ExpirationTimeMillis')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCacheAnalysisJobsResponseBodyDataListCacheAnalysisJobBigKeys(TeaModel):
    def __init__(
        self,
        key_info: List[DescribeCacheAnalysisJobsResponseBodyDataListCacheAnalysisJobBigKeysKeyInfo] = None,
    ):
        self.key_info = key_info

    def validate(self):
        if self.key_info:
            for k in self.key_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['KeyInfo'] = []
        if self.key_info is not None:
            for k in self.key_info:
                result['KeyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.key_info = []
        if m.get('KeyInfo') is not None:
            for k in m.get('KeyInfo'):
                temp_model = DescribeCacheAnalysisJobsResponseBodyDataListCacheAnalysisJobBigKeysKeyInfo()
                self.key_info.append(temp_model.from_map(k))
        return self


class DescribeCacheAnalysisJobsResponseBodyDataListCacheAnalysisJob(TeaModel):
    def __init__(
        self,
        big_keys: DescribeCacheAnalysisJobsResponseBodyDataListCacheAnalysisJobBigKeys = None,
        instance_id: str = None,
        job_id: str = None,
        message: str = None,
        node_id: str = None,
        task_state: str = None,
    ):
        # The details about the large keys.
        # 
        # > The sub-parameters of this parameter and the content of the sub-parameters are not returned. To query the detailed information about the cache analysis tasks, call the [DescribeCacheAnalysisJob](~~443012~~) operation.
        self.big_keys = big_keys
        # The instance ID.
        self.instance_id = instance_id
        # The ID of the cache analysis task.
        self.job_id = job_id
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The ID of the data node on the instance.
        self.node_id = node_id
        # The state of the cache analysis task. Valid values:
        # 
        # * **BACKUP**: The data is being backed up.
        # * **ANALYZING**: The data is being analyzed.
        # * **FINISHED**: The data is analyzed.
        # * **FAILED**: An error occurred.
        self.task_state = task_state

    def validate(self):
        if self.big_keys:
            self.big_keys.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.big_keys is not None:
            result['BigKeys'] = self.big_keys.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BigKeys') is not None:
            temp_model = DescribeCacheAnalysisJobsResponseBodyDataListCacheAnalysisJobBigKeys()
            self.big_keys = temp_model.from_map(m['BigKeys'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        return self


class DescribeCacheAnalysisJobsResponseBodyDataList(TeaModel):
    def __init__(
        self,
        cache_analysis_job: List[DescribeCacheAnalysisJobsResponseBodyDataListCacheAnalysisJob] = None,
    ):
        self.cache_analysis_job = cache_analysis_job

    def validate(self):
        if self.cache_analysis_job:
            for k in self.cache_analysis_job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CacheAnalysisJob'] = []
        if self.cache_analysis_job is not None:
            for k in self.cache_analysis_job:
                result['CacheAnalysisJob'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cache_analysis_job = []
        if m.get('CacheAnalysisJob') is not None:
            for k in m.get('CacheAnalysisJob'):
                temp_model = DescribeCacheAnalysisJobsResponseBodyDataListCacheAnalysisJob()
                self.cache_analysis_job.append(temp_model.from_map(k))
        return self


class DescribeCacheAnalysisJobsResponseBodyData(TeaModel):
    def __init__(
        self,
        extra: str = None,
        list: DescribeCacheAnalysisJobsResponseBodyDataList = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The reserved parameter.
        self.extra = extra
        # The ID of the data node on the instance.
        self.list = list
        # The page number. The value must be an integer that is greater than 0. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('List') is not None:
            temp_model = DescribeCacheAnalysisJobsResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCacheAnalysisJobsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeCacheAnalysisJobsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The list of cache analysis tasks.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeCacheAnalysisJobsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCacheAnalysisJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCacheAnalysisJobsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCacheAnalysisJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudBenchTasksRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        page_no: str = None,
        page_size: str = None,
        start_time: str = None,
        status: str = None,
        task_type: str = None,
    ):
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time
        # The page number. The value must be a positive integer. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. The value must be a positive integer. Default value: 10.
        self.page_size = page_size
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time
        # The status of the stress testing task. Valid values:
        # 
        # *   **SUCCESS**: The task is successful.
        # *   **IGNORED**: The task is ignored.
        # *   **RUNNING**: The task is running.
        # *   **EXCEPTION**: The task is abnormal.
        self.status = status
        # The type of the stress testing task. Valid values:
        # 
        # *   **pressure test** (default): A task of this type replays the traffic that is captured from the source instance on the destination instance at the maximum playback rate that is supported by the destination instance.
        # *   **smart pressure test**: A task of this type analyzes the traffic that is captured from the source instance over a short period of time and generates traffic on the destination instance for continuous stress testing. The business model based on which the traffic is generated on the destination instance and the traffic distribution are consistent with those on the source instance. Stress testing tasks of this type can help you reduce the amount of time that is consumed to collect data from the source instance and reduce storage costs and performance overheads.
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeCloudBenchTasksResponseBodyDataListCloudbenchTasks(TeaModel):
    def __init__(
        self,
        archive_job_id: str = None,
        archive_oss_table_name: str = None,
        archive_state: int = None,
        backup_id: str = None,
        backup_type: str = None,
        bench_step: str = None,
        bench_step_status: str = None,
        client_gateway_id: str = None,
        client_type: str = None,
        description: str = None,
        dst_instance_uuid: str = None,
        dst_ip: str = None,
        dst_port: int = None,
        dst_type: str = None,
        dts_job_class: str = None,
        dts_job_id: str = None,
        dts_job_name: str = None,
        dts_job_state: int = None,
        dts_job_status: str = None,
        ecs_instance_id: str = None,
        end_state: str = None,
        error_code: str = None,
        error_message: str = None,
        external: str = None,
        rate: int = None,
        request_duration: int = None,
        smart_pressure_time: int = None,
        source: str = None,
        sql_complete_reuse: str = None,
        src_instance_area: str = None,
        src_instance_uuid: str = None,
        src_public_ip: str = None,
        state: str = None,
        status: str = None,
        table_schema: str = None,
        task_id: str = None,
        task_type: str = None,
        topic: str = None,
        user_id: str = None,
        version: str = None,
        work_dir: str = None,
    ):
        # The archiving task ID.
        self.archive_job_id = archive_job_id
        # The name of the table that was archived to Object Storage Service (OSS).
        self.archive_oss_table_name = archive_oss_table_name
        # The archiving status of the file that stores the analysis result of full SQL statistics. Valid values:
        # 
        # * **0**: The file archiving is not started.
        # * **1**: The file is archived.
        # * **2**: An error occurred.
        # * **3**: The file is being archived.
        # * **4**: The archived file does not need to be downloaded.
        self.archive_state = archive_state
        # The ID of the backup set. You can call the [DescribeBackups](~~26273~~) operation to query the ID of the backup set.
        self.backup_id = backup_id
        # The backup type. Valid values:
        # 
        # * **TIMESTAMP**: Data is restored to the state at a specific point in time.
        # * **BACKUPID**: Data is restored from a backup set that is identified by an ID.
        self.backup_type = backup_type
        # The substep in the stress testing task. Valid values:
        # 
        # * **NEW**: Initialize the stress testing task.
        # * **WAIT_BUY_ECS**: Purchase an ECS instance.
        # * **WAIT_START_ECS**: Start the ECS instance.
        # * **WAIT_INSTALL_JDK**: Install the Java Development Kit (JDK).
        # * **WAIT_INSTALL_DBGATEWAY**: Install the database gateway (DBGateway).
        # * **ADD_SECURITY_IPS_STEP**: Configure the whitelist of the security group.
        # * **ARCHIVIE**: Archive the file that stores the analysis results of full SQL statistics.
        # * **DOWNLOAD**: Download the file that stores the analysis result of full SQL statistics.
        # * **PROCEED**: Preprocess the file that stores the analysis result of full SQL statistics.
        # * **PRE_LOAD**: Preload the file that stores the analysis result of full SQL statistics.
        # * **VALIDATE**: Verify the functionality of stress testing.
        # * **PRESSURE**: Start the stress testing task.
        self.bench_step = bench_step
        # The status that indicates the substep performed for the stress testing task. Valid values:
        # 
        # * **NEW**: The task is being initialized.
        # * **RUNNING**: The task is running.
        # * **FAILED**: The task failed.
        # * **FINISHED**: The task is complete.
        # * **Terminated**: The task is terminated.
        # * **Deleted**: The task is deleted.
        self.bench_step_status = bench_step_status
        # The DBGateway ID of the stress testing client.
        self.client_gateway_id = client_gateway_id
        # The type of the stress testing client. Valid values:
        # 
        # * **ECS**: indicates that you must prepare the DBGateway.
        # * **DAS_ECS**: indicates that DAS automatically purchases and deploys an ECS instance for stress testing.
        self.client_type = client_type
        # The description of the stress testing task.
        self.description = description
        # The UUID of the destination instance.
        self.dst_instance_uuid = dst_instance_uuid
        # The reserved parameter.
        self.dst_ip = dst_ip
        # The port number of the destination instance.
        self.dst_port = dst_port
        # The type of the identifier that is used to indicate the destination instance. Valid values:
        # 
        # * **Instance** (default): the instance ID.
        # * **ConnectionString**: the endpoint of the instance.
        self.dst_type = dst_type
        # The specification of the DTS instance.
        # 
        # > For more information about the specifications of DTS instances and the test performance of each instance, see [Specifications of data migration instances](~~26606~~).
        self.dts_job_class = dts_job_class
        # The ID of the DTS migration task.
        self.dts_job_id = dts_job_id
        # The name of the Data Transmission Service (DTS) migration task.
        self.dts_job_name = dts_job_name
        # The status of the DTS migration task. Valid values:
        # 
        # * **NOT_STARTED**: The task is not started.
        # * **PRE_CHECKING**: The task is in precheck.
        # * **PRE_CHECK_FAILED**: The precheck failed.
        # * **CHECKING**: The task is being checked.
        # * **MIGRATING**: The data is being migrated.
        # * **CATCHED**: The data is migrated from the source instance to the destination instance.
        # * **SUSPENDING**: The task is suspended.
        # * **MIGRATION_FAILED**: The data failed to be migrated.
        # * **FINISHED**: The task is complete.
        # * **INITIALIZING**: The synchronization is being initialized.
        # * **INITIALIZE_FAILED**: The synchronization failed to be initialized.
        # * **SYNCHRONIZING**: The data is being synchronized.
        # * **MODIFYING**: The roles of the instances are being changed.
        # * **SWITCHING**: The roles of the instances are being switched.
        # * **FAILED**: The task failed.
        self.dts_job_state = dts_job_state
        # The status of the DTS migration task. Valid values:
        # 
        # * **NOT_STARTED**: The task is not started.
        # * **PRE_CHECKING**: The task is in precheck.
        # * **PRE_CHECK_FAILED**: The precheck failed.
        # * **CHECKING**: The task is being checked.
        # * **MIGRATING**: The data is being migrated.
        # * **CATCHED**: The data is migrated from the source instance to the destination instance.
        # * **SUSPENDING**: The task is suspended.
        # * **MIGRATION_FAILED**: The data failed to be migrated.
        # * **FINISHED**: The task is complete.
        # * **INITIALIZING**: The synchronization is being initialized.
        # * **INITIALIZE_FAILED**: The synchronization failed to be initialized.
        # * **SYNCHRONIZING**: The data is being synchronized.
        # * **MODIFYING**: The roles of the instances are being changed.
        # * **SWITCHING**: The roles of the instances are being switched.
        # * **FAILED**: The task failed.
        self.dts_job_status = dts_job_status
        # The ID of the Elastic Compute Service (ECS) instance.
        self.ecs_instance_id = ecs_instance_id
        # The state that indicates the last operation performed for the stress testing task. Valid values:
        # 
        # * **WAIT_TARGET**: prepares the destination instance.
        # * **WAIT_DBGATEWAY**: prepares the DBGateway.
        # * **WAIT_SQL**: prepares the full SQL statistics.
        # * **WAIT_LOGIC**: prepares to replay the traffic.
        # 
        # > When the state of a stress testing task changes to the state that is specified by the EndState parameter, the stress testing task is complete.
        self.end_state = end_state
        # The error code returned for the substep of the stress testing task.
        self.error_code = error_code
        # The error message returned if the task failed.
        self.error_message = error_message
        # The additional information.
        self.external = external
        # The rate at which the stress testing task replayed the traffic. This value is a positive integer. Valid values: **0** to **30**. Default value: **1**.
        self.rate = rate
        # The duration of the stress testing task. Unit: millisecond.
        self.request_duration = request_duration
        # The duration of the stress testing task of the smart pressure test type. Unit: millisecond.
        self.smart_pressure_time = smart_pressure_time
        # The source of the task. Valid values:
        # 
        # * **DAS**\
        # * **OPEN_API**\
        self.source = source
        # The reused information about the analysis result of full SQL statistics.
        self.sql_complete_reuse = sql_complete_reuse
        # The database engine of the source instance. Valid values:
        self.src_instance_area = src_instance_area
        # The UUID of the source instance.
        self.src_instance_uuid = src_instance_uuid
        # The reserved parameter.
        self.src_public_ip = src_public_ip
        # The state that indicates the operation performed for the stress testing task. Valid values:
        # 
        # * **WAIT_TARGET**: prepares the destination instance.
        # * **WAIT_DBGATEWAY**: prepares the DBGateway.
        # * **WAIT_SQL**: prepares the full SQL statistics.
        # * **WAIT_LOGIC**: prepares to replay the traffic.
        self.state = state
        # The status of the stress testing task. Valid values:
        # 
        # * **SUCCESS**: The task was successful.
        # * **IGNORED**: The task was ignored.
        # * **RUNNING**: The task is running.
        # * **EXCEPTION**: The task is abnormal.
        self.status = status
        # The name of the table that is used for stress testing.
        self.table_schema = table_schema
        # The task ID.
        self.task_id = task_id
        # The type of the stress testing task. Valid values:
        # 
        # * **pressure test** (default): A task of this type replays the traffic that is captured from the source instance on the destination instance at the maximum playback rate that is supported by the destination instance.
        # * **smart pressure test**: A task of this type analyzes the traffic that is captured from the source instance over a short period of time and generates traffic on the destination instance for continuous stress testing. The business model based on which the traffic is generated on the destination instance and the traffic distribution are consistent with those on the source instance. Stress testing tasks of this type can help you reduce the amount of time that is consumed to collect data from the source instance and reduce storage costs and performance overheads.
        self.task_type = task_type
        # The topic that contains the consumed data. This topic is a topic in Message Queue for Apache Kafka.
        self.topic = topic
        # The Alibaba Cloud account ID.
        self.user_id = user_id
        # The version of the stress testing task. Valid values:
        # 
        # * **V2.0**\
        # * **V3.0**\
        self.version = version
        # The path of the temporary directory that is generated for stress testing.
        self.work_dir = work_dir

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.archive_job_id is not None:
            result['ArchiveJobId'] = self.archive_job_id
        if self.archive_oss_table_name is not None:
            result['ArchiveOssTableName'] = self.archive_oss_table_name
        if self.archive_state is not None:
            result['ArchiveState'] = self.archive_state
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.bench_step is not None:
            result['BenchStep'] = self.bench_step
        if self.bench_step_status is not None:
            result['BenchStepStatus'] = self.bench_step_status
        if self.client_gateway_id is not None:
            result['ClientGatewayId'] = self.client_gateway_id
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.description is not None:
            result['Description'] = self.description
        if self.dst_instance_uuid is not None:
            result['DstInstanceUuid'] = self.dst_instance_uuid
        if self.dst_ip is not None:
            result['DstIp'] = self.dst_ip
        if self.dst_port is not None:
            result['DstPort'] = self.dst_port
        if self.dst_type is not None:
            result['DstType'] = self.dst_type
        if self.dts_job_class is not None:
            result['DtsJobClass'] = self.dts_job_class
        if self.dts_job_id is not None:
            result['DtsJobId'] = self.dts_job_id
        if self.dts_job_name is not None:
            result['DtsJobName'] = self.dts_job_name
        if self.dts_job_state is not None:
            result['DtsJobState'] = self.dts_job_state
        if self.dts_job_status is not None:
            result['DtsJobStatus'] = self.dts_job_status
        if self.ecs_instance_id is not None:
            result['EcsInstanceId'] = self.ecs_instance_id
        if self.end_state is not None:
            result['EndState'] = self.end_state
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.external is not None:
            result['External'] = self.external
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.request_duration is not None:
            result['RequestDuration'] = self.request_duration
        if self.smart_pressure_time is not None:
            result['SmartPressureTime'] = self.smart_pressure_time
        if self.source is not None:
            result['Source'] = self.source
        if self.sql_complete_reuse is not None:
            result['SqlCompleteReuse'] = self.sql_complete_reuse
        if self.src_instance_area is not None:
            result['SrcInstanceArea'] = self.src_instance_area
        if self.src_instance_uuid is not None:
            result['SrcInstanceUuid'] = self.src_instance_uuid
        if self.src_public_ip is not None:
            result['SrcPublicIp'] = self.src_public_ip
        if self.state is not None:
            result['State'] = self.state
        if self.status is not None:
            result['Status'] = self.status
        if self.table_schema is not None:
            result['TableSchema'] = self.table_schema
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.version is not None:
            result['Version'] = self.version
        if self.work_dir is not None:
            result['WorkDir'] = self.work_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArchiveJobId') is not None:
            self.archive_job_id = m.get('ArchiveJobId')
        if m.get('ArchiveOssTableName') is not None:
            self.archive_oss_table_name = m.get('ArchiveOssTableName')
        if m.get('ArchiveState') is not None:
            self.archive_state = m.get('ArchiveState')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('BenchStep') is not None:
            self.bench_step = m.get('BenchStep')
        if m.get('BenchStepStatus') is not None:
            self.bench_step_status = m.get('BenchStepStatus')
        if m.get('ClientGatewayId') is not None:
            self.client_gateway_id = m.get('ClientGatewayId')
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DstInstanceUuid') is not None:
            self.dst_instance_uuid = m.get('DstInstanceUuid')
        if m.get('DstIp') is not None:
            self.dst_ip = m.get('DstIp')
        if m.get('DstPort') is not None:
            self.dst_port = m.get('DstPort')
        if m.get('DstType') is not None:
            self.dst_type = m.get('DstType')
        if m.get('DtsJobClass') is not None:
            self.dts_job_class = m.get('DtsJobClass')
        if m.get('DtsJobId') is not None:
            self.dts_job_id = m.get('DtsJobId')
        if m.get('DtsJobName') is not None:
            self.dts_job_name = m.get('DtsJobName')
        if m.get('DtsJobState') is not None:
            self.dts_job_state = m.get('DtsJobState')
        if m.get('DtsJobStatus') is not None:
            self.dts_job_status = m.get('DtsJobStatus')
        if m.get('EcsInstanceId') is not None:
            self.ecs_instance_id = m.get('EcsInstanceId')
        if m.get('EndState') is not None:
            self.end_state = m.get('EndState')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('External') is not None:
            self.external = m.get('External')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('RequestDuration') is not None:
            self.request_duration = m.get('RequestDuration')
        if m.get('SmartPressureTime') is not None:
            self.smart_pressure_time = m.get('SmartPressureTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SqlCompleteReuse') is not None:
            self.sql_complete_reuse = m.get('SqlCompleteReuse')
        if m.get('SrcInstanceArea') is not None:
            self.src_instance_area = m.get('SrcInstanceArea')
        if m.get('SrcInstanceUuid') is not None:
            self.src_instance_uuid = m.get('SrcInstanceUuid')
        if m.get('SrcPublicIp') is not None:
            self.src_public_ip = m.get('SrcPublicIp')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TableSchema') is not None:
            self.table_schema = m.get('TableSchema')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('WorkDir') is not None:
            self.work_dir = m.get('WorkDir')
        return self


class DescribeCloudBenchTasksResponseBodyDataList(TeaModel):
    def __init__(
        self,
        cloudbench_tasks: List[DescribeCloudBenchTasksResponseBodyDataListCloudbenchTasks] = None,
    ):
        self.cloudbench_tasks = cloudbench_tasks

    def validate(self):
        if self.cloudbench_tasks:
            for k in self.cloudbench_tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['cloudbenchTasks'] = []
        if self.cloudbench_tasks is not None:
            for k in self.cloudbench_tasks:
                result['cloudbenchTasks'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cloudbench_tasks = []
        if m.get('cloudbenchTasks') is not None:
            for k in m.get('cloudbenchTasks'):
                temp_model = DescribeCloudBenchTasksResponseBodyDataListCloudbenchTasks()
                self.cloudbench_tasks.append(temp_model.from_map(k))
        return self


class DescribeCloudBenchTasksResponseBodyData(TeaModel):
    def __init__(
        self,
        extra: str = None,
        list: DescribeCloudBenchTasksResponseBodyDataList = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The reserved parameter.
        self.extra = extra
        # The detailed information of the stress testing task.
        self.list = list
        # The page number.
        self.page_no = page_no
        # The number of entries per page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('List') is not None:
            temp_model = DescribeCloudBenchTasksResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCloudBenchTasksResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeCloudBenchTasksResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information, including the error codes and the number of entries that are returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeCloudBenchTasksResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCloudBenchTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCloudBenchTasksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudBenchTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudbenchTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        # The ID of the stress testing task. You can call the [DescribeCloudBenchTasks](~~230670~~) operation to query the ID.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeCloudbenchTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        archive_job_id: str = None,
        archive_oss_table_name: str = None,
        archive_state: int = None,
        backup_id: str = None,
        backup_type: str = None,
        bench_step: str = None,
        bench_step_status: str = None,
        client_gateway_id: str = None,
        client_type: str = None,
        description: str = None,
        dst_instance_uuid: str = None,
        dst_ip: str = None,
        dst_port: int = None,
        dst_type: str = None,
        dts_job_class: str = None,
        dts_job_id: str = None,
        dts_job_name: str = None,
        dts_job_state: int = None,
        dts_job_status: str = None,
        ecs_instance_id: str = None,
        end_state: str = None,
        error_code: str = None,
        error_message: str = None,
        external: str = None,
        rate: int = None,
        request_duration: int = None,
        smart_pressure_time: int = None,
        source: str = None,
        sql_complete_reuse: str = None,
        src_instance_area: str = None,
        src_instance_uuid: str = None,
        src_public_ip: str = None,
        state: str = None,
        status: str = None,
        table_schema: str = None,
        task_id: str = None,
        task_type: str = None,
        topic: str = None,
        user_id: str = None,
        version: str = None,
        work_dir: str = None,
    ):
        # The ID of the archiving task.
        self.archive_job_id = archive_job_id
        # The name of the table that was archived to Object Storage Service (OSS).
        self.archive_oss_table_name = archive_oss_table_name
        # The archiving state of the file that stores the analysis result of full SQL statistics. Valid values:
        # 
        # *   **0**: The file archiving is not started.
        # *   **1**: The file is archived.
        # *   **2**: An error occurred.
        # *   **3**: The file is being archived.
        # *   **4**: The archived file does not need to be downloaded.
        self.archive_state = archive_state
        # The ID of the backup set. You can call the [DescribeBackups](~~26273~~) operation to query the ID of the backup set.
        self.backup_id = backup_id
        # The backup type. Valid values:
        # 
        # *   **TIMESTAMP**\
        # *   **BACKUPID**\
        self.backup_type = backup_type
        # The substep in the stress testing task. Valid values:
        # 
        # *   **NEW**: initializes the stress testing task.
        # *   **WAIT_BUY_ECS**: purchases an ECS instance.
        # *   **WAIT_START_ECS**: starts an ECS instance.
        # *   **WAIT_INSTALL_JDK**: installs the Java Development Kit (JDK).
        # *   **WAIT_INSTALL_DBGATEWAY**: installs the database gateway (DBGateway).
        # *   **ADD_SECURITY_IPS_STEP**: configure a security group whitelist.
        # *   **ARCHIVE**: archives the full SQL statistics.
        # *   **DOWNLOAD**: downloads the file that stores the analysis result of full SQL statistics.
        # *   **PROCEED**: preprocesses the file that stores the analysis result of full SQL statistics.
        # *   **PRE_LOAD**: preloads the file that stores the analysis result of full SQL statistics.
        # *   **VALIDATE**: verifies the functionality of stress testing.
        # *   **PRESSURE**: starts the stress testing task.
        self.bench_step = bench_step
        # The status that indicates the substep performed on the stress testing task. Valid values:
        # 
        # *   **NEW**: The task is being initialized.
        # *   **RUNNING**: The task is running.
        # *   **FAILED**: The task failed.
        # *   **FINISHED**: The task is complete.
        # *   **Terminated**: The task is terminated.
        # *   **Deleted**: The task is deleted.
        self.bench_step_status = bench_step_status
        # The DBGateway ID of the stress testing client.
        self.client_gateway_id = client_gateway_id
        # The type of the stress testing client. Valid values:
        # 
        # *   **ECS**: indicates that you must create the [DBGateway](~~64905~~).
        # *   **DAS_ECS**: indicates that DAS automatically purchases and deploys an ECS instance for stress testing.
        self.client_type = client_type
        # The description of the stress testing task.
        self.description = description
        # The UUID of the destination instance.
        self.dst_instance_uuid = dst_instance_uuid
        # The reserved parameter.
        self.dst_ip = dst_ip
        # The port number of the destination instance.
        self.dst_port = dst_port
        # The type of the identifier that is used to indicate the destination instance. Valid values:
        # 
        # *   **Instance** (default): the instance ID.
        # *   **ConnectionString**: the endpoint of the instance.
        self.dst_type = dst_type
        # The specification of the DTS task.
        self.dts_job_class = dts_job_class
        # The ID of the DTS migration task.
        self.dts_job_id = dts_job_id
        # The name of the Data Transmission Service (DTS) task.
        self.dts_job_name = dts_job_name
        # The state of the DTS task. Valid values:
        # 
        # *   **NOT_STARTED**: The task is not started.
        # *   **PRE_CHECKING**: The task is in precheck.
        # *   **PRE_CHECK_FAILED**: The precheck failed.
        # *   **CHECKING**: The task is being checked.
        # *   **MIGRATING**: The data is being migrated.
        # *   **CATCHED**: The data is migrated from the source instance to the destination instance.
        # *   **SUSPENDING**: The task is suspended.
        # *   **MIGRATION_FAILED**: The data failed to be migrated.
        # *   **FINISHED**: The task is complete.
        # *   **INITIALIZING**: The synchronization is being initialized.
        # *   **INITIALIZE_FAILED**: The synchronization failed to be initialized.
        # *   **SYNCHRONIZING**: The data is being synchronized.
        # *   **MODIFYING**: The objects to be synchronized are being changed.
        # *   **SWITCHING**: The roles of the instances are being switched.
        # *   **FAILED**: The task failed.
        self.dts_job_state = dts_job_state
        # The state of the DTS task. Valid values:
        # 
        # *   **NOT_STARTED**: The task is not started.
        # *   **PRE_CHECKING**: The task is in precheck.
        # *   **PRE_CHECK_FAILED**: The precheck failed.
        # *   **CHECKING**: The task is being checked.
        # *   **MIGRATING**: The data is being migrated.
        # *   **CATCHED**: The data is migrated from the source instance to the destination instance.
        # *   **SUSPENDING**: The task is suspended.
        # *   **MIGRATION_FAILED**: The data failed to be migrated.
        # *   **FINISHED**: The task is complete.
        # *   **INITIALIZING**: The synchronization is being initialized.
        # *   **INITIALIZE_FAILED**: The synchronization failed to be initialized.
        # *   **SYNCHRONIZING**: The data is being synchronized.
        # *   **MODIFYING**: The objects to be synchronized are being changed.
        # *   **SWITCHING**: The roles of the instances are being switched.
        # *   **FAILED**: The task failed.
        self.dts_job_status = dts_job_status
        # The ID of the Elastic Compute Service (ECS) instance.
        self.ecs_instance_id = ecs_instance_id
        # The state that specifies the last operation that is performed for the stress testing task. Valid values:
        # 
        # *   **WAIT_TARGET**: prepares the destination instance.
        # *   **WAIT_DBGATEWAY**: prepares the DBGateway.
        # *   **WAIT_SQL**: prepares the full SQL statistics.
        # *   **WAIT_LOGIC**: prepares to replay the traffic.
        # 
        # >  When the state of a stress testing task changes to the state that is specified by the EndState parameter, the stress testing task becomes completed.
        self.end_state = end_state
        # The error code returned for the substep of the stress testing task.
        self.error_code = error_code
        # The error message returned if the request failed.
        self.error_message = error_message
        # The additional information.
        self.external = external
        # The rate at which the stress testing task replayed the traffic. The value is a positive integer. Valid values:**1** to **30**. Default value: **1**.
        self.rate = rate
        # The duration of the stress testing task for which traffic was captured from the source instance.
        self.request_duration = request_duration
        # The duration of the stress testing task for which the traffic was generated on the destination instance. Unit: milliseconds.
        self.smart_pressure_time = smart_pressure_time
        # The source of the task. Valid values:
        # 
        # *   **DAS**\
        # *   **OPEN_API**\
        self.source = source
        # The reuse information about the analysis result of full SQL statistics.
        self.sql_complete_reuse = sql_complete_reuse
        # The database type of the source instance. Valid values:
        self.src_instance_area = src_instance_area
        # The UUID of the source instance.
        self.src_instance_uuid = src_instance_uuid
        # The reserved parameter.
        self.src_public_ip = src_public_ip
        # The state that indicates the operation performed for the stress testing task. Valid values:
        # 
        # *   **WAIT_TARGET**: prepares the destination instance.
        # *   **WAIT_DBGATEWAY**: prepares the DBGateway.
        # *   **WAIT_SQL**: prepares the full SQL statistics.
        # *   **WAIT_LOGIC**: prepares to replay the traffic.
        self.state = state
        # The state of the stress testing task. Valid values:
        # 
        # *   **SUCCESS**: The task is successful.
        # *   **IGNORED**: The task is ignored.
        # *   **RUNNING**: The task is running.
        # *   **EXCEPTION**: An error occurred.
        self.status = status
        # The name of the table that is used for stress testing.
        self.table_schema = table_schema
        # The task ID.
        self.task_id = task_id
        # The type of the stress testing task. Valid values:
        # 
        # *   **pressure test** (default): A task of this type replays the traffic that is captured from the source instance on the destination instance at the maximum playback rate that is supported by the destination instance.
        # *   **smart pressure test**: A task of this type analyzes the traffic that is captured from the source instance over a short period of time and generates traffic on the destination instance for continuous stress testing. The business model based on which the traffic is generated on the destination instance and the traffic distribution are consistent with those on the source instance. Stress testing tasks of this type can help you reduce the amount of time that is consumed to collect data from the source instance and reduce storage costs and performance overheads.
        self.task_type = task_type
        # The topic that contains the consumed data. This topic is a topic in Message Queue for Apache Kafka.
        self.topic = topic
        # The ID of the Alibaba Cloud account.
        self.user_id = user_id
        # The version of the stress testing task. Valid values:
        # 
        # *   **V2.0**\
        # *   **V3.0**\
        self.version = version
        # The temporary directory generated for stress testing.
        self.work_dir = work_dir

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.archive_job_id is not None:
            result['ArchiveJobId'] = self.archive_job_id
        if self.archive_oss_table_name is not None:
            result['ArchiveOssTableName'] = self.archive_oss_table_name
        if self.archive_state is not None:
            result['ArchiveState'] = self.archive_state
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.bench_step is not None:
            result['BenchStep'] = self.bench_step
        if self.bench_step_status is not None:
            result['BenchStepStatus'] = self.bench_step_status
        if self.client_gateway_id is not None:
            result['ClientGatewayId'] = self.client_gateway_id
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.description is not None:
            result['Description'] = self.description
        if self.dst_instance_uuid is not None:
            result['DstInstanceUuid'] = self.dst_instance_uuid
        if self.dst_ip is not None:
            result['DstIp'] = self.dst_ip
        if self.dst_port is not None:
            result['DstPort'] = self.dst_port
        if self.dst_type is not None:
            result['DstType'] = self.dst_type
        if self.dts_job_class is not None:
            result['DtsJobClass'] = self.dts_job_class
        if self.dts_job_id is not None:
            result['DtsJobId'] = self.dts_job_id
        if self.dts_job_name is not None:
            result['DtsJobName'] = self.dts_job_name
        if self.dts_job_state is not None:
            result['DtsJobState'] = self.dts_job_state
        if self.dts_job_status is not None:
            result['DtsJobStatus'] = self.dts_job_status
        if self.ecs_instance_id is not None:
            result['EcsInstanceId'] = self.ecs_instance_id
        if self.end_state is not None:
            result['EndState'] = self.end_state
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.external is not None:
            result['External'] = self.external
        if self.rate is not None:
            result['Rate'] = self.rate
        if self.request_duration is not None:
            result['RequestDuration'] = self.request_duration
        if self.smart_pressure_time is not None:
            result['SmartPressureTime'] = self.smart_pressure_time
        if self.source is not None:
            result['Source'] = self.source
        if self.sql_complete_reuse is not None:
            result['SqlCompleteReuse'] = self.sql_complete_reuse
        if self.src_instance_area is not None:
            result['SrcInstanceArea'] = self.src_instance_area
        if self.src_instance_uuid is not None:
            result['SrcInstanceUuid'] = self.src_instance_uuid
        if self.src_public_ip is not None:
            result['SrcPublicIp'] = self.src_public_ip
        if self.state is not None:
            result['State'] = self.state
        if self.status is not None:
            result['Status'] = self.status
        if self.table_schema is not None:
            result['TableSchema'] = self.table_schema
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.version is not None:
            result['Version'] = self.version
        if self.work_dir is not None:
            result['WorkDir'] = self.work_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArchiveJobId') is not None:
            self.archive_job_id = m.get('ArchiveJobId')
        if m.get('ArchiveOssTableName') is not None:
            self.archive_oss_table_name = m.get('ArchiveOssTableName')
        if m.get('ArchiveState') is not None:
            self.archive_state = m.get('ArchiveState')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('BenchStep') is not None:
            self.bench_step = m.get('BenchStep')
        if m.get('BenchStepStatus') is not None:
            self.bench_step_status = m.get('BenchStepStatus')
        if m.get('ClientGatewayId') is not None:
            self.client_gateway_id = m.get('ClientGatewayId')
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DstInstanceUuid') is not None:
            self.dst_instance_uuid = m.get('DstInstanceUuid')
        if m.get('DstIp') is not None:
            self.dst_ip = m.get('DstIp')
        if m.get('DstPort') is not None:
            self.dst_port = m.get('DstPort')
        if m.get('DstType') is not None:
            self.dst_type = m.get('DstType')
        if m.get('DtsJobClass') is not None:
            self.dts_job_class = m.get('DtsJobClass')
        if m.get('DtsJobId') is not None:
            self.dts_job_id = m.get('DtsJobId')
        if m.get('DtsJobName') is not None:
            self.dts_job_name = m.get('DtsJobName')
        if m.get('DtsJobState') is not None:
            self.dts_job_state = m.get('DtsJobState')
        if m.get('DtsJobStatus') is not None:
            self.dts_job_status = m.get('DtsJobStatus')
        if m.get('EcsInstanceId') is not None:
            self.ecs_instance_id = m.get('EcsInstanceId')
        if m.get('EndState') is not None:
            self.end_state = m.get('EndState')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('External') is not None:
            self.external = m.get('External')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        if m.get('RequestDuration') is not None:
            self.request_duration = m.get('RequestDuration')
        if m.get('SmartPressureTime') is not None:
            self.smart_pressure_time = m.get('SmartPressureTime')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SqlCompleteReuse') is not None:
            self.sql_complete_reuse = m.get('SqlCompleteReuse')
        if m.get('SrcInstanceArea') is not None:
            self.src_instance_area = m.get('SrcInstanceArea')
        if m.get('SrcInstanceUuid') is not None:
            self.src_instance_uuid = m.get('SrcInstanceUuid')
        if m.get('SrcPublicIp') is not None:
            self.src_public_ip = m.get('SrcPublicIp')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TableSchema') is not None:
            self.table_schema = m.get('TableSchema')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('WorkDir') is not None:
            self.work_dir = m.get('WorkDir')
        return self


class DescribeCloudbenchTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeCloudbenchTaskResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information, including the error codes and the number of entries that are returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeCloudbenchTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCloudbenchTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCloudbenchTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudbenchTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudbenchTaskConfigRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        # The task ID. You can call the [DescribeCloudBenchTasks](~~230670~~) operation to query the task ID.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeCloudbenchTaskConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        archive_folder: str = None,
        bench_cmd: str = None,
        client_jar_path: str = None,
        jar_on_oss: str = None,
        load_cmd: str = None,
        meta_file_name: str = None,
        meta_file_on_oss: str = None,
        meta_file_path: str = None,
        parse_cmd: str = None,
        parse_file_path: str = None,
        rocks_db_path: str = None,
        sql_file_name: str = None,
        sql_file_on_oss: str = None,
        sql_file_path: str = None,
        task_id: str = None,
        user_id: str = None,
        work_dir: str = None,
    ):
        # The path in which the files are archived.
        self.archive_folder = archive_folder
        # The command that was run to start the stress testing task.
        self.bench_cmd = bench_cmd
        # The path to the JAR file that is used for stress testing.
        self.client_jar_path = client_jar_path
        # The path to the JAR file that is stored in OSS. The JAR file is used for stress testing.
        self.jar_on_oss = jar_on_oss
        # The command that was run to preload the file that stores the analysis result of full SQL statistics.
        self.load_cmd = load_cmd
        # The name of the metadata file.
        self.meta_file_name = meta_file_name
        # The name of the metadata file stored in Object Storage Service (OSS).
        self.meta_file_on_oss = meta_file_on_oss
        # The path to the metadata file.
        self.meta_file_path = meta_file_path
        # The command that was run to parse the file that stores the analysis result of full SQL statistics.
        self.parse_cmd = parse_cmd
        # The path to the file that is parsed. The file stores the analysis result of full SQL statistics.
        self.parse_file_path = parse_file_path
        # The location where the RocksDB storage system is deployed in the stress testing client.
        self.rocks_db_path = rocks_db_path
        # The name of the file that stores the analysis result of full SQL statistics.
        self.sql_file_name = sql_file_name
        # The name of the file that stores the analysis result of full SQL statistics and that is stored in OSS.
        self.sql_file_on_oss = sql_file_on_oss
        # The path to the file that stores the analysis result of full SQL statistics.
        self.sql_file_path = sql_file_path
        # The task ID.
        self.task_id = task_id
        # The Alibaba Cloud account ID.
        self.user_id = user_id
        # The path of the temporary directory that is generated for stress testing.
        self.work_dir = work_dir

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.archive_folder is not None:
            result['ArchiveFolder'] = self.archive_folder
        if self.bench_cmd is not None:
            result['BenchCmd'] = self.bench_cmd
        if self.client_jar_path is not None:
            result['ClientJarPath'] = self.client_jar_path
        if self.jar_on_oss is not None:
            result['JarOnOss'] = self.jar_on_oss
        if self.load_cmd is not None:
            result['LoadCmd'] = self.load_cmd
        if self.meta_file_name is not None:
            result['MetaFileName'] = self.meta_file_name
        if self.meta_file_on_oss is not None:
            result['MetaFileOnOss'] = self.meta_file_on_oss
        if self.meta_file_path is not None:
            result['MetaFilePath'] = self.meta_file_path
        if self.parse_cmd is not None:
            result['ParseCmd'] = self.parse_cmd
        if self.parse_file_path is not None:
            result['ParseFilePath'] = self.parse_file_path
        if self.rocks_db_path is not None:
            result['RocksDbPath'] = self.rocks_db_path
        if self.sql_file_name is not None:
            result['SqlFileName'] = self.sql_file_name
        if self.sql_file_on_oss is not None:
            result['SqlFileOnOss'] = self.sql_file_on_oss
        if self.sql_file_path is not None:
            result['SqlFilePath'] = self.sql_file_path
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.work_dir is not None:
            result['WorkDir'] = self.work_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ArchiveFolder') is not None:
            self.archive_folder = m.get('ArchiveFolder')
        if m.get('BenchCmd') is not None:
            self.bench_cmd = m.get('BenchCmd')
        if m.get('ClientJarPath') is not None:
            self.client_jar_path = m.get('ClientJarPath')
        if m.get('JarOnOss') is not None:
            self.jar_on_oss = m.get('JarOnOss')
        if m.get('LoadCmd') is not None:
            self.load_cmd = m.get('LoadCmd')
        if m.get('MetaFileName') is not None:
            self.meta_file_name = m.get('MetaFileName')
        if m.get('MetaFileOnOss') is not None:
            self.meta_file_on_oss = m.get('MetaFileOnOss')
        if m.get('MetaFilePath') is not None:
            self.meta_file_path = m.get('MetaFilePath')
        if m.get('ParseCmd') is not None:
            self.parse_cmd = m.get('ParseCmd')
        if m.get('ParseFilePath') is not None:
            self.parse_file_path = m.get('ParseFilePath')
        if m.get('RocksDbPath') is not None:
            self.rocks_db_path = m.get('RocksDbPath')
        if m.get('SqlFileName') is not None:
            self.sql_file_name = m.get('SqlFileName')
        if m.get('SqlFileOnOss') is not None:
            self.sql_file_on_oss = m.get('SqlFileOnOss')
        if m.get('SqlFilePath') is not None:
            self.sql_file_path = m.get('SqlFilePath')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WorkDir') is not None:
            self.work_dir = m.get('WorkDir')
        return self


class DescribeCloudbenchTaskConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeCloudbenchTaskConfigResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information, including the error codes and the number of entries that are returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeCloudbenchTaskConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCloudbenchTaskConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCloudbenchTaskConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudbenchTaskConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDiagnosticReportListRequest(TeaModel):
    def __init__(
        self,
        dbinstance_id: str = None,
        end_time: str = None,
        page_no: str = None,
        page_size: str = None,
        start_time: str = None,
    ):
        # The instance ID.
        self.dbinstance_id = dbinstance_id
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time
        # The page number. The value must be a positive integer. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDiagnosticReportListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
        synchro: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The information of the diagnostics reports. Valid values:
        # 
        # *   **total**: the number of diagnostics reports.
        # *   **score**: the health score.
        # *   **diagnosticTime**: the time when the diagnostics report was generated. The time is displayed in UTC.
        # *   **startTime**: the start time of the query. The time is displayed in UTC.
        # *   **endTime**: the end time of the query. The time is displayed in UTC.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success
        # The reserved parameter.
        self.synchro = synchro

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.synchro is not None:
            result['Synchro'] = self.synchro
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Synchro') is not None:
            self.synchro = m.get('Synchro')
        return self


class DescribeDiagnosticReportListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDiagnosticReportListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDiagnosticReportListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHotBigKeysRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        instance_id: str = None,
        node_id: str = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The ID of the ApsaraDB for Redis instance. You can call the [DescribeInstances](~~60933~~) operation to query the ID.
        self.instance_id = instance_id
        # The ID of the data shard on the ApsaraDB for Redis instance. You can call the [DescribeRoleZoneInfo](~~190794~~) operation to query the ID.
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class DescribeHotBigKeysResponseBodyDataBigKeysBigKey(TeaModel):
    def __init__(
        self,
        db: int = None,
        key: str = None,
        key_type: str = None,
        node_id: str = None,
        size: int = None,
    ):
        # The database in which the key is stored.
        self.db = db
        # The key.
        self.key = key
        # The type of the key.
        self.key_type = key_type
        # The ID of the data shard on the ApsaraDB for Redis instance.
        self.node_id = node_id
        # The number of elements in the key.
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db is not None:
            result['Db'] = self.db
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class DescribeHotBigKeysResponseBodyDataBigKeys(TeaModel):
    def __init__(
        self,
        big_key: List[DescribeHotBigKeysResponseBodyDataBigKeysBigKey] = None,
    ):
        self.big_key = big_key

    def validate(self):
        if self.big_key:
            for k in self.big_key:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BigKey'] = []
        if self.big_key is not None:
            for k in self.big_key:
                result['BigKey'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.big_key = []
        if m.get('BigKey') is not None:
            for k in m.get('BigKey'):
                temp_model = DescribeHotBigKeysResponseBodyDataBigKeysBigKey()
                self.big_key.append(temp_model.from_map(k))
        return self


class DescribeHotBigKeysResponseBodyDataHotKeysHotKey(TeaModel):
    def __init__(
        self,
        db: int = None,
        hot: str = None,
        key: str = None,
        key_type: str = None,
        lfu: int = None,
        node_id: str = None,
    ):
        # The database in which the key is stored.
        self.db = db
        # The frequency at which the key is accessed, which indicates the queries per second (QPS) of the key.
        self.hot = hot
        # The key.
        self.key = key
        # The type of the key.
        self.key_type = key_type
        # The statistical value that is calculated based on the least frequently used (LFU) caching algorithm.
        self.lfu = lfu
        # The ID of the data shard on the ApsaraDB for Redis instance.
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db is not None:
            result['Db'] = self.db
        if self.hot is not None:
            result['Hot'] = self.hot
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.lfu is not None:
            result['Lfu'] = self.lfu
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('Hot') is not None:
            self.hot = m.get('Hot')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('Lfu') is not None:
            self.lfu = m.get('Lfu')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class DescribeHotBigKeysResponseBodyDataHotKeys(TeaModel):
    def __init__(
        self,
        hot_key: List[DescribeHotBigKeysResponseBodyDataHotKeysHotKey] = None,
    ):
        self.hot_key = hot_key

    def validate(self):
        if self.hot_key:
            for k in self.hot_key:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HotKey'] = []
        if self.hot_key is not None:
            for k in self.hot_key:
                result['HotKey'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.hot_key = []
        if m.get('HotKey') is not None:
            for k in m.get('HotKey'):
                temp_model = DescribeHotBigKeysResponseBodyDataHotKeysHotKey()
                self.hot_key.append(temp_model.from_map(k))
        return self


class DescribeHotBigKeysResponseBodyData(TeaModel):
    def __init__(
        self,
        big_key_msg: str = None,
        big_keys: DescribeHotBigKeysResponseBodyDataBigKeys = None,
        hot_key_msg: str = None,
        hot_keys: DescribeHotBigKeysResponseBodyDataHotKeys = None,
    ):
        # The reason why the large key failed to be queried.
        self.big_key_msg = big_key_msg
        # The list of large keys.
        self.big_keys = big_keys
        # The reason why the hot key failed to be queried.
        self.hot_key_msg = hot_key_msg
        # The list of hot keys.
        self.hot_keys = hot_keys

    def validate(self):
        if self.big_keys:
            self.big_keys.validate()
        if self.hot_keys:
            self.hot_keys.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.big_key_msg is not None:
            result['BigKeyMsg'] = self.big_key_msg
        if self.big_keys is not None:
            result['BigKeys'] = self.big_keys.to_map()
        if self.hot_key_msg is not None:
            result['HotKeyMsg'] = self.hot_key_msg
        if self.hot_keys is not None:
            result['HotKeys'] = self.hot_keys.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BigKeyMsg') is not None:
            self.big_key_msg = m.get('BigKeyMsg')
        if m.get('BigKeys') is not None:
            temp_model = DescribeHotBigKeysResponseBodyDataBigKeys()
            self.big_keys = temp_model.from_map(m['BigKeys'])
        if m.get('HotKeyMsg') is not None:
            self.hot_key_msg = m.get('HotKeyMsg')
        if m.get('HotKeys') is not None:
            temp_model = DescribeHotBigKeysResponseBodyDataHotKeys()
            self.hot_keys = temp_model.from_map(m['HotKeys'])
        return self


class DescribeHotBigKeysResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeHotBigKeysResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The list of hot keys and large keys.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeHotBigKeysResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeHotBigKeysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHotBigKeysResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHotBigKeysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHotKeysRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        node_id: str = None,
    ):
        # The ID of the ApsaraDB for Redis instance. You can call the [DescribeInstances](~~60933~~) operation to query the instance ID.
        self.instance_id = instance_id
        # The ID of the data shard on the ApsaraDB for Redis instance. You can call the [DescribeRoleZoneInfo](~~190794~~) operation to query the data shard ID.
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class DescribeHotKeysResponseBodyDataHotKey(TeaModel):
    def __init__(
        self,
        db: int = None,
        hot: str = None,
        key: str = None,
        key_type: str = None,
        size: int = None,
    ):
        # The database in which the key is stored.
        self.db = db
        # The frequency at which the key is accessed, which indicates the queries per second (QPS) of the key.
        self.hot = hot
        # The name of the key.
        self.key = key
        # The type of the key.
        self.key_type = key_type
        # The number of elements in the key.
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db is not None:
            result['Db'] = self.db
        if self.hot is not None:
            result['Hot'] = self.hot
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('Hot') is not None:
            self.hot = m.get('Hot')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class DescribeHotKeysResponseBodyData(TeaModel):
    def __init__(
        self,
        hot_key: List[DescribeHotKeysResponseBodyDataHotKey] = None,
    ):
        self.hot_key = hot_key

    def validate(self):
        if self.hot_key:
            for k in self.hot_key:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HotKey'] = []
        if self.hot_key is not None:
            for k in self.hot_key:
                result['HotKey'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.hot_key = []
        if m.get('HotKey') is not None:
            for k in m.get('HotKey'):
                temp_model = DescribeHotKeysResponseBodyDataHotKey()
                self.hot_key.append(temp_model.from_map(k))
        return self


class DescribeHotKeysResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeHotKeysResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The details of the hot keys.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeHotKeysResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeHotKeysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHotKeysResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHotKeysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceDasProRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The database instance ID.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeInstanceDasProResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # Indicates whether DAS Professional Edition is enabled for the database instance.
        # 
        # *   **true**\
        # *   **false**\
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeInstanceDasProResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceDasProResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceDasProResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTopBigKeysRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        end_time: str = None,
        instance_id: str = None,
        node_id: str = None,
        start_time: str = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # > 
        # 
        # *   The end time must be later than the start time.
        # 
        # *   Only data within the last four days can be queried.
        # 
        # *   The maximum interval between the **start time** and the** end time** is 3 hours.
        self.end_time = end_time
        # The ID of the ApsaraDB for Redis instance. You can call the [DescribeInstances](~~60933~~) operation to query the ID.
        self.instance_id = instance_id
        # The ID of the data shard on the ApsaraDB for Redis instance. You can call the [DescribeRoleZoneInfo](~~190794~~) operation to query the ID.
        self.node_id = node_id
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeTopBigKeysResponseBodyDataBigKey(TeaModel):
    def __init__(
        self,
        db: int = None,
        key: str = None,
        key_type: str = None,
        node_id: str = None,
        size: int = None,
    ):
        # The database in which the key is stored.
        self.db = db
        # The key.
        self.key = key
        # The type of the key.
        self.key_type = key_type
        # The ID of the data shard on the ApsaraDB for Redis instance.
        self.node_id = node_id
        # The number of elements in the key.
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db is not None:
            result['Db'] = self.db
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class DescribeTopBigKeysResponseBodyData(TeaModel):
    def __init__(
        self,
        big_key: List[DescribeTopBigKeysResponseBodyDataBigKey] = None,
    ):
        self.big_key = big_key

    def validate(self):
        if self.big_key:
            for k in self.big_key:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BigKey'] = []
        if self.big_key is not None:
            for k in self.big_key:
                result['BigKey'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.big_key = []
        if m.get('BigKey') is not None:
            for k in m.get('BigKey'):
                temp_model = DescribeTopBigKeysResponseBodyDataBigKey()
                self.big_key.append(temp_model.from_map(k))
        return self


class DescribeTopBigKeysResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeTopBigKeysResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information about the large keys.
        # 
        # > This parameter is left empty If no large keys exist within the specified time range.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeTopBigKeysResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeTopBigKeysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeTopBigKeysResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeTopBigKeysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTopHotKeysRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        end_time: str = None,
        instance_id: str = None,
        node_id: str = None,
        start_time: str = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # > 
        # 
        # *   The end time must be later than the start time.
        # 
        # *   Only data within the last four days can be queried.
        # 
        # *   The maximum interval between the **start time** and the** end time** is 3 hours.
        self.end_time = end_time
        # The ID of the ApsaraDB for Redis instance. You can call the [DescribeInstances](~~60933~~) operation to query the ID.
        self.instance_id = instance_id
        # The ID of the data shard on the ApsaraDB for Redis instance. You can call the [DescribeRoleZoneInfo](~~190794~~) operation to query the ID.
        self.node_id = node_id
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeTopHotKeysResponseBodyDataHotKey(TeaModel):
    def __init__(
        self,
        db: int = None,
        hot: str = None,
        key: str = None,
        key_type: str = None,
        lfu: int = None,
        node_id: str = None,
    ):
        # The database in which the key is stored.
        self.db = db
        # The frequency at which the key is accessed, which indicates the QPS of the key.
        self.hot = hot
        # The key.
        self.key = key
        # The type of the key.
        self.key_type = key_type
        # The statistical value that is calculated based on the least frequently used (LFU) caching algorithm.
        self.lfu = lfu
        # The ID of the data shard on the ApsaraDB for Redis instance.
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db is not None:
            result['Db'] = self.db
        if self.hot is not None:
            result['Hot'] = self.hot
        if self.key is not None:
            result['Key'] = self.key
        if self.key_type is not None:
            result['KeyType'] = self.key_type
        if self.lfu is not None:
            result['Lfu'] = self.lfu
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('Hot') is not None:
            self.hot = m.get('Hot')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('KeyType') is not None:
            self.key_type = m.get('KeyType')
        if m.get('Lfu') is not None:
            self.lfu = m.get('Lfu')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class DescribeTopHotKeysResponseBodyData(TeaModel):
    def __init__(
        self,
        hot_key: List[DescribeTopHotKeysResponseBodyDataHotKey] = None,
    ):
        self.hot_key = hot_key

    def validate(self):
        if self.hot_key:
            for k in self.hot_key:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HotKey'] = []
        if self.hot_key is not None:
            for k in self.hot_key:
                result['HotKey'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.hot_key = []
        if m.get('HotKey') is not None:
            for k in m.get('HotKey'):
                temp_model = DescribeTopHotKeysResponseBodyDataHotKey()
                self.hot_key.append(temp_model.from_map(k))
        return self


class DescribeTopHotKeysResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeTopHotKeysResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information about the hot keys.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeTopHotKeysResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeTopHotKeysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeTopHotKeysResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeTopHotKeysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableAllSqlConcurrencyControlRulesRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        instance_id: str = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The instance ID.
        # 
        # >  You must specify this parameter only if your database instance is an ApsaraDB RDS for MySQL instance or a PolarDB for MySQL cluster.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DisableAllSqlConcurrencyControlRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The reserved parameter.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message that contains information such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableAllSqlConcurrencyControlRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableAllSqlConcurrencyControlRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableAllSqlConcurrencyControlRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableAutoResourceOptimizeRulesRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        instance_ids: str = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The database instance ID.
        # 
        # >  Set this parameter to a JSON array that consists of multiple instance IDs. Separate instance IDs with commas (,). Example: `[\"Instance ID1\", \"Instance ID2\"]`.
        self.instance_ids = instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        return self


class DisableAutoResourceOptimizeRulesResponseBodyDataConfigFailInstanceList(TeaModel):
    def __init__(
        self,
        config_success: bool = None,
        error_message: str = None,
        instance_id: str = None,
    ):
        # Indicates whether the automatic tablespace fragment recycling feature is disabled. Valid values:
        # 
        # * **true**\
        # 
        # * **false**\
        self.config_success = config_success
        # The error message returned if the request failed.
        self.error_message = error_message
        # The database instance ID.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_success is not None:
            result['ConfigSuccess'] = self.config_success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigSuccess') is not None:
            self.config_success = m.get('ConfigSuccess')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DisableAutoResourceOptimizeRulesResponseBodyDataConfigSuccessInstanceList(TeaModel):
    def __init__(
        self,
        config_success: bool = None,
        instance_id: str = None,
    ):
        # Indicates whether the automatic tablespace fragment recycling feature is disabled. Valid values:
        # 
        # * **true**\
        # 
        # * **false**\
        self.config_success = config_success
        # The database instance ID.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_success is not None:
            result['ConfigSuccess'] = self.config_success
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigSuccess') is not None:
            self.config_success = m.get('ConfigSuccess')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DisableAutoResourceOptimizeRulesResponseBodyData(TeaModel):
    def __init__(
        self,
        config_fail_instance_count: int = None,
        config_fail_instance_list: List[DisableAutoResourceOptimizeRulesResponseBodyDataConfigFailInstanceList] = None,
        config_success_instance_count: int = None,
        config_success_instance_list: List[DisableAutoResourceOptimizeRulesResponseBodyDataConfigSuccessInstanceList] = None,
        total_instance_count: int = None,
    ):
        # The number of database instances for which the automatic tablespace fragment recycling feature failed to be disabled.
        self.config_fail_instance_count = config_fail_instance_count
        # The list of database instances for which the automatic tablespace fragment recycling feature failed to be disabled.
        self.config_fail_instance_list = config_fail_instance_list
        # The number of database instances for which the automatic tablespace fragment recycling feature is disabled.
        self.config_success_instance_count = config_success_instance_count
        # The list of database instances for which the automatic tablespace fragment recycling feature is disabled.
        self.config_success_instance_list = config_success_instance_list
        # The total number of database instances.
        self.total_instance_count = total_instance_count

    def validate(self):
        if self.config_fail_instance_list:
            for k in self.config_fail_instance_list:
                if k:
                    k.validate()
        if self.config_success_instance_list:
            for k in self.config_success_instance_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_fail_instance_count is not None:
            result['ConfigFailInstanceCount'] = self.config_fail_instance_count
        result['ConfigFailInstanceList'] = []
        if self.config_fail_instance_list is not None:
            for k in self.config_fail_instance_list:
                result['ConfigFailInstanceList'].append(k.to_map() if k else None)
        if self.config_success_instance_count is not None:
            result['ConfigSuccessInstanceCount'] = self.config_success_instance_count
        result['ConfigSuccessInstanceList'] = []
        if self.config_success_instance_list is not None:
            for k in self.config_success_instance_list:
                result['ConfigSuccessInstanceList'].append(k.to_map() if k else None)
        if self.total_instance_count is not None:
            result['TotalInstanceCount'] = self.total_instance_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigFailInstanceCount') is not None:
            self.config_fail_instance_count = m.get('ConfigFailInstanceCount')
        self.config_fail_instance_list = []
        if m.get('ConfigFailInstanceList') is not None:
            for k in m.get('ConfigFailInstanceList'):
                temp_model = DisableAutoResourceOptimizeRulesResponseBodyDataConfigFailInstanceList()
                self.config_fail_instance_list.append(temp_model.from_map(k))
        if m.get('ConfigSuccessInstanceCount') is not None:
            self.config_success_instance_count = m.get('ConfigSuccessInstanceCount')
        self.config_success_instance_list = []
        if m.get('ConfigSuccessInstanceList') is not None:
            for k in m.get('ConfigSuccessInstanceList'):
                temp_model = DisableAutoResourceOptimizeRulesResponseBodyDataConfigSuccessInstanceList()
                self.config_success_instance_list.append(temp_model.from_map(k))
        if m.get('TotalInstanceCount') is not None:
            self.total_instance_count = m.get('TotalInstanceCount')
        return self


class DisableAutoResourceOptimizeRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: DisableAutoResourceOptimizeRulesResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DisableAutoResourceOptimizeRulesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableAutoResourceOptimizeRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableAutoResourceOptimizeRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableAutoResourceOptimizeRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableAutoThrottleRulesRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        instance_ids: str = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The database instance IDs.
        # 
        # >  Set this parameter to a JSON array that consists of multiple instance IDs. Separate instance IDs with commas (,). Example: `[\"Instance ID1\",\"Instance ID2\"]`.
        self.instance_ids = instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        return self


class DisableAutoThrottleRulesResponseBodyDataConfigFailInstanceList(TeaModel):
    def __init__(
        self,
        config_success: bool = None,
        error_message: str = None,
        instance_id: str = None,
    ):
        # Indicates whether the automatic SQL throttling feature is disabled. Valid values:
        # 
        # * **true**\
        # 
        # * **false**\
        self.config_success = config_success
        # The error message returned.
        self.error_message = error_message
        # The database instance ID.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_success is not None:
            result['ConfigSuccess'] = self.config_success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigSuccess') is not None:
            self.config_success = m.get('ConfigSuccess')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DisableAutoThrottleRulesResponseBodyDataConfigSuccessInstanceList(TeaModel):
    def __init__(
        self,
        config_success: bool = None,
        instance_id: str = None,
    ):
        # Indicates whether the automatic SQL throttling feature is disabled. Valid values:
        # 
        # * **true**\
        # 
        # * **false**\
        self.config_success = config_success
        # The database instance ID.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_success is not None:
            result['ConfigSuccess'] = self.config_success
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigSuccess') is not None:
            self.config_success = m.get('ConfigSuccess')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DisableAutoThrottleRulesResponseBodyData(TeaModel):
    def __init__(
        self,
        config_fail_instance_count: int = None,
        config_fail_instance_list: List[DisableAutoThrottleRulesResponseBodyDataConfigFailInstanceList] = None,
        config_success_instance_count: int = None,
        config_success_instance_list: List[DisableAutoThrottleRulesResponseBodyDataConfigSuccessInstanceList] = None,
        total_instance_count: int = None,
    ):
        # The number of database instances for which the automatic SQL throttling feature failed to be disabled.
        self.config_fail_instance_count = config_fail_instance_count
        # The database instances for which the automatic SQL throttling feature failed to be disabled.
        self.config_fail_instance_list = config_fail_instance_list
        # The number of database instances for which the automatic SQL throttling feature is disabled.
        self.config_success_instance_count = config_success_instance_count
        # The database instances for which the automatic SQL throttling feature is disabled.
        self.config_success_instance_list = config_success_instance_list
        # The total number of database instances.
        self.total_instance_count = total_instance_count

    def validate(self):
        if self.config_fail_instance_list:
            for k in self.config_fail_instance_list:
                if k:
                    k.validate()
        if self.config_success_instance_list:
            for k in self.config_success_instance_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_fail_instance_count is not None:
            result['ConfigFailInstanceCount'] = self.config_fail_instance_count
        result['ConfigFailInstanceList'] = []
        if self.config_fail_instance_list is not None:
            for k in self.config_fail_instance_list:
                result['ConfigFailInstanceList'].append(k.to_map() if k else None)
        if self.config_success_instance_count is not None:
            result['ConfigSuccessInstanceCount'] = self.config_success_instance_count
        result['ConfigSuccessInstanceList'] = []
        if self.config_success_instance_list is not None:
            for k in self.config_success_instance_list:
                result['ConfigSuccessInstanceList'].append(k.to_map() if k else None)
        if self.total_instance_count is not None:
            result['TotalInstanceCount'] = self.total_instance_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigFailInstanceCount') is not None:
            self.config_fail_instance_count = m.get('ConfigFailInstanceCount')
        self.config_fail_instance_list = []
        if m.get('ConfigFailInstanceList') is not None:
            for k in m.get('ConfigFailInstanceList'):
                temp_model = DisableAutoThrottleRulesResponseBodyDataConfigFailInstanceList()
                self.config_fail_instance_list.append(temp_model.from_map(k))
        if m.get('ConfigSuccessInstanceCount') is not None:
            self.config_success_instance_count = m.get('ConfigSuccessInstanceCount')
        self.config_success_instance_list = []
        if m.get('ConfigSuccessInstanceList') is not None:
            for k in m.get('ConfigSuccessInstanceList'):
                temp_model = DisableAutoThrottleRulesResponseBodyDataConfigSuccessInstanceList()
                self.config_success_instance_list.append(temp_model.from_map(k))
        if m.get('TotalInstanceCount') is not None:
            self.total_instance_count = m.get('TotalInstanceCount')
        return self


class DisableAutoThrottleRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: DisableAutoThrottleRulesResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DisableAutoThrottleRulesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableAutoThrottleRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableAutoThrottleRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableAutoThrottleRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableDasProRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        user_id: str = None,
    ):
        # The database instance ID.
        self.instance_id = instance_id
        # The ID of the Alibaba Cloud account that is used to create the database instance.
        # 
        # >  This parameter is optional. The system can automatically obtain the account ID based on the value of InstanceId that you set when you call this operation.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DisableDasProResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
        synchro: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The reserved parameter.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success
        # The reserved parameter.
        self.synchro = synchro

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.synchro is not None:
            result['Synchro'] = self.synchro
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Synchro') is not None:
            self.synchro = m.get('Synchro')
        return self


class DisableDasProResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableDasProResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableDasProResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableInstanceDasConfigRequest(TeaModel):
    def __init__(
        self,
        engine: str = None,
        instance_id: str = None,
        scale_type: str = None,
    ):
        # The database engine. Set the value to Redis.
        self.engine = engine
        # The database instance ID.
        self.instance_id = instance_id
        # The type of auto scaling. Valid values:
        # 
        # *   **specScale**: The specifications of a database instance are automatically scaled up or down.
        # *   **shardScale**: The number of shards for a database instance is automatically increased or decreased.
        # *   **bandwidthScale**: The bandwidth of a database instance is automatically increased or decreased.
        self.scale_type = scale_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scale_type is not None:
            result['ScaleType'] = self.scale_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScaleType') is not None:
            self.scale_type = m.get('ScaleType')
        return self


class DisableInstanceDasConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The result of disabling the auto scaling feature for the database instance.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableInstanceDasConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableInstanceDasConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableInstanceDasConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableSqlConcurrencyControlRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        instance_id: str = None,
        item_id: int = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The instance ID.
        # 
        # >  The database instance must be an ApsaraDB RDS for MySQL instance or a PolarDB for MySQL cluster.
        self.instance_id = instance_id
        # The ID of the throttling rule that is applied to the instance. You can call the [GetRunningSqlConcurrencyControlRules](~~223538~~) operation to query the ID.
        self.item_id = item_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        return self


class DisableSqlConcurrencyControlResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information, including the error codes and the number of entries that are returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableSqlConcurrencyControlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DisableSqlConcurrencyControlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableSqlConcurrencyControlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableDasProRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        sql_retention: int = None,
        user_id: str = None,
    ):
        # The database instance ID.
        self.instance_id = instance_id
        # The storage duration of SQL Explorer data. Unit: day. Default value: **30**. Valid values:
        # 
        # *   **30**\
        # *   **180**\
        # *   **365**\
        # *   **1095**\
        # *   **1825**\
        self.sql_retention = sql_retention
        # The ID of the Alibaba Cloud account that is used to create the database instance.
        # 
        # >  This parameter is optional. The system can automatically obtain the account ID based on the value of InstanceId when you call this operation.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.sql_retention is not None:
            result['SqlRetention'] = self.sql_retention
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SqlRetention') is not None:
            self.sql_retention = m.get('SqlRetention')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class EnableDasProResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
        synchro: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The reserved parameter.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message that contains information such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success
        # The reserved parameter.
        self.synchro = synchro

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.synchro is not None:
            result['Synchro'] = self.synchro
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Synchro') is not None:
            self.synchro = m.get('Synchro')
        return self


class EnableDasProResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableDasProResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableDasProResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableSqlConcurrencyControlRequest(TeaModel):
    def __init__(
        self,
        concurrency_control_time: int = None,
        console_context: str = None,
        instance_id: str = None,
        max_concurrency: int = None,
        sql_keywords: str = None,
        sql_type: str = None,
    ):
        # The duration within which the SQL throttling rule takes effect. Unit: seconds.
        # 
        # >  The throttling rule takes effect only within this duration.
        self.concurrency_control_time = concurrency_control_time
        # The reserved parameter.
        self.console_context = console_context
        # The instance ID.
        # 
        # >  You must specify the instance ID only if your database instance is an ApsaraDB RDS for MySQL instance or a PolarDB for MySQL cluster.
        self.instance_id = instance_id
        # The maximum number of concurrent SQL statements. Set this parameter to a positive integer.
        # 
        # >  When the number of concurrent SQL statements that contain the specified keywords reaches this upper limit, the throttling rule is triggered.
        self.max_concurrency = max_concurrency
        # The keywords that are used to identify the SQL statements that need to be throttled.
        # 
        # >  If you specify multiple SQL keywords, separate them with tildes (~). If the number of concurrent SQL statements that contain all the specified SQL keywords reaches the specified upper limit, the throttling rule is triggered.
        self.sql_keywords = sql_keywords
        # The type of the SQL statements. Valid values:
        # 
        # *   **SELECT**\
        # *   **UPDATE**\
        # *   **DELETE**\
        self.sql_type = sql_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrency_control_time is not None:
            result['ConcurrencyControlTime'] = self.concurrency_control_time
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_concurrency is not None:
            result['MaxConcurrency'] = self.max_concurrency
        if self.sql_keywords is not None:
            result['SqlKeywords'] = self.sql_keywords
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConcurrencyControlTime') is not None:
            self.concurrency_control_time = m.get('ConcurrencyControlTime')
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxConcurrency') is not None:
            self.max_concurrency = m.get('MaxConcurrency')
        if m.get('SqlKeywords') is not None:
            self.sql_keywords = m.get('SqlKeywords')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        return self


class EnableSqlConcurrencyControlResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information, including the error codes and the number of entries that are returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableSqlConcurrencyControlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableSqlConcurrencyControlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableSqlConcurrencyControlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAsyncErrorRequestListByCodeRequest(TeaModel):
    def __init__(
        self,
        end: int = None,
        error_code: str = None,
        instance_id: str = None,
        node_id: str = None,
        start: int = None,
    ):
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time. The interval between the start time and the end time cannot exceed 24 hours.
        self.end = end
        # The error code. You can call the [GetAsyncErrorRequestStatByCode](~~409804~~) operation to query the MySQL error codes that may be generated in the SQL Explorer results of an instance.
        self.error_code = error_code
        # The instance ID.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  This parameter must be specified if the database instance is a PolarDB for MySQL cluster.
        self.node_id = node_id
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The start time must be within the storage duration of the SQL Explorer feature of the database instance, and can be up to 90 days earlier than the current time.
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class GetAsyncErrorRequestListByCodeResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        sql_id: str = None,
    ):
        # The instance ID
        self.instance_id = instance_id
        # SQL ID.
        self.sql_id = sql_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['instanceId'] = self.instance_id
        if self.sql_id is not None:
            result['sqlId'] = self.sql_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instanceId') is not None:
            self.instance_id = m.get('instanceId')
        if m.get('sqlId') is not None:
            self.sql_id = m.get('sqlId')
        return self


class GetAsyncErrorRequestListByCodeResponseBodyData(TeaModel):
    def __init__(
        self,
        complete: bool = None,
        fail: bool = None,
        is_finish: bool = None,
        result: List[GetAsyncErrorRequestListByCodeResponseBodyDataResult] = None,
        result_id: str = None,
        state: str = None,
        timestamp: int = None,
    ):
        # Indicates whether the asynchronous request was complete.
        # 
        # *   **true**\
        # *   **false**\
        self.complete = complete
        # Indicates whether the asynchronous request failed. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.fail = fail
        # Indicates whether the asynchronous request was complete. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.is_finish = is_finish
        # The instance ID.
        self.result = result
        # The ID of the asynchronous request.
        self.result_id = result_id
        # The state of the asynchronous request. Valid values:
        # 
        # *   **RUNNING**\
        # *   **SUCCESS**\
        # *   **FAIL**\
        self.state = state
        # The time when the asynchronous request was made. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete is not None:
            result['complete'] = self.complete
        if self.fail is not None:
            result['fail'] = self.fail
        if self.is_finish is not None:
            result['isFinish'] = self.is_finish
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.result_id is not None:
            result['resultId'] = self.result_id
        if self.state is not None:
            result['state'] = self.state
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('complete') is not None:
            self.complete = m.get('complete')
        if m.get('fail') is not None:
            self.fail = m.get('fail')
        if m.get('isFinish') is not None:
            self.is_finish = m.get('isFinish')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = GetAsyncErrorRequestListByCodeResponseBodyDataResult()
                self.result.append(temp_model.from_map(k))
        if m.get('resultId') is not None:
            self.result_id = m.get('resultId')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class GetAsyncErrorRequestListByCodeResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetAsyncErrorRequestListByCodeResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAsyncErrorRequestListByCodeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAsyncErrorRequestListByCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAsyncErrorRequestListByCodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAsyncErrorRequestListByCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAsyncErrorRequestStatByCodeRequest(TeaModel):
    def __init__(
        self,
        db_name: str = None,
        end: int = None,
        instance_id: str = None,
        node_id: str = None,
        start: int = None,
    ):
        # The name of a database.
        self.db_name = db_name
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time. The interval between the start time and the end time cannot exceed 24 hours.
        self.end = end
        # The instance ID.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  This parameter must be specified for PolarDB for MySQL clusters.
        self.node_id = node_id
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The start time must be within the storage duration of the SQL Explorer feature of the database instance and can be up to 90 days earlier than the current time.
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.end is not None:
            result['End'] = self.end
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class GetAsyncErrorRequestStatByCodeResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        count: int = None,
        error_code: str = None,
        instance_id: str = None,
    ):
        # The number of SQL queries corresponding to the error code.
        self.count = count
        # The error code returned if the request failed.
        self.error_code = error_code
        # The instance ID.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['count'] = self.count
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.instance_id is not None:
            result['instanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('count') is not None:
            self.count = m.get('count')
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('instanceId') is not None:
            self.instance_id = m.get('instanceId')
        return self


class GetAsyncErrorRequestStatByCodeResponseBodyData(TeaModel):
    def __init__(
        self,
        complete: bool = None,
        fail: bool = None,
        is_finish: bool = None,
        result: List[GetAsyncErrorRequestStatByCodeResponseBodyDataResult] = None,
        result_id: str = None,
        state: str = None,
        timestamp: int = None,
    ):
        # Indicates whether the asynchronous request was complete.
        # 
        # *   **true**\
        # *   **false**\
        self.complete = complete
        # Indicates whether the asynchronous request failed. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.fail = fail
        # Indicates whether the asynchronous request was complete. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.is_finish = is_finish
        # The number of SQL queries corresponding to the error code.
        self.result = result
        # The ID of the asynchronous request.
        self.result_id = result_id
        # The state of the asynchronous request. Valid values:
        # 
        # *   **RUNNING**\
        # *   **SUCCESS**\
        # *   **FAIL**\
        self.state = state
        # The time when the asynchronous request was made. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete is not None:
            result['complete'] = self.complete
        if self.fail is not None:
            result['fail'] = self.fail
        if self.is_finish is not None:
            result['isFinish'] = self.is_finish
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                result['result'].append(k.to_map() if k else None)
        if self.result_id is not None:
            result['resultId'] = self.result_id
        if self.state is not None:
            result['state'] = self.state
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('complete') is not None:
            self.complete = m.get('complete')
        if m.get('fail') is not None:
            self.fail = m.get('fail')
        if m.get('isFinish') is not None:
            self.is_finish = m.get('isFinish')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                temp_model = GetAsyncErrorRequestStatByCodeResponseBodyDataResult()
                self.result.append(temp_model.from_map(k))
        if m.get('resultId') is not None:
            self.result_id = m.get('resultId')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class GetAsyncErrorRequestStatByCodeResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetAsyncErrorRequestStatByCodeResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAsyncErrorRequestStatByCodeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAsyncErrorRequestStatByCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAsyncErrorRequestStatByCodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAsyncErrorRequestStatByCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAsyncErrorRequestStatResultRequest(TeaModel):
    def __init__(
        self,
        db_name: str = None,
        end: int = None,
        instance_id: str = None,
        node_id: str = None,
        sql_id_list: str = None,
        start: int = None,
    ):
        # The name of the database.
        self.db_name = db_name
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time. The interval between the start time and the end time cannot exceed 24 hours.
        self.end = end
        # The instance ID.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  This parameter must be specified for PolarDB for MySQL instances.
        self.node_id = node_id
        # The ID of the SQL template. Separate multiple SQL IDs with commas (,). You can call the [GetAsyncErrorRequestListByCode](~~410746~~) operation to query the ID of the SQL query for which MySQL error code is returned.
        self.sql_id_list = sql_id_list
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The beginning of the time range to query must be within the storage duration of the database instance and can be up to 90 days earlier than the current time.
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.end is not None:
            result['End'] = self.end
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.sql_id_list is not None:
            result['SqlIdList'] = self.sql_id_list
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('SqlIdList') is not None:
            self.sql_id_list = m.get('SqlIdList')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class GetAsyncErrorRequestStatResultResponseBodyData(TeaModel):
    def __init__(
        self,
        complete: bool = None,
        fail: bool = None,
        is_finish: bool = None,
        result: List[Dict[str, DataResultValue]] = None,
        result_id: str = None,
        state: str = None,
        timestamp: int = None,
    ):
        # Indicates whether the asynchronous request was complete.
        # 
        # *   **true**\
        # *   **false**\
        self.complete = complete
        # Indicates whether the request failed. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.fail = fail
        # Indicates whether the asynchronous request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.is_finish = is_finish
        # The returned data of the asynchronous request.
        self.result = result
        # The ID of the asynchronous request.
        self.result_id = result_id
        # The state of the asynchronous request. Valid values:
        # 
        # *   **RUNNING**: The asynchronous request is running.
        # *   **SUCCESS**: The asynchronous request is successful.
        # *   **FAIL**: The asynchronous request fails.
        self.state = state
        # The time when the asynchronous request was made. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete is not None:
            result['complete'] = self.complete
        if self.fail is not None:
            result['fail'] = self.fail
        if self.is_finish is not None:
            result['isFinish'] = self.is_finish
        result['result'] = []
        if self.result is not None:
            for k in self.result:
                d1 = {}
                for k1 ,v1 in k.items():
                    d1[k1] = v1.to_map()
                result['result'].append(d1)
        if self.result_id is not None:
            result['resultId'] = self.result_id
        if self.state is not None:
            result['state'] = self.state
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('complete') is not None:
            self.complete = m.get('complete')
        if m.get('fail') is not None:
            self.fail = m.get('fail')
        if m.get('isFinish') is not None:
            self.is_finish = m.get('isFinish')
        self.result = []
        if m.get('result') is not None:
            for k in m.get('result'):
                d1 = {}
                for k1, v1 in k.items():
                    temp_model = DataResultValue()
                    d1[k1] = temp_model.from_map(v1)
                self.result.append(d1)
        if m.get('resultId') is not None:
            self.result_id = m.get('resultId')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class GetAsyncErrorRequestStatResultResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetAsyncErrorRequestStatResultResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAsyncErrorRequestStatResultResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAsyncErrorRequestStatResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAsyncErrorRequestStatResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAsyncErrorRequestStatResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAutoIncrementUsageStatisticRequest(TeaModel):
    def __init__(
        self,
        db_names: str = None,
        instance_id: str = None,
        ratio_filter: float = None,
        real_time: bool = None,
    ):
        # The database name. If you specify a database, the operation queries the usage of auto-increment table IDs in the specified database. Otherwise, the operation queries the usage of auto-increment table IDs in all databases on the instance.
        # 
        # >  Specify the parameter value as a JSON array, such as \[\"db1\",\"db2\"]. Separate multiple database names with commas (,).
        self.db_names = db_names
        # The instance ID.
        self.instance_id = instance_id
        # The usage threshold of auto-increment IDs. Only usage that exceeds the threshold can be returned. Valid values are decimals that range from 0 to 1.
        self.ratio_filter = ratio_filter
        # Specifies whether to query real-time data. Valid values:
        # 
        # *   **true**: queries data in real time except for data generated in the last 10 minutes.****\
        # *   **false**: queries data generated in the last 2 hours. If no such data exists, queries the latest data.
        self.real_time = real_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_names is not None:
            result['DbNames'] = self.db_names
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ratio_filter is not None:
            result['RatioFilter'] = self.ratio_filter
        if self.real_time is not None:
            result['RealTime'] = self.real_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DbNames') is not None:
            self.db_names = m.get('DbNames')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RatioFilter') is not None:
            self.ratio_filter = m.get('RatioFilter')
        if m.get('RealTime') is not None:
            self.real_time = m.get('RealTime')
        return self


class GetAutoIncrementUsageStatisticResponseBodyDataAutoIncrementUsageList(TeaModel):
    def __init__(
        self,
        auto_increment_current_value: int = None,
        auto_increment_ratio: float = None,
        column_name: str = None,
        db_name: str = None,
        maximum_value: int = None,
        table_name: str = None,
    ):
        # The latest auto-increment ID.
        self.auto_increment_current_value = auto_increment_current_value
        # The usage ratio of auto-increment IDs.
        self.auto_increment_ratio = auto_increment_ratio
        # The column name.
        self.column_name = column_name
        # The database name.
        self.db_name = db_name
        # The maximum auto-increment ID that is supported by the current data type.
        self.maximum_value = maximum_value
        # The table name.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_increment_current_value is not None:
            result['AutoIncrementCurrentValue'] = self.auto_increment_current_value
        if self.auto_increment_ratio is not None:
            result['AutoIncrementRatio'] = self.auto_increment_ratio
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.maximum_value is not None:
            result['MaximumValue'] = self.maximum_value
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoIncrementCurrentValue') is not None:
            self.auto_increment_current_value = m.get('AutoIncrementCurrentValue')
        if m.get('AutoIncrementRatio') is not None:
            self.auto_increment_ratio = m.get('AutoIncrementRatio')
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('MaximumValue') is not None:
            self.maximum_value = m.get('MaximumValue')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetAutoIncrementUsageStatisticResponseBodyData(TeaModel):
    def __init__(
        self,
        auto_increment_usage_list: List[GetAutoIncrementUsageStatisticResponseBodyDataAutoIncrementUsageList] = None,
        error_info: str = None,
        finish: bool = None,
        task_status: str = None,
        timestamp: int = None,
    ):
        # The usage details of auto-increment IDs.
        self.auto_increment_usage_list = auto_increment_usage_list
        # The error message returned if the task fails.
        self.error_info = error_info
        # Indicates whether the task is complete. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.finish = finish
        # The task status. Valid values:
        # 
        # *   **INIT**: The task is being initialized.
        # *   **RUNNING**: The task is being executed.
        # *   **SUCCESS**: The task succeeds.
        # *   **FAIL**: The task fails.
        self.task_status = task_status
        # The time when the request was made. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp

    def validate(self):
        if self.auto_increment_usage_list:
            for k in self.auto_increment_usage_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AutoIncrementUsageList'] = []
        if self.auto_increment_usage_list is not None:
            for k in self.auto_increment_usage_list:
                result['AutoIncrementUsageList'].append(k.to_map() if k else None)
        if self.error_info is not None:
            result['ErrorInfo'] = self.error_info
        if self.finish is not None:
            result['Finish'] = self.finish
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.auto_increment_usage_list = []
        if m.get('AutoIncrementUsageList') is not None:
            for k in m.get('AutoIncrementUsageList'):
                temp_model = GetAutoIncrementUsageStatisticResponseBodyDataAutoIncrementUsageList()
                self.auto_increment_usage_list.append(temp_model.from_map(k))
        if m.get('ErrorInfo') is not None:
            self.error_info = m.get('ErrorInfo')
        if m.get('Finish') is not None:
            self.finish = m.get('Finish')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetAutoIncrementUsageStatisticResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetAutoIncrementUsageStatisticResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        # 
        # >  If the request is successful, **Successful** is returned. Otherwise, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAutoIncrementUsageStatisticResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAutoIncrementUsageStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAutoIncrementUsageStatisticResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAutoIncrementUsageStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAutoResourceOptimizeRulesRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        instance_ids: str = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The database instance IDs.
        # 
        # *   Set this parameter to a JSON array that consists of multiple instance IDs. Separate instance IDs with commas (,). Example: `[\"Instance ID1\",\"Instance ID2\"]`.
        # 
        # *   By default, if you leave this parameter empty, all database instances for which the automatic fragment recycling feature has been enabled within the current Alibaba Cloud account are returned. The following types of database instances are returned:
        # 
        #     *   Database instances for which the automatic fragment recycling feature is currently enabled.
        #     *   Database instances for which the automatic fragment recycling feature was once enabled but is currently disabled, including those for which DAS Professional Edition has been disabled but excluding those that have been released.
        self.instance_ids = instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        return self


class GetAutoResourceOptimizeRulesResponseBodyDataEnableAutoResourceOptimizeList(TeaModel):
    def __init__(
        self,
        auto_defragment: bool = None,
        das_pro_on: bool = None,
        instance_id: str = None,
        table_fragmentation_ratio: float = None,
        table_space_size: float = None,
        user_id: str = None,
    ):
        # Indicates whether the automatic fragment recycling feature is enabled. Valid values:
        # 
        # * **true**\
        # * **false**\
        self.auto_defragment = auto_defragment
        # Indicates whether DAS Professional Edition is enabled. Valid values:
        # 
        # * **true**\
        # * **false**\
        self.das_pro_on = das_pro_on
        # The database instance ID.
        self.instance_id = instance_id
        # The fragmentation rate of a single physical table for which the automatic fragment recycling feature is enabled.
        self.table_fragmentation_ratio = table_fragmentation_ratio
        # The minimum storage usage of a single physical table for which the automatic fragment recycling feature is enabled. Unit: GB.
        self.table_space_size = table_space_size
        # The ID of the Alibaba Cloud account that is used to create the database instance.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_defragment is not None:
            result['AutoDefragment'] = self.auto_defragment
        if self.das_pro_on is not None:
            result['DasProOn'] = self.das_pro_on
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.table_fragmentation_ratio is not None:
            result['TableFragmentationRatio'] = self.table_fragmentation_ratio
        if self.table_space_size is not None:
            result['TableSpaceSize'] = self.table_space_size
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoDefragment') is not None:
            self.auto_defragment = m.get('AutoDefragment')
        if m.get('DasProOn') is not None:
            self.das_pro_on = m.get('DasProOn')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TableFragmentationRatio') is not None:
            self.table_fragmentation_ratio = m.get('TableFragmentationRatio')
        if m.get('TableSpaceSize') is not None:
            self.table_space_size = m.get('TableSpaceSize')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetAutoResourceOptimizeRulesResponseBodyDataHasEnableRuleButNotDasProList(TeaModel):
    def __init__(
        self,
        auto_defragment: bool = None,
        das_pro_on: bool = None,
        instance_id: str = None,
        table_fragmentation_ratio: float = None,
        table_space_size: float = None,
        user_id: str = None,
    ):
        # Indicates whether the automatic fragment recycling feature is enabled. Valid values:
        # 
        # * **true**\
        # * **false**\
        self.auto_defragment = auto_defragment
        # Indicates whether DAS Professional Edition is enabled. Valid values:
        # 
        # * **true**\
        # * **false**\
        self.das_pro_on = das_pro_on
        # The database instance ID.
        self.instance_id = instance_id
        # The fragmentation rate of a single physical table for which the automatic fragment recycling feature is enabled.
        self.table_fragmentation_ratio = table_fragmentation_ratio
        # The minimum storage usage of a single physical table for which the automatic fragment recycling feature is enabled. Unit: GB.
        self.table_space_size = table_space_size
        # The ID of the Alibaba Cloud account that is used to create the database instance.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_defragment is not None:
            result['AutoDefragment'] = self.auto_defragment
        if self.das_pro_on is not None:
            result['DasProOn'] = self.das_pro_on
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.table_fragmentation_ratio is not None:
            result['TableFragmentationRatio'] = self.table_fragmentation_ratio
        if self.table_space_size is not None:
            result['TableSpaceSize'] = self.table_space_size
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoDefragment') is not None:
            self.auto_defragment = m.get('AutoDefragment')
        if m.get('DasProOn') is not None:
            self.das_pro_on = m.get('DasProOn')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TableFragmentationRatio') is not None:
            self.table_fragmentation_ratio = m.get('TableFragmentationRatio')
        if m.get('TableSpaceSize') is not None:
            self.table_space_size = m.get('TableSpaceSize')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetAutoResourceOptimizeRulesResponseBodyDataTurnOffAutoResourceOptimizeList(TeaModel):
    def __init__(
        self,
        auto_defragment: bool = None,
        das_pro_on: bool = None,
        instance_id: str = None,
        table_fragmentation_ratio: float = None,
        table_space_size: float = None,
        user_id: str = None,
    ):
        # Indicates whether the automatic fragment recycling feature is enabled. Valid values:
        # 
        # * **true**\
        # * **false**\
        self.auto_defragment = auto_defragment
        # Indicates whether DAS Professional Edition is enabled. Valid values:
        # 
        # * **true**\
        # * **false**\
        self.das_pro_on = das_pro_on
        # The database instance ID.
        self.instance_id = instance_id
        # The fragmentation rate of a single physical table for which the automatic fragment recycling feature is enabled.
        self.table_fragmentation_ratio = table_fragmentation_ratio
        # Indicates whether the automatic fragment recycling feature is enabled. Valid values:
        # 
        # true
        # false
        self.table_space_size = table_space_size
        # The ID of the Alibaba Cloud account that is used to create the database instance.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_defragment is not None:
            result['AutoDefragment'] = self.auto_defragment
        if self.das_pro_on is not None:
            result['DasProOn'] = self.das_pro_on
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.table_fragmentation_ratio is not None:
            result['TableFragmentationRatio'] = self.table_fragmentation_ratio
        if self.table_space_size is not None:
            result['TableSpaceSize'] = self.table_space_size
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoDefragment') is not None:
            self.auto_defragment = m.get('AutoDefragment')
        if m.get('DasProOn') is not None:
            self.das_pro_on = m.get('DasProOn')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TableFragmentationRatio') is not None:
            self.table_fragmentation_ratio = m.get('TableFragmentationRatio')
        if m.get('TableSpaceSize') is not None:
            self.table_space_size = m.get('TableSpaceSize')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetAutoResourceOptimizeRulesResponseBodyData(TeaModel):
    def __init__(
        self,
        enable_auto_resource_optimize_count: int = None,
        enable_auto_resource_optimize_list: List[GetAutoResourceOptimizeRulesResponseBodyDataEnableAutoResourceOptimizeList] = None,
        has_enable_rule_but_not_das_pro_count: int = None,
        has_enable_rule_but_not_das_pro_list: List[GetAutoResourceOptimizeRulesResponseBodyDataHasEnableRuleButNotDasProList] = None,
        never_enable_auto_resource_optimize_or_released_instance_count: int = None,
        never_enable_auto_resource_optimize_or_released_instance_id_list: List[str] = None,
        total_auto_resource_optimize_rules_count: int = None,
        turn_off_auto_resource_optimize_count: int = None,
        turn_off_auto_resource_optimize_list: List[GetAutoResourceOptimizeRulesResponseBodyDataTurnOffAutoResourceOptimizeList] = None,
    ):
        # The number of database instances for which the automatic fragment recycling feature is currently enabled.
        self.enable_auto_resource_optimize_count = enable_auto_resource_optimize_count
        # The database instances for which the automatic fragment recycling feature is currently enabled.
        self.enable_auto_resource_optimize_list = enable_auto_resource_optimize_list
        # The number of database instances for which the automatic fragment recycling feature is enabled and DAS Professional Edition is disabled.
        self.has_enable_rule_but_not_das_pro_count = has_enable_rule_but_not_das_pro_count
        # The database instances for which the automatic fragment recycling feature is enabled and DAS Professional Edition is disabled.
        # 
        # > This type of database instance does not perform automatic fragment recycling tasks until DAS Professional Edition is enabled for the instances again.
        self.has_enable_rule_but_not_das_pro_list = has_enable_rule_but_not_das_pro_list
        # The number of database instances that do not exist or for which the automatic fragment recycling feature has never been enabled.
        # 
        # >  If a database instance does not exist, the instance has been released or the specified instance ID is invalid.
        self.never_enable_auto_resource_optimize_or_released_instance_count = never_enable_auto_resource_optimize_or_released_instance_count
        # The database instances that do not exist or for which the automatic fragment recycling feature has never been enabled.
        self.never_enable_auto_resource_optimize_or_released_instance_id_list = never_enable_auto_resource_optimize_or_released_instance_id_list
        # The number of database instances for which the automatic fragment recycling feature has been enabled.
        self.total_auto_resource_optimize_rules_count = total_auto_resource_optimize_rules_count
        # The number of database instances for which the automatic fragment recycling feature was once enabled but is currently disabled.
        self.turn_off_auto_resource_optimize_count = turn_off_auto_resource_optimize_count
        # The database instances for which the automatic fragment recycling feature was once enabled but is currently disabled.
        self.turn_off_auto_resource_optimize_list = turn_off_auto_resource_optimize_list

    def validate(self):
        if self.enable_auto_resource_optimize_list:
            for k in self.enable_auto_resource_optimize_list:
                if k:
                    k.validate()
        if self.has_enable_rule_but_not_das_pro_list:
            for k in self.has_enable_rule_but_not_das_pro_list:
                if k:
                    k.validate()
        if self.turn_off_auto_resource_optimize_list:
            for k in self.turn_off_auto_resource_optimize_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_auto_resource_optimize_count is not None:
            result['EnableAutoResourceOptimizeCount'] = self.enable_auto_resource_optimize_count
        result['EnableAutoResourceOptimizeList'] = []
        if self.enable_auto_resource_optimize_list is not None:
            for k in self.enable_auto_resource_optimize_list:
                result['EnableAutoResourceOptimizeList'].append(k.to_map() if k else None)
        if self.has_enable_rule_but_not_das_pro_count is not None:
            result['HasEnableRuleButNotDasProCount'] = self.has_enable_rule_but_not_das_pro_count
        result['HasEnableRuleButNotDasProList'] = []
        if self.has_enable_rule_but_not_das_pro_list is not None:
            for k in self.has_enable_rule_but_not_das_pro_list:
                result['HasEnableRuleButNotDasProList'].append(k.to_map() if k else None)
        if self.never_enable_auto_resource_optimize_or_released_instance_count is not None:
            result['NeverEnableAutoResourceOptimizeOrReleasedInstanceCount'] = self.never_enable_auto_resource_optimize_or_released_instance_count
        if self.never_enable_auto_resource_optimize_or_released_instance_id_list is not None:
            result['NeverEnableAutoResourceOptimizeOrReleasedInstanceIdList'] = self.never_enable_auto_resource_optimize_or_released_instance_id_list
        if self.total_auto_resource_optimize_rules_count is not None:
            result['TotalAutoResourceOptimizeRulesCount'] = self.total_auto_resource_optimize_rules_count
        if self.turn_off_auto_resource_optimize_count is not None:
            result['TurnOffAutoResourceOptimizeCount'] = self.turn_off_auto_resource_optimize_count
        result['TurnOffAutoResourceOptimizeList'] = []
        if self.turn_off_auto_resource_optimize_list is not None:
            for k in self.turn_off_auto_resource_optimize_list:
                result['TurnOffAutoResourceOptimizeList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableAutoResourceOptimizeCount') is not None:
            self.enable_auto_resource_optimize_count = m.get('EnableAutoResourceOptimizeCount')
        self.enable_auto_resource_optimize_list = []
        if m.get('EnableAutoResourceOptimizeList') is not None:
            for k in m.get('EnableAutoResourceOptimizeList'):
                temp_model = GetAutoResourceOptimizeRulesResponseBodyDataEnableAutoResourceOptimizeList()
                self.enable_auto_resource_optimize_list.append(temp_model.from_map(k))
        if m.get('HasEnableRuleButNotDasProCount') is not None:
            self.has_enable_rule_but_not_das_pro_count = m.get('HasEnableRuleButNotDasProCount')
        self.has_enable_rule_but_not_das_pro_list = []
        if m.get('HasEnableRuleButNotDasProList') is not None:
            for k in m.get('HasEnableRuleButNotDasProList'):
                temp_model = GetAutoResourceOptimizeRulesResponseBodyDataHasEnableRuleButNotDasProList()
                self.has_enable_rule_but_not_das_pro_list.append(temp_model.from_map(k))
        if m.get('NeverEnableAutoResourceOptimizeOrReleasedInstanceCount') is not None:
            self.never_enable_auto_resource_optimize_or_released_instance_count = m.get('NeverEnableAutoResourceOptimizeOrReleasedInstanceCount')
        if m.get('NeverEnableAutoResourceOptimizeOrReleasedInstanceIdList') is not None:
            self.never_enable_auto_resource_optimize_or_released_instance_id_list = m.get('NeverEnableAutoResourceOptimizeOrReleasedInstanceIdList')
        if m.get('TotalAutoResourceOptimizeRulesCount') is not None:
            self.total_auto_resource_optimize_rules_count = m.get('TotalAutoResourceOptimizeRulesCount')
        if m.get('TurnOffAutoResourceOptimizeCount') is not None:
            self.turn_off_auto_resource_optimize_count = m.get('TurnOffAutoResourceOptimizeCount')
        self.turn_off_auto_resource_optimize_list = []
        if m.get('TurnOffAutoResourceOptimizeList') is not None:
            for k in m.get('TurnOffAutoResourceOptimizeList'):
                temp_model = GetAutoResourceOptimizeRulesResponseBodyDataTurnOffAutoResourceOptimizeList()
                self.turn_off_auto_resource_optimize_list.append(temp_model.from_map(k))
        return self


class GetAutoResourceOptimizeRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetAutoResourceOptimizeRulesResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAutoResourceOptimizeRulesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAutoResourceOptimizeRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAutoResourceOptimizeRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAutoResourceOptimizeRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAutoThrottleRulesRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        instance_ids: str = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The database instance IDs.
        # 
        # *   Set this parameter to a JSON array that consists of multiple instance IDs. Separate instance IDs with commas (,). Example: `[\"Instance ID1\",\"Instance ID2\"]`.
        # 
        # *   By default, if you leave this parameter empty, all database instances for which the automatic SQL throttling feature has been enabled within the current Alibaba Cloud account are returned. The following types of database instances are returned:
        # 
        #     *   Database instances for which the automatic SQL throttling feature is currently enabled.
        #     *   Database instances for which the automatic SQL throttling feature was once enabled but is currently disabled. Released database instances are not included.
        self.instance_ids = instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        return self


class GetAutoThrottleRulesResponseBodyDataEnableAutoThrottleList(TeaModel):
    def __init__(
        self,
        abnormal_duration: float = None,
        active_sessions: int = None,
        allow_throttle_end_time: str = None,
        allow_throttle_start_time: str = None,
        auto_kill_session: bool = None,
        cpu_session_relation: str = None,
        cpu_usage: float = None,
        instance_id: str = None,
        max_throttle_time: float = None,
        user_id: str = None,
        visible: bool = None,
    ):
        # The maximum period of time during which an exception occurs when automatic SQL throttling is triggered. Unit: minutes.
        self.abnormal_duration = abnormal_duration
        # The maximum number of active sessions.
        self.active_sessions = active_sessions
        # The end time of the throttling window. The value of this parameter is in UTC.
        self.allow_throttle_end_time = allow_throttle_end_time
        # The start time of the throttling window. The value of this parameter is in UTC.
        self.allow_throttle_start_time = allow_throttle_start_time
        # Indicates whether abnormal SQL statements in execution are terminated at a time. Valid values:
        # 
        # > Abnormal SQL statements use the same template as the SQL statements that need to be throttled.
        # 
        # * **true**\
        # * **false**\
        self.auto_kill_session = auto_kill_session
        # The logical relationship between the CPU utilization threshold and the maximum number of active sessions. Valid values:
        # 
        # * **AND**\
        # * **OR**\
        self.cpu_session_relation = cpu_session_relation
        # The CPU utilization threshold.
        self.cpu_usage = cpu_usage
        # The database instance ID.
        self.instance_id = instance_id
        # The maximum throttling duration. Unit: minutes.
        self.max_throttle_time = max_throttle_time
        # The ID of the Alibaba Cloud account that is used to create the database instance.
        self.user_id = user_id
        # Indicates whether the automatic SQL throttling feature is enabled. Valid values:
        # 
        # * **true**\
        # * **false**\
        self.visible = visible

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abnormal_duration is not None:
            result['AbnormalDuration'] = self.abnormal_duration
        if self.active_sessions is not None:
            result['ActiveSessions'] = self.active_sessions
        if self.allow_throttle_end_time is not None:
            result['AllowThrottleEndTime'] = self.allow_throttle_end_time
        if self.allow_throttle_start_time is not None:
            result['AllowThrottleStartTime'] = self.allow_throttle_start_time
        if self.auto_kill_session is not None:
            result['AutoKillSession'] = self.auto_kill_session
        if self.cpu_session_relation is not None:
            result['CpuSessionRelation'] = self.cpu_session_relation
        if self.cpu_usage is not None:
            result['CpuUsage'] = self.cpu_usage
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_throttle_time is not None:
            result['MaxThrottleTime'] = self.max_throttle_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.visible is not None:
            result['Visible'] = self.visible
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AbnormalDuration') is not None:
            self.abnormal_duration = m.get('AbnormalDuration')
        if m.get('ActiveSessions') is not None:
            self.active_sessions = m.get('ActiveSessions')
        if m.get('AllowThrottleEndTime') is not None:
            self.allow_throttle_end_time = m.get('AllowThrottleEndTime')
        if m.get('AllowThrottleStartTime') is not None:
            self.allow_throttle_start_time = m.get('AllowThrottleStartTime')
        if m.get('AutoKillSession') is not None:
            self.auto_kill_session = m.get('AutoKillSession')
        if m.get('CpuSessionRelation') is not None:
            self.cpu_session_relation = m.get('CpuSessionRelation')
        if m.get('CpuUsage') is not None:
            self.cpu_usage = m.get('CpuUsage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxThrottleTime') is not None:
            self.max_throttle_time = m.get('MaxThrottleTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Visible') is not None:
            self.visible = m.get('Visible')
        return self


class GetAutoThrottleRulesResponseBodyDataTurnOffAutoThrottleList(TeaModel):
    def __init__(
        self,
        abnormal_duration: float = None,
        active_sessions: int = None,
        allow_throttle_end_time: str = None,
        allow_throttle_start_time: str = None,
        auto_kill_session: bool = None,
        cpu_session_relation: str = None,
        cpu_usage: float = None,
        instance_id: str = None,
        max_throttle_time: float = None,
        user_id: str = None,
        visible: bool = None,
    ):
        # The maximum period of time during which the automatic SQL throttling feature is triggered. Unit: minutes.
        self.abnormal_duration = abnormal_duration
        # The maximum number of active sessions.
        self.active_sessions = active_sessions
        # The end time of the throttling window. The value of this parameter is in UTC.
        self.allow_throttle_end_time = allow_throttle_end_time
        # The start time of the throttling window. The value of this parameter is in UTC.
        self.allow_throttle_start_time = allow_throttle_start_time
        # Indicates whether abnormal SQL statements in execution are terminated at a time. Valid values:
        # 
        # > Abnormal SQL statements use the same template as the SQL statements that need to be throttled.
        # 
        # * **true**\
        # * **false**\
        self.auto_kill_session = auto_kill_session
        # The logical relationship between the CPU utilization threshold and the maximum number of active sessions. Valid values:
        # 
        # * **AND**\
        # * **OR**\
        self.cpu_session_relation = cpu_session_relation
        # The CPU utilization threshold.
        self.cpu_usage = cpu_usage
        # The database instance ID.
        self.instance_id = instance_id
        # The maximum throttling duration. Unit: minutes.
        self.max_throttle_time = max_throttle_time
        # The ID of the Alibaba Cloud account that is used to create the database instance.
        self.user_id = user_id
        # Indicates whether the automatic SQL throttling feature is enabled. Valid values:
        # 
        # * **true**\
        # * **false**\
        self.visible = visible

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abnormal_duration is not None:
            result['AbnormalDuration'] = self.abnormal_duration
        if self.active_sessions is not None:
            result['ActiveSessions'] = self.active_sessions
        if self.allow_throttle_end_time is not None:
            result['AllowThrottleEndTime'] = self.allow_throttle_end_time
        if self.allow_throttle_start_time is not None:
            result['AllowThrottleStartTime'] = self.allow_throttle_start_time
        if self.auto_kill_session is not None:
            result['AutoKillSession'] = self.auto_kill_session
        if self.cpu_session_relation is not None:
            result['CpuSessionRelation'] = self.cpu_session_relation
        if self.cpu_usage is not None:
            result['CpuUsage'] = self.cpu_usage
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_throttle_time is not None:
            result['MaxThrottleTime'] = self.max_throttle_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.visible is not None:
            result['Visible'] = self.visible
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AbnormalDuration') is not None:
            self.abnormal_duration = m.get('AbnormalDuration')
        if m.get('ActiveSessions') is not None:
            self.active_sessions = m.get('ActiveSessions')
        if m.get('AllowThrottleEndTime') is not None:
            self.allow_throttle_end_time = m.get('AllowThrottleEndTime')
        if m.get('AllowThrottleStartTime') is not None:
            self.allow_throttle_start_time = m.get('AllowThrottleStartTime')
        if m.get('AutoKillSession') is not None:
            self.auto_kill_session = m.get('AutoKillSession')
        if m.get('CpuSessionRelation') is not None:
            self.cpu_session_relation = m.get('CpuSessionRelation')
        if m.get('CpuUsage') is not None:
            self.cpu_usage = m.get('CpuUsage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxThrottleTime') is not None:
            self.max_throttle_time = m.get('MaxThrottleTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Visible') is not None:
            self.visible = m.get('Visible')
        return self


class GetAutoThrottleRulesResponseBodyData(TeaModel):
    def __init__(
        self,
        enable_auto_throttle_count: int = None,
        enable_auto_throttle_list: List[GetAutoThrottleRulesResponseBodyDataEnableAutoThrottleList] = None,
        never_enable_auto_throttle_or_released_instance_count: int = None,
        never_enable_auto_throttle_or_released_instance_id_list: List[str] = None,
        total_auto_throttle_rules_count: int = None,
        turn_off_auto_throttle_count: int = None,
        turn_off_auto_throttle_list: List[GetAutoThrottleRulesResponseBodyDataTurnOffAutoThrottleList] = None,
    ):
        # The number of database instances for which the automatic SQL throttling feature is currently enabled.
        self.enable_auto_throttle_count = enable_auto_throttle_count
        # The database instances for which the automatic SQL throttling feature is currently enabled.
        self.enable_auto_throttle_list = enable_auto_throttle_list
        # The number of database instances that do not exist or for which the automatic SQL throttling feature has never been enabled.
        # 
        # >  If a database instance does not exist, the instance has been released or the specified instance ID is invalid.
        self.never_enable_auto_throttle_or_released_instance_count = never_enable_auto_throttle_or_released_instance_count
        # The number of database instances that do not exist or for which the automatic SQL throttling feature has never been enabled.
        # 
        # >  If a database instance does not exist, the instance has been released or the specified instance ID is invalid.
        self.never_enable_auto_throttle_or_released_instance_id_list = never_enable_auto_throttle_or_released_instance_id_list
        # The number of databases for which the automatic SQL throttling feature has been enabled.
        self.total_auto_throttle_rules_count = total_auto_throttle_rules_count
        # The number of database instances for which the automatic SQL throttling feature was once enabled but is currently disabled.
        self.turn_off_auto_throttle_count = turn_off_auto_throttle_count
        # The database instances for which the automatic SQL throttling feature was once enabled but is currently disabled.
        self.turn_off_auto_throttle_list = turn_off_auto_throttle_list

    def validate(self):
        if self.enable_auto_throttle_list:
            for k in self.enable_auto_throttle_list:
                if k:
                    k.validate()
        if self.turn_off_auto_throttle_list:
            for k in self.turn_off_auto_throttle_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_auto_throttle_count is not None:
            result['EnableAutoThrottleCount'] = self.enable_auto_throttle_count
        result['EnableAutoThrottleList'] = []
        if self.enable_auto_throttle_list is not None:
            for k in self.enable_auto_throttle_list:
                result['EnableAutoThrottleList'].append(k.to_map() if k else None)
        if self.never_enable_auto_throttle_or_released_instance_count is not None:
            result['NeverEnableAutoThrottleOrReleasedInstanceCount'] = self.never_enable_auto_throttle_or_released_instance_count
        if self.never_enable_auto_throttle_or_released_instance_id_list is not None:
            result['NeverEnableAutoThrottleOrReleasedInstanceIdList'] = self.never_enable_auto_throttle_or_released_instance_id_list
        if self.total_auto_throttle_rules_count is not None:
            result['TotalAutoThrottleRulesCount'] = self.total_auto_throttle_rules_count
        if self.turn_off_auto_throttle_count is not None:
            result['TurnOffAutoThrottleCount'] = self.turn_off_auto_throttle_count
        result['TurnOffAutoThrottleList'] = []
        if self.turn_off_auto_throttle_list is not None:
            for k in self.turn_off_auto_throttle_list:
                result['TurnOffAutoThrottleList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableAutoThrottleCount') is not None:
            self.enable_auto_throttle_count = m.get('EnableAutoThrottleCount')
        self.enable_auto_throttle_list = []
        if m.get('EnableAutoThrottleList') is not None:
            for k in m.get('EnableAutoThrottleList'):
                temp_model = GetAutoThrottleRulesResponseBodyDataEnableAutoThrottleList()
                self.enable_auto_throttle_list.append(temp_model.from_map(k))
        if m.get('NeverEnableAutoThrottleOrReleasedInstanceCount') is not None:
            self.never_enable_auto_throttle_or_released_instance_count = m.get('NeverEnableAutoThrottleOrReleasedInstanceCount')
        if m.get('NeverEnableAutoThrottleOrReleasedInstanceIdList') is not None:
            self.never_enable_auto_throttle_or_released_instance_id_list = m.get('NeverEnableAutoThrottleOrReleasedInstanceIdList')
        if m.get('TotalAutoThrottleRulesCount') is not None:
            self.total_auto_throttle_rules_count = m.get('TotalAutoThrottleRulesCount')
        if m.get('TurnOffAutoThrottleCount') is not None:
            self.turn_off_auto_throttle_count = m.get('TurnOffAutoThrottleCount')
        self.turn_off_auto_throttle_list = []
        if m.get('TurnOffAutoThrottleList') is not None:
            for k in m.get('TurnOffAutoThrottleList'):
                temp_model = GetAutoThrottleRulesResponseBodyDataTurnOffAutoThrottleList()
                self.turn_off_auto_throttle_list.append(temp_model.from_map(k))
        return self


class GetAutoThrottleRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetAutoThrottleRulesResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message that contains information such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAutoThrottleRulesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAutoThrottleRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAutoThrottleRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAutoThrottleRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAutonomousNotifyEventContentRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        span_id: str = None,
        context: str = None,
    ):
        # The instance ID.
        self.instance_id = instance_id
        # The unique identifier of the event. You can call the [GetAutonomousNotifyEventsInRange](~~288371~~) operation to query the unique identifier returned by the SpanId response parameter.
        self.span_id = span_id
        # The reserved parameter.
        self.context = context

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.span_id is not None:
            result['SpanId'] = self.span_id
        if self.context is not None:
            result['__context'] = self.context
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SpanId') is not None:
            self.span_id = m.get('SpanId')
        if m.get('__context') is not None:
            self.context = m.get('__context')
        return self


class GetAutonomousNotifyEventContentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The details of the notification events.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAutonomousNotifyEventContentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAutonomousNotifyEventContentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAutonomousNotifyEventContentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAutonomousNotifyEventsInRangeRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        event_context: str = None,
        instance_id: str = None,
        level: str = None,
        min_level: str = None,
        node_id: str = None,
        page_offset: str = None,
        page_size: str = None,
        start_time: str = None,
        context: str = None,
    ):
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time
        # The reserved parameter.
        self.event_context = event_context
        # The instance ID.
        self.instance_id = instance_id
        # The urgency level of the events. If you specify this parameter, the MinLevel parameter does not take effect. Valid values:
        # 
        # *   **Notice**: events for which the system sends notifications.
        # *   **Optimization**: events that need to be optimized.
        # *   **Warn**: events for which the system sends warnings.
        # *   **Critical**: critical events.
        self.level = level
        # The minimum urgency level of the events. Valid values:
        # 
        # *   **Notice**: events for which the system sends notifications.
        # *   **Optimization**: events that need to be optimized.
        # *   **Warn**: events for which the system sends warnings.
        # *   **Critical**: critical events.
        self.min_level = min_level
        # The ID of the node in a PolarDB for MySQL cluster. You can call the [DescribeDBClusters](~~98094~~) operation to query the node ID returned by the DBNodeId response parameter.
        # 
        # >  You must specify the node ID if your database instance is a PolarDB for MySQL cluster.
        self.node_id = node_id
        # The page number. The value must be a positive integer. Default value: 1.
        self.page_offset = page_offset
        # The number of entries per page.
        self.page_size = page_size
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time
        # The reserved parameter.
        self.context = context

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_context is not None:
            result['EventContext'] = self.event_context
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.level is not None:
            result['Level'] = self.level
        if self.min_level is not None:
            result['MinLevel'] = self.min_level
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.page_offset is not None:
            result['PageOffset'] = self.page_offset
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.context is not None:
            result['__context'] = self.context
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventContext') is not None:
            self.event_context = m.get('EventContext')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MinLevel') is not None:
            self.min_level = m.get('MinLevel')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('PageOffset') is not None:
            self.page_offset = m.get('PageOffset')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('__context') is not None:
            self.context = m.get('__context')
        return self


class GetAutonomousNotifyEventsInRangeResponseBodyDataList(TeaModel):
    def __init__(
        self,
        t: List[str] = None,
    ):
        self.t = t

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.t is not None:
            result['T'] = self.t
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('T') is not None:
            self.t = m.get('T')
        return self


class GetAutonomousNotifyEventsInRangeResponseBodyData(TeaModel):
    def __init__(
        self,
        extra: str = None,
        list: GetAutonomousNotifyEventsInRangeResponseBodyDataList = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The reserved parameter.
        self.extra = extra
        # The detailed information, including the error codes and the number of entries that are returned.
        self.list = list
        # The page number.
        self.page_no = page_no
        # The number of entries per page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('List') is not None:
            temp_model = GetAutonomousNotifyEventsInRangeResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetAutonomousNotifyEventsInRangeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAutonomousNotifyEventsInRangeResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information, including the error codes and the number of entries that are returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAutonomousNotifyEventsInRangeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAutonomousNotifyEventsInRangeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAutonomousNotifyEventsInRangeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAutonomousNotifyEventsInRangeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBlockingDetailListRequest(TeaModel):
    def __init__(
        self,
        db_name_list: str = None,
        end_time: str = None,
        instance_id: str = None,
        page_no: str = None,
        page_size: str = None,
        query_hash: str = None,
        start_time: str = None,
    ):
        # The database name list.
        # 
        # *   Separate multiple database names with commas (,).
        self.db_name_list = db_name_list
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.end_time = end_time
        # The database instance ID.
        self.instance_id = instance_id
        # The page number. The value must be an integer that is greater than 0. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. The value must be an integer that is greater than 0. Default value: 10.
        self.page_size = page_size
        # The hash value of the SQL statement.
        self.query_hash = query_hash
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name_list is not None:
            result['DbNameList'] = self.db_name_list
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_hash is not None:
            result['QueryHash'] = self.query_hash
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DbNameList') is not None:
            self.db_name_list = m.get('DbNameList')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryHash') is not None:
            self.query_hash = m.get('QueryHash')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetBlockingDetailListResponseBodyDataList(TeaModel):
    def __init__(
        self,
        batch_id: int = None,
        client_app_name: str = None,
        current_collection_time: int = None,
        data_base: str = None,
        host_name: str = None,
        login_id: str = None,
        query_hash: str = None,
        spid: str = None,
        sql_text: str = None,
        start_time: str = None,
        wait_time_ms: int = None,
        wait_type: str = None,
    ):
        # The batch ID.
        self.batch_id = batch_id
        # The client name.
        self.client_app_name = client_app_name
        # The time when the blocking data was collected.
        self.current_collection_time = current_collection_time
        # The database name.
        self.data_base = data_base
        # The client hostname.
        self.host_name = host_name
        # The username that is used for the logon.
        self.login_id = login_id
        # The hash value of the SQL statement.
        self.query_hash = query_hash
        # The session ID.
        self.spid = spid
        # The SQL statement.
        self.sql_text = sql_text
        # The time when the execution started.
        self.start_time = start_time
        # The blocking duration. Unit: milliseconds.
        self.wait_time_ms = wait_time_ms
        # The wait type.
        self.wait_type = wait_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_id is not None:
            result['BatchId'] = self.batch_id
        if self.client_app_name is not None:
            result['ClientAppName'] = self.client_app_name
        if self.current_collection_time is not None:
            result['CurrentCollectionTime'] = self.current_collection_time
        if self.data_base is not None:
            result['DataBase'] = self.data_base
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.login_id is not None:
            result['LoginId'] = self.login_id
        if self.query_hash is not None:
            result['QueryHash'] = self.query_hash
        if self.spid is not None:
            result['Spid'] = self.spid
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.wait_time_ms is not None:
            result['WaitTimeMs'] = self.wait_time_ms
        if self.wait_type is not None:
            result['WaitType'] = self.wait_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchId') is not None:
            self.batch_id = m.get('BatchId')
        if m.get('ClientAppName') is not None:
            self.client_app_name = m.get('ClientAppName')
        if m.get('CurrentCollectionTime') is not None:
            self.current_collection_time = m.get('CurrentCollectionTime')
        if m.get('DataBase') is not None:
            self.data_base = m.get('DataBase')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('LoginId') is not None:
            self.login_id = m.get('LoginId')
        if m.get('QueryHash') is not None:
            self.query_hash = m.get('QueryHash')
        if m.get('Spid') is not None:
            self.spid = m.get('Spid')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('WaitTimeMs') is not None:
            self.wait_time_ms = m.get('WaitTimeMs')
        if m.get('WaitType') is not None:
            self.wait_type = m.get('WaitType')
        return self


class GetBlockingDetailListResponseBodyData(TeaModel):
    def __init__(
        self,
        list: List[GetBlockingDetailListResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The details of the data returned.
        self.list = list
        # The page number of the page returned.
        self.page_no = page_no
        # The number of entries returned on each page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetBlockingDetailListResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetBlockingDetailListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetBlockingDetailListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        # 
        # >  If the request is successful, **Successful** is returned. Otherwise, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   true
        # *   false
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetBlockingDetailListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBlockingDetailListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetBlockingDetailListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetBlockingDetailListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDBInstanceConnectivityDiagnosisRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        src_ip: str = None,
    ):
        # The instance ID.
        self.instance_id = instance_id
        # The source IP address.
        self.src_ip = src_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.src_ip is not None:
            result['SrcIp'] = self.src_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SrcIp') is not None:
            self.src_ip = m.get('SrcIp')
        return self


class GetDBInstanceConnectivityDiagnosisResponseBodyData(TeaModel):
    def __init__(
        self,
        conn_check_error_code: str = None,
        conn_check_error_message: str = None,
        fail_type: str = None,
        instance_id: str = None,
        success: bool = None,
    ):
        # The exception detection items:
        # 
        # *   **SRC_IP_NOT_IN_USER_WHITELIST**: The source IP address is not added to the whitelist of the user.
        # *   **VIP_NOT_EXISTS**: The Application Load Balancer (ALB) instance corresponding to the virtual IP address (VIP) does not exist.
        # *   **RS_NOT_EXISTS**: The resource sharing (RS) is not properly mounted.
        # *   **VIP_TUNNEL_ID_NOT_CONSISTENT**: The tunnel ID used by the VIP of the virtual private cloud (VPC) type is different from the tunnel ID of the VPC.
        # *   **VIP_VPC_CLOUD_INSTANCE_NOT_EXISTS**: The VIP of the VPC type does not exist.
        # *   **VIP_IS_NOT_NGLB**: The NGLB mode is disabled for the VIP.
        # *   **CUSTINS_NOT_ASSOCIATE_ECS_SECURITY_GROUP**: No security group is associated with the instance.
        # *   **SRC_IP_NOT_IN_USER_WHITELIST**: The source IP address is not added to the whitelist of the user.
        # *   **SRC_IP_NOT_IN_ADMIN_WHITELIST**: The source IP address is not added to the whitelist of the instance.
        # *   **SRC_IP_NOT_IN_ECS_SECURITY_GROUP**: The source IP address is not added to the security group that is associated with the instance.
        # *   **VPC_INSTANCE_IP_NOT_WORKING_STATUS**: The IP address in the VPC is in an abnormal state.
        self.conn_check_error_code = conn_check_error_code
        # The details of the exception detection.
        self.conn_check_error_message = conn_check_error_message
        # The type of the exception:
        # 
        # *   **0**: an exception that can be handled by the user.
        # *   **1**: an exception that can be handled by a technical engineer.
        self.fail_type = fail_type
        # The instance ID.
        self.instance_id = instance_id
        # Indicates whether the connectivity test was passed:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conn_check_error_code is not None:
            result['connCheckErrorCode'] = self.conn_check_error_code
        if self.conn_check_error_message is not None:
            result['connCheckErrorMessage'] = self.conn_check_error_message
        if self.fail_type is not None:
            result['failType'] = self.fail_type
        if self.instance_id is not None:
            result['instanceId'] = self.instance_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('connCheckErrorCode') is not None:
            self.conn_check_error_code = m.get('connCheckErrorCode')
        if m.get('connCheckErrorMessage') is not None:
            self.conn_check_error_message = m.get('connCheckErrorMessage')
        if m.get('failType') is not None:
            self.fail_type = m.get('failType')
        if m.get('instanceId') is not None:
            self.instance_id = m.get('instanceId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GetDBInstanceConnectivityDiagnosisResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetDBInstanceConnectivityDiagnosisResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information.
        self.data = data
        # The returned message.
        # 
        # > If the request was successful, **Successful** is returned. Otherwise, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDBInstanceConnectivityDiagnosisResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDBInstanceConnectivityDiagnosisResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDBInstanceConnectivityDiagnosisResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDBInstanceConnectivityDiagnosisResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDasProServiceUsageRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        user_id: str = None,
    ):
        # The database instance ID.
        self.instance_id = instance_id
        # The ID of the Alibaba Cloud account that is used to create the database instance.
        # 
        # >  This parameter is optional. The system can automatically obtain the account ID based on the value of InstanceId when you call this operation.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetDasProServiceUsageResponseBodyData(TeaModel):
    def __init__(
        self,
        commodity_instance_id: str = None,
        engine: str = None,
        expire_time: int = None,
        instance_alias: str = None,
        instance_id: str = None,
        ip: str = None,
        is_spare: bool = None,
        migration_predict_remaining_time: int = None,
        port: int = None,
        region: str = None,
        service_unit_id: str = None,
        sql_retention: str = None,
        start_time: int = None,
        storage_free_quota_in_mb: float = None,
        storage_used: int = None,
        user_id: str = None,
        vpc_id: str = None,
    ):
        # The ID of the DAS Professional Edition instance.
        self.commodity_instance_id = commodity_instance_id
        # The type of the database engine.
        self.engine = engine
        # The point of time when DAS Professional Edition for the database instance expires. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.expire_time = expire_time
        # The name of the database instance.
        self.instance_alias = instance_alias
        # The database instance ID.
        self.instance_id = instance_id
        # The endpoint of the database instance.
        self.ip = ip
        # Indicates whether DAS Professional Edition for the database instance has expired. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.is_spare = is_spare
        # The estimated remaining time for migrating the data generated by the SQL Explorer and Audit feature from the previous version to the new version. Unit: milliseconds.
        # 
        # >  This parameter is returned only when the SQL Explorer and Audit feature is migrated from the previous version to the new version.
        self.migration_predict_remaining_time = migration_predict_remaining_time
        # The port number that is used to connect to the database instance.
        self.port = port
        # The region in which the database instance resides.
        self.region = region
        # The service unit ID.
        self.service_unit_id = service_unit_id
        # The storage duration of SQL Explorer data. Unit: days.
        self.sql_retention = sql_retention
        # The time when DAS Professional Edition was enabled for the database instance. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time
        # The SQL Explorer storage space that is offered free-of-charge. Unit: MB.
        self.storage_free_quota_in_mb = storage_free_quota_in_mb
        # The storage usage of SQL Explorer of the database instance. Unit: bytes.
        self.storage_used = storage_used
        # The ID of the Alibaba Cloud account that is used to create the database instance.
        self.user_id = user_id
        # The virtual private cloud (VPC) ID.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_instance_id is not None:
            result['commodityInstanceId'] = self.commodity_instance_id
        if self.engine is not None:
            result['engine'] = self.engine
        if self.expire_time is not None:
            result['expireTime'] = self.expire_time
        if self.instance_alias is not None:
            result['instanceAlias'] = self.instance_alias
        if self.instance_id is not None:
            result['instanceId'] = self.instance_id
        if self.ip is not None:
            result['ip'] = self.ip
        if self.is_spare is not None:
            result['isSpare'] = self.is_spare
        if self.migration_predict_remaining_time is not None:
            result['migrationPredictRemainingTime'] = self.migration_predict_remaining_time
        if self.port is not None:
            result['port'] = self.port
        if self.region is not None:
            result['region'] = self.region
        if self.service_unit_id is not None:
            result['serviceUnitId'] = self.service_unit_id
        if self.sql_retention is not None:
            result['sqlRetention'] = self.sql_retention
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.storage_free_quota_in_mb is not None:
            result['storageFreeQuotaInMB'] = self.storage_free_quota_in_mb
        if self.storage_used is not None:
            result['storageUsed'] = self.storage_used
        if self.user_id is not None:
            result['userId'] = self.user_id
        if self.vpc_id is not None:
            result['vpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commodityInstanceId') is not None:
            self.commodity_instance_id = m.get('commodityInstanceId')
        if m.get('engine') is not None:
            self.engine = m.get('engine')
        if m.get('expireTime') is not None:
            self.expire_time = m.get('expireTime')
        if m.get('instanceAlias') is not None:
            self.instance_alias = m.get('instanceAlias')
        if m.get('instanceId') is not None:
            self.instance_id = m.get('instanceId')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('isSpare') is not None:
            self.is_spare = m.get('isSpare')
        if m.get('migrationPredictRemainingTime') is not None:
            self.migration_predict_remaining_time = m.get('migrationPredictRemainingTime')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('serviceUnitId') is not None:
            self.service_unit_id = m.get('serviceUnitId')
        if m.get('sqlRetention') is not None:
            self.sql_retention = m.get('sqlRetention')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('storageFreeQuotaInMB') is not None:
            self.storage_free_quota_in_mb = m.get('storageFreeQuotaInMB')
        if m.get('storageUsed') is not None:
            self.storage_used = m.get('storageUsed')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        if m.get('vpcId') is not None:
            self.vpc_id = m.get('vpcId')
        return self


class GetDasProServiceUsageResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetDasProServiceUsageResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDasProServiceUsageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDasProServiceUsageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDasProServiceUsageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDasProServiceUsageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDasSQLLogHotDataRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        child_dbinstance_ids: str = None,
        dbname: str = None,
        end: int = None,
        fail: str = None,
        host_address: str = None,
        instance_id: str = None,
        logical_operator: str = None,
        max_latancy: int = None,
        max_records_per_page: int = None,
        max_rows: int = None,
        max_scan_rows: int = None,
        max_spill_cnt: int = None,
        min_latancy: int = None,
        min_rows: int = None,
        min_scan_rows: int = None,
        min_spill_cnt: int = None,
        page_numbers: int = None,
        query_keyword: str = None,
        role: str = None,
        sort_key: str = None,
        sort_method: str = None,
        sql_type: str = None,
        start: int = None,
        state: str = None,
        thread_id: str = None,
        trace_id: str = None,
        transaction_id: str = None,
    ):
        # The account of the database.
        # 
        # >  You can specify multiple database accounts that are separated by spaces. Example: `user1 user2 user3`.
        self.account_name = account_name
        # The node ID.
        # 
        # >  This parameter must be specified if the database instance is a PolarDB for MySQL cluster.
        self.child_dbinstance_ids = child_dbinstance_ids
        # The name of the database.
        # 
        # >  You can specify multiple database names that are separated by spaces. Example: `DB1 DB2 DB3`.
        self.dbname = dbname
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time. The interval between the start time and the end time cannot exceed 24 hours.
        self.end = end
        # The error code of SQL execution. You can call the [GetAsyncErrorRequestStatByCode](~~409804~~) operation to query MySQL error codes in SQL Explorer data.
        self.fail = fail
        # The IP address of the client.
        # 
        # >  You can specify multiple IP addresses that are separated by spaces. Example: `IP1 IP2 IP3`.
        self.host_address = host_address
        # The ID of the database instance.
        self.instance_id = instance_id
        # The logical relationship among multiple keywords.
        # 
        # *   **or**\
        # *   **and**\
        self.logical_operator = logical_operator
        # The maximum execution duration. Unit: microseconds. You can specify this parameter to query the SQL statements whose execution duration is smaller than the value of this parameter.
        self.max_latancy = max_latancy
        # The maximum number of entries per page. Valid values: 5 to 100.
        self.max_records_per_page = max_records_per_page
        # The reserved parameter. This parameter is not supported.
        self.max_rows = max_rows
        # The maximum number of scanned rows. You can specify this parameter to query the SQL statements that scan a smaller number of rows than the value of this parameter.
        self.max_scan_rows = max_scan_rows
        # The reserved parameter. This parameter is not supported.
        self.max_spill_cnt = max_spill_cnt
        # The minimum execution duration. Unit: microseconds. You can specify this parameter to query the SQL statements whose execution duration is greater than or equal to the value of this parameter.
        self.min_latancy = min_latancy
        # The reserved parameter. This parameter is not supported.
        self.min_rows = min_rows
        # The minimum number of scanned rows. You can specify this parameter to query the SQL statements that scan a larger or an equal number of rows than the value of this parameter.
        self.min_scan_rows = min_scan_rows
        # The reserved parameter. This parameter is not supported.
        self.min_spill_cnt = min_spill_cnt
        # The page number. Pages start from page 1. Default value: 1.
        self.page_numbers = page_numbers
        # The keyword that is used for the query.
        # 
        # >  The keyword must be at least four characters in length. You can specify multiple keywords that are separated by spaces. Fuzzy queries are not supported.
        self.query_keyword = query_keyword
        # The reserved parameter. This parameter is not supported.
        self.role = role
        # The basis on which you want to sort the query results.
        # 
        # *   **SCAN_ROWS**: the number of scanned rows.
        # *   **UPDATE_ROWS**: the number of updated rows.
        # *   **CONSUME**: the time consumed.
        # *   **ORIGIN_TIME**: the execution duration.
        self.sort_key = sort_key
        # The order in which you want to sort the query results.
        # 
        # *   **ase**: ascending order.
        # *   **desc**: descending order.
        self.sort_method = sort_method
        # The type of the SQL statement. Valid values:
        # 
        # *   **SELECT**\
        # *   **UPDATE**\
        # *   **DELETE**\
        self.sql_type = sql_type
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  You can query only the data that is generated after the new SQL Explorer and Audit feature is enabled. The start time can be up to seven days earlier than the current time.
        self.start = start
        # The execution results. You can specify **0** to query the SQL statements that are successfully executed. You can also specify an error code to query the corresponding SQL statements that fail to be executed.
        self.state = state
        # The thread ID.
        # 
        # >  You can specify multiple thread IDs that are separated by spaces. Example: `Thread ID1 Thread ID2 Thread ID3`.
        self.thread_id = thread_id
        # The reserved parameter. This parameter is not supported.
        self.trace_id = trace_id
        # The transaction ID.
        self.transaction_id = transaction_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.child_dbinstance_ids is not None:
            result['ChildDBInstanceIDs'] = self.child_dbinstance_ids
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.end is not None:
            result['End'] = self.end
        if self.fail is not None:
            result['Fail'] = self.fail
        if self.host_address is not None:
            result['HostAddress'] = self.host_address
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.logical_operator is not None:
            result['LogicalOperator'] = self.logical_operator
        if self.max_latancy is not None:
            result['MaxLatancy'] = self.max_latancy
        if self.max_records_per_page is not None:
            result['MaxRecordsPerPage'] = self.max_records_per_page
        if self.max_rows is not None:
            result['MaxRows'] = self.max_rows
        if self.max_scan_rows is not None:
            result['MaxScanRows'] = self.max_scan_rows
        if self.max_spill_cnt is not None:
            result['MaxSpillCnt'] = self.max_spill_cnt
        if self.min_latancy is not None:
            result['MinLatancy'] = self.min_latancy
        if self.min_rows is not None:
            result['MinRows'] = self.min_rows
        if self.min_scan_rows is not None:
            result['MinScanRows'] = self.min_scan_rows
        if self.min_spill_cnt is not None:
            result['MinSpillCnt'] = self.min_spill_cnt
        if self.page_numbers is not None:
            result['PageNumbers'] = self.page_numbers
        if self.query_keyword is not None:
            result['QueryKeyword'] = self.query_keyword
        if self.role is not None:
            result['Role'] = self.role
        if self.sort_key is not None:
            result['SortKey'] = self.sort_key
        if self.sort_method is not None:
            result['SortMethod'] = self.sort_method
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.start is not None:
            result['Start'] = self.start
        if self.state is not None:
            result['State'] = self.state
        if self.thread_id is not None:
            result['ThreadID'] = self.thread_id
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.transaction_id is not None:
            result['TransactionId'] = self.transaction_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ChildDBInstanceIDs') is not None:
            self.child_dbinstance_ids = m.get('ChildDBInstanceIDs')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('Fail') is not None:
            self.fail = m.get('Fail')
        if m.get('HostAddress') is not None:
            self.host_address = m.get('HostAddress')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LogicalOperator') is not None:
            self.logical_operator = m.get('LogicalOperator')
        if m.get('MaxLatancy') is not None:
            self.max_latancy = m.get('MaxLatancy')
        if m.get('MaxRecordsPerPage') is not None:
            self.max_records_per_page = m.get('MaxRecordsPerPage')
        if m.get('MaxRows') is not None:
            self.max_rows = m.get('MaxRows')
        if m.get('MaxScanRows') is not None:
            self.max_scan_rows = m.get('MaxScanRows')
        if m.get('MaxSpillCnt') is not None:
            self.max_spill_cnt = m.get('MaxSpillCnt')
        if m.get('MinLatancy') is not None:
            self.min_latancy = m.get('MinLatancy')
        if m.get('MinRows') is not None:
            self.min_rows = m.get('MinRows')
        if m.get('MinScanRows') is not None:
            self.min_scan_rows = m.get('MinScanRows')
        if m.get('MinSpillCnt') is not None:
            self.min_spill_cnt = m.get('MinSpillCnt')
        if m.get('PageNumbers') is not None:
            self.page_numbers = m.get('PageNumbers')
        if m.get('QueryKeyword') is not None:
            self.query_keyword = m.get('QueryKeyword')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SortKey') is not None:
            self.sort_key = m.get('SortKey')
        if m.get('SortMethod') is not None:
            self.sort_method = m.get('SortMethod')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('ThreadID') is not None:
            self.thread_id = m.get('ThreadID')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('TransactionId') is not None:
            self.transaction_id = m.get('TransactionId')
        return self


class GetDasSQLLogHotDataResponseBodyDataList(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        dbname: str = None,
        execute_time: str = None,
        ext: str = None,
        host_address: str = None,
        latancy: int = None,
        lock_time: int = None,
        logic_read: int = None,
        origin_time: str = None,
        physic_async_read: int = None,
        physic_sync_read: int = None,
        return_rows: int = None,
        sqltext: str = None,
        scan_rows: int = None,
        sql_type: str = None,
        state: str = None,
        thread_id: int = None,
        transaction_id: str = None,
        update_rows: int = None,
    ):
        # The account of the database.
        self.account_name = account_name
        # The name of the database.
        self.dbname = dbname
        # The execution time. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.execute_time = execute_time
        # The extended information. This parameter is a reserved parameter.
        self.ext = ext
        # The IP address of the client.
        self.host_address = host_address
        # The execution duration. Unit: microseconds.
        self.latancy = latancy
        # The lock wait duration. Unit: microseconds.
        self.lock_time = lock_time
        # The number of logical reads.
        self.logic_read = logic_read
        # The execution time. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        self.origin_time = origin_time
        # The number of physical asynchronous reads.
        self.physic_async_read = physic_async_read
        # The number of physical synchronous reads.
        self.physic_sync_read = physic_sync_read
        # The number of rows returned.
        self.return_rows = return_rows
        # The content of the SQL statement.
        self.sqltext = sqltext
        # The number of rows scanned by the SQL statement.
        self.scan_rows = scan_rows
        # The type of the SQL statement. Valid values:
        # 
        # * **SELECT**\
        # * **UPDATE**\
        # * **DELETE**\
        self.sql_type = sql_type
        # The execution result. If a **0** is returned, the SQL statement was successfully executed. If an error code is returned, the SQL statement failed to be executed.
        self.state = state
        # The thread ID.
        self.thread_id = thread_id
        # The transaction ID.
        self.transaction_id = transaction_id
        # The number of updated rows.
        self.update_rows = update_rows

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.dbname is not None:
            result['DBName'] = self.dbname
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.ext is not None:
            result['Ext'] = self.ext
        if self.host_address is not None:
            result['HostAddress'] = self.host_address
        if self.latancy is not None:
            result['Latancy'] = self.latancy
        if self.lock_time is not None:
            result['LockTime'] = self.lock_time
        if self.logic_read is not None:
            result['LogicRead'] = self.logic_read
        if self.origin_time is not None:
            result['OriginTime'] = self.origin_time
        if self.physic_async_read is not None:
            result['PhysicAsyncRead'] = self.physic_async_read
        if self.physic_sync_read is not None:
            result['PhysicSyncRead'] = self.physic_sync_read
        if self.return_rows is not None:
            result['ReturnRows'] = self.return_rows
        if self.sqltext is not None:
            result['SQLText'] = self.sqltext
        if self.scan_rows is not None:
            result['ScanRows'] = self.scan_rows
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.state is not None:
            result['State'] = self.state
        if self.thread_id is not None:
            result['ThreadID'] = self.thread_id
        if self.transaction_id is not None:
            result['TransactionId'] = self.transaction_id
        if self.update_rows is not None:
            result['UpdateRows'] = self.update_rows
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DBName') is not None:
            self.dbname = m.get('DBName')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('Ext') is not None:
            self.ext = m.get('Ext')
        if m.get('HostAddress') is not None:
            self.host_address = m.get('HostAddress')
        if m.get('Latancy') is not None:
            self.latancy = m.get('Latancy')
        if m.get('LockTime') is not None:
            self.lock_time = m.get('LockTime')
        if m.get('LogicRead') is not None:
            self.logic_read = m.get('LogicRead')
        if m.get('OriginTime') is not None:
            self.origin_time = m.get('OriginTime')
        if m.get('PhysicAsyncRead') is not None:
            self.physic_async_read = m.get('PhysicAsyncRead')
        if m.get('PhysicSyncRead') is not None:
            self.physic_sync_read = m.get('PhysicSyncRead')
        if m.get('ReturnRows') is not None:
            self.return_rows = m.get('ReturnRows')
        if m.get('SQLText') is not None:
            self.sqltext = m.get('SQLText')
        if m.get('ScanRows') is not None:
            self.scan_rows = m.get('ScanRows')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('ThreadID') is not None:
            self.thread_id = m.get('ThreadID')
        if m.get('TransactionId') is not None:
            self.transaction_id = m.get('TransactionId')
        if m.get('UpdateRows') is not None:
            self.update_rows = m.get('UpdateRows')
        return self


class GetDasSQLLogHotDataResponseBodyData(TeaModel):
    def __init__(
        self,
        extra: Any = None,
        list: List[GetDasSQLLogHotDataResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The reserved parameter.
        self.extra = extra
        # The details of the data returned.
        self.list = list
        # The page number.
        self.page_no = page_no
        # The number of entries per page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra is not None:
            result['Extra'] = self.extra
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetDasSQLLogHotDataResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetDasSQLLogHotDataResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetDasSQLLogHotDataResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # > If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDasSQLLogHotDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDasSQLLogHotDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDasSQLLogHotDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDasSQLLogHotDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeadLockDetailListRequest(TeaModel):
    def __init__(
        self,
        db_name_list: str = None,
        end_time: str = None,
        instance_id: str = None,
        page_no: str = None,
        page_size: str = None,
        start_time: str = None,
    ):
        # The database name list.
        self.db_name_list = db_name_list
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.end_time = end_time
        # The instance ID.
        self.instance_id = instance_id
        # The page number. The value must be an integer that is greater than 0. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name_list is not None:
            result['DbNameList'] = self.db_name_list
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DbNameList') is not None:
            self.db_name_list = m.get('DbNameList')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetDeadLockDetailListResponseBodyDataListBlockProcessList(TeaModel):
    def __init__(
        self,
        client_app: str = None,
        database_name: str = None,
        host_name: str = None,
        last_tran_started: int = None,
        lock_mode: str = None,
        log_used: int = None,
        login_name: str = None,
        object_owned: str = None,
        object_requested: str = None,
        own_mode: str = None,
        spid: int = None,
        sql_text: str = None,
        status: str = None,
        victim: int = None,
        wait_mode: str = None,
        wait_resource: str = None,
        wait_resource_description: str = None,
    ):
        # The client application.
        self.client_app = client_app
        # The database name.
        self.database_name = database_name
        # The host name.
        self.host_name = host_name
        # The time when the transaction started.
        self.last_tran_started = last_tran_started
        # The lock mode.
        self.lock_mode = lock_mode
        # The size of the logs generated by the session.
        self.log_used = log_used
        # The username that is used for login.
        self.login_name = login_name
        # The locked object.
        self.object_owned = object_owned
        # The object that the current transaction requested to lock.
        self.object_requested = object_requested
        # The holding mode.
        self.own_mode = own_mode
        # The ID of the session that started the transaction.
        self.spid = spid
        # The SQL statement.
        self.sql_text = sql_text
        # The transaction status.
        self.status = status
        # The victim.
        self.victim = victim
        # The wait mode.
        self.wait_mode = wait_mode
        # The pending resource.
        self.wait_resource = wait_resource
        # The description of the pending resource.
        self.wait_resource_description = wait_resource_description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_app is not None:
            result['ClientApp'] = self.client_app
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.last_tran_started is not None:
            result['LastTranStarted'] = self.last_tran_started
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.log_used is not None:
            result['LogUsed'] = self.log_used
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.object_owned is not None:
            result['ObjectOwned'] = self.object_owned
        if self.object_requested is not None:
            result['ObjectRequested'] = self.object_requested
        if self.own_mode is not None:
            result['OwnMode'] = self.own_mode
        if self.spid is not None:
            result['Spid'] = self.spid
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        if self.status is not None:
            result['Status'] = self.status
        if self.victim is not None:
            result['Victim'] = self.victim
        if self.wait_mode is not None:
            result['WaitMode'] = self.wait_mode
        if self.wait_resource is not None:
            result['WaitResource'] = self.wait_resource
        if self.wait_resource_description is not None:
            result['WaitResourceDescription'] = self.wait_resource_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientApp') is not None:
            self.client_app = m.get('ClientApp')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('LastTranStarted') is not None:
            self.last_tran_started = m.get('LastTranStarted')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('LogUsed') is not None:
            self.log_used = m.get('LogUsed')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('ObjectOwned') is not None:
            self.object_owned = m.get('ObjectOwned')
        if m.get('ObjectRequested') is not None:
            self.object_requested = m.get('ObjectRequested')
        if m.get('OwnMode') is not None:
            self.own_mode = m.get('OwnMode')
        if m.get('Spid') is not None:
            self.spid = m.get('Spid')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Victim') is not None:
            self.victim = m.get('Victim')
        if m.get('WaitMode') is not None:
            self.wait_mode = m.get('WaitMode')
        if m.get('WaitResource') is not None:
            self.wait_resource = m.get('WaitResource')
        if m.get('WaitResourceDescription') is not None:
            self.wait_resource_description = m.get('WaitResourceDescription')
        return self


class GetDeadLockDetailListResponseBodyDataList(TeaModel):
    def __init__(
        self,
        batch_id: int = None,
        block_process_list: List[GetDeadLockDetailListResponseBodyDataListBlockProcessList] = None,
        client_app: str = None,
        database_name: str = None,
        host_name: str = None,
        last_tran_started: int = None,
        lock_mode: str = None,
        log_used: int = None,
        login_name: str = None,
        object_owned: str = None,
        object_requested: str = None,
        own_mode: str = None,
        spid: int = None,
        sql_text: str = None,
        status: str = None,
        victim: int = None,
        wait_mode: str = None,
        wait_resource: str = None,
        wait_resource_description: str = None,
    ):
        # The time when the data was collected.
        self.batch_id = batch_id
        # The blocking list.
        self.block_process_list = block_process_list
        # The client application.
        self.client_app = client_app
        # The database name.
        self.database_name = database_name
        # The host name.
        self.host_name = host_name
        # The time when the transaction started.
        self.last_tran_started = last_tran_started
        # The lock mode.
        self.lock_mode = lock_mode
        # The size of the logs generated by the session.
        self.log_used = log_used
        # The username that is used for login.
        self.login_name = login_name
        # The locked object.
        self.object_owned = object_owned
        # The object that the current transaction requested to lock.
        self.object_requested = object_requested
        # The holding mode.
        self.own_mode = own_mode
        # The ID of the session that started the transaction.
        self.spid = spid
        # The SQL statement.
        self.sql_text = sql_text
        # The transaction status.
        self.status = status
        # The victim.
        self.victim = victim
        # The wait mode.
        self.wait_mode = wait_mode
        # The pending resource.
        self.wait_resource = wait_resource
        # The description of the pending resource.
        self.wait_resource_description = wait_resource_description

    def validate(self):
        if self.block_process_list:
            for k in self.block_process_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_id is not None:
            result['BatchId'] = self.batch_id
        result['BlockProcessList'] = []
        if self.block_process_list is not None:
            for k in self.block_process_list:
                result['BlockProcessList'].append(k.to_map() if k else None)
        if self.client_app is not None:
            result['ClientApp'] = self.client_app
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.last_tran_started is not None:
            result['LastTranStarted'] = self.last_tran_started
        if self.lock_mode is not None:
            result['LockMode'] = self.lock_mode
        if self.log_used is not None:
            result['LogUsed'] = self.log_used
        if self.login_name is not None:
            result['LoginName'] = self.login_name
        if self.object_owned is not None:
            result['ObjectOwned'] = self.object_owned
        if self.object_requested is not None:
            result['ObjectRequested'] = self.object_requested
        if self.own_mode is not None:
            result['OwnMode'] = self.own_mode
        if self.spid is not None:
            result['Spid'] = self.spid
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        if self.status is not None:
            result['Status'] = self.status
        if self.victim is not None:
            result['Victim'] = self.victim
        if self.wait_mode is not None:
            result['WaitMode'] = self.wait_mode
        if self.wait_resource is not None:
            result['WaitResource'] = self.wait_resource
        if self.wait_resource_description is not None:
            result['WaitResourceDescription'] = self.wait_resource_description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchId') is not None:
            self.batch_id = m.get('BatchId')
        self.block_process_list = []
        if m.get('BlockProcessList') is not None:
            for k in m.get('BlockProcessList'):
                temp_model = GetDeadLockDetailListResponseBodyDataListBlockProcessList()
                self.block_process_list.append(temp_model.from_map(k))
        if m.get('ClientApp') is not None:
            self.client_app = m.get('ClientApp')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('LastTranStarted') is not None:
            self.last_tran_started = m.get('LastTranStarted')
        if m.get('LockMode') is not None:
            self.lock_mode = m.get('LockMode')
        if m.get('LogUsed') is not None:
            self.log_used = m.get('LogUsed')
        if m.get('LoginName') is not None:
            self.login_name = m.get('LoginName')
        if m.get('ObjectOwned') is not None:
            self.object_owned = m.get('ObjectOwned')
        if m.get('ObjectRequested') is not None:
            self.object_requested = m.get('ObjectRequested')
        if m.get('OwnMode') is not None:
            self.own_mode = m.get('OwnMode')
        if m.get('Spid') is not None:
            self.spid = m.get('Spid')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Victim') is not None:
            self.victim = m.get('Victim')
        if m.get('WaitMode') is not None:
            self.wait_mode = m.get('WaitMode')
        if m.get('WaitResource') is not None:
            self.wait_resource = m.get('WaitResource')
        if m.get('WaitResourceDescription') is not None:
            self.wait_resource_description = m.get('WaitResourceDescription')
        return self


class GetDeadLockDetailListResponseBodyData(TeaModel):
    def __init__(
        self,
        list: List[GetDeadLockDetailListResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The details of the data returned.
        self.list = list
        # The page number of the returned page.
        self.page_no = page_no
        # The number of entries returned on each page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetDeadLockDetailListResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetDeadLockDetailListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetDeadLockDetailListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        # 
        # >  If the request is successful, **Successful** is returned. Otherwise, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDeadLockDetailListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeadLockDetailListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDeadLockDetailListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDeadLockDetailListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEndpointSwitchTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        uid: str = None,
        user_id: str = None,
        context: str = None,
        access_key: str = None,
        signature: str = None,
        skip_auth: str = None,
        timestamp: str = None,
    ):
        self.task_id = task_id
        self.uid = uid
        self.user_id = user_id
        self.context = context
        self.access_key = access_key
        self.signature = signature
        self.skip_auth = skip_auth
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.uid is not None:
            result['Uid'] = self.uid
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.context is not None:
            result['__context'] = self.context
        if self.access_key is not None:
            result['accessKey'] = self.access_key
        if self.signature is not None:
            result['signature'] = self.signature
        if self.skip_auth is not None:
            result['skipAuth'] = self.skip_auth
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Uid') is not None:
            self.uid = m.get('Uid')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('__context') is not None:
            self.context = m.get('__context')
        if m.get('accessKey') is not None:
            self.access_key = m.get('accessKey')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('skipAuth') is not None:
            self.skip_auth = m.get('skipAuth')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class GetEndpointSwitchTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        db_link_id: int = None,
        err_msg: str = None,
        ori_uuid: str = None,
        status: str = None,
        task_id: str = None,
        uuid: str = None,
    ):
        self.account_id = account_id
        self.db_link_id = db_link_id
        self.err_msg = err_msg
        self.ori_uuid = ori_uuid
        self.status = status
        self.task_id = task_id
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.db_link_id is not None:
            result['DbLinkId'] = self.db_link_id
        if self.err_msg is not None:
            result['ErrMsg'] = self.err_msg
        if self.ori_uuid is not None:
            result['OriUuid'] = self.ori_uuid
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('DbLinkId') is not None:
            self.db_link_id = m.get('DbLinkId')
        if m.get('ErrMsg') is not None:
            self.err_msg = m.get('ErrMsg')
        if m.get('OriUuid') is not None:
            self.ori_uuid = m.get('OriUuid')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class GetEndpointSwitchTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetEndpointSwitchTaskResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
        synchro: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success
        self.synchro = synchro

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.synchro is not None:
            result['Synchro'] = self.synchro
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetEndpointSwitchTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Synchro') is not None:
            self.synchro = m.get('Synchro')
        return self


class GetEndpointSwitchTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEndpointSwitchTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEndpointSwitchTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetErrorRequestSampleRequest(TeaModel):
    def __init__(
        self,
        db_name: str = None,
        end: int = None,
        instance_id: str = None,
        node_id: str = None,
        sql_id: str = None,
        start: int = None,
    ):
        # The name of the database.
        self.db_name = db_name
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time. The interval cannot exceed 24 hours.
        self.end = end
        # The instance ID.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  You must specify the node ID if your database instance is a PolarDB for MySQL cluster.
        self.node_id = node_id
        # The SQL query ID. You can call the [GetAsyncErrorRequestListByCode](~~410746~~) operation to query the ID of the SQL query for which MySQL error code is returned.
        self.sql_id = sql_id
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The start time must be within the storage duration of the SQL Explorer feature of the database instance, and can be up to 90 days earlier than the current time.
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.end is not None:
            result['End'] = self.end
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class GetErrorRequestSampleResponseBodyData(TeaModel):
    def __init__(
        self,
        database: str = None,
        error_code: str = None,
        instance_id: str = None,
        origin_host: str = None,
        sql: str = None,
        sql_id: str = None,
        tables: List[str] = None,
        timestamp: int = None,
        user: str = None,
    ):
        # The database name.
        self.database = database
        # The error code that is returned.
        self.error_code = error_code
        # The instance ID.
        self.instance_id = instance_id
        # The IP address of the client that executes the SQL statement.
        self.origin_host = origin_host
        # The SQL statement.
        self.sql = sql
        # The SQL query ID.
        self.sql_id = sql_id
        # The table information.
        self.tables = tables
        # The time when the SQL query was executed. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp
        # The username of the account that is used to log on to the database.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['database'] = self.database
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.instance_id is not None:
            result['instanceId'] = self.instance_id
        if self.origin_host is not None:
            result['originHost'] = self.origin_host
        if self.sql is not None:
            result['sql'] = self.sql
        if self.sql_id is not None:
            result['sqlId'] = self.sql_id
        if self.tables is not None:
            result['tables'] = self.tables
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.user is not None:
            result['user'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('database') is not None:
            self.database = m.get('database')
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('instanceId') is not None:
            self.instance_id = m.get('instanceId')
        if m.get('originHost') is not None:
            self.origin_host = m.get('originHost')
        if m.get('sql') is not None:
            self.sql = m.get('sql')
        if m.get('sqlId') is not None:
            self.sql_id = m.get('sqlId')
        if m.get('tables') is not None:
            self.tables = m.get('tables')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('user') is not None:
            self.user = m.get('user')
        return self


class GetErrorRequestSampleResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[GetErrorRequestSampleResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetErrorRequestSampleResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetErrorRequestSampleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetErrorRequestSampleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetErrorRequestSampleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEventSubscriptionRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The instance ID.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetEventSubscriptionResponseBodyDataContactGroups(TeaModel):
    def __init__(
        self,
        contacts: str = None,
        description: str = None,
        name: str = None,
        user_id: str = None,
    ):
        # The members of the alert contact group.
        self.contacts = contacts
        # The description of the alert contact group.
        self.description = description
        # The name of the alert contact group.
        self.name = name
        # The user ID.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contacts is not None:
            result['contacts'] = self.contacts
        if self.description is not None:
            result['description'] = self.description
        if self.name is not None:
            result['name'] = self.name
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('contacts') is not None:
            self.contacts = m.get('contacts')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class GetEventSubscriptionResponseBodyDataContacts(TeaModel):
    def __init__(
        self,
        dingtalk_hook: str = None,
        email: str = None,
        groups: List[str] = None,
        is_cms_reduplicated: bool = None,
        name: str = None,
        phone: str = None,
        user_id: str = None,
    ):
        # The webhook URL of the DingTalk chatbot.
        self.dingtalk_hook = dingtalk_hook
        # The email address of the alert contact.
        self.email = email
        # The contact groups to which the alert contact belongs.
        self.groups = groups
        # Indicates whether the alert contact name is the same as the contact name on CloudMonitor.
        # 
        # * **true**\
        # * **false**\
        self.is_cms_reduplicated = is_cms_reduplicated
        # The name of the alert contact.
        self.name = name
        # The mobile number of the alert contact.
        self.phone = phone
        # The user ID.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dingtalk_hook is not None:
            result['dingtalkHook'] = self.dingtalk_hook
        if self.email is not None:
            result['email'] = self.email
        if self.groups is not None:
            result['groups'] = self.groups
        if self.is_cms_reduplicated is not None:
            result['isCmsReduplicated'] = self.is_cms_reduplicated
        if self.name is not None:
            result['name'] = self.name
        if self.phone is not None:
            result['phone'] = self.phone
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dingtalkHook') is not None:
            self.dingtalk_hook = m.get('dingtalkHook')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('groups') is not None:
            self.groups = m.get('groups')
        if m.get('isCmsReduplicated') is not None:
            self.is_cms_reduplicated = m.get('isCmsReduplicated')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class GetEventSubscriptionResponseBodyData(TeaModel):
    def __init__(
        self,
        active: int = None,
        channel_type: str = None,
        contact_group_name: str = None,
        contact_groups: List[GetEventSubscriptionResponseBodyDataContactGroups] = None,
        contact_name: str = None,
        contacts: List[GetEventSubscriptionResponseBodyDataContacts] = None,
        event_context: str = None,
        event_send_group: List[str] = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        id: int = None,
        instance_id: str = None,
        lang: str = None,
        level: str = None,
        min_interval: str = None,
        user_id: str = None,
    ):
        # Indicates whether the event subscription feature is enabled. Valid values:
        # 
        # *   **0**: The event subscription feature is disabled.
        # *   **1**: The event subscription feature is enabled.
        self.active = active
        # The notification method. Valid values:
        # 
        # *   **hdm_alarm_sms**: text message.
        # *   **dingtalk**: DingTalk chatbot.
        # *   **hdm_alarm_sms_and_email**: text message and email.
        # *   **hdm_alarm_sms,dingtalk**: text message and DingTalk chatbot.
        self.channel_type = channel_type
        # The name of the contact group that receives alert notifications. Multiple names are separated by commas (,).
        self.contact_group_name = contact_group_name
        # The alert contact groups.
        self.contact_groups = contact_groups
        # The name of the subscriber who receives alert notifications. Multiple names are separated by commas (,).
        self.contact_name = contact_name
        # The user ID.
        self.contacts = contacts
        # The supported event scenarios. Only **AllContext** may be returned, which indicates that all scenarios are supported.
        self.event_context = event_context
        # The supported event scenarios in which event subscription can be sent.
        self.event_send_group = event_send_group
        # The time when event subscription was enabled. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.gmt_create = gmt_create
        # The time when the event subscription settings were most recently modified. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.gmt_modified = gmt_modified
        # The primary key ID of the database.
        self.id = id
        # The instance ID.
        self.instance_id = instance_id
        # The language of event notifications. Only **zh-CN** may be returned, which indicates that event notifications are sent in Chinese.
        self.lang = lang
        # The risk level of the events that trigger notifications. Valid values:
        # 
        # *   **Notice**\
        # *   **Optimization**\
        # *   **Warn**\
        # *   **Critical**\
        self.level = level
        # The minimum interval between event notifications. Unit: seconds.
        self.min_interval = min_interval
        # The user ID.
        self.user_id = user_id

    def validate(self):
        if self.contact_groups:
            for k in self.contact_groups:
                if k:
                    k.validate()
        if self.contacts:
            for k in self.contacts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['active'] = self.active
        if self.channel_type is not None:
            result['channelType'] = self.channel_type
        if self.contact_group_name is not None:
            result['contactGroupName'] = self.contact_group_name
        result['contactGroups'] = []
        if self.contact_groups is not None:
            for k in self.contact_groups:
                result['contactGroups'].append(k.to_map() if k else None)
        if self.contact_name is not None:
            result['contactName'] = self.contact_name
        result['contacts'] = []
        if self.contacts is not None:
            for k in self.contacts:
                result['contacts'].append(k.to_map() if k else None)
        if self.event_context is not None:
            result['eventContext'] = self.event_context
        if self.event_send_group is not None:
            result['eventSendGroup'] = self.event_send_group
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instanceId'] = self.instance_id
        if self.lang is not None:
            result['lang'] = self.lang
        if self.level is not None:
            result['level'] = self.level
        if self.min_interval is not None:
            result['minInterval'] = self.min_interval
        if self.user_id is not None:
            result['userId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('active') is not None:
            self.active = m.get('active')
        if m.get('channelType') is not None:
            self.channel_type = m.get('channelType')
        if m.get('contactGroupName') is not None:
            self.contact_group_name = m.get('contactGroupName')
        self.contact_groups = []
        if m.get('contactGroups') is not None:
            for k in m.get('contactGroups'):
                temp_model = GetEventSubscriptionResponseBodyDataContactGroups()
                self.contact_groups.append(temp_model.from_map(k))
        if m.get('contactName') is not None:
            self.contact_name = m.get('contactName')
        self.contacts = []
        if m.get('contacts') is not None:
            for k in m.get('contacts'):
                temp_model = GetEventSubscriptionResponseBodyDataContacts()
                self.contacts.append(temp_model.from_map(k))
        if m.get('eventContext') is not None:
            self.event_context = m.get('eventContext')
        if m.get('eventSendGroup') is not None:
            self.event_send_group = m.get('eventSendGroup')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instanceId') is not None:
            self.instance_id = m.get('instanceId')
        if m.get('lang') is not None:
            self.lang = m.get('lang')
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('minInterval') is not None:
            self.min_interval = m.get('minInterval')
        if m.get('userId') is not None:
            self.user_id = m.get('userId')
        return self


class GetEventSubscriptionResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetEventSubscriptionResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetEventSubscriptionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetEventSubscriptionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetEventSubscriptionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetEventSubscriptionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFullRequestOriginStatByInstanceIdRequest(TeaModel):
    def __init__(
        self,
        asc: bool = None,
        end: int = None,
        instance_id: str = None,
        node_id: str = None,
        order_by: str = None,
        page_no: int = None,
        page_size: int = None,
        role: str = None,
        sql_type: str = None,
        start: int = None,
        user_id: str = None,
    ):
        # Specifies whether to sort the results in ascending order. By default, the results are not sorted in ascending order.
        self.asc = asc
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time. The interval between the start time and the end time cannot exceed 24 hours.
        self.end = end
        # The instance ID.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  This parameter must be specified if the database instance is a PolarDB for MySQL cluster.
        self.node_id = node_id
        # The field by which the results to be returned are sorted. Default value: **count**. Valid values:
        # 
        # *   **count**: the number of executions.
        # *   **avgRt**: the average execution duration.
        # *   **rtRate**: the execution duration percentage.
        # *   **rowsExamined**: the total number of scanned rows.
        # *   **avgRowsExamined**: the average number of scanned rows.
        # *   **avgRowsReturned**: the average number of returned rows.
        self.order_by = order_by
        # The page number. Pages start from page 1. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. Default value: 20.
        self.page_size = page_size
        # The role of the PolarDB-X 2.0 node. Valid values:
        # 
        # *   **polarx_cn**: compute node.
        # *   **polarx_en**: data node.
        self.role = role
        # The type of the SQL statement. Valid values: **SELECT**, **INSERT**, **UPDATE**, **DELETE**, **LOGIN**, **LOGOUT**, **MERGE**, **ALTER**, **CREATEINDEX**, **DROPINDEX**, **CREATE**, **DROP**, **SET**, **DESC**, **REPLACE**, **CALL**, **BEGIN**, **DESCRIBE**, **ROLLBACK**, **FLUSH**, **USE**, **SHOW**, **START**, **COMMIT**, and **RENAME**.
        # 
        # >  If the database instance is an ApsaraDB RDS for MySQL instance, a PolarDB for MySQL cluster, or a PolarDB-X 2.0 instance, the statistics can be collected based on the SQL statement type.
        self.sql_type = sql_type
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The start time must be within the storage duration of the SQL Explorer of the database instance, and can be up to 90 days earlier than the current time.
        self.start = start
        # The ID of the Alibaba Cloud account that is used to create the database instance.
        # 
        # >  This parameter is optional. The system can automatically obtain the account ID based on the value of InstanceId when you call this operation.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.end is not None:
            result['End'] = self.end
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.role is not None:
            result['Role'] = self.role
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.start is not None:
            result['Start'] = self.start
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetFullRequestOriginStatByInstanceIdResponseBodyDataList(TeaModel):
    def __init__(
        self,
        avg_examined_rows: float = None,
        avg_fetch_rows: int = None,
        avg_lock_wait_time: float = None,
        avg_logical_read: float = None,
        avg_physical_async_read: int = None,
        avg_physical_sync_read: float = None,
        avg_returned_rows: float = None,
        avg_rows: int = None,
        avg_rt: float = None,
        avg_sql_count: int = None,
        avg_updated_rows: float = None,
        count: int = None,
        count_rate: float = None,
        database: str = None,
        error_count: int = None,
        examined_rows: int = None,
        fetch_rows: int = None,
        ip: str = None,
        key: str = None,
        lock_wait_time: float = None,
        logical_read: int = None,
        origin_host: str = None,
        physical_async_read: int = None,
        physical_sync_read: int = None,
        port: int = None,
        rows: int = None,
        rt_greater_than_one_second_count: int = None,
        rt_rate: float = None,
        sql_count: int = None,
        sum_updated_rows: int = None,
        version: int = None,
        vpc_id: str = None,
    ):
        # The average number of scanned rows.
        # 
        # > This parameter is returned only for ApsaraDB RDS for MySQL, ApsaraDB RDS for PostgreSQL, and PolarDB for MySQL databases.
        self.avg_examined_rows = avg_examined_rows
        # The average number of rows that are fetched from data nodes by compute nodes on the PolarDB-X 2.0 instance.
        self.avg_fetch_rows = avg_fetch_rows
        # The average lock wait duration. Unit: seconds.
        self.avg_lock_wait_time = avg_lock_wait_time
        # The average number of logical reads.
        self.avg_logical_read = avg_logical_read
        # The average number of physical asynchronous reads.
        self.avg_physical_async_read = avg_physical_async_read
        # The average number of physical synchronous reads.
        self.avg_physical_sync_read = avg_physical_sync_read
        # The average number of returned rows.
        self.avg_returned_rows = avg_returned_rows
        # The average number of rows.
        self.avg_rows = avg_rows
        # The average execution duration.
        self.avg_rt = avg_rt
        # The average number of SQL statements.
        self.avg_sql_count = avg_sql_count
        # The average number of updated rows.
        # 
        # > This parameter is returned only for ApsaraDB RDS for MySQL and PolarDB-X 2.0 databases.
        self.avg_updated_rows = avg_updated_rows
        # The total number of executions.
        self.count = count
        # The percentage of the total number of executions.
        self.count_rate = count_rate
        # The name of the database.
        self.database = database
        # The number of failed executions.
        self.error_count = error_count
        # The total number of scanned rows.
        # 
        # > This parameter is returned only for ApsaraDB RDS for MySQL, ApsaraDB RDS for PostgreSQL, and PolarDB for MySQL databases.
        self.examined_rows = examined_rows
        # The number of rows that are fetched from data nodes by compute nodes on the PolarDB-X 2.0 instance.
        self.fetch_rows = fetch_rows
        # The network address of the database instance.
        self.ip = ip
        # The IP address of the client that executes the SQL statement.
        self.key = key
        # The lock wait duration. Unit: seconds.
        self.lock_wait_time = lock_wait_time
        # The number of logical reads.
        self.logical_read = logical_read
        # The IP address of the client that executes the SQL statement.
        self.origin_host = origin_host
        # The number of physical asynchronous reads.
        self.physical_async_read = physical_async_read
        # The number of physical synchronous reads.
        self.physical_sync_read = physical_sync_read
        # The port number that is used to connect to the database instance.
        self.port = port
        # The total number of rows updated or returned by the compute nodes of the PolarDB-X 2.0 instance.
        self.rows = rows
        # The number of SQL statements that take longer than 1 second to execute.
        self.rt_greater_than_one_second_count = rt_greater_than_one_second_count
        # The execution duration percentage.
        self.rt_rate = rt_rate
        # The number of SQL statements.
        self.sql_count = sql_count
        # The total number of updated rows.
        self.sum_updated_rows = sum_updated_rows
        # The version number.
        self.version = version
        # The virtual private cloud (VPC) ID.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_examined_rows is not None:
            result['AvgExaminedRows'] = self.avg_examined_rows
        if self.avg_fetch_rows is not None:
            result['AvgFetchRows'] = self.avg_fetch_rows
        if self.avg_lock_wait_time is not None:
            result['AvgLockWaitTime'] = self.avg_lock_wait_time
        if self.avg_logical_read is not None:
            result['AvgLogicalRead'] = self.avg_logical_read
        if self.avg_physical_async_read is not None:
            result['AvgPhysicalAsyncRead'] = self.avg_physical_async_read
        if self.avg_physical_sync_read is not None:
            result['AvgPhysicalSyncRead'] = self.avg_physical_sync_read
        if self.avg_returned_rows is not None:
            result['AvgReturnedRows'] = self.avg_returned_rows
        if self.avg_rows is not None:
            result['AvgRows'] = self.avg_rows
        if self.avg_rt is not None:
            result['AvgRt'] = self.avg_rt
        if self.avg_sql_count is not None:
            result['AvgSqlCount'] = self.avg_sql_count
        if self.avg_updated_rows is not None:
            result['AvgUpdatedRows'] = self.avg_updated_rows
        if self.count is not None:
            result['Count'] = self.count
        if self.count_rate is not None:
            result['CountRate'] = self.count_rate
        if self.database is not None:
            result['Database'] = self.database
        if self.error_count is not None:
            result['ErrorCount'] = self.error_count
        if self.examined_rows is not None:
            result['ExaminedRows'] = self.examined_rows
        if self.fetch_rows is not None:
            result['FetchRows'] = self.fetch_rows
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.key is not None:
            result['Key'] = self.key
        if self.lock_wait_time is not None:
            result['LockWaitTime'] = self.lock_wait_time
        if self.logical_read is not None:
            result['LogicalRead'] = self.logical_read
        if self.origin_host is not None:
            result['OriginHost'] = self.origin_host
        if self.physical_async_read is not None:
            result['PhysicalAsyncRead'] = self.physical_async_read
        if self.physical_sync_read is not None:
            result['PhysicalSyncRead'] = self.physical_sync_read
        if self.port is not None:
            result['Port'] = self.port
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.rt_greater_than_one_second_count is not None:
            result['RtGreaterThanOneSecondCount'] = self.rt_greater_than_one_second_count
        if self.rt_rate is not None:
            result['RtRate'] = self.rt_rate
        if self.sql_count is not None:
            result['SqlCount'] = self.sql_count
        if self.sum_updated_rows is not None:
            result['SumUpdatedRows'] = self.sum_updated_rows
        if self.version is not None:
            result['Version'] = self.version
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgExaminedRows') is not None:
            self.avg_examined_rows = m.get('AvgExaminedRows')
        if m.get('AvgFetchRows') is not None:
            self.avg_fetch_rows = m.get('AvgFetchRows')
        if m.get('AvgLockWaitTime') is not None:
            self.avg_lock_wait_time = m.get('AvgLockWaitTime')
        if m.get('AvgLogicalRead') is not None:
            self.avg_logical_read = m.get('AvgLogicalRead')
        if m.get('AvgPhysicalAsyncRead') is not None:
            self.avg_physical_async_read = m.get('AvgPhysicalAsyncRead')
        if m.get('AvgPhysicalSyncRead') is not None:
            self.avg_physical_sync_read = m.get('AvgPhysicalSyncRead')
        if m.get('AvgReturnedRows') is not None:
            self.avg_returned_rows = m.get('AvgReturnedRows')
        if m.get('AvgRows') is not None:
            self.avg_rows = m.get('AvgRows')
        if m.get('AvgRt') is not None:
            self.avg_rt = m.get('AvgRt')
        if m.get('AvgSqlCount') is not None:
            self.avg_sql_count = m.get('AvgSqlCount')
        if m.get('AvgUpdatedRows') is not None:
            self.avg_updated_rows = m.get('AvgUpdatedRows')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CountRate') is not None:
            self.count_rate = m.get('CountRate')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('ErrorCount') is not None:
            self.error_count = m.get('ErrorCount')
        if m.get('ExaminedRows') is not None:
            self.examined_rows = m.get('ExaminedRows')
        if m.get('FetchRows') is not None:
            self.fetch_rows = m.get('FetchRows')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('LockWaitTime') is not None:
            self.lock_wait_time = m.get('LockWaitTime')
        if m.get('LogicalRead') is not None:
            self.logical_read = m.get('LogicalRead')
        if m.get('OriginHost') is not None:
            self.origin_host = m.get('OriginHost')
        if m.get('PhysicalAsyncRead') is not None:
            self.physical_async_read = m.get('PhysicalAsyncRead')
        if m.get('PhysicalSyncRead') is not None:
            self.physical_sync_read = m.get('PhysicalSyncRead')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('RtGreaterThanOneSecondCount') is not None:
            self.rt_greater_than_one_second_count = m.get('RtGreaterThanOneSecondCount')
        if m.get('RtRate') is not None:
            self.rt_rate = m.get('RtRate')
        if m.get('SqlCount') is not None:
            self.sql_count = m.get('SqlCount')
        if m.get('SumUpdatedRows') is not None:
            self.sum_updated_rows = m.get('SumUpdatedRows')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class GetFullRequestOriginStatByInstanceIdResponseBodyData(TeaModel):
    def __init__(
        self,
        list: List[GetFullRequestOriginStatByInstanceIdResponseBodyDataList] = None,
        total: int = None,
    ):
        # The details of the full request data.
        self.list = list
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetFullRequestOriginStatByInstanceIdResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetFullRequestOriginStatByInstanceIdResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetFullRequestOriginStatByInstanceIdResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetFullRequestOriginStatByInstanceIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetFullRequestOriginStatByInstanceIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFullRequestOriginStatByInstanceIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFullRequestOriginStatByInstanceIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFullRequestSampleByInstanceIdRequest(TeaModel):
    def __init__(
        self,
        end: int = None,
        instance_id: str = None,
        role: str = None,
        sql_id: str = None,
        start: int = None,
        user_id: str = None,
    ):
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time. The interval between the start time and the end time must be equal to or greater than 1 hour.
        self.end = end
        # The instance ID.
        self.instance_id = instance_id
        # The role of the PolarDB-X 2.0 node. Valid values:
        # 
        # *   **polarx_cn**: compute node.
        # *   **polarx_en**: data node.
        self.role = role
        # The SQL statement ID.
        self.sql_id = sql_id
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The start time must be within the storage duration of the SQL Explorer feature of the database instance, and can be up to 90 days earlier than the current time.
        self.start = start
        # The ID of the Alibaba Cloud account that is used to create the database instance.
        # 
        # >  This parameter is optional. The system can automatically obtain the account ID based on the value of InstanceId when you call this operation.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role is not None:
            result['Role'] = self.role
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.start is not None:
            result['Start'] = self.start
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetFullRequestSampleByInstanceIdResponseBodyData(TeaModel):
    def __init__(
        self,
        database: str = None,
        frows: int = None,
        lock_wait_time: float = None,
        logical_read: float = None,
        origin_host: str = None,
        physical_async_read: float = None,
        physical_sync_read: float = None,
        rows: int = None,
        rows_examined: int = None,
        rows_returned: int = None,
        rt: float = None,
        scan_rows: int = None,
        scnt: int = None,
        sql: str = None,
        sql_id: str = None,
        sql_type: str = None,
        timestamp: int = None,
        update_rows: int = None,
        user: str = None,
    ):
        # The name of the database.
        self.database = database
        # The number of rows fetched by PolarDB-X 2.0 compute nodes.
        self.frows = frows
        # The lock wait duration. Unit: seconds.
        self.lock_wait_time = lock_wait_time
        # The number of logical reads.
        self.logical_read = logical_read
        # The source IP address.
        self.origin_host = origin_host
        # The number of physical asynchronous reads.
        self.physical_async_read = physical_async_read
        # The number of physical synchronous reads.
        self.physical_sync_read = physical_sync_read
        # The number of rows updated or returned on PolarDB-X 2.0 compute nodes.
        self.rows = rows
        # The total number of scanned rows.
        # 
        # > This parameter is returned only for ApsaraDB RDS for MySQL, ApsaraDB RDS for PostgreSQL, and PolarDB for MySQL databases.
        self.rows_examined = rows_examined
        # The number of rows returned by the SQL statement.
        self.rows_returned = rows_returned
        # The amount of time consumed to execute the SQL statement. Unit: seconds.
        self.rt = rt
        # The number of scanned rows.
        self.scan_rows = scan_rows
        # The number of requests sent from PolarDB-X 2.0 compute nodes to data nodes.
        self.scnt = scnt
        # The sample SQL statement.
        self.sql = sql
        # The SQL statement ID.
        self.sql_id = sql_id
        # The type of the SQL statement. Valid values: **SELECT**, **INSERT**, **UPDATE**, **DELETE**, **LOGIN**, **LOGOUT**, **MERGE**, **ALTER**, **CREATEINDEX**, **DROPINDEX**, **CREATE**, **DROP**, **SET**, **DESC**, **REPLACE**, **CALL**, **BEGIN**, **DESCRIBE**, **ROLLBACK**, **FLUSH**, **USE**, **SHOW**, **START**, **COMMIT**, and **RENAME**.
        self.sql_type = sql_type
        # The time when the SQL statement was executed. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp
        # The number of updated rows.
        self.update_rows = update_rows
        # The name of the user who executes the SQL statement.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        if self.frows is not None:
            result['Frows'] = self.frows
        if self.lock_wait_time is not None:
            result['LockWaitTime'] = self.lock_wait_time
        if self.logical_read is not None:
            result['LogicalRead'] = self.logical_read
        if self.origin_host is not None:
            result['OriginHost'] = self.origin_host
        if self.physical_async_read is not None:
            result['PhysicalAsyncRead'] = self.physical_async_read
        if self.physical_sync_read is not None:
            result['PhysicalSyncRead'] = self.physical_sync_read
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.rows_examined is not None:
            result['RowsExamined'] = self.rows_examined
        if self.rows_returned is not None:
            result['RowsReturned'] = self.rows_returned
        if self.rt is not None:
            result['Rt'] = self.rt
        if self.scan_rows is not None:
            result['ScanRows'] = self.scan_rows
        if self.scnt is not None:
            result['Scnt'] = self.scnt
        if self.sql is not None:
            result['Sql'] = self.sql
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.update_rows is not None:
            result['UpdateRows'] = self.update_rows
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('Frows') is not None:
            self.frows = m.get('Frows')
        if m.get('LockWaitTime') is not None:
            self.lock_wait_time = m.get('LockWaitTime')
        if m.get('LogicalRead') is not None:
            self.logical_read = m.get('LogicalRead')
        if m.get('OriginHost') is not None:
            self.origin_host = m.get('OriginHost')
        if m.get('PhysicalAsyncRead') is not None:
            self.physical_async_read = m.get('PhysicalAsyncRead')
        if m.get('PhysicalSyncRead') is not None:
            self.physical_sync_read = m.get('PhysicalSyncRead')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('RowsExamined') is not None:
            self.rows_examined = m.get('RowsExamined')
        if m.get('RowsReturned') is not None:
            self.rows_returned = m.get('RowsReturned')
        if m.get('Rt') is not None:
            self.rt = m.get('Rt')
        if m.get('ScanRows') is not None:
            self.scan_rows = m.get('ScanRows')
        if m.get('Scnt') is not None:
            self.scnt = m.get('Scnt')
        if m.get('Sql') is not None:
            self.sql = m.get('Sql')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UpdateRows') is not None:
            self.update_rows = m.get('UpdateRows')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class GetFullRequestSampleByInstanceIdResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[GetFullRequestSampleByInstanceIdResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message that contains information such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetFullRequestSampleByInstanceIdResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetFullRequestSampleByInstanceIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFullRequestSampleByInstanceIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFullRequestSampleByInstanceIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetFullRequestStatResultByInstanceIdRequest(TeaModel):
    def __init__(
        self,
        asc: bool = None,
        db_name: str = None,
        end: int = None,
        instance_id: str = None,
        keyword: str = None,
        node_id: str = None,
        order_by: str = None,
        origin_host: str = None,
        page_no: int = None,
        page_size: int = None,
        role: str = None,
        sql_id: str = None,
        sql_type: str = None,
        start: int = None,
        user_id: str = None,
    ):
        # Specifies whether to sort the results in ascending order. By default, the results are not sorted in ascending order.
        self.asc = asc
        # The name of the database.
        self.db_name = db_name
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time. The interval cannot exceed one day.
        self.end = end
        # The instance ID.
        self.instance_id = instance_id
        # The keywords that are used for query.
        self.keyword = keyword
        # The node ID.
        # 
        # >  You must specify the node ID if your database instance is a PolarDB for MySQL cluster.
        self.node_id = node_id
        # The field by which to sort the returned entries. Default value: **count**. Valid values:
        # 
        # *   **count**: the number of executions.
        # *   **avgRt**: the average execution duration.
        # *   **rtRate**: the execution duration percentage.
        # *   **rowsExamined**: the total number of scanned rows.
        # *   **avgRowsExamined**: the average number of scanned rows.
        # *   **avgRowsReturned**: the average number of returned rows.
        self.order_by = order_by
        # The IP address of the client that executes the SQL statement.
        # 
        # >  This parameter is optional. If this parameter is specified, the full request statistics of the specified IP address are collected. If this parameter is left empty, the full request statistics of the entire database instance are collected.
        self.origin_host = origin_host
        # The page number. Pages start from page 1. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. Default value: 20.
        self.page_size = page_size
        # The role of the PolarDB-X 2.0 node. Valid values:
        # 
        # *   **polarx_cn**: compute node
        # *   **polarx_en**: data node
        self.role = role
        # The SQL ID.
        # 
        # >  If this parameter is specified, the full request statistics of the specified SQL query are collected. If this parameter is left empty, the full request statistics of the entire database instance are collected.
        self.sql_id = sql_id
        # The type of the SQL statement. Valid values: **SELECT**, **INSERT**, **UPDATE**, **DELETE**, **LOGIN**, **LOGOUT**, **MERGE**, **ALTER**, **CREATEINDEX**, **DROPINDEX**, **CREATE**, **DROP**, **SET**, **DESC**, **REPLACE**, **CALL**, **BEGIN**, **DESCRIBE**, **ROLLBACK**, **FLUSH**, **USE**, **SHOW**, **START**, **COMMIT**, and **RENAME**.
        # 
        # >  If your database instance is an ApsaraDB RDS for MySQL instance, a PolarDB for MySQL cluster, or a PolarDB-X 2.0 instance, the statistics can be collected based on the SQL statement type.
        self.sql_type = sql_type
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The start time can be up to 90 days earlier than the current time.
        self.start = start
        # The ID of the Alibaba Cloud account that was used to create the database instance.
        # 
        # >  This parameter is optional. The system can automatically obtain the Alibaba Cloud account ID based on the value of InstanceId when you call the GetFullRequestOriginStatByInstanceId operation.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.end is not None:
            result['End'] = self.end
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.origin_host is not None:
            result['OriginHost'] = self.origin_host
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.role is not None:
            result['Role'] = self.role
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.start is not None:
            result['Start'] = self.start
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('OriginHost') is not None:
            self.origin_host = m.get('OriginHost')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetFullRequestStatResultByInstanceIdResponseBodyDataResultList(TeaModel):
    def __init__(
        self,
        avg_examined_rows: float = None,
        avg_fetch_rows: int = None,
        avg_lock_wait_time: float = None,
        avg_logical_read: float = None,
        avg_physical_async_read: int = None,
        avg_physical_sync_read: int = None,
        avg_returned_rows: float = None,
        avg_rt: float = None,
        avg_sql_count: int = None,
        avg_updated_rows: int = None,
        count: int = None,
        count_rate: float = None,
        database: str = None,
        error_count: int = None,
        examined_rows: int = None,
        fetch_rows: int = None,
        ip: str = None,
        lock_wait_time: float = None,
        logical_read: int = None,
        physical_async_read: int = None,
        physical_sync_read: int = None,
        port: int = None,
        psql: str = None,
        rows: int = None,
        rt_greater_than_one_second_count: int = None,
        rt_rate: float = None,
        sql_count: int = None,
        sql_id: str = None,
        sum_updated_rows: int = None,
        tables: List[str] = None,
        version: int = None,
        vpc_id: str = None,
    ):
        # The average number of scanned rows.
        # 
        # > This parameter is returned only for ApsaraDB RDS for MySQL, ApsaraDB RDS for PostgreSQL, and PolarDB for MySQL databases.
        self.avg_examined_rows = avg_examined_rows
        # The average number of rows that are fetched by compute nodes from data nodes on the PolarDB-X 2.0 instance.
        self.avg_fetch_rows = avg_fetch_rows
        # The average lock wait latency. Unit: seconds.
        self.avg_lock_wait_time = avg_lock_wait_time
        # The average number of logical reads.
        self.avg_logical_read = avg_logical_read
        # The average number of physical asynchronous reads.
        self.avg_physical_async_read = avg_physical_async_read
        # The average number of physical synchronous reads.
        self.avg_physical_sync_read = avg_physical_sync_read
        # The average number of returned rows.
        self.avg_returned_rows = avg_returned_rows
        # The average execution duration.
        self.avg_rt = avg_rt
        # The average number of SQL statements.
        self.avg_sql_count = avg_sql_count
        # The average number of updated rows.
        # 
        #  > This parameter is returned only for ApsaraDB RDS for MySQL and PolarDB-X 2.0 databases.
        self.avg_updated_rows = avg_updated_rows
        # The total number of executions.
        self.count = count
        # The percentage of the total number of executions.
        self.count_rate = count_rate
        # The name of the database.
        self.database = database
        # The number of failed executions.
        self.error_count = error_count
        # The total number of scanned rows.
        # 
        # > This parameter is returned only for ApsaraDB RDS for MySQL, ApsaraDB RDS for PostgreSQL, and PolarDB for MySQL databases.
        self.examined_rows = examined_rows
        # The number of rows that are fetched by compute nodes from data nodes on the PolarDB-X 2.0 instance.
        self.fetch_rows = fetch_rows
        # The IP address of the database instance.
        self.ip = ip
        # The lock wait latency. Unit: seconds.
        self.lock_wait_time = lock_wait_time
        # The number of logical reads.
        self.logical_read = logical_read
        # The number of physical asynchronous reads.
        self.physical_async_read = physical_async_read
        # The number of physical synchronous reads.
        self.physical_sync_read = physical_sync_read
        # The port number that is used to connect to the database instance.
        self.port = port
        # The SQL template.
        self.psql = psql
        # The total number of rows updated or returned by the compute nodes of the PolarDB-X 2.0 instance.
        self.rows = rows
        # The number of SQL statements that take longer than 1 second to execute.
        self.rt_greater_than_one_second_count = rt_greater_than_one_second_count
        # The execution duration percentage.
        self.rt_rate = rt_rate
        # The number of SQL statements.
        self.sql_count = sql_count
        # The SQL ID.
        self.sql_id = sql_id
        # The total number of updated rows.
        self.sum_updated_rows = sum_updated_rows
        # The names of tables in the database.
        self.tables = tables
        # The version number.
        self.version = version
        # The virtual private cloud (VPC) ID.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_examined_rows is not None:
            result['AvgExaminedRows'] = self.avg_examined_rows
        if self.avg_fetch_rows is not None:
            result['AvgFetchRows'] = self.avg_fetch_rows
        if self.avg_lock_wait_time is not None:
            result['AvgLockWaitTime'] = self.avg_lock_wait_time
        if self.avg_logical_read is not None:
            result['AvgLogicalRead'] = self.avg_logical_read
        if self.avg_physical_async_read is not None:
            result['AvgPhysicalAsyncRead'] = self.avg_physical_async_read
        if self.avg_physical_sync_read is not None:
            result['AvgPhysicalSyncRead'] = self.avg_physical_sync_read
        if self.avg_returned_rows is not None:
            result['AvgReturnedRows'] = self.avg_returned_rows
        if self.avg_rt is not None:
            result['AvgRt'] = self.avg_rt
        if self.avg_sql_count is not None:
            result['AvgSqlCount'] = self.avg_sql_count
        if self.avg_updated_rows is not None:
            result['AvgUpdatedRows'] = self.avg_updated_rows
        if self.count is not None:
            result['Count'] = self.count
        if self.count_rate is not None:
            result['CountRate'] = self.count_rate
        if self.database is not None:
            result['Database'] = self.database
        if self.error_count is not None:
            result['ErrorCount'] = self.error_count
        if self.examined_rows is not None:
            result['ExaminedRows'] = self.examined_rows
        if self.fetch_rows is not None:
            result['FetchRows'] = self.fetch_rows
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.lock_wait_time is not None:
            result['LockWaitTime'] = self.lock_wait_time
        if self.logical_read is not None:
            result['LogicalRead'] = self.logical_read
        if self.physical_async_read is not None:
            result['PhysicalAsyncRead'] = self.physical_async_read
        if self.physical_sync_read is not None:
            result['PhysicalSyncRead'] = self.physical_sync_read
        if self.port is not None:
            result['Port'] = self.port
        if self.psql is not None:
            result['Psql'] = self.psql
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.rt_greater_than_one_second_count is not None:
            result['RtGreaterThanOneSecondCount'] = self.rt_greater_than_one_second_count
        if self.rt_rate is not None:
            result['RtRate'] = self.rt_rate
        if self.sql_count is not None:
            result['SqlCount'] = self.sql_count
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sum_updated_rows is not None:
            result['SumUpdatedRows'] = self.sum_updated_rows
        if self.tables is not None:
            result['Tables'] = self.tables
        if self.version is not None:
            result['Version'] = self.version
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgExaminedRows') is not None:
            self.avg_examined_rows = m.get('AvgExaminedRows')
        if m.get('AvgFetchRows') is not None:
            self.avg_fetch_rows = m.get('AvgFetchRows')
        if m.get('AvgLockWaitTime') is not None:
            self.avg_lock_wait_time = m.get('AvgLockWaitTime')
        if m.get('AvgLogicalRead') is not None:
            self.avg_logical_read = m.get('AvgLogicalRead')
        if m.get('AvgPhysicalAsyncRead') is not None:
            self.avg_physical_async_read = m.get('AvgPhysicalAsyncRead')
        if m.get('AvgPhysicalSyncRead') is not None:
            self.avg_physical_sync_read = m.get('AvgPhysicalSyncRead')
        if m.get('AvgReturnedRows') is not None:
            self.avg_returned_rows = m.get('AvgReturnedRows')
        if m.get('AvgRt') is not None:
            self.avg_rt = m.get('AvgRt')
        if m.get('AvgSqlCount') is not None:
            self.avg_sql_count = m.get('AvgSqlCount')
        if m.get('AvgUpdatedRows') is not None:
            self.avg_updated_rows = m.get('AvgUpdatedRows')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CountRate') is not None:
            self.count_rate = m.get('CountRate')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('ErrorCount') is not None:
            self.error_count = m.get('ErrorCount')
        if m.get('ExaminedRows') is not None:
            self.examined_rows = m.get('ExaminedRows')
        if m.get('FetchRows') is not None:
            self.fetch_rows = m.get('FetchRows')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('LockWaitTime') is not None:
            self.lock_wait_time = m.get('LockWaitTime')
        if m.get('LogicalRead') is not None:
            self.logical_read = m.get('LogicalRead')
        if m.get('PhysicalAsyncRead') is not None:
            self.physical_async_read = m.get('PhysicalAsyncRead')
        if m.get('PhysicalSyncRead') is not None:
            self.physical_sync_read = m.get('PhysicalSyncRead')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Psql') is not None:
            self.psql = m.get('Psql')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('RtGreaterThanOneSecondCount') is not None:
            self.rt_greater_than_one_second_count = m.get('RtGreaterThanOneSecondCount')
        if m.get('RtRate') is not None:
            self.rt_rate = m.get('RtRate')
        if m.get('SqlCount') is not None:
            self.sql_count = m.get('SqlCount')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SumUpdatedRows') is not None:
            self.sum_updated_rows = m.get('SumUpdatedRows')
        if m.get('Tables') is not None:
            self.tables = m.get('Tables')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class GetFullRequestStatResultByInstanceIdResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        list: List[GetFullRequestStatResultByInstanceIdResponseBodyDataResultList] = None,
        total: int = None,
    ):
        # The full request data.
        self.list = list
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetFullRequestStatResultByInstanceIdResponseBodyDataResultList()
                self.list.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetFullRequestStatResultByInstanceIdResponseBodyData(TeaModel):
    def __init__(
        self,
        fail: bool = None,
        is_finish: bool = None,
        result: GetFullRequestStatResultByInstanceIdResponseBodyDataResult = None,
        result_id: str = None,
        state: str = None,
        timestamp: int = None,
    ):
        # Indicates whether the asynchronous request failed. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.fail = fail
        # Indicates whether the asynchronous request was complete. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.is_finish = is_finish
        # The returned full request data.
        self.result = result
        # The request ID.
        self.result_id = result_id
        # The state of the asynchronous request. Valid values:
        # 
        # *   **RUNNING**\
        # *   **SUCCESS**\
        # *   **FAIL**\
        self.state = state
        # The time when the asynchronous request was sent. The value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail is not None:
            result['Fail'] = self.fail
        if self.is_finish is not None:
            result['IsFinish'] = self.is_finish
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.result_id is not None:
            result['ResultId'] = self.result_id
        if self.state is not None:
            result['State'] = self.state
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Fail') is not None:
            self.fail = m.get('Fail')
        if m.get('IsFinish') is not None:
            self.is_finish = m.get('IsFinish')
        if m.get('Result') is not None:
            temp_model = GetFullRequestStatResultByInstanceIdResponseBodyDataResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('ResultId') is not None:
            self.result_id = m.get('ResultId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetFullRequestStatResultByInstanceIdResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetFullRequestStatResultByInstanceIdResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message that contains information such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetFullRequestStatResultByInstanceIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetFullRequestStatResultByInstanceIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetFullRequestStatResultByInstanceIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetFullRequestStatResultByInstanceIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHDMAliyunResourceSyncResultRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        uid: str = None,
        user_id: str = None,
        context: str = None,
        access_key: str = None,
        signature: str = None,
        skip_auth: str = None,
        timestamp: str = None,
    ):
        self.task_id = task_id
        self.uid = uid
        self.user_id = user_id
        self.context = context
        self.access_key = access_key
        self.signature = signature
        self.skip_auth = skip_auth
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.uid is not None:
            result['Uid'] = self.uid
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.context is not None:
            result['__context'] = self.context
        if self.access_key is not None:
            result['accessKey'] = self.access_key
        if self.signature is not None:
            result['signature'] = self.signature
        if self.skip_auth is not None:
            result['skipAuth'] = self.skip_auth
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Uid') is not None:
            self.uid = m.get('Uid')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('__context') is not None:
            self.context = m.get('__context')
        if m.get('accessKey') is not None:
            self.access_key = m.get('accessKey')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('skipAuth') is not None:
            self.skip_auth = m.get('skipAuth')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class GetHDMAliyunResourceSyncResultResponseBodyDataSubResultsResourceSyncSubResult(TeaModel):
    def __init__(
        self,
        err_msg: str = None,
        resource_type: str = None,
        success: bool = None,
        sync_count: int = None,
    ):
        self.err_msg = err_msg
        self.resource_type = resource_type
        self.success = success
        self.sync_count = sync_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.err_msg is not None:
            result['ErrMsg'] = self.err_msg
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.success is not None:
            result['Success'] = self.success
        if self.sync_count is not None:
            result['SyncCount'] = self.sync_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrMsg') is not None:
            self.err_msg = m.get('ErrMsg')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SyncCount') is not None:
            self.sync_count = m.get('SyncCount')
        return self


class GetHDMAliyunResourceSyncResultResponseBodyDataSubResults(TeaModel):
    def __init__(
        self,
        resource_sync_sub_result: List[GetHDMAliyunResourceSyncResultResponseBodyDataSubResultsResourceSyncSubResult] = None,
    ):
        self.resource_sync_sub_result = resource_sync_sub_result

    def validate(self):
        if self.resource_sync_sub_result:
            for k in self.resource_sync_sub_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ResourceSyncSubResult'] = []
        if self.resource_sync_sub_result is not None:
            for k in self.resource_sync_sub_result:
                result['ResourceSyncSubResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource_sync_sub_result = []
        if m.get('ResourceSyncSubResult') is not None:
            for k in m.get('ResourceSyncSubResult'):
                temp_model = GetHDMAliyunResourceSyncResultResponseBodyDataSubResultsResourceSyncSubResult()
                self.resource_sync_sub_result.append(temp_model.from_map(k))
        return self


class GetHDMAliyunResourceSyncResultResponseBodyData(TeaModel):
    def __init__(
        self,
        error_msg: str = None,
        results: str = None,
        sub_results: GetHDMAliyunResourceSyncResultResponseBodyDataSubResults = None,
        sync_status: str = None,
    ):
        self.error_msg = error_msg
        self.results = results
        self.sub_results = sub_results
        self.sync_status = sync_status

    def validate(self):
        if self.sub_results:
            self.sub_results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.results is not None:
            result['Results'] = self.results
        if self.sub_results is not None:
            result['SubResults'] = self.sub_results.to_map()
        if self.sync_status is not None:
            result['SyncStatus'] = self.sync_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('Results') is not None:
            self.results = m.get('Results')
        if m.get('SubResults') is not None:
            temp_model = GetHDMAliyunResourceSyncResultResponseBodyDataSubResults()
            self.sub_results = temp_model.from_map(m['SubResults'])
        if m.get('SyncStatus') is not None:
            self.sync_status = m.get('SyncStatus')
        return self


class GetHDMAliyunResourceSyncResultResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetHDMAliyunResourceSyncResultResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
        synchro: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success
        self.synchro = synchro

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.synchro is not None:
            result['Synchro'] = self.synchro
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHDMAliyunResourceSyncResultResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Synchro') is not None:
            self.synchro = m.get('Synchro')
        return self


class GetHDMAliyunResourceSyncResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHDMAliyunResourceSyncResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHDMAliyunResourceSyncResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHDMLastAliyunResourceSyncResultRequest(TeaModel):
    def __init__(
        self,
        uid: str = None,
        user_id: str = None,
        context: str = None,
        access_key: str = None,
        signature: str = None,
        skip_auth: str = None,
        timestamp: str = None,
    ):
        self.uid = uid
        self.user_id = user_id
        self.context = context
        self.access_key = access_key
        self.signature = signature
        self.skip_auth = skip_auth
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uid is not None:
            result['Uid'] = self.uid
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.context is not None:
            result['__context'] = self.context
        if self.access_key is not None:
            result['accessKey'] = self.access_key
        if self.signature is not None:
            result['signature'] = self.signature
        if self.skip_auth is not None:
            result['skipAuth'] = self.skip_auth
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uid') is not None:
            self.uid = m.get('Uid')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('__context') is not None:
            self.context = m.get('__context')
        if m.get('accessKey') is not None:
            self.access_key = m.get('accessKey')
        if m.get('signature') is not None:
            self.signature = m.get('signature')
        if m.get('skipAuth') is not None:
            self.skip_auth = m.get('skipAuth')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class GetHDMLastAliyunResourceSyncResultResponseBodyDataSubResultsResourceSyncSubResult(TeaModel):
    def __init__(
        self,
        err_msg: str = None,
        resource_type: str = None,
        success: bool = None,
        sync_count: int = None,
    ):
        self.err_msg = err_msg
        self.resource_type = resource_type
        self.success = success
        self.sync_count = sync_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.err_msg is not None:
            result['ErrMsg'] = self.err_msg
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.success is not None:
            result['Success'] = self.success
        if self.sync_count is not None:
            result['SyncCount'] = self.sync_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrMsg') is not None:
            self.err_msg = m.get('ErrMsg')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('SyncCount') is not None:
            self.sync_count = m.get('SyncCount')
        return self


class GetHDMLastAliyunResourceSyncResultResponseBodyDataSubResults(TeaModel):
    def __init__(
        self,
        resource_sync_sub_result: List[GetHDMLastAliyunResourceSyncResultResponseBodyDataSubResultsResourceSyncSubResult] = None,
    ):
        self.resource_sync_sub_result = resource_sync_sub_result

    def validate(self):
        if self.resource_sync_sub_result:
            for k in self.resource_sync_sub_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ResourceSyncSubResult'] = []
        if self.resource_sync_sub_result is not None:
            for k in self.resource_sync_sub_result:
                result['ResourceSyncSubResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource_sync_sub_result = []
        if m.get('ResourceSyncSubResult') is not None:
            for k in m.get('ResourceSyncSubResult'):
                temp_model = GetHDMLastAliyunResourceSyncResultResponseBodyDataSubResultsResourceSyncSubResult()
                self.resource_sync_sub_result.append(temp_model.from_map(k))
        return self


class GetHDMLastAliyunResourceSyncResultResponseBodyData(TeaModel):
    def __init__(
        self,
        error_msg: str = None,
        results: str = None,
        sub_results: GetHDMLastAliyunResourceSyncResultResponseBodyDataSubResults = None,
        sync_status: str = None,
    ):
        self.error_msg = error_msg
        self.results = results
        self.sub_results = sub_results
        self.sync_status = sync_status

    def validate(self):
        if self.sub_results:
            self.sub_results.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.results is not None:
            result['Results'] = self.results
        if self.sub_results is not None:
            result['SubResults'] = self.sub_results.to_map()
        if self.sync_status is not None:
            result['SyncStatus'] = self.sync_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('Results') is not None:
            self.results = m.get('Results')
        if m.get('SubResults') is not None:
            temp_model = GetHDMLastAliyunResourceSyncResultResponseBodyDataSubResults()
            self.sub_results = temp_model.from_map(m['SubResults'])
        if m.get('SyncStatus') is not None:
            self.sync_status = m.get('SyncStatus')
        return self


class GetHDMLastAliyunResourceSyncResultResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetHDMLastAliyunResourceSyncResultResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
        synchro: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success
        self.synchro = synchro

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.synchro is not None:
            result['Synchro'] = self.synchro
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHDMLastAliyunResourceSyncResultResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Synchro') is not None:
            self.synchro = m.get('Synchro')
        return self


class GetHDMLastAliyunResourceSyncResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHDMLastAliyunResourceSyncResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHDMLastAliyunResourceSyncResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceInspectionsRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        engine: str = None,
        instance_area: str = None,
        page_no: str = None,
        page_size: str = None,
        resource_group_id: str = None,
        search_map: str = None,
        start_time: str = None,
    ):
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time.
        self.end_time = end_time
        # The database engine. Valid values:
        # 
        # *   **MySQL**\
        # *   **Redis**\
        # *   **PolarDBMySQL**\
        self.engine = engine
        # The type of the instance on which the database is deployed. Valid values:
        # 
        # *   **RDS**: an Alibaba Cloud database instance.
        # *   **ECS**: an ECS instance on which a self-managed database is deployed.
        # *   **IDC**: a self-managed database instance that is not deployed on Alibaba Cloud.
        # 
        # >  The value IDC specifies that the instance is deployed in a data center.
        self.instance_area = instance_area
        # The page number. The value must be a positive integer. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        # The resource group ID.
        self.resource_group_id = resource_group_id
        # The filter condition, which can be specified in one of the following formats:
        # 
        # *   Specify the ID of a single instance in the {"InstanceId":"Instance ID"} format.
        # *   Specify the IDs of multiple instances in the {"InstanceIds":\["Instance ID1","Instance ID2"]} format. Separate the instance IDs with commas (,).
        # *   Specify the region in which the instance resides in the {"region":"Region of the instance"} format.
        self.search_map = search_map
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_area is not None:
            result['InstanceArea'] = self.instance_area
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.search_map is not None:
            result['SearchMap'] = self.search_map
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceArea') is not None:
            self.instance_area = m.get('InstanceArea')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SearchMap') is not None:
            self.search_map = m.get('SearchMap')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetInstanceInspectionsResponseBodyDataListAutoFunction(TeaModel):
    def __init__(
        self,
        auto_index: int = None,
        auto_limited_sql: int = None,
        auto_resource_optimize: int = None,
        auto_scale: int = None,
        event_subscription: int = None,
    ):
        # Indicates whether the feature of automatically creating and deleting indexes is enabled. Valid values:
        # 
        # * **0**: disabled.
        # * **1**: enabled.
        # * **2**: not supported.
        self.auto_index = auto_index
        # Indicates whether the automatic throttling feature is enabled. Valid values:
        # 
        # * **0**: disabled.
        # * **1**: enabled.
        # * **2**: not supported.
        self.auto_limited_sql = auto_limited_sql
        # Indicates whether automatic reclamation of fragments is enabled. Valid values:
        # 
        # * **0**: disabled.
        # * **1**: enabled.
        # * **2**: not supported.
        self.auto_resource_optimize = auto_resource_optimize
        # Indicates whether the auto scaling feature is enabled. Valid values:
        # 
        # * **0**: disabled.
        # * **1**: enabled.
        # * **2**: not supported.
        self.auto_scale = auto_scale
        # Indicates whether the event subscription feature is enabled. Valid values:
        # 
        # * **0**: disabled.
        # * **1**: enabled.
        # * **2**: not supported.
        self.event_subscription = event_subscription

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_index is not None:
            result['AutoIndex'] = self.auto_index
        if self.auto_limited_sql is not None:
            result['AutoLimitedSql'] = self.auto_limited_sql
        if self.auto_resource_optimize is not None:
            result['AutoResourceOptimize'] = self.auto_resource_optimize
        if self.auto_scale is not None:
            result['AutoScale'] = self.auto_scale
        if self.event_subscription is not None:
            result['EventSubscription'] = self.event_subscription
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoIndex') is not None:
            self.auto_index = m.get('AutoIndex')
        if m.get('AutoLimitedSql') is not None:
            self.auto_limited_sql = m.get('AutoLimitedSql')
        if m.get('AutoResourceOptimize') is not None:
            self.auto_resource_optimize = m.get('AutoResourceOptimize')
        if m.get('AutoScale') is not None:
            self.auto_scale = m.get('AutoScale')
        if m.get('EventSubscription') is not None:
            self.event_subscription = m.get('EventSubscription')
        return self


class GetInstanceInspectionsResponseBodyDataListInstance(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        category: str = None,
        cpu: str = None,
        engine: str = None,
        engine_version: str = None,
        instance_alias: str = None,
        instance_area: str = None,
        instance_class: str = None,
        instance_id: str = None,
        memory: int = None,
        network_type: str = None,
        node_id: str = None,
        region: str = None,
        storage: int = None,
        uuid: str = None,
        vpc_id: str = None,
    ):
        # The account ID. You can obtain the account ID on the **Security Settings** page in the Alibaba Cloud **account management center**.
        self.account_id = account_id
        # The connection mode of the instance. Valid values:
        # 
        # * **standard**: standard mode.
        # * **safe**: database proxy mode.
        self.category = category
        # The CPU specification of the instance. For example, if a value of 8 is returned, the instance has eight CPU cores.
        self.cpu = cpu
        # The database engine. Valid values:
        # 
        # * **MySQL**\
        # * **Redis**\
        # * **PolarDBMySQL**\
        self.engine = engine
        # The version number of the database engine.
        self.engine_version = engine_version
        # The name of the instance.
        self.instance_alias = instance_alias
        # The type of the instance on which the database is deployed. Valid values:
        # 
        # * **RDS**: an Alibaba Cloud database instance.
        # * **ECS**: an ECS instance on which a self-managed database is deployed.
        # * **IDC**: a self-managed database instance that is not deployed on Alibaba Cloud.
        # 
        # > The value IDC indicates that the instance is deployed in a data center.
        self.instance_area = instance_area
        # The instance type.
        self.instance_class = instance_class
        # The instance ID.
        self.instance_id = instance_id
        # The memory capacity of the database that is deployed on the instance. Unit: MB.
        self.memory = memory
        # The network type of the instance.
        self.network_type = network_type
        # The ID of the node on the instance.
        self.node_id = node_id
        # The ID of the region in which the instance resides.
        self.region = region
        # The storage space of the instance. Unit: GB.
        self.storage = storage
        # The unique identifier of the instance.
        self.uuid = uuid
        # The ID of the virtual private cloud (VPC) in which the instance is deployed.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.category is not None:
            result['Category'] = self.category
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.instance_alias is not None:
            result['InstanceAlias'] = self.instance_alias
        if self.instance_area is not None:
            result['InstanceArea'] = self.instance_area
        if self.instance_class is not None:
            result['InstanceClass'] = self.instance_class
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.region is not None:
            result['Region'] = self.region
        if self.storage is not None:
            result['Storage'] = self.storage
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('InstanceAlias') is not None:
            self.instance_alias = m.get('InstanceAlias')
        if m.get('InstanceArea') is not None:
            self.instance_area = m.get('InstanceArea')
        if m.get('InstanceClass') is not None:
            self.instance_class = m.get('InstanceClass')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Storage') is not None:
            self.storage = m.get('Storage')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class GetInstanceInspectionsResponseBodyDataList(TeaModel):
    def __init__(
        self,
        auto_function: GetInstanceInspectionsResponseBodyDataListAutoFunction = None,
        data: Dict[str, Any] = None,
        enable_das_pro: int = None,
        end_time: int = None,
        gmt_create: int = None,
        instance: GetInstanceInspectionsResponseBodyDataListInstance = None,
        score: int = None,
        score_map: Dict[str, Any] = None,
        start_time: int = None,
        state: int = None,
        task_type: int = None,
    ):
        # Indicates whether the autonomy service is enabled.
        self.auto_function = auto_function
        # The returned data.
        self.data = data
        # Indicates whether DAS Professional Edition is enabled. Valid values:
        # 
        # * **0**: disabled.
        # * **1**: enabled.
        # * **2**: not supported.
        self.enable_das_pro = enable_das_pro
        # The end time of the inspection and scoring task. The value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # > The end time must be later than the start time.
        self.end_time = end_time
        # The time when the task was created. The value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.gmt_create = gmt_create
        # The details of the instance.
        self.instance = instance
        # The inspection scores of the instance.
        self.score = score
        # The scores that are deducted for the instance.
        self.score_map = score_map
        # The start time of the inspection and scoring task. The value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time
        # The state of the inspection and scoring task. Valid values:
        # 
        # * **0**: The task is waiting for execution.
        # * **1**: The task is in progress.
        # * **2**: The task is complete.
        self.state = state
        # The mode in which the inspection and scoring task was initiated. Valid values:
        # 
        # * **0**: automatic mode
        # * **1**: manual mode
        self.task_type = task_type

    def validate(self):
        if self.auto_function:
            self.auto_function.validate()
        if self.instance:
            self.instance.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_function is not None:
            result['AutoFunction'] = self.auto_function.to_map()
        if self.data is not None:
            result['Data'] = self.data
        if self.enable_das_pro is not None:
            result['EnableDasPro'] = self.enable_das_pro
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.instance is not None:
            result['Instance'] = self.instance.to_map()
        if self.score is not None:
            result['Score'] = self.score
        if self.score_map is not None:
            result['ScoreMap'] = self.score_map
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoFunction') is not None:
            temp_model = GetInstanceInspectionsResponseBodyDataListAutoFunction()
            self.auto_function = temp_model.from_map(m['AutoFunction'])
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('EnableDasPro') is not None:
            self.enable_das_pro = m.get('EnableDasPro')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Instance') is not None:
            temp_model = GetInstanceInspectionsResponseBodyDataListInstance()
            self.instance = temp_model.from_map(m['Instance'])
        if m.get('Score') is not None:
            self.score = m.get('Score')
        if m.get('ScoreMap') is not None:
            self.score_map = m.get('ScoreMap')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class GetInstanceInspectionsResponseBodyData(TeaModel):
    def __init__(
        self,
        list: List[GetInstanceInspectionsResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The mode in which the inspection and scoring task was initiated. Valid values:
        # 
        # *   **0**: automatic mode
        # *   **1**: manual mode
        self.list = list
        # The page number. The value returned is a positive integer. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetInstanceInspectionsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetInstanceInspectionsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetInstanceInspectionsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The inspection and scoring results.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetInstanceInspectionsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInstanceInspectionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInstanceInspectionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceInspectionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceMissingIndexListRequest(TeaModel):
    def __init__(
        self,
        avg_total_user_cost: str = None,
        avg_user_impact: str = None,
        end_time: str = None,
        index_count: str = None,
        instance_id: str = None,
        object_name: str = None,
        page_no: str = None,
        page_size: str = None,
        reserved_pages: str = None,
        reserved_size: str = None,
        row_count: str = None,
        start_time: str = None,
        unique_compiles: str = None,
        user_scans: str = None,
        user_seeks: str = None,
    ):
        # The query condition based on the average cost savings.
        self.avg_total_user_cost = avg_total_user_cost
        # The query condition based on the performance improvement.
        self.avg_user_impact = avg_user_impact
        # The end time of the last seek.
        self.end_time = end_time
        # The query condition based on the number of indexes.
        self.index_count = index_count
        # The database instance ID.
        # 
        # >  Only ApsaraDB RDS for SQL Server instances are supported.
        self.instance_id = instance_id
        # The object name.
        self.object_name = object_name
        # The page number. Pages start from page 1. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        # The query condition based on the total number of pages.
        self.reserved_pages = reserved_pages
        # The query condition based on the table size.
        self.reserved_size = reserved_size
        # The query condition based on the number of table rows.
        self.row_count = row_count
        # The start time of the last seek.
        self.start_time = start_time
        # The query condition based on the number of compilations.
        self.unique_compiles = unique_compiles
        # The query condition based on the number of scans.
        self.user_scans = user_scans
        # The query condition based on the number of seeks.
        self.user_seeks = user_seeks

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_total_user_cost is not None:
            result['AvgTotalUserCost'] = self.avg_total_user_cost
        if self.avg_user_impact is not None:
            result['AvgUserImpact'] = self.avg_user_impact
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.index_count is not None:
            result['IndexCount'] = self.index_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.object_name is not None:
            result['ObjectName'] = self.object_name
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.reserved_pages is not None:
            result['ReservedPages'] = self.reserved_pages
        if self.reserved_size is not None:
            result['ReservedSize'] = self.reserved_size
        if self.row_count is not None:
            result['RowCount'] = self.row_count
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.unique_compiles is not None:
            result['UniqueCompiles'] = self.unique_compiles
        if self.user_scans is not None:
            result['UserScans'] = self.user_scans
        if self.user_seeks is not None:
            result['UserSeeks'] = self.user_seeks
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgTotalUserCost') is not None:
            self.avg_total_user_cost = m.get('AvgTotalUserCost')
        if m.get('AvgUserImpact') is not None:
            self.avg_user_impact = m.get('AvgUserImpact')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IndexCount') is not None:
            self.index_count = m.get('IndexCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ObjectName') is not None:
            self.object_name = m.get('ObjectName')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ReservedPages') is not None:
            self.reserved_pages = m.get('ReservedPages')
        if m.get('ReservedSize') is not None:
            self.reserved_size = m.get('ReservedSize')
        if m.get('RowCount') is not None:
            self.row_count = m.get('RowCount')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('UniqueCompiles') is not None:
            self.unique_compiles = m.get('UniqueCompiles')
        if m.get('UserScans') is not None:
            self.user_scans = m.get('UserScans')
        if m.get('UserSeeks') is not None:
            self.user_seeks = m.get('UserSeeks')
        return self


class GetInstanceMissingIndexListResponseBodyDataList(TeaModel):
    def __init__(
        self,
        avg_total_user_cost: float = None,
        avg_user_impact: float = None,
        create_index: str = None,
        database_name: str = None,
        equality_columns: str = None,
        included_columns: str = None,
        index_count: int = None,
        inequality_columns: str = None,
        last_user_seek: int = None,
        object_name: str = None,
        reserved_pages: int = None,
        reserved_size: float = None,
        row_count: int = None,
        schema_name: str = None,
        system_scans: int = None,
        system_seeks: int = None,
        unique_compiles: int = None,
        user_scans: int = None,
        user_seeks: int = None,
    ):
        # The average cost savings.
        self.avg_total_user_cost = avg_total_user_cost
        # The performance improvement, in percentage.
        self.avg_user_impact = avg_user_impact
        # The statement used to create the missing indexes.
        self.create_index = create_index
        # The database name.
        self.database_name = database_name
        # The index columns included in the equal operation.
        self.equality_columns = equality_columns
        # The columns on which indexes are missing.
        self.included_columns = included_columns
        # The number of indexes.
        self.index_count = index_count
        # The index columns included in the not equal operation.
        self.inequality_columns = inequality_columns
        # The last seek time of a user.
        self.last_user_seek = last_user_seek
        # The object name.
        self.object_name = object_name
        # The total number of returned pages.
        self.reserved_pages = reserved_pages
        # The table size.
        self.reserved_size = reserved_size
        # The number of table rows.
        self.row_count = row_count
        # The schema name.
        self.schema_name = schema_name
        # The number of scans.
        self.system_scans = system_scans
        # The number of seeks.
        self.system_seeks = system_seeks
        # The number of compilations.
        self.unique_compiles = unique_compiles
        # The number of scans performed by users.
        self.user_scans = user_scans
        # The number of seeks performed by users.
        self.user_seeks = user_seeks

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_total_user_cost is not None:
            result['AvgTotalUserCost'] = self.avg_total_user_cost
        if self.avg_user_impact is not None:
            result['AvgUserImpact'] = self.avg_user_impact
        if self.create_index is not None:
            result['CreateIndex'] = self.create_index
        if self.database_name is not None:
            result['DatabaseName'] = self.database_name
        if self.equality_columns is not None:
            result['EqualityColumns'] = self.equality_columns
        if self.included_columns is not None:
            result['IncludedColumns'] = self.included_columns
        if self.index_count is not None:
            result['IndexCount'] = self.index_count
        if self.inequality_columns is not None:
            result['InequalityColumns'] = self.inequality_columns
        if self.last_user_seek is not None:
            result['LastUserSeek'] = self.last_user_seek
        if self.object_name is not None:
            result['ObjectName'] = self.object_name
        if self.reserved_pages is not None:
            result['ReservedPages'] = self.reserved_pages
        if self.reserved_size is not None:
            result['ReservedSize'] = self.reserved_size
        if self.row_count is not None:
            result['RowCount'] = self.row_count
        if self.schema_name is not None:
            result['SchemaName'] = self.schema_name
        if self.system_scans is not None:
            result['SystemScans'] = self.system_scans
        if self.system_seeks is not None:
            result['SystemSeeks'] = self.system_seeks
        if self.unique_compiles is not None:
            result['UniqueCompiles'] = self.unique_compiles
        if self.user_scans is not None:
            result['UserScans'] = self.user_scans
        if self.user_seeks is not None:
            result['UserSeeks'] = self.user_seeks
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgTotalUserCost') is not None:
            self.avg_total_user_cost = m.get('AvgTotalUserCost')
        if m.get('AvgUserImpact') is not None:
            self.avg_user_impact = m.get('AvgUserImpact')
        if m.get('CreateIndex') is not None:
            self.create_index = m.get('CreateIndex')
        if m.get('DatabaseName') is not None:
            self.database_name = m.get('DatabaseName')
        if m.get('EqualityColumns') is not None:
            self.equality_columns = m.get('EqualityColumns')
        if m.get('IncludedColumns') is not None:
            self.included_columns = m.get('IncludedColumns')
        if m.get('IndexCount') is not None:
            self.index_count = m.get('IndexCount')
        if m.get('InequalityColumns') is not None:
            self.inequality_columns = m.get('InequalityColumns')
        if m.get('LastUserSeek') is not None:
            self.last_user_seek = m.get('LastUserSeek')
        if m.get('ObjectName') is not None:
            self.object_name = m.get('ObjectName')
        if m.get('ReservedPages') is not None:
            self.reserved_pages = m.get('ReservedPages')
        if m.get('ReservedSize') is not None:
            self.reserved_size = m.get('ReservedSize')
        if m.get('RowCount') is not None:
            self.row_count = m.get('RowCount')
        if m.get('SchemaName') is not None:
            self.schema_name = m.get('SchemaName')
        if m.get('SystemScans') is not None:
            self.system_scans = m.get('SystemScans')
        if m.get('SystemSeeks') is not None:
            self.system_seeks = m.get('SystemSeeks')
        if m.get('UniqueCompiles') is not None:
            self.unique_compiles = m.get('UniqueCompiles')
        if m.get('UserScans') is not None:
            self.user_scans = m.get('UserScans')
        if m.get('UserSeeks') is not None:
            self.user_seeks = m.get('UserSeeks')
        return self


class GetInstanceMissingIndexListResponseBodyData(TeaModel):
    def __init__(
        self,
        list: List[GetInstanceMissingIndexListResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The returned data.
        self.list = list
        # The page number of the page returned.
        self.page_no = page_no
        # The number of entries per page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetInstanceMissingIndexListResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetInstanceMissingIndexListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetInstanceMissingIndexListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetInstanceMissingIndexListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInstanceMissingIndexListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInstanceMissingIndexListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceMissingIndexListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceSqlOptimizeStatisticRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        filter_enable: str = None,
        instance_id: str = None,
        node_id: str = None,
        start_time: str = None,
        threshold: str = None,
        use_merging: str = None,
    ):
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.end_time = end_time
        # Specifies whether to filter instances for which DAS Professional Edition is enabled. Valid values:
        # 
        # *   **true**: filters instances for which DAS Professional Edition is enabled.
        # *   **false**: does not filter instances for which DAS Professional Edition is enabled.
        # 
        # >  If you set the value to **true**, only database instances for which DAS Professional Edition is disabled are queried. If you set the value to **false**, all database instances are queried.
        self.filter_enable = filter_enable
        # The database instance ID.
        # 
        # >  The database instance must be an ApsaraDB RDS for MySQL instance or a PolarDB for MySQL cluster.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  This parameter must be specified if the database instance is an ApsaraDB RDS for MySQL Cluster Edition instance or a PolarDB for MySQL cluster.
        self.node_id = node_id
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time
        # The duration threshold for automatic SQL optimization events. After this parameter is specified, the system collects statistics on automatic SQL optimization events whose duration does not exceed the specified threshold.
        # 
        # >  This parameter is a reserved parameter and does not take effect.
        self.threshold = threshold
        # Specifies whether to merge automatic SQL optimization events. Valid values:
        # 
        # *   **true**: merges automatic SQL optimization events.
        # *   **false**: does not merge automatic SQL optimization events.
        # 
        # >  This parameter is a reserved parameter and does not take effect.
        self.use_merging = use_merging

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.filter_enable is not None:
            result['FilterEnable'] = self.filter_enable
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.use_merging is not None:
            result['UseMerging'] = self.use_merging
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FilterEnable') is not None:
            self.filter_enable = m.get('FilterEnable')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('UseMerging') is not None:
            self.use_merging = m.get('UseMerging')
        return self


class GetInstanceSqlOptimizeStatisticResponseBodyData(TeaModel):
    def __init__(
        self,
        count: int = None,
        improvement: float = None,
    ):
        # The total number of automatic SQL optimization events.
        self.count = count
        # The multiple of the maximum improvement for returned automatic SQL optimization events.
        self.improvement = improvement

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['count'] = self.count
        if self.improvement is not None:
            result['improvement'] = self.improvement
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('count') is not None:
            self.count = m.get('count')
        if m.get('improvement') is not None:
            self.improvement = m.get('improvement')
        return self


class GetInstanceSqlOptimizeStatisticResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetInstanceSqlOptimizeStatisticResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The details of the automatic SQL optimization events.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetInstanceSqlOptimizeStatisticResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetInstanceSqlOptimizeStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInstanceSqlOptimizeStatisticResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceSqlOptimizeStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetKillInstanceSessionTaskResultRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        node_id: str = None,
        task_id: str = None,
    ):
        # The instance ID.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  You must specify this parameter if your database instance is a PolarDB for MySQL cluster.
        self.node_id = node_id
        # The task ID. You can obtain the task ID from the response parameters of the [CreateKillInstanceSessionTask](~~609246~~) operation.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetKillInstanceSessionTaskResultResponseBodyDataResult(TeaModel):
    def __init__(
        self,
        active: bool = None,
        command: str = None,
        db: str = None,
        host: str = None,
        id: int = None,
        info: str = None,
        reason: str = None,
        state: str = None,
        task_id: str = None,
        time: int = None,
        user: str = None,
    ):
        # Indicates whether the session is active.
        # 
        # > If the type of the command is Query or Execute and the session in the transaction is not terminated, the session is active.
        self.active = active
        # The type of the command executed in the session.
        self.command = command
        # The name of the database.
        self.db = db
        # The IP address and port number of the host that initiated the session.
        self.host = host
        # The session ID.
        self.id = id
        # The SQL statement executed in the session.
        self.info = info
        # The description of the session when the session was terminated.
        # 
        # *   **SESSION_KILLED**: The session is terminated.
        # *   **SESSION_EXPIRED**: The session has expired.
        # *   **SESSION_NO_PERMISSION**: The account used to terminate the session has insufficient permissions.
        # *   **SESSION_ACCOUNT_ERROR**: The account or password used to terminate the session is invalid.
        # *   **SESSION_IGNORED_USER**: The session of the account does not need to be terminated.
        # *   **SESSION_INTERNAL_USER_OR_COMMAND**: The session is a session initiated by or a command run by an Alibaba Cloud O\&M account.
        # *   **SESSION_KILL_TASK_TIMEOUT**: Timeout occurs when the session is terminated.
        # *   **SESSION_OTHER_ERROR**: Other errors occurred.
        self.reason = reason
        # The status of the session.
        self.state = state
        # The ID of the subtask that terminates the session.
        self.task_id = task_id
        # The execution duration. Unit: seconds.
        self.time = time
        # The account of the database.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.command is not None:
            result['Command'] = self.command
        if self.db is not None:
            result['Db'] = self.db
        if self.host is not None:
            result['Host'] = self.host
        if self.id is not None:
            result['Id'] = self.id
        if self.info is not None:
            result['Info'] = self.info
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.state is not None:
            result['State'] = self.state
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.time is not None:
            result['Time'] = self.time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class GetKillInstanceSessionTaskResultResponseBodyData(TeaModel):
    def __init__(
        self,
        ignored_user_session_count: int = None,
        instance_id: str = None,
        kill_fail_count: int = None,
        kill_success_count: int = None,
        node_id: str = None,
        result: List[GetKillInstanceSessionTaskResultResponseBodyDataResult] = None,
        sessions: List[int] = None,
        task_id: str = None,
        task_state: str = None,
        user_id: str = None,
    ):
        # The number of ignored sessions, including sessions of the accounts that are specified by IgnoredUsers, sessions of internal O\&M accounts of Alibaba Cloud, and **Binlog Dump** sessions.
        self.ignored_user_session_count = ignored_user_session_count
        # The instance ID.
        self.instance_id = instance_id
        # The number of sessions that failed to be terminated.
        self.kill_fail_count = kill_fail_count
        # The number of sessions that were terminated.
        self.kill_success_count = kill_success_count
        # The node ID.
        # 
        # >  This parameter is returned only if the instance is a PolarDB for MySQL cluster.
        self.node_id = node_id
        # The details of the task that terminated sessions.
        self.result = result
        # The session IDs.
        # 
        # >  If all sessions are terminated, the IDs of all sessions on the instance or node are returned.
        self.sessions = sessions
        # The task ID.
        self.task_id = task_id
        # The state of the task that terminates sessions.
        # 
        # *   **RUNNING**: The task is in progress.
        # *   **SUCCESS**: The task is successful.
        # *   **FAILURE**: The task failed.
        # *   **ERROR**: Other errors occur.
        self.task_state = task_state
        # The ID of the Alibaba Cloud account.
        self.user_id = user_id

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignored_user_session_count is not None:
            result['IgnoredUserSessionCount'] = self.ignored_user_session_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.kill_fail_count is not None:
            result['KillFailCount'] = self.kill_fail_count
        if self.kill_success_count is not None:
            result['KillSuccessCount'] = self.kill_success_count
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        if self.sessions is not None:
            result['Sessions'] = self.sessions
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IgnoredUserSessionCount') is not None:
            self.ignored_user_session_count = m.get('IgnoredUserSessionCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('KillFailCount') is not None:
            self.kill_fail_count = m.get('KillFailCount')
        if m.get('KillSuccessCount') is not None:
            self.kill_success_count = m.get('KillSuccessCount')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = GetKillInstanceSessionTaskResultResponseBodyDataResult()
                self.result.append(temp_model.from_map(k))
        if m.get('Sessions') is not None:
            self.sessions = m.get('Sessions')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetKillInstanceSessionTaskResultResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetKillInstanceSessionTaskResultResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetKillInstanceSessionTaskResultResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetKillInstanceSessionTaskResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetKillInstanceSessionTaskResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetKillInstanceSessionTaskResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMongoDBCurrentOpRequest(TeaModel):
    def __init__(
        self,
        filter_doc: str = None,
        instance_id: str = None,
        node_id: str = None,
        role: str = None,
    ):
        # The `db.currentOp()` command that is used to filter sessions. For more information, see [db.currentOp()](https://docs.mongodb.com/manual/reference/method/db.currentOp/) of MongoDB Documentation.
        self.filter_doc = filter_doc
        # The instance ID.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  If you do not specify a node ID, the sessions of the primary node are queried by default.
        self.node_id = node_id
        # A reserved parameter. You do not need to specify the parameter.
        self.role = role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filter_doc is not None:
            result['FilterDoc'] = self.filter_doc
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FilterDoc') is not None:
            self.filter_doc = m.get('FilterDoc')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class GetMongoDBCurrentOpResponseBodyDataSessionList(TeaModel):
    def __init__(
        self,
        active: bool = None,
        client: str = None,
        command: str = None,
        connection_id: int = None,
        desc: str = None,
        driver: str = None,
        host: str = None,
        kill_pending: bool = None,
        ns: str = None,
        op: str = None,
        op_id: str = None,
        os_arch: str = None,
        os_name: str = None,
        os_type: str = None,
        plan_summary: str = None,
        platform: str = None,
        secs_running: int = None,
        shard: str = None,
    ):
        # Indicates whether the operation is active. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.active = active
        # The IP address of the client.
        self.client = client
        # The document that contains the complete command object associated with the operation.
        self.command = command
        # The connection ID.
        self.connection_id = connection_id
        # The description of the connection.
        self.desc = desc
        # The driver for MongoDB.
        self.driver = driver
        # The host.
        self.host = host
        # Indicates whether the operation is marked as terminated.
        # 
        # *   **true**\
        # *   **false**\
        self.kill_pending = kill_pending
        # The namespace.
        self.ns = ns
        # The type of the operation.
        self.op = op
        # The operation ID.
        self.op_id = op_id
        # The architecture of the operating system.
        self.os_arch = os_arch
        # The name of the operating system.
        self.os_name = os_name
        # The type of the operating system.
        self.os_type = os_type
        # The description of the execution plan.
        self.plan_summary = plan_summary
        # The platform.
        self.platform = platform
        # The duration of the operation. Unit: seconds.
        self.secs_running = secs_running
        # The ID of the data shard.
        # 
        # >  This parameter is returned for sharded cluster instances.
        self.shard = shard

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.client is not None:
            result['Client'] = self.client
        if self.command is not None:
            result['Command'] = self.command
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.driver is not None:
            result['Driver'] = self.driver
        if self.host is not None:
            result['Host'] = self.host
        if self.kill_pending is not None:
            result['KillPending'] = self.kill_pending
        if self.ns is not None:
            result['Ns'] = self.ns
        if self.op is not None:
            result['Op'] = self.op
        if self.op_id is not None:
            result['OpId'] = self.op_id
        if self.os_arch is not None:
            result['OsArch'] = self.os_arch
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.plan_summary is not None:
            result['PlanSummary'] = self.plan_summary
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.secs_running is not None:
            result['SecsRunning'] = self.secs_running
        if self.shard is not None:
            result['Shard'] = self.shard
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('Client') is not None:
            self.client = m.get('Client')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Driver') is not None:
            self.driver = m.get('Driver')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('KillPending') is not None:
            self.kill_pending = m.get('KillPending')
        if m.get('Ns') is not None:
            self.ns = m.get('Ns')
        if m.get('Op') is not None:
            self.op = m.get('Op')
        if m.get('OpId') is not None:
            self.op_id = m.get('OpId')
        if m.get('OsArch') is not None:
            self.os_arch = m.get('OsArch')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('PlanSummary') is not None:
            self.plan_summary = m.get('PlanSummary')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('SecsRunning') is not None:
            self.secs_running = m.get('SecsRunning')
        if m.get('Shard') is not None:
            self.shard = m.get('Shard')
        return self


class GetMongoDBCurrentOpResponseBodyDataSessionStat(TeaModel):
    def __init__(
        self,
        active_count: int = None,
        client_stats: Dict[str, DataSessionStatClientStatsValue] = None,
        db_stats: Dict[str, DataSessionStatDbStatsValue] = None,
        longest_secs_running: int = None,
        total_count: int = None,
    ):
        # The number of active sessions.
        self.active_count = active_count
        # The statistics on the IP addresses of the clients.
        self.client_stats = client_stats
        # The statistics on the namespaces.
        self.db_stats = db_stats
        # The longest duration of a session. Unit: seconds.
        self.longest_secs_running = longest_secs_running
        # The total number of sessions.
        self.total_count = total_count

    def validate(self):
        if self.client_stats:
            for v in self.client_stats.values():
                if v:
                    v.validate()
        if self.db_stats:
            for v in self.db_stats.values():
                if v:
                    v.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_count is not None:
            result['ActiveCount'] = self.active_count
        result['ClientStats'] = {}
        if self.client_stats is not None:
            for k, v in self.client_stats.items():
                result['ClientStats'][k] = v.to_map()
        result['DbStats'] = {}
        if self.db_stats is not None:
            for k, v in self.db_stats.items():
                result['DbStats'][k] = v.to_map()
        if self.longest_secs_running is not None:
            result['LongestSecsRunning'] = self.longest_secs_running
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveCount') is not None:
            self.active_count = m.get('ActiveCount')
        self.client_stats = {}
        if m.get('ClientStats') is not None:
            for k, v in m.get('ClientStats').items():
                temp_model = DataSessionStatClientStatsValue()
                self.client_stats[k] = temp_model.from_map(v)
        self.db_stats = {}
        if m.get('DbStats') is not None:
            for k, v in m.get('DbStats').items():
                temp_model = DataSessionStatDbStatsValue()
                self.db_stats[k] = temp_model.from_map(v)
        if m.get('LongestSecsRunning') is not None:
            self.longest_secs_running = m.get('LongestSecsRunning')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetMongoDBCurrentOpResponseBodyData(TeaModel):
    def __init__(
        self,
        session_list: List[GetMongoDBCurrentOpResponseBodyDataSessionList] = None,
        session_stat: GetMongoDBCurrentOpResponseBodyDataSessionStat = None,
        timestamp: int = None,
    ):
        # The sessions.
        self.session_list = session_list
        # The statistics on the sessions.
        self.session_stat = session_stat
        # The time when the database sessions were returned. The value is in the UNIX timestamp format. Unit: milliseconds.
        self.timestamp = timestamp

    def validate(self):
        if self.session_list:
            for k in self.session_list:
                if k:
                    k.validate()
        if self.session_stat:
            self.session_stat.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SessionList'] = []
        if self.session_list is not None:
            for k in self.session_list:
                result['SessionList'].append(k.to_map() if k else None)
        if self.session_stat is not None:
            result['SessionStat'] = self.session_stat.to_map()
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.session_list = []
        if m.get('SessionList') is not None:
            for k in m.get('SessionList'):
                temp_model = GetMongoDBCurrentOpResponseBodyDataSessionList()
                self.session_list.append(temp_model.from_map(k))
        if m.get('SessionStat') is not None:
            temp_model = GetMongoDBCurrentOpResponseBodyDataSessionStat()
            self.session_stat = temp_model.from_map(m['SessionStat'])
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetMongoDBCurrentOpResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetMongoDBCurrentOpResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The response code.
        self.code = code
        # The details of the sessions.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. Otherwise, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetMongoDBCurrentOpResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMongoDBCurrentOpResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMongoDBCurrentOpResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMongoDBCurrentOpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMySQLAllSessionAsyncRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        node_id: str = None,
        result_id: str = None,
    ):
        # The instance ID.
        # 
        # >  Only ApsaraDB RDS for MySQL, PolarDB for MySQL, and PolarDB-X 2.0 instances are supported.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  You must specify this parameter for PolarDB for MySQL clusters. If you do not specify a node ID, the session data of the primary node is returned by default.
        self.node_id = node_id
        # The ID of the asynchronous request.
        # 
        # >  You can leave this parameter empty when you call the operation to initiate the request for the first time, and use the value of this parameter contained in the response to the first request for subsequent requests.
        self.result_id = result_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.result_id is not None:
            result['ResultId'] = self.result_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('ResultId') is not None:
            self.result_id = m.get('ResultId')
        return self


class GetMySQLAllSessionAsyncResponseBodyDataSessionDataClientStats(TeaModel):
    def __init__(
        self,
        active_count: int = None,
        key: str = None,
        thread_id_list: List[int] = None,
        total_count: int = None,
        user_list: List[str] = None,
    ):
        # The number of active sessions that belong to the client IP address.
        # 
        # >  If the type of the command executed in the session is Query or Execute and the session in the transaction is not terminated, the session is active.
        self.active_count = active_count
        # The IP address of the client.
        self.key = key
        # The IDs of the sessions that belong to the client IP address.
        self.thread_id_list = thread_id_list
        # The total number of sessions that belong to the client IP address.
        self.total_count = total_count
        # The database accounts to which the sessions belong.
        self.user_list = user_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_count is not None:
            result['ActiveCount'] = self.active_count
        if self.key is not None:
            result['Key'] = self.key
        if self.thread_id_list is not None:
            result['ThreadIdList'] = self.thread_id_list
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.user_list is not None:
            result['UserList'] = self.user_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveCount') is not None:
            self.active_count = m.get('ActiveCount')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ThreadIdList') is not None:
            self.thread_id_list = m.get('ThreadIdList')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('UserList') is not None:
            self.user_list = m.get('UserList')
        return self


class GetMySQLAllSessionAsyncResponseBodyDataSessionDataDbStats(TeaModel):
    def __init__(
        self,
        active_count: int = None,
        key: str = None,
        thread_id_list: List[int] = None,
        total_count: int = None,
        user_list: List[str] = None,
    ):
        # The number of active sessions of the database.
        # 
        # >  If the type of the command executed in the session is Query or Execute and the session in the transaction is not terminated, the session is active.
        self.active_count = active_count
        # The database name.
        self.key = key
        # The IDs of the sessions of the database.
        self.thread_id_list = thread_id_list
        # The total number of sessions of the database.
        self.total_count = total_count
        # The database accounts to which the sessions belong.
        self.user_list = user_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_count is not None:
            result['ActiveCount'] = self.active_count
        if self.key is not None:
            result['Key'] = self.key
        if self.thread_id_list is not None:
            result['ThreadIdList'] = self.thread_id_list
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.user_list is not None:
            result['UserList'] = self.user_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveCount') is not None:
            self.active_count = m.get('ActiveCount')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ThreadIdList') is not None:
            self.thread_id_list = m.get('ThreadIdList')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('UserList') is not None:
            self.user_list = m.get('UserList')
        return self


class GetMySQLAllSessionAsyncResponseBodyDataSessionDataSessionList(TeaModel):
    def __init__(
        self,
        client: str = None,
        command: str = None,
        db_name: str = None,
        session_id: int = None,
        sql_template_id: str = None,
        sql_text: str = None,
        state: str = None,
        time: int = None,
        trx_duration: int = None,
        trx_id: str = None,
        user: str = None,
        user_client_alias: str = None,
    ):
        # The IP address of the client.
        self.client = client
        # The type of the command executed in the session.
        self.command = command
        # The database name.
        self.db_name = db_name
        # The session ID.
        self.session_id = session_id
        # The SQL template ID.
        # 
        # >  This parameter is returned only when you use a PolarDB-X 2.0 instance.
        self.sql_template_id = sql_template_id
        # The SQL statement executed in the session.
        self.sql_text = sql_text
        # The status of the session.
        self.state = state
        # The execution duration of the session. Unit: seconds.
        self.time = time
        # The duration of the transaction. Unit: seconds.
        self.trx_duration = trx_duration
        # The ID of the transaction to which the session belongs.
        self.trx_id = trx_id
        # The username of the database account.
        self.user = user
        # The alias of the IP address of the client.
        self.user_client_alias = user_client_alias

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client is not None:
            result['Client'] = self.client
        if self.command is not None:
            result['Command'] = self.command
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.session_id is not None:
            result['SessionId'] = self.session_id
        if self.sql_template_id is not None:
            result['SqlTemplateId'] = self.sql_template_id
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        if self.state is not None:
            result['State'] = self.state
        if self.time is not None:
            result['Time'] = self.time
        if self.trx_duration is not None:
            result['TrxDuration'] = self.trx_duration
        if self.trx_id is not None:
            result['TrxId'] = self.trx_id
        if self.user is not None:
            result['User'] = self.user
        if self.user_client_alias is not None:
            result['UserClientAlias'] = self.user_client_alias
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Client') is not None:
            self.client = m.get('Client')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('SessionId') is not None:
            self.session_id = m.get('SessionId')
        if m.get('SqlTemplateId') is not None:
            self.sql_template_id = m.get('SqlTemplateId')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('TrxDuration') is not None:
            self.trx_duration = m.get('TrxDuration')
        if m.get('TrxId') is not None:
            self.trx_id = m.get('TrxId')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('UserClientAlias') is not None:
            self.user_client_alias = m.get('UserClientAlias')
        return self


class GetMySQLAllSessionAsyncResponseBodyDataSessionDataUserStats(TeaModel):
    def __init__(
        self,
        active_count: int = None,
        key: str = None,
        thread_id_list: List[int] = None,
        total_count: int = None,
        user_list: List[str] = None,
    ):
        # The number of active sessions within the account.
        # 
        # >  If the type of the command executed in the session is Query or Execute and the session in the transaction is not terminated, the session is active.
        self.active_count = active_count
        # The database account.
        self.key = key
        # The IDs of the sessions within the account.
        self.thread_id_list = thread_id_list
        # The total number of sessions within the account.
        self.total_count = total_count
        # The database accounts to which the sessions belong.
        self.user_list = user_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_count is not None:
            result['ActiveCount'] = self.active_count
        if self.key is not None:
            result['Key'] = self.key
        if self.thread_id_list is not None:
            result['ThreadIdList'] = self.thread_id_list
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.user_list is not None:
            result['UserList'] = self.user_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveCount') is not None:
            self.active_count = m.get('ActiveCount')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ThreadIdList') is not None:
            self.thread_id_list = m.get('ThreadIdList')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('UserList') is not None:
            self.user_list = m.get('UserList')
        return self


class GetMySQLAllSessionAsyncResponseBodyDataSessionData(TeaModel):
    def __init__(
        self,
        active_session_count: int = None,
        client_stats: List[GetMySQLAllSessionAsyncResponseBodyDataSessionDataClientStats] = None,
        db_stats: List[GetMySQLAllSessionAsyncResponseBodyDataSessionDataDbStats] = None,
        max_active_time: int = None,
        session_list: List[GetMySQLAllSessionAsyncResponseBodyDataSessionDataSessionList] = None,
        time_stamp: int = None,
        total_session_count: int = None,
        user_stats: List[GetMySQLAllSessionAsyncResponseBodyDataSessionDataUserStats] = None,
    ):
        # The total number of active sessions.
        self.active_session_count = active_session_count
        # The sessions that are counted by client IP address.
        self.client_stats = client_stats
        # The sessions that are counted by database.
        self.db_stats = db_stats
        # The maximum execution duration of an active session. Unit: seconds.
        self.max_active_time = max_active_time
        # The sessions.
        self.session_list = session_list
        # The time when the session was queried. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.time_stamp = time_stamp
        # The total number of sessions.
        self.total_session_count = total_session_count
        # The sessions that are counted by database account.
        self.user_stats = user_stats

    def validate(self):
        if self.client_stats:
            for k in self.client_stats:
                if k:
                    k.validate()
        if self.db_stats:
            for k in self.db_stats:
                if k:
                    k.validate()
        if self.session_list:
            for k in self.session_list:
                if k:
                    k.validate()
        if self.user_stats:
            for k in self.user_stats:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_session_count is not None:
            result['ActiveSessionCount'] = self.active_session_count
        result['ClientStats'] = []
        if self.client_stats is not None:
            for k in self.client_stats:
                result['ClientStats'].append(k.to_map() if k else None)
        result['DbStats'] = []
        if self.db_stats is not None:
            for k in self.db_stats:
                result['DbStats'].append(k.to_map() if k else None)
        if self.max_active_time is not None:
            result['MaxActiveTime'] = self.max_active_time
        result['SessionList'] = []
        if self.session_list is not None:
            for k in self.session_list:
                result['SessionList'].append(k.to_map() if k else None)
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.total_session_count is not None:
            result['TotalSessionCount'] = self.total_session_count
        result['UserStats'] = []
        if self.user_stats is not None:
            for k in self.user_stats:
                result['UserStats'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveSessionCount') is not None:
            self.active_session_count = m.get('ActiveSessionCount')
        self.client_stats = []
        if m.get('ClientStats') is not None:
            for k in m.get('ClientStats'):
                temp_model = GetMySQLAllSessionAsyncResponseBodyDataSessionDataClientStats()
                self.client_stats.append(temp_model.from_map(k))
        self.db_stats = []
        if m.get('DbStats') is not None:
            for k in m.get('DbStats'):
                temp_model = GetMySQLAllSessionAsyncResponseBodyDataSessionDataDbStats()
                self.db_stats.append(temp_model.from_map(k))
        if m.get('MaxActiveTime') is not None:
            self.max_active_time = m.get('MaxActiveTime')
        self.session_list = []
        if m.get('SessionList') is not None:
            for k in m.get('SessionList'):
                temp_model = GetMySQLAllSessionAsyncResponseBodyDataSessionDataSessionList()
                self.session_list.append(temp_model.from_map(k))
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('TotalSessionCount') is not None:
            self.total_session_count = m.get('TotalSessionCount')
        self.user_stats = []
        if m.get('UserStats') is not None:
            for k in m.get('UserStats'):
                temp_model = GetMySQLAllSessionAsyncResponseBodyDataSessionDataUserStats()
                self.user_stats.append(temp_model.from_map(k))
        return self


class GetMySQLAllSessionAsyncResponseBodyData(TeaModel):
    def __init__(
        self,
        complete: bool = None,
        fail: bool = None,
        is_finish: bool = None,
        result_id: str = None,
        session_data: GetMySQLAllSessionAsyncResponseBodyDataSessionData = None,
        state: str = None,
        timestamp: int = None,
    ):
        # Indicates whether the asynchronous request was complete. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.complete = complete
        # Indicates whether the asynchronous request failed. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.fail = fail
        # Indicates whether the asynchronous request was complete. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.is_finish = is_finish
        # The ID of the asynchronous request.
        self.result_id = result_id
        # The session data.
        self.session_data = session_data
        # The state of the asynchronous request. Valid values:
        # 
        # *   **RUNNING**\
        # *   **SUCCESS**\
        # *   **FAIL**\
        self.state = state
        # The time when the asynchronous request was made. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp

    def validate(self):
        if self.session_data:
            self.session_data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete is not None:
            result['Complete'] = self.complete
        if self.fail is not None:
            result['Fail'] = self.fail
        if self.is_finish is not None:
            result['IsFinish'] = self.is_finish
        if self.result_id is not None:
            result['ResultId'] = self.result_id
        if self.session_data is not None:
            result['SessionData'] = self.session_data.to_map()
        if self.state is not None:
            result['State'] = self.state
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Complete') is not None:
            self.complete = m.get('Complete')
        if m.get('Fail') is not None:
            self.fail = m.get('Fail')
        if m.get('IsFinish') is not None:
            self.is_finish = m.get('IsFinish')
        if m.get('ResultId') is not None:
            self.result_id = m.get('ResultId')
        if m.get('SessionData') is not None:
            temp_model = GetMySQLAllSessionAsyncResponseBodyDataSessionData()
            self.session_data = temp_model.from_map(m['SessionData'])
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class GetMySQLAllSessionAsyncResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetMySQLAllSessionAsyncResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetMySQLAllSessionAsyncResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMySQLAllSessionAsyncResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMySQLAllSessionAsyncResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMySQLAllSessionAsyncResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPartitionsHeatmapRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        instance_id: str = None,
        time_range: str = None,
        type: str = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The instance ID.
        self.instance_id = instance_id
        # The time range to be queried. Valid values:
        # 
        # *   **LAST_ONE_HOURS**: the last hour.
        # *   **LAST_SIX_HOURS**: the last six hours.
        # *   **LAST_ONE_DAYS**: the last day.
        # *   **LAST_THREE_DAYS**: the last three days.
        # *   **LAST_SEVEN_DAYS**: the last seven days.
        self.time_range = time_range
        # The type of the data to be queried. Valid values:
        # 
        # *   **READ_ROWS**: the read rows.
        # *   **WRITTEN_ROWS**: the written rows.
        # *   **READ_WRITTEN_ROWS**: the read and written rows.
        # *   **UPDATE_ROWS**: the updated rows.
        # *   **INSERTED_ROWS**: the inserted rows.
        # *   **DELETED_ROWS**: the deleted rows.
        # *   **READ_ROWS_WITH_DN**: the read rows returned from a data node.
        # *   **WRITTEN_ROWS_WITH_DN**: the written rows returned from a data node.
        # *   **READ_WRITTEN_ROWS_WITH_DN**: the read and written rows returned from a data node.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.time_range is not None:
            result['TimeRange'] = self.time_range
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TimeRange') is not None:
            self.time_range = m.get('TimeRange')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetPartitionsHeatmapResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The hot data of the PolarDB-X 2.0 instance. The data is returned in JSON format.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message that contains information such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetPartitionsHeatmapResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPartitionsHeatmapResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPartitionsHeatmapResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPfsMetricTrendsRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        instance_id: str = None,
        metric: str = None,
        node_id: str = None,
        start_time: int = None,
    ):
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time. You can view the data of up to seven days in the previous 30 days.
        self.end_time = end_time
        # The instance ID.
        self.instance_id = instance_id
        # The metric whose trend you want to query. Valid values:
        # 
        # *   **count**: the number of executions.
        # *   **avgRt**: the average execution duration.
        # *   **rtRate**: the execution duration percentage.
        # *   **rowsExamined**: the total number of scanned rows.
        self.metric = metric
        # The node ID.
        # 
        # >  You must specify this parameter for an ApsaraDB RDS for MySQL cluster instance and a PolarDB for MySQL cluster.
        self.node_id = node_id
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.metric is not None:
            result['Metric'] = self.metric
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Metric') is not None:
            self.metric = m.get('Metric')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetPfsMetricTrendsResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: Dict[str, List[DataValue]] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            for v in self.data.values():
                for k1 in v:
                    if k1:
                        k1.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = {}
        if self.data is not None:
            for k, v in self.data.items():
                l1 = []
                for k1 in v:
                    l1.append(k1.to_map() if k1 else None)
                result['Data'][k] = l1
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = {}
        if m.get('Data') is not None:
            for k, v in m.get('Data').items():
                l1 = []
                for k1 in v:
                    temp_model = DataValue()
                    l1.append(temp_model.from_map(k1))
                self.data['k'] = l1
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetPfsMetricTrendsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPfsMetricTrendsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPfsMetricTrendsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPfsSqlSampleRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        instance_id: str = None,
        node_id: str = None,
        sql_id: str = None,
        start_time: int = None,
    ):
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time. You can query the data of up to seven days within the last month.
        self.end_time = end_time
        # The instance ID.
        # 
        # >  Only ApsaraDB RDS for MySQL instances and PolarDB for MySQL clusters are supported.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  This parameter must be specified for ApsaraDB RDS for MySQL Cluster Edition instances and PolarDB for MySQL clusters.
        self.node_id = node_id
        # The SQL ID.
        self.sql_id = sql_id
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetPfsSqlSampleResponseBodyData(TeaModel):
    def __init__(
        self,
        create_tmp_disk_tables: int = None,
        create_tmp_tables: int = None,
        db: str = None,
        end_event_id: int = None,
        errors: int = None,
        event_id: int = None,
        event_name: str = None,
        instance_id: str = None,
        latency: float = None,
        lock_latency: float = None,
        logic_id: str = None,
        no_good_index_used: int = None,
        no_index_used: int = None,
        node_id: str = None,
        rows_affected: int = None,
        rows_examined: int = None,
        rows_sent: int = None,
        select_full_join: int = None,
        select_full_range_join: int = None,
        select_range: int = None,
        select_range_check: int = None,
        select_scan: int = None,
        sort_merge_passes: int = None,
        sort_range: int = None,
        sort_rows: int = None,
        sort_scan: int = None,
        sql: str = None,
        sql_id: str = None,
        thread_id: int = None,
        timestamp: int = None,
        user_id: str = None,
        warnings: int = None,
    ):
        # The number of internal on-disk temporary tables that were created when the SQL statement was executed.
        self.create_tmp_disk_tables = create_tmp_disk_tables
        # The number of internal temporary tables that were created when the SQL statement was executed.
        self.create_tmp_tables = create_tmp_tables
        # The name of the database.
        self.db = db
        # The end ID of the event. By default, the value of this parameter is NULL when the event starts and is changed to the event ID when the event ends.
        self.end_event_id = end_event_id
        # The number of errors returned for the SQL statement.
        self.errors = errors
        # The event ID.
        self.event_id = event_id
        # The name of the event.
        self.event_name = event_name
        # The instance ID.
        self.instance_id = instance_id
        # The execution duration. Unit: millisecond.
        self.latency = latency
        # The lock wait duration. Unit: millisecond.
        self.lock_latency = lock_latency
        # The logical database ID.
        self.logic_id = logic_id
        # Indicates whether the server failed to find an index that can be used for the SQL statement. Valid values:
        # 
        # * **1:** yes.
        # * **0:** no.
        self.no_good_index_used = no_good_index_used
        # Indicates whether table scans were performed when indexes were not used. Valid values:
        # 
        # * **1:** yes.
        # * **0:** no.
        self.no_index_used = no_index_used
        # The node ID.
        # 
        # > This parameter is returned only for ApsaraDB RDS for MySQL Cluster Edition instances and PolarDB for MySQL clusters.
        self.node_id = node_id
        # The number of rows affected by the SQL statement.
        self.rows_affected = rows_affected
        # The number of rows scanned by the SQL statement.
        self.rows_examined = rows_examined
        # The number of rows returned by the SQL statement.
        self.rows_sent = rows_sent
        # The number of joins that are used to perform table scans without using indexes.
        # 
        # > This parameter is used to count the number of joins that did not use indexes. If the value of this parameter is not 0, check the table indexes.
        self.select_full_join = select_full_join
        # The number of joins that used ranges on referenced tables.
        self.select_full_range_join = select_full_range_join
        # The number of joins that used ranges on the first table.
        self.select_range = select_range
        # The number of joins that did not have key values. The keys and values were checked for each row of data.
        # 
        # >  This parameter is used to count the number of joins that did not use indexes. If the value of this parameter is not 0, check the table indexes.
        self.select_range_check = select_range_check
        # The number of scans.
        self.select_scan = select_scan
        # The number of merges that the sorting algorithm must perform.
        self.sort_merge_passes = sort_merge_passes
        # The number of times the data was sorted by using ranges.
        self.sort_range = sort_range
        # The number of sorted rows.
        self.sort_rows = sort_rows
        # The number of sorts that were performed during table scans.
        self.sort_scan = sort_scan
        # The SQL sample.
        self.sql = sql
        # The SQL ID.
        self.sql_id = sql_id
        # The thread ID.
        self.thread_id = thread_id
        # The time when the SQL statement was executed. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp
        # The user ID.
        self.user_id = user_id
        # The number of warnings returned for the SQL statement.
        self.warnings = warnings

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_tmp_disk_tables is not None:
            result['CreateTmpDiskTables'] = self.create_tmp_disk_tables
        if self.create_tmp_tables is not None:
            result['CreateTmpTables'] = self.create_tmp_tables
        if self.db is not None:
            result['Db'] = self.db
        if self.end_event_id is not None:
            result['EndEventId'] = self.end_event_id
        if self.errors is not None:
            result['Errors'] = self.errors
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.latency is not None:
            result['Latency'] = self.latency
        if self.lock_latency is not None:
            result['LockLatency'] = self.lock_latency
        if self.logic_id is not None:
            result['LogicId'] = self.logic_id
        if self.no_good_index_used is not None:
            result['NoGoodIndexUsed'] = self.no_good_index_used
        if self.no_index_used is not None:
            result['NoIndexUsed'] = self.no_index_used
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.rows_affected is not None:
            result['RowsAffected'] = self.rows_affected
        if self.rows_examined is not None:
            result['RowsExamined'] = self.rows_examined
        if self.rows_sent is not None:
            result['RowsSent'] = self.rows_sent
        if self.select_full_join is not None:
            result['SelectFullJoin'] = self.select_full_join
        if self.select_full_range_join is not None:
            result['SelectFullRangeJoin'] = self.select_full_range_join
        if self.select_range is not None:
            result['SelectRange'] = self.select_range
        if self.select_range_check is not None:
            result['SelectRangeCheck'] = self.select_range_check
        if self.select_scan is not None:
            result['SelectScan'] = self.select_scan
        if self.sort_merge_passes is not None:
            result['SortMergePasses'] = self.sort_merge_passes
        if self.sort_range is not None:
            result['SortRange'] = self.sort_range
        if self.sort_rows is not None:
            result['SortRows'] = self.sort_rows
        if self.sort_scan is not None:
            result['SortScan'] = self.sort_scan
        if self.sql is not None:
            result['Sql'] = self.sql
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.thread_id is not None:
            result['ThreadId'] = self.thread_id
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.warnings is not None:
            result['Warnings'] = self.warnings
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTmpDiskTables') is not None:
            self.create_tmp_disk_tables = m.get('CreateTmpDiskTables')
        if m.get('CreateTmpTables') is not None:
            self.create_tmp_tables = m.get('CreateTmpTables')
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('EndEventId') is not None:
            self.end_event_id = m.get('EndEventId')
        if m.get('Errors') is not None:
            self.errors = m.get('Errors')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Latency') is not None:
            self.latency = m.get('Latency')
        if m.get('LockLatency') is not None:
            self.lock_latency = m.get('LockLatency')
        if m.get('LogicId') is not None:
            self.logic_id = m.get('LogicId')
        if m.get('NoGoodIndexUsed') is not None:
            self.no_good_index_used = m.get('NoGoodIndexUsed')
        if m.get('NoIndexUsed') is not None:
            self.no_index_used = m.get('NoIndexUsed')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('RowsAffected') is not None:
            self.rows_affected = m.get('RowsAffected')
        if m.get('RowsExamined') is not None:
            self.rows_examined = m.get('RowsExamined')
        if m.get('RowsSent') is not None:
            self.rows_sent = m.get('RowsSent')
        if m.get('SelectFullJoin') is not None:
            self.select_full_join = m.get('SelectFullJoin')
        if m.get('SelectFullRangeJoin') is not None:
            self.select_full_range_join = m.get('SelectFullRangeJoin')
        if m.get('SelectRange') is not None:
            self.select_range = m.get('SelectRange')
        if m.get('SelectRangeCheck') is not None:
            self.select_range_check = m.get('SelectRangeCheck')
        if m.get('SelectScan') is not None:
            self.select_scan = m.get('SelectScan')
        if m.get('SortMergePasses') is not None:
            self.sort_merge_passes = m.get('SortMergePasses')
        if m.get('SortRange') is not None:
            self.sort_range = m.get('SortRange')
        if m.get('SortRows') is not None:
            self.sort_rows = m.get('SortRows')
        if m.get('SortScan') is not None:
            self.sort_scan = m.get('SortScan')
        if m.get('Sql') is not None:
            self.sql = m.get('Sql')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('ThreadId') is not None:
            self.thread_id = m.get('ThreadId')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Warnings') is not None:
            self.warnings = m.get('Warnings')
        return self


class GetPfsSqlSampleResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: List[GetPfsSqlSampleResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The queried SQL sample data.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetPfsSqlSampleResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetPfsSqlSampleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPfsSqlSampleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPfsSqlSampleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPfsSqlSummariesRequest(TeaModel):
    def __init__(
        self,
        asc: bool = None,
        end_time: int = None,
        instance_id: str = None,
        keywords: str = None,
        node_id: str = None,
        order_by: str = None,
        page_no: int = None,
        page_size: int = None,
        sql_id: str = None,
        start_time: int = None,
    ):
        # Specifies whether to sort the returned entries in ascending order. Default value: **false**. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.asc = asc
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time. You can view the data of up to seven days within the last month.
        self.end_time = end_time
        # The instance ID.
        self.instance_id = instance_id
        # The keywords of the SQL template. Separate multiple keywords with spaces.
        self.keywords = keywords
        # The node ID.
        # 
        # >  This parameter must be specified if the database instance is an ApsaraDB RDS for MySQL Cluster Edition instance or a PolarDB for MySQL cluster.
        self.node_id = node_id
        # The field by which to sort the returned entries. Default value: **count**.
        # 
        # *   **count**: the number of executions.
        # *   **avgRt**: the average execution duration.
        # *   **rtRate**: the execution duration percentage.
        # *   **rowsExamined**: the total number of scanned rows.
        # *   **avgRowsExamined**: the average number of scanned rows.
        # *   **avgRowsReturned**: the average number of returned rows.
        self.order_by = order_by
        # The page number. Pages start from page 1. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. Default value: 10. Valid values: 1 to 100.
        self.page_size = page_size
        # The SQL ID.
        # 
        # >  If this parameter is specified, the full request statistics of the specified SQL query are collected. If this parameter is left empty, the full request statistics of the entire database instance are collected.
        self.sql_id = sql_id
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.keywords is not None:
            result['Keywords'] = self.keywords
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Keywords') is not None:
            self.keywords = m.get('Keywords')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetPfsSqlSummariesResponseBodyDataList(TeaModel):
    def __init__(
        self,
        avg_latency: float = None,
        count: int = None,
        count_rate: float = None,
        cpu_rate: float = None,
        cpu_time: float = None,
        data_read_time: float = None,
        data_reads: int = None,
        data_write_time: float = None,
        data_writes: int = None,
        db: str = None,
        elapsed_time: float = None,
        err_count: int = None,
        first_time: int = None,
        full_scan: bool = None,
        id: int = None,
        instance_id: str = None,
        last_time: int = None,
        lock_latency_avg: float = None,
        logic_id: int = None,
        logic_reads: int = None,
        max_latency: float = None,
        mutex_spins: int = None,
        mutex_waits: int = None,
        node_id: str = None,
        physical_async_reads: int = None,
        physical_reads: int = None,
        psql: str = None,
        redo_writes: int = None,
        rows_affected: int = None,
        rows_affected_avg: float = None,
        rows_examined: int = None,
        rows_examined_avg: float = None,
        rows_send_avg: float = None,
        rows_sent: int = None,
        rows_sent_avg: float = None,
        rows_sorted: int = None,
        rt_rate: float = None,
        rwlock_os_waits: int = None,
        rwlock_spin_rounds: int = None,
        rwlock_spin_waits: int = None,
        select_full_join_avg: float = None,
        select_full_range_join_avg: float = None,
        select_range_avg: float = None,
        select_scan_avg: float = None,
        semisync_delay_time: float = None,
        server_lock_time: float = None,
        sort_merge_passes: int = None,
        sort_range_avg: float = None,
        sort_rows_avg: float = None,
        sort_scan_avg: float = None,
        sql_id: str = None,
        sql_type: str = None,
        tables: List[str] = None,
        timer_wait_avg: float = None,
        timestamp: int = None,
        tmp_disk_tables: int = None,
        tmp_disk_tables_avg: float = None,
        tmp_tables: int = None,
        tmp_tables_avg: float = None,
        total_latency: float = None,
        transaction_lock_time: float = None,
        user_id: str = None,
        warn_count: int = None,
    ):
        # The average execution latency. Unit: millisecond.
        self.avg_latency = avg_latency
        # The total number of executions.
        self.count = count
        # The percentage of the number of executions.
        self.count_rate = count_rate
        # The ratio of the CPU execution duration to the total execution duration of the SQL statement.
        self.cpu_rate = cpu_rate
        # The CPU execution duration. Unit: millisecond.
        self.cpu_time = cpu_time
        # The data read duration. Unit: millisecond.
        self.data_read_time = data_read_time
        # The number of nodes from which data can be read.
        self.data_reads = data_reads
        # The data write duration. Unit: millisecond.
        self.data_write_time = data_write_time
        # The number of nodes to which data can be written.
        self.data_writes = data_writes
        # The name of the database.
        self.db = db
        # The execution duration. Unit: millisecond.
        self.elapsed_time = elapsed_time
        # The number of errors.
        self.err_count = err_count
        # The time when the SQL statement was executed for the first time. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.first_time = first_time
        # Indicates whether full table scan was enabled. Valid values:
        # 
        # * **true**\
        # * **false**\
        self.full_scan = full_scan
        # The primary key ID.
        self.id = id
        # The instance ID.
        self.instance_id = instance_id
        # The time when the SQL statement was last modified. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.last_time = last_time
        # The average lock wait latency. Unit: millisecond.
        self.lock_latency_avg = lock_latency_avg
        # The logical database ID.
        self.logic_id = logic_id
        # The number of logical nodes.
        self.logic_reads = logic_reads
        # The maximum execution latency. Unit: millisecond.
        self.max_latency = max_latency
        # The number of mutex spins.
        self.mutex_spins = mutex_spins
        # The number of mutex waits.
        self.mutex_waits = mutex_waits
        # The node ID.
        # 
        # > This parameter is returned only if the database instance is an ApsaraDB RDS for MySQL Cluster Edition instance or a PolarDB for MySQL cluster.
        self.node_id = node_id
        # The number of physical asynchronous nodes.
        self.physical_async_reads = physical_async_reads
        # The number of physical nodes.
        self.physical_reads = physical_reads
        # The SQL template.
        self.psql = psql
        # The number of redo nodes.
        self.redo_writes = redo_writes
        # The number of rows that are affected by the SQL statement.
        self.rows_affected = rows_affected
        # The average number of rows affected by the SQL statement.
        self.rows_affected_avg = rows_affected_avg
        # The total number of scanned rows.
        self.rows_examined = rows_examined
        # The average number of scanned rows.
        self.rows_examined_avg = rows_examined_avg
        # The average number of returned rows.
        self.rows_send_avg = rows_send_avg
        # The number of rows returned by the SQL statement.
        self.rows_sent = rows_sent
        # The average number of rows returned for the SQL statement.
        self.rows_sent_avg = rows_sent_avg
        # The number of sorted rows.
        self.rows_sorted = rows_sorted
        # The execution duration percentage.
        self.rt_rate = rt_rate
        # Indicates whether read/write splitting was enabled. Valid values:
        # 
        # * **0:** Read/write splitting was disabled.
        # * **1:** Read/write splitting was enabled.
        self.rwlock_os_waits = rwlock_os_waits
        # The read/write splitting parameters.
        self.rwlock_spin_rounds = rwlock_spin_rounds
        # Indices whether multi-index scanning was enabled. Valid values:
        # 
        # * **0:** Multi-index scanning was disabled.
        # * **1:** Multi-index scanning was enabled.
        self.rwlock_spin_waits = rwlock_spin_waits
        # The average number of joins that performed table scans without using indexes.
        # 
        # > If the value of this parameter is not 0, check the table indexes.
        self.select_full_join_avg = select_full_join_avg
        # The average number of joins that selected a range.
        self.select_full_range_join_avg = select_full_range_join_avg
        # The average selected range.
        self.select_range_avg = select_range_avg
        # The average number of scanned rows.
        self.select_scan_avg = select_scan_avg
        # The semi-synchronous replication latency. Unit: millisecond.
        self.semisync_delay_time = semisync_delay_time
        # The amount of time consumed for locking the server. Unit: millisecond.
        self.server_lock_time = server_lock_time
        # The number of merges that the sorting algorithm must perform.
        self.sort_merge_passes = sort_merge_passes
        # The average number of sorts that were performed by using a range.
        self.sort_range_avg = sort_range_avg
        # The average number of sorted rows.
        self.sort_rows_avg = sort_rows_avg
        # The average number of sorts that were performed during table scans.
        self.sort_scan_avg = sort_scan_avg
        # The SQL template ID.
        self.sql_id = sql_id
        # The type of the SQL statement. Valid values:
        # 
        # * **SELECT**\
        # * **UPDATE**\
        # * **DELETE**\
        self.sql_type = sql_type
        # The names of tables in the database.
        self.tables = tables
        # The reserved parameter.
        self.timer_wait_avg = timer_wait_avg
        # The data timestamp. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp
        # The number of on-disk temporary tables.
        self.tmp_disk_tables = tmp_disk_tables
        # The average number of on-disk temporary tables.
        self.tmp_disk_tables_avg = tmp_disk_tables_avg
        # The number of temporary tables.
        self.tmp_tables = tmp_tables
        # The average number of temporary tables.
        self.tmp_tables_avg = tmp_tables_avg
        # The execution latency. Unit: millisecond.
        self.total_latency = total_latency
        # The amount of time consumed for locking the storage transaction. Unit: millisecond.
        self.transaction_lock_time = transaction_lock_time
        # The user ID.
        self.user_id = user_id
        # The number of warnings.
        self.warn_count = warn_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_latency is not None:
            result['AvgLatency'] = self.avg_latency
        if self.count is not None:
            result['Count'] = self.count
        if self.count_rate is not None:
            result['CountRate'] = self.count_rate
        if self.cpu_rate is not None:
            result['CpuRate'] = self.cpu_rate
        if self.cpu_time is not None:
            result['CpuTime'] = self.cpu_time
        if self.data_read_time is not None:
            result['DataReadTime'] = self.data_read_time
        if self.data_reads is not None:
            result['DataReads'] = self.data_reads
        if self.data_write_time is not None:
            result['DataWriteTime'] = self.data_write_time
        if self.data_writes is not None:
            result['DataWrites'] = self.data_writes
        if self.db is not None:
            result['Db'] = self.db
        if self.elapsed_time is not None:
            result['ElapsedTime'] = self.elapsed_time
        if self.err_count is not None:
            result['ErrCount'] = self.err_count
        if self.first_time is not None:
            result['FirstTime'] = self.first_time
        if self.full_scan is not None:
            result['FullScan'] = self.full_scan
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.lock_latency_avg is not None:
            result['LockLatencyAvg'] = self.lock_latency_avg
        if self.logic_id is not None:
            result['LogicId'] = self.logic_id
        if self.logic_reads is not None:
            result['LogicReads'] = self.logic_reads
        if self.max_latency is not None:
            result['MaxLatency'] = self.max_latency
        if self.mutex_spins is not None:
            result['MutexSpins'] = self.mutex_spins
        if self.mutex_waits is not None:
            result['MutexWaits'] = self.mutex_waits
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.physical_async_reads is not None:
            result['PhysicalAsyncReads'] = self.physical_async_reads
        if self.physical_reads is not None:
            result['PhysicalReads'] = self.physical_reads
        if self.psql is not None:
            result['Psql'] = self.psql
        if self.redo_writes is not None:
            result['RedoWrites'] = self.redo_writes
        if self.rows_affected is not None:
            result['RowsAffected'] = self.rows_affected
        if self.rows_affected_avg is not None:
            result['RowsAffectedAvg'] = self.rows_affected_avg
        if self.rows_examined is not None:
            result['RowsExamined'] = self.rows_examined
        if self.rows_examined_avg is not None:
            result['RowsExaminedAvg'] = self.rows_examined_avg
        if self.rows_send_avg is not None:
            result['RowsSendAvg'] = self.rows_send_avg
        if self.rows_sent is not None:
            result['RowsSent'] = self.rows_sent
        if self.rows_sent_avg is not None:
            result['RowsSentAvg'] = self.rows_sent_avg
        if self.rows_sorted is not None:
            result['RowsSorted'] = self.rows_sorted
        if self.rt_rate is not None:
            result['RtRate'] = self.rt_rate
        if self.rwlock_os_waits is not None:
            result['RwlockOsWaits'] = self.rwlock_os_waits
        if self.rwlock_spin_rounds is not None:
            result['RwlockSpinRounds'] = self.rwlock_spin_rounds
        if self.rwlock_spin_waits is not None:
            result['RwlockSpinWaits'] = self.rwlock_spin_waits
        if self.select_full_join_avg is not None:
            result['SelectFullJoinAvg'] = self.select_full_join_avg
        if self.select_full_range_join_avg is not None:
            result['SelectFullRangeJoinAvg'] = self.select_full_range_join_avg
        if self.select_range_avg is not None:
            result['SelectRangeAvg'] = self.select_range_avg
        if self.select_scan_avg is not None:
            result['SelectScanAvg'] = self.select_scan_avg
        if self.semisync_delay_time is not None:
            result['SemisyncDelayTime'] = self.semisync_delay_time
        if self.server_lock_time is not None:
            result['ServerLockTime'] = self.server_lock_time
        if self.sort_merge_passes is not None:
            result['SortMergePasses'] = self.sort_merge_passes
        if self.sort_range_avg is not None:
            result['SortRangeAvg'] = self.sort_range_avg
        if self.sort_rows_avg is not None:
            result['SortRowsAvg'] = self.sort_rows_avg
        if self.sort_scan_avg is not None:
            result['SortScanAvg'] = self.sort_scan_avg
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.tables is not None:
            result['Tables'] = self.tables
        if self.timer_wait_avg is not None:
            result['TimerWaitAvg'] = self.timer_wait_avg
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.tmp_disk_tables is not None:
            result['TmpDiskTables'] = self.tmp_disk_tables
        if self.tmp_disk_tables_avg is not None:
            result['TmpDiskTablesAvg'] = self.tmp_disk_tables_avg
        if self.tmp_tables is not None:
            result['TmpTables'] = self.tmp_tables
        if self.tmp_tables_avg is not None:
            result['TmpTablesAvg'] = self.tmp_tables_avg
        if self.total_latency is not None:
            result['TotalLatency'] = self.total_latency
        if self.transaction_lock_time is not None:
            result['TransactionLockTime'] = self.transaction_lock_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.warn_count is not None:
            result['WarnCount'] = self.warn_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgLatency') is not None:
            self.avg_latency = m.get('AvgLatency')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CountRate') is not None:
            self.count_rate = m.get('CountRate')
        if m.get('CpuRate') is not None:
            self.cpu_rate = m.get('CpuRate')
        if m.get('CpuTime') is not None:
            self.cpu_time = m.get('CpuTime')
        if m.get('DataReadTime') is not None:
            self.data_read_time = m.get('DataReadTime')
        if m.get('DataReads') is not None:
            self.data_reads = m.get('DataReads')
        if m.get('DataWriteTime') is not None:
            self.data_write_time = m.get('DataWriteTime')
        if m.get('DataWrites') is not None:
            self.data_writes = m.get('DataWrites')
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('ElapsedTime') is not None:
            self.elapsed_time = m.get('ElapsedTime')
        if m.get('ErrCount') is not None:
            self.err_count = m.get('ErrCount')
        if m.get('FirstTime') is not None:
            self.first_time = m.get('FirstTime')
        if m.get('FullScan') is not None:
            self.full_scan = m.get('FullScan')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('LockLatencyAvg') is not None:
            self.lock_latency_avg = m.get('LockLatencyAvg')
        if m.get('LogicId') is not None:
            self.logic_id = m.get('LogicId')
        if m.get('LogicReads') is not None:
            self.logic_reads = m.get('LogicReads')
        if m.get('MaxLatency') is not None:
            self.max_latency = m.get('MaxLatency')
        if m.get('MutexSpins') is not None:
            self.mutex_spins = m.get('MutexSpins')
        if m.get('MutexWaits') is not None:
            self.mutex_waits = m.get('MutexWaits')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('PhysicalAsyncReads') is not None:
            self.physical_async_reads = m.get('PhysicalAsyncReads')
        if m.get('PhysicalReads') is not None:
            self.physical_reads = m.get('PhysicalReads')
        if m.get('Psql') is not None:
            self.psql = m.get('Psql')
        if m.get('RedoWrites') is not None:
            self.redo_writes = m.get('RedoWrites')
        if m.get('RowsAffected') is not None:
            self.rows_affected = m.get('RowsAffected')
        if m.get('RowsAffectedAvg') is not None:
            self.rows_affected_avg = m.get('RowsAffectedAvg')
        if m.get('RowsExamined') is not None:
            self.rows_examined = m.get('RowsExamined')
        if m.get('RowsExaminedAvg') is not None:
            self.rows_examined_avg = m.get('RowsExaminedAvg')
        if m.get('RowsSendAvg') is not None:
            self.rows_send_avg = m.get('RowsSendAvg')
        if m.get('RowsSent') is not None:
            self.rows_sent = m.get('RowsSent')
        if m.get('RowsSentAvg') is not None:
            self.rows_sent_avg = m.get('RowsSentAvg')
        if m.get('RowsSorted') is not None:
            self.rows_sorted = m.get('RowsSorted')
        if m.get('RtRate') is not None:
            self.rt_rate = m.get('RtRate')
        if m.get('RwlockOsWaits') is not None:
            self.rwlock_os_waits = m.get('RwlockOsWaits')
        if m.get('RwlockSpinRounds') is not None:
            self.rwlock_spin_rounds = m.get('RwlockSpinRounds')
        if m.get('RwlockSpinWaits') is not None:
            self.rwlock_spin_waits = m.get('RwlockSpinWaits')
        if m.get('SelectFullJoinAvg') is not None:
            self.select_full_join_avg = m.get('SelectFullJoinAvg')
        if m.get('SelectFullRangeJoinAvg') is not None:
            self.select_full_range_join_avg = m.get('SelectFullRangeJoinAvg')
        if m.get('SelectRangeAvg') is not None:
            self.select_range_avg = m.get('SelectRangeAvg')
        if m.get('SelectScanAvg') is not None:
            self.select_scan_avg = m.get('SelectScanAvg')
        if m.get('SemisyncDelayTime') is not None:
            self.semisync_delay_time = m.get('SemisyncDelayTime')
        if m.get('ServerLockTime') is not None:
            self.server_lock_time = m.get('ServerLockTime')
        if m.get('SortMergePasses') is not None:
            self.sort_merge_passes = m.get('SortMergePasses')
        if m.get('SortRangeAvg') is not None:
            self.sort_range_avg = m.get('SortRangeAvg')
        if m.get('SortRowsAvg') is not None:
            self.sort_rows_avg = m.get('SortRowsAvg')
        if m.get('SortScanAvg') is not None:
            self.sort_scan_avg = m.get('SortScanAvg')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('Tables') is not None:
            self.tables = m.get('Tables')
        if m.get('TimerWaitAvg') is not None:
            self.timer_wait_avg = m.get('TimerWaitAvg')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('TmpDiskTables') is not None:
            self.tmp_disk_tables = m.get('TmpDiskTables')
        if m.get('TmpDiskTablesAvg') is not None:
            self.tmp_disk_tables_avg = m.get('TmpDiskTablesAvg')
        if m.get('TmpTables') is not None:
            self.tmp_tables = m.get('TmpTables')
        if m.get('TmpTablesAvg') is not None:
            self.tmp_tables_avg = m.get('TmpTablesAvg')
        if m.get('TotalLatency') is not None:
            self.total_latency = m.get('TotalLatency')
        if m.get('TransactionLockTime') is not None:
            self.transaction_lock_time = m.get('TransactionLockTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('WarnCount') is not None:
            self.warn_count = m.get('WarnCount')
        return self


class GetPfsSqlSummariesResponseBodyData(TeaModel):
    def __init__(
        self,
        extra: Any = None,
        list: List[GetPfsSqlSummariesResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The reserved parameter.
        self.extra = extra
        # The detailed information.
        self.list = list
        # The page number.
        self.page_no = page_no
        # The number of entries per page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra is not None:
            result['Extra'] = self.extra
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetPfsSqlSummariesResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetPfsSqlSummariesResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetPfsSqlSummariesResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetPfsSqlSummariesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetPfsSqlSummariesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPfsSqlSummariesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPfsSqlSummariesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueryOptimizeDataStatsRequest(TeaModel):
    def __init__(
        self,
        asc: str = None,
        db_names: str = None,
        engine: str = None,
        instance_ids: str = None,
        keywords: str = None,
        logical_operator: str = None,
        only_optimized_sql: str = None,
        order_by: str = None,
        page_no: str = None,
        page_size: str = None,
        region: str = None,
        rules: str = None,
        sql_ids: str = None,
        tag_names: str = None,
        time: str = None,
        user: str = None,
    ):
        # Specifies whether to sort the returned entries in ascending order. Default value: **true**. Valid values:
        # 
        # *   **true**: sorts the returned entries in ascending order.
        # *   **false**: does not sort the returned entries in ascending order.
        self.asc = asc
        # The name of the database to be queried.
        self.db_names = db_names
        # The database engine. Valid values:
        # 
        # *   **MySQL**\
        # *   **PolarDBMySQL**\
        # *   **PostgreSQL**\
        self.engine = engine
        # The instance IDs. Separate multiple IDs with commas (,).
        self.instance_ids = instance_ids
        # The keywords of the SQL template. Separate multiple keywords with spaces.
        self.keywords = keywords
        # The logical relationship between multiple keywords. Valid values:
        # 
        # *   **or**\
        # *   **and**\
        self.logical_operator = logical_operator
        # Specifies whether to query only SQL templates that need to be optimized. Default value: **false**. Valid values:
        # 
        # *   **true**: queries only SQL templates that need to be optimized.
        # *   **false**: does not query only SQL statements that need to be optimized.
        self.only_optimized_sql = only_optimized_sql
        # The field by which to sort the returned entries. Default value: **count**. Valid values:
        # 
        # *   **count**: the number of executions.
        # *   **maxQueryTime**: the longest execution time.
        # *   **avgQueryTime**: the average execution time.
        # *   **maxLockTime**: the longest lock wait time.
        # *   **avgLockTime**: the longest lock wait time.
        # *   **maxRowsExamined**: the largest number of scanned rows.
        # *   **avgRowsExamined**: the average number of scanned rows.
        # *   **maxRowsSent**: the largest number of returned rows.
        # *   **avgRowsSent**: the average number of returned rows.
        self.order_by = order_by
        # The page number. Pages start from page 1. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        # The region in which the instance resides. Valid values:
        # 
        # *   **cn-china**: Chinese mainland
        # *   **cn-hongkong**: China (Hong Kong)
        # *   **ap-southeast-1**: Singapore
        # 
        # This parameter takes effect only if **InstanceIds** is left empty. If you leave **InstanceIds** empty, the system obtains data from the region set by **Region**. By default, Region is set to **cn-china**. If you specify **InstanceIds**, **Region** does not take effect and the system obtains data from the region in which the first specified instance resides.****\
        # 
        # >  Set this parameter to **cn-china** for the instances that are created in the regions in the Chinese mainland.
        self.region = region
        # The tags that are used to filter SQL templates. Separate multiple tags with commas (,). For more information, see [Query governance](~~290038~~).
        self.rules = rules
        # The SQL template ID. You can query the ID of a template by calling the [GetQueryOptimizeExecErrorStats](~~405235~~) operation.
        self.sql_ids = sql_ids
        # The reserved parameter.
        self.tag_names = tag_names
        # The time range to query. Specify the time in the UNIX timestamp format. Unit: milliseconds.
        self.time = time
        # The account of the database to be queried.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.db_names is not None:
            result['DbNames'] = self.db_names
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.keywords is not None:
            result['Keywords'] = self.keywords
        if self.logical_operator is not None:
            result['LogicalOperator'] = self.logical_operator
        if self.only_optimized_sql is not None:
            result['OnlyOptimizedSql'] = self.only_optimized_sql
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region is not None:
            result['Region'] = self.region
        if self.rules is not None:
            result['Rules'] = self.rules
        if self.sql_ids is not None:
            result['SqlIds'] = self.sql_ids
        if self.tag_names is not None:
            result['TagNames'] = self.tag_names
        if self.time is not None:
            result['Time'] = self.time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('DbNames') is not None:
            self.db_names = m.get('DbNames')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Keywords') is not None:
            self.keywords = m.get('Keywords')
        if m.get('LogicalOperator') is not None:
            self.logical_operator = m.get('LogicalOperator')
        if m.get('OnlyOptimizedSql') is not None:
            self.only_optimized_sql = m.get('OnlyOptimizedSql')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Rules') is not None:
            self.rules = m.get('Rules')
        if m.get('SqlIds') is not None:
            self.sql_ids = m.get('SqlIds')
        if m.get('TagNames') is not None:
            self.tag_names = m.get('TagNames')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class GetQueryOptimizeDataStatsResponseBodyDataListRuleList(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
    ):
        # The rule name.
        self.name = name
        # The type of the rule. Valid values:
        # 
        # * **Predefined**\
        # * **UserDefined**\
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetQueryOptimizeDataStatsResponseBodyDataList(TeaModel):
    def __init__(
        self,
        avg_lock_time: float = None,
        avg_query_time: float = None,
        avg_rows_affected: float = None,
        avg_rows_examined: float = None,
        avg_rows_sent: float = None,
        count: int = None,
        dbname: str = None,
        instance_id: str = None,
        max_lock_time: float = None,
        max_query_time: float = None,
        max_rows_affected: int = None,
        max_rows_examined: int = None,
        max_rows_sent: int = None,
        psql: str = None,
        rule_list: List[GetQueryOptimizeDataStatsResponseBodyDataListRuleList] = None,
        sql_id: str = None,
        sql_sample: str = None,
        sql_type: str = None,
        user: str = None,
    ):
        # The average lock wait time. Unit: seconds.
        self.avg_lock_time = avg_lock_time
        # The average query execution time. Unit: seconds.
        self.avg_query_time = avg_query_time
        # The average number of rows affected by the SQL statement.
        # 
        # > A value of -1 indicates that this parameter is not collected.
        self.avg_rows_affected = avg_rows_affected
        # The average number of scanned rows.
        self.avg_rows_examined = avg_rows_examined
        # The average number of returned rows.
        self.avg_rows_sent = avg_rows_sent
        # The number of times that the SQL template is executed.
        self.count = count
        # The name of the database to which the SQL template belongs.
        self.dbname = dbname
        # The instance ID.
        self.instance_id = instance_id
        # The longest lock wait time. Unit: seconds.
        self.max_lock_time = max_lock_time
        # The longest query execution time. Unit: seconds.
        self.max_query_time = max_query_time
        # The largest number of rows affected by the SQL template.
        # 
        # > A value of -1 indicates that this parameter is not collected.
        self.max_rows_affected = max_rows_affected
        # The largest number of scanned rows.
        self.max_rows_examined = max_rows_examined
        # The largest number of returned rows.
        self.max_rows_sent = max_rows_sent
        # The SQL template.
        self.psql = psql
        # The information about the rules.
        self.rule_list = rule_list
        # The SQL template ID.
        self.sql_id = sql_id
        # The sample query that took the longest time to execute.
        self.sql_sample = sql_sample
        # The type of the SQL statement.
        self.sql_type = sql_type
        # The account of the database.
        self.user = user

    def validate(self):
        if self.rule_list:
            for k in self.rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_lock_time is not None:
            result['AvgLockTime'] = self.avg_lock_time
        if self.avg_query_time is not None:
            result['AvgQueryTime'] = self.avg_query_time
        if self.avg_rows_affected is not None:
            result['AvgRowsAffected'] = self.avg_rows_affected
        if self.avg_rows_examined is not None:
            result['AvgRowsExamined'] = self.avg_rows_examined
        if self.avg_rows_sent is not None:
            result['AvgRowsSent'] = self.avg_rows_sent
        if self.count is not None:
            result['Count'] = self.count
        if self.dbname is not None:
            result['Dbname'] = self.dbname
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.max_lock_time is not None:
            result['MaxLockTime'] = self.max_lock_time
        if self.max_query_time is not None:
            result['MaxQueryTime'] = self.max_query_time
        if self.max_rows_affected is not None:
            result['MaxRowsAffected'] = self.max_rows_affected
        if self.max_rows_examined is not None:
            result['MaxRowsExamined'] = self.max_rows_examined
        if self.max_rows_sent is not None:
            result['MaxRowsSent'] = self.max_rows_sent
        if self.psql is not None:
            result['Psql'] = self.psql
        result['RuleList'] = []
        if self.rule_list is not None:
            for k in self.rule_list:
                result['RuleList'].append(k.to_map() if k else None)
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_sample is not None:
            result['SqlSample'] = self.sql_sample
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgLockTime') is not None:
            self.avg_lock_time = m.get('AvgLockTime')
        if m.get('AvgQueryTime') is not None:
            self.avg_query_time = m.get('AvgQueryTime')
        if m.get('AvgRowsAffected') is not None:
            self.avg_rows_affected = m.get('AvgRowsAffected')
        if m.get('AvgRowsExamined') is not None:
            self.avg_rows_examined = m.get('AvgRowsExamined')
        if m.get('AvgRowsSent') is not None:
            self.avg_rows_sent = m.get('AvgRowsSent')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Dbname') is not None:
            self.dbname = m.get('Dbname')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MaxLockTime') is not None:
            self.max_lock_time = m.get('MaxLockTime')
        if m.get('MaxQueryTime') is not None:
            self.max_query_time = m.get('MaxQueryTime')
        if m.get('MaxRowsAffected') is not None:
            self.max_rows_affected = m.get('MaxRowsAffected')
        if m.get('MaxRowsExamined') is not None:
            self.max_rows_examined = m.get('MaxRowsExamined')
        if m.get('MaxRowsSent') is not None:
            self.max_rows_sent = m.get('MaxRowsSent')
        if m.get('Psql') is not None:
            self.psql = m.get('Psql')
        self.rule_list = []
        if m.get('RuleList') is not None:
            for k in m.get('RuleList'):
                temp_model = GetQueryOptimizeDataStatsResponseBodyDataListRuleList()
                self.rule_list.append(temp_model.from_map(k))
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlSample') is not None:
            self.sql_sample = m.get('SqlSample')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class GetQueryOptimizeDataStatsResponseBodyData(TeaModel):
    def __init__(
        self,
        extra: str = None,
        list: List[GetQueryOptimizeDataStatsResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The reserved parameter.
        self.extra = extra
        # The information about the SQL templates.
        self.list = list
        # The reserved parameter.
        self.page_no = page_no
        # The reserved parameter.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra is not None:
            result['Extra'] = self.extra
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetQueryOptimizeDataStatsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetQueryOptimizeDataStatsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetQueryOptimizeDataStatsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQueryOptimizeDataStatsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQueryOptimizeDataStatsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQueryOptimizeDataStatsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQueryOptimizeDataStatsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueryOptimizeDataTopRequest(TeaModel):
    def __init__(
        self,
        engine: str = None,
        instance_ids: str = None,
        region: str = None,
        tag_names: str = None,
        time: str = None,
        type: str = None,
    ):
        # The database engine. Valid values:
        # 
        # *   **MySQL**\
        # *   **PolarDBMySQL**\
        # *   **PostgreSQL**\
        self.engine = engine
        # The instance IDs. Separate multiple IDs with commas (,).
        self.instance_ids = instance_ids
        # The region in which the instance resides. Valid values:
        # 
        # *   **cn-china**: Chinese mainland
        # *   **cn-hongkong**: China (Hong Kong)
        # *   **ap-southeast-1**: Singapore
        # 
        # This parameter takes effect only if **InstanceIds** is left empty. If you leave **InstanceIds** empty, the system obtains data from the region set by **Region**. By default, Region is set to **cn-china**. If you specify **InstanceIds**, **Region** does not take effect and the system obtains data from the region in which the first specified instance resides.****\
        # 
        # >  Set this parameter to **cn-china** for all your instances that reside in the regions in the Chinese mainland.
        self.region = region
        # The reserved parameter.
        self.tag_names = tag_names
        # The time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.time = time
        # The type of instances that you want to query. Valid values:
        # 
        # *   **RED**: the best-performing instances
        # *   **BLACK**: the worst-performing instances
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.region is not None:
            result['Region'] = self.region
        if self.tag_names is not None:
            result['TagNames'] = self.tag_names
        if self.time is not None:
            result['Time'] = self.time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('TagNames') is not None:
            self.tag_names = m.get('TagNames')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetQueryOptimizeDataTopResponseBodyDataList(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        type: str = None,
        value: float = None,
    ):
        # The instance ID.
        self.instance_id = instance_id
        # The metric name. Valid values:
        # 
        # * **sqlExecuteCount**: the number of slow SQL executions.
        # * **optimizedSqlExecuteCount**: the number of slow SQL executions that need to be optimized.
        self.type = type
        # The metric value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetQueryOptimizeDataTopResponseBodyData(TeaModel):
    def __init__(
        self,
        extra: str = None,
        list: List[GetQueryOptimizeDataTopResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The reserved parameter.
        self.extra = extra
        # The information about the instances.
        self.list = list
        # The reserved parameter.
        self.page_no = page_no
        # The reserved parameter.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra is not None:
            result['Extra'] = self.extra
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetQueryOptimizeDataTopResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetQueryOptimizeDataTopResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetQueryOptimizeDataTopResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQueryOptimizeDataTopResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQueryOptimizeDataTopResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQueryOptimizeDataTopResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQueryOptimizeDataTopResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueryOptimizeDataTrendRequest(TeaModel):
    def __init__(
        self,
        end: str = None,
        engine: str = None,
        instance_ids: str = None,
        region: str = None,
        start: str = None,
        tag_names: str = None,
    ):
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The end time must be later than the start time, but not later than 00:00:00 (UTC+8) on the current day.
        self.end = end
        # The database engine. Valid values:
        # 
        # *   **MySQL**\
        # *   **PolarDBMySQL**\
        # *   **PostgreSQL**\
        self.engine = engine
        # The instance IDs. Separate multiple IDs with commas (,).
        self.instance_ids = instance_ids
        # The region in which the instance resides. Valid values:
        # 
        # *   **cn-china**: Chinese mainland.
        # *   **cn-hongkong**: China (Hong Kong).
        # *   **ap-southeast-1**: Singapore.
        # 
        # This parameter takes effect only if **InstanceIds** is left empty. If you leave **InstanceIds** empty, the system obtains data from the region specified by **Region**. By default, Region is set to **cn-china**. If you specify **InstanceIds**, **Region** does not take effect and the system obtains data from the region in which the first specified instance resides.****\
        # 
        # >  If your instances reside in the regions inside the Chinese mainland, set this parameter to **cn-china**.
        self.region = region
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  You can specify a start time up to two months earlier than the current time.
        self.start = start
        # The reserved parameter.
        self.tag_names = tag_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.region is not None:
            result['Region'] = self.region
        if self.start is not None:
            result['Start'] = self.start
        if self.tag_names is not None:
            result['TagNames'] = self.tag_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('TagNames') is not None:
            self.tag_names = m.get('TagNames')
        return self


class GetQueryOptimizeDataTrendResponseBodyDataList(TeaModel):
    def __init__(
        self,
        kpi: str = None,
        timestamp: int = None,
        value: float = None,
    ):
        # The name of the metric. Valid values:
        # 
        # * **sqlExecuteCount**: the number of executions of slow SQL queries.
        # * **sqlExecuteCountDiff**: the difference in the number of executions of slow SQL queries compared to the previous day.
        # * **sqlCount**: the number of slow SQL templates.
        # * **sqlCountDiff**: the difference in the number of slow SQL templates compared to the previous day.
        # * **optimizedSqlExecuteCount**: the number of optimizable executions of slow SQL queries.
        # * **optimizedSqlExecuteCountDiff**: the difference in the number of optimizable executions of slow SQL queries compared to the previous day.
        # * **optimizedSqlCount**: the number of optimizable slow SQL templates.
        # * **optimizedSqlCountDiff**: the difference in the number of optimizable slow SQL templates compared to the previous day.
        self.kpi = kpi
        # The data timestamp. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp
        # The value of the metric.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.kpi is not None:
            result['Kpi'] = self.kpi
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Kpi') is not None:
            self.kpi = m.get('Kpi')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetQueryOptimizeDataTrendResponseBodyData(TeaModel):
    def __init__(
        self,
        extra: str = None,
        list: List[GetQueryOptimizeDataTrendResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The reserved parameter.
        self.extra = extra
        # The details of the trend data.
        self.list = list
        # The reserved parameter.
        self.page_no = page_no
        # The reserved parameter.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra is not None:
            result['Extra'] = self.extra
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetQueryOptimizeDataTrendResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetQueryOptimizeDataTrendResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetQueryOptimizeDataTrendResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQueryOptimizeDataTrendResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQueryOptimizeDataTrendResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQueryOptimizeDataTrendResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQueryOptimizeDataTrendResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueryOptimizeExecErrorSampleRequest(TeaModel):
    def __init__(
        self,
        engine: str = None,
        instance_id: str = None,
        sql_id: str = None,
        time: str = None,
    ):
        # The database engine. Valid values:
        # 
        # *   **MySQL**\
        # *   **PolarDBMySQL**\
        # *   **PostgreSQL**\
        self.engine = engine
        # The instance ID.
        self.instance_id = instance_id
        # The SQL template ID. You can call the [GetQueryOptimizeExecErrorStats](~~405235~~) operation to obtain the SQL template ID.
        self.sql_id = sql_id
        # The date to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class GetQueryOptimizeExecErrorSampleResponseBodyDataList(TeaModel):
    def __init__(
        self,
        dbname: str = None,
        error_code: str = None,
        orig_host: str = None,
        sql_id: str = None,
        sql_text: str = None,
        timestamp: int = None,
        user: str = None,
    ):
        # The name of the database.
        self.dbname = dbname
        # The error code returned.
        self.error_code = error_code
        # The IP address of the client that executes the SQL statement.
        self.orig_host = orig_host
        # The SQL template ID.
        self.sql_id = sql_id
        # The content of the SQL statement that failed to be executed.
        self.sql_text = sql_text
        # The point in time when the failed SQL statement was executed. The value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp
        # The username of the client that executes the SQL statement.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbname is not None:
            result['Dbname'] = self.dbname
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.orig_host is not None:
            result['OrigHost'] = self.orig_host
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dbname') is not None:
            self.dbname = m.get('Dbname')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('OrigHost') is not None:
            self.orig_host = m.get('OrigHost')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class GetQueryOptimizeExecErrorSampleResponseBodyData(TeaModel):
    def __init__(
        self,
        extra: str = None,
        list: List[GetQueryOptimizeExecErrorSampleResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # A reserved parameter.
        self.extra = extra
        # The queried data.
        self.list = list
        # A reserved parameter.
        self.page_no = page_no
        # A reserved parameter.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra is not None:
            result['Extra'] = self.extra
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetQueryOptimizeExecErrorSampleResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetQueryOptimizeExecErrorSampleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetQueryOptimizeExecErrorSampleResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQueryOptimizeExecErrorSampleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQueryOptimizeExecErrorSampleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQueryOptimizeExecErrorSampleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQueryOptimizeExecErrorSampleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueryOptimizeExecErrorStatsRequest(TeaModel):
    def __init__(
        self,
        asc: str = None,
        db_names: str = None,
        engine: str = None,
        instance_ids: str = None,
        keywords: str = None,
        logical_operator: str = None,
        order_by: str = None,
        page_no: str = None,
        page_size: str = None,
        region: str = None,
        time: str = None,
    ):
        # Specifies whether to sort the returned entries in ascending order. Default value: **true**. Valid values:
        # 
        # *   **true**: sorts the returned entries in ascending order.
        # *   **false**: does not sort the returned entries in ascending order.
        self.asc = asc
        # The name of the database to be queried.
        self.db_names = db_names
        # The database engine. Valid values:
        # 
        # *   **MySQL**\
        # *   **PolarDBMySQL**\
        # *   **PostgreSQL**\
        self.engine = engine
        # The instance IDs. Separate multiple IDs with commas (,).
        self.instance_ids = instance_ids
        # The keywords of the SQL template. Separate multiple keywords with spaces.
        self.keywords = keywords
        # The logical relationship between multiple keywords. Valid values:
        # 
        # *   **or**\
        # *   **and**\
        self.logical_operator = logical_operator
        # The field by which to sort the returned entries. Only error_count is supported, which specifies that the entries are sorted based on the number of failed executions.
        self.order_by = order_by
        # The page number. Pages start from page 1. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        # The region in which the instance resides. Valid values:
        # 
        # *   **cn-china**: Chinese mainland
        # *   **cn-hongkong**: China (Hong Kong)
        # *   **ap-southeast-1**: Singapore
        # 
        # This parameter takes effect only if **InstanceIds** is left empty. If you leave **InstanceIds** empty, the system obtains data from the region set by **Region**. By default, Region is set to **cn-china**. If you specify **InstanceIds**, **Region** does not take effect and the system obtains data from the region in which the first specified instance resides.****\
        # 
        # >  Set this parameter to **cn-china** for the instances that are created in the regions in the Chinese mainland.
        self.region = region
        # The time range to query. Specify the time in the UNIX timestamp format. Unit: milliseconds.
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.db_names is not None:
            result['DbNames'] = self.db_names
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.keywords is not None:
            result['Keywords'] = self.keywords
        if self.logical_operator is not None:
            result['LogicalOperator'] = self.logical_operator
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region is not None:
            result['Region'] = self.region
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('DbNames') is not None:
            self.db_names = m.get('DbNames')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Keywords') is not None:
            self.keywords = m.get('Keywords')
        if m.get('LogicalOperator') is not None:
            self.logical_operator = m.get('LogicalOperator')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class GetQueryOptimizeExecErrorStatsResponseBodyDataList(TeaModel):
    def __init__(
        self,
        dbname: str = None,
        error_code: str = None,
        error_count: int = None,
        instance_id: str = None,
        instance_name: str = None,
        sql_id: str = None,
        sql_text: str = None,
    ):
        # The name of the database.
        self.dbname = dbname
        # The error code returned if the request failed.
        self.error_code = error_code
        # The number of errors.
        self.error_count = error_count
        # The instance ID.
        self.instance_id = instance_id
        # The alias of the database instance.
        self.instance_name = instance_name
        # The SQL template ID.
        self.sql_id = sql_id
        # The content of the SQL template.
        self.sql_text = sql_text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbname is not None:
            result['Dbname'] = self.dbname
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_count is not None:
            result['ErrorCount'] = self.error_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dbname') is not None:
            self.dbname = m.get('Dbname')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorCount') is not None:
            self.error_count = m.get('ErrorCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        return self


class GetQueryOptimizeExecErrorStatsResponseBodyData(TeaModel):
    def __init__(
        self,
        extra: str = None,
        list: List[GetQueryOptimizeExecErrorStatsResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The reserved parameter.
        self.extra = extra
        # The information about the SQL templates that failed to execute.
        self.list = list
        # The page number.
        self.page_no = page_no
        # The number of entries per page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra is not None:
            result['Extra'] = self.extra
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetQueryOptimizeExecErrorStatsResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetQueryOptimizeExecErrorStatsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetQueryOptimizeExecErrorStatsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information, including the error codes and the number of entries that are returned.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQueryOptimizeExecErrorStatsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQueryOptimizeExecErrorStatsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQueryOptimizeExecErrorStatsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQueryOptimizeExecErrorStatsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueryOptimizeRuleListRequest(TeaModel):
    def __init__(
        self,
        engine: str = None,
        instance_ids: str = None,
        region: str = None,
        tag_names: str = None,
    ):
        # The database engine. Valid values:
        # 
        # *   **MySQL**\
        # *   **PolarDBMySQL**\
        # *   **PostgreSQL**\
        self.engine = engine
        # The instance IDs. Separate multiple IDs with commas (,).
        self.instance_ids = instance_ids
        # The region in which the instance resides. Valid values:
        # 
        # *   **cn-china**: Chinese mainland
        # *   **cn-hongkong**: China (Hong Kong)
        # *   **ap-southeast-1**: Singapore
        # 
        # This parameter takes effect only if **InstanceIds** is left empty. If you leave **InstanceIds** empty, the system obtains data from the region set by **Region**. By default, Region is set to **cn-china**. If you specify **InstanceIds**, **Region** does not take effect and the system obtains data from the region in which the first specified instance resides.****\
        # 
        # >  If your instances reside in the regions in the Chinese mainland, set this parameter to **cn-china**.
        self.region = region
        # A reserved parameter.
        self.tag_names = tag_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.region is not None:
            result['Region'] = self.region
        if self.tag_names is not None:
            result['TagNames'] = self.tag_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('TagNames') is not None:
            self.tag_names = m.get('TagNames')
        return self


class GetQueryOptimizeRuleListResponseBodyDataList(TeaModel):
    def __init__(
        self,
        name: str = None,
        rule_id: str = None,
        type: str = None,
    ):
        # The name of the tag.
        self.name = name
        # A reserved parameter.
        self.rule_id = rule_id
        # The type of the tag. **Predefined** is returned, which indicates that the tag is added by the system.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetQueryOptimizeRuleListResponseBodyData(TeaModel):
    def __init__(
        self,
        extra: str = None,
        list: List[GetQueryOptimizeRuleListResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # A reserved parameter.
        self.extra = extra
        # The information about tags.
        self.list = list
        # A reserved parameter.
        self.page_no = page_no
        # A reserved parameter.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra is not None:
            result['Extra'] = self.extra
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetQueryOptimizeRuleListResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetQueryOptimizeRuleListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetQueryOptimizeRuleListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQueryOptimizeRuleListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQueryOptimizeRuleListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQueryOptimizeRuleListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQueryOptimizeRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueryOptimizeShareUrlRequest(TeaModel):
    def __init__(
        self,
        asc: bool = None,
        db_names: str = None,
        engine: str = None,
        instance_ids: str = None,
        keywords: str = None,
        logical_operator: str = None,
        only_optimized_sql: bool = None,
        order_by: str = None,
        page_no: int = None,
        page_size: int = None,
        region: str = None,
        rules: str = None,
        sql_ids: str = None,
        tag_names: str = None,
        time: int = None,
        user: str = None,
    ):
        # Specifies whether to sort the returned entries in ascending order. Default value: **true**. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.asc = asc
        # The name of the database to be queried.
        self.db_names = db_names
        # The database engine. Valid values:
        # 
        # *   **MySQL**: ApsaraDB RDS for MySQL
        # *   **PolarDBMySQL**: PolarDB for MySQL
        # *   **PostgreSQL**: ApsaraDB RDS for PostgreSQL
        self.engine = engine
        # The instance IDs. Separate multiple IDs with commas (,).
        self.instance_ids = instance_ids
        # The keywords of the SQL template. Separate multiple keywords with spaces.
        self.keywords = keywords
        # The logical relationship between multiple keywords. Valid values:
        # 
        # *   **or**\
        # *   **and**\
        self.logical_operator = logical_operator
        # Specifies whether to query only SQL templates that need to be optimized. Default value: **false**. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.only_optimized_sql = only_optimized_sql
        # The field by which to sort the returned entries. Default value: **count**. Valid values:
        # 
        # *   **count**: the number of executions.
        # *   **maxQueryTime**: the longest execution duration.
        # *   **avgQueryTime**: the average execution duration.
        # *   **maxLockTime**: the longest lock wait duration.
        # *   **avgLockTime**: the average lock wait duration.
        # *   **maxRowsExamined**: the largest number of scanned rows.
        # *   **avgRowsExamined**: the average number of scanned rows.
        # *   **maxRowsSent**: the largest number of returned rows.
        # *   **avgRowsSent**: the average number of returned rows.
        self.order_by = order_by
        # The page number. Pages start from page 1. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        # The region in which the instance resides. Valid values:
        # 
        # *   **cn-china**: Chinese mainland
        # *   **cn-hongkong**: China (Hong Kong)
        # *   **ap-southeast-1**: Singapore
        # 
        # This parameter takes effect only if **InstanceIds** is left empty. If you leave **InstanceIds** empty, the system obtains data from the region set by **Region**. By default, Region is set to **cn-china**. If you specify **InstanceIds**, **Region** does not take effect and the system obtains data from the region in which the first specified instance resides.****\
        # 
        # >  If your instances reside in the regions in the Chinese mainland, set this parameter to **cn-china**.
        self.region = region
        # The tags that are used to filter SQL templates. Separate multiple tags with commas (,). For more information, see [Query governance](~~290038~~).
        self.rules = rules
        # The SQL template IDs. You can call the [GetQueryOptimizeExecErrorStats](~~405261~~) operation to obtain the SQL template IDs.
        self.sql_ids = sql_ids
        # A reserved parameter.
        self.tag_names = tag_names
        # The date to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.time = time
        # The account of the database to be queried.
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.db_names is not None:
            result['DbNames'] = self.db_names
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.keywords is not None:
            result['Keywords'] = self.keywords
        if self.logical_operator is not None:
            result['LogicalOperator'] = self.logical_operator
        if self.only_optimized_sql is not None:
            result['OnlyOptimizedSql'] = self.only_optimized_sql
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region is not None:
            result['Region'] = self.region
        if self.rules is not None:
            result['Rules'] = self.rules
        if self.sql_ids is not None:
            result['SqlIds'] = self.sql_ids
        if self.tag_names is not None:
            result['TagNames'] = self.tag_names
        if self.time is not None:
            result['Time'] = self.time
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('DbNames') is not None:
            self.db_names = m.get('DbNames')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Keywords') is not None:
            self.keywords = m.get('Keywords')
        if m.get('LogicalOperator') is not None:
            self.logical_operator = m.get('LogicalOperator')
        if m.get('OnlyOptimizedSql') is not None:
            self.only_optimized_sql = m.get('OnlyOptimizedSql')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Rules') is not None:
            self.rules = m.get('Rules')
        if m.get('SqlIds') is not None:
            self.sql_ids = m.get('SqlIds')
        if m.get('TagNames') is not None:
            self.tag_names = m.get('TagNames')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class GetQueryOptimizeShareUrlResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The share URL.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message that contains information such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQueryOptimizeShareUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQueryOptimizeShareUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQueryOptimizeShareUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueryOptimizeSolutionRequest(TeaModel):
    def __init__(
        self,
        engine: str = None,
        instance_id: str = None,
        rule_ids: str = None,
        sql_id: str = None,
    ):
        # The database engine. Valid values:
        # 
        # *   **MySQL**\
        # *   **PolarDBMySQL**\
        # *   **PostgreSQL**\
        self.engine = engine
        # The instance ID. You can call the [GetQueryOptimizeDataStats](~~405261~~) operation to query the instance ID.
        self.instance_id = instance_id
        # The tag ID. For more information, see [Query governance](~~290038~~).
        self.rule_ids = rule_ids
        # The SQL template ID. You can call the [GetQueryOptimizeDataStats](~~405261~~) operation to query the SQL template ID.
        self.sql_id = sql_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        return self


class GetQueryOptimizeSolutionResponseBodyDataList(TeaModel):
    def __init__(
        self,
        level: str = None,
        rule_id: str = None,
        solution: str = None,
        solution_ext: str = None,
    ):
        # The severity level. Valid values:
        # 
        # * **INFO**\
        # * **WARN**\
        self.level = level
        # The tag ID.
        self.rule_id = rule_id
        # The suggestion.
        self.solution = solution
        # The reserved parameter.
        self.solution_ext = solution_ext

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.solution_ext is not None:
            result['SolutionExt'] = self.solution_ext
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('SolutionExt') is not None:
            self.solution_ext = m.get('SolutionExt')
        return self


class GetQueryOptimizeSolutionResponseBodyData(TeaModel):
    def __init__(
        self,
        extra: str = None,
        list: List[GetQueryOptimizeSolutionResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # The reserved parameter.
        self.extra = extra
        # The optimization suggestions.
        self.list = list
        # The reserved parameter.
        self.page_no = page_no
        # The reserved parameter.
        self.page_size = page_size
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra is not None:
            result['Extra'] = self.extra
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetQueryOptimizeSolutionResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetQueryOptimizeSolutionResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetQueryOptimizeSolutionResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQueryOptimizeSolutionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQueryOptimizeSolutionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQueryOptimizeSolutionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQueryOptimizeSolutionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueryOptimizeTagRequest(TeaModel):
    def __init__(
        self,
        engine: str = None,
        instance_id: str = None,
        sql_id: str = None,
    ):
        # The database engine. Valid values:
        # 
        # *   **MySQL**: ApsaraDB RDS for MySQL
        # *   **PolarDBMySQL**: PolarDB for MySQL
        # *   **PostgreSQL**: ApsaraDB RDS for PostgreSQL
        self.engine = engine
        # The instance ID.
        self.instance_id = instance_id
        # The SQL template ID. You can call the [GetQueryOptimizeDataStats](~~405261~~) operation to query the SQL template ID.
        self.sql_id = sql_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        return self


class GetQueryOptimizeTagResponseBodyData(TeaModel):
    def __init__(
        self,
        comments: str = None,
        sql_id: str = None,
        tags: str = None,
    ):
        # The remarks.
        self.comments = comments
        # The SQL template ID.
        self.sql_id = sql_id
        # The SQL tags. Multiple tags are separated by commas (,).
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comments is not None:
            result['Comments'] = self.comments
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Comments') is not None:
            self.comments = m.get('Comments')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class GetQueryOptimizeTagResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetQueryOptimizeTagResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The returned SQL tag data.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQueryOptimizeTagResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQueryOptimizeTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQueryOptimizeTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQueryOptimizeTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRedisAllSessionRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        instance_id: str = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The database instance ID.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetRedisAllSessionResponseBodyDataSessions(TeaModel):
    def __init__(
        self,
        addr: str = None,
        age: str = None,
        client: str = None,
        client_desc: str = None,
        cmd: str = None,
        db: int = None,
        events: str = None,
        fd: int = None,
        flags: str = None,
        id: int = None,
        idle: int = None,
        multi: int = None,
        name: str = None,
        node_id: str = None,
        obl: int = None,
        oll: int = None,
        omem: int = None,
        psub: int = None,
        qbuf: int = None,
        qbuf_free: int = None,
        sub: int = None,
    ):
        # The IP address and port number of the client.
        self.addr = addr
        # The connection duration of the session. Unit: seconds.
        self.age = age
        # The IP address of the client.
        self.client = client
        # The alias of the client.
        self.client_desc = client_desc
        # The command that was last run.
        self.cmd = cmd
        # The ID of the database that the client is using.
        self.db = db
        # The file descriptor event. Valid values:
        # 
        # *   **r**: Client sockets are readable in the event loop.
        # *   **w**: Client sockets are writable in the event loop.
        self.events = events
        # The file descriptor that is used by sockets.
        self.fd = fd
        # The client flag. Valid values:
        # 
        # *   **A**: The connection needs to be closed at the earliest opportunity.
        # *   **b**: The client is waiting for blocked events.
        # *   **c**: The connection is closed after all replies are written.
        # *   **d**: The monitored keys have been modified, and the `EXEC` command is about to fail.
        # *   **i**: The client is waiting for VM I/O operations. This value is no longer used.
        # *   **M**: The client is the primary node.
        # *   **N**: No special flags are configured.
        # *   **O**: The client is in monitor mode.
        # *   **r**: The client is a cluster node in read-only mode.
        # *   **S**: The client is a replica node in normal mode.
        # *   **u**: The client is not blocked.
        # *   **U**: The client is connected by using UNIX domain sockets.
        # *   **x**: The client is executing a transaction.
        self.flags = flags
        # The client ID.
        self.id = id
        # The duration during which the session is in the idle state. Unit: seconds.
        self.idle = idle
        # The number of commands in `MULTI` or `EXEC`.
        self.multi = multi
        # The name of the client.
        self.name = name
        # The node ID.
        self.node_id = node_id
        # The size of the fixed output buffer. Unit: bytes.
        self.obl = obl
        # The number of objects contained in the output list.
        self.oll = oll
        # The size of the output buffer. Unit: bytes.
        self.omem = omem
        # The number of subscriptions that match the pattern.
        self.psub = psub
        # The size of the input buffer. Unit: bytes.
        self.qbuf = qbuf
        # The remaining size of the input buffer. Unit: bytes.
        self.qbuf_free = qbuf_free
        # The number of subscribed channels.
        self.sub = sub

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr is not None:
            result['Addr'] = self.addr
        if self.age is not None:
            result['Age'] = self.age
        if self.client is not None:
            result['Client'] = self.client
        if self.client_desc is not None:
            result['ClientDesc'] = self.client_desc
        if self.cmd is not None:
            result['Cmd'] = self.cmd
        if self.db is not None:
            result['Db'] = self.db
        if self.events is not None:
            result['Events'] = self.events
        if self.fd is not None:
            result['Fd'] = self.fd
        if self.flags is not None:
            result['Flags'] = self.flags
        if self.id is not None:
            result['Id'] = self.id
        if self.idle is not None:
            result['Idle'] = self.idle
        if self.multi is not None:
            result['Multi'] = self.multi
        if self.name is not None:
            result['Name'] = self.name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.obl is not None:
            result['Obl'] = self.obl
        if self.oll is not None:
            result['Oll'] = self.oll
        if self.omem is not None:
            result['Omem'] = self.omem
        if self.psub is not None:
            result['Psub'] = self.psub
        if self.qbuf is not None:
            result['Qbuf'] = self.qbuf
        if self.qbuf_free is not None:
            result['QbufFree'] = self.qbuf_free
        if self.sub is not None:
            result['Sub'] = self.sub
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addr') is not None:
            self.addr = m.get('Addr')
        if m.get('Age') is not None:
            self.age = m.get('Age')
        if m.get('Client') is not None:
            self.client = m.get('Client')
        if m.get('ClientDesc') is not None:
            self.client_desc = m.get('ClientDesc')
        if m.get('Cmd') is not None:
            self.cmd = m.get('Cmd')
        if m.get('Db') is not None:
            self.db = m.get('Db')
        if m.get('Events') is not None:
            self.events = m.get('Events')
        if m.get('Fd') is not None:
            self.fd = m.get('Fd')
        if m.get('Flags') is not None:
            self.flags = m.get('Flags')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Idle') is not None:
            self.idle = m.get('Idle')
        if m.get('Multi') is not None:
            self.multi = m.get('Multi')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Obl') is not None:
            self.obl = m.get('Obl')
        if m.get('Oll') is not None:
            self.oll = m.get('Oll')
        if m.get('Omem') is not None:
            self.omem = m.get('Omem')
        if m.get('Psub') is not None:
            self.psub = m.get('Psub')
        if m.get('Qbuf') is not None:
            self.qbuf = m.get('Qbuf')
        if m.get('QbufFree') is not None:
            self.qbuf_free = m.get('QbufFree')
        if m.get('Sub') is not None:
            self.sub = m.get('Sub')
        return self


class GetRedisAllSessionResponseBodyDataSourceStats(TeaModel):
    def __init__(
        self,
        count: str = None,
        ids: List[int] = None,
        key: str = None,
    ):
        # The total number of sessions from the access source.
        self.count = count
        # The client IDs.
        self.ids = ids
        # The access source.
        self.key = key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class GetRedisAllSessionResponseBodyData(TeaModel):
    def __init__(
        self,
        sessions: List[GetRedisAllSessionResponseBodyDataSessions] = None,
        source_stats: List[GetRedisAllSessionResponseBodyDataSourceStats] = None,
        timestamp: int = None,
        total: int = None,
    ):
        # The information about the sessions.
        self.sessions = sessions
        # The statistics on the access source.
        self.source_stats = source_stats
        # The time when the instance sessions were returned. The value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.timestamp = timestamp
        # The total number of sessions.
        self.total = total

    def validate(self):
        if self.sessions:
            for k in self.sessions:
                if k:
                    k.validate()
        if self.source_stats:
            for k in self.source_stats:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Sessions'] = []
        if self.sessions is not None:
            for k in self.sessions:
                result['Sessions'].append(k.to_map() if k else None)
        result['SourceStats'] = []
        if self.source_stats is not None:
            for k in self.source_stats:
                result['SourceStats'].append(k.to_map() if k else None)
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.sessions = []
        if m.get('Sessions') is not None:
            for k in m.get('Sessions'):
                temp_model = GetRedisAllSessionResponseBodyDataSessions()
                self.sessions.append(temp_model.from_map(k))
        self.source_stats = []
        if m.get('SourceStats') is not None:
            for k in m.get('SourceStats'):
                temp_model = GetRedisAllSessionResponseBodyDataSourceStats()
                self.source_stats.append(temp_model.from_map(k))
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetRedisAllSessionResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetRedisAllSessionResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The session data.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetRedisAllSessionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRedisAllSessionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRedisAllSessionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRedisAllSessionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRequestDiagnosisPageRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        instance_id: str = None,
        node_id: str = None,
        page_no: int = None,
        page_size: int = None,
        start_time: int = None,
    ):
        # The end of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.end_time = end_time
        # The instance ID.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  You must specify the node ID if your database instance is a PolarDB for MySQL, PolarDB for PostgreSQL (Compatible with Oracle), or ApsaraDB for MongoDB instance.
        self.node_id = node_id
        # The page number. The value must be a positive integer. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. The value must be a positive integer. Default value: 10.
        self.page_size = page_size
        # The beginning of the time range to query. Set this parameter to a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetRequestDiagnosisPageResponseBodyDataList(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        db_schema: str = None,
        engine: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        message_id: str = None,
        param: str = None,
        result: str = None,
        sql_id: str = None,
        state: int = None,
        uuid: str = None,
    ):
        # The user ID.
        self.account_id = account_id
        # The name of the database.
        self.db_schema = db_schema
        # The database engine. Valid values:
        # 
        # * **MySQL**\
        # * **PostgreSQL**\
        # * **SQLServer**\
        # * **PolarDBMySQL**\
        # * **PolarDBOracle**\
        # * **MongoDB**\
        self.engine = engine
        # The time when the SQL diagnostics task was created. The value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.gmt_create = gmt_create
        # The time when the SQL diagnostics task was modified. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.gmt_modified = gmt_modified
        # The unique ID of the diagnostics task.
        self.message_id = message_id
        # Additional information.
        self.param = param
        # The result of the SQL diagnostics task. The result includes the following information:
        # 
        # * **endTime**: the end time of the SQL diagnostics task.
        # * **errorCode**: indicates whether the SQL diagnostics task is complete. Valid values:
        #   * **0001**: The SQL diagnostics task is complete.
        #   * **0003**: The SQL diagnostics task failed.
        # 
        # * **errorMessage**: the error message.
        # * **estimateCost**: the estimated cost.
        #   * **cpu**: the estimated CPU utilization of the index.
        #   * **io**: the estimated I/O usage of the index.
        #   * **rows**: the estimated values of the rows returned for the index.
        # * **improvement**: the performance improvement ratio.
        # * **indexAdvices**: the index recommendations, which include the following information:
        #   * **columns**: the index columns.
        #   * **ddlAddIndex**: the DDL statement for the index.
        #   * **indexName**: the name of the index.
        #   * **schemaName**: the name of the database.
        #   * **tableName**: the name of the table.
        #   * **unique**: indicates whether the index is unique.
        # 
        # * **ip**: the IP address of the instance.
        # * **messageId**: the ID of the diagnostics task.
        # * **port**: the port used to connect to the instance.
        # * **sqlTag**: the SQL tag.
        # * **startTime**: the start time of the SQL diagnostics task.
        # * **success**: indicates whether the request was successful.
        # * **support**: indicates whether the SQL statement can be diagnosed. Valid values:
        #   * **true**: The SQL statement can be diagnosed.
        #   * **false**: The SQL statement cannot be diagnosed.
        # 
        # * **tuningAdvices**: the SQL rewrite suggestions.
        self.result = result
        # The SQL template ID.
        self.sql_id = sql_id
        # The status of the diagnostics task. Valid values:
        # 
        # * **0**: The diagnostics task is in progress.
        # 
        # * **1**: A diagnostics error occurred.
        # 
        # * **2**: The diagnostics task is complete.
        # 
        # * **3**: An SQL error occurred.
        # 
        # * **4**: An engine error occurred.
        self.state = state
        # The unique ID of the diagnostics instance.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        if self.db_schema is not None:
            result['dbSchema'] = self.db_schema
        if self.engine is not None:
            result['engine'] = self.engine
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.message_id is not None:
            result['messageId'] = self.message_id
        if self.param is not None:
            result['param'] = self.param
        if self.result is not None:
            result['result'] = self.result
        if self.sql_id is not None:
            result['sqlId'] = self.sql_id
        if self.state is not None:
            result['state'] = self.state
        if self.uuid is not None:
            result['uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        if m.get('dbSchema') is not None:
            self.db_schema = m.get('dbSchema')
        if m.get('engine') is not None:
            self.engine = m.get('engine')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('messageId') is not None:
            self.message_id = m.get('messageId')
        if m.get('param') is not None:
            self.param = m.get('param')
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('sqlId') is not None:
            self.sql_id = m.get('sqlId')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('uuid') is not None:
            self.uuid = m.get('uuid')
        return self


class GetRequestDiagnosisPageResponseBodyData(TeaModel):
    def __init__(
        self,
        extra: str = None,
        list: List[GetRequestDiagnosisPageResponseBodyDataList] = None,
        page_no: int = None,
        page_size: int = None,
        total: int = None,
    ):
        # Additional information.
        self.extra = extra
        # The SQL diagnostics records returned.
        self.list = list
        # The page number. The value must be a positive integer. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. The value must be a positive integer. Default value: 10.
        self.page_size = page_size
        # The total number of returned entries.
        self.total = total

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extra is not None:
            result['extra'] = self.extra
        result['list'] = []
        if self.list is not None:
            for k in self.list:
                result['list'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['pageNo'] = self.page_no
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        self.list = []
        if m.get('list') is not None:
            for k in m.get('list'):
                temp_model = GetRequestDiagnosisPageResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('pageNo') is not None:
            self.page_no = m.get('pageNo')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class GetRequestDiagnosisPageResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetRequestDiagnosisPageResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message that contains information such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetRequestDiagnosisPageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRequestDiagnosisPageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRequestDiagnosisPageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRequestDiagnosisPageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRequestDiagnosisResultRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        message_id: str = None,
        node_id: str = None,
        source: str = None,
        sql_id: str = None,
    ):
        # The instance ID.
        self.instance_id = instance_id
        # The unique ID of the diagnostics task. You can call the [CreateRequestDiagnosis](~~341609~~) operation to query the diagnostics task ID.
        self.message_id = message_id
        # The node ID.
        # 
        # >  You must specify the node ID if your database instance is a PolarDB for MySQL cluster, a PolarDB for PostgreSQL (compatible with Oracle) instance, or an ApsaraDB for MongoDB database.
        self.node_id = node_id
        # The source of the task.
        # 
        # >  This parameter is required if you call this operation in the DAS console. You do not need to specify this parameter when you call this operation.
        self.source = source
        # The SQL template ID.
        # 
        # >  This parameter is required if you call this operation in the DAS console. You do not need to specify this parameter when you call this operation.
        self.sql_id = sql_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.source is not None:
            result['Source'] = self.source
        if self.sql_id is not None:
            result['SqlId'] = self.sql_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SqlId') is not None:
            self.sql_id = m.get('SqlId')
        return self


class GetRequestDiagnosisResultResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        db_schema: str = None,
        engine: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        message_id: str = None,
        param: str = None,
        result: str = None,
        sql_id: str = None,
        state: int = None,
        uuid: str = None,
    ):
        # The user ID.
        self.account_id = account_id
        # The name of the database.
        self.db_schema = db_schema
        # The database engine. Valid values:
        # 
        # *   **MySQL**\
        # *   **PostgreSQL**\
        # *   **SQLServer**\
        # *   **PolarDBMySQL**\
        # *   **PolarDBOracle**\
        # *   **MongoDB**\
        self.engine = engine
        # The time when the SQL diagnostics task was created. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.gmt_create = gmt_create
        # The time when the SQL diagnostics task was modified. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.gmt_modified = gmt_modified
        # The unique ID of the diagnostics task.
        self.message_id = message_id
        # The additional information.
        self.param = param
        # The result of the SQL diagnostics task. The result includes the following information:
        # 
        # *   **endTime**: the end time of the SQL diagnostics task.
        # 
        # *   **errorCode**: the error code.
        # 
        #     *   **0001**: The SQL diagnostics task is complete.
        #     *   **0003**: The SQL diagnostics task failed.
        # 
        # *   **errorMessage**: the error message.
        # 
        # *   **estimateCost**: the estimated cost.
        # 
        #     *   **cpu**: the estimated CPU utilization of the index.
        #     *   **io**: the estimated I/O usage of the index.
        #     *   **rows**: the estimated values of the rows returned for the index.
        # 
        # *   **improvement**: the performance improvement ratio.
        # 
        # *   **indexAdvices**: the index recommendations, which include the following information:
        # 
        #     *   **columns**: the index columns.
        #     *   **ddlAddIndex**: the DDL statement for the index.
        #     *   **indexName**: the name of the index.
        #     *   **schemaName**: the name of the database.
        #     *   **tableName**: the name of the table.
        #     *   **unique**: indicates whether the index is unique.
        # 
        # *   **ip**: the IP address of the instance.
        # 
        # *   **messageId**: the ID of the diagnostics task.
        # 
        # *   **port**: the port used to connect to the instance.
        # 
        # *   **sqlTag**: the SQL tag.
        # 
        # *   **startTime**: the start time of the SQL diagnostics task.
        # 
        # *   **success**: indicates whether the request was successful.
        # 
        # *   **support**: indicates whether the SQL statement can be diagnosed. Valid values:
        # 
        #     *   **true**\
        #     *   **false**\
        # 
        # *   **tuningAdvices** : the SQL rewrite suggestions.
        self.result = result
        # The SQL template ID.
        self.sql_id = sql_id
        # The state of the diagnostics task. Valid values:
        # 
        # *   **0**: The diagnostics task is in progress.
        # *   **1**: A diagnostics error occurred.
        # *   **2**: The diagnostics task is complete.
        # *   **3**: An SQL error occurred.
        # *   **4**: An engine error occurred.
        self.state = state
        # The unique ID of the diagnostics instance.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        if self.db_schema is not None:
            result['dbSchema'] = self.db_schema
        if self.engine is not None:
            result['engine'] = self.engine
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.message_id is not None:
            result['messageId'] = self.message_id
        if self.param is not None:
            result['param'] = self.param
        if self.result is not None:
            result['result'] = self.result
        if self.sql_id is not None:
            result['sqlId'] = self.sql_id
        if self.state is not None:
            result['state'] = self.state
        if self.uuid is not None:
            result['uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        if m.get('dbSchema') is not None:
            self.db_schema = m.get('dbSchema')
        if m.get('engine') is not None:
            self.engine = m.get('engine')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('messageId') is not None:
            self.message_id = m.get('messageId')
        if m.get('param') is not None:
            self.param = m.get('param')
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('sqlId') is not None:
            self.sql_id = m.get('sqlId')
        if m.get('state') is not None:
            self.state = m.get('state')
        if m.get('uuid') is not None:
            self.uuid = m.get('uuid')
        return self


class GetRequestDiagnosisResultResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetRequestDiagnosisResultResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetRequestDiagnosisResultResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRequestDiagnosisResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRequestDiagnosisResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRequestDiagnosisResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRunningSqlConcurrencyControlRulesRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        instance_id: str = None,
        page_no: int = None,
        page_size: int = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The instance ID.
        # 
        # >  You must specify this parameter only if your database instance is an ApsaraDB RDS for MySQL instance or a PolarDB for MySQL cluster.
        self.instance_id = instance_id
        # The page number. The value must be a positive integer. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. The value must be a positive integer. Default value: 10.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetRunningSqlConcurrencyControlRulesResponseBodyDataListRunningRules(TeaModel):
    def __init__(
        self,
        concurrency_control_time: int = None,
        instance_id: str = None,
        item_id: int = None,
        keywords_hash: str = None,
        max_concurrency: str = None,
        sql_keywords: str = None,
        sql_type: str = None,
        start_time: int = None,
        status: str = None,
        user_id: str = None,
    ):
        # The duration within which the SQL throttling rule takes effect. Unit: seconds.
        # 
        # > The throttling rule takes effect only within this duration.
        self.concurrency_control_time = concurrency_control_time
        # The instance ID.
        self.instance_id = instance_id
        # The ID of the throttling rule that is applied to the instance.
        self.item_id = item_id
        # The hash value of the SQL keywords. The hash value is calculated based on the SQL keywords that are contained in the SQL statements to which the throttling rule is applied.
        self.keywords_hash = keywords_hash
        # The maximum number of concurrent SQL statements. The value is a positive integer.
        # 
        # > If the number of concurrent SQL statements that contain the specified keywords reaches this upper limit, the throttling rule is triggered.
        self.max_concurrency = max_concurrency
        # The keywords contained in the SQL statements to which the throttling rule was applied.
        # 
        # > SQL keywords are separated by tildes (~). If the number of concurrent SQL statements that contain all the specified SQL keywords reaches the specified upper limit, the throttling rule is triggered.
        self.sql_keywords = sql_keywords
        # The type of the SQL statements. Valid values:
        # 
        # * **SELECT**\
        # * **UPDATE**\
        # * **DELETE**\
        self.sql_type = sql_type
        # The time when the throttling rule started to take effect. The value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time
        # The status of the throttling rule. The value of **Open** indicates that the throttling rule is in effect.
        self.status = status
        # The Alibaba Cloud account ID.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrency_control_time is not None:
            result['ConcurrencyControlTime'] = self.concurrency_control_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.keywords_hash is not None:
            result['KeywordsHash'] = self.keywords_hash
        if self.max_concurrency is not None:
            result['MaxConcurrency'] = self.max_concurrency
        if self.sql_keywords is not None:
            result['SqlKeywords'] = self.sql_keywords
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConcurrencyControlTime') is not None:
            self.concurrency_control_time = m.get('ConcurrencyControlTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('KeywordsHash') is not None:
            self.keywords_hash = m.get('KeywordsHash')
        if m.get('MaxConcurrency') is not None:
            self.max_concurrency = m.get('MaxConcurrency')
        if m.get('SqlKeywords') is not None:
            self.sql_keywords = m.get('SqlKeywords')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetRunningSqlConcurrencyControlRulesResponseBodyDataList(TeaModel):
    def __init__(
        self,
        running_rules: List[GetRunningSqlConcurrencyControlRulesResponseBodyDataListRunningRules] = None,
    ):
        self.running_rules = running_rules

    def validate(self):
        if self.running_rules:
            for k in self.running_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['runningRules'] = []
        if self.running_rules is not None:
            for k in self.running_rules:
                result['runningRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.running_rules = []
        if m.get('runningRules') is not None:
            for k in m.get('runningRules'):
                temp_model = GetRunningSqlConcurrencyControlRulesResponseBodyDataListRunningRules()
                self.running_rules.append(temp_model.from_map(k))
        return self


class GetRunningSqlConcurrencyControlRulesResponseBodyData(TeaModel):
    def __init__(
        self,
        list: GetRunningSqlConcurrencyControlRulesResponseBodyDataList = None,
        total: int = None,
    ):
        # The returned data.
        self.list = list
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = GetRunningSqlConcurrencyControlRulesResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetRunningSqlConcurrencyControlRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetRunningSqlConcurrencyControlRulesResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information, including the error codes and the number of entries that are returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetRunningSqlConcurrencyControlRulesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRunningSqlConcurrencyControlRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRunningSqlConcurrencyControlRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRunningSqlConcurrencyControlRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSqlConcurrencyControlKeywordsFromSqlTextRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        instance_id: str = None,
        sql_text: str = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The instance ID.
        self.instance_id = instance_id
        # The SQL statement based on which a throttling keyword string is to be generated.
        self.sql_text = sql_text

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.sql_text is not None:
            result['SqlText'] = self.sql_text
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SqlText') is not None:
            self.sql_text = m.get('SqlText')
        return self


class GetSqlConcurrencyControlKeywordsFromSqlTextResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The throttling keyword string that was generated based on the SQL statement.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSqlConcurrencyControlKeywordsFromSqlTextResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSqlConcurrencyControlKeywordsFromSqlTextResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSqlConcurrencyControlKeywordsFromSqlTextResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSqlConcurrencyControlRulesHistoryRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        instance_id: str = None,
        page_no: int = None,
        page_size: int = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The instance ID.
        # 
        # >  Only ApsaraDB RDS for MySQL instances and PolarDB for MySQL clusters are supported.
        self.instance_id = instance_id
        # The page number. The value must be an integer that is greater than 0. Default value: 1.
        self.page_no = page_no
        # The number of entries per page. The value must be an integer that is greater than 0. Default value: 10.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetSqlConcurrencyControlRulesHistoryResponseBodyDataListRules(TeaModel):
    def __init__(
        self,
        concurrency_control_time: int = None,
        instance_id: str = None,
        item_id: int = None,
        keywords_hash: str = None,
        max_concurrency: int = None,
        sql_keywords: str = None,
        sql_type: str = None,
        start_time: int = None,
        status: str = None,
        user_id: str = None,
    ):
        # The duration within which the SQL throttling rule takes effect. Unit: seconds.
        # 
        # >  The throttling rule takes effect only within this duration.
        self.concurrency_control_time = concurrency_control_time
        # The instance ID.
        self.instance_id = instance_id
        # The ID of the throttling rule that is applied to the instance.
        self.item_id = item_id
        # The hash value of the SQL keywords. The SQL keywords are contained in the SQL statements to which the throttling rule is applied.
        self.keywords_hash = keywords_hash
        # The maximum number of concurrent SQL statements. Set this parameter to a positive integer.
        # 
        # >  When the number of concurrent SQL statements that contain the specified keywords reaches this upper limit, the throttling rule is triggered.
        self.max_concurrency = max_concurrency
        # The keywords that are used to identify the SQL statements that need to be throttled.
        # 
        # > SQL keywords are separated with tildes (~). When the number of concurrent SQL statements that contain all the specified SQL keywords reaches the specified upper limit, the throttling rule is triggered.
        self.sql_keywords = sql_keywords
        # The type of the SQL statements. Valid values:
        # 
        # * **SELECT**\
        # * **UPDATE**\
        # * **DELETE**\
        self.sql_type = sql_type
        # The beginning of the time range to query. This value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.start_time = start_time
        # The state of the throttling rule. Valid values:
        # 
        # * **Open**: The throttling rule is in effect.
        # * **Closed**: The throttling rule was in effect.
        self.status = status
        # The user ID.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrency_control_time is not None:
            result['ConcurrencyControlTime'] = self.concurrency_control_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.keywords_hash is not None:
            result['KeywordsHash'] = self.keywords_hash
        if self.max_concurrency is not None:
            result['MaxConcurrency'] = self.max_concurrency
        if self.sql_keywords is not None:
            result['SqlKeywords'] = self.sql_keywords
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConcurrencyControlTime') is not None:
            self.concurrency_control_time = m.get('ConcurrencyControlTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('KeywordsHash') is not None:
            self.keywords_hash = m.get('KeywordsHash')
        if m.get('MaxConcurrency') is not None:
            self.max_concurrency = m.get('MaxConcurrency')
        if m.get('SqlKeywords') is not None:
            self.sql_keywords = m.get('SqlKeywords')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetSqlConcurrencyControlRulesHistoryResponseBodyDataList(TeaModel):
    def __init__(
        self,
        rules: List[GetSqlConcurrencyControlRulesHistoryResponseBodyDataListRules] = None,
    ):
        self.rules = rules

    def validate(self):
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.rules = []
        if m.get('rules') is not None:
            for k in m.get('rules'):
                temp_model = GetSqlConcurrencyControlRulesHistoryResponseBodyDataListRules()
                self.rules.append(temp_model.from_map(k))
        return self


class GetSqlConcurrencyControlRulesHistoryResponseBodyData(TeaModel):
    def __init__(
        self,
        list: GetSqlConcurrencyControlRulesHistoryResponseBodyDataList = None,
        total: int = None,
    ):
        # The list of the queried throttling rules.
        self.list = list
        # The total number of entries returned.
        self.total = total

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = GetSqlConcurrencyControlRulesHistoryResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetSqlConcurrencyControlRulesHistoryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetSqlConcurrencyControlRulesHistoryResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information, including the error codes and the number of entries that are returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSqlConcurrencyControlRulesHistoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSqlConcurrencyControlRulesHistoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSqlConcurrencyControlRulesHistoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSqlConcurrencyControlRulesHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSqlOptimizeAdviceRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        end_dt: str = None,
        engine: str = None,
        instance_ids: str = None,
        region: str = None,
        start_dt: str = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The end date of the time range to query. Specify the date in the *yyyyMMdd* format. The time must be in UTC.
        # 
        # *   The default value of this parameter is one day before the current day.
        # *   The value must be earlier than the current day. The interval between the start date and the end date cannot exceed 30 days.
        self.end_dt = end_dt
        # The database engine. Valid values:
        # 
        # *   **MySQL**: ApsaraDB RDS for MySQL.
        # *   **PolarDBMySQL**: PolarDB for MySQL.
        self.engine = engine
        # The instance ID.
        # 
        # >  You must specify the instance ID only if your database instance is an ApsaraDB RDS for MySQL instance or a PolarDB for MySQL cluster.
        self.instance_ids = instance_ids
        # The region in which the instance resides. Valid values:
        # 
        # *   **cn-china**: Chinese mainland.
        # *   **cn-hongkong**: China (Hong Kong).
        # *   **ap-southeast-1**: Singapore.
        # 
        # This parameter takes effect only if **InstanceIds** is left empty. If you leave **InstanceIds** empty, the system obtains data from the region specified by **Region**. By default, Region is set to **cn-china**. If you specify **InstanceIds**, **Region** does not take effect, and the system obtains data from the region in which the first specified instance resides.****\
        # 
        # >  If your instances reside in the regions inside the Chinese mainland, set this parameter to **cn-china**.
        self.region = region
        # The start date of the time range to query. Specify the date in the *yyyyMMdd* format. The time must be in UTC.
        # 
        # *   The default value of this parameter is one day before the current day.
        # *   The value must be earlier than the current day.
        self.start_dt = start_dt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.end_dt is not None:
            result['EndDt'] = self.end_dt
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.region is not None:
            result['Region'] = self.region
        if self.start_dt is not None:
            result['StartDt'] = self.start_dt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('EndDt') is not None:
            self.end_dt = m.get('EndDt')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartDt') is not None:
            self.start_dt = m.get('StartDt')
        return self


class GetSqlOptimizeAdviceResponseBodyData(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        download_url: str = None,
        expire_time: str = None,
        status: str = None,
        status_code: str = None,
        task_id: str = None,
    ):
        # The time when the task was created. The value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        self.create_time = create_time
        # The URL that is used to download the file.
        self.download_url = download_url
        # The time when the file expires. The value is a UNIX timestamp representing the number of milliseconds that have elapsed since January 1, 1970, 00:00:00 UTC.
        # 
        # >  The file expires three days after the task is created.
        self.expire_time = expire_time
        # The status of the task. Valid values:
        # 
        # *   **INIT**: The task is being initialized.
        # *   **RUNNING**: The task is running.
        # *   **FINISH**: The task is complete.
        # *   **FAILED**: The task failed.
        self.status = status
        # The status code of the task. Valid values:
        # 
        # *   **NO_DATA**: No data is returned.
        # *   **INTERNAL_ERROR**: An internal error occurred.
        # *   **SUCCESS**: The task is successful.
        self.status_code = status_code
        # The task ID.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.status is not None:
            result['Status'] = self.status
        if self.status_code is not None:
            result['StatusCode'] = self.status_code
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusCode') is not None:
            self.status_code = m.get('StatusCode')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetSqlOptimizeAdviceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetSqlOptimizeAdviceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The detailed information, including the error codes and the number of entries that are returned.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, Successful is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSqlOptimizeAdviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSqlOptimizeAdviceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSqlOptimizeAdviceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSqlOptimizeAdviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetStorageAnalysisResultRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        node_id: str = None,
        task_id: str = None,
    ):
        # The instance ID.
        self.instance_id = instance_id
        # The node ID.
        # 
        # >  This parameter is reserved.
        self.node_id = node_id
        # The task ID, which is returned after you call the CreateStorageAnalysisTask operation.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetStorageAnalysisResultResponseBodyDataStorageAnalysisResultNeedOptimizeItemList(TeaModel):
    def __init__(
        self,
        associated_data: str = None,
        db_name: str = None,
        optimize_advice: str = None,
        optimize_item_name: str = None,
        table_name: str = None,
    ):
        # The data associated with items to be optimized.
        self.associated_data = associated_data
        # The database name.
        self.db_name = db_name
        # The optimization suggestion. Valid values:
        # 
        # *   **NEED_ANALYZE_TABLE**: You can execute the ANALYZE TABLE statement on the related table during off-peak hours.
        # *   **NEED_OPTIMIZE_TABLE**: You can reclaim fragments during off-peak hours.
        self.optimize_advice = optimize_advice
        # The item to be optimized. Valid values:
        # 
        # *   **NEED_ANALYZE_TABLE**: The statistical data in information_schema.tables differs greatly from the physical file size.
        # *   **NEED_OPTIMIZE_TABLE**: The fragmentation degree of the table is high.
        self.optimize_item_name = optimize_item_name
        # The table name.
        self.table_name = table_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_data is not None:
            result['AssociatedData'] = self.associated_data
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.optimize_advice is not None:
            result['OptimizeAdvice'] = self.optimize_advice
        if self.optimize_item_name is not None:
            result['OptimizeItemName'] = self.optimize_item_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssociatedData') is not None:
            self.associated_data = m.get('AssociatedData')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('OptimizeAdvice') is not None:
            self.optimize_advice = m.get('OptimizeAdvice')
        if m.get('OptimizeItemName') is not None:
            self.optimize_item_name = m.get('OptimizeItemName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class GetStorageAnalysisResultResponseBodyDataStorageAnalysisResultTableStats(TeaModel):
    def __init__(
        self,
        avg_row_length: int = None,
        data_free: int = None,
        data_size: int = None,
        db_name: str = None,
        engine: str = None,
        index_size: int = None,
        phy_total_size: int = None,
        physical_file_size: int = None,
        table_name: str = None,
        table_rows: int = None,
        table_type: str = None,
        total_size: int = None,
    ):
        # The average row length.
        # 
        # >  Unit: bytes.
        self.avg_row_length = avg_row_length
        # The size of storage occupied by fragments.
        # 
        # >  Unit: bytes.
        self.data_free = data_free
        # The size of storage occupied by the table data.
        # 
        # >  Unit: bytes.
        self.data_size = data_size
        # The database name.
        self.db_name = db_name
        # The type of the engine used by the table.
        self.engine = engine
        # The size of storage occupied by indexes.
        # 
        # >  Unit: bytes.
        self.index_size = index_size
        # The size of the table storage.
        # 
        # >  Unit: byte. The value of the parameter is the sum of DataSize, IndexSize, and DataFree.
        self.phy_total_size = phy_total_size
        # The physical file size of the table.
        # 
        # >  Unit: byte. You may fail to obtain the physical file size because of the deployment mode of the database instance.
        self.physical_file_size = physical_file_size
        # The table name.
        self.table_name = table_name
        # The number of rows in the table.
        self.table_rows = table_rows
        # The table type.
        self.table_type = table_type
        # The size of storage occupied by table data and indexes.
        # 
        # >  Unit: byte. The value of the parameter is the sum of DataSize and IndexSize.
        self.total_size = total_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_row_length is not None:
            result['AvgRowLength'] = self.avg_row_length
        if self.data_free is not None:
            result['DataFree'] = self.data_free
        if self.data_size is not None:
            result['DataSize'] = self.data_size
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.index_size is not None:
            result['IndexSize'] = self.index_size
        if self.phy_total_size is not None:
            result['PhyTotalSize'] = self.phy_total_size
        if self.physical_file_size is not None:
            result['PhysicalFileSize'] = self.physical_file_size
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.table_rows is not None:
            result['TableRows'] = self.table_rows
        if self.table_type is not None:
            result['TableType'] = self.table_type
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgRowLength') is not None:
            self.avg_row_length = m.get('AvgRowLength')
        if m.get('DataFree') is not None:
            self.data_free = m.get('DataFree')
        if m.get('DataSize') is not None:
            self.data_size = m.get('DataSize')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('IndexSize') is not None:
            self.index_size = m.get('IndexSize')
        if m.get('PhyTotalSize') is not None:
            self.phy_total_size = m.get('PhyTotalSize')
        if m.get('PhysicalFileSize') is not None:
            self.physical_file_size = m.get('PhysicalFileSize')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TableRows') is not None:
            self.table_rows = m.get('TableRows')
        if m.get('TableType') is not None:
            self.table_type = m.get('TableType')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class GetStorageAnalysisResultResponseBodyDataStorageAnalysisResult(TeaModel):
    def __init__(
        self,
        analysis_error_type: str = None,
        analysis_success: bool = None,
        daily_increment: int = None,
        estimate_available_days: int = None,
        need_optimize_item_list: List[GetStorageAnalysisResultResponseBodyDataStorageAnalysisResultNeedOptimizeItemList] = None,
        table_stats: List[GetStorageAnalysisResultResponseBodyDataStorageAnalysisResultTableStats] = None,
        total_free_storage_size: int = None,
        total_storage_size: int = None,
        total_used_storage_size: int = None,
    ):
        # The reason why the analysis on the database and table fails.
        # 
        # *   **DB_OR_TABLE_NOT_EXIST**: The specified database or table does not exist.
        # *   **DB_NOT_EXIST**: The specified database does not exist.
        self.analysis_error_type = analysis_error_type
        # Indicates whether the analysis on the database and table is successful.
        self.analysis_success = analysis_success
        # The estimated daily storage usage increment in the last seven days.
        # 
        # >  Unit: bytes.
        self.daily_increment = daily_increment
        # The estimated number of days before the remaining storage runs out.
        self.estimate_available_days = estimate_available_days
        # The list of items to be optimized.
        self.need_optimize_item_list = need_optimize_item_list
        # The information about the table.
        self.table_stats = table_stats
        # The size of remaining storage.
        # 
        # >  Unit: bytes.
        self.total_free_storage_size = total_free_storage_size
        # The total size of instance storage.
        # 
        # >  Unit: bytes.
        self.total_storage_size = total_storage_size
        # The size of used storage.
        # 
        # >  Unit: bytes.
        self.total_used_storage_size = total_used_storage_size

    def validate(self):
        if self.need_optimize_item_list:
            for k in self.need_optimize_item_list:
                if k:
                    k.validate()
        if self.table_stats:
            for k in self.table_stats:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_error_type is not None:
            result['AnalysisErrorType'] = self.analysis_error_type
        if self.analysis_success is not None:
            result['AnalysisSuccess'] = self.analysis_success
        if self.daily_increment is not None:
            result['DailyIncrement'] = self.daily_increment
        if self.estimate_available_days is not None:
            result['EstimateAvailableDays'] = self.estimate_available_days
        result['NeedOptimizeItemList'] = []
        if self.need_optimize_item_list is not None:
            for k in self.need_optimize_item_list:
                result['NeedOptimizeItemList'].append(k.to_map() if k else None)
        result['TableStats'] = []
        if self.table_stats is not None:
            for k in self.table_stats:
                result['TableStats'].append(k.to_map() if k else None)
        if self.total_free_storage_size is not None:
            result['TotalFreeStorageSize'] = self.total_free_storage_size
        if self.total_storage_size is not None:
            result['TotalStorageSize'] = self.total_storage_size
        if self.total_used_storage_size is not None:
            result['TotalUsedStorageSize'] = self.total_used_storage_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnalysisErrorType') is not None:
            self.analysis_error_type = m.get('AnalysisErrorType')
        if m.get('AnalysisSuccess') is not None:
            self.analysis_success = m.get('AnalysisSuccess')
        if m.get('DailyIncrement') is not None:
            self.daily_increment = m.get('DailyIncrement')
        if m.get('EstimateAvailableDays') is not None:
            self.estimate_available_days = m.get('EstimateAvailableDays')
        self.need_optimize_item_list = []
        if m.get('NeedOptimizeItemList') is not None:
            for k in m.get('NeedOptimizeItemList'):
                temp_model = GetStorageAnalysisResultResponseBodyDataStorageAnalysisResultNeedOptimizeItemList()
                self.need_optimize_item_list.append(temp_model.from_map(k))
        self.table_stats = []
        if m.get('TableStats') is not None:
            for k in m.get('TableStats'):
                temp_model = GetStorageAnalysisResultResponseBodyDataStorageAnalysisResultTableStats()
                self.table_stats.append(temp_model.from_map(k))
        if m.get('TotalFreeStorageSize') is not None:
            self.total_free_storage_size = m.get('TotalFreeStorageSize')
        if m.get('TotalStorageSize') is not None:
            self.total_storage_size = m.get('TotalStorageSize')
        if m.get('TotalUsedStorageSize') is not None:
            self.total_used_storage_size = m.get('TotalUsedStorageSize')
        return self


class GetStorageAnalysisResultResponseBodyData(TeaModel):
    def __init__(
        self,
        analyzed_db_count: int = None,
        storage_analysis_result: GetStorageAnalysisResultResponseBodyDataStorageAnalysisResult = None,
        task_finish: bool = None,
        task_id: str = None,
        task_progress: int = None,
        task_state: str = None,
        task_success: bool = None,
        total_db_count: int = None,
    ):
        # The number of databases that have been analyzed.
        self.analyzed_db_count = analyzed_db_count
        # The details of storage analysis.
        self.storage_analysis_result = storage_analysis_result
        # Indicates whether the task is complete.
        self.task_finish = task_finish
        # The task ID.
        self.task_id = task_id
        # The task progress.
        # 
        # >  Valid values are integers that range from 0 to 100.
        self.task_progress = task_progress
        # The status of the storage analysis task. Valid values:
        # 
        # *   **INIT**: The task is being initialized.
        # *   **PENDING**: The task is being queued for execution.
        # *   **RECEIVED**: The task is received for execution.
        # *   **RUNNING**: The task is being executed.
        # *   **RETRY**: The task is being retried.
        # *   **SUCCESS**: The task succeeds.
        # *   **FAILURE**: The task fails.
        self.task_state = task_state
        # Indicates whether the task is successful.
        self.task_success = task_success
        # The number of databases that need to be analyzed in the storage analysis task.
        self.total_db_count = total_db_count

    def validate(self):
        if self.storage_analysis_result:
            self.storage_analysis_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analyzed_db_count is not None:
            result['AnalyzedDbCount'] = self.analyzed_db_count
        if self.storage_analysis_result is not None:
            result['StorageAnalysisResult'] = self.storage_analysis_result.to_map()
        if self.task_finish is not None:
            result['TaskFinish'] = self.task_finish
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_progress is not None:
            result['TaskProgress'] = self.task_progress
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.task_success is not None:
            result['TaskSuccess'] = self.task_success
        if self.total_db_count is not None:
            result['TotalDbCount'] = self.total_db_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnalyzedDbCount') is not None:
            self.analyzed_db_count = m.get('AnalyzedDbCount')
        if m.get('StorageAnalysisResult') is not None:
            temp_model = GetStorageAnalysisResultResponseBodyDataStorageAnalysisResult()
            self.storage_analysis_result = temp_model.from_map(m['StorageAnalysisResult'])
        if m.get('TaskFinish') is not None:
            self.task_finish = m.get('TaskFinish')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskProgress') is not None:
            self.task_progress = m.get('TaskProgress')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TaskSuccess') is not None:
            self.task_success = m.get('TaskSuccess')
        if m.get('TotalDbCount') is not None:
            self.total_db_count = m.get('TotalDbCount')
        return self


class GetStorageAnalysisResultResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: GetStorageAnalysisResultResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The returned message.
        # 
        # >  If the request is successful, **Successful** is returned. Otherwise, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetStorageAnalysisResultResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetStorageAnalysisResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetStorageAnalysisResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetStorageAnalysisResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class KillInstanceAllSessionRequest(TeaModel):
    def __init__(
        self,
        console_context: str = None,
        instance_id: str = None,
    ):
        # The reserved parameter.
        self.console_context = console_context
        # The instance ID.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.console_context is not None:
            result['ConsoleContext'] = self.console_context
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConsoleContext') is not None:
            self.console_context = m.get('ConsoleContext')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class KillInstanceAllSessionResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        # The HTTP status code returned.
        self.code = code
        # The reserved parameter.
        self.data = data
        # The returned message.
        # 
        # >  If the request was successful, **Successful** is returned. If the request failed, an error message such as an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class KillInstanceAllSessionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: KillInstanceAllSessionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = KillInstanceAllSessionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyAutoScalingConfigRequestBandwidth(TeaModel):
    def __init__(
        self,
        apply: bool = None,
        bandwidth_usage_lower_threshold: int = None,
        bandwidth_usage_upper_threshold: int = None,
        downgrade: bool = None,
        observation_window_size: str = None,
        upgrade: bool = None,
    ):
        # Specifies whether to apply the **Bandwidth** configuration of the automatic bandwidth adjustment feature. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.apply = apply
        # The average bandwidth usage threshold that triggers automatic bandwidth downgrade. Unit: %. Valid values:
        # 
        # *   **10**\
        # *   **20**\
        # *   **30**\
        self.bandwidth_usage_lower_threshold = bandwidth_usage_lower_threshold
        # The average bandwidth usage threshold that triggers automatic bandwidth upgrade. Unit: %. Valid values:
        # 
        # *   **50**\
        # *   **60**\
        # *   **70**\
        # *   **80**\
        # *   **90**\
        # *   **95**\
        self.bandwidth_usage_upper_threshold = bandwidth_usage_upper_threshold
        # Specifies whether to enable the automatic bandwidth downgrade feature. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.downgrade = downgrade
        # The observation window of the automatic bandwidth upgrade feature. The value of this parameter consists of a numeric value and a time unit suffix. The **m** time unit suffix specifies the minute. Valid values:
        # 
        # *   **1m**\
        # *   **5m**\
        # *   **10m**\
        # *   **15m**\
        # *   **30m**\
        self.observation_window_size = observation_window_size
        # Specifies whether to enable the automatic bandwidth upgrade feature. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.upgrade = upgrade

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply is not None:
            result['Apply'] = self.apply
        if self.bandwidth_usage_lower_threshold is not None:
            result['BandwidthUsageLowerThreshold'] = self.bandwidth_usage_lower_threshold
        if self.bandwidth_usage_upper_threshold is not None:
            result['BandwidthUsageUpperThreshold'] = self.bandwidth_usage_upper_threshold
        if self.downgrade is not None:
            result['Downgrade'] = self.downgrade
        if self.observation_window_size is not None:
            result['ObservationWindowSize'] = self.observation_window_size
        if self.upgrade is not None:
            result['Upgrade'] = self.upgrade
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Apply') is not None:
            self.apply = m.get('Apply')
        if m.get('BandwidthUsageLowerThreshold') is not None:
            self.bandwidth_usage_lower_threshold = m.get('BandwidthUsageLowerThreshold')
        if m.get('BandwidthUsageUpperThreshold') is not None:
            self.bandwidth_usage_upper_threshold = m.get('BandwidthUsageUpperThreshold')
        if m.get('Downgrade') is not None:
            self.downgrade = m.get('Downgrade')
        if m.get('ObservationWindowSize') is not None:
            self.observation_window_size = m.get('ObservationWindowSize')
        if m.get('Upgrade') is not None:
            self.upgrade = m.get('Upgrade')
        return self


class ModifyAutoScalingConfigRequestResource(TeaModel):
    def __init__(
        self,
        apply: bool = None,
        cpu_usage_upper_threshold: int = None,
        downgrade_observation_window_size: str = None,
        enable: bool = None,
        upgrade_observation_window_size: str = None,
    ):
        # Specifies whether to apply the **Resource** configuration of the auto scaling feature for resources. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.apply = apply
        # The average CPU utilization threshold that triggers automatic scale-out of resources. Unit: %. Valid values:
        # 
        # *   **70**\
        # *   **80**\
        # *   **90**\
        self.cpu_usage_upper_threshold = cpu_usage_upper_threshold
        # The observation window of the automatic resource scale-in feature. The value of this parameter consists of a numeric value and a time unit suffix. The **m** time unit suffix specifies the minute. Valid values:
        # 
        # *   **1m**\
        # *   **3m**\
        # *   **5m**\
        # *   **10m**\
        # *   **20m**\
        # *   **30m**\
        self.downgrade_observation_window_size = downgrade_observation_window_size
        # Specifies whether to enable the auto scaling feature for resources. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.enable = enable
        # The observation window of the automatic resource scale-out feature. The value of this parameter consists of a numeric value and a time unit suffix. The **m** time unit suffix specifies the minute. Valid values:
        # 
        # *   **1m**\
        # *   **3m**\
        # *   **5m**\
        # *   **10m**\
        # *   **20m**\
        # *   **30m**\
        self.upgrade_observation_window_size = upgrade_observation_window_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply is not None:
            result['Apply'] = self.apply
        if self.cpu_usage_upper_threshold is not None:
            result['CpuUsageUpperThreshold'] = self.cpu_usage_upper_threshold
        if self.downgrade_observation_window_size is not None:
            result['DowngradeObservationWindowSize'] = self.downgrade_observation_window_size
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.upgrade_observation_window_size is not None:
            result['UpgradeObservationWindowSize'] = self.upgrade_observation_window_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Apply') is not None:
            self.apply = m.get('Apply')
        if m.get('CpuUsageUpperThreshold') is not None:
            self.cpu_usage_upper_threshold = m.get('CpuUsageUpperThreshold')
        if m.get('DowngradeObservationWindowSize') is not None:
            self.downgrade_observation_window_size = m.get('DowngradeObservationWindowSize')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('UpgradeObservationWindowSize') is not None:
            self.upgrade_observation_window_size = m.get('UpgradeObservationWindowSize')
        return self


class ModifyAutoScalingConfigRequestShard(TeaModel):
    def __init__(
        self,
        apply: bool = None,
        downgrade: bool = None,
        downgrade_observation_window_size: str = None,
        max_shards: int = None,
        mem_usage_lower_threshold: int = None,
        mem_usage_upper_threshold: int = None,
        min_shards: int = None,
        upgrade: bool = None,
        upgrade_observation_window_size: str = None,
    ):
        # Specifies whether to apply the **Shard** configuration of the auto scaling feature for shards. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        # 
        # >  The auto scaling feature for shards is available only for ApsaraDB for Redis Community Edition instances that use cloud disks on the China site (aliyun.com).
        self.apply = apply
        # Specifies whether to enable the feature of automatically removing shards. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        # 
        # >  The feature of automatically removing shards is in canary release.
        self.downgrade = downgrade
        # The observation window of the feature of automatically removing shards. The value of this parameter consists of a numeric value and a time unit suffix. The **h** time unit suffix specifies the hour. The **d** time unit suffix specifies the day. Valid values:
        # 
        # *   **1h**\
        # *   **2h**\
        # *   **3h**\
        # *   **1d**\
        # *   **7d**\
        self.downgrade_observation_window_size = downgrade_observation_window_size
        # The maximum number of shards in the instance. The value must be a positive integer. Valid values: 4 to 32.
        self.max_shards = max_shards
        # The average memory usage threshold that triggers automatic removal of shards. Unit: %. Valid values:
        # 
        # *   **10**\
        # *   **20**\
        # *   **30**\
        self.mem_usage_lower_threshold = mem_usage_lower_threshold
        # The average memory usage threshold that triggers automatic adding of shards. Unit: %. Valid values:
        # 
        # *   **50**\
        # *   **60**\
        # *   **70**\
        # *   **80**\
        # *   **90**\
        self.mem_usage_upper_threshold = mem_usage_upper_threshold
        # The minimum number of shards in the instance. The value must be a positive integer. Valid values: 4 to 32.
        self.min_shards = min_shards
        # Specifies whether to enable the feature of automatically adding shards. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.upgrade = upgrade
        # The observation window of the feature of automatically adding shards. The value of this parameter consists of a numeric value and a time unit suffix. The **m** time unit suffix specifies the minute. Valid values:
        # 
        # *   **5m**\
        # *   **10m**\
        # *   **15m**\
        # *   **30m**\
        self.upgrade_observation_window_size = upgrade_observation_window_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply is not None:
            result['Apply'] = self.apply
        if self.downgrade is not None:
            result['Downgrade'] = self.downgrade
        if self.downgrade_observation_window_size is not None:
            result['DowngradeObservationWindowSize'] = self.downgrade_observation_window_size
        if self.max_shards is not None:
            result['MaxShards'] = self.max_shards
        if self.mem_usage_lower_threshold is not None:
            result['MemUsageLowerThreshold'] = self.mem_usage_lower_threshold
        if self.mem_usage_upper_threshold is not None:
            result['MemUsageUpperThreshold'] = self.mem_usage_upper_threshold
        if self.min_shards is not None:
            result['MinShards'] = self.min_shards
        if self.upgrade is not None:
            result['Upgrade'] = self.upgrade
        if self.upgrade_observation_window_size is not None:
            result['UpgradeObservationWindowSize'] = self.upgrade_observation_window_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Apply') is not None:
            self.apply = m.get('Apply')
        if m.get('Downgrade') is not None:
            self.downgrade = m.get('Downgrade')
        if m.get('DowngradeObservationWindowSize') is not None:
            self.downgrade_observation_window_size = m.get('DowngradeObservationWindowSize')
        if m.get('MaxShards') is not None:
            self.max_shards = m.get('MaxShards')
        if m.get('MemUsageLowerThreshold') is not None:
            self.mem_usage_lower_threshold = m.get('MemUsageLowerThreshold')
        if m.get('MemUsageUpperThreshold') is not None:
            self.mem_usage_upper_threshold = m.get('MemUsageUpperThreshold')
        if m.get('MinShards') is not None:
            self.min_shards = m.get('MinShards')
        if m.get('Upgrade') is not None:
            self.upgrade = m.get('Upgrade')
        if m.get('UpgradeObservationWindowSize') is not None:
            self.upgrade_observation_window_size = m.get('UpgradeObservationWindowSize')
        return self


class ModifyAutoScalingConfigRequestSpec(TeaModel):
    def __init__(
        self,
        apply: bool = None,
        cool_down_time: str = None,
        cpu_usage_upper_threshold: int = None,
        downgrade: bool = None,
        max_read_only_nodes: int = None,
        max_spec: str = None,
        mem_usage_upper_threshold: int = None,
        observation_window_size: str = None,
        upgrade: bool = None,
    ):
        # Specifies whether to apply the **Spec** configuration of the auto scaling feature for specifications. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.apply = apply
        # The quiescent period. The value of this parameter consists of a numeric value and a time unit suffix. The **m** time unit suffix specifies the minute, the **h** time unit suffix specifies the hour, and the **d** time suffix unit specifies the day.
        # 
        # *   Valid values for PolarDB for MySQL Cluster Edition instances: **5m**, **10m**, **30m**, **1h**, **2h**, **3h**, **1d**, and **7d**.
        # *   Valid values for ApsaraDB RDS for MySQL High-availability Edition instances that use standard SSDs or ESSDs: **5m**, **10m**, **30m**, **1h**, **2h**, **3h**, **1d**, and **7d**.
        self.cool_down_time = cool_down_time
        # The average CPU utilization threshold that triggers automatic specification scale-up. Unit: %. Valid values:
        # 
        # *   **50**\
        # *   **60**\
        # *   **70**\
        # *   **80**\
        # *   **90**\
        # 
        # >  This parameter must be specified if the database instance is a PolarDB for MySQL Cluster Edition instance or an ApsaraDB RDS for MySQL High-availability Edition instance that uses standard SSDs or ESSDs.
        self.cpu_usage_upper_threshold = cpu_usage_upper_threshold
        # Specifies whether to enable the automatic specification scale-down feature. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        # 
        # >  This parameter must be specified if the database instance is a PolarDB for MySQL Cluster Edition instance or an ApsaraDB RDS for MySQL High-availability Edition instance that uses standard SSDs or ESSDs.
        self.downgrade = downgrade
        # The maximum number of read-only nodes of the instance.
        # 
        # >  This parameter must be specified if the database instance is a PolarDB for MySQL Cluster Edition instance.
        self.max_read_only_nodes = max_read_only_nodes
        # The maximum specifications to which the database instance can be upgraded. The database instance can be upgraded only to a database instance of the same edition with higher specifications. For information about the specifications of different database instances, refer to the following topics:
        # 
        # *   PolarDB for MySQL Cluster Edition instances: [Specifications of compute nodes](~~102542~~).
        # *   ApsaraDB RDS for MySQL High-availability Edition instances that use standard SSDs or ESSDs: [Specifications](~~276974~~).
        self.max_spec = max_spec
        # The average memory usage threshold that triggers automatic specification scale-up. Unit: %. Valid values:
        # 
        # *   **50**\
        # *   **60**\
        # *   **70**\
        # *   **80**\
        # *   **90**\
        # 
        # >  This parameter must be specified if the database instance is an ApsaraDB for Redis Community Edition instance that uses cloud disks on the China site (aliyun.com).
        self.mem_usage_upper_threshold = mem_usage_upper_threshold
        # The observation window. The value of this parameter consists of a numeric value and a time unit suffix. The **m** time unit suffix specifies the minute and the **h** time unit suffix specifies the hour.
        # 
        # *   Valid values for PolarDB for MySQL Cluster Edition instances: **5m**, **10m**, **15m**, and **30m**.
        # *   Valid values for ApsaraDB RDS for MySQL High-availability Edition instances that use standard SSDs or ESSDs: **5m**, **20m**, **30m**, **40m**, and **1h**.
        # *   Valid values for ApsaraDB for Redis Community Edition instances that use cloud disks: **5m**, **10m**, **15m**, and **30m**.
        self.observation_window_size = observation_window_size
        # Specifies whether to enable the automatic specification scale-up feature. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.upgrade = upgrade

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply is not None:
            result['Apply'] = self.apply
        if self.cool_down_time is not None:
            result['CoolDownTime'] = self.cool_down_time
        if self.cpu_usage_upper_threshold is not None:
            result['CpuUsageUpperThreshold'] = self.cpu_usage_upper_threshold
        if self.downgrade is not None:
            result['Downgrade'] = self.downgrade
        if self.max_read_only_nodes is not None:
            result['MaxReadOnlyNodes'] = self.max_read_only_nodes
        if self.max_spec is not None:
            result['MaxSpec'] = self.max_spec
        if self.mem_usage_upper_threshold is not None:
            result['MemUsageUpperThreshold'] = self.mem_usage_upper_threshold
        if self.observation_window_size is not None:
            result['ObservationWindowSize'] = self.observation_window_size
        if self.upgrade is not None:
            result['Upgrade'] = self.upgrade
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Apply') is not None:
            self.apply = m.get('Apply')
        if m.get('CoolDownTime') is not None:
            self.cool_down_time = m.get('CoolDownTime')
        if m.get('CpuUsageUpperThreshold') is not None:
            self.cpu_usage_upper_threshold = m.get('CpuUsageUpperThreshold')
        if m.get('Downgrade') is not None:
            self.downgrade = m.get('Downgrade')
        if m.get('MaxReadOnlyNodes') is not None:
            self.max_read_only_nodes = m.get('MaxReadOnlyNodes')
        if m.get('MaxSpec') is not None:
            self.max_spec = m.get('MaxSpec')
        if m.get('MemUsageUpperThreshold') is not None:
            self.mem_usage_upper_threshold = m.get('MemUsageUpperThreshold')
        if m.get('ObservationWindowSize') is not None:
            self.observation_window_size = m.get('ObservationWindowSize')
        if m.get('Upgrade') is not None:
            self.upgrade = m.get('Upgrade')
        return self


class ModifyAutoScalingConfigRequestStorage(TeaModel):
    def __init__(
        self,
        apply: bool = None,
        disk_usage_upper_threshold: int = None,
        max_storage: int = None,
        upgrade: bool = None,
    ):
        # Specifies whether to apply the **Storage** configuration of the automatic storage expansion feature. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.apply = apply
        # The average storage usage threshold that triggers automatic storage expansion. Unit: %. Valid values:
        # 
        # *   **50**\
        # *   **60**\
        # *   **70**\
        # *   **80**\
        # *   **90**\
        self.disk_usage_upper_threshold = disk_usage_upper_threshold
        # The maximum storage size of the database instance. The value must be greater than or equal to the total storage size of the instance. Valid values of different types of instances:
        # 
        # *   If the ApsaraDB for RDS instance uses ESSDs, the value of this parameter can be set to 32000, in GB.
        # *   If the ApsaraDB for RDS instance uses standard SSDs, the value of this parameter can be set to 6000, in GB.
        # 
        # >  The ApsaraDB RDS for MySQL instances that use standard SSDs are discontinued. We recommend that you [upgrade the storage type of an ApsaraDB RDS for MySQL instance from standard SSDs to ESSDs](~~314678~~).
        self.max_storage = max_storage
        # Specifies whether to enable the automatic storage expansion feature. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.upgrade = upgrade

    def validate(self):
        pass

    def to_map(self):
