# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HubArgs', 'Hub']

@pulumi.input_type
class HubArgs:
    def __init__(__self__, *,
                 identity: pulumi.Input['HubIdentityArgs'],
                 key_vault_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 storage_account_id: pulumi.Input[_builtins.str],
                 application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input['HubEncryptionArgs']] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_business_impact_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_network: Optional[pulumi.Input['HubManagedNetworkArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Hub resource.
        :param pulumi.Input['HubIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] key_vault_id: The Key Vault ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The Storage Account ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] application_insights_id: The Application Insights ID that should be used by this AI Foundry Hub.
        :param pulumi.Input[_builtins.str] container_registry_id: The Container Registry ID that should be used by this AI Foundry Hub.
        :param pulumi.Input[_builtins.str] description: The description of this AI Foundry Hub.
        :param pulumi.Input['HubEncryptionArgs'] encryption: An `encryption` block as defined below. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] friendly_name: The display name of this AI Foundry Hub.
        :param pulumi.Input[_builtins.bool] high_business_impact_enabled: Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Hub to be created. Defaults to `false`.
               
               > **Note:** `high_business_impact_enabled` will be enabled by default when creating an AI Foundry Hub with `encryption` enabled.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input['HubManagedNetworkArgs'] managed_network: A `managed_network` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity: The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access for this AI Service Hub should be enabled. Possible values include `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the AI Foundry Hub.
        """
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if application_insights_id is not None:
            pulumi.set(__self__, "application_insights_id", application_insights_id)
        if container_registry_id is not None:
            pulumi.set(__self__, "container_registry_id", container_registry_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if high_business_impact_enabled is not None:
            pulumi.set(__self__, "high_business_impact_enabled", high_business_impact_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_network is not None:
            pulumi.set(__self__, "managed_network", managed_network)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_user_assigned_identity is not None:
            pulumi.set(__self__, "primary_user_assigned_identity", primary_user_assigned_identity)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Input['HubIdentityArgs']:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['HubIdentityArgs']):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Key Vault ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Storage Account ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsId")
    def application_insights_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Application Insights ID that should be used by this AI Foundry Hub.
        """
        return pulumi.get(self, "application_insights_id")

    @application_insights_id.setter
    def application_insights_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_insights_id", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Container Registry ID that should be used by this AI Foundry Hub.
        """
        return pulumi.get(self, "container_registry_id")

    @container_registry_id.setter
    def container_registry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_registry_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this AI Foundry Hub.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['HubEncryptionArgs']]:
        """
        An `encryption` block as defined below. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['HubEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of this AI Foundry Hub.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @_builtins.property
    @pulumi.getter(name="highBusinessImpactEnabled")
    def high_business_impact_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Hub to be created. Defaults to `false`.

        > **Note:** `high_business_impact_enabled` will be enabled by default when creating an AI Foundry Hub with `encryption` enabled.
        """
        return pulumi.get(self, "high_business_impact_enabled")

    @high_business_impact_enabled.setter
    def high_business_impact_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "high_business_impact_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedNetwork")
    def managed_network(self) -> Optional[pulumi.Input['HubManagedNetworkArgs']]:
        """
        A `managed_network` block as defined below.
        """
        return pulumi.get(self, "managed_network")

    @managed_network.setter
    def managed_network(self, value: Optional[pulumi.Input['HubManagedNetworkArgs']]):
        pulumi.set(self, "managed_network", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentity")
    def primary_user_assigned_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        """
        return pulumi.get(self, "primary_user_assigned_identity")

    @primary_user_assigned_identity.setter
    def primary_user_assigned_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_user_assigned_identity", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether public network access for this AI Service Hub should be enabled. Possible values include `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the AI Foundry Hub.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _HubState:
    def __init__(__self__, *,
                 application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 discovery_url: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input['HubEncryptionArgs']] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_business_impact_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['HubIdentityArgs']] = None,
                 key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_network: Optional[pulumi.Input['HubManagedNetworkArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Hub resources.
        :param pulumi.Input[_builtins.str] application_insights_id: The Application Insights ID that should be used by this AI Foundry Hub.
        :param pulumi.Input[_builtins.str] container_registry_id: The Container Registry ID that should be used by this AI Foundry Hub.
        :param pulumi.Input[_builtins.str] description: The description of this AI Foundry Hub.
        :param pulumi.Input[_builtins.str] discovery_url: The URL for the discovery service to identify regional endpoints for AI Foundry Hub services.
        :param pulumi.Input['HubEncryptionArgs'] encryption: An `encryption` block as defined below. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] friendly_name: The display name of this AI Foundry Hub.
        :param pulumi.Input[_builtins.bool] high_business_impact_enabled: Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Hub to be created. Defaults to `false`.
               
               > **Note:** `high_business_impact_enabled` will be enabled by default when creating an AI Foundry Hub with `encryption` enabled.
        :param pulumi.Input['HubIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] key_vault_id: The Key Vault ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input['HubManagedNetworkArgs'] managed_network: A `managed_network` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity: The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access for this AI Service Hub should be enabled. Possible values include `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The Storage Account ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the AI Foundry Hub.
        :param pulumi.Input[_builtins.str] workspace_id: The immutable ID associated with this AI Foundry Hub.
        """
        if application_insights_id is not None:
            pulumi.set(__self__, "application_insights_id", application_insights_id)
        if container_registry_id is not None:
            pulumi.set(__self__, "container_registry_id", container_registry_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if discovery_url is not None:
            pulumi.set(__self__, "discovery_url", discovery_url)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if high_business_impact_enabled is not None:
            pulumi.set(__self__, "high_business_impact_enabled", high_business_impact_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_network is not None:
            pulumi.set(__self__, "managed_network", managed_network)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_user_assigned_identity is not None:
            pulumi.set(__self__, "primary_user_assigned_identity", primary_user_assigned_identity)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsId")
    def application_insights_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Application Insights ID that should be used by this AI Foundry Hub.
        """
        return pulumi.get(self, "application_insights_id")

    @application_insights_id.setter
    def application_insights_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_insights_id", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Container Registry ID that should be used by this AI Foundry Hub.
        """
        return pulumi.get(self, "container_registry_id")

    @container_registry_id.setter
    def container_registry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_registry_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this AI Foundry Hub.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL for the discovery service to identify regional endpoints for AI Foundry Hub services.
        """
        return pulumi.get(self, "discovery_url")

    @discovery_url.setter
    def discovery_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "discovery_url", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['HubEncryptionArgs']]:
        """
        An `encryption` block as defined below. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['HubEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of this AI Foundry Hub.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @_builtins.property
    @pulumi.getter(name="highBusinessImpactEnabled")
    def high_business_impact_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Hub to be created. Defaults to `false`.

        > **Note:** `high_business_impact_enabled` will be enabled by default when creating an AI Foundry Hub with `encryption` enabled.
        """
        return pulumi.get(self, "high_business_impact_enabled")

    @high_business_impact_enabled.setter
    def high_business_impact_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "high_business_impact_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['HubIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['HubIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Key Vault ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedNetwork")
    def managed_network(self) -> Optional[pulumi.Input['HubManagedNetworkArgs']]:
        """
        A `managed_network` block as defined below.
        """
        return pulumi.get(self, "managed_network")

    @managed_network.setter
    def managed_network(self, value: Optional[pulumi.Input['HubManagedNetworkArgs']]):
        pulumi.set(self, "managed_network", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentity")
    def primary_user_assigned_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        """
        return pulumi.get(self, "primary_user_assigned_identity")

    @primary_user_assigned_identity.setter
    def primary_user_assigned_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_user_assigned_identity", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether public network access for this AI Service Hub should be enabled. Possible values include `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Storage Account ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the AI Foundry Hub.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The immutable ID associated with this AI Foundry Hub.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("azure:aifoundry/hub:Hub")
class Hub(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[Union['HubEncryptionArgs', 'HubEncryptionArgsDict']]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_business_impact_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['HubIdentityArgs', 'HubIdentityArgsDict']]] = None,
                 key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_network: Optional[pulumi.Input[Union['HubManagedNetworkArgs', 'HubManagedNetworkArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an AI Foundry Hub.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example",
            location="westeurope")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        test = azure.keyvault.AccessPolicy("test",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Get",
                "Delete",
                "Purge",
                "GetRotationPolicy",
            ])
        example_account = azure.storage.Account("example",
            name="examplesa",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="LRS")
        example_ai_services = azure.cognitive.AIServices("example",
            name="exampleaiservices",
            location=example.location,
            resource_group_name=example.name,
            sku_name="S0")
        example_hub = azure.aifoundry.Hub("example",
            name="exampleaihub",
            location=example_ai_services.location,
            resource_group_name=example.name,
            storage_account_id=example_account.id,
            key_vault_id=example_key_vault.id,
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices`: 2024-04-01

        ## Import

        AI Foundry Hubs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:aifoundry/hub:Hub example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.MachineLearningServices/workspaces/hub1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_insights_id: The Application Insights ID that should be used by this AI Foundry Hub.
        :param pulumi.Input[_builtins.str] container_registry_id: The Container Registry ID that should be used by this AI Foundry Hub.
        :param pulumi.Input[_builtins.str] description: The description of this AI Foundry Hub.
        :param pulumi.Input[Union['HubEncryptionArgs', 'HubEncryptionArgsDict']] encryption: An `encryption` block as defined below. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] friendly_name: The display name of this AI Foundry Hub.
        :param pulumi.Input[_builtins.bool] high_business_impact_enabled: Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Hub to be created. Defaults to `false`.
               
               > **Note:** `high_business_impact_enabled` will be enabled by default when creating an AI Foundry Hub with `encryption` enabled.
        :param pulumi.Input[Union['HubIdentityArgs', 'HubIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] key_vault_id: The Key Vault ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[Union['HubManagedNetworkArgs', 'HubManagedNetworkArgsDict']] managed_network: A `managed_network` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity: The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access for this AI Service Hub should be enabled. Possible values include `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The Storage Account ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the AI Foundry Hub.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HubArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AI Foundry Hub.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example",
            location="westeurope")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        test = azure.keyvault.AccessPolicy("test",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Get",
                "Delete",
                "Purge",
                "GetRotationPolicy",
            ])
        example_account = azure.storage.Account("example",
            name="examplesa",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="LRS")
        example_ai_services = azure.cognitive.AIServices("example",
            name="exampleaiservices",
            location=example.location,
            resource_group_name=example.name,
            sku_name="S0")
        example_hub = azure.aifoundry.Hub("example",
            name="exampleaihub",
            location=example_ai_services.location,
            resource_group_name=example.name,
            storage_account_id=example_account.id,
            key_vault_id=example_key_vault.id,
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices`: 2024-04-01

        ## Import

        AI Foundry Hubs can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:aifoundry/hub:Hub example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.MachineLearningServices/workspaces/hub1
        ```

        :param str resource_name: The name of the resource.
        :param HubArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HubArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[Union['HubEncryptionArgs', 'HubEncryptionArgsDict']]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_business_impact_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['HubIdentityArgs', 'HubIdentityArgsDict']]] = None,
                 key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_network: Optional[pulumi.Input[Union['HubManagedNetworkArgs', 'HubManagedNetworkArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HubArgs.__new__(HubArgs)

            __props__.__dict__["application_insights_id"] = application_insights_id
            __props__.__dict__["container_registry_id"] = container_registry_id
            __props__.__dict__["description"] = description
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["friendly_name"] = friendly_name
            __props__.__dict__["high_business_impact_enabled"] = high_business_impact_enabled
            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            if key_vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_vault_id'")
            __props__.__dict__["key_vault_id"] = key_vault_id
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_network"] = managed_network
            __props__.__dict__["name"] = name
            __props__.__dict__["primary_user_assigned_identity"] = primary_user_assigned_identity
            __props__.__dict__["public_network_access"] = public_network_access
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_id'")
            __props__.__dict__["storage_account_id"] = storage_account_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["discovery_url"] = None
            __props__.__dict__["workspace_id"] = None
        super(Hub, __self__).__init__(
            'azure:aifoundry/hub:Hub',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
            container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            discovery_url: Optional[pulumi.Input[_builtins.str]] = None,
            encryption: Optional[pulumi.Input[Union['HubEncryptionArgs', 'HubEncryptionArgsDict']]] = None,
            friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
            high_business_impact_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['HubIdentityArgs', 'HubIdentityArgsDict']]] = None,
            key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            managed_network: Optional[pulumi.Input[Union['HubManagedNetworkArgs', 'HubManagedNetworkArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Hub':
        """
        Get an existing Hub resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_insights_id: The Application Insights ID that should be used by this AI Foundry Hub.
        :param pulumi.Input[_builtins.str] container_registry_id: The Container Registry ID that should be used by this AI Foundry Hub.
        :param pulumi.Input[_builtins.str] description: The description of this AI Foundry Hub.
        :param pulumi.Input[_builtins.str] discovery_url: The URL for the discovery service to identify regional endpoints for AI Foundry Hub services.
        :param pulumi.Input[Union['HubEncryptionArgs', 'HubEncryptionArgsDict']] encryption: An `encryption` block as defined below. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] friendly_name: The display name of this AI Foundry Hub.
        :param pulumi.Input[_builtins.bool] high_business_impact_enabled: Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Hub to be created. Defaults to `false`.
               
               > **Note:** `high_business_impact_enabled` will be enabled by default when creating an AI Foundry Hub with `encryption` enabled.
        :param pulumi.Input[Union['HubIdentityArgs', 'HubIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] key_vault_id: The Key Vault ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[Union['HubManagedNetworkArgs', 'HubManagedNetworkArgsDict']] managed_network: A `managed_network` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity: The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access for this AI Service Hub should be enabled. Possible values include `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The Storage Account ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the AI Foundry Hub.
        :param pulumi.Input[_builtins.str] workspace_id: The immutable ID associated with this AI Foundry Hub.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HubState.__new__(_HubState)

        __props__.__dict__["application_insights_id"] = application_insights_id
        __props__.__dict__["container_registry_id"] = container_registry_id
        __props__.__dict__["description"] = description
        __props__.__dict__["discovery_url"] = discovery_url
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["high_business_impact_enabled"] = high_business_impact_enabled
        __props__.__dict__["identity"] = identity
        __props__.__dict__["key_vault_id"] = key_vault_id
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_network"] = managed_network
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_user_assigned_identity"] = primary_user_assigned_identity
        __props__.__dict__["public_network_access"] = public_network_access
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["storage_account_id"] = storage_account_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["workspace_id"] = workspace_id
        return Hub(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsId")
    def application_insights_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Application Insights ID that should be used by this AI Foundry Hub.
        """
        return pulumi.get(self, "application_insights_id")

    @_builtins.property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Container Registry ID that should be used by this AI Foundry Hub.
        """
        return pulumi.get(self, "container_registry_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of this AI Foundry Hub.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL for the discovery service to identify regional endpoints for AI Foundry Hub services.
        """
        return pulumi.get(self, "discovery_url")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional['outputs.HubEncryption']]:
        """
        An `encryption` block as defined below. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The display name of this AI Foundry Hub.
        """
        return pulumi.get(self, "friendly_name")

    @_builtins.property
    @pulumi.getter(name="highBusinessImpactEnabled")
    def high_business_impact_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether High Business Impact (HBI) should be enabled or not. Enabling this setting will reduce diagnostic data collected by the service. Changing this forces a new AI Foundry Hub to be created. Defaults to `false`.

        > **Note:** `high_business_impact_enabled` will be enabled by default when creating an AI Foundry Hub with `encryption` enabled.
        """
        return pulumi.get(self, "high_business_impact_enabled")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.HubIdentity']:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Key Vault ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedNetwork")
    def managed_network(self) -> pulumi.Output['outputs.HubManagedNetwork']:
        """
        A `managed_network` block as defined below.
        """
        return pulumi.get(self, "managed_network")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentity")
    def primary_user_assigned_identity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user assigned identity ID that represents the AI Foundry Hub identity. This must be set when enabling encryption with a user assigned identity.
        """
        return pulumi.get(self, "primary_user_assigned_identity")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether public network access for this AI Service Hub should be enabled. Possible values include `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the AI Foundry Hub should exist. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Storage Account ID that should be used by this AI Foundry Hub. Changing this forces a new AI Foundry Hub to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the AI Foundry Hub.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The immutable ID associated with this AI Foundry Hub.
        """
        return pulumi.get(self, "workspace_id")

