# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthorizationServerArgs', 'AuthorizationServer']

@pulumi.input_type
class AuthorizationServerArgs:
    def __init__(__self__, *,
                 api_management_name: pulumi.Input[_builtins.str],
                 authorization_endpoint: pulumi.Input[_builtins.str],
                 authorization_methods: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 client_id: pulumi.Input[_builtins.str],
                 client_registration_endpoint: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 grant_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 resource_group_name: pulumi.Input[_builtins.str],
                 bearer_token_sending_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 default_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_owner_password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_owner_username: Optional[pulumi.Input[_builtins.str]] = None,
                 support_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_body_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationServerTokenBodyParameterArgs']]]] = None,
                 token_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AuthorizationServer resource.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service in which this Authorization Server should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] authorization_endpoint: The OAUTH Authorization Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorization_methods: The HTTP Verbs supported by the Authorization Endpoint. Possible values are `DELETE`, `GET`, `HEAD`, `OPTIONS`, `PATCH`, `POST`, `PUT` and `TRACE`.
               
               > **Note:** `GET` must always be present.
        :param pulumi.Input[_builtins.str] client_id: The Client/App ID registered with this Authorization Server.
        :param pulumi.Input[_builtins.str] client_registration_endpoint: The URI of page where Client/App Registration is performed for this Authorization Server.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name of this Authorization Server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grant_types: Form of Authorization Grants required when requesting an Access Token. Possible values are `authorizationCode`, `clientCredentials`, `implicit` and `resourceOwnerPassword`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bearer_token_sending_methods: The mechanism by which Access Tokens are passed to the API. Possible values are `authorizationHeader` and `query`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_authentication_methods: The Authentication Methods supported by the Token endpoint of this Authorization Server.. Possible values are `Basic` and `Body`.
        :param pulumi.Input[_builtins.str] client_secret: The Client/App Secret registered with this Authorization Server.
        :param pulumi.Input[_builtins.str] default_scope: The Default Scope used when requesting an Access Token, specified as a string containing space-delimited values.
        :param pulumi.Input[_builtins.str] description: A description of the Authorization Server, which may contain HTML formatting tags.
        :param pulumi.Input[_builtins.str] name: The name of this Authorization Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_owner_password: The password associated with the Resource Owner.
               
               > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        :param pulumi.Input[_builtins.str] resource_owner_username: The username associated with the Resource Owner.
               
               > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        :param pulumi.Input[_builtins.bool] support_state: Does this Authorization Server support State? If this is set to `true` the client may use the state parameter to raise protocol security.
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizationServerTokenBodyParameterArgs']]] token_body_parameters: A `token_body_parameter` block as defined below.
        :param pulumi.Input[_builtins.str] token_endpoint: The OAUTH Token Endpoint.
        """
        pulumi.set(__self__, "api_management_name", api_management_name)
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "authorization_methods", authorization_methods)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_registration_endpoint", client_registration_endpoint)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "grant_types", grant_types)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if bearer_token_sending_methods is not None:
            pulumi.set(__self__, "bearer_token_sending_methods", bearer_token_sending_methods)
        if client_authentication_methods is not None:
            pulumi.set(__self__, "client_authentication_methods", client_authentication_methods)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if default_scope is not None:
            pulumi.set(__self__, "default_scope", default_scope)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_owner_password is not None:
            pulumi.set(__self__, "resource_owner_password", resource_owner_password)
        if resource_owner_username is not None:
            pulumi.set(__self__, "resource_owner_username", resource_owner_username)
        if support_state is not None:
            pulumi.set(__self__, "support_state", support_state)
        if token_body_parameters is not None:
            pulumi.set(__self__, "token_body_parameters", token_body_parameters)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the API Management Service in which this Authorization Server should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The OAUTH Authorization Endpoint.
        """
        return pulumi.get(self, "authorization_endpoint")

    @authorization_endpoint.setter
    def authorization_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authorization_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="authorizationMethods")
    def authorization_methods(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The HTTP Verbs supported by the Authorization Endpoint. Possible values are `DELETE`, `GET`, `HEAD`, `OPTIONS`, `PATCH`, `POST`, `PUT` and `TRACE`.

        > **Note:** `GET` must always be present.
        """
        return pulumi.get(self, "authorization_methods")

    @authorization_methods.setter
    def authorization_methods(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "authorization_methods", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Client/App ID registered with this Authorization Server.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientRegistrationEndpoint")
    def client_registration_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        The URI of page where Client/App Registration is performed for this Authorization Server.
        """
        return pulumi.get(self, "client_registration_endpoint")

    @client_registration_endpoint.setter
    def client_registration_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_registration_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The user-friendly name of this Authorization Server.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Form of Authorization Grants required when requesting an Access Token. Possible values are `authorizationCode`, `clientCredentials`, `implicit` and `resourceOwnerPassword`.
        """
        return pulumi.get(self, "grant_types")

    @grant_types.setter
    def grant_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "grant_types", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="bearerTokenSendingMethods")
    def bearer_token_sending_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The mechanism by which Access Tokens are passed to the API. Possible values are `authorizationHeader` and `query`.
        """
        return pulumi.get(self, "bearer_token_sending_methods")

    @bearer_token_sending_methods.setter
    def bearer_token_sending_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bearer_token_sending_methods", value)

    @_builtins.property
    @pulumi.getter(name="clientAuthenticationMethods")
    def client_authentication_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Authentication Methods supported by the Token endpoint of this Authorization Server.. Possible values are `Basic` and `Body`.
        """
        return pulumi.get(self, "client_authentication_methods")

    @client_authentication_methods.setter
    def client_authentication_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "client_authentication_methods", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client/App Secret registered with this Authorization Server.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="defaultScope")
    def default_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Default Scope used when requesting an Access Token, specified as a string containing space-delimited values.
        """
        return pulumi.get(self, "default_scope")

    @default_scope.setter
    def default_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_scope", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the Authorization Server, which may contain HTML formatting tags.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of this Authorization Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceOwnerPassword")
    def resource_owner_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password associated with the Resource Owner.

        > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        """
        return pulumi.get(self, "resource_owner_password")

    @resource_owner_password.setter
    def resource_owner_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_owner_password", value)

    @_builtins.property
    @pulumi.getter(name="resourceOwnerUsername")
    def resource_owner_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username associated with the Resource Owner.

        > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        """
        return pulumi.get(self, "resource_owner_username")

    @resource_owner_username.setter
    def resource_owner_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_owner_username", value)

    @_builtins.property
    @pulumi.getter(name="supportState")
    def support_state(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Does this Authorization Server support State? If this is set to `true` the client may use the state parameter to raise protocol security.
        """
        return pulumi.get(self, "support_state")

    @support_state.setter
    def support_state(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "support_state", value)

    @_builtins.property
    @pulumi.getter(name="tokenBodyParameters")
    def token_body_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationServerTokenBodyParameterArgs']]]]:
        """
        A `token_body_parameter` block as defined below.
        """
        return pulumi.get(self, "token_body_parameters")

    @token_body_parameters.setter
    def token_body_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationServerTokenBodyParameterArgs']]]]):
        pulumi.set(self, "token_body_parameters", value)

    @_builtins.property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OAUTH Token Endpoint.
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_endpoint", value)


@pulumi.input_type
class _AuthorizationServerState:
    def __init__(__self__, *,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bearer_token_sending_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_registration_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 default_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_owner_password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_owner_username: Optional[pulumi.Input[_builtins.str]] = None,
                 support_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_body_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationServerTokenBodyParameterArgs']]]] = None,
                 token_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthorizationServer resources.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service in which this Authorization Server should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] authorization_endpoint: The OAUTH Authorization Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorization_methods: The HTTP Verbs supported by the Authorization Endpoint. Possible values are `DELETE`, `GET`, `HEAD`, `OPTIONS`, `PATCH`, `POST`, `PUT` and `TRACE`.
               
               > **Note:** `GET` must always be present.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bearer_token_sending_methods: The mechanism by which Access Tokens are passed to the API. Possible values are `authorizationHeader` and `query`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_authentication_methods: The Authentication Methods supported by the Token endpoint of this Authorization Server.. Possible values are `Basic` and `Body`.
        :param pulumi.Input[_builtins.str] client_id: The Client/App ID registered with this Authorization Server.
        :param pulumi.Input[_builtins.str] client_registration_endpoint: The URI of page where Client/App Registration is performed for this Authorization Server.
        :param pulumi.Input[_builtins.str] client_secret: The Client/App Secret registered with this Authorization Server.
        :param pulumi.Input[_builtins.str] default_scope: The Default Scope used when requesting an Access Token, specified as a string containing space-delimited values.
        :param pulumi.Input[_builtins.str] description: A description of the Authorization Server, which may contain HTML formatting tags.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name of this Authorization Server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grant_types: Form of Authorization Grants required when requesting an Access Token. Possible values are `authorizationCode`, `clientCredentials`, `implicit` and `resourceOwnerPassword`.
        :param pulumi.Input[_builtins.str] name: The name of this Authorization Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_owner_password: The password associated with the Resource Owner.
               
               > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        :param pulumi.Input[_builtins.str] resource_owner_username: The username associated with the Resource Owner.
               
               > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        :param pulumi.Input[_builtins.bool] support_state: Does this Authorization Server support State? If this is set to `true` the client may use the state parameter to raise protocol security.
        :param pulumi.Input[Sequence[pulumi.Input['AuthorizationServerTokenBodyParameterArgs']]] token_body_parameters: A `token_body_parameter` block as defined below.
        :param pulumi.Input[_builtins.str] token_endpoint: The OAUTH Token Endpoint.
        """
        if api_management_name is not None:
            pulumi.set(__self__, "api_management_name", api_management_name)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if authorization_methods is not None:
            pulumi.set(__self__, "authorization_methods", authorization_methods)
        if bearer_token_sending_methods is not None:
            pulumi.set(__self__, "bearer_token_sending_methods", bearer_token_sending_methods)
        if client_authentication_methods is not None:
            pulumi.set(__self__, "client_authentication_methods", client_authentication_methods)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_registration_endpoint is not None:
            pulumi.set(__self__, "client_registration_endpoint", client_registration_endpoint)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if default_scope is not None:
            pulumi.set(__self__, "default_scope", default_scope)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if grant_types is not None:
            pulumi.set(__self__, "grant_types", grant_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if resource_owner_password is not None:
            pulumi.set(__self__, "resource_owner_password", resource_owner_password)
        if resource_owner_username is not None:
            pulumi.set(__self__, "resource_owner_username", resource_owner_username)
        if support_state is not None:
            pulumi.set(__self__, "support_state", support_state)
        if token_body_parameters is not None:
            pulumi.set(__self__, "token_body_parameters", token_body_parameters)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management Service in which this Authorization Server should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OAUTH Authorization Endpoint.
        """
        return pulumi.get(self, "authorization_endpoint")

    @authorization_endpoint.setter
    def authorization_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="authorizationMethods")
    def authorization_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The HTTP Verbs supported by the Authorization Endpoint. Possible values are `DELETE`, `GET`, `HEAD`, `OPTIONS`, `PATCH`, `POST`, `PUT` and `TRACE`.

        > **Note:** `GET` must always be present.
        """
        return pulumi.get(self, "authorization_methods")

    @authorization_methods.setter
    def authorization_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorization_methods", value)

    @_builtins.property
    @pulumi.getter(name="bearerTokenSendingMethods")
    def bearer_token_sending_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The mechanism by which Access Tokens are passed to the API. Possible values are `authorizationHeader` and `query`.
        """
        return pulumi.get(self, "bearer_token_sending_methods")

    @bearer_token_sending_methods.setter
    def bearer_token_sending_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "bearer_token_sending_methods", value)

    @_builtins.property
    @pulumi.getter(name="clientAuthenticationMethods")
    def client_authentication_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Authentication Methods supported by the Token endpoint of this Authorization Server.. Possible values are `Basic` and `Body`.
        """
        return pulumi.get(self, "client_authentication_methods")

    @client_authentication_methods.setter
    def client_authentication_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "client_authentication_methods", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client/App ID registered with this Authorization Server.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientRegistrationEndpoint")
    def client_registration_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of page where Client/App Registration is performed for this Authorization Server.
        """
        return pulumi.get(self, "client_registration_endpoint")

    @client_registration_endpoint.setter
    def client_registration_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_registration_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client/App Secret registered with this Authorization Server.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="defaultScope")
    def default_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Default Scope used when requesting an Access Token, specified as a string containing space-delimited values.
        """
        return pulumi.get(self, "default_scope")

    @default_scope.setter
    def default_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_scope", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the Authorization Server, which may contain HTML formatting tags.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-friendly name of this Authorization Server.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Form of Authorization Grants required when requesting an Access Token. Possible values are `authorizationCode`, `clientCredentials`, `implicit` and `resourceOwnerPassword`.
        """
        return pulumi.get(self, "grant_types")

    @grant_types.setter
    def grant_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "grant_types", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of this Authorization Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceOwnerPassword")
    def resource_owner_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password associated with the Resource Owner.

        > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        """
        return pulumi.get(self, "resource_owner_password")

    @resource_owner_password.setter
    def resource_owner_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_owner_password", value)

    @_builtins.property
    @pulumi.getter(name="resourceOwnerUsername")
    def resource_owner_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username associated with the Resource Owner.

        > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        """
        return pulumi.get(self, "resource_owner_username")

    @resource_owner_username.setter
    def resource_owner_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_owner_username", value)

    @_builtins.property
    @pulumi.getter(name="supportState")
    def support_state(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Does this Authorization Server support State? If this is set to `true` the client may use the state parameter to raise protocol security.
        """
        return pulumi.get(self, "support_state")

    @support_state.setter
    def support_state(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "support_state", value)

    @_builtins.property
    @pulumi.getter(name="tokenBodyParameters")
    def token_body_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationServerTokenBodyParameterArgs']]]]:
        """
        A `token_body_parameter` block as defined below.
        """
        return pulumi.get(self, "token_body_parameters")

    @token_body_parameters.setter
    def token_body_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthorizationServerTokenBodyParameterArgs']]]]):
        pulumi.set(self, "token_body_parameters", value)

    @_builtins.property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OAUTH Token Endpoint.
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_endpoint", value)


@pulumi.type_token("azure:apimanagement/authorizationServer:AuthorizationServer")
class AuthorizationServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bearer_token_sending_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_registration_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 default_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_owner_password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_owner_username: Optional[pulumi.Input[_builtins.str]] = None,
                 support_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_body_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationServerTokenBodyParameterArgs', 'AuthorizationServerTokenBodyParameterArgsDict']]]]] = None,
                 token_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Authorization Server within an API Management Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.apimanagement.get_service(name="search-api",
            resource_group_name="search-service")
        example_authorization_server = azure.apimanagement.AuthorizationServer("example",
            name="test-server",
            api_management_name=example.name,
            resource_group_name=example.resource_group_name,
            display_name="Test Server",
            authorization_endpoint="https://example.mydomain.com/client/authorize",
            client_id="42424242-4242-4242-4242-424242424242",
            client_registration_endpoint="https://example.mydomain.com/client/register",
            grant_types=["authorizationCode"],
            authorization_methods=["GET"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Authorization Servers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/authorizationServer:AuthorizationServer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1/authorizationServers/server1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service in which this Authorization Server should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] authorization_endpoint: The OAUTH Authorization Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorization_methods: The HTTP Verbs supported by the Authorization Endpoint. Possible values are `DELETE`, `GET`, `HEAD`, `OPTIONS`, `PATCH`, `POST`, `PUT` and `TRACE`.
               
               > **Note:** `GET` must always be present.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bearer_token_sending_methods: The mechanism by which Access Tokens are passed to the API. Possible values are `authorizationHeader` and `query`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_authentication_methods: The Authentication Methods supported by the Token endpoint of this Authorization Server.. Possible values are `Basic` and `Body`.
        :param pulumi.Input[_builtins.str] client_id: The Client/App ID registered with this Authorization Server.
        :param pulumi.Input[_builtins.str] client_registration_endpoint: The URI of page where Client/App Registration is performed for this Authorization Server.
        :param pulumi.Input[_builtins.str] client_secret: The Client/App Secret registered with this Authorization Server.
        :param pulumi.Input[_builtins.str] default_scope: The Default Scope used when requesting an Access Token, specified as a string containing space-delimited values.
        :param pulumi.Input[_builtins.str] description: A description of the Authorization Server, which may contain HTML formatting tags.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name of this Authorization Server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grant_types: Form of Authorization Grants required when requesting an Access Token. Possible values are `authorizationCode`, `clientCredentials`, `implicit` and `resourceOwnerPassword`.
        :param pulumi.Input[_builtins.str] name: The name of this Authorization Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_owner_password: The password associated with the Resource Owner.
               
               > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        :param pulumi.Input[_builtins.str] resource_owner_username: The username associated with the Resource Owner.
               
               > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        :param pulumi.Input[_builtins.bool] support_state: Does this Authorization Server support State? If this is set to `true` the client may use the state parameter to raise protocol security.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationServerTokenBodyParameterArgs', 'AuthorizationServerTokenBodyParameterArgsDict']]]] token_body_parameters: A `token_body_parameter` block as defined below.
        :param pulumi.Input[_builtins.str] token_endpoint: The OAUTH Token Endpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthorizationServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Authorization Server within an API Management Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.apimanagement.get_service(name="search-api",
            resource_group_name="search-service")
        example_authorization_server = azure.apimanagement.AuthorizationServer("example",
            name="test-server",
            api_management_name=example.name,
            resource_group_name=example.resource_group_name,
            display_name="Test Server",
            authorization_endpoint="https://example.mydomain.com/client/authorize",
            client_id="42424242-4242-4242-4242-424242424242",
            client_registration_endpoint="https://example.mydomain.com/client/register",
            grant_types=["authorizationCode"],
            authorization_methods=["GET"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Authorization Servers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/authorizationServer:AuthorizationServer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1/authorizationServers/server1
        ```

        :param str resource_name: The name of the resource.
        :param AuthorizationServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorizationServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bearer_token_sending_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_registration_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 default_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_owner_password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_owner_username: Optional[pulumi.Input[_builtins.str]] = None,
                 support_state: Optional[pulumi.Input[_builtins.bool]] = None,
                 token_body_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationServerTokenBodyParameterArgs', 'AuthorizationServerTokenBodyParameterArgsDict']]]]] = None,
                 token_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorizationServerArgs.__new__(AuthorizationServerArgs)

            if api_management_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_name'")
            __props__.__dict__["api_management_name"] = api_management_name
            if authorization_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'authorization_endpoint'")
            __props__.__dict__["authorization_endpoint"] = authorization_endpoint
            if authorization_methods is None and not opts.urn:
                raise TypeError("Missing required property 'authorization_methods'")
            __props__.__dict__["authorization_methods"] = authorization_methods
            __props__.__dict__["bearer_token_sending_methods"] = bearer_token_sending_methods
            __props__.__dict__["client_authentication_methods"] = client_authentication_methods
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            if client_registration_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'client_registration_endpoint'")
            __props__.__dict__["client_registration_endpoint"] = client_registration_endpoint
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["default_scope"] = default_scope
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if grant_types is None and not opts.urn:
                raise TypeError("Missing required property 'grant_types'")
            __props__.__dict__["grant_types"] = grant_types
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["resource_owner_password"] = None if resource_owner_password is None else pulumi.Output.secret(resource_owner_password)
            __props__.__dict__["resource_owner_username"] = resource_owner_username
            __props__.__dict__["support_state"] = support_state
            __props__.__dict__["token_body_parameters"] = token_body_parameters
            __props__.__dict__["token_endpoint"] = token_endpoint
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret", "resourceOwnerPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthorizationServer, __self__).__init__(
            'azure:apimanagement/authorizationServer:AuthorizationServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
            authorization_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            authorization_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bearer_token_sending_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            client_authentication_methods: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            client_registration_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            client_secret: Optional[pulumi.Input[_builtins.str]] = None,
            default_scope: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            grant_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_owner_password: Optional[pulumi.Input[_builtins.str]] = None,
            resource_owner_username: Optional[pulumi.Input[_builtins.str]] = None,
            support_state: Optional[pulumi.Input[_builtins.bool]] = None,
            token_body_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationServerTokenBodyParameterArgs', 'AuthorizationServerTokenBodyParameterArgsDict']]]]] = None,
            token_endpoint: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthorizationServer':
        """
        Get an existing AuthorizationServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The name of the API Management Service in which this Authorization Server should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] authorization_endpoint: The OAUTH Authorization Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorization_methods: The HTTP Verbs supported by the Authorization Endpoint. Possible values are `DELETE`, `GET`, `HEAD`, `OPTIONS`, `PATCH`, `POST`, `PUT` and `TRACE`.
               
               > **Note:** `GET` must always be present.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] bearer_token_sending_methods: The mechanism by which Access Tokens are passed to the API. Possible values are `authorizationHeader` and `query`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_authentication_methods: The Authentication Methods supported by the Token endpoint of this Authorization Server.. Possible values are `Basic` and `Body`.
        :param pulumi.Input[_builtins.str] client_id: The Client/App ID registered with this Authorization Server.
        :param pulumi.Input[_builtins.str] client_registration_endpoint: The URI of page where Client/App Registration is performed for this Authorization Server.
        :param pulumi.Input[_builtins.str] client_secret: The Client/App Secret registered with this Authorization Server.
        :param pulumi.Input[_builtins.str] default_scope: The Default Scope used when requesting an Access Token, specified as a string containing space-delimited values.
        :param pulumi.Input[_builtins.str] description: A description of the Authorization Server, which may contain HTML formatting tags.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name of this Authorization Server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] grant_types: Form of Authorization Grants required when requesting an Access Token. Possible values are `authorizationCode`, `clientCredentials`, `implicit` and `resourceOwnerPassword`.
        :param pulumi.Input[_builtins.str] name: The name of this Authorization Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_owner_password: The password associated with the Resource Owner.
               
               > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        :param pulumi.Input[_builtins.str] resource_owner_username: The username associated with the Resource Owner.
               
               > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        :param pulumi.Input[_builtins.bool] support_state: Does this Authorization Server support State? If this is set to `true` the client may use the state parameter to raise protocol security.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthorizationServerTokenBodyParameterArgs', 'AuthorizationServerTokenBodyParameterArgsDict']]]] token_body_parameters: A `token_body_parameter` block as defined below.
        :param pulumi.Input[_builtins.str] token_endpoint: The OAUTH Token Endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthorizationServerState.__new__(_AuthorizationServerState)

        __props__.__dict__["api_management_name"] = api_management_name
        __props__.__dict__["authorization_endpoint"] = authorization_endpoint
        __props__.__dict__["authorization_methods"] = authorization_methods
        __props__.__dict__["bearer_token_sending_methods"] = bearer_token_sending_methods
        __props__.__dict__["client_authentication_methods"] = client_authentication_methods
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_registration_endpoint"] = client_registration_endpoint
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["default_scope"] = default_scope
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["grant_types"] = grant_types
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["resource_owner_password"] = resource_owner_password
        __props__.__dict__["resource_owner_username"] = resource_owner_username
        __props__.__dict__["support_state"] = support_state
        __props__.__dict__["token_body_parameters"] = token_body_parameters
        __props__.__dict__["token_endpoint"] = token_endpoint
        return AuthorizationServer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the API Management Service in which this Authorization Server should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @_builtins.property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The OAUTH Authorization Endpoint.
        """
        return pulumi.get(self, "authorization_endpoint")

    @_builtins.property
    @pulumi.getter(name="authorizationMethods")
    def authorization_methods(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The HTTP Verbs supported by the Authorization Endpoint. Possible values are `DELETE`, `GET`, `HEAD`, `OPTIONS`, `PATCH`, `POST`, `PUT` and `TRACE`.

        > **Note:** `GET` must always be present.
        """
        return pulumi.get(self, "authorization_methods")

    @_builtins.property
    @pulumi.getter(name="bearerTokenSendingMethods")
    def bearer_token_sending_methods(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The mechanism by which Access Tokens are passed to the API. Possible values are `authorizationHeader` and `query`.
        """
        return pulumi.get(self, "bearer_token_sending_methods")

    @_builtins.property
    @pulumi.getter(name="clientAuthenticationMethods")
    def client_authentication_methods(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The Authentication Methods supported by the Token endpoint of this Authorization Server.. Possible values are `Basic` and `Body`.
        """
        return pulumi.get(self, "client_authentication_methods")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Client/App ID registered with this Authorization Server.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientRegistrationEndpoint")
    def client_registration_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of page where Client/App Registration is performed for this Authorization Server.
        """
        return pulumi.get(self, "client_registration_endpoint")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Client/App Secret registered with this Authorization Server.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="defaultScope")
    def default_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Default Scope used when requesting an Access Token, specified as a string containing space-delimited values.
        """
        return pulumi.get(self, "default_scope")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the Authorization Server, which may contain HTML formatting tags.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The user-friendly name of this Authorization Server.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="grantTypes")
    def grant_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Form of Authorization Grants required when requesting an Access Token. Possible values are `authorizationCode`, `clientCredentials`, `implicit` and `resourceOwnerPassword`.
        """
        return pulumi.get(self, "grant_types")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of this Authorization Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="resourceOwnerPassword")
    def resource_owner_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password associated with the Resource Owner.

        > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        """
        return pulumi.get(self, "resource_owner_password")

    @_builtins.property
    @pulumi.getter(name="resourceOwnerUsername")
    def resource_owner_username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The username associated with the Resource Owner.

        > **Note:** This can only be specified when `grant_type` includes `resourceOwnerPassword`.
        """
        return pulumi.get(self, "resource_owner_username")

    @_builtins.property
    @pulumi.getter(name="supportState")
    def support_state(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Does this Authorization Server support State? If this is set to `true` the client may use the state parameter to raise protocol security.
        """
        return pulumi.get(self, "support_state")

    @_builtins.property
    @pulumi.getter(name="tokenBodyParameters")
    def token_body_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.AuthorizationServerTokenBodyParameter']]]:
        """
        A `token_body_parameter` block as defined below.
        """
        return pulumi.get(self, "token_body_parameters")

    @_builtins.property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The OAUTH Token Endpoint.
        """
        return pulumi.get(self, "token_endpoint")

