# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GatewayCertificateAuthorityArgs', 'GatewayCertificateAuthority']

@pulumi.input_type
class GatewayCertificateAuthorityArgs:
    def __init__(__self__, *,
                 api_management_id: pulumi.Input[_builtins.str],
                 certificate_name: pulumi.Input[_builtins.str],
                 gateway_name: pulumi.Input[_builtins.str],
                 is_trusted: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a GatewayCertificateAuthority resource.
        :param pulumi.Input[_builtins.str] api_management_id: The ID of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] certificate_name: The name of the API Management Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the API Management Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] is_trusted: Whether the API Management Gateway Certificate Authority is trusted.
        """
        pulumi.set(__self__, "api_management_id", api_management_id)
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "gateway_name", gateway_name)
        if is_trusted is not None:
            pulumi.set(__self__, "is_trusted", is_trusted)

    @_builtins.property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_id")

    @api_management_id.setter
    def api_management_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the API Management Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_name", value)

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the API Management Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gateway_name")

    @gateway_name.setter
    def gateway_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gateway_name", value)

    @_builtins.property
    @pulumi.getter(name="isTrusted")
    def is_trusted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the API Management Gateway Certificate Authority is trusted.
        """
        return pulumi.get(self, "is_trusted")

    @is_trusted.setter
    def is_trusted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_trusted", value)


@pulumi.input_type
class _GatewayCertificateAuthorityState:
    def __init__(__self__, *,
                 api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_trusted: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering GatewayCertificateAuthority resources.
        :param pulumi.Input[_builtins.str] api_management_id: The ID of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] certificate_name: The name of the API Management Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the API Management Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] is_trusted: Whether the API Management Gateway Certificate Authority is trusted.
        """
        if api_management_id is not None:
            pulumi.set(__self__, "api_management_id", api_management_id)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if gateway_name is not None:
            pulumi.set(__self__, "gateway_name", gateway_name)
        if is_trusted is not None:
            pulumi.set(__self__, "is_trusted", is_trusted)

    @_builtins.property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_id")

    @api_management_id.setter
    def api_management_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_name", value)

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gateway_name")

    @gateway_name.setter
    def gateway_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_name", value)

    @_builtins.property
    @pulumi.getter(name="isTrusted")
    def is_trusted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the API Management Gateway Certificate Authority is trusted.
        """
        return pulumi.get(self, "is_trusted")

    @is_trusted.setter
    def is_trusted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_trusted", value)


@pulumi.type_token("azure:apimanagement/gatewayCertificateAuthority:GatewayCertificateAuthority")
class GatewayCertificateAuthority(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_trusted: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages an API Management Gateway Certificate Authority.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Consumption_0")
        example_gateway = azure.apimanagement.Gateway("example",
            name="example-gateway",
            api_management_id=example_service.id,
            description="Example API Management gateway",
            location_data={
                "name": "example name",
                "city": "example city",
                "district": "example district",
                "region": "example region",
            })
        example_certificate = azure.apimanagement.Certificate("example",
            name="example-cert",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            data=std.filebase64(input="example.pfx").result)
        example_gateway_certificate_authority = azure.apimanagement.GatewayCertificateAuthority("example",
            api_management_id=example_service.id,
            certificate_name=example_certificate.name,
            gateway_name=example_gateway.name,
            is_trusted=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Gateway Certificate Authority can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/gatewayCertificateAuthority:GatewayCertificateAuthority example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1/gateways/gateway1/certificateAuthorities/cert1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_id: The ID of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] certificate_name: The name of the API Management Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the API Management Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] is_trusted: Whether the API Management Gateway Certificate Authority is trusted.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayCertificateAuthorityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API Management Gateway Certificate Authority.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="pub1",
            publisher_email="pub1@email.com",
            sku_name="Consumption_0")
        example_gateway = azure.apimanagement.Gateway("example",
            name="example-gateway",
            api_management_id=example_service.id,
            description="Example API Management gateway",
            location_data={
                "name": "example name",
                "city": "example city",
                "district": "example district",
                "region": "example region",
            })
        example_certificate = azure.apimanagement.Certificate("example",
            name="example-cert",
            api_management_name=example_service.name,
            resource_group_name=example.name,
            data=std.filebase64(input="example.pfx").result)
        example_gateway_certificate_authority = azure.apimanagement.GatewayCertificateAuthority("example",
            api_management_id=example_service.id,
            certificate_name=example_certificate.name,
            gateway_name=example_gateway.name,
            is_trusted=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement`: 2022-08-01

        ## Import

        API Management Gateway Certificate Authority can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/gatewayCertificateAuthority:GatewayCertificateAuthority example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/service/service1/gateways/gateway1/certificateAuthorities/cert1
        ```

        :param str resource_name: The name of the resource.
        :param GatewayCertificateAuthorityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayCertificateAuthorityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_trusted: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayCertificateAuthorityArgs.__new__(GatewayCertificateAuthorityArgs)

            if api_management_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_id'")
            __props__.__dict__["api_management_id"] = api_management_id
            if certificate_name is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_name'")
            __props__.__dict__["certificate_name"] = certificate_name
            if gateway_name is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_name'")
            __props__.__dict__["gateway_name"] = gateway_name
            __props__.__dict__["is_trusted"] = is_trusted
        super(GatewayCertificateAuthority, __self__).__init__(
            'azure:apimanagement/gatewayCertificateAuthority:GatewayCertificateAuthority',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
            is_trusted: Optional[pulumi.Input[_builtins.bool]] = None) -> 'GatewayCertificateAuthority':
        """
        Get an existing GatewayCertificateAuthority resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_id: The ID of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] certificate_name: The name of the API Management Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gateway_name: The name of the API Management Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] is_trusted: Whether the API Management Gateway Certificate Authority is trusted.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayCertificateAuthorityState.__new__(_GatewayCertificateAuthorityState)

        __props__.__dict__["api_management_id"] = api_management_id
        __props__.__dict__["certificate_name"] = certificate_name
        __props__.__dict__["gateway_name"] = gateway_name
        __props__.__dict__["is_trusted"] = is_trusted
        return GatewayCertificateAuthority(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_id")

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the API Management Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "certificate_name")

    @_builtins.property
    @pulumi.getter(name="gatewayName")
    def gateway_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the API Management Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gateway_name")

    @_builtins.property
    @pulumi.getter(name="isTrusted")
    def is_trusted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the API Management Gateway Certificate Authority is trusted.
        """
        return pulumi.get(self, "is_trusted")

