# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApiVersionSetResult',
    'AwaitableGetApiVersionSetResult',
    'get_api_version_set',
    'get_api_version_set_output',
]

@pulumi.output_type
class GetApiVersionSetResult:
    """
    A collection of values returned by getApiVersionSet.
    """
    def __init__(__self__, api_management_name=None, description=None, display_name=None, id=None, name=None, resource_group_name=None, version_header_name=None, version_query_name=None, versioning_scheme=None):
        if api_management_name and not isinstance(api_management_name, str):
            raise TypeError("Expected argument 'api_management_name' to be a str")
        pulumi.set(__self__, "api_management_name", api_management_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if version_header_name and not isinstance(version_header_name, str):
            raise TypeError("Expected argument 'version_header_name' to be a str")
        pulumi.set(__self__, "version_header_name", version_header_name)
        if version_query_name and not isinstance(version_query_name, str):
            raise TypeError("Expected argument 'version_query_name' to be a str")
        pulumi.set(__self__, "version_query_name", version_query_name)
        if versioning_scheme and not isinstance(versioning_scheme, str):
            raise TypeError("Expected argument 'versioning_scheme' to be a str")
        pulumi.set(__self__, "versioning_scheme", versioning_scheme)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> _builtins.str:
        return pulumi.get(self, "api_management_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of API Version Set.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of this API Version Set.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="versionHeaderName")
    def version_header_name(self) -> _builtins.str:
        """
        The name of the Header which should be read from Inbound Requests which defines the API Version.
        """
        return pulumi.get(self, "version_header_name")

    @_builtins.property
    @pulumi.getter(name="versionQueryName")
    def version_query_name(self) -> _builtins.str:
        """
        The name of the Query String which should be read from Inbound Requests which defines the API Version.
        """
        return pulumi.get(self, "version_query_name")

    @_builtins.property
    @pulumi.getter(name="versioningScheme")
    def versioning_scheme(self) -> _builtins.str:
        return pulumi.get(self, "versioning_scheme")


class AwaitableGetApiVersionSetResult(GetApiVersionSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiVersionSetResult(
            api_management_name=self.api_management_name,
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            name=self.name,
            resource_group_name=self.resource_group_name,
            version_header_name=self.version_header_name,
            version_query_name=self.version_query_name,
            versioning_scheme=self.versioning_scheme)


def get_api_version_set(api_management_name: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        resource_group_name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiVersionSetResult:
    """
    Uses this data source to access information about an API Version Set within an API Management Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_api_version_set(resource_group_name="example-resources",
        api_management_name="example-api",
        name="example-api-version-set")
    pulumi.export("apiManagementApiVersionSetId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement`: 2022-08-01


    :param _builtins.str api_management_name: The name of the API Management Service where the API Version Set exists.
    :param _builtins.str name: The name of the API Version Set.
    :param _builtins.str resource_group_name: The name of the Resource Group in which the parent API Management Service exists.
    """
    __args__ = dict()
    __args__['apiManagementName'] = api_management_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:apimanagement/getApiVersionSet:getApiVersionSet', __args__, opts=opts, typ=GetApiVersionSetResult).value

    return AwaitableGetApiVersionSetResult(
        api_management_name=pulumi.get(__ret__, 'api_management_name'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        version_header_name=pulumi.get(__ret__, 'version_header_name'),
        version_query_name=pulumi.get(__ret__, 'version_query_name'),
        versioning_scheme=pulumi.get(__ret__, 'versioning_scheme'))
def get_api_version_set_output(api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                               name: Optional[pulumi.Input[_builtins.str]] = None,
                               resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiVersionSetResult]:
    """
    Uses this data source to access information about an API Version Set within an API Management Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_api_version_set(resource_group_name="example-resources",
        api_management_name="example-api",
        name="example-api-version-set")
    pulumi.export("apiManagementApiVersionSetId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement`: 2022-08-01


    :param _builtins.str api_management_name: The name of the API Management Service where the API Version Set exists.
    :param _builtins.str name: The name of the API Version Set.
    :param _builtins.str resource_group_name: The name of the Resource Group in which the parent API Management Service exists.
    """
    __args__ = dict()
    __args__['apiManagementName'] = api_management_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:apimanagement/getApiVersionSet:getApiVersionSet', __args__, opts=opts, typ=GetApiVersionSetResult)
    return __ret__.apply(lambda __response__: GetApiVersionSetResult(
        api_management_name=pulumi.get(__response__, 'api_management_name'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        version_header_name=pulumi.get(__response__, 'version_header_name'),
        version_query_name=pulumi.get(__response__, 'version_query_name'),
        versioning_scheme=pulumi.get(__response__, 'versioning_scheme')))
