# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SpringCloudDynatraceApplicationPerformanceMonitoringArgs', 'SpringCloudDynatraceApplicationPerformanceMonitoring']

@pulumi.input_type
class SpringCloudDynatraceApplicationPerformanceMonitoringArgs:
    def __init__(__self__, *,
                 connection_point: pulumi.Input[_builtins.str],
                 spring_cloud_service_id: pulumi.Input[_builtins.str],
                 tenant: pulumi.Input[_builtins.str],
                 tenant_token: pulumi.Input[_builtins.str],
                 api_token: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SpringCloudDynatraceApplicationPerformanceMonitoring resource.
        :param pulumi.Input[_builtins.str] connection_point: Specifies the endpoint to connect to the Dynatrace environment.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant: Specifies the Dynatrace tenant.
        :param pulumi.Input[_builtins.str] tenant_token: Specifies the internal token that is used for authentication when OneAgent connects to the Dynatrace cluster to send data.
        :param pulumi.Input[_builtins.str] api_token: Specifies the API token of the Dynatrace environment.
        :param pulumi.Input[_builtins.str] api_url: Specifies the API Url of the Dynatrace environment.
        :param pulumi.Input[_builtins.str] environment_id: Specifies the Dynatrace environment ID.
        :param pulumi.Input[_builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for Dynatrace. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "connection_point", connection_point)
        pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        pulumi.set(__self__, "tenant", tenant)
        pulumi.set(__self__, "tenant_token", tenant_token)
        if api_token is not None:
            pulumi.set(__self__, "api_token", api_token)
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if globally_enabled is not None:
            pulumi.set(__self__, "globally_enabled", globally_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="connectionPoint")
    def connection_point(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the endpoint to connect to the Dynatrace environment.
        """
        return pulumi.get(self, "connection_point")

    @connection_point.setter
    def connection_point(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_point", value)

    @_builtins.property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Dynatrace tenant.
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant", value)

    @_builtins.property
    @pulumi.getter(name="tenantToken")
    def tenant_token(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the internal token that is used for authentication when OneAgent connects to the Dynatrace cluster to send data.
        """
        return pulumi.get(self, "tenant_token")

    @tenant_token.setter
    def tenant_token(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_token", value)

    @_builtins.property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the API token of the Dynatrace environment.
        """
        return pulumi.get(self, "api_token")

    @api_token.setter
    def api_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_token", value)

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the API Url of the Dynatrace environment.
        """
        return pulumi.get(self, "api_url")

    @api_url.setter
    def api_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_url", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Dynatrace environment ID.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @globally_enabled.setter
    def globally_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "globally_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for Dynatrace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SpringCloudDynatraceApplicationPerformanceMonitoringState:
    def __init__(__self__, *,
                 api_token: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_point: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudDynatraceApplicationPerformanceMonitoring resources.
        :param pulumi.Input[_builtins.str] api_token: Specifies the API token of the Dynatrace environment.
        :param pulumi.Input[_builtins.str] api_url: Specifies the API Url of the Dynatrace environment.
        :param pulumi.Input[_builtins.str] connection_point: Specifies the endpoint to connect to the Dynatrace environment.
        :param pulumi.Input[_builtins.str] environment_id: Specifies the Dynatrace environment ID.
        :param pulumi.Input[_builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for Dynatrace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant: Specifies the Dynatrace tenant.
        :param pulumi.Input[_builtins.str] tenant_token: Specifies the internal token that is used for authentication when OneAgent connects to the Dynatrace cluster to send data.
        """
        if api_token is not None:
            pulumi.set(__self__, "api_token", api_token)
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if connection_point is not None:
            pulumi.set(__self__, "connection_point", connection_point)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if globally_enabled is not None:
            pulumi.set(__self__, "globally_enabled", globally_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spring_cloud_service_id is not None:
            pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)
        if tenant_token is not None:
            pulumi.set(__self__, "tenant_token", tenant_token)

    @_builtins.property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the API token of the Dynatrace environment.
        """
        return pulumi.get(self, "api_token")

    @api_token.setter
    def api_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_token", value)

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the API Url of the Dynatrace environment.
        """
        return pulumi.get(self, "api_url")

    @api_url.setter
    def api_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_url", value)

    @_builtins.property
    @pulumi.getter(name="connectionPoint")
    def connection_point(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the endpoint to connect to the Dynatrace environment.
        """
        return pulumi.get(self, "connection_point")

    @connection_point.setter
    def connection_point(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_point", value)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Dynatrace environment ID.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment_id", value)

    @_builtins.property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @globally_enabled.setter
    def globally_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "globally_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for Dynatrace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Dynatrace tenant.
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant", value)

    @_builtins.property
    @pulumi.getter(name="tenantToken")
    def tenant_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the internal token that is used for authentication when OneAgent connects to the Dynatrace cluster to send data.
        """
        return pulumi.get(self, "tenant_token")

    @tenant_token.setter
    def tenant_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_token", value)


@pulumi.type_token("azure:appplatform/springCloudDynatraceApplicationPerformanceMonitoring:SpringCloudDynatraceApplicationPerformanceMonitoring")
class SpringCloudDynatraceApplicationPerformanceMonitoring(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_token: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_point: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_token: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > **Note:** This resource is only applicable for Spring Cloud Service enterprise tier

        Manages a Spring Cloud Application Performance Monitoring resource for Dynatrace.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudDynatraceApplicationPerformanceMonitoring` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_dynatrace_application_performance_monitoring = azure.appplatform.SpringCloudDynatraceApplicationPerformanceMonitoring("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            globally_enabled=True,
            api_url="https://example-api-url.com",
            api_token="dt0s01.AAAAAAAAAAAAAAAAAAAAAAAA.BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB",
            environment_id="example-environment-id",
            tenant="example-tenant",
            tenant_token="dt0s01.AAAAAAAAAAAAAAAAAAAAAAAA.BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB",
            connection_point="https://example.live.dynatrace.com:443")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud Application Performance Monitoring resource for Dynatrace can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudDynatraceApplicationPerformanceMonitoring:SpringCloudDynatraceApplicationPerformanceMonitoring example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AppPlatform/spring/service1/apms/apm1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_token: Specifies the API token of the Dynatrace environment.
        :param pulumi.Input[_builtins.str] api_url: Specifies the API Url of the Dynatrace environment.
        :param pulumi.Input[_builtins.str] connection_point: Specifies the endpoint to connect to the Dynatrace environment.
        :param pulumi.Input[_builtins.str] environment_id: Specifies the Dynatrace environment ID.
        :param pulumi.Input[_builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for Dynatrace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant: Specifies the Dynatrace tenant.
        :param pulumi.Input[_builtins.str] tenant_token: Specifies the internal token that is used for authentication when OneAgent connects to the Dynatrace cluster to send data.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudDynatraceApplicationPerformanceMonitoringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Note:** This resource is only applicable for Spring Cloud Service enterprise tier

        Manages a Spring Cloud Application Performance Monitoring resource for Dynatrace.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudDynatraceApplicationPerformanceMonitoring` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_dynatrace_application_performance_monitoring = azure.appplatform.SpringCloudDynatraceApplicationPerformanceMonitoring("example",
            name="example",
            spring_cloud_service_id=example_spring_cloud_service.id,
            globally_enabled=True,
            api_url="https://example-api-url.com",
            api_token="dt0s01.AAAAAAAAAAAAAAAAAAAAAAAA.BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB",
            environment_id="example-environment-id",
            tenant="example-tenant",
            tenant_token="dt0s01.AAAAAAAAAAAAAAAAAAAAAAAA.BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB",
            connection_point="https://example.live.dynatrace.com:443")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform`: 2024-01-01-preview

        ## Import

        Spring Cloud Application Performance Monitoring resource for Dynatrace can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudDynatraceApplicationPerformanceMonitoring:SpringCloudDynatraceApplicationPerformanceMonitoring example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.AppPlatform/spring/service1/apms/apm1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudDynatraceApplicationPerformanceMonitoringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudDynatraceApplicationPerformanceMonitoringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_token: Optional[pulumi.Input[_builtins.str]] = None,
                 api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_point: Optional[pulumi.Input[_builtins.str]] = None,
                 environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_token: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudDynatraceApplicationPerformanceMonitoringArgs.__new__(SpringCloudDynatraceApplicationPerformanceMonitoringArgs)

            __props__.__dict__["api_token"] = None if api_token is None else pulumi.Output.secret(api_token)
            __props__.__dict__["api_url"] = api_url
            if connection_point is None and not opts.urn:
                raise TypeError("Missing required property 'connection_point'")
            __props__.__dict__["connection_point"] = connection_point
            __props__.__dict__["environment_id"] = environment_id
            __props__.__dict__["globally_enabled"] = globally_enabled
            __props__.__dict__["name"] = name
            if spring_cloud_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_service_id'")
            __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
            if tenant is None and not opts.urn:
                raise TypeError("Missing required property 'tenant'")
            __props__.__dict__["tenant"] = None if tenant is None else pulumi.Output.secret(tenant)
            if tenant_token is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_token'")
            __props__.__dict__["tenant_token"] = None if tenant_token is None else pulumi.Output.secret(tenant_token)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiToken", "tenant", "tenantToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SpringCloudDynatraceApplicationPerformanceMonitoring, __self__).__init__(
            'azure:appplatform/springCloudDynatraceApplicationPerformanceMonitoring:SpringCloudDynatraceApplicationPerformanceMonitoring',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_token: Optional[pulumi.Input[_builtins.str]] = None,
            api_url: Optional[pulumi.Input[_builtins.str]] = None,
            connection_point: Optional[pulumi.Input[_builtins.str]] = None,
            environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            globally_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None,
            tenant: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_token: Optional[pulumi.Input[_builtins.str]] = None) -> 'SpringCloudDynatraceApplicationPerformanceMonitoring':
        """
        Get an existing SpringCloudDynatraceApplicationPerformanceMonitoring resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_token: Specifies the API token of the Dynatrace environment.
        :param pulumi.Input[_builtins.str] api_url: Specifies the API Url of the Dynatrace environment.
        :param pulumi.Input[_builtins.str] connection_point: Specifies the endpoint to connect to the Dynatrace environment.
        :param pulumi.Input[_builtins.str] environment_id: Specifies the Dynatrace environment ID.
        :param pulumi.Input[_builtins.bool] globally_enabled: Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Application Performance Monitoring resource for Dynatrace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant: Specifies the Dynatrace tenant.
        :param pulumi.Input[_builtins.str] tenant_token: Specifies the internal token that is used for authentication when OneAgent connects to the Dynatrace cluster to send data.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudDynatraceApplicationPerformanceMonitoringState.__new__(_SpringCloudDynatraceApplicationPerformanceMonitoringState)

        __props__.__dict__["api_token"] = api_token
        __props__.__dict__["api_url"] = api_url
        __props__.__dict__["connection_point"] = connection_point
        __props__.__dict__["environment_id"] = environment_id
        __props__.__dict__["globally_enabled"] = globally_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        __props__.__dict__["tenant"] = tenant
        __props__.__dict__["tenant_token"] = tenant_token
        return SpringCloudDynatraceApplicationPerformanceMonitoring(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiToken")
    def api_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the API token of the Dynatrace environment.
        """
        return pulumi.get(self, "api_token")

    @_builtins.property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the API Url of the Dynatrace environment.
        """
        return pulumi.get(self, "api_url")

    @_builtins.property
    @pulumi.getter(name="connectionPoint")
    def connection_point(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the endpoint to connect to the Dynatrace environment.
        """
        return pulumi.get(self, "connection_point")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Dynatrace environment ID.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter(name="globallyEnabled")
    def globally_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the Spring Cloud Application Performance Monitoring resource for Application Insights is enabled globally. Defaults to `false`.
        """
        return pulumi.get(self, "globally_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Spring Cloud Application Performance Monitoring resource for Dynatrace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Dynatrace tenant.
        """
        return pulumi.get(self, "tenant")

    @_builtins.property
    @pulumi.getter(name="tenantToken")
    def tenant_token(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the internal token that is used for authentication when OneAgent connects to the Dynatrace cluster to send data.
        """
        return pulumi.get(self, "tenant_token")

