# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LinuxWebAppSlotArgs', 'LinuxWebAppSlot']

@pulumi.input_type
class LinuxWebAppSlotArgs:
    def __init__(__self__, *,
                 app_service_id: pulumi.Input[_builtins.str],
                 site_config: pulumi.Input['LinuxWebAppSlotSiteConfigArgs'],
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input['LinuxWebAppSlotAuthSettingsArgs']] = None,
                 auth_settings_v2: Optional[pulumi.Input['LinuxWebAppSlotAuthSettingsV2Args']] = None,
                 backup: Optional[pulumi.Input['LinuxWebAppSlotBackupArgs']] = None,
                 client_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotConnectionStringArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['LinuxWebAppSlotIdentityArgs']] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logs: Optional[pulumi.Input['LinuxWebAppSlotLogsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotStorageAccountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_backup_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 zip_deploy_file: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LinuxWebAppSlot resource.
        :param pulumi.Input[_builtins.str] app_service_id: The ID of the Linux Web App this Deployment Slot will be part of.
        :param pulumi.Input['LinuxWebAppSlotSiteConfigArgs'] site_config: A `site_config` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_settings: A map of key-value pairs of App Settings.
        :param pulumi.Input['LinuxWebAppSlotAuthSettingsArgs'] auth_settings: An `auth_settings` block as defined below.
        :param pulumi.Input['LinuxWebAppSlotAuthSettingsV2Args'] auth_settings_v2: An `auth_settings_v2` block as defined below.
        :param pulumi.Input['LinuxWebAppSlotBackupArgs'] backup: A `backup` block as defined below.
        :param pulumi.Input[_builtins.bool] client_affinity_enabled: Should Client Affinity be enabled?
        :param pulumi.Input[_builtins.bool] client_certificate_enabled: Should Client Certificates be enabled?
        :param pulumi.Input[_builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[_builtins.str] client_certificate_mode: The Client Certificate mode. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. This property has no effect when `client_cert_enabled` is `false`. Defaults to `Required`.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotConnectionStringArgs']]] connection_strings: One or more `connection_string` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Should the Linux Web App be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ftp_publish_basic_authentication_enabled: Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] https_only: Should the Linux Web App require HTTPS connections. Defaults to `false`.
        :param pulumi.Input['LinuxWebAppSlotIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] key_vault_reference_identity_id: The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity).
        :param pulumi.Input['LinuxWebAppSlotLogsArgs'] logs: A `logs` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Should public network access be enabled for the Web App. Defaults to `true`.
        :param pulumi.Input[_builtins.str] service_plan_id: The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Web App will be used.
               
               > **Note:** `service_plan_id` should only be specified if it differs from the Service Plan of the associated Linux Web App.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotStorageAccountArgs']]] storage_accounts: One or more `storage_account` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags that should be assigned to the Linux Web App.
        :param pulumi.Input[_builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
               
               > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        :param pulumi.Input[_builtins.str] zip_deploy_file: The local path and filename of the Zip packaged application to deploy to this Linux Web App.
               
               > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://docs.microsoft.com/en-us/azure/app-service/deploy-run-package) for further details.
        """
        pulumi.set(__self__, "app_service_id", app_service_id)
        pulumi.set(__self__, "site_config", site_config)
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if auth_settings is not None:
            pulumi.set(__self__, "auth_settings", auth_settings)
        if auth_settings_v2 is not None:
            pulumi.set(__self__, "auth_settings_v2", auth_settings_v2)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if client_affinity_enabled is not None:
            pulumi.set(__self__, "client_affinity_enabled", client_affinity_enabled)
        if client_certificate_enabled is not None:
            pulumi.set(__self__, "client_certificate_enabled", client_certificate_enabled)
        if client_certificate_exclusion_paths is not None:
            pulumi.set(__self__, "client_certificate_exclusion_paths", client_certificate_exclusion_paths)
        if client_certificate_mode is not None:
            pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ftp_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "ftp_publish_basic_authentication_enabled", ftp_publish_basic_authentication_enabled)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_reference_identity_id is not None:
            pulumi.set(__self__, "key_vault_reference_identity_id", key_vault_reference_identity_id)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if service_plan_id is not None:
            pulumi.set(__self__, "service_plan_id", service_plan_id)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_backup_restore_enabled is not None:
            pulumi.set(__self__, "virtual_network_backup_restore_enabled", virtual_network_backup_restore_enabled)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)
        if webdeploy_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "webdeploy_publish_basic_authentication_enabled", webdeploy_publish_basic_authentication_enabled)
        if zip_deploy_file is not None:
            pulumi.set(__self__, "zip_deploy_file", zip_deploy_file)

    @_builtins.property
    @pulumi.getter(name="appServiceId")
    def app_service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Linux Web App this Deployment Slot will be part of.
        """
        return pulumi.get(self, "app_service_id")

    @app_service_id.setter
    def app_service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_service_id", value)

    @_builtins.property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> pulumi.Input['LinuxWebAppSlotSiteConfigArgs']:
        """
        A `site_config` block as defined below.
        """
        return pulumi.get(self, "site_config")

    @site_config.setter
    def site_config(self, value: pulumi.Input['LinuxWebAppSlotSiteConfigArgs']):
        pulumi.set(self, "site_config", value)

    @_builtins.property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key-value pairs of App Settings.
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_settings", value)

    @_builtins.property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> Optional[pulumi.Input['LinuxWebAppSlotAuthSettingsArgs']]:
        """
        An `auth_settings` block as defined below.
        """
        return pulumi.get(self, "auth_settings")

    @auth_settings.setter
    def auth_settings(self, value: Optional[pulumi.Input['LinuxWebAppSlotAuthSettingsArgs']]):
        pulumi.set(self, "auth_settings", value)

    @_builtins.property
    @pulumi.getter(name="authSettingsV2")
    def auth_settings_v2(self) -> Optional[pulumi.Input['LinuxWebAppSlotAuthSettingsV2Args']]:
        """
        An `auth_settings_v2` block as defined below.
        """
        return pulumi.get(self, "auth_settings_v2")

    @auth_settings_v2.setter
    def auth_settings_v2(self, value: Optional[pulumi.Input['LinuxWebAppSlotAuthSettingsV2Args']]):
        pulumi.set(self, "auth_settings_v2", value)

    @_builtins.property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['LinuxWebAppSlotBackupArgs']]:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['LinuxWebAppSlotBackupArgs']]):
        pulumi.set(self, "backup", value)

    @_builtins.property
    @pulumi.getter(name="clientAffinityEnabled")
    def client_affinity_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Client Affinity be enabled?
        """
        return pulumi.get(self, "client_affinity_enabled")

    @client_affinity_enabled.setter
    def client_affinity_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_affinity_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Client Certificates be enabled?
        """
        return pulumi.get(self, "client_certificate_enabled")

    @client_certificate_enabled.setter
    def client_certificate_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_certificate_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateExclusionPaths")
    def client_certificate_exclusion_paths(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Paths to exclude when using client certificates, separated by ;
        """
        return pulumi.get(self, "client_certificate_exclusion_paths")

    @client_certificate_exclusion_paths.setter
    def client_certificate_exclusion_paths(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_exclusion_paths", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client Certificate mode. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. This property has no effect when `client_cert_enabled` is `false`. Defaults to `Required`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @client_certificate_mode.setter
    def client_certificate_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotConnectionStringArgs']]]]:
        """
        One or more `connection_string` blocks as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Linux Web App be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ftpPublishBasicAuthenticationEnabled")
    def ftp_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ftp_publish_basic_authentication_enabled")

    @ftp_publish_basic_authentication_enabled.setter
    def ftp_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ftp_publish_basic_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Linux Web App require HTTPS connections. Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['LinuxWebAppSlotIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['LinuxWebAppSlotIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultReferenceIdentityId")
    def key_vault_reference_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity).
        """
        return pulumi.get(self, "key_vault_reference_identity_id")

    @key_vault_reference_identity_id.setter
    def key_vault_reference_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_reference_identity_id", value)

    @_builtins.property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input['LinuxWebAppSlotLogsArgs']]:
        """
        A `logs` block as defined below.
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input['LinuxWebAppSlotLogsArgs']]):
        pulumi.set(self, "logs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should public network access be enabled for the Web App. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="servicePlanId")
    def service_plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Web App will be used.

        > **Note:** `service_plan_id` should only be specified if it differs from the Service Plan of the associated Linux Web App.
        """
        return pulumi.get(self, "service_plan_id")

    @service_plan_id.setter
    def service_plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_plan_id", value)

    @_builtins.property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotStorageAccountArgs']]]]:
        """
        One or more `storage_account` blocks as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags that should be assigned to the Linux Web App.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkBackupRestoreEnabled")
    def virtual_network_backup_restore_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "virtual_network_backup_restore_enabled")

    @virtual_network_backup_restore_enabled.setter
    def virtual_network_backup_restore_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "virtual_network_backup_restore_enabled", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @virtual_network_subnet_id.setter
    def virtual_network_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="webdeployPublishBasicAuthenticationEnabled")
    def webdeploy_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.

        > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        """
        return pulumi.get(self, "webdeploy_publish_basic_authentication_enabled")

    @webdeploy_publish_basic_authentication_enabled.setter
    def webdeploy_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "webdeploy_publish_basic_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter(name="zipDeployFile")
    def zip_deploy_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The local path and filename of the Zip packaged application to deploy to this Linux Web App.

        > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://docs.microsoft.com/en-us/azure/app-service/deploy-run-package) for further details.
        """
        return pulumi.get(self, "zip_deploy_file")

    @zip_deploy_file.setter
    def zip_deploy_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zip_deploy_file", value)


@pulumi.input_type
class _LinuxWebAppSlotState:
    def __init__(__self__, *,
                 app_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 app_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input['LinuxWebAppSlotAuthSettingsArgs']] = None,
                 auth_settings_v2: Optional[pulumi.Input['LinuxWebAppSlotAuthSettingsV2Args']] = None,
                 backup: Optional[pulumi.Input['LinuxWebAppSlotBackupArgs']] = None,
                 client_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotConnectionStringArgs']]]] = None,
                 custom_domain_verification_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hosting_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['LinuxWebAppSlotIdentityArgs']] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 logs: Optional[pulumi.Input['LinuxWebAppSlotLogsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 outbound_ip_addresses: Optional[pulumi.Input[_builtins.str]] = None,
                 possible_outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 possible_outbound_ip_addresses: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 site_config: Optional[pulumi.Input['LinuxWebAppSlotSiteConfigArgs']] = None,
                 site_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotSiteCredentialArgs']]]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotStorageAccountArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_backup_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 zip_deploy_file: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LinuxWebAppSlot resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_metadata: A `app_metadata`.
        :param pulumi.Input[_builtins.str] app_service_id: The ID of the Linux Web App this Deployment Slot will be part of.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_settings: A map of key-value pairs of App Settings.
        :param pulumi.Input['LinuxWebAppSlotAuthSettingsArgs'] auth_settings: An `auth_settings` block as defined below.
        :param pulumi.Input['LinuxWebAppSlotAuthSettingsV2Args'] auth_settings_v2: An `auth_settings_v2` block as defined below.
        :param pulumi.Input['LinuxWebAppSlotBackupArgs'] backup: A `backup` block as defined below.
        :param pulumi.Input[_builtins.bool] client_affinity_enabled: Should Client Affinity be enabled?
        :param pulumi.Input[_builtins.bool] client_certificate_enabled: Should Client Certificates be enabled?
        :param pulumi.Input[_builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[_builtins.str] client_certificate_mode: The Client Certificate mode. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. This property has no effect when `client_cert_enabled` is `false`. Defaults to `Required`.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotConnectionStringArgs']]] connection_strings: One or more `connection_string` blocks as defined below.
        :param pulumi.Input[_builtins.str] custom_domain_verification_id: The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        :param pulumi.Input[_builtins.str] default_hostname: The default hostname of the Linux Web App.
        :param pulumi.Input[_builtins.bool] enabled: Should the Linux Web App be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ftp_publish_basic_authentication_enabled: Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] hosting_environment_id: The ID of the App Service Environment used by App Service Slot.
        :param pulumi.Input[_builtins.bool] https_only: Should the Linux Web App require HTTPS connections. Defaults to `false`.
        :param pulumi.Input['LinuxWebAppSlotIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] key_vault_reference_identity_id: The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity).
        :param pulumi.Input[_builtins.str] kind: The Kind value for this Linux Web App.
        :param pulumi.Input['LinuxWebAppSlotLogsArgs'] logs: A `logs` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] outbound_ip_address_lists: A list of outbound IP addresses - such as `["52.23.25.3", "52.143.43.12"]`
        :param pulumi.Input[_builtins.str] outbound_ip_addresses: A comma-separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] possible_outbound_ip_address_lists: A `possible_outbound_ip_address_list`.
        :param pulumi.Input[_builtins.str] possible_outbound_ip_addresses: A comma-separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12,52.143.43.17` - not all of which are necessarily in use. Superset of `outbound_ip_addresses`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Should public network access be enabled for the Web App. Defaults to `true`.
        :param pulumi.Input[_builtins.str] service_plan_id: The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Web App will be used.
               
               > **Note:** `service_plan_id` should only be specified if it differs from the Service Plan of the associated Linux Web App.
        :param pulumi.Input['LinuxWebAppSlotSiteConfigArgs'] site_config: A `site_config` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotSiteCredentialArgs']]] site_credentials: A `site_credential` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotStorageAccountArgs']]] storage_accounts: One or more `storage_account` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags that should be assigned to the Linux Web App.
        :param pulumi.Input[_builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
               
               > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        :param pulumi.Input[_builtins.str] zip_deploy_file: The local path and filename of the Zip packaged application to deploy to this Linux Web App.
               
               > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://docs.microsoft.com/en-us/azure/app-service/deploy-run-package) for further details.
        """
        if app_metadata is not None:
            pulumi.set(__self__, "app_metadata", app_metadata)
        if app_service_id is not None:
            pulumi.set(__self__, "app_service_id", app_service_id)
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if auth_settings is not None:
            pulumi.set(__self__, "auth_settings", auth_settings)
        if auth_settings_v2 is not None:
            pulumi.set(__self__, "auth_settings_v2", auth_settings_v2)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if client_affinity_enabled is not None:
            pulumi.set(__self__, "client_affinity_enabled", client_affinity_enabled)
        if client_certificate_enabled is not None:
            pulumi.set(__self__, "client_certificate_enabled", client_certificate_enabled)
        if client_certificate_exclusion_paths is not None:
            pulumi.set(__self__, "client_certificate_exclusion_paths", client_certificate_exclusion_paths)
        if client_certificate_mode is not None:
            pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if custom_domain_verification_id is not None:
            pulumi.set(__self__, "custom_domain_verification_id", custom_domain_verification_id)
        if default_hostname is not None:
            pulumi.set(__self__, "default_hostname", default_hostname)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ftp_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "ftp_publish_basic_authentication_enabled", ftp_publish_basic_authentication_enabled)
        if hosting_environment_id is not None:
            pulumi.set(__self__, "hosting_environment_id", hosting_environment_id)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_reference_identity_id is not None:
            pulumi.set(__self__, "key_vault_reference_identity_id", key_vault_reference_identity_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_ip_address_lists is not None:
            pulumi.set(__self__, "outbound_ip_address_lists", outbound_ip_address_lists)
        if outbound_ip_addresses is not None:
            pulumi.set(__self__, "outbound_ip_addresses", outbound_ip_addresses)
        if possible_outbound_ip_address_lists is not None:
            pulumi.set(__self__, "possible_outbound_ip_address_lists", possible_outbound_ip_address_lists)
        if possible_outbound_ip_addresses is not None:
            pulumi.set(__self__, "possible_outbound_ip_addresses", possible_outbound_ip_addresses)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if service_plan_id is not None:
            pulumi.set(__self__, "service_plan_id", service_plan_id)
        if site_config is not None:
            pulumi.set(__self__, "site_config", site_config)
        if site_credentials is not None:
            pulumi.set(__self__, "site_credentials", site_credentials)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_backup_restore_enabled is not None:
            pulumi.set(__self__, "virtual_network_backup_restore_enabled", virtual_network_backup_restore_enabled)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)
        if webdeploy_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "webdeploy_publish_basic_authentication_enabled", webdeploy_publish_basic_authentication_enabled)
        if zip_deploy_file is not None:
            pulumi.set(__self__, "zip_deploy_file", zip_deploy_file)

    @_builtins.property
    @pulumi.getter(name="appMetadata")
    def app_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A `app_metadata`.
        """
        return pulumi.get(self, "app_metadata")

    @app_metadata.setter
    def app_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_metadata", value)

    @_builtins.property
    @pulumi.getter(name="appServiceId")
    def app_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Linux Web App this Deployment Slot will be part of.
        """
        return pulumi.get(self, "app_service_id")

    @app_service_id.setter
    def app_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service_id", value)

    @_builtins.property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key-value pairs of App Settings.
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_settings", value)

    @_builtins.property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> Optional[pulumi.Input['LinuxWebAppSlotAuthSettingsArgs']]:
        """
        An `auth_settings` block as defined below.
        """
        return pulumi.get(self, "auth_settings")

    @auth_settings.setter
    def auth_settings(self, value: Optional[pulumi.Input['LinuxWebAppSlotAuthSettingsArgs']]):
        pulumi.set(self, "auth_settings", value)

    @_builtins.property
    @pulumi.getter(name="authSettingsV2")
    def auth_settings_v2(self) -> Optional[pulumi.Input['LinuxWebAppSlotAuthSettingsV2Args']]:
        """
        An `auth_settings_v2` block as defined below.
        """
        return pulumi.get(self, "auth_settings_v2")

    @auth_settings_v2.setter
    def auth_settings_v2(self, value: Optional[pulumi.Input['LinuxWebAppSlotAuthSettingsV2Args']]):
        pulumi.set(self, "auth_settings_v2", value)

    @_builtins.property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['LinuxWebAppSlotBackupArgs']]:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['LinuxWebAppSlotBackupArgs']]):
        pulumi.set(self, "backup", value)

    @_builtins.property
    @pulumi.getter(name="clientAffinityEnabled")
    def client_affinity_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Client Affinity be enabled?
        """
        return pulumi.get(self, "client_affinity_enabled")

    @client_affinity_enabled.setter
    def client_affinity_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_affinity_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Client Certificates be enabled?
        """
        return pulumi.get(self, "client_certificate_enabled")

    @client_certificate_enabled.setter
    def client_certificate_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_certificate_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateExclusionPaths")
    def client_certificate_exclusion_paths(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Paths to exclude when using client certificates, separated by ;
        """
        return pulumi.get(self, "client_certificate_exclusion_paths")

    @client_certificate_exclusion_paths.setter
    def client_certificate_exclusion_paths(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_exclusion_paths", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client Certificate mode. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. This property has no effect when `client_cert_enabled` is `false`. Defaults to `Required`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @client_certificate_mode.setter
    def client_certificate_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotConnectionStringArgs']]]]:
        """
        One or more `connection_string` blocks as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @_builtins.property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @custom_domain_verification_id.setter
    def custom_domain_verification_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_domain_verification_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default hostname of the Linux Web App.
        """
        return pulumi.get(self, "default_hostname")

    @default_hostname.setter
    def default_hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_hostname", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Linux Web App be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ftpPublishBasicAuthenticationEnabled")
    def ftp_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ftp_publish_basic_authentication_enabled")

    @ftp_publish_basic_authentication_enabled.setter
    def ftp_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ftp_publish_basic_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hostingEnvironmentId")
    def hosting_environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the App Service Environment used by App Service Slot.
        """
        return pulumi.get(self, "hosting_environment_id")

    @hosting_environment_id.setter
    def hosting_environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hosting_environment_id", value)

    @_builtins.property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Linux Web App require HTTPS connections. Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['LinuxWebAppSlotIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['LinuxWebAppSlotIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultReferenceIdentityId")
    def key_vault_reference_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity).
        """
        return pulumi.get(self, "key_vault_reference_identity_id")

    @key_vault_reference_identity_id.setter
    def key_vault_reference_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_reference_identity_id", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kind value for this Linux Web App.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input['LinuxWebAppSlotLogsArgs']]:
        """
        A `logs` block as defined below.
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input['LinuxWebAppSlotLogsArgs']]):
        pulumi.set(self, "logs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outboundIpAddressLists")
    def outbound_ip_address_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of outbound IP addresses - such as `["52.23.25.3", "52.143.43.12"]`
        """
        return pulumi.get(self, "outbound_ip_address_lists")

    @outbound_ip_address_lists.setter
    def outbound_ip_address_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "outbound_ip_address_lists", value)

    @_builtins.property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A comma-separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12`.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @outbound_ip_addresses.setter
    def outbound_ip_addresses(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "outbound_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="possibleOutboundIpAddressLists")
    def possible_outbound_ip_address_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A `possible_outbound_ip_address_list`.
        """
        return pulumi.get(self, "possible_outbound_ip_address_lists")

    @possible_outbound_ip_address_lists.setter
    def possible_outbound_ip_address_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "possible_outbound_ip_address_lists", value)

    @_builtins.property
    @pulumi.getter(name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A comma-separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12,52.143.43.17` - not all of which are necessarily in use. Superset of `outbound_ip_addresses`.
        """
        return pulumi.get(self, "possible_outbound_ip_addresses")

    @possible_outbound_ip_addresses.setter
    def possible_outbound_ip_addresses(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "possible_outbound_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should public network access be enabled for the Web App. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="servicePlanId")
    def service_plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Web App will be used.

        > **Note:** `service_plan_id` should only be specified if it differs from the Service Plan of the associated Linux Web App.
        """
        return pulumi.get(self, "service_plan_id")

    @service_plan_id.setter
    def service_plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_plan_id", value)

    @_builtins.property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> Optional[pulumi.Input['LinuxWebAppSlotSiteConfigArgs']]:
        """
        A `site_config` block as defined below.
        """
        return pulumi.get(self, "site_config")

    @site_config.setter
    def site_config(self, value: Optional[pulumi.Input['LinuxWebAppSlotSiteConfigArgs']]):
        pulumi.set(self, "site_config", value)

    @_builtins.property
    @pulumi.getter(name="siteCredentials")
    def site_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotSiteCredentialArgs']]]]:
        """
        A `site_credential` block as defined below.
        """
        return pulumi.get(self, "site_credentials")

    @site_credentials.setter
    def site_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotSiteCredentialArgs']]]]):
        pulumi.set(self, "site_credentials", value)

    @_builtins.property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotStorageAccountArgs']]]]:
        """
        One or more `storage_account` blocks as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinuxWebAppSlotStorageAccountArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags that should be assigned to the Linux Web App.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkBackupRestoreEnabled")
    def virtual_network_backup_restore_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "virtual_network_backup_restore_enabled")

    @virtual_network_backup_restore_enabled.setter
    def virtual_network_backup_restore_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "virtual_network_backup_restore_enabled", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @virtual_network_subnet_id.setter
    def virtual_network_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="webdeployPublishBasicAuthenticationEnabled")
    def webdeploy_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.

        > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        """
        return pulumi.get(self, "webdeploy_publish_basic_authentication_enabled")

    @webdeploy_publish_basic_authentication_enabled.setter
    def webdeploy_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "webdeploy_publish_basic_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter(name="zipDeployFile")
    def zip_deploy_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The local path and filename of the Zip packaged application to deploy to this Linux Web App.

        > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://docs.microsoft.com/en-us/azure/app-service/deploy-run-package) for further details.
        """
        return pulumi.get(self, "zip_deploy_file")

    @zip_deploy_file.setter
    def zip_deploy_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zip_deploy_file", value)


@pulumi.type_token("azure:appservice/linuxWebAppSlot:LinuxWebAppSlot")
class LinuxWebAppSlot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input[Union['LinuxWebAppSlotAuthSettingsArgs', 'LinuxWebAppSlotAuthSettingsArgsDict']]] = None,
                 auth_settings_v2: Optional[pulumi.Input[Union['LinuxWebAppSlotAuthSettingsV2Args', 'LinuxWebAppSlotAuthSettingsV2ArgsDict']]] = None,
                 backup: Optional[pulumi.Input[Union['LinuxWebAppSlotBackupArgs', 'LinuxWebAppSlotBackupArgsDict']]] = None,
                 client_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxWebAppSlotConnectionStringArgs', 'LinuxWebAppSlotConnectionStringArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['LinuxWebAppSlotIdentityArgs', 'LinuxWebAppSlotIdentityArgsDict']]] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logs: Optional[pulumi.Input[Union['LinuxWebAppSlotLogsArgs', 'LinuxWebAppSlotLogsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 site_config: Optional[pulumi.Input[Union['LinuxWebAppSlotSiteConfigArgs', 'LinuxWebAppSlotSiteConfigArgsDict']]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxWebAppSlotStorageAccountArgs', 'LinuxWebAppSlotStorageAccountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_backup_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 zip_deploy_file: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Linux Web App Slot.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-plan",
            resource_group_name=example.name,
            location=example.location,
            os_type="Linux",
            sku_name="P1v2")
        example_linux_web_app = azure.appservice.LinuxWebApp("example",
            name="example-linux-web-app",
            resource_group_name=example.name,
            location=example_service_plan.location,
            service_plan_id=example_service_plan.id,
            site_config={})
        example_linux_web_app_slot = azure.appservice.LinuxWebAppSlot("example",
            name="example-slot",
            app_service_id=example_linux_web_app.id,
            site_config={})
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01

        ## Import

        Linux Web Apps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/linuxWebAppSlot:LinuxWebAppSlot example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Web/sites/site1/slots/slot1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_service_id: The ID of the Linux Web App this Deployment Slot will be part of.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_settings: A map of key-value pairs of App Settings.
        :param pulumi.Input[Union['LinuxWebAppSlotAuthSettingsArgs', 'LinuxWebAppSlotAuthSettingsArgsDict']] auth_settings: An `auth_settings` block as defined below.
        :param pulumi.Input[Union['LinuxWebAppSlotAuthSettingsV2Args', 'LinuxWebAppSlotAuthSettingsV2ArgsDict']] auth_settings_v2: An `auth_settings_v2` block as defined below.
        :param pulumi.Input[Union['LinuxWebAppSlotBackupArgs', 'LinuxWebAppSlotBackupArgsDict']] backup: A `backup` block as defined below.
        :param pulumi.Input[_builtins.bool] client_affinity_enabled: Should Client Affinity be enabled?
        :param pulumi.Input[_builtins.bool] client_certificate_enabled: Should Client Certificates be enabled?
        :param pulumi.Input[_builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[_builtins.str] client_certificate_mode: The Client Certificate mode. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. This property has no effect when `client_cert_enabled` is `false`. Defaults to `Required`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxWebAppSlotConnectionStringArgs', 'LinuxWebAppSlotConnectionStringArgsDict']]]] connection_strings: One or more `connection_string` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Should the Linux Web App be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ftp_publish_basic_authentication_enabled: Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] https_only: Should the Linux Web App require HTTPS connections. Defaults to `false`.
        :param pulumi.Input[Union['LinuxWebAppSlotIdentityArgs', 'LinuxWebAppSlotIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] key_vault_reference_identity_id: The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity).
        :param pulumi.Input[Union['LinuxWebAppSlotLogsArgs', 'LinuxWebAppSlotLogsArgsDict']] logs: A `logs` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Should public network access be enabled for the Web App. Defaults to `true`.
        :param pulumi.Input[_builtins.str] service_plan_id: The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Web App will be used.
               
               > **Note:** `service_plan_id` should only be specified if it differs from the Service Plan of the associated Linux Web App.
        :param pulumi.Input[Union['LinuxWebAppSlotSiteConfigArgs', 'LinuxWebAppSlotSiteConfigArgsDict']] site_config: A `site_config` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxWebAppSlotStorageAccountArgs', 'LinuxWebAppSlotStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags that should be assigned to the Linux Web App.
        :param pulumi.Input[_builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
               
               > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        :param pulumi.Input[_builtins.str] zip_deploy_file: The local path and filename of the Zip packaged application to deploy to this Linux Web App.
               
               > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://docs.microsoft.com/en-us/azure/app-service/deploy-run-package) for further details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinuxWebAppSlotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Linux Web App Slot.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-plan",
            resource_group_name=example.name,
            location=example.location,
            os_type="Linux",
            sku_name="P1v2")
        example_linux_web_app = azure.appservice.LinuxWebApp("example",
            name="example-linux-web-app",
            resource_group_name=example.name,
            location=example_service_plan.location,
            service_plan_id=example_service_plan.id,
            site_config={})
        example_linux_web_app_slot = azure.appservice.LinuxWebAppSlot("example",
            name="example-slot",
            app_service_id=example_linux_web_app.id,
            site_config={})
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web`: 2023-12-01

        ## Import

        Linux Web Apps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appservice/linuxWebAppSlot:LinuxWebAppSlot example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.Web/sites/site1/slots/slot1
        ```

        :param str resource_name: The name of the resource.
        :param LinuxWebAppSlotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinuxWebAppSlotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 auth_settings: Optional[pulumi.Input[Union['LinuxWebAppSlotAuthSettingsArgs', 'LinuxWebAppSlotAuthSettingsArgsDict']]] = None,
                 auth_settings_v2: Optional[pulumi.Input[Union['LinuxWebAppSlotAuthSettingsV2Args', 'LinuxWebAppSlotAuthSettingsV2ArgsDict']]] = None,
                 backup: Optional[pulumi.Input[Union['LinuxWebAppSlotBackupArgs', 'LinuxWebAppSlotBackupArgsDict']]] = None,
                 client_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_exclusion_paths: Optional[pulumi.Input[_builtins.str]] = None,
                 client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxWebAppSlotConnectionStringArgs', 'LinuxWebAppSlotConnectionStringArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['LinuxWebAppSlotIdentityArgs', 'LinuxWebAppSlotIdentityArgsDict']]] = None,
                 key_vault_reference_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logs: Optional[pulumi.Input[Union['LinuxWebAppSlotLogsArgs', 'LinuxWebAppSlotLogsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 site_config: Optional[pulumi.Input[Union['LinuxWebAppSlotSiteConfigArgs', 'LinuxWebAppSlotSiteConfigArgsDict']]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxWebAppSlotStorageAccountArgs', 'LinuxWebAppSlotStorageAccountArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_backup_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 zip_deploy_file: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinuxWebAppSlotArgs.__new__(LinuxWebAppSlotArgs)

            if app_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_service_id'")
            __props__.__dict__["app_service_id"] = app_service_id
            __props__.__dict__["app_settings"] = app_settings
            __props__.__dict__["auth_settings"] = auth_settings
            __props__.__dict__["auth_settings_v2"] = auth_settings_v2
            __props__.__dict__["backup"] = backup
            __props__.__dict__["client_affinity_enabled"] = client_affinity_enabled
            __props__.__dict__["client_certificate_enabled"] = client_certificate_enabled
            __props__.__dict__["client_certificate_exclusion_paths"] = client_certificate_exclusion_paths
            __props__.__dict__["client_certificate_mode"] = client_certificate_mode
            __props__.__dict__["connection_strings"] = connection_strings
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ftp_publish_basic_authentication_enabled"] = ftp_publish_basic_authentication_enabled
            __props__.__dict__["https_only"] = https_only
            __props__.__dict__["identity"] = identity
            __props__.__dict__["key_vault_reference_identity_id"] = key_vault_reference_identity_id
            __props__.__dict__["logs"] = logs
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["service_plan_id"] = service_plan_id
            if site_config is None and not opts.urn:
                raise TypeError("Missing required property 'site_config'")
            __props__.__dict__["site_config"] = site_config
            __props__.__dict__["storage_accounts"] = storage_accounts
            __props__.__dict__["tags"] = tags
            __props__.__dict__["virtual_network_backup_restore_enabled"] = virtual_network_backup_restore_enabled
            __props__.__dict__["virtual_network_subnet_id"] = virtual_network_subnet_id
            __props__.__dict__["webdeploy_publish_basic_authentication_enabled"] = webdeploy_publish_basic_authentication_enabled
            __props__.__dict__["zip_deploy_file"] = zip_deploy_file
            __props__.__dict__["app_metadata"] = None
            __props__.__dict__["custom_domain_verification_id"] = None
            __props__.__dict__["default_hostname"] = None
            __props__.__dict__["hosting_environment_id"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["outbound_ip_address_lists"] = None
            __props__.__dict__["outbound_ip_addresses"] = None
            __props__.__dict__["possible_outbound_ip_address_lists"] = None
            __props__.__dict__["possible_outbound_ip_addresses"] = None
            __props__.__dict__["site_credentials"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["customDomainVerificationId", "siteCredentials"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LinuxWebAppSlot, __self__).__init__(
            'azure:appservice/linuxWebAppSlot:LinuxWebAppSlot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            app_service_id: Optional[pulumi.Input[_builtins.str]] = None,
            app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            auth_settings: Optional[pulumi.Input[Union['LinuxWebAppSlotAuthSettingsArgs', 'LinuxWebAppSlotAuthSettingsArgsDict']]] = None,
            auth_settings_v2: Optional[pulumi.Input[Union['LinuxWebAppSlotAuthSettingsV2Args', 'LinuxWebAppSlotAuthSettingsV2ArgsDict']]] = None,
            backup: Optional[pulumi.Input[Union['LinuxWebAppSlotBackupArgs', 'LinuxWebAppSlotBackupArgsDict']]] = None,
            client_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            client_certificate_exclusion_paths: Optional[pulumi.Input[_builtins.str]] = None,
            client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxWebAppSlotConnectionStringArgs', 'LinuxWebAppSlotConnectionStringArgsDict']]]]] = None,
            custom_domain_verification_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_hostname: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            hosting_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            https_only: Optional[pulumi.Input[_builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['LinuxWebAppSlotIdentityArgs', 'LinuxWebAppSlotIdentityArgsDict']]] = None,
            key_vault_reference_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            logs: Optional[pulumi.Input[Union['LinuxWebAppSlotLogsArgs', 'LinuxWebAppSlotLogsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            outbound_ip_addresses: Optional[pulumi.Input[_builtins.str]] = None,
            possible_outbound_ip_address_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            possible_outbound_ip_addresses: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
            site_config: Optional[pulumi.Input[Union['LinuxWebAppSlotSiteConfigArgs', 'LinuxWebAppSlotSiteConfigArgsDict']]] = None,
            site_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxWebAppSlotSiteCredentialArgs', 'LinuxWebAppSlotSiteCredentialArgsDict']]]]] = None,
            storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinuxWebAppSlotStorageAccountArgs', 'LinuxWebAppSlotStorageAccountArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            virtual_network_backup_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            webdeploy_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            zip_deploy_file: Optional[pulumi.Input[_builtins.str]] = None) -> 'LinuxWebAppSlot':
        """
        Get an existing LinuxWebAppSlot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_metadata: A `app_metadata`.
        :param pulumi.Input[_builtins.str] app_service_id: The ID of the Linux Web App this Deployment Slot will be part of.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_settings: A map of key-value pairs of App Settings.
        :param pulumi.Input[Union['LinuxWebAppSlotAuthSettingsArgs', 'LinuxWebAppSlotAuthSettingsArgsDict']] auth_settings: An `auth_settings` block as defined below.
        :param pulumi.Input[Union['LinuxWebAppSlotAuthSettingsV2Args', 'LinuxWebAppSlotAuthSettingsV2ArgsDict']] auth_settings_v2: An `auth_settings_v2` block as defined below.
        :param pulumi.Input[Union['LinuxWebAppSlotBackupArgs', 'LinuxWebAppSlotBackupArgsDict']] backup: A `backup` block as defined below.
        :param pulumi.Input[_builtins.bool] client_affinity_enabled: Should Client Affinity be enabled?
        :param pulumi.Input[_builtins.bool] client_certificate_enabled: Should Client Certificates be enabled?
        :param pulumi.Input[_builtins.str] client_certificate_exclusion_paths: Paths to exclude when using client certificates, separated by ;
        :param pulumi.Input[_builtins.str] client_certificate_mode: The Client Certificate mode. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. This property has no effect when `client_cert_enabled` is `false`. Defaults to `Required`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxWebAppSlotConnectionStringArgs', 'LinuxWebAppSlotConnectionStringArgsDict']]]] connection_strings: One or more `connection_string` blocks as defined below.
        :param pulumi.Input[_builtins.str] custom_domain_verification_id: The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        :param pulumi.Input[_builtins.str] default_hostname: The default hostname of the Linux Web App.
        :param pulumi.Input[_builtins.bool] enabled: Should the Linux Web App be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ftp_publish_basic_authentication_enabled: Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] hosting_environment_id: The ID of the App Service Environment used by App Service Slot.
        :param pulumi.Input[_builtins.bool] https_only: Should the Linux Web App require HTTPS connections. Defaults to `false`.
        :param pulumi.Input[Union['LinuxWebAppSlotIdentityArgs', 'LinuxWebAppSlotIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] key_vault_reference_identity_id: The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity).
        :param pulumi.Input[_builtins.str] kind: The Kind value for this Linux Web App.
        :param pulumi.Input[Union['LinuxWebAppSlotLogsArgs', 'LinuxWebAppSlotLogsArgsDict']] logs: A `logs` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] outbound_ip_address_lists: A list of outbound IP addresses - such as `["52.23.25.3", "52.143.43.12"]`
        :param pulumi.Input[_builtins.str] outbound_ip_addresses: A comma-separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] possible_outbound_ip_address_lists: A `possible_outbound_ip_address_list`.
        :param pulumi.Input[_builtins.str] possible_outbound_ip_addresses: A comma-separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12,52.143.43.17` - not all of which are necessarily in use. Superset of `outbound_ip_addresses`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Should public network access be enabled for the Web App. Defaults to `true`.
        :param pulumi.Input[_builtins.str] service_plan_id: The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Web App will be used.
               
               > **Note:** `service_plan_id` should only be specified if it differs from the Service Plan of the associated Linux Web App.
        :param pulumi.Input[Union['LinuxWebAppSlotSiteConfigArgs', 'LinuxWebAppSlotSiteConfigArgsDict']] site_config: A `site_config` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxWebAppSlotSiteCredentialArgs', 'LinuxWebAppSlotSiteCredentialArgsDict']]]] site_credentials: A `site_credential` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinuxWebAppSlotStorageAccountArgs', 'LinuxWebAppSlotStorageAccountArgsDict']]]] storage_accounts: One or more `storage_account` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags that should be assigned to the Linux Web App.
        :param pulumi.Input[_builtins.bool] webdeploy_publish_basic_authentication_enabled: Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.
               
               > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        :param pulumi.Input[_builtins.str] zip_deploy_file: The local path and filename of the Zip packaged application to deploy to this Linux Web App.
               
               > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://docs.microsoft.com/en-us/azure/app-service/deploy-run-package) for further details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinuxWebAppSlotState.__new__(_LinuxWebAppSlotState)

        __props__.__dict__["app_metadata"] = app_metadata
        __props__.__dict__["app_service_id"] = app_service_id
        __props__.__dict__["app_settings"] = app_settings
        __props__.__dict__["auth_settings"] = auth_settings
        __props__.__dict__["auth_settings_v2"] = auth_settings_v2
        __props__.__dict__["backup"] = backup
        __props__.__dict__["client_affinity_enabled"] = client_affinity_enabled
        __props__.__dict__["client_certificate_enabled"] = client_certificate_enabled
        __props__.__dict__["client_certificate_exclusion_paths"] = client_certificate_exclusion_paths
        __props__.__dict__["client_certificate_mode"] = client_certificate_mode
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["custom_domain_verification_id"] = custom_domain_verification_id
        __props__.__dict__["default_hostname"] = default_hostname
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["ftp_publish_basic_authentication_enabled"] = ftp_publish_basic_authentication_enabled
        __props__.__dict__["hosting_environment_id"] = hosting_environment_id
        __props__.__dict__["https_only"] = https_only
        __props__.__dict__["identity"] = identity
        __props__.__dict__["key_vault_reference_identity_id"] = key_vault_reference_identity_id
        __props__.__dict__["kind"] = kind
        __props__.__dict__["logs"] = logs
        __props__.__dict__["name"] = name
        __props__.__dict__["outbound_ip_address_lists"] = outbound_ip_address_lists
        __props__.__dict__["outbound_ip_addresses"] = outbound_ip_addresses
        __props__.__dict__["possible_outbound_ip_address_lists"] = possible_outbound_ip_address_lists
        __props__.__dict__["possible_outbound_ip_addresses"] = possible_outbound_ip_addresses
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["service_plan_id"] = service_plan_id
        __props__.__dict__["site_config"] = site_config
        __props__.__dict__["site_credentials"] = site_credentials
        __props__.__dict__["storage_accounts"] = storage_accounts
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_network_backup_restore_enabled"] = virtual_network_backup_restore_enabled
        __props__.__dict__["virtual_network_subnet_id"] = virtual_network_subnet_id
        __props__.__dict__["webdeploy_publish_basic_authentication_enabled"] = webdeploy_publish_basic_authentication_enabled
        __props__.__dict__["zip_deploy_file"] = zip_deploy_file
        return LinuxWebAppSlot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appMetadata")
    def app_metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A `app_metadata`.
        """
        return pulumi.get(self, "app_metadata")

    @_builtins.property
    @pulumi.getter(name="appServiceId")
    def app_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Linux Web App this Deployment Slot will be part of.
        """
        return pulumi.get(self, "app_service_id")

    @_builtins.property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of key-value pairs of App Settings.
        """
        return pulumi.get(self, "app_settings")

    @_builtins.property
    @pulumi.getter(name="authSettings")
    def auth_settings(self) -> pulumi.Output[Optional['outputs.LinuxWebAppSlotAuthSettings']]:
        """
        An `auth_settings` block as defined below.
        """
        return pulumi.get(self, "auth_settings")

    @_builtins.property
    @pulumi.getter(name="authSettingsV2")
    def auth_settings_v2(self) -> pulumi.Output[Optional['outputs.LinuxWebAppSlotAuthSettingsV2']]:
        """
        An `auth_settings_v2` block as defined below.
        """
        return pulumi.get(self, "auth_settings_v2")

    @_builtins.property
    @pulumi.getter
    def backup(self) -> pulumi.Output[Optional['outputs.LinuxWebAppSlotBackup']]:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @_builtins.property
    @pulumi.getter(name="clientAffinityEnabled")
    def client_affinity_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should Client Affinity be enabled?
        """
        return pulumi.get(self, "client_affinity_enabled")

    @_builtins.property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should Client Certificates be enabled?
        """
        return pulumi.get(self, "client_certificate_enabled")

    @_builtins.property
    @pulumi.getter(name="clientCertificateExclusionPaths")
    def client_certificate_exclusion_paths(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Paths to exclude when using client certificates, separated by ;
        """
        return pulumi.get(self, "client_certificate_exclusion_paths")

    @_builtins.property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Client Certificate mode. Possible values are `Required`, `Optional`, and `OptionalInteractiveUser`. This property has no effect when `client_cert_enabled` is `false`. Defaults to `Required`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Optional[Sequence['outputs.LinuxWebAppSlotConnectionString']]]:
        """
        One or more `connection_string` blocks as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @_builtins.property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier used by App Service to perform domain ownership verification via DNS TXT record.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @_builtins.property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The default hostname of the Linux Web App.
        """
        return pulumi.get(self, "default_hostname")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Linux Web App be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="ftpPublishBasicAuthenticationEnabled")
    def ftp_publish_basic_authentication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the default FTP Basic Authentication publishing profile be enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ftp_publish_basic_authentication_enabled")

    @_builtins.property
    @pulumi.getter(name="hostingEnvironmentId")
    def hosting_environment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the App Service Environment used by App Service Slot.
        """
        return pulumi.get(self, "hosting_environment_id")

    @_builtins.property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Linux Web App require HTTPS connections. Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.LinuxWebAppSlotIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="keyVaultReferenceIdentityId")
    def key_vault_reference_identity_id(self) -> pulumi.Output[_builtins.str]:
        """
        The User Assigned Identity ID used for accessing KeyVault secrets. The identity must be assigned to the application in the `identity` block. [For more information see - Access vaults with a user-assigned identity](https://docs.microsoft.com/azure/app-service/app-service-key-vault-references#access-vaults-with-a-user-assigned-identity).
        """
        return pulumi.get(self, "key_vault_reference_identity_id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[_builtins.str]:
        """
        The Kind value for this Linux Web App.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def logs(self) -> pulumi.Output[Optional['outputs.LinuxWebAppSlotLogs']]:
        """
        A `logs` block as defined below.
        """
        return pulumi.get(self, "logs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outboundIpAddressLists")
    def outbound_ip_address_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of outbound IP addresses - such as `["52.23.25.3", "52.143.43.12"]`
        """
        return pulumi.get(self, "outbound_ip_address_lists")

    @_builtins.property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> pulumi.Output[_builtins.str]:
        """
        A comma-separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12`.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="possibleOutboundIpAddressLists")
    def possible_outbound_ip_address_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A `possible_outbound_ip_address_list`.
        """
        return pulumi.get(self, "possible_outbound_ip_address_lists")

    @_builtins.property
    @pulumi.getter(name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> pulumi.Output[_builtins.str]:
        """
        A comma-separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12,52.143.43.17` - not all of which are necessarily in use. Superset of `outbound_ip_addresses`.
        """
        return pulumi.get(self, "possible_outbound_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should public network access be enabled for the Web App. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="servicePlanId")
    def service_plan_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Service Plan in which to run this slot. If not specified the same Service Plan as the Linux Web App will be used.

        > **Note:** `service_plan_id` should only be specified if it differs from the Service Plan of the associated Linux Web App.
        """
        return pulumi.get(self, "service_plan_id")

    @_builtins.property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> pulumi.Output['outputs.LinuxWebAppSlotSiteConfig']:
        """
        A `site_config` block as defined below.
        """
        return pulumi.get(self, "site_config")

    @_builtins.property
    @pulumi.getter(name="siteCredentials")
    def site_credentials(self) -> pulumi.Output[Sequence['outputs.LinuxWebAppSlotSiteCredential']]:
        """
        A `site_credential` block as defined below.
        """
        return pulumi.get(self, "site_credentials")

    @_builtins.property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> pulumi.Output[Optional[Sequence['outputs.LinuxWebAppSlotStorageAccount']]]:
        """
        One or more `storage_account` blocks as defined below.
        """
        return pulumi.get(self, "storage_accounts")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags that should be assigned to the Linux Web App.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkBackupRestoreEnabled")
    def virtual_network_backup_restore_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "virtual_network_backup_restore_enabled")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @_builtins.property
    @pulumi.getter(name="webdeployPublishBasicAuthenticationEnabled")
    def webdeploy_publish_basic_authentication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the default WebDeploy Basic Authentication publishing credentials enabled. Defaults to `true`.

        > **Note:** Setting this value to true will disable the ability to use `zip_deploy_file` which currently relies on the default publishing profile.
        """
        return pulumi.get(self, "webdeploy_publish_basic_authentication_enabled")

    @_builtins.property
    @pulumi.getter(name="zipDeployFile")
    def zip_deploy_file(self) -> pulumi.Output[_builtins.str]:
        """
        The local path and filename of the Zip packaged application to deploy to this Linux Web App.

        > **Note:** Using this value requires `WEBSITE_RUN_FROM_PACKAGE=1` to be set on the App in `app_settings`. Refer to the [Azure docs](https://docs.microsoft.com/en-us/azure/app-service/deploy-run-package) for further details.
        """
        return pulumi.get(self, "zip_deploy_file")

