# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['AccountEncryptionArgs']]]] = None,
                 identity: Optional[pulumi.Input['AccountIdentityArgs']] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Automation Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU of the account. Possible values are `Basic` and `Free`.
        :param pulumi.Input[Sequence[pulumi.Input['AccountEncryptionArgs']]] encryptions: An `encryption` block as defined below.
        :param pulumi.Input['AccountIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Whether requests using non-AAD authentication are blocked. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Automation Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for the automation account. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        if encryptions is not None:
            pulumi.set(__self__, "encryptions", encryptions)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the Automation Account is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        The SKU of the account. Possible values are `Basic` and `Free`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountEncryptionArgs']]]]:
        """
        An `encryption` block as defined below.
        """
        return pulumi.get(self, "encryptions")

    @encryptions.setter
    def encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountEncryptionArgs']]]]):
        pulumi.set(self, "encryptions", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AccountIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AccountIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether requests using non-AAD authentication are blocked. Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Automation Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public network access is allowed for the automation account. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 dsc_primary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 dsc_secondary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 dsc_server_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 encryptions: Optional[pulumi.Input[Sequence[pulumi.Input['AccountEncryptionArgs']]]] = None,
                 hybrid_service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['AccountIdentityArgs']] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_endpoint_connections: Optional[pulumi.Input[Sequence[pulumi.Input['AccountPrivateEndpointConnectionArgs']]]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[_builtins.str] dsc_primary_access_key: The Primary Access Key for the DSC Endpoint associated with this Automation Account.
        :param pulumi.Input[_builtins.str] dsc_secondary_access_key: The Secondary Access Key for the DSC Endpoint associated with this Automation Account.
        :param pulumi.Input[_builtins.str] dsc_server_endpoint: The DSC Server Endpoint associated with this Automation Account.
        :param pulumi.Input[Sequence[pulumi.Input['AccountEncryptionArgs']]] encryptions: An `encryption` block as defined below.
        :param pulumi.Input[_builtins.str] hybrid_service_url: The URL of automation hybrid service which is used for hybrid worker on-boarding With this Automation Account.
        :param pulumi.Input['AccountIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Whether requests using non-AAD authentication are blocked. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Automation Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for the automation account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Automation Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU of the account. Possible values are `Basic` and `Free`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if dsc_primary_access_key is not None:
            pulumi.set(__self__, "dsc_primary_access_key", dsc_primary_access_key)
        if dsc_secondary_access_key is not None:
            pulumi.set(__self__, "dsc_secondary_access_key", dsc_secondary_access_key)
        if dsc_server_endpoint is not None:
            pulumi.set(__self__, "dsc_server_endpoint", dsc_server_endpoint)
        if encryptions is not None:
            pulumi.set(__self__, "encryptions", encryptions)
        if hybrid_service_url is not None:
            pulumi.set(__self__, "hybrid_service_url", hybrid_service_url)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_endpoint_connections is not None:
            pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="dscPrimaryAccessKey")
    def dsc_primary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Primary Access Key for the DSC Endpoint associated with this Automation Account.
        """
        return pulumi.get(self, "dsc_primary_access_key")

    @dsc_primary_access_key.setter
    def dsc_primary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dsc_primary_access_key", value)

    @_builtins.property
    @pulumi.getter(name="dscSecondaryAccessKey")
    def dsc_secondary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Secondary Access Key for the DSC Endpoint associated with this Automation Account.
        """
        return pulumi.get(self, "dsc_secondary_access_key")

    @dsc_secondary_access_key.setter
    def dsc_secondary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dsc_secondary_access_key", value)

    @_builtins.property
    @pulumi.getter(name="dscServerEndpoint")
    def dsc_server_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DSC Server Endpoint associated with this Automation Account.
        """
        return pulumi.get(self, "dsc_server_endpoint")

    @dsc_server_endpoint.setter
    def dsc_server_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dsc_server_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def encryptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountEncryptionArgs']]]]:
        """
        An `encryption` block as defined below.
        """
        return pulumi.get(self, "encryptions")

    @encryptions.setter
    def encryptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountEncryptionArgs']]]]):
        pulumi.set(self, "encryptions", value)

    @_builtins.property
    @pulumi.getter(name="hybridServiceUrl")
    def hybrid_service_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of automation hybrid service which is used for hybrid worker on-boarding With this Automation Account.
        """
        return pulumi.get(self, "hybrid_service_url")

    @hybrid_service_url.setter
    def hybrid_service_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hybrid_service_url", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AccountIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AccountIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether requests using non-AAD authentication are blocked. Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Automation Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountPrivateEndpointConnectionArgs']]]]:
        return pulumi.get(self, "private_endpoint_connections")

    @private_endpoint_connections.setter
    def private_endpoint_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountPrivateEndpointConnectionArgs']]]]):
        pulumi.set(self, "private_endpoint_connections", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public network access is allowed for the automation account. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the Automation Account is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU of the account. Possible values are `Basic` and `Free`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:automation/account:Account")
class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountEncryptionArgs', 'AccountEncryptionArgsDict']]]]] = None,
                 identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Automation Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.automation.Account("example",
            name="example-account",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Basic",
            tags={
                "environment": "development",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Automation`: 2023-11-01, 2019-06-01

        ## Import

        Automation Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/account:Account account1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountEncryptionArgs', 'AccountEncryptionArgsDict']]]] encryptions: An `encryption` block as defined below.
        :param pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Whether requests using non-AAD authentication are blocked. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Automation Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for the automation account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Automation Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU of the account. Possible values are `Basic` and `Free`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Automation Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.automation.Account("example",
            name="example-account",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Basic",
            tags={
                "environment": "development",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Automation`: 2023-11-01, 2019-06-01

        ## Import

        Automation Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/account:Account account1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountEncryptionArgs', 'AccountEncryptionArgsDict']]]]] = None,
                 identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            __props__.__dict__["encryptions"] = encryptions
            __props__.__dict__["identity"] = identity
            __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["dsc_primary_access_key"] = None
            __props__.__dict__["dsc_secondary_access_key"] = None
            __props__.__dict__["dsc_server_endpoint"] = None
            __props__.__dict__["hybrid_service_url"] = None
            __props__.__dict__["private_endpoint_connections"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["dscPrimaryAccessKey", "dscSecondaryAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Account, __self__).__init__(
            'azure:automation/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dsc_primary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            dsc_secondary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            dsc_server_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            encryptions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountEncryptionArgs', 'AccountEncryptionArgsDict']]]]] = None,
            hybrid_service_url: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
            local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_endpoint_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountPrivateEndpointConnectionArgs', 'AccountPrivateEndpointConnectionArgsDict']]]]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dsc_primary_access_key: The Primary Access Key for the DSC Endpoint associated with this Automation Account.
        :param pulumi.Input[_builtins.str] dsc_secondary_access_key: The Secondary Access Key for the DSC Endpoint associated with this Automation Account.
        :param pulumi.Input[_builtins.str] dsc_server_endpoint: The DSC Server Endpoint associated with this Automation Account.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountEncryptionArgs', 'AccountEncryptionArgsDict']]]] encryptions: An `encryption` block as defined below.
        :param pulumi.Input[_builtins.str] hybrid_service_url: The URL of automation hybrid service which is used for hybrid worker on-boarding With this Automation Account.
        :param pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Whether requests using non-AAD authentication are blocked. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Automation Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for the automation account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Automation Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU of the account. Possible values are `Basic` and `Free`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["dsc_primary_access_key"] = dsc_primary_access_key
        __props__.__dict__["dsc_secondary_access_key"] = dsc_secondary_access_key
        __props__.__dict__["dsc_server_endpoint"] = dsc_server_endpoint
        __props__.__dict__["encryptions"] = encryptions
        __props__.__dict__["hybrid_service_url"] = hybrid_service_url
        __props__.__dict__["identity"] = identity
        __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["private_endpoint_connections"] = private_endpoint_connections
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["tags"] = tags
        return Account(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dscPrimaryAccessKey")
    def dsc_primary_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The Primary Access Key for the DSC Endpoint associated with this Automation Account.
        """
        return pulumi.get(self, "dsc_primary_access_key")

    @_builtins.property
    @pulumi.getter(name="dscSecondaryAccessKey")
    def dsc_secondary_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The Secondary Access Key for the DSC Endpoint associated with this Automation Account.
        """
        return pulumi.get(self, "dsc_secondary_access_key")

    @_builtins.property
    @pulumi.getter(name="dscServerEndpoint")
    def dsc_server_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The DSC Server Endpoint associated with this Automation Account.
        """
        return pulumi.get(self, "dsc_server_endpoint")

    @_builtins.property
    @pulumi.getter
    def encryptions(self) -> pulumi.Output[Optional[Sequence['outputs.AccountEncryption']]]:
        """
        An `encryption` block as defined below.
        """
        return pulumi.get(self, "encryptions")

    @_builtins.property
    @pulumi.getter(name="hybridServiceUrl")
    def hybrid_service_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of automation hybrid service which is used for hybrid worker on-boarding With this Automation Account.
        """
        return pulumi.get(self, "hybrid_service_url")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.AccountIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether requests using non-AAD authentication are blocked. Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Automation Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> pulumi.Output[Sequence['outputs.AccountPrivateEndpointConnection']]:
        return pulumi.get(self, "private_endpoint_connections")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether public network access is allowed for the automation account. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the Automation Account is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU of the account. Possible values are `Basic` and `Free`.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

