# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetappVolumeAttachmentArgs', 'NetappVolumeAttachment']

@pulumi.input_type
class NetappVolumeAttachmentArgs:
    def __init__(__self__, *,
                 netapp_volume_id: pulumi.Input[_builtins.str],
                 vmware_cluster_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetappVolumeAttachment resource.
        :param pulumi.Input[_builtins.str] netapp_volume_id: The netapp file volume for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to connect to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        :param pulumi.Input[_builtins.str] vmware_cluster_id: The vmware cluster for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to associated to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
               
               > **Note:** please follow the prerequisites mentioned in this [article](https://learn.microsoft.com/en-us/azure/azure-vmware/attach-azure-netapp-files-to-azure-vmware-solution-hosts?tabs=azure-portal#prerequisites) before associating the netapp file volume to the Azure VMware Solution hosts.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution Private Cloud Netapp File Volume Attachment. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        """
        pulumi.set(__self__, "netapp_volume_id", netapp_volume_id)
        pulumi.set(__self__, "vmware_cluster_id", vmware_cluster_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="netappVolumeId")
    def netapp_volume_id(self) -> pulumi.Input[_builtins.str]:
        """
        The netapp file volume for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to connect to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        """
        return pulumi.get(self, "netapp_volume_id")

    @netapp_volume_id.setter
    def netapp_volume_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "netapp_volume_id", value)

    @_builtins.property
    @pulumi.getter(name="vmwareClusterId")
    def vmware_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The vmware cluster for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to associated to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.

        > **Note:** please follow the prerequisites mentioned in this [article](https://learn.microsoft.com/en-us/azure/azure-vmware/attach-azure-netapp-files-to-azure-vmware-solution-hosts?tabs=azure-portal#prerequisites) before associating the netapp file volume to the Azure VMware Solution hosts.
        """
        return pulumi.get(self, "vmware_cluster_id")

    @vmware_cluster_id.setter
    def vmware_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vmware_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure VMware Solution Private Cloud Netapp File Volume Attachment. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetappVolumeAttachmentState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netapp_volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vmware_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetappVolumeAttachment resources.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution Private Cloud Netapp File Volume Attachment. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        :param pulumi.Input[_builtins.str] netapp_volume_id: The netapp file volume for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to connect to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        :param pulumi.Input[_builtins.str] vmware_cluster_id: The vmware cluster for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to associated to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
               
               > **Note:** please follow the prerequisites mentioned in this [article](https://learn.microsoft.com/en-us/azure/azure-vmware/attach-azure-netapp-files-to-azure-vmware-solution-hosts?tabs=azure-portal#prerequisites) before associating the netapp file volume to the Azure VMware Solution hosts.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if netapp_volume_id is not None:
            pulumi.set(__self__, "netapp_volume_id", netapp_volume_id)
        if vmware_cluster_id is not None:
            pulumi.set(__self__, "vmware_cluster_id", vmware_cluster_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure VMware Solution Private Cloud Netapp File Volume Attachment. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="netappVolumeId")
    def netapp_volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The netapp file volume for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to connect to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        """
        return pulumi.get(self, "netapp_volume_id")

    @netapp_volume_id.setter
    def netapp_volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "netapp_volume_id", value)

    @_builtins.property
    @pulumi.getter(name="vmwareClusterId")
    def vmware_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The vmware cluster for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to associated to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.

        > **Note:** please follow the prerequisites mentioned in this [article](https://learn.microsoft.com/en-us/azure/azure-vmware/attach-azure-netapp-files-to-azure-vmware-solution-hosts?tabs=azure-portal#prerequisites) before associating the netapp file volume to the Azure VMware Solution hosts.
        """
        return pulumi.get(self, "vmware_cluster_id")

    @vmware_cluster_id.setter
    def vmware_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vmware_cluster_id", value)


@pulumi.type_token("azure:avs/netappVolumeAttachment:NetappVolumeAttachment")
class NetappVolumeAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netapp_volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vmware_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure VMware Solution Private Cloud Netapp File Attachment.

        ## Example Usage

        > **Note:** For Azure Azure VMware Solution Private Cloud, normal `pulumi up` could ignore this note. Please disable correlation request id for continuous operations in one build (like acctest). The continuous operations like `update` or `delete` could not be triggered when it shares the same `correlation-id` with its previous operation.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        test = azure.network.PublicIp("test",
            name="example-public-ip",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            allocation_method="Static",
            sku="Standard")
        test_virtual_network = azure.network.VirtualNetwork("test",
            name="example-VirtualNetwork",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            address_spaces=["10.88.0.0/16"])
        netapp_subnet = azure.network.Subnet("netappSubnet",
            name="example-Subnet",
            resource_group_name=test_azurerm_resource_group["name"],
            virtual_network_name=test_virtual_network.name,
            address_prefixes=["10.88.2.0/24"],
            delegations=[{
                "name": "testdelegation",
                "service_delegation": {
                    "name": "Microsoft.Netapp/volumes",
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                },
            }])
        gateway_subnet = azure.network.Subnet("gatewaySubnet",
            name="GatewaySubnet",
            resource_group_name=test_azurerm_resource_group["name"],
            virtual_network_name=test_virtual_network.name,
            address_prefixes=["10.88.1.0/24"])
        test_virtual_network_gateway = azure.network.VirtualNetworkGateway("test",
            name="example-vnet-gateway",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            type="ExpressRoute",
            sku="Standard",
            ip_configurations=[{
                "name": "vnetGatewayConfig",
                "public_ip_address_id": test.id,
                "subnet_id": gateway_subnet.id,
            }])
        test_account = azure.netapp.Account("test",
            name="example-NetAppAccount",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"])
        test_pool = azure.netapp.Pool("test",
            name="example-NetAppPool",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            account_name=test_account.name,
            service_level="Standard",
            size_in_tb=4)
        test_volume = azure.netapp.Volume("test",
            name="example-NetAppVolume",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            account_name=test_account.name,
            pool_name=test_pool.name,
            volume_path="my-unique-file-path-%d",
            service_level="Standard",
            subnet_id=netapp_subnet.id,
            protocols=["NFSv3"],
            storage_quota_in_gb=100,
            azure_vmware_data_store_enabled=True,
            export_policy_rules=[{
                "rule_index": 1,
                "allowed_clients": ["0.0.0.0/0"],
                "protocols_enabled": "NFSv3",
                "unix_read_only": False,
                "unix_read_write": True,
                "root_access_enabled": True,
            }])
        test_private_cloud = azure.avs.PrivateCloud("test",
            name="example-PC",
            resource_group_name=test_azurerm_resource_group["name"],
            location=test_azurerm_resource_group["location"],
            sku_name="av36",
            management_cluster={
                "size": 3,
            },
            network_subnet_cidr="192.168.48.0/22")
        test_cluster = azure.avs.Cluster("test",
            name="example-vm-cluster",
            vmware_cloud_id=test_private_cloud.id,
            cluster_node_count=3,
            sku_name="av36")
        test_express_route_authorization = azure.avs.ExpressRouteAuthorization("test",
            name="example-VmwareAuthorization",
            private_cloud_id=test_private_cloud.id)
        test_virtual_network_gateway_connection = azure.network.VirtualNetworkGatewayConnection("test",
            name="example-vnetgwconn",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            type="ExpressRoute",
            virtual_network_gateway_id=test_virtual_network_gateway.id,
            express_route_circuit_id=test_private_cloud.circuits[0].express_route_id,
            authorization_key=test_express_route_authorization.express_route_authorization_key)
        test_netapp_volume_attachment = azure.avs.NetappVolumeAttachment("test",
            name="example-vmwareattachment",
            netapp_volume_id=test_volume.id,
            vmware_cluster_id=test_cluster.id,
            opts = pulumi.ResourceOptions(depends_on=[test_virtual_network_gateway_connection]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AVS`: 2022-05-01

        ## Import

        Azure VMware Solution Private Cloud Netapp File Volume Attachments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:avs/netappVolumeAttachment:NetappVolumeAttachment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/privateCloud1/clusters/Cluster1/dataStores/datastore1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution Private Cloud Netapp File Volume Attachment. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        :param pulumi.Input[_builtins.str] netapp_volume_id: The netapp file volume for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to connect to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        :param pulumi.Input[_builtins.str] vmware_cluster_id: The vmware cluster for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to associated to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
               
               > **Note:** please follow the prerequisites mentioned in this [article](https://learn.microsoft.com/en-us/azure/azure-vmware/attach-azure-netapp-files-to-azure-vmware-solution-hosts?tabs=azure-portal#prerequisites) before associating the netapp file volume to the Azure VMware Solution hosts.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetappVolumeAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure VMware Solution Private Cloud Netapp File Attachment.

        ## Example Usage

        > **Note:** For Azure Azure VMware Solution Private Cloud, normal `pulumi up` could ignore this note. Please disable correlation request id for continuous operations in one build (like acctest). The continuous operations like `update` or `delete` could not be triggered when it shares the same `correlation-id` with its previous operation.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        test = azure.network.PublicIp("test",
            name="example-public-ip",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            allocation_method="Static",
            sku="Standard")
        test_virtual_network = azure.network.VirtualNetwork("test",
            name="example-VirtualNetwork",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            address_spaces=["10.88.0.0/16"])
        netapp_subnet = azure.network.Subnet("netappSubnet",
            name="example-Subnet",
            resource_group_name=test_azurerm_resource_group["name"],
            virtual_network_name=test_virtual_network.name,
            address_prefixes=["10.88.2.0/24"],
            delegations=[{
                "name": "testdelegation",
                "service_delegation": {
                    "name": "Microsoft.Netapp/volumes",
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                },
            }])
        gateway_subnet = azure.network.Subnet("gatewaySubnet",
            name="GatewaySubnet",
            resource_group_name=test_azurerm_resource_group["name"],
            virtual_network_name=test_virtual_network.name,
            address_prefixes=["10.88.1.0/24"])
        test_virtual_network_gateway = azure.network.VirtualNetworkGateway("test",
            name="example-vnet-gateway",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            type="ExpressRoute",
            sku="Standard",
            ip_configurations=[{
                "name": "vnetGatewayConfig",
                "public_ip_address_id": test.id,
                "subnet_id": gateway_subnet.id,
            }])
        test_account = azure.netapp.Account("test",
            name="example-NetAppAccount",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"])
        test_pool = azure.netapp.Pool("test",
            name="example-NetAppPool",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            account_name=test_account.name,
            service_level="Standard",
            size_in_tb=4)
        test_volume = azure.netapp.Volume("test",
            name="example-NetAppVolume",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            account_name=test_account.name,
            pool_name=test_pool.name,
            volume_path="my-unique-file-path-%d",
            service_level="Standard",
            subnet_id=netapp_subnet.id,
            protocols=["NFSv3"],
            storage_quota_in_gb=100,
            azure_vmware_data_store_enabled=True,
            export_policy_rules=[{
                "rule_index": 1,
                "allowed_clients": ["0.0.0.0/0"],
                "protocols_enabled": "NFSv3",
                "unix_read_only": False,
                "unix_read_write": True,
                "root_access_enabled": True,
            }])
        test_private_cloud = azure.avs.PrivateCloud("test",
            name="example-PC",
            resource_group_name=test_azurerm_resource_group["name"],
            location=test_azurerm_resource_group["location"],
            sku_name="av36",
            management_cluster={
                "size": 3,
            },
            network_subnet_cidr="192.168.48.0/22")
        test_cluster = azure.avs.Cluster("test",
            name="example-vm-cluster",
            vmware_cloud_id=test_private_cloud.id,
            cluster_node_count=3,
            sku_name="av36")
        test_express_route_authorization = azure.avs.ExpressRouteAuthorization("test",
            name="example-VmwareAuthorization",
            private_cloud_id=test_private_cloud.id)
        test_virtual_network_gateway_connection = azure.network.VirtualNetworkGatewayConnection("test",
            name="example-vnetgwconn",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            type="ExpressRoute",
            virtual_network_gateway_id=test_virtual_network_gateway.id,
            express_route_circuit_id=test_private_cloud.circuits[0].express_route_id,
            authorization_key=test_express_route_authorization.express_route_authorization_key)
        test_netapp_volume_attachment = azure.avs.NetappVolumeAttachment("test",
            name="example-vmwareattachment",
            netapp_volume_id=test_volume.id,
            vmware_cluster_id=test_cluster.id,
            opts = pulumi.ResourceOptions(depends_on=[test_virtual_network_gateway_connection]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AVS`: 2022-05-01

        ## Import

        Azure VMware Solution Private Cloud Netapp File Volume Attachments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:avs/netappVolumeAttachment:NetappVolumeAttachment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/privateCloud1/clusters/Cluster1/dataStores/datastore1
        ```

        :param str resource_name: The name of the resource.
        :param NetappVolumeAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetappVolumeAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 netapp_volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vmware_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetappVolumeAttachmentArgs.__new__(NetappVolumeAttachmentArgs)

            __props__.__dict__["name"] = name
            if netapp_volume_id is None and not opts.urn:
                raise TypeError("Missing required property 'netapp_volume_id'")
            __props__.__dict__["netapp_volume_id"] = netapp_volume_id
            if vmware_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'vmware_cluster_id'")
            __props__.__dict__["vmware_cluster_id"] = vmware_cluster_id
        super(NetappVolumeAttachment, __self__).__init__(
            'azure:avs/netappVolumeAttachment:NetappVolumeAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            netapp_volume_id: Optional[pulumi.Input[_builtins.str]] = None,
            vmware_cluster_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetappVolumeAttachment':
        """
        Get an existing NetappVolumeAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure VMware Solution Private Cloud Netapp File Volume Attachment. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        :param pulumi.Input[_builtins.str] netapp_volume_id: The netapp file volume for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to connect to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        :param pulumi.Input[_builtins.str] vmware_cluster_id: The vmware cluster for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to associated to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
               
               > **Note:** please follow the prerequisites mentioned in this [article](https://learn.microsoft.com/en-us/azure/azure-vmware/attach-azure-netapp-files-to-azure-vmware-solution-hosts?tabs=azure-portal#prerequisites) before associating the netapp file volume to the Azure VMware Solution hosts.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetappVolumeAttachmentState.__new__(_NetappVolumeAttachmentState)

        __props__.__dict__["name"] = name
        __props__.__dict__["netapp_volume_id"] = netapp_volume_id
        __props__.__dict__["vmware_cluster_id"] = vmware_cluster_id
        return NetappVolumeAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Azure VMware Solution Private Cloud Netapp File Volume Attachment. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="netappVolumeId")
    def netapp_volume_id(self) -> pulumi.Output[_builtins.str]:
        """
        The netapp file volume for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to connect to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.
        """
        return pulumi.get(self, "netapp_volume_id")

    @_builtins.property
    @pulumi.getter(name="vmwareClusterId")
    def vmware_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The vmware cluster for this Azure VMware Solution Private Cloud Netapp File Volume Attachment to associated to. Changing this forces a new Azure VMware Solution Private Cloud Netapp File Volume Attachment to be created.

        > **Note:** please follow the prerequisites mentioned in this [article](https://learn.microsoft.com/en-us/azure/azure-vmware/attach-azure-netapp-files-to-azure-vmware-solution-hosts?tabs=azure-portal#prerequisites) before associating the netapp file volume to the Azure VMware Solution hosts.
        """
        return pulumi.get(self, "vmware_cluster_id")

