# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ChannelSlackArgs', 'ChannelSlack']

@pulumi.input_type
class ChannelSlackArgs:
    def __init__(__self__, *,
                 bot_name: pulumi.Input[_builtins.str],
                 client_id: pulumi.Input[_builtins.str],
                 client_secret: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 verification_token: pulumi.Input[_builtins.str],
                 landing_page_url: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_secret: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ChannelSlack resource.
        :param pulumi.Input[_builtins.str] bot_name: The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] client_id: The Client ID that will be used to authenticate with Slack.
        :param pulumi.Input[_builtins.str] client_secret: The Client Secret that will be used to authenticate with Slack.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Bot Channel. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] verification_token: The Verification Token that will be used to authenticate with Slack.
        :param pulumi.Input[_builtins.str] landing_page_url: The Slack Landing Page URL.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signing_secret: The Signing Secret that will be used to sign the requests.
        """
        pulumi.set(__self__, "bot_name", bot_name)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "verification_token", verification_token)
        if landing_page_url is not None:
            pulumi.set(__self__, "landing_page_url", landing_page_url)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if signing_secret is not None:
            pulumi.set(__self__, "signing_secret", signing_secret)

    @_builtins.property
    @pulumi.getter(name="botName")
    def bot_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "bot_name")

    @bot_name.setter
    def bot_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bot_name", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Client ID that will be used to authenticate with Slack.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[_builtins.str]:
        """
        The Client Secret that will be used to authenticate with Slack.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Bot Channel. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="verificationToken")
    def verification_token(self) -> pulumi.Input[_builtins.str]:
        """
        The Verification Token that will be used to authenticate with Slack.
        """
        return pulumi.get(self, "verification_token")

    @verification_token.setter
    def verification_token(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "verification_token", value)

    @_builtins.property
    @pulumi.getter(name="landingPageUrl")
    def landing_page_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Slack Landing Page URL.
        """
        return pulumi.get(self, "landing_page_url")

    @landing_page_url.setter
    def landing_page_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "landing_page_url", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="signingSecret")
    def signing_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Signing Secret that will be used to sign the requests.
        """
        return pulumi.get(self, "signing_secret")

    @signing_secret.setter
    def signing_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signing_secret", value)


@pulumi.input_type
class _ChannelSlackState:
    def __init__(__self__, *,
                 bot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 landing_page_url: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_token: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ChannelSlack resources.
        :param pulumi.Input[_builtins.str] bot_name: The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] client_id: The Client ID that will be used to authenticate with Slack.
        :param pulumi.Input[_builtins.str] client_secret: The Client Secret that will be used to authenticate with Slack.
        :param pulumi.Input[_builtins.str] landing_page_url: The Slack Landing Page URL.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Bot Channel. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signing_secret: The Signing Secret that will be used to sign the requests.
        :param pulumi.Input[_builtins.str] verification_token: The Verification Token that will be used to authenticate with Slack.
        """
        if bot_name is not None:
            pulumi.set(__self__, "bot_name", bot_name)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if landing_page_url is not None:
            pulumi.set(__self__, "landing_page_url", landing_page_url)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if signing_secret is not None:
            pulumi.set(__self__, "signing_secret", signing_secret)
        if verification_token is not None:
            pulumi.set(__self__, "verification_token", verification_token)

    @_builtins.property
    @pulumi.getter(name="botName")
    def bot_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "bot_name")

    @bot_name.setter
    def bot_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bot_name", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID that will be used to authenticate with Slack.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client Secret that will be used to authenticate with Slack.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="landingPageUrl")
    def landing_page_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Slack Landing Page URL.
        """
        return pulumi.get(self, "landing_page_url")

    @landing_page_url.setter
    def landing_page_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "landing_page_url", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Bot Channel. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="signingSecret")
    def signing_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Signing Secret that will be used to sign the requests.
        """
        return pulumi.get(self, "signing_secret")

    @signing_secret.setter
    def signing_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signing_secret", value)

    @_builtins.property
    @pulumi.getter(name="verificationToken")
    def verification_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Verification Token that will be used to authenticate with Slack.
        """
        return pulumi.get(self, "verification_token")

    @verification_token.setter
    def verification_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "verification_token", value)


@pulumi.type_token("azure:bot/channelSlack:ChannelSlack")
class ChannelSlack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 landing_page_url: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_token: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Slack integration for a Bot Channel

        > **Note:** A bot can only have a single Slack Channel associated with it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_channels_registration = azure.bot.ChannelsRegistration("example",
            name="example",
            location="global",
            resource_group_name=example.name,
            sku="F0",
            microsoft_app_id=current.client_id)
        example_channel_slack = azure.bot.ChannelSlack("example",
            bot_name=example_channels_registration.name,
            location=example_channels_registration.location,
            resource_group_name=example.name,
            client_id="exampleId",
            client_secret="exampleSecret",
            verification_token="exampleVerificationToken")
        ```

        ## Import

        The Slack Integration for a Bot Channel can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:bot/channelSlack:ChannelSlack example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.BotService/botServices/example/channels/SlackChannel
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bot_name: The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] client_id: The Client ID that will be used to authenticate with Slack.
        :param pulumi.Input[_builtins.str] client_secret: The Client Secret that will be used to authenticate with Slack.
        :param pulumi.Input[_builtins.str] landing_page_url: The Slack Landing Page URL.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Bot Channel. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signing_secret: The Signing Secret that will be used to sign the requests.
        :param pulumi.Input[_builtins.str] verification_token: The Verification Token that will be used to authenticate with Slack.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChannelSlackArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Slack integration for a Bot Channel

        > **Note:** A bot can only have a single Slack Channel associated with it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_channels_registration = azure.bot.ChannelsRegistration("example",
            name="example",
            location="global",
            resource_group_name=example.name,
            sku="F0",
            microsoft_app_id=current.client_id)
        example_channel_slack = azure.bot.ChannelSlack("example",
            bot_name=example_channels_registration.name,
            location=example_channels_registration.location,
            resource_group_name=example.name,
            client_id="exampleId",
            client_secret="exampleSecret",
            verification_token="exampleVerificationToken")
        ```

        ## Import

        The Slack Integration for a Bot Channel can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:bot/channelSlack:ChannelSlack example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.BotService/botServices/example/channels/SlackChannel
        ```

        :param str resource_name: The name of the resource.
        :param ChannelSlackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelSlackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 landing_page_url: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 verification_token: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelSlackArgs.__new__(ChannelSlackArgs)

            if bot_name is None and not opts.urn:
                raise TypeError("Missing required property 'bot_name'")
            __props__.__dict__["bot_name"] = bot_name
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            if client_secret is None and not opts.urn:
                raise TypeError("Missing required property 'client_secret'")
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["landing_page_url"] = landing_page_url
            __props__.__dict__["location"] = location
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["signing_secret"] = None if signing_secret is None else pulumi.Output.secret(signing_secret)
            if verification_token is None and not opts.urn:
                raise TypeError("Missing required property 'verification_token'")
            __props__.__dict__["verification_token"] = None if verification_token is None else pulumi.Output.secret(verification_token)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret", "signingSecret", "verificationToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ChannelSlack, __self__).__init__(
            'azure:bot/channelSlack:ChannelSlack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bot_name: Optional[pulumi.Input[_builtins.str]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            client_secret: Optional[pulumi.Input[_builtins.str]] = None,
            landing_page_url: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            signing_secret: Optional[pulumi.Input[_builtins.str]] = None,
            verification_token: Optional[pulumi.Input[_builtins.str]] = None) -> 'ChannelSlack':
        """
        Get an existing ChannelSlack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bot_name: The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] client_id: The Client ID that will be used to authenticate with Slack.
        :param pulumi.Input[_builtins.str] client_secret: The Client Secret that will be used to authenticate with Slack.
        :param pulumi.Input[_builtins.str] landing_page_url: The Slack Landing Page URL.
        :param pulumi.Input[_builtins.str] location: The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Bot Channel. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signing_secret: The Signing Secret that will be used to sign the requests.
        :param pulumi.Input[_builtins.str] verification_token: The Verification Token that will be used to authenticate with Slack.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ChannelSlackState.__new__(_ChannelSlackState)

        __props__.__dict__["bot_name"] = bot_name
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["landing_page_url"] = landing_page_url
        __props__.__dict__["location"] = location
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["signing_secret"] = signing_secret
        __props__.__dict__["verification_token"] = verification_token
        return ChannelSlack(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="botName")
    def bot_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Bot Resource this channel will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "bot_name")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Client ID that will be used to authenticate with Slack.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[_builtins.str]:
        """
        The Client Secret that will be used to authenticate with Slack.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="landingPageUrl")
    def landing_page_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Slack Landing Page URL.
        """
        return pulumi.get(self, "landing_page_url")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Bot Channel. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="signingSecret")
    def signing_secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Signing Secret that will be used to sign the requests.
        """
        return pulumi.get(self, "signing_secret")

    @_builtins.property
    @pulumi.getter(name="verificationToken")
    def verification_token(self) -> pulumi.Output[_builtins.str]:
        """
        The Verification Token that will be used to authenticate with Slack.
        """
        return pulumi.get(self, "verification_token")

