# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FrontdoorOriginArgs', 'FrontdoorOrigin']

@pulumi.input_type
class FrontdoorOriginArgs:
    def __init__(__self__, *,
                 cdn_frontdoor_origin_group_id: pulumi.Input[_builtins.str],
                 certificate_name_check_enabled: pulumi.Input[_builtins.bool],
                 host_name: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http_port: Optional[pulumi.Input[_builtins.int]] = None,
                 https_port: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_host_header: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 private_link: Optional[pulumi.Input['FrontdoorOriginPrivateLinkArgs']] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a FrontdoorOrigin resource.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_origin_group_id: The ID of the Front Door Origin Group within which this Front Door Origin should exist. Changing this forces a new Front Door Origin to be created.
        :param pulumi.Input[_builtins.bool] certificate_name_check_enabled: Specifies whether certificate name checks are enabled for this origin.
        :param pulumi.Input[_builtins.str] host_name: The IPv4 address, IPv6 address or Domain name of the Origin.
               
               !> **Note:** This must be unique across all Front Door Origins within a Front Door Endpoint.
        :param pulumi.Input[_builtins.bool] enabled: Should the origin be enabled? Possible values are `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.int] http_port: The value of the HTTP port. Must be between `1` and `65535`. Defaults to `80`.
        :param pulumi.Input[_builtins.int] https_port: The value of the HTTPS port. Must be between `1` and `65535`. Defaults to `443`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Origin. Changing this forces a new Front Door Origin to be created.
        :param pulumi.Input[_builtins.str] origin_host_header: The host header value (an IPv4 address, IPv6 address or Domain name) which is sent to the origin with each request. If unspecified the hostname from the request will be used.
               
               > **Note:** Azure Front Door Origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin's hostname. This field's value overrides the host header defined in the Front Door Endpoint. For more information on how to properly set the origin host header value please see the [product documentation](https://docs.microsoft.com/azure/frontdoor/origin?pivots=front-door-standard-premium#origin-host-header).
        :param pulumi.Input[_builtins.int] priority: Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy. Must be between `1` and `5` (inclusive). Defaults to `1`.
        :param pulumi.Input['FrontdoorOriginPrivateLinkArgs'] private_link: A `private_link` block as defined below.
               
               > **Note:** Private Link requires that the Front Door Profile this Origin is hosted within is using the SKU `Premium_AzureFrontDoor` and that the `certificate_name_check_enabled` field is set to `true`.
        :param pulumi.Input[_builtins.int] weight: The weight of the origin in a given origin group for load balancing. Must be between `1` and `1000`. Defaults to `500`.
        """
        pulumi.set(__self__, "cdn_frontdoor_origin_group_id", cdn_frontdoor_origin_group_id)
        pulumi.set(__self__, "certificate_name_check_enabled", certificate_name_check_enabled)
        pulumi.set(__self__, "host_name", host_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if origin_host_header is not None:
            pulumi.set(__self__, "origin_host_header", origin_host_header)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if private_link is not None:
            pulumi.set(__self__, "private_link", private_link)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorOriginGroupId")
    def cdn_frontdoor_origin_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Front Door Origin Group within which this Front Door Origin should exist. Changing this forces a new Front Door Origin to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_origin_group_id")

    @cdn_frontdoor_origin_group_id.setter
    def cdn_frontdoor_origin_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cdn_frontdoor_origin_group_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateNameCheckEnabled")
    def certificate_name_check_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Specifies whether certificate name checks are enabled for this origin.
        """
        return pulumi.get(self, "certificate_name_check_enabled")

    @certificate_name_check_enabled.setter
    def certificate_name_check_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "certificate_name_check_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[_builtins.str]:
        """
        The IPv4 address, IPv6 address or Domain name of the Origin.

        !> **Note:** This must be unique across all Front Door Origins within a Front Door Endpoint.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the origin be enabled? Possible values are `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The value of the HTTP port. Must be between `1` and `65535`. Defaults to `80`.
        """
        return pulumi.get(self, "http_port")

    @http_port.setter
    def http_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "http_port", value)

    @_builtins.property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The value of the HTTPS port. Must be between `1` and `65535`. Defaults to `443`.
        """
        return pulumi.get(self, "https_port")

    @https_port.setter
    def https_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "https_port", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Front Door Origin. Changing this forces a new Front Door Origin to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="originHostHeader")
    def origin_host_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host header value (an IPv4 address, IPv6 address or Domain name) which is sent to the origin with each request. If unspecified the hostname from the request will be used.

        > **Note:** Azure Front Door Origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin's hostname. This field's value overrides the host header defined in the Front Door Endpoint. For more information on how to properly set the origin host header value please see the [product documentation](https://docs.microsoft.com/azure/frontdoor/origin?pivots=front-door-standard-premium#origin-host-header).
        """
        return pulumi.get(self, "origin_host_header")

    @origin_host_header.setter
    def origin_host_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_host_header", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy. Must be between `1` and `5` (inclusive). Defaults to `1`.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="privateLink")
    def private_link(self) -> Optional[pulumi.Input['FrontdoorOriginPrivateLinkArgs']]:
        """
        A `private_link` block as defined below.

        > **Note:** Private Link requires that the Front Door Profile this Origin is hosted within is using the SKU `Premium_AzureFrontDoor` and that the `certificate_name_check_enabled` field is set to `true`.
        """
        return pulumi.get(self, "private_link")

    @private_link.setter
    def private_link(self, value: Optional[pulumi.Input['FrontdoorOriginPrivateLinkArgs']]):
        pulumi.set(self, "private_link", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The weight of the origin in a given origin group for load balancing. Must be between `1` and `1000`. Defaults to `500`.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class _FrontdoorOriginState:
    def __init__(__self__, *,
                 cdn_frontdoor_origin_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_name_check_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http_port: Optional[pulumi.Input[_builtins.int]] = None,
                 https_port: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_host_header: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 private_link: Optional[pulumi.Input['FrontdoorOriginPrivateLinkArgs']] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering FrontdoorOrigin resources.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_origin_group_id: The ID of the Front Door Origin Group within which this Front Door Origin should exist. Changing this forces a new Front Door Origin to be created.
        :param pulumi.Input[_builtins.bool] certificate_name_check_enabled: Specifies whether certificate name checks are enabled for this origin.
        :param pulumi.Input[_builtins.bool] enabled: Should the origin be enabled? Possible values are `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] host_name: The IPv4 address, IPv6 address or Domain name of the Origin.
               
               !> **Note:** This must be unique across all Front Door Origins within a Front Door Endpoint.
        :param pulumi.Input[_builtins.int] http_port: The value of the HTTP port. Must be between `1` and `65535`. Defaults to `80`.
        :param pulumi.Input[_builtins.int] https_port: The value of the HTTPS port. Must be between `1` and `65535`. Defaults to `443`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Origin. Changing this forces a new Front Door Origin to be created.
        :param pulumi.Input[_builtins.str] origin_host_header: The host header value (an IPv4 address, IPv6 address or Domain name) which is sent to the origin with each request. If unspecified the hostname from the request will be used.
               
               > **Note:** Azure Front Door Origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin's hostname. This field's value overrides the host header defined in the Front Door Endpoint. For more information on how to properly set the origin host header value please see the [product documentation](https://docs.microsoft.com/azure/frontdoor/origin?pivots=front-door-standard-premium#origin-host-header).
        :param pulumi.Input[_builtins.int] priority: Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy. Must be between `1` and `5` (inclusive). Defaults to `1`.
        :param pulumi.Input['FrontdoorOriginPrivateLinkArgs'] private_link: A `private_link` block as defined below.
               
               > **Note:** Private Link requires that the Front Door Profile this Origin is hosted within is using the SKU `Premium_AzureFrontDoor` and that the `certificate_name_check_enabled` field is set to `true`.
        :param pulumi.Input[_builtins.int] weight: The weight of the origin in a given origin group for load balancing. Must be between `1` and `1000`. Defaults to `500`.
        """
        if cdn_frontdoor_origin_group_id is not None:
            pulumi.set(__self__, "cdn_frontdoor_origin_group_id", cdn_frontdoor_origin_group_id)
        if certificate_name_check_enabled is not None:
            pulumi.set(__self__, "certificate_name_check_enabled", certificate_name_check_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if origin_host_header is not None:
            pulumi.set(__self__, "origin_host_header", origin_host_header)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if private_link is not None:
            pulumi.set(__self__, "private_link", private_link)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorOriginGroupId")
    def cdn_frontdoor_origin_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Front Door Origin Group within which this Front Door Origin should exist. Changing this forces a new Front Door Origin to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_origin_group_id")

    @cdn_frontdoor_origin_group_id.setter
    def cdn_frontdoor_origin_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdn_frontdoor_origin_group_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateNameCheckEnabled")
    def certificate_name_check_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether certificate name checks are enabled for this origin.
        """
        return pulumi.get(self, "certificate_name_check_enabled")

    @certificate_name_check_enabled.setter
    def certificate_name_check_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "certificate_name_check_enabled", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the origin be enabled? Possible values are `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address, IPv6 address or Domain name of the Origin.

        !> **Note:** This must be unique across all Front Door Origins within a Front Door Endpoint.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The value of the HTTP port. Must be between `1` and `65535`. Defaults to `80`.
        """
        return pulumi.get(self, "http_port")

    @http_port.setter
    def http_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "http_port", value)

    @_builtins.property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The value of the HTTPS port. Must be between `1` and `65535`. Defaults to `443`.
        """
        return pulumi.get(self, "https_port")

    @https_port.setter
    def https_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "https_port", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Front Door Origin. Changing this forces a new Front Door Origin to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="originHostHeader")
    def origin_host_header(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host header value (an IPv4 address, IPv6 address or Domain name) which is sent to the origin with each request. If unspecified the hostname from the request will be used.

        > **Note:** Azure Front Door Origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin's hostname. This field's value overrides the host header defined in the Front Door Endpoint. For more information on how to properly set the origin host header value please see the [product documentation](https://docs.microsoft.com/azure/frontdoor/origin?pivots=front-door-standard-premium#origin-host-header).
        """
        return pulumi.get(self, "origin_host_header")

    @origin_host_header.setter
    def origin_host_header(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_host_header", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy. Must be between `1` and `5` (inclusive). Defaults to `1`.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="privateLink")
    def private_link(self) -> Optional[pulumi.Input['FrontdoorOriginPrivateLinkArgs']]:
        """
        A `private_link` block as defined below.

        > **Note:** Private Link requires that the Front Door Profile this Origin is hosted within is using the SKU `Premium_AzureFrontDoor` and that the `certificate_name_check_enabled` field is set to `true`.
        """
        return pulumi.get(self, "private_link")

    @private_link.setter
    def private_link(self, value: Optional[pulumi.Input['FrontdoorOriginPrivateLinkArgs']]):
        pulumi.set(self, "private_link", value)

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The weight of the origin in a given origin group for load balancing. Must be between `1` and `1000`. Defaults to `500`.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "weight", value)


@pulumi.type_token("azure:cdn/frontdoorOrigin:FrontdoorOrigin")
class FrontdoorOrigin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdn_frontdoor_origin_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_name_check_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http_port: Optional[pulumi.Input[_builtins.int]] = None,
                 https_port: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_host_header: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 private_link: Optional[pulumi.Input[Union['FrontdoorOriginPrivateLinkArgs', 'FrontdoorOriginPrivateLinkArgsDict']]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a Front Door (standard/premium) Origin.

        !> **Note:** If you are attempting to implement an Origin that uses its own Private Link Service with a Load Balancer the Profile resource in your configuration file **must** have a `depends_on` meta-argument which references the `privatedns.LinkService`, see `Example Usage With Private Link Service` below.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Premium_AzureFrontDoor")
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="example-origingroup",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            load_balancing={})
        example_frontdoor_origin = azure.cdn.FrontdoorOrigin("example",
            name="example-origin",
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            enabled=True,
            certificate_name_check_enabled=False,
            host_name="contoso.com",
            http_port=80,
            https_port=443,
            origin_host_header="www.contoso.com",
            priority=1,
            weight=1)
        ```

        ### With Private Link

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestoracc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Premium",
            account_replication_type="LRS",
            allow_nested_items_to_be_public=False,
            network_rules={
                "default_action": "Deny",
            },
            tags={
                "environment": "Example",
            })
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Premium_AzureFrontDoor")
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="example-origin-group",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            load_balancing={})
        example_frontdoor_origin = azure.cdn.FrontdoorOrigin("example",
            name="example-origin",
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            enabled=True,
            certificate_name_check_enabled=True,
            host_name=example_account.primary_blob_host,
            origin_host_header=example_account.primary_blob_host,
            priority=1,
            weight=500,
            private_link={
                "request_message": "Request access for Private Link Origin CDN Frontdoor",
                "target_type": "blob",
                "location": example_account.location,
                "private_link_target_id": example_account.id,
            })
        ```

        ### With Private Link Service

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="vn-example",
            resource_group_name=example.name,
            location=example.location,
            address_spaces=["10.5.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="sn-example",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.5.1.0/24"],
            private_link_service_network_policies_enabled=False)
        example_public_ip = azure.network.PublicIp("example",
            name="ip-example",
            sku="Standard",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="lb-example",
            sku="Standard",
            location=example.location,
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": example_public_ip.name,
                "public_ip_address_id": example_public_ip.id,
            }])
        example_link_service = azure.privatedns.LinkService("example",
            name="pls-example",
            resource_group_name=example.name,
            location=example.location,
            visibility_subscription_ids=[current.subscription_id],
            load_balancer_frontend_ip_configuration_ids=[example_load_balancer.frontend_ip_configurations[0].id],
            nat_ip_configurations=[{
                "name": "primary",
                "private_ip_address": "10.5.1.17",
                "private_ip_address_version": "IPv4",
                "subnet_id": example_subnet.id,
                "primary": True,
            }])
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="profile-example",
            resource_group_name=example.name,
            sku_name="Premium_AzureFrontDoor",
            opts = pulumi.ResourceOptions(depends_on=[example_link_service]))
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="group-example",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            load_balancing={
                "additional_latency_in_milliseconds": 0,
                "sample_size": 16,
                "successful_samples_required": 3,
            })
        example_frontdoor_origin = azure.cdn.FrontdoorOrigin("example",
            name="origin-example",
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            enabled=True,
            host_name="example.com",
            origin_host_header="example.com",
            priority=1,
            weight=1000,
            certificate_name_check_enabled=False,
            private_link={
                "request_message": "Request access for Private Link Origin CDN Frontdoor",
                "location": example.location,
                "private_link_target_id": example_link_service.id,
            })
        ```

        ## Example HCL Configurations

        * Private Link Origin with Storage Account Blob
        * Private Link Origin with Storage Account Static Web Site
        * Private Link Origin with Linux Web Application
        * Private Link Origin with Internal Load Balancer

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Cdn`: 2024-02-01

        ## Import

        Front Door Origins can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorOrigin:FrontdoorOrigin example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/originGroups/originGroup1/origins/origin1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_origin_group_id: The ID of the Front Door Origin Group within which this Front Door Origin should exist. Changing this forces a new Front Door Origin to be created.
        :param pulumi.Input[_builtins.bool] certificate_name_check_enabled: Specifies whether certificate name checks are enabled for this origin.
        :param pulumi.Input[_builtins.bool] enabled: Should the origin be enabled? Possible values are `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] host_name: The IPv4 address, IPv6 address or Domain name of the Origin.
               
               !> **Note:** This must be unique across all Front Door Origins within a Front Door Endpoint.
        :param pulumi.Input[_builtins.int] http_port: The value of the HTTP port. Must be between `1` and `65535`. Defaults to `80`.
        :param pulumi.Input[_builtins.int] https_port: The value of the HTTPS port. Must be between `1` and `65535`. Defaults to `443`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Origin. Changing this forces a new Front Door Origin to be created.
        :param pulumi.Input[_builtins.str] origin_host_header: The host header value (an IPv4 address, IPv6 address or Domain name) which is sent to the origin with each request. If unspecified the hostname from the request will be used.
               
               > **Note:** Azure Front Door Origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin's hostname. This field's value overrides the host header defined in the Front Door Endpoint. For more information on how to properly set the origin host header value please see the [product documentation](https://docs.microsoft.com/azure/frontdoor/origin?pivots=front-door-standard-premium#origin-host-header).
        :param pulumi.Input[_builtins.int] priority: Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy. Must be between `1` and `5` (inclusive). Defaults to `1`.
        :param pulumi.Input[Union['FrontdoorOriginPrivateLinkArgs', 'FrontdoorOriginPrivateLinkArgsDict']] private_link: A `private_link` block as defined below.
               
               > **Note:** Private Link requires that the Front Door Profile this Origin is hosted within is using the SKU `Premium_AzureFrontDoor` and that the `certificate_name_check_enabled` field is set to `true`.
        :param pulumi.Input[_builtins.int] weight: The weight of the origin in a given origin group for load balancing. Must be between `1` and `1000`. Defaults to `500`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FrontdoorOriginArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Front Door (standard/premium) Origin.

        !> **Note:** If you are attempting to implement an Origin that uses its own Private Link Service with a Load Balancer the Profile resource in your configuration file **must** have a `depends_on` meta-argument which references the `privatedns.LinkService`, see `Example Usage With Private Link Service` below.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Premium_AzureFrontDoor")
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="example-origingroup",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            load_balancing={})
        example_frontdoor_origin = azure.cdn.FrontdoorOrigin("example",
            name="example-origin",
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            enabled=True,
            certificate_name_check_enabled=False,
            host_name="contoso.com",
            http_port=80,
            https_port=443,
            origin_host_header="www.contoso.com",
            priority=1,
            weight=1)
        ```

        ### With Private Link

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestoracc",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Premium",
            account_replication_type="LRS",
            allow_nested_items_to_be_public=False,
            network_rules={
                "default_action": "Deny",
            },
            tags={
                "environment": "Example",
            })
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Premium_AzureFrontDoor")
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="example-origin-group",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            load_balancing={})
        example_frontdoor_origin = azure.cdn.FrontdoorOrigin("example",
            name="example-origin",
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            enabled=True,
            certificate_name_check_enabled=True,
            host_name=example_account.primary_blob_host,
            origin_host_header=example_account.primary_blob_host,
            priority=1,
            weight=500,
            private_link={
                "request_message": "Request access for Private Link Origin CDN Frontdoor",
                "target_type": "blob",
                "location": example_account.location,
                "private_link_target_id": example_account.id,
            })
        ```

        ### With Private Link Service

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="vn-example",
            resource_group_name=example.name,
            location=example.location,
            address_spaces=["10.5.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="sn-example",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.5.1.0/24"],
            private_link_service_network_policies_enabled=False)
        example_public_ip = azure.network.PublicIp("example",
            name="ip-example",
            sku="Standard",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="lb-example",
            sku="Standard",
            location=example.location,
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": example_public_ip.name,
                "public_ip_address_id": example_public_ip.id,
            }])
        example_link_service = azure.privatedns.LinkService("example",
            name="pls-example",
            resource_group_name=example.name,
            location=example.location,
            visibility_subscription_ids=[current.subscription_id],
            load_balancer_frontend_ip_configuration_ids=[example_load_balancer.frontend_ip_configurations[0].id],
            nat_ip_configurations=[{
                "name": "primary",
                "private_ip_address": "10.5.1.17",
                "private_ip_address_version": "IPv4",
                "subnet_id": example_subnet.id,
                "primary": True,
            }])
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="profile-example",
            resource_group_name=example.name,
            sku_name="Premium_AzureFrontDoor",
            opts = pulumi.ResourceOptions(depends_on=[example_link_service]))
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="group-example",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            load_balancing={
                "additional_latency_in_milliseconds": 0,
                "sample_size": 16,
                "successful_samples_required": 3,
            })
        example_frontdoor_origin = azure.cdn.FrontdoorOrigin("example",
            name="origin-example",
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            enabled=True,
            host_name="example.com",
            origin_host_header="example.com",
            priority=1,
            weight=1000,
            certificate_name_check_enabled=False,
            private_link={
                "request_message": "Request access for Private Link Origin CDN Frontdoor",
                "location": example.location,
                "private_link_target_id": example_link_service.id,
            })
        ```

        ## Example HCL Configurations

        * Private Link Origin with Storage Account Blob
        * Private Link Origin with Storage Account Static Web Site
        * Private Link Origin with Linux Web Application
        * Private Link Origin with Internal Load Balancer

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Cdn`: 2024-02-01

        ## Import

        Front Door Origins can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorOrigin:FrontdoorOrigin example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/originGroups/originGroup1/origins/origin1
        ```

        :param str resource_name: The name of the resource.
        :param FrontdoorOriginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FrontdoorOriginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdn_frontdoor_origin_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_name_check_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 http_port: Optional[pulumi.Input[_builtins.int]] = None,
                 https_port: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_host_header: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 private_link: Optional[pulumi.Input[Union['FrontdoorOriginPrivateLinkArgs', 'FrontdoorOriginPrivateLinkArgsDict']]] = None,
                 weight: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FrontdoorOriginArgs.__new__(FrontdoorOriginArgs)

            if cdn_frontdoor_origin_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'cdn_frontdoor_origin_group_id'")
            __props__.__dict__["cdn_frontdoor_origin_group_id"] = cdn_frontdoor_origin_group_id
            if certificate_name_check_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_name_check_enabled'")
            __props__.__dict__["certificate_name_check_enabled"] = certificate_name_check_enabled
            __props__.__dict__["enabled"] = enabled
            if host_name is None and not opts.urn:
                raise TypeError("Missing required property 'host_name'")
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["http_port"] = http_port
            __props__.__dict__["https_port"] = https_port
            __props__.__dict__["name"] = name
            __props__.__dict__["origin_host_header"] = origin_host_header
            __props__.__dict__["priority"] = priority
            __props__.__dict__["private_link"] = private_link
            __props__.__dict__["weight"] = weight
        super(FrontdoorOrigin, __self__).__init__(
            'azure:cdn/frontdoorOrigin:FrontdoorOrigin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cdn_frontdoor_origin_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_name_check_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            host_name: Optional[pulumi.Input[_builtins.str]] = None,
            http_port: Optional[pulumi.Input[_builtins.int]] = None,
            https_port: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            origin_host_header: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            private_link: Optional[pulumi.Input[Union['FrontdoorOriginPrivateLinkArgs', 'FrontdoorOriginPrivateLinkArgsDict']]] = None,
            weight: Optional[pulumi.Input[_builtins.int]] = None) -> 'FrontdoorOrigin':
        """
        Get an existing FrontdoorOrigin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_origin_group_id: The ID of the Front Door Origin Group within which this Front Door Origin should exist. Changing this forces a new Front Door Origin to be created.
        :param pulumi.Input[_builtins.bool] certificate_name_check_enabled: Specifies whether certificate name checks are enabled for this origin.
        :param pulumi.Input[_builtins.bool] enabled: Should the origin be enabled? Possible values are `true` or `false`. Defaults to `true`.
        :param pulumi.Input[_builtins.str] host_name: The IPv4 address, IPv6 address or Domain name of the Origin.
               
               !> **Note:** This must be unique across all Front Door Origins within a Front Door Endpoint.
        :param pulumi.Input[_builtins.int] http_port: The value of the HTTP port. Must be between `1` and `65535`. Defaults to `80`.
        :param pulumi.Input[_builtins.int] https_port: The value of the HTTPS port. Must be between `1` and `65535`. Defaults to `443`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Origin. Changing this forces a new Front Door Origin to be created.
        :param pulumi.Input[_builtins.str] origin_host_header: The host header value (an IPv4 address, IPv6 address or Domain name) which is sent to the origin with each request. If unspecified the hostname from the request will be used.
               
               > **Note:** Azure Front Door Origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin's hostname. This field's value overrides the host header defined in the Front Door Endpoint. For more information on how to properly set the origin host header value please see the [product documentation](https://docs.microsoft.com/azure/frontdoor/origin?pivots=front-door-standard-premium#origin-host-header).
        :param pulumi.Input[_builtins.int] priority: Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy. Must be between `1` and `5` (inclusive). Defaults to `1`.
        :param pulumi.Input[Union['FrontdoorOriginPrivateLinkArgs', 'FrontdoorOriginPrivateLinkArgsDict']] private_link: A `private_link` block as defined below.
               
               > **Note:** Private Link requires that the Front Door Profile this Origin is hosted within is using the SKU `Premium_AzureFrontDoor` and that the `certificate_name_check_enabled` field is set to `true`.
        :param pulumi.Input[_builtins.int] weight: The weight of the origin in a given origin group for load balancing. Must be between `1` and `1000`. Defaults to `500`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FrontdoorOriginState.__new__(_FrontdoorOriginState)

        __props__.__dict__["cdn_frontdoor_origin_group_id"] = cdn_frontdoor_origin_group_id
        __props__.__dict__["certificate_name_check_enabled"] = certificate_name_check_enabled
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["http_port"] = http_port
        __props__.__dict__["https_port"] = https_port
        __props__.__dict__["name"] = name
        __props__.__dict__["origin_host_header"] = origin_host_header
        __props__.__dict__["priority"] = priority
        __props__.__dict__["private_link"] = private_link
        __props__.__dict__["weight"] = weight
        return FrontdoorOrigin(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorOriginGroupId")
    def cdn_frontdoor_origin_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Front Door Origin Group within which this Front Door Origin should exist. Changing this forces a new Front Door Origin to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_origin_group_id")

    @_builtins.property
    @pulumi.getter(name="certificateNameCheckEnabled")
    def certificate_name_check_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether certificate name checks are enabled for this origin.
        """
        return pulumi.get(self, "certificate_name_check_enabled")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the origin be enabled? Possible values are `true` or `false`. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[_builtins.str]:
        """
        The IPv4 address, IPv6 address or Domain name of the Origin.

        !> **Note:** This must be unique across all Front Door Origins within a Front Door Endpoint.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The value of the HTTP port. Must be between `1` and `65535`. Defaults to `80`.
        """
        return pulumi.get(self, "http_port")

    @_builtins.property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The value of the HTTPS port. Must be between `1` and `65535`. Defaults to `443`.
        """
        return pulumi.get(self, "https_port")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Front Door Origin. Changing this forces a new Front Door Origin to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="originHostHeader")
    def origin_host_header(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The host header value (an IPv4 address, IPv6 address or Domain name) which is sent to the origin with each request. If unspecified the hostname from the request will be used.

        > **Note:** Azure Front Door Origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin's hostname. This field's value overrides the host header defined in the Front Door Endpoint. For more information on how to properly set the origin host header value please see the [product documentation](https://docs.microsoft.com/azure/frontdoor/origin?pivots=front-door-standard-premium#origin-host-header).
        """
        return pulumi.get(self, "origin_host_header")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any lower priority origin is healthy. Must be between `1` and `5` (inclusive). Defaults to `1`.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="privateLink")
    def private_link(self) -> pulumi.Output[Optional['outputs.FrontdoorOriginPrivateLink']]:
        """
        A `private_link` block as defined below.

        > **Note:** Private Link requires that the Front Door Profile this Origin is hosted within is using the SKU `Premium_AzureFrontDoor` and that the `certificate_name_check_enabled` field is set to `true`.
        """
        return pulumi.get(self, "private_link")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The weight of the origin in a given origin group for load balancing. Must be between `1` and `1000`. Defaults to `500`.
        """
        return pulumi.get(self, "weight")

