# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 custom_question_answering_search_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_question_answering_search_service_key: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_subdomain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input['AccountCustomerManagedKeyArgs']] = None,
                 dynamic_throttling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identity: Optional[pulumi.Input['AccountIdentityArgs']] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_aad_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_aad_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_super_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_website_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input['AccountNetworkAclsArgs']] = None,
                 outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 qna_runtime_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input['AccountStorageArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[_builtins.str] kind: Specifies the type of Cognitive Service Account that should be created. Possible values are `Academic`, `AnomalyDetector`, `Bing.Autosuggest`, `Bing.Autosuggest.v7`, `Bing.CustomSearch`, `Bing.Search`, `Bing.Search.v7`, `Bing.Speech`, `Bing.SpellCheck`, `Bing.SpellCheck.v7`, `CognitiveServices`, `ComputerVision`, `ContentModerator`, `ContentSafety`, `CustomSpeech`, `CustomVision.Prediction`, `CustomVision.Training`, `Emotion`, `Face`, `FormRecognizer`, `ImmersiveReader`, `LUIS`, `LUIS.Authoring`, `MetricsAdvisor`, `OpenAI`, `Personalizer`, `QnAMaker`, `Recommendations`, `SpeakerRecognition`, `Speech`, `SpeechServices`, `SpeechTranslation`, `TextAnalytics`, `TextTranslation` and `WebLM`. Changing this forces a new resource to be created.
               
               > **Note:** New Bing Search resources cannot be created as their APIs are moving from Cognitive Services Platform to new surface area under Microsoft.com. Starting from October 30, 2020, existing instances of Bing Search APIs provisioned via Cognitive Services will be continuously supported for next 3 years or till the end of respective Enterprise Agreement, whichever happens first.
               
               > **Note:** You must create your first Face, Text Analytics, or Computer Vision resources from the Azure portal to review and acknowledge the terms and conditions. In Azure Portal, the checkbox to accept terms and conditions is only displayed when a US region is selected. More information on [Prerequisites](https://docs.microsoft.com/azure/cognitive-services/cognitive-services-apis-create-account-cli?tabs=windows#prerequisites).
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Cognitive Service Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this Cognitive Service Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.
               
               > **Note:** SKU `DC0` is the commitment tier for Cognitive Services containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        :param pulumi.Input[_builtins.str] custom_question_answering_search_service_id: If `kind` is `TextAnalytics` this specifies the ID of the Search service.
        :param pulumi.Input[_builtins.str] custom_question_answering_search_service_key: If `kind` is `TextAnalytics` this specifies the key of the Search service.
               
               > **Note:** `custom_question_answering_search_service_id` and `custom_question_answering_search_service_key` are used for [Custom Question Answering, the renamed version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/custom-question-answering), while `qna_runtime_endpoint` is used for [the old version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/overview/overview)
        :param pulumi.Input[_builtins.str] custom_subdomain_name: The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. This property is also required when using the OpenAI service with libraries which assume the Azure OpenAI endpoint is a subdomain on `https://openai.azure.com/`, eg. `https://<custom_subdomain_name>.openai.azure.com/`.  Changing this forces a new resource to be created.
        :param pulumi.Input['AccountCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as documented below.
        :param pulumi.Input[_builtins.bool] dynamic_throttling_enabled: Whether to enable the dynamic throttling for this Cognitive Service Account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: List of FQDNs allowed for the Cognitive Account.
        :param pulumi.Input['AccountIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication methods is enabled for the Cognitive Account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_aad_client_id: The Azure AD Client ID (Application ID). This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_aad_tenant_id: The Azure AD Tenant ID. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_super_user_name: The super user of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_website_name: The website name of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
               
               > **Note:** This URL is mandatory if the `kind` is set to `QnAMaker`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Cognitive Service Account. Changing this forces a new resource to be created.
        :param pulumi.Input['AccountNetworkAclsArgs'] network_acls: A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        :param pulumi.Input[_builtins.bool] outbound_network_access_restricted: Whether outbound network access is restricted for the Cognitive Account. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] qna_runtime_endpoint: A URL to link a QnAMaker cognitive account to a QnA runtime.
        :param pulumi.Input[Sequence[pulumi.Input['AccountStorageArgs']]] storages: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        if custom_question_answering_search_service_id is not None:
            pulumi.set(__self__, "custom_question_answering_search_service_id", custom_question_answering_search_service_id)
        if custom_question_answering_search_service_key is not None:
            pulumi.set(__self__, "custom_question_answering_search_service_key", custom_question_answering_search_service_key)
        if custom_subdomain_name is not None:
            pulumi.set(__self__, "custom_subdomain_name", custom_subdomain_name)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if dynamic_throttling_enabled is not None:
            pulumi.set(__self__, "dynamic_throttling_enabled", dynamic_throttling_enabled)
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metrics_advisor_aad_client_id is not None:
            pulumi.set(__self__, "metrics_advisor_aad_client_id", metrics_advisor_aad_client_id)
        if metrics_advisor_aad_tenant_id is not None:
            pulumi.set(__self__, "metrics_advisor_aad_tenant_id", metrics_advisor_aad_tenant_id)
        if metrics_advisor_super_user_name is not None:
            pulumi.set(__self__, "metrics_advisor_super_user_name", metrics_advisor_super_user_name)
        if metrics_advisor_website_name is not None:
            pulumi.set(__self__, "metrics_advisor_website_name", metrics_advisor_website_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_acls is not None:
            pulumi.set(__self__, "network_acls", network_acls)
        if outbound_network_access_restricted is not None:
            pulumi.set(__self__, "outbound_network_access_restricted", outbound_network_access_restricted)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if qna_runtime_endpoint is not None:
            pulumi.set(__self__, "qna_runtime_endpoint", qna_runtime_endpoint)
        if storages is not None:
            pulumi.set(__self__, "storages", storages)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Cognitive Service Account that should be created. Possible values are `Academic`, `AnomalyDetector`, `Bing.Autosuggest`, `Bing.Autosuggest.v7`, `Bing.CustomSearch`, `Bing.Search`, `Bing.Search.v7`, `Bing.Speech`, `Bing.SpellCheck`, `Bing.SpellCheck.v7`, `CognitiveServices`, `ComputerVision`, `ContentModerator`, `ContentSafety`, `CustomSpeech`, `CustomVision.Prediction`, `CustomVision.Training`, `Emotion`, `Face`, `FormRecognizer`, `ImmersiveReader`, `LUIS`, `LUIS.Authoring`, `MetricsAdvisor`, `OpenAI`, `Personalizer`, `QnAMaker`, `Recommendations`, `SpeakerRecognition`, `Speech`, `SpeechServices`, `SpeechTranslation`, `TextAnalytics`, `TextTranslation` and `WebLM`. Changing this forces a new resource to be created.

        > **Note:** New Bing Search resources cannot be created as their APIs are moving from Cognitive Services Platform to new surface area under Microsoft.com. Starting from October 30, 2020, existing instances of Bing Search APIs provisioned via Cognitive Services will be continuously supported for next 3 years or till the end of respective Enterprise Agreement, whichever happens first.

        > **Note:** You must create your first Face, Text Analytics, or Computer Vision resources from the Azure portal to review and acknowledge the terms and conditions. In Azure Portal, the checkbox to accept terms and conditions is only displayed when a US region is selected. More information on [Prerequisites](https://docs.microsoft.com/azure/cognitive-services/cognitive-services-apis-create-account-cli?tabs=windows#prerequisites).
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the Cognitive Service Account is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the SKU Name for this Cognitive Service Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.

        > **Note:** SKU `DC0` is the commitment tier for Cognitive Services containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="customQuestionAnsweringSearchServiceId")
    def custom_question_answering_search_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If `kind` is `TextAnalytics` this specifies the ID of the Search service.
        """
        return pulumi.get(self, "custom_question_answering_search_service_id")

    @custom_question_answering_search_service_id.setter
    def custom_question_answering_search_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_question_answering_search_service_id", value)

    @_builtins.property
    @pulumi.getter(name="customQuestionAnsweringSearchServiceKey")
    def custom_question_answering_search_service_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If `kind` is `TextAnalytics` this specifies the key of the Search service.

        > **Note:** `custom_question_answering_search_service_id` and `custom_question_answering_search_service_key` are used for [Custom Question Answering, the renamed version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/custom-question-answering), while `qna_runtime_endpoint` is used for [the old version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/overview/overview)
        """
        return pulumi.get(self, "custom_question_answering_search_service_key")

    @custom_question_answering_search_service_key.setter
    def custom_question_answering_search_service_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_question_answering_search_service_key", value)

    @_builtins.property
    @pulumi.getter(name="customSubdomainName")
    def custom_subdomain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. This property is also required when using the OpenAI service with libraries which assume the Azure OpenAI endpoint is a subdomain on `https://openai.azure.com/`, eg. `https://<custom_subdomain_name>.openai.azure.com/`.  Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_subdomain_name")

    @custom_subdomain_name.setter
    def custom_subdomain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_subdomain_name", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['AccountCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as documented below.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['AccountCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter(name="dynamicThrottlingEnabled")
    def dynamic_throttling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the dynamic throttling for this Cognitive Service Account.
        """
        return pulumi.get(self, "dynamic_throttling_enabled")

    @dynamic_throttling_enabled.setter
    def dynamic_throttling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dynamic_throttling_enabled", value)

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of FQDNs allowed for the Cognitive Account.
        """
        return pulumi.get(self, "fqdns")

    @fqdns.setter
    def fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fqdns", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AccountIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AccountIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether local authentication methods is enabled for the Cognitive Account. Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="metricsAdvisorAadClientId")
    def metrics_advisor_aad_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure AD Client ID (Application ID). This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "metrics_advisor_aad_client_id")

    @metrics_advisor_aad_client_id.setter
    def metrics_advisor_aad_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_advisor_aad_client_id", value)

    @_builtins.property
    @pulumi.getter(name="metricsAdvisorAadTenantId")
    def metrics_advisor_aad_tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure AD Tenant ID. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "metrics_advisor_aad_tenant_id")

    @metrics_advisor_aad_tenant_id.setter
    def metrics_advisor_aad_tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_advisor_aad_tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="metricsAdvisorSuperUserName")
    def metrics_advisor_super_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The super user of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "metrics_advisor_super_user_name")

    @metrics_advisor_super_user_name.setter
    def metrics_advisor_super_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_advisor_super_user_name", value)

    @_builtins.property
    @pulumi.getter(name="metricsAdvisorWebsiteName")
    def metrics_advisor_website_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The website name of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.

        > **Note:** This URL is mandatory if the `kind` is set to `QnAMaker`.
        """
        return pulumi.get(self, "metrics_advisor_website_name")

    @metrics_advisor_website_name.setter
    def metrics_advisor_website_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_advisor_website_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Cognitive Service Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> Optional[pulumi.Input['AccountNetworkAclsArgs']]:
        """
        A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        """
        return pulumi.get(self, "network_acls")

    @network_acls.setter
    def network_acls(self, value: Optional[pulumi.Input['AccountNetworkAclsArgs']]):
        pulumi.set(self, "network_acls", value)

    @_builtins.property
    @pulumi.getter(name="outboundNetworkAccessRestricted")
    def outbound_network_access_restricted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether outbound network access is restricted for the Cognitive Account. Defaults to `false`.
        """
        return pulumi.get(self, "outbound_network_access_restricted")

    @outbound_network_access_restricted.setter
    def outbound_network_access_restricted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "outbound_network_access_restricted", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="qnaRuntimeEndpoint")
    def qna_runtime_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A URL to link a QnAMaker cognitive account to a QnA runtime.
        """
        return pulumi.get(self, "qna_runtime_endpoint")

    @qna_runtime_endpoint.setter
    def qna_runtime_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qna_runtime_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountStorageArgs']]]]:
        """
        A `storage` block as defined below.
        """
        return pulumi.get(self, "storages")

    @storages.setter
    def storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountStorageArgs']]]]):
        pulumi.set(self, "storages", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 custom_question_answering_search_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_question_answering_search_service_key: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_subdomain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input['AccountCustomerManagedKeyArgs']] = None,
                 dynamic_throttling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identity: Optional[pulumi.Input['AccountIdentityArgs']] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_aad_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_aad_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_super_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_website_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input['AccountNetworkAclsArgs']] = None,
                 outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 primary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 qna_runtime_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input['AccountStorageArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[_builtins.str] custom_question_answering_search_service_id: If `kind` is `TextAnalytics` this specifies the ID of the Search service.
        :param pulumi.Input[_builtins.str] custom_question_answering_search_service_key: If `kind` is `TextAnalytics` this specifies the key of the Search service.
               
               > **Note:** `custom_question_answering_search_service_id` and `custom_question_answering_search_service_key` are used for [Custom Question Answering, the renamed version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/custom-question-answering), while `qna_runtime_endpoint` is used for [the old version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/overview/overview)
        :param pulumi.Input[_builtins.str] custom_subdomain_name: The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. This property is also required when using the OpenAI service with libraries which assume the Azure OpenAI endpoint is a subdomain on `https://openai.azure.com/`, eg. `https://<custom_subdomain_name>.openai.azure.com/`.  Changing this forces a new resource to be created.
        :param pulumi.Input['AccountCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as documented below.
        :param pulumi.Input[_builtins.bool] dynamic_throttling_enabled: Whether to enable the dynamic throttling for this Cognitive Service Account.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint used to connect to the Cognitive Service Account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: List of FQDNs allowed for the Cognitive Account.
        :param pulumi.Input['AccountIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] kind: Specifies the type of Cognitive Service Account that should be created. Possible values are `Academic`, `AnomalyDetector`, `Bing.Autosuggest`, `Bing.Autosuggest.v7`, `Bing.CustomSearch`, `Bing.Search`, `Bing.Search.v7`, `Bing.Speech`, `Bing.SpellCheck`, `Bing.SpellCheck.v7`, `CognitiveServices`, `ComputerVision`, `ContentModerator`, `ContentSafety`, `CustomSpeech`, `CustomVision.Prediction`, `CustomVision.Training`, `Emotion`, `Face`, `FormRecognizer`, `ImmersiveReader`, `LUIS`, `LUIS.Authoring`, `MetricsAdvisor`, `OpenAI`, `Personalizer`, `QnAMaker`, `Recommendations`, `SpeakerRecognition`, `Speech`, `SpeechServices`, `SpeechTranslation`, `TextAnalytics`, `TextTranslation` and `WebLM`. Changing this forces a new resource to be created.
               
               > **Note:** New Bing Search resources cannot be created as their APIs are moving from Cognitive Services Platform to new surface area under Microsoft.com. Starting from October 30, 2020, existing instances of Bing Search APIs provisioned via Cognitive Services will be continuously supported for next 3 years or till the end of respective Enterprise Agreement, whichever happens first.
               
               > **Note:** You must create your first Face, Text Analytics, or Computer Vision resources from the Azure portal to review and acknowledge the terms and conditions. In Azure Portal, the checkbox to accept terms and conditions is only displayed when a US region is selected. More information on [Prerequisites](https://docs.microsoft.com/azure/cognitive-services/cognitive-services-apis-create-account-cli?tabs=windows#prerequisites).
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication methods is enabled for the Cognitive Account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_aad_client_id: The Azure AD Client ID (Application ID). This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_aad_tenant_id: The Azure AD Tenant ID. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_super_user_name: The super user of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_website_name: The website name of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
               
               > **Note:** This URL is mandatory if the `kind` is set to `QnAMaker`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Cognitive Service Account. Changing this forces a new resource to be created.
        :param pulumi.Input['AccountNetworkAclsArgs'] network_acls: A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        :param pulumi.Input[_builtins.bool] outbound_network_access_restricted: Whether outbound network access is restricted for the Cognitive Account. Defaults to `false`.
        :param pulumi.Input[_builtins.str] primary_access_key: A primary access key which can be used to connect to the Cognitive Service Account.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] qna_runtime_endpoint: A URL to link a QnAMaker cognitive account to a QnA runtime.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Cognitive Service Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] secondary_access_key: The secondary access key which can be used to connect to the Cognitive Service Account.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this Cognitive Service Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.
               
               > **Note:** SKU `DC0` is the commitment tier for Cognitive Services containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        :param pulumi.Input[Sequence[pulumi.Input['AccountStorageArgs']]] storages: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if custom_question_answering_search_service_id is not None:
            pulumi.set(__self__, "custom_question_answering_search_service_id", custom_question_answering_search_service_id)
        if custom_question_answering_search_service_key is not None:
            pulumi.set(__self__, "custom_question_answering_search_service_key", custom_question_answering_search_service_key)
        if custom_subdomain_name is not None:
            pulumi.set(__self__, "custom_subdomain_name", custom_subdomain_name)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if dynamic_throttling_enabled is not None:
            pulumi.set(__self__, "dynamic_throttling_enabled", dynamic_throttling_enabled)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metrics_advisor_aad_client_id is not None:
            pulumi.set(__self__, "metrics_advisor_aad_client_id", metrics_advisor_aad_client_id)
        if metrics_advisor_aad_tenant_id is not None:
            pulumi.set(__self__, "metrics_advisor_aad_tenant_id", metrics_advisor_aad_tenant_id)
        if metrics_advisor_super_user_name is not None:
            pulumi.set(__self__, "metrics_advisor_super_user_name", metrics_advisor_super_user_name)
        if metrics_advisor_website_name is not None:
            pulumi.set(__self__, "metrics_advisor_website_name", metrics_advisor_website_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_acls is not None:
            pulumi.set(__self__, "network_acls", network_acls)
        if outbound_network_access_restricted is not None:
            pulumi.set(__self__, "outbound_network_access_restricted", outbound_network_access_restricted)
        if primary_access_key is not None:
            pulumi.set(__self__, "primary_access_key", primary_access_key)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if qna_runtime_endpoint is not None:
            pulumi.set(__self__, "qna_runtime_endpoint", qna_runtime_endpoint)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_access_key is not None:
            pulumi.set(__self__, "secondary_access_key", secondary_access_key)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if storages is not None:
            pulumi.set(__self__, "storages", storages)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="customQuestionAnsweringSearchServiceId")
    def custom_question_answering_search_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If `kind` is `TextAnalytics` this specifies the ID of the Search service.
        """
        return pulumi.get(self, "custom_question_answering_search_service_id")

    @custom_question_answering_search_service_id.setter
    def custom_question_answering_search_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_question_answering_search_service_id", value)

    @_builtins.property
    @pulumi.getter(name="customQuestionAnsweringSearchServiceKey")
    def custom_question_answering_search_service_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If `kind` is `TextAnalytics` this specifies the key of the Search service.

        > **Note:** `custom_question_answering_search_service_id` and `custom_question_answering_search_service_key` are used for [Custom Question Answering, the renamed version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/custom-question-answering), while `qna_runtime_endpoint` is used for [the old version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/overview/overview)
        """
        return pulumi.get(self, "custom_question_answering_search_service_key")

    @custom_question_answering_search_service_key.setter
    def custom_question_answering_search_service_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_question_answering_search_service_key", value)

    @_builtins.property
    @pulumi.getter(name="customSubdomainName")
    def custom_subdomain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. This property is also required when using the OpenAI service with libraries which assume the Azure OpenAI endpoint is a subdomain on `https://openai.azure.com/`, eg. `https://<custom_subdomain_name>.openai.azure.com/`.  Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_subdomain_name")

    @custom_subdomain_name.setter
    def custom_subdomain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_subdomain_name", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['AccountCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as documented below.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['AccountCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter(name="dynamicThrottlingEnabled")
    def dynamic_throttling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the dynamic throttling for this Cognitive Service Account.
        """
        return pulumi.get(self, "dynamic_throttling_enabled")

    @dynamic_throttling_enabled.setter
    def dynamic_throttling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dynamic_throttling_enabled", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint used to connect to the Cognitive Service Account.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of FQDNs allowed for the Cognitive Account.
        """
        return pulumi.get(self, "fqdns")

    @fqdns.setter
    def fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fqdns", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AccountIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AccountIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of Cognitive Service Account that should be created. Possible values are `Academic`, `AnomalyDetector`, `Bing.Autosuggest`, `Bing.Autosuggest.v7`, `Bing.CustomSearch`, `Bing.Search`, `Bing.Search.v7`, `Bing.Speech`, `Bing.SpellCheck`, `Bing.SpellCheck.v7`, `CognitiveServices`, `ComputerVision`, `ContentModerator`, `ContentSafety`, `CustomSpeech`, `CustomVision.Prediction`, `CustomVision.Training`, `Emotion`, `Face`, `FormRecognizer`, `ImmersiveReader`, `LUIS`, `LUIS.Authoring`, `MetricsAdvisor`, `OpenAI`, `Personalizer`, `QnAMaker`, `Recommendations`, `SpeakerRecognition`, `Speech`, `SpeechServices`, `SpeechTranslation`, `TextAnalytics`, `TextTranslation` and `WebLM`. Changing this forces a new resource to be created.

        > **Note:** New Bing Search resources cannot be created as their APIs are moving from Cognitive Services Platform to new surface area under Microsoft.com. Starting from October 30, 2020, existing instances of Bing Search APIs provisioned via Cognitive Services will be continuously supported for next 3 years or till the end of respective Enterprise Agreement, whichever happens first.

        > **Note:** You must create your first Face, Text Analytics, or Computer Vision resources from the Azure portal to review and acknowledge the terms and conditions. In Azure Portal, the checkbox to accept terms and conditions is only displayed when a US region is selected. More information on [Prerequisites](https://docs.microsoft.com/azure/cognitive-services/cognitive-services-apis-create-account-cli?tabs=windows#prerequisites).
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether local authentication methods is enabled for the Cognitive Account. Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="metricsAdvisorAadClientId")
    def metrics_advisor_aad_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure AD Client ID (Application ID). This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "metrics_advisor_aad_client_id")

    @metrics_advisor_aad_client_id.setter
    def metrics_advisor_aad_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_advisor_aad_client_id", value)

    @_builtins.property
    @pulumi.getter(name="metricsAdvisorAadTenantId")
    def metrics_advisor_aad_tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure AD Tenant ID. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "metrics_advisor_aad_tenant_id")

    @metrics_advisor_aad_tenant_id.setter
    def metrics_advisor_aad_tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_advisor_aad_tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="metricsAdvisorSuperUserName")
    def metrics_advisor_super_user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The super user of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "metrics_advisor_super_user_name")

    @metrics_advisor_super_user_name.setter
    def metrics_advisor_super_user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_advisor_super_user_name", value)

    @_builtins.property
    @pulumi.getter(name="metricsAdvisorWebsiteName")
    def metrics_advisor_website_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The website name of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.

        > **Note:** This URL is mandatory if the `kind` is set to `QnAMaker`.
        """
        return pulumi.get(self, "metrics_advisor_website_name")

    @metrics_advisor_website_name.setter
    def metrics_advisor_website_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metrics_advisor_website_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Cognitive Service Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> Optional[pulumi.Input['AccountNetworkAclsArgs']]:
        """
        A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        """
        return pulumi.get(self, "network_acls")

    @network_acls.setter
    def network_acls(self, value: Optional[pulumi.Input['AccountNetworkAclsArgs']]):
        pulumi.set(self, "network_acls", value)

    @_builtins.property
    @pulumi.getter(name="outboundNetworkAccessRestricted")
    def outbound_network_access_restricted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether outbound network access is restricted for the Cognitive Account. Defaults to `false`.
        """
        return pulumi.get(self, "outbound_network_access_restricted")

    @outbound_network_access_restricted.setter
    def outbound_network_access_restricted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "outbound_network_access_restricted", value)

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A primary access key which can be used to connect to the Cognitive Service Account.
        """
        return pulumi.get(self, "primary_access_key")

    @primary_access_key.setter
    def primary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_access_key", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="qnaRuntimeEndpoint")
    def qna_runtime_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A URL to link a QnAMaker cognitive account to a QnA runtime.
        """
        return pulumi.get(self, "qna_runtime_endpoint")

    @qna_runtime_endpoint.setter
    def qna_runtime_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qna_runtime_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the Cognitive Service Account is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary access key which can be used to connect to the Cognitive Service Account.
        """
        return pulumi.get(self, "secondary_access_key")

    @secondary_access_key.setter
    def secondary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_access_key", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SKU Name for this Cognitive Service Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.

        > **Note:** SKU `DC0` is the commitment tier for Cognitive Services containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountStorageArgs']]]]:
        """
        A `storage` block as defined below.
        """
        return pulumi.get(self, "storages")

    @storages.setter
    def storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountStorageArgs']]]]):
        pulumi.set(self, "storages", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:cognitive/account:Account")
class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_question_answering_search_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_question_answering_search_service_key: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_subdomain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['AccountCustomerManagedKeyArgs', 'AccountCustomerManagedKeyArgsDict']]] = None,
                 dynamic_throttling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_aad_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_aad_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_super_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_website_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input[Union['AccountNetworkAclsArgs', 'AccountNetworkAclsArgsDict']]] = None,
                 outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 qna_runtime_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountStorageArgs', 'AccountStorageArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Cognitive Services Account.

        > **Note:** Version v2.65.0 of the Azure Provider and later will attempt to Purge the Cognitive Account during deletion. This feature can be disabled using the `features` block within the `provider` block, see the provider documentation on the features block for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.cognitive.Account("example",
            name="example-account",
            location=example.location,
            resource_group_name=example.name,
            kind="Face",
            sku_name="S0",
            tags={
                "Acceptance": "Test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CognitiveServices`: 2024-10-01

        ## Import

        Cognitive Service Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cognitive/account:Account account1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.CognitiveServices/accounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_question_answering_search_service_id: If `kind` is `TextAnalytics` this specifies the ID of the Search service.
        :param pulumi.Input[_builtins.str] custom_question_answering_search_service_key: If `kind` is `TextAnalytics` this specifies the key of the Search service.
               
               > **Note:** `custom_question_answering_search_service_id` and `custom_question_answering_search_service_key` are used for [Custom Question Answering, the renamed version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/custom-question-answering), while `qna_runtime_endpoint` is used for [the old version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/overview/overview)
        :param pulumi.Input[_builtins.str] custom_subdomain_name: The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. This property is also required when using the OpenAI service with libraries which assume the Azure OpenAI endpoint is a subdomain on `https://openai.azure.com/`, eg. `https://<custom_subdomain_name>.openai.azure.com/`.  Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AccountCustomerManagedKeyArgs', 'AccountCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as documented below.
        :param pulumi.Input[_builtins.bool] dynamic_throttling_enabled: Whether to enable the dynamic throttling for this Cognitive Service Account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: List of FQDNs allowed for the Cognitive Account.
        :param pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] kind: Specifies the type of Cognitive Service Account that should be created. Possible values are `Academic`, `AnomalyDetector`, `Bing.Autosuggest`, `Bing.Autosuggest.v7`, `Bing.CustomSearch`, `Bing.Search`, `Bing.Search.v7`, `Bing.Speech`, `Bing.SpellCheck`, `Bing.SpellCheck.v7`, `CognitiveServices`, `ComputerVision`, `ContentModerator`, `ContentSafety`, `CustomSpeech`, `CustomVision.Prediction`, `CustomVision.Training`, `Emotion`, `Face`, `FormRecognizer`, `ImmersiveReader`, `LUIS`, `LUIS.Authoring`, `MetricsAdvisor`, `OpenAI`, `Personalizer`, `QnAMaker`, `Recommendations`, `SpeakerRecognition`, `Speech`, `SpeechServices`, `SpeechTranslation`, `TextAnalytics`, `TextTranslation` and `WebLM`. Changing this forces a new resource to be created.
               
               > **Note:** New Bing Search resources cannot be created as their APIs are moving from Cognitive Services Platform to new surface area under Microsoft.com. Starting from October 30, 2020, existing instances of Bing Search APIs provisioned via Cognitive Services will be continuously supported for next 3 years or till the end of respective Enterprise Agreement, whichever happens first.
               
               > **Note:** You must create your first Face, Text Analytics, or Computer Vision resources from the Azure portal to review and acknowledge the terms and conditions. In Azure Portal, the checkbox to accept terms and conditions is only displayed when a US region is selected. More information on [Prerequisites](https://docs.microsoft.com/azure/cognitive-services/cognitive-services-apis-create-account-cli?tabs=windows#prerequisites).
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication methods is enabled for the Cognitive Account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_aad_client_id: The Azure AD Client ID (Application ID). This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_aad_tenant_id: The Azure AD Tenant ID. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_super_user_name: The super user of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_website_name: The website name of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
               
               > **Note:** This URL is mandatory if the `kind` is set to `QnAMaker`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Cognitive Service Account. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AccountNetworkAclsArgs', 'AccountNetworkAclsArgsDict']] network_acls: A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        :param pulumi.Input[_builtins.bool] outbound_network_access_restricted: Whether outbound network access is restricted for the Cognitive Account. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] qna_runtime_endpoint: A URL to link a QnAMaker cognitive account to a QnA runtime.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Cognitive Service Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this Cognitive Service Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.
               
               > **Note:** SKU `DC0` is the commitment tier for Cognitive Services containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountStorageArgs', 'AccountStorageArgsDict']]]] storages: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cognitive Services Account.

        > **Note:** Version v2.65.0 of the Azure Provider and later will attempt to Purge the Cognitive Account during deletion. This feature can be disabled using the `features` block within the `provider` block, see the provider documentation on the features block for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.cognitive.Account("example",
            name="example-account",
            location=example.location,
            resource_group_name=example.name,
            kind="Face",
            sku_name="S0",
            tags={
                "Acceptance": "Test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CognitiveServices`: 2024-10-01

        ## Import

        Cognitive Service Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cognitive/account:Account account1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.CognitiveServices/accounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_question_answering_search_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_question_answering_search_service_key: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_subdomain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['AccountCustomerManagedKeyArgs', 'AccountCustomerManagedKeyArgsDict']]] = None,
                 dynamic_throttling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_aad_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_aad_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_super_user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 metrics_advisor_website_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input[Union['AccountNetworkAclsArgs', 'AccountNetworkAclsArgsDict']]] = None,
                 outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 qna_runtime_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountStorageArgs', 'AccountStorageArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            __props__.__dict__["custom_question_answering_search_service_id"] = custom_question_answering_search_service_id
            __props__.__dict__["custom_question_answering_search_service_key"] = None if custom_question_answering_search_service_key is None else pulumi.Output.secret(custom_question_answering_search_service_key)
            __props__.__dict__["custom_subdomain_name"] = custom_subdomain_name
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["dynamic_throttling_enabled"] = dynamic_throttling_enabled
            __props__.__dict__["fqdns"] = fqdns
            __props__.__dict__["identity"] = identity
            if kind is None and not opts.urn:
                raise TypeError("Missing required property 'kind'")
            __props__.__dict__["kind"] = kind
            __props__.__dict__["local_auth_enabled"] = local_auth_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["metrics_advisor_aad_client_id"] = metrics_advisor_aad_client_id
            __props__.__dict__["metrics_advisor_aad_tenant_id"] = metrics_advisor_aad_tenant_id
            __props__.__dict__["metrics_advisor_super_user_name"] = metrics_advisor_super_user_name
            __props__.__dict__["metrics_advisor_website_name"] = metrics_advisor_website_name
            __props__.__dict__["name"] = name
            __props__.__dict__["network_acls"] = network_acls
            __props__.__dict__["outbound_network_access_restricted"] = outbound_network_access_restricted
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["qna_runtime_endpoint"] = qna_runtime_endpoint
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["storages"] = storages
            __props__.__dict__["tags"] = tags
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["primary_access_key"] = None
            __props__.__dict__["secondary_access_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["customQuestionAnsweringSearchServiceKey", "primaryAccessKey", "secondaryAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Account, __self__).__init__(
            'azure:cognitive/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_question_answering_search_service_id: Optional[pulumi.Input[_builtins.str]] = None,
            custom_question_answering_search_service_key: Optional[pulumi.Input[_builtins.str]] = None,
            custom_subdomain_name: Optional[pulumi.Input[_builtins.str]] = None,
            customer_managed_key: Optional[pulumi.Input[Union['AccountCustomerManagedKeyArgs', 'AccountCustomerManagedKeyArgsDict']]] = None,
            dynamic_throttling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            metrics_advisor_aad_client_id: Optional[pulumi.Input[_builtins.str]] = None,
            metrics_advisor_aad_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            metrics_advisor_super_user_name: Optional[pulumi.Input[_builtins.str]] = None,
            metrics_advisor_website_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_acls: Optional[pulumi.Input[Union['AccountNetworkAclsArgs', 'AccountNetworkAclsArgsDict']]] = None,
            outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
            primary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            qna_runtime_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountStorageArgs', 'AccountStorageArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_question_answering_search_service_id: If `kind` is `TextAnalytics` this specifies the ID of the Search service.
        :param pulumi.Input[_builtins.str] custom_question_answering_search_service_key: If `kind` is `TextAnalytics` this specifies the key of the Search service.
               
               > **Note:** `custom_question_answering_search_service_id` and `custom_question_answering_search_service_key` are used for [Custom Question Answering, the renamed version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/custom-question-answering), while `qna_runtime_endpoint` is used for [the old version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/overview/overview)
        :param pulumi.Input[_builtins.str] custom_subdomain_name: The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. This property is also required when using the OpenAI service with libraries which assume the Azure OpenAI endpoint is a subdomain on `https://openai.azure.com/`, eg. `https://<custom_subdomain_name>.openai.azure.com/`.  Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AccountCustomerManagedKeyArgs', 'AccountCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as documented below.
        :param pulumi.Input[_builtins.bool] dynamic_throttling_enabled: Whether to enable the dynamic throttling for this Cognitive Service Account.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint used to connect to the Cognitive Service Account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: List of FQDNs allowed for the Cognitive Account.
        :param pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] kind: Specifies the type of Cognitive Service Account that should be created. Possible values are `Academic`, `AnomalyDetector`, `Bing.Autosuggest`, `Bing.Autosuggest.v7`, `Bing.CustomSearch`, `Bing.Search`, `Bing.Search.v7`, `Bing.Speech`, `Bing.SpellCheck`, `Bing.SpellCheck.v7`, `CognitiveServices`, `ComputerVision`, `ContentModerator`, `ContentSafety`, `CustomSpeech`, `CustomVision.Prediction`, `CustomVision.Training`, `Emotion`, `Face`, `FormRecognizer`, `ImmersiveReader`, `LUIS`, `LUIS.Authoring`, `MetricsAdvisor`, `OpenAI`, `Personalizer`, `QnAMaker`, `Recommendations`, `SpeakerRecognition`, `Speech`, `SpeechServices`, `SpeechTranslation`, `TextAnalytics`, `TextTranslation` and `WebLM`. Changing this forces a new resource to be created.
               
               > **Note:** New Bing Search resources cannot be created as their APIs are moving from Cognitive Services Platform to new surface area under Microsoft.com. Starting from October 30, 2020, existing instances of Bing Search APIs provisioned via Cognitive Services will be continuously supported for next 3 years or till the end of respective Enterprise Agreement, whichever happens first.
               
               > **Note:** You must create your first Face, Text Analytics, or Computer Vision resources from the Azure portal to review and acknowledge the terms and conditions. In Azure Portal, the checkbox to accept terms and conditions is only displayed when a US region is selected. More information on [Prerequisites](https://docs.microsoft.com/azure/cognitive-services/cognitive-services-apis-create-account-cli?tabs=windows#prerequisites).
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication methods is enabled for the Cognitive Account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_aad_client_id: The Azure AD Client ID (Application ID). This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_aad_tenant_id: The Azure AD Tenant ID. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_super_user_name: The super user of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] metrics_advisor_website_name: The website name of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
               
               > **Note:** This URL is mandatory if the `kind` is set to `QnAMaker`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Cognitive Service Account. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AccountNetworkAclsArgs', 'AccountNetworkAclsArgsDict']] network_acls: A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        :param pulumi.Input[_builtins.bool] outbound_network_access_restricted: Whether outbound network access is restricted for the Cognitive Account. Defaults to `false`.
        :param pulumi.Input[_builtins.str] primary_access_key: A primary access key which can be used to connect to the Cognitive Service Account.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] qna_runtime_endpoint: A URL to link a QnAMaker cognitive account to a QnA runtime.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Cognitive Service Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] secondary_access_key: The secondary access key which can be used to connect to the Cognitive Service Account.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this Cognitive Service Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.
               
               > **Note:** SKU `DC0` is the commitment tier for Cognitive Services containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountStorageArgs', 'AccountStorageArgsDict']]]] storages: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["custom_question_answering_search_service_id"] = custom_question_answering_search_service_id
        __props__.__dict__["custom_question_answering_search_service_key"] = custom_question_answering_search_service_key
        __props__.__dict__["custom_subdomain_name"] = custom_subdomain_name
        __props__.__dict__["customer_managed_key"] = customer_managed_key
        __props__.__dict__["dynamic_throttling_enabled"] = dynamic_throttling_enabled
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["fqdns"] = fqdns
        __props__.__dict__["identity"] = identity
        __props__.__dict__["kind"] = kind
        __props__.__dict__["local_auth_enabled"] = local_auth_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["metrics_advisor_aad_client_id"] = metrics_advisor_aad_client_id
        __props__.__dict__["metrics_advisor_aad_tenant_id"] = metrics_advisor_aad_tenant_id
        __props__.__dict__["metrics_advisor_super_user_name"] = metrics_advisor_super_user_name
        __props__.__dict__["metrics_advisor_website_name"] = metrics_advisor_website_name
        __props__.__dict__["name"] = name
        __props__.__dict__["network_acls"] = network_acls
        __props__.__dict__["outbound_network_access_restricted"] = outbound_network_access_restricted
        __props__.__dict__["primary_access_key"] = primary_access_key
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["qna_runtime_endpoint"] = qna_runtime_endpoint
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secondary_access_key"] = secondary_access_key
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["storages"] = storages
        __props__.__dict__["tags"] = tags
        return Account(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customQuestionAnsweringSearchServiceId")
    def custom_question_answering_search_service_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If `kind` is `TextAnalytics` this specifies the ID of the Search service.
        """
        return pulumi.get(self, "custom_question_answering_search_service_id")

    @_builtins.property
    @pulumi.getter(name="customQuestionAnsweringSearchServiceKey")
    def custom_question_answering_search_service_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If `kind` is `TextAnalytics` this specifies the key of the Search service.

        > **Note:** `custom_question_answering_search_service_id` and `custom_question_answering_search_service_key` are used for [Custom Question Answering, the renamed version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/custom-question-answering), while `qna_runtime_endpoint` is used for [the old version of QnA Maker](https://docs.microsoft.com/azure/cognitive-services/qnamaker/overview/overview)
        """
        return pulumi.get(self, "custom_question_answering_search_service_key")

    @_builtins.property
    @pulumi.getter(name="customSubdomainName")
    def custom_subdomain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. This property is also required when using the OpenAI service with libraries which assume the Azure OpenAI endpoint is a subdomain on `https://openai.azure.com/`, eg. `https://<custom_subdomain_name>.openai.azure.com/`.  Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_subdomain_name")

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional['outputs.AccountCustomerManagedKey']]:
        """
        A `customer_managed_key` block as documented below.
        """
        return pulumi.get(self, "customer_managed_key")

    @_builtins.property
    @pulumi.getter(name="dynamicThrottlingEnabled")
    def dynamic_throttling_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable the dynamic throttling for this Cognitive Service Account.
        """
        return pulumi.get(self, "dynamic_throttling_enabled")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint used to connect to the Cognitive Service Account.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of FQDNs allowed for the Cognitive Account.
        """
        return pulumi.get(self, "fqdns")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.AccountIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of Cognitive Service Account that should be created. Possible values are `Academic`, `AnomalyDetector`, `Bing.Autosuggest`, `Bing.Autosuggest.v7`, `Bing.CustomSearch`, `Bing.Search`, `Bing.Search.v7`, `Bing.Speech`, `Bing.SpellCheck`, `Bing.SpellCheck.v7`, `CognitiveServices`, `ComputerVision`, `ContentModerator`, `ContentSafety`, `CustomSpeech`, `CustomVision.Prediction`, `CustomVision.Training`, `Emotion`, `Face`, `FormRecognizer`, `ImmersiveReader`, `LUIS`, `LUIS.Authoring`, `MetricsAdvisor`, `OpenAI`, `Personalizer`, `QnAMaker`, `Recommendations`, `SpeakerRecognition`, `Speech`, `SpeechServices`, `SpeechTranslation`, `TextAnalytics`, `TextTranslation` and `WebLM`. Changing this forces a new resource to be created.

        > **Note:** New Bing Search resources cannot be created as their APIs are moving from Cognitive Services Platform to new surface area under Microsoft.com. Starting from October 30, 2020, existing instances of Bing Search APIs provisioned via Cognitive Services will be continuously supported for next 3 years or till the end of respective Enterprise Agreement, whichever happens first.

        > **Note:** You must create your first Face, Text Analytics, or Computer Vision resources from the Azure portal to review and acknowledge the terms and conditions. In Azure Portal, the checkbox to accept terms and conditions is only displayed when a US region is selected. More information on [Prerequisites](https://docs.microsoft.com/azure/cognitive-services/cognitive-services-apis-create-account-cli?tabs=windows#prerequisites).
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether local authentication methods is enabled for the Cognitive Account. Defaults to `true`.
        """
        return pulumi.get(self, "local_auth_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="metricsAdvisorAadClientId")
    def metrics_advisor_aad_client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Azure AD Client ID (Application ID). This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "metrics_advisor_aad_client_id")

    @_builtins.property
    @pulumi.getter(name="metricsAdvisorAadTenantId")
    def metrics_advisor_aad_tenant_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Azure AD Tenant ID. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "metrics_advisor_aad_tenant_id")

    @_builtins.property
    @pulumi.getter(name="metricsAdvisorSuperUserName")
    def metrics_advisor_super_user_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The super user of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "metrics_advisor_super_user_name")

    @_builtins.property
    @pulumi.getter(name="metricsAdvisorWebsiteName")
    def metrics_advisor_website_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The website name of Metrics Advisor. This attribute is only set when kind is `MetricsAdvisor`. Changing this forces a new resource to be created.

        > **Note:** This URL is mandatory if the `kind` is set to `QnAMaker`.
        """
        return pulumi.get(self, "metrics_advisor_website_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Cognitive Service Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> pulumi.Output[Optional['outputs.AccountNetworkAcls']]:
        """
        A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        """
        return pulumi.get(self, "network_acls")

    @_builtins.property
    @pulumi.getter(name="outboundNetworkAccessRestricted")
    def outbound_network_access_restricted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether outbound network access is restricted for the Cognitive Account. Defaults to `false`.
        """
        return pulumi.get(self, "outbound_network_access_restricted")

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        A primary access key which can be used to connect to the Cognitive Service Account.
        """
        return pulumi.get(self, "primary_access_key")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether public network access is allowed for the Cognitive Account. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="qnaRuntimeEndpoint")
    def qna_runtime_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A URL to link a QnAMaker cognitive account to a QnA runtime.
        """
        return pulumi.get(self, "qna_runtime_endpoint")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the Cognitive Service Account is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The secondary access key which can be used to connect to the Cognitive Service Account.
        """
        return pulumi.get(self, "secondary_access_key")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the SKU Name for this Cognitive Service Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.

        > **Note:** SKU `DC0` is the commitment tier for Cognitive Services containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def storages(self) -> pulumi.Output[Optional[Sequence['outputs.AccountStorage']]]:
        """
        A `storage` block as defined below.
        """
        return pulumi.get(self, "storages")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

