# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDedicatedHostGroupResult',
    'AwaitableGetDedicatedHostGroupResult',
    'get_dedicated_host_group',
    'get_dedicated_host_group_output',
]

@pulumi.output_type
class GetDedicatedHostGroupResult:
    """
    A collection of values returned by getDedicatedHostGroup.
    """
    def __init__(__self__, automatic_placement_enabled=None, id=None, location=None, name=None, platform_fault_domain_count=None, resource_group_name=None, tags=None, zones=None):
        if automatic_placement_enabled and not isinstance(automatic_placement_enabled, bool):
            raise TypeError("Expected argument 'automatic_placement_enabled' to be a bool")
        pulumi.set(__self__, "automatic_placement_enabled", automatic_placement_enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if platform_fault_domain_count and not isinstance(platform_fault_domain_count, int):
            raise TypeError("Expected argument 'platform_fault_domain_count' to be a int")
        pulumi.set(__self__, "platform_fault_domain_count", platform_fault_domain_count)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="automaticPlacementEnabled")
    def automatic_placement_enabled(self) -> _builtins.bool:
        """
        Whether virtual machines or virtual machine scale sets be placed automatically on this Dedicated Host Group.
        """
        return pulumi.get(self, "automatic_placement_enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure location where the Dedicated Host Group exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="platformFaultDomainCount")
    def platform_fault_domain_count(self) -> _builtins.int:
        """
        The number of fault domains that the Dedicated Host Group spans.
        """
        return pulumi.get(self, "platform_fault_domain_count")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Sequence[_builtins.str]:
        """
        A list of Availability Zones in which this Dedicated Host Group is located.
        """
        return pulumi.get(self, "zones")


class AwaitableGetDedicatedHostGroupResult(GetDedicatedHostGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDedicatedHostGroupResult(
            automatic_placement_enabled=self.automatic_placement_enabled,
            id=self.id,
            location=self.location,
            name=self.name,
            platform_fault_domain_count=self.platform_fault_domain_count,
            resource_group_name=self.resource_group_name,
            tags=self.tags,
            zones=self.zones)


def get_dedicated_host_group(name: Optional[_builtins.str] = None,
                             resource_group_name: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDedicatedHostGroupResult:
    """
    Use this data source to access information about an existing Dedicated Host Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_dedicated_host_group(name="example-dedicated-host-group",
        resource_group_name="example-rg")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2024-03-01


    :param _builtins.str name: Specifies the name of the Dedicated Host Group.
    :param _builtins.str resource_group_name: Specifies the name of the resource group the Dedicated Host Group is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:compute/getDedicatedHostGroup:getDedicatedHostGroup', __args__, opts=opts, typ=GetDedicatedHostGroupResult).value

    return AwaitableGetDedicatedHostGroupResult(
        automatic_placement_enabled=pulumi.get(__ret__, 'automatic_placement_enabled'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        platform_fault_domain_count=pulumi.get(__ret__, 'platform_fault_domain_count'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'),
        zones=pulumi.get(__ret__, 'zones'))
def get_dedicated_host_group_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                    resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDedicatedHostGroupResult]:
    """
    Use this data source to access information about an existing Dedicated Host Group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_dedicated_host_group(name="example-dedicated-host-group",
        resource_group_name="example-rg")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2024-03-01


    :param _builtins.str name: Specifies the name of the Dedicated Host Group.
    :param _builtins.str resource_group_name: Specifies the name of the resource group the Dedicated Host Group is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:compute/getDedicatedHostGroup:getDedicatedHostGroup', __args__, opts=opts, typ=GetDedicatedHostGroupResult)
    return __ret__.apply(lambda __response__: GetDedicatedHostGroupResult(
        automatic_placement_enabled=pulumi.get(__response__, 'automatic_placement_enabled'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        platform_fault_domain_count=pulumi.get(__response__, 'platform_fault_domain_count'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags'),
        zones=pulumi.get(__response__, 'zones')))
