# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSharedImageGalleryResult',
    'AwaitableGetSharedImageGalleryResult',
    'get_shared_image_gallery',
    'get_shared_image_gallery_output',
]

@pulumi.output_type
class GetSharedImageGalleryResult:
    """
    A collection of values returned by getSharedImageGallery.
    """
    def __init__(__self__, description=None, id=None, image_names=None, location=None, name=None, resource_group_name=None, tags=None, unique_name=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_names and not isinstance(image_names, list):
            raise TypeError("Expected argument 'image_names' to be a list")
        pulumi.set(__self__, "image_names", image_names)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if unique_name and not isinstance(unique_name, str):
            raise TypeError("Expected argument 'unique_name' to be a str")
        pulumi.set(__self__, "unique_name", unique_name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description for the Shared Image Gallery.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageNames")
    def image_names(self) -> Sequence[_builtins.str]:
        """
        A list of Shared Image names within this Shared Image Gallery.
        """
        return pulumi.get(self, "image_names")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags which are assigned to the Shared Image Gallery.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="uniqueName")
    def unique_name(self) -> _builtins.str:
        """
        The unique name assigned to the Shared Image Gallery.
        """
        return pulumi.get(self, "unique_name")


class AwaitableGetSharedImageGalleryResult(GetSharedImageGalleryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSharedImageGalleryResult(
            description=self.description,
            id=self.id,
            image_names=self.image_names,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags,
            unique_name=self.unique_name)


def get_shared_image_gallery(name: Optional[_builtins.str] = None,
                             resource_group_name: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSharedImageGalleryResult:
    """
    Use this data source to access information about an existing Shared Image Gallery.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_shared_image_gallery(name="my-image-gallery",
        resource_group_name="example-resources")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2022-03-03


    :param _builtins.str name: The name of the Shared Image Gallery.
    :param _builtins.str resource_group_name: The name of the Resource Group in which the Shared Image Gallery exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:compute/getSharedImageGallery:getSharedImageGallery', __args__, opts=opts, typ=GetSharedImageGalleryResult).value

    return AwaitableGetSharedImageGalleryResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        image_names=pulumi.get(__ret__, 'image_names'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'),
        unique_name=pulumi.get(__ret__, 'unique_name'))
def get_shared_image_gallery_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                    resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSharedImageGalleryResult]:
    """
    Use this data source to access information about an existing Shared Image Gallery.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_shared_image_gallery(name="my-image-gallery",
        resource_group_name="example-resources")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2022-03-03


    :param _builtins.str name: The name of the Shared Image Gallery.
    :param _builtins.str resource_group_name: The name of the Resource Group in which the Shared Image Gallery exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:compute/getSharedImageGallery:getSharedImageGallery', __args__, opts=opts, typ=GetSharedImageGalleryResult)
    return __ret__.apply(lambda __response__: GetSharedImageGalleryResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        image_names=pulumi.get(__response__, 'image_names'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags'),
        unique_name=pulumi.get(__response__, 'unique_name')))
