# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentDaprComponentArgs', 'EnvironmentDaprComponent']

@pulumi.input_type
class EnvironmentDaprComponentArgs:
    def __init__(__self__, *,
                 component_type: pulumi.Input[_builtins.str],
                 container_app_environment_id: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 ignore_errors: Optional[pulumi.Input[_builtins.bool]] = None,
                 init_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentMetadataArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentSecretArgs']]]] = None):
        """
        The set of arguments for constructing a EnvironmentDaprComponent resource.
        :param pulumi.Input[_builtins.str] component_type: The Dapr Component Type. For example `state.azure.blobstorage`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] container_app_environment_id: The ID of the Container App Managed Environment for this Dapr Component. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] version: The version of the component.
        :param pulumi.Input[_builtins.bool] ignore_errors: Should the Dapr sidecar to continue initialisation if the component fails to load. Defaults to `false`
        :param pulumi.Input[_builtins.str] init_timeout: The timeout for component initialisation as a `ISO8601` formatted string. e.g. `5s`, `2h`, `1m`. Defaults to `5s`.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentMetadataArgs']]] metadatas: One or more `metadata` blocks as detailed below.
        :param pulumi.Input[_builtins.str] name: The name for this Dapr component. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: A list of scopes to which this component applies.
               
               > **Note:** See the official docs for more information at https://learn.microsoft.com/en-us/azure/container-apps/dapr-overview?tabs=bicep1%2Cyaml#component-scopes
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentSecretArgs']]] secrets: A `secret` block as detailed below.
        """
        pulumi.set(__self__, "component_type", component_type)
        pulumi.set(__self__, "container_app_environment_id", container_app_environment_id)
        pulumi.set(__self__, "version", version)
        if ignore_errors is not None:
            pulumi.set(__self__, "ignore_errors", ignore_errors)
        if init_timeout is not None:
            pulumi.set(__self__, "init_timeout", init_timeout)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @_builtins.property
    @pulumi.getter(name="componentType")
    def component_type(self) -> pulumi.Input[_builtins.str]:
        """
        The Dapr Component Type. For example `state.azure.blobstorage`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "component_type")

    @component_type.setter
    def component_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "component_type", value)

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Container App Managed Environment for this Dapr Component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @container_app_environment_id.setter
    def container_app_environment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_app_environment_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The version of the component.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="ignoreErrors")
    def ignore_errors(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Dapr sidecar to continue initialisation if the component fails to load. Defaults to `false`
        """
        return pulumi.get(self, "ignore_errors")

    @ignore_errors.setter
    def ignore_errors(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_errors", value)

    @_builtins.property
    @pulumi.getter(name="initTimeout")
    def init_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timeout for component initialisation as a `ISO8601` formatted string. e.g. `5s`, `2h`, `1m`. Defaults to `5s`.
        """
        return pulumi.get(self, "init_timeout")

    @init_timeout.setter
    def init_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "init_timeout", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentMetadataArgs']]]]:
        """
        One or more `metadata` blocks as detailed below.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for this Dapr component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of scopes to which this component applies.

        > **Note:** See the official docs for more information at https://learn.microsoft.com/en-us/azure/container-apps/dapr-overview?tabs=bicep1%2Cyaml#component-scopes
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentSecretArgs']]]]:
        """
        A `secret` block as detailed below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentSecretArgs']]]]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class _EnvironmentDaprComponentState:
    def __init__(__self__, *,
                 component_type: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_errors: Optional[pulumi.Input[_builtins.bool]] = None,
                 init_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentMetadataArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentSecretArgs']]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvironmentDaprComponent resources.
        :param pulumi.Input[_builtins.str] component_type: The Dapr Component Type. For example `state.azure.blobstorage`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] container_app_environment_id: The ID of the Container App Managed Environment for this Dapr Component. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] ignore_errors: Should the Dapr sidecar to continue initialisation if the component fails to load. Defaults to `false`
        :param pulumi.Input[_builtins.str] init_timeout: The timeout for component initialisation as a `ISO8601` formatted string. e.g. `5s`, `2h`, `1m`. Defaults to `5s`.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentMetadataArgs']]] metadatas: One or more `metadata` blocks as detailed below.
        :param pulumi.Input[_builtins.str] name: The name for this Dapr component. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: A list of scopes to which this component applies.
               
               > **Note:** See the official docs for more information at https://learn.microsoft.com/en-us/azure/container-apps/dapr-overview?tabs=bicep1%2Cyaml#component-scopes
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentSecretArgs']]] secrets: A `secret` block as detailed below.
        :param pulumi.Input[_builtins.str] version: The version of the component.
        """
        if component_type is not None:
            pulumi.set(__self__, "component_type", component_type)
        if container_app_environment_id is not None:
            pulumi.set(__self__, "container_app_environment_id", container_app_environment_id)
        if ignore_errors is not None:
            pulumi.set(__self__, "ignore_errors", ignore_errors)
        if init_timeout is not None:
            pulumi.set(__self__, "init_timeout", init_timeout)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="componentType")
    def component_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Dapr Component Type. For example `state.azure.blobstorage`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "component_type")

    @component_type.setter
    def component_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "component_type", value)

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container App Managed Environment for this Dapr Component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @container_app_environment_id.setter
    def container_app_environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_app_environment_id", value)

    @_builtins.property
    @pulumi.getter(name="ignoreErrors")
    def ignore_errors(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Dapr sidecar to continue initialisation if the component fails to load. Defaults to `false`
        """
        return pulumi.get(self, "ignore_errors")

    @ignore_errors.setter
    def ignore_errors(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_errors", value)

    @_builtins.property
    @pulumi.getter(name="initTimeout")
    def init_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timeout for component initialisation as a `ISO8601` formatted string. e.g. `5s`, `2h`, `1m`. Defaults to `5s`.
        """
        return pulumi.get(self, "init_timeout")

    @init_timeout.setter
    def init_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "init_timeout", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentMetadataArgs']]]]:
        """
        One or more `metadata` blocks as detailed below.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for this Dapr component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of scopes to which this component applies.

        > **Note:** See the official docs for more information at https://learn.microsoft.com/en-us/azure/container-apps/dapr-overview?tabs=bicep1%2Cyaml#component-scopes
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentSecretArgs']]]]:
        """
        A `secret` block as detailed below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentDaprComponentSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the component.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azure:containerapp/environmentDaprComponent:EnvironmentDaprComponent")
class EnvironmentDaprComponent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 component_type: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_errors: Optional[pulumi.Input[_builtins.bool]] = None,
                 init_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentDaprComponentMetadataArgs', 'EnvironmentDaprComponentMetadataArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentDaprComponentSecretArgs', 'EnvironmentDaprComponentSecretArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Dapr Component for a Container App Environment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="acctest-01",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="Example-Environment",
            location=example.location,
            resource_group_name=example.name,
            log_analytics_workspace_id=example_analytics_workspace.id)
        example_environment_dapr_component = azure.containerapp.EnvironmentDaprComponent("example",
            name="example-component",
            container_app_environment_id=example_environment.id,
            component_type="state.azure.blobstorage",
            version="v1")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App`: 2025-01-01

        ## Import

        A Dapr Component for a Container App Environment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerapp/environmentDaprComponent:EnvironmentDaprComponent example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/managedEnvironments/myenv/daprComponents/mydaprcomponent"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] component_type: The Dapr Component Type. For example `state.azure.blobstorage`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] container_app_environment_id: The ID of the Container App Managed Environment for this Dapr Component. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] ignore_errors: Should the Dapr sidecar to continue initialisation if the component fails to load. Defaults to `false`
        :param pulumi.Input[_builtins.str] init_timeout: The timeout for component initialisation as a `ISO8601` formatted string. e.g. `5s`, `2h`, `1m`. Defaults to `5s`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentDaprComponentMetadataArgs', 'EnvironmentDaprComponentMetadataArgsDict']]]] metadatas: One or more `metadata` blocks as detailed below.
        :param pulumi.Input[_builtins.str] name: The name for this Dapr component. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: A list of scopes to which this component applies.
               
               > **Note:** See the official docs for more information at https://learn.microsoft.com/en-us/azure/container-apps/dapr-overview?tabs=bicep1%2Cyaml#component-scopes
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentDaprComponentSecretArgs', 'EnvironmentDaprComponentSecretArgsDict']]]] secrets: A `secret` block as detailed below.
        :param pulumi.Input[_builtins.str] version: The version of the component.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentDaprComponentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dapr Component for a Container App Environment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="acctest-01",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="Example-Environment",
            location=example.location,
            resource_group_name=example.name,
            log_analytics_workspace_id=example_analytics_workspace.id)
        example_environment_dapr_component = azure.containerapp.EnvironmentDaprComponent("example",
            name="example-component",
            container_app_environment_id=example_environment.id,
            component_type="state.azure.blobstorage",
            version="v1")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App`: 2025-01-01

        ## Import

        A Dapr Component for a Container App Environment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerapp/environmentDaprComponent:EnvironmentDaprComponent example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/managedEnvironments/myenv/daprComponents/mydaprcomponent"
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentDaprComponentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentDaprComponentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 component_type: Optional[pulumi.Input[_builtins.str]] = None,
                 container_app_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_errors: Optional[pulumi.Input[_builtins.bool]] = None,
                 init_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentDaprComponentMetadataArgs', 'EnvironmentDaprComponentMetadataArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentDaprComponentSecretArgs', 'EnvironmentDaprComponentSecretArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentDaprComponentArgs.__new__(EnvironmentDaprComponentArgs)

            if component_type is None and not opts.urn:
                raise TypeError("Missing required property 'component_type'")
            __props__.__dict__["component_type"] = component_type
            if container_app_environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_app_environment_id'")
            __props__.__dict__["container_app_environment_id"] = container_app_environment_id
            __props__.__dict__["ignore_errors"] = ignore_errors
            __props__.__dict__["init_timeout"] = init_timeout
            __props__.__dict__["metadatas"] = metadatas
            __props__.__dict__["name"] = name
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["secrets"] = None if secrets is None else pulumi.Output.secret(secrets)
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secrets"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EnvironmentDaprComponent, __self__).__init__(
            'azure:containerapp/environmentDaprComponent:EnvironmentDaprComponent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            component_type: Optional[pulumi.Input[_builtins.str]] = None,
            container_app_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            ignore_errors: Optional[pulumi.Input[_builtins.bool]] = None,
            init_timeout: Optional[pulumi.Input[_builtins.str]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentDaprComponentMetadataArgs', 'EnvironmentDaprComponentMetadataArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentDaprComponentSecretArgs', 'EnvironmentDaprComponentSecretArgsDict']]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnvironmentDaprComponent':
        """
        Get an existing EnvironmentDaprComponent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] component_type: The Dapr Component Type. For example `state.azure.blobstorage`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] container_app_environment_id: The ID of the Container App Managed Environment for this Dapr Component. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] ignore_errors: Should the Dapr sidecar to continue initialisation if the component fails to load. Defaults to `false`
        :param pulumi.Input[_builtins.str] init_timeout: The timeout for component initialisation as a `ISO8601` formatted string. e.g. `5s`, `2h`, `1m`. Defaults to `5s`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentDaprComponentMetadataArgs', 'EnvironmentDaprComponentMetadataArgsDict']]]] metadatas: One or more `metadata` blocks as detailed below.
        :param pulumi.Input[_builtins.str] name: The name for this Dapr component. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: A list of scopes to which this component applies.
               
               > **Note:** See the official docs for more information at https://learn.microsoft.com/en-us/azure/container-apps/dapr-overview?tabs=bicep1%2Cyaml#component-scopes
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentDaprComponentSecretArgs', 'EnvironmentDaprComponentSecretArgsDict']]]] secrets: A `secret` block as detailed below.
        :param pulumi.Input[_builtins.str] version: The version of the component.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentDaprComponentState.__new__(_EnvironmentDaprComponentState)

        __props__.__dict__["component_type"] = component_type
        __props__.__dict__["container_app_environment_id"] = container_app_environment_id
        __props__.__dict__["ignore_errors"] = ignore_errors
        __props__.__dict__["init_timeout"] = init_timeout
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["name"] = name
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["secrets"] = secrets
        __props__.__dict__["version"] = version
        return EnvironmentDaprComponent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="componentType")
    def component_type(self) -> pulumi.Output[_builtins.str]:
        """
        The Dapr Component Type. For example `state.azure.blobstorage`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "component_type")

    @_builtins.property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container App Managed Environment for this Dapr Component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @_builtins.property
    @pulumi.getter(name="ignoreErrors")
    def ignore_errors(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Dapr sidecar to continue initialisation if the component fails to load. Defaults to `false`
        """
        return pulumi.get(self, "ignore_errors")

    @_builtins.property
    @pulumi.getter(name="initTimeout")
    def init_timeout(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The timeout for component initialisation as a `ISO8601` formatted string. e.g. `5s`, `2h`, `1m`. Defaults to `5s`.
        """
        return pulumi.get(self, "init_timeout")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Optional[Sequence['outputs.EnvironmentDaprComponentMetadata']]]:
        """
        One or more `metadata` blocks as detailed below.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for this Dapr component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of scopes to which this component applies.

        > **Note:** See the official docs for more information at https://learn.microsoft.com/en-us/azure/container-apps/dapr-overview?tabs=bicep1%2Cyaml#component-scopes
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> pulumi.Output[Optional[Sequence['outputs.EnvironmentDaprComponentSecret']]]:
        """
        A `secret` block as detailed below.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the component.
        """
        return pulumi.get(self, "version")

