# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegistryTaskArgs', 'RegistryTask']

@pulumi.input_type
class RegistryTaskArgs:
    def __init__(__self__, *,
                 container_registry_id: pulumi.Input[_builtins.str],
                 agent_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_setting: Optional[pulumi.Input['RegistryTaskAgentSettingArgs']] = None,
                 base_image_trigger: Optional[pulumi.Input['RegistryTaskBaseImageTriggerArgs']] = None,
                 docker_step: Optional[pulumi.Input['RegistryTaskDockerStepArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encoded_step: Optional[pulumi.Input['RegistryTaskEncodedStepArgs']] = None,
                 file_step: Optional[pulumi.Input['RegistryTaskFileStepArgs']] = None,
                 identity: Optional[pulumi.Input['RegistryTaskIdentityArgs']] = None,
                 is_system_task: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_template: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input['RegistryTaskPlatformArgs']] = None,
                 registry_credential: Optional[pulumi.Input['RegistryTaskRegistryCredentialArgs']] = None,
                 source_triggers: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryTaskSourceTriggerArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timer_triggers: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryTaskTimerTriggerArgs']]]] = None):
        """
        The set of arguments for constructing a RegistryTask resource.
        :param pulumi.Input[_builtins.str] container_registry_id: The ID of the Container Registry that this Container Registry Task resides in. Changing this forces a new Container Registry Task to be created.
        :param pulumi.Input[_builtins.str] agent_pool_name: The name of the dedicated Container Registry Agent Pool for this Container Registry Task.
        :param pulumi.Input['RegistryTaskAgentSettingArgs'] agent_setting: A `agent_setting` block as defined below.
               
               > **Note:** Only one of `agent_pool_name` and `agent_setting` can be specified.
        :param pulumi.Input['RegistryTaskBaseImageTriggerArgs'] base_image_trigger: A `base_image_trigger` block as defined below.
        :param pulumi.Input['RegistryTaskDockerStepArgs'] docker_step: A `docker_step` block as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Should this Container Registry Task be enabled? Defaults to `true`.
        :param pulumi.Input['RegistryTaskEncodedStepArgs'] encoded_step: A `encoded_step` block as defined below.
        :param pulumi.Input['RegistryTaskFileStepArgs'] file_step: A `file_step` block as defined below.
               
               > **Note:** For non-system task (when `is_system_task` is set to `false`), one and only one of the `docker_step`, `encoded_step` and `file_step` should be specified.
        :param pulumi.Input['RegistryTaskIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] is_system_task: Whether this Container Registry Task is a system task. Changing this forces a new Container Registry Task to be created. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Container Registry Task. Changing this forces a new Container Registry Task to be created.
        :param pulumi.Input['RegistryTaskPlatformArgs'] platform: A `platform` block as defined below.
               
               > **Note:** The `platform` is required for non-system task (when `is_system_task` is set to `false`).
        :param pulumi.Input[Sequence[pulumi.Input['RegistryTaskSourceTriggerArgs']]] source_triggers: One or more `source_trigger` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['RegistryTaskTimerTriggerArgs']]] timer_triggers: One or more `timer_trigger` blocks as defined below.
        """
        pulumi.set(__self__, "container_registry_id", container_registry_id)
        if agent_pool_name is not None:
            pulumi.set(__self__, "agent_pool_name", agent_pool_name)
        if agent_setting is not None:
            pulumi.set(__self__, "agent_setting", agent_setting)
        if base_image_trigger is not None:
            pulumi.set(__self__, "base_image_trigger", base_image_trigger)
        if docker_step is not None:
            pulumi.set(__self__, "docker_step", docker_step)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encoded_step is not None:
            pulumi.set(__self__, "encoded_step", encoded_step)
        if file_step is not None:
            pulumi.set(__self__, "file_step", file_step)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if is_system_task is not None:
            pulumi.set(__self__, "is_system_task", is_system_task)
        if log_template is not None:
            pulumi.set(__self__, "log_template", log_template)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if registry_credential is not None:
            pulumi.set(__self__, "registry_credential", registry_credential)
        if source_triggers is not None:
            pulumi.set(__self__, "source_triggers", source_triggers)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if timer_triggers is not None:
            pulumi.set(__self__, "timer_triggers", timer_triggers)

    @_builtins.property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Container Registry that this Container Registry Task resides in. Changing this forces a new Container Registry Task to be created.
        """
        return pulumi.get(self, "container_registry_id")

    @container_registry_id.setter
    def container_registry_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_registry_id", value)

    @_builtins.property
    @pulumi.getter(name="agentPoolName")
    def agent_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the dedicated Container Registry Agent Pool for this Container Registry Task.
        """
        return pulumi.get(self, "agent_pool_name")

    @agent_pool_name.setter
    def agent_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="agentSetting")
    def agent_setting(self) -> Optional[pulumi.Input['RegistryTaskAgentSettingArgs']]:
        """
        A `agent_setting` block as defined below.

        > **Note:** Only one of `agent_pool_name` and `agent_setting` can be specified.
        """
        return pulumi.get(self, "agent_setting")

    @agent_setting.setter
    def agent_setting(self, value: Optional[pulumi.Input['RegistryTaskAgentSettingArgs']]):
        pulumi.set(self, "agent_setting", value)

    @_builtins.property
    @pulumi.getter(name="baseImageTrigger")
    def base_image_trigger(self) -> Optional[pulumi.Input['RegistryTaskBaseImageTriggerArgs']]:
        """
        A `base_image_trigger` block as defined below.
        """
        return pulumi.get(self, "base_image_trigger")

    @base_image_trigger.setter
    def base_image_trigger(self, value: Optional[pulumi.Input['RegistryTaskBaseImageTriggerArgs']]):
        pulumi.set(self, "base_image_trigger", value)

    @_builtins.property
    @pulumi.getter(name="dockerStep")
    def docker_step(self) -> Optional[pulumi.Input['RegistryTaskDockerStepArgs']]:
        """
        A `docker_step` block as defined below.
        """
        return pulumi.get(self, "docker_step")

    @docker_step.setter
    def docker_step(self, value: Optional[pulumi.Input['RegistryTaskDockerStepArgs']]):
        pulumi.set(self, "docker_step", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Container Registry Task be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="encodedStep")
    def encoded_step(self) -> Optional[pulumi.Input['RegistryTaskEncodedStepArgs']]:
        """
        A `encoded_step` block as defined below.
        """
        return pulumi.get(self, "encoded_step")

    @encoded_step.setter
    def encoded_step(self, value: Optional[pulumi.Input['RegistryTaskEncodedStepArgs']]):
        pulumi.set(self, "encoded_step", value)

    @_builtins.property
    @pulumi.getter(name="fileStep")
    def file_step(self) -> Optional[pulumi.Input['RegistryTaskFileStepArgs']]:
        """
        A `file_step` block as defined below.

        > **Note:** For non-system task (when `is_system_task` is set to `false`), one and only one of the `docker_step`, `encoded_step` and `file_step` should be specified.
        """
        return pulumi.get(self, "file_step")

    @file_step.setter
    def file_step(self, value: Optional[pulumi.Input['RegistryTaskFileStepArgs']]):
        pulumi.set(self, "file_step", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['RegistryTaskIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['RegistryTaskIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="isSystemTask")
    def is_system_task(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this Container Registry Task is a system task. Changing this forces a new Container Registry Task to be created. Defaults to `false`.
        """
        return pulumi.get(self, "is_system_task")

    @is_system_task.setter
    def is_system_task(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_system_task", value)

    @_builtins.property
    @pulumi.getter(name="logTemplate")
    def log_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "log_template")

    @log_template.setter
    def log_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_template", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Container Registry Task. Changing this forces a new Container Registry Task to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input['RegistryTaskPlatformArgs']]:
        """
        A `platform` block as defined below.

        > **Note:** The `platform` is required for non-system task (when `is_system_task` is set to `false`).
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input['RegistryTaskPlatformArgs']]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="registryCredential")
    def registry_credential(self) -> Optional[pulumi.Input['RegistryTaskRegistryCredentialArgs']]:
        return pulumi.get(self, "registry_credential")

    @registry_credential.setter
    def registry_credential(self, value: Optional[pulumi.Input['RegistryTaskRegistryCredentialArgs']]):
        pulumi.set(self, "registry_credential", value)

    @_builtins.property
    @pulumi.getter(name="sourceTriggers")
    def source_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryTaskSourceTriggerArgs']]]]:
        """
        One or more `source_trigger` blocks as defined below.
        """
        return pulumi.get(self, "source_triggers")

    @source_triggers.setter
    def source_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryTaskSourceTriggerArgs']]]]):
        pulumi.set(self, "source_triggers", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="timerTriggers")
    def timer_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryTaskTimerTriggerArgs']]]]:
        """
        One or more `timer_trigger` blocks as defined below.
        """
        return pulumi.get(self, "timer_triggers")

    @timer_triggers.setter
    def timer_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryTaskTimerTriggerArgs']]]]):
        pulumi.set(self, "timer_triggers", value)


@pulumi.input_type
class _RegistryTaskState:
    def __init__(__self__, *,
                 agent_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_setting: Optional[pulumi.Input['RegistryTaskAgentSettingArgs']] = None,
                 base_image_trigger: Optional[pulumi.Input['RegistryTaskBaseImageTriggerArgs']] = None,
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_step: Optional[pulumi.Input['RegistryTaskDockerStepArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encoded_step: Optional[pulumi.Input['RegistryTaskEncodedStepArgs']] = None,
                 file_step: Optional[pulumi.Input['RegistryTaskFileStepArgs']] = None,
                 identity: Optional[pulumi.Input['RegistryTaskIdentityArgs']] = None,
                 is_system_task: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_template: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input['RegistryTaskPlatformArgs']] = None,
                 registry_credential: Optional[pulumi.Input['RegistryTaskRegistryCredentialArgs']] = None,
                 source_triggers: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryTaskSourceTriggerArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timer_triggers: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryTaskTimerTriggerArgs']]]] = None):
        """
        Input properties used for looking up and filtering RegistryTask resources.
        :param pulumi.Input[_builtins.str] agent_pool_name: The name of the dedicated Container Registry Agent Pool for this Container Registry Task.
        :param pulumi.Input['RegistryTaskAgentSettingArgs'] agent_setting: A `agent_setting` block as defined below.
               
               > **Note:** Only one of `agent_pool_name` and `agent_setting` can be specified.
        :param pulumi.Input['RegistryTaskBaseImageTriggerArgs'] base_image_trigger: A `base_image_trigger` block as defined below.
        :param pulumi.Input[_builtins.str] container_registry_id: The ID of the Container Registry that this Container Registry Task resides in. Changing this forces a new Container Registry Task to be created.
        :param pulumi.Input['RegistryTaskDockerStepArgs'] docker_step: A `docker_step` block as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Should this Container Registry Task be enabled? Defaults to `true`.
        :param pulumi.Input['RegistryTaskEncodedStepArgs'] encoded_step: A `encoded_step` block as defined below.
        :param pulumi.Input['RegistryTaskFileStepArgs'] file_step: A `file_step` block as defined below.
               
               > **Note:** For non-system task (when `is_system_task` is set to `false`), one and only one of the `docker_step`, `encoded_step` and `file_step` should be specified.
        :param pulumi.Input['RegistryTaskIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] is_system_task: Whether this Container Registry Task is a system task. Changing this forces a new Container Registry Task to be created. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Container Registry Task. Changing this forces a new Container Registry Task to be created.
        :param pulumi.Input['RegistryTaskPlatformArgs'] platform: A `platform` block as defined below.
               
               > **Note:** The `platform` is required for non-system task (when `is_system_task` is set to `false`).
        :param pulumi.Input[Sequence[pulumi.Input['RegistryTaskSourceTriggerArgs']]] source_triggers: One or more `source_trigger` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['RegistryTaskTimerTriggerArgs']]] timer_triggers: One or more `timer_trigger` blocks as defined below.
        """
        if agent_pool_name is not None:
            pulumi.set(__self__, "agent_pool_name", agent_pool_name)
        if agent_setting is not None:
            pulumi.set(__self__, "agent_setting", agent_setting)
        if base_image_trigger is not None:
            pulumi.set(__self__, "base_image_trigger", base_image_trigger)
        if container_registry_id is not None:
            pulumi.set(__self__, "container_registry_id", container_registry_id)
        if docker_step is not None:
            pulumi.set(__self__, "docker_step", docker_step)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encoded_step is not None:
            pulumi.set(__self__, "encoded_step", encoded_step)
        if file_step is not None:
            pulumi.set(__self__, "file_step", file_step)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if is_system_task is not None:
            pulumi.set(__self__, "is_system_task", is_system_task)
        if log_template is not None:
            pulumi.set(__self__, "log_template", log_template)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if registry_credential is not None:
            pulumi.set(__self__, "registry_credential", registry_credential)
        if source_triggers is not None:
            pulumi.set(__self__, "source_triggers", source_triggers)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if timer_triggers is not None:
            pulumi.set(__self__, "timer_triggers", timer_triggers)

    @_builtins.property
    @pulumi.getter(name="agentPoolName")
    def agent_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the dedicated Container Registry Agent Pool for this Container Registry Task.
        """
        return pulumi.get(self, "agent_pool_name")

    @agent_pool_name.setter
    def agent_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="agentSetting")
    def agent_setting(self) -> Optional[pulumi.Input['RegistryTaskAgentSettingArgs']]:
        """
        A `agent_setting` block as defined below.

        > **Note:** Only one of `agent_pool_name` and `agent_setting` can be specified.
        """
        return pulumi.get(self, "agent_setting")

    @agent_setting.setter
    def agent_setting(self, value: Optional[pulumi.Input['RegistryTaskAgentSettingArgs']]):
        pulumi.set(self, "agent_setting", value)

    @_builtins.property
    @pulumi.getter(name="baseImageTrigger")
    def base_image_trigger(self) -> Optional[pulumi.Input['RegistryTaskBaseImageTriggerArgs']]:
        """
        A `base_image_trigger` block as defined below.
        """
        return pulumi.get(self, "base_image_trigger")

    @base_image_trigger.setter
    def base_image_trigger(self, value: Optional[pulumi.Input['RegistryTaskBaseImageTriggerArgs']]):
        pulumi.set(self, "base_image_trigger", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container Registry that this Container Registry Task resides in. Changing this forces a new Container Registry Task to be created.
        """
        return pulumi.get(self, "container_registry_id")

    @container_registry_id.setter
    def container_registry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_registry_id", value)

    @_builtins.property
    @pulumi.getter(name="dockerStep")
    def docker_step(self) -> Optional[pulumi.Input['RegistryTaskDockerStepArgs']]:
        """
        A `docker_step` block as defined below.
        """
        return pulumi.get(self, "docker_step")

    @docker_step.setter
    def docker_step(self, value: Optional[pulumi.Input['RegistryTaskDockerStepArgs']]):
        pulumi.set(self, "docker_step", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Container Registry Task be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="encodedStep")
    def encoded_step(self) -> Optional[pulumi.Input['RegistryTaskEncodedStepArgs']]:
        """
        A `encoded_step` block as defined below.
        """
        return pulumi.get(self, "encoded_step")

    @encoded_step.setter
    def encoded_step(self, value: Optional[pulumi.Input['RegistryTaskEncodedStepArgs']]):
        pulumi.set(self, "encoded_step", value)

    @_builtins.property
    @pulumi.getter(name="fileStep")
    def file_step(self) -> Optional[pulumi.Input['RegistryTaskFileStepArgs']]:
        """
        A `file_step` block as defined below.

        > **Note:** For non-system task (when `is_system_task` is set to `false`), one and only one of the `docker_step`, `encoded_step` and `file_step` should be specified.
        """
        return pulumi.get(self, "file_step")

    @file_step.setter
    def file_step(self, value: Optional[pulumi.Input['RegistryTaskFileStepArgs']]):
        pulumi.set(self, "file_step", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['RegistryTaskIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['RegistryTaskIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="isSystemTask")
    def is_system_task(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this Container Registry Task is a system task. Changing this forces a new Container Registry Task to be created. Defaults to `false`.
        """
        return pulumi.get(self, "is_system_task")

    @is_system_task.setter
    def is_system_task(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_system_task", value)

    @_builtins.property
    @pulumi.getter(name="logTemplate")
    def log_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "log_template")

    @log_template.setter
    def log_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_template", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Container Registry Task. Changing this forces a new Container Registry Task to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input['RegistryTaskPlatformArgs']]:
        """
        A `platform` block as defined below.

        > **Note:** The `platform` is required for non-system task (when `is_system_task` is set to `false`).
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input['RegistryTaskPlatformArgs']]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="registryCredential")
    def registry_credential(self) -> Optional[pulumi.Input['RegistryTaskRegistryCredentialArgs']]:
        return pulumi.get(self, "registry_credential")

    @registry_credential.setter
    def registry_credential(self, value: Optional[pulumi.Input['RegistryTaskRegistryCredentialArgs']]):
        pulumi.set(self, "registry_credential", value)

    @_builtins.property
    @pulumi.getter(name="sourceTriggers")
    def source_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryTaskSourceTriggerArgs']]]]:
        """
        One or more `source_trigger` blocks as defined below.
        """
        return pulumi.get(self, "source_triggers")

    @source_triggers.setter
    def source_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryTaskSourceTriggerArgs']]]]):
        pulumi.set(self, "source_triggers", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "timeout_in_seconds")

    @timeout_in_seconds.setter
    def timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="timerTriggers")
    def timer_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryTaskTimerTriggerArgs']]]]:
        """
        One or more `timer_trigger` blocks as defined below.
        """
        return pulumi.get(self, "timer_triggers")

    @timer_triggers.setter
    def timer_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryTaskTimerTriggerArgs']]]]):
        pulumi.set(self, "timer_triggers", value)


@pulumi.type_token("azure:containerservice/registryTask:RegistryTask")
class RegistryTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_setting: Optional[pulumi.Input[Union['RegistryTaskAgentSettingArgs', 'RegistryTaskAgentSettingArgsDict']]] = None,
                 base_image_trigger: Optional[pulumi.Input[Union['RegistryTaskBaseImageTriggerArgs', 'RegistryTaskBaseImageTriggerArgsDict']]] = None,
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_step: Optional[pulumi.Input[Union['RegistryTaskDockerStepArgs', 'RegistryTaskDockerStepArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encoded_step: Optional[pulumi.Input[Union['RegistryTaskEncodedStepArgs', 'RegistryTaskEncodedStepArgsDict']]] = None,
                 file_step: Optional[pulumi.Input[Union['RegistryTaskFileStepArgs', 'RegistryTaskFileStepArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['RegistryTaskIdentityArgs', 'RegistryTaskIdentityArgsDict']]] = None,
                 is_system_task: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_template: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[Union['RegistryTaskPlatformArgs', 'RegistryTaskPlatformArgsDict']]] = None,
                 registry_credential: Optional[pulumi.Input[Union['RegistryTaskRegistryCredentialArgs', 'RegistryTaskRegistryCredentialArgsDict']]] = None,
                 source_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegistryTaskSourceTriggerArgs', 'RegistryTaskSourceTriggerArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timer_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegistryTaskTimerTriggerArgs', 'RegistryTaskTimerTriggerArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Container Registry Task.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic")
        example_registry_task = azure.containerservice.RegistryTask("example",
            name="example-task",
            container_registry_id=example_registry.id,
            platform={
                "os": "Linux",
            },
            docker_step={
                "dockerfile_path": "Dockerfile",
                "context_path": "https://github.com/<username>/<repository>#<branch>:<folder>",
                "context_access_token": "<github personal access token>",
                "image_names": ["helloworld:{{.Run.ID}}"],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry`: 2023-11-01-preview, 2019-06-01-preview

        ## Import

        Container Registry Tasks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/registryTask:RegistryTask example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.ContainerRegistry/registries/registry1/tasks/task1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_pool_name: The name of the dedicated Container Registry Agent Pool for this Container Registry Task.
        :param pulumi.Input[Union['RegistryTaskAgentSettingArgs', 'RegistryTaskAgentSettingArgsDict']] agent_setting: A `agent_setting` block as defined below.
               
               > **Note:** Only one of `agent_pool_name` and `agent_setting` can be specified.
        :param pulumi.Input[Union['RegistryTaskBaseImageTriggerArgs', 'RegistryTaskBaseImageTriggerArgsDict']] base_image_trigger: A `base_image_trigger` block as defined below.
        :param pulumi.Input[_builtins.str] container_registry_id: The ID of the Container Registry that this Container Registry Task resides in. Changing this forces a new Container Registry Task to be created.
        :param pulumi.Input[Union['RegistryTaskDockerStepArgs', 'RegistryTaskDockerStepArgsDict']] docker_step: A `docker_step` block as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Should this Container Registry Task be enabled? Defaults to `true`.
        :param pulumi.Input[Union['RegistryTaskEncodedStepArgs', 'RegistryTaskEncodedStepArgsDict']] encoded_step: A `encoded_step` block as defined below.
        :param pulumi.Input[Union['RegistryTaskFileStepArgs', 'RegistryTaskFileStepArgsDict']] file_step: A `file_step` block as defined below.
               
               > **Note:** For non-system task (when `is_system_task` is set to `false`), one and only one of the `docker_step`, `encoded_step` and `file_step` should be specified.
        :param pulumi.Input[Union['RegistryTaskIdentityArgs', 'RegistryTaskIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] is_system_task: Whether this Container Registry Task is a system task. Changing this forces a new Container Registry Task to be created. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Container Registry Task. Changing this forces a new Container Registry Task to be created.
        :param pulumi.Input[Union['RegistryTaskPlatformArgs', 'RegistryTaskPlatformArgsDict']] platform: A `platform` block as defined below.
               
               > **Note:** The `platform` is required for non-system task (when `is_system_task` is set to `false`).
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegistryTaskSourceTriggerArgs', 'RegistryTaskSourceTriggerArgsDict']]]] source_triggers: One or more `source_trigger` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegistryTaskTimerTriggerArgs', 'RegistryTaskTimerTriggerArgsDict']]]] timer_triggers: One or more `timer_trigger` blocks as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistryTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Container Registry Task.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic")
        example_registry_task = azure.containerservice.RegistryTask("example",
            name="example-task",
            container_registry_id=example_registry.id,
            platform={
                "os": "Linux",
            },
            docker_step={
                "dockerfile_path": "Dockerfile",
                "context_path": "https://github.com/<username>/<repository>#<branch>:<folder>",
                "context_access_token": "<github personal access token>",
                "image_names": ["helloworld:{{.Run.ID}}"],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry`: 2023-11-01-preview, 2019-06-01-preview

        ## Import

        Container Registry Tasks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/registryTask:RegistryTask example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.ContainerRegistry/registries/registry1/tasks/task1
        ```

        :param str resource_name: The name of the resource.
        :param RegistryTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_setting: Optional[pulumi.Input[Union['RegistryTaskAgentSettingArgs', 'RegistryTaskAgentSettingArgsDict']]] = None,
                 base_image_trigger: Optional[pulumi.Input[Union['RegistryTaskBaseImageTriggerArgs', 'RegistryTaskBaseImageTriggerArgsDict']]] = None,
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_step: Optional[pulumi.Input[Union['RegistryTaskDockerStepArgs', 'RegistryTaskDockerStepArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encoded_step: Optional[pulumi.Input[Union['RegistryTaskEncodedStepArgs', 'RegistryTaskEncodedStepArgsDict']]] = None,
                 file_step: Optional[pulumi.Input[Union['RegistryTaskFileStepArgs', 'RegistryTaskFileStepArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['RegistryTaskIdentityArgs', 'RegistryTaskIdentityArgsDict']]] = None,
                 is_system_task: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_template: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[Union['RegistryTaskPlatformArgs', 'RegistryTaskPlatformArgsDict']]] = None,
                 registry_credential: Optional[pulumi.Input[Union['RegistryTaskRegistryCredentialArgs', 'RegistryTaskRegistryCredentialArgsDict']]] = None,
                 source_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegistryTaskSourceTriggerArgs', 'RegistryTaskSourceTriggerArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 timer_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegistryTaskTimerTriggerArgs', 'RegistryTaskTimerTriggerArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryTaskArgs.__new__(RegistryTaskArgs)

            __props__.__dict__["agent_pool_name"] = agent_pool_name
            __props__.__dict__["agent_setting"] = agent_setting
            __props__.__dict__["base_image_trigger"] = base_image_trigger
            if container_registry_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_registry_id'")
            __props__.__dict__["container_registry_id"] = container_registry_id
            __props__.__dict__["docker_step"] = docker_step
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["encoded_step"] = encoded_step
            __props__.__dict__["file_step"] = file_step
            __props__.__dict__["identity"] = identity
            __props__.__dict__["is_system_task"] = is_system_task
            __props__.__dict__["log_template"] = log_template
            __props__.__dict__["name"] = name
            __props__.__dict__["platform"] = platform
            __props__.__dict__["registry_credential"] = registry_credential
            __props__.__dict__["source_triggers"] = source_triggers
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
            __props__.__dict__["timer_triggers"] = timer_triggers
        super(RegistryTask, __self__).__init__(
            'azure:containerservice/registryTask:RegistryTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
            agent_setting: Optional[pulumi.Input[Union['RegistryTaskAgentSettingArgs', 'RegistryTaskAgentSettingArgsDict']]] = None,
            base_image_trigger: Optional[pulumi.Input[Union['RegistryTaskBaseImageTriggerArgs', 'RegistryTaskBaseImageTriggerArgsDict']]] = None,
            container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
            docker_step: Optional[pulumi.Input[Union['RegistryTaskDockerStepArgs', 'RegistryTaskDockerStepArgsDict']]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            encoded_step: Optional[pulumi.Input[Union['RegistryTaskEncodedStepArgs', 'RegistryTaskEncodedStepArgsDict']]] = None,
            file_step: Optional[pulumi.Input[Union['RegistryTaskFileStepArgs', 'RegistryTaskFileStepArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['RegistryTaskIdentityArgs', 'RegistryTaskIdentityArgsDict']]] = None,
            is_system_task: Optional[pulumi.Input[_builtins.bool]] = None,
            log_template: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            platform: Optional[pulumi.Input[Union['RegistryTaskPlatformArgs', 'RegistryTaskPlatformArgsDict']]] = None,
            registry_credential: Optional[pulumi.Input[Union['RegistryTaskRegistryCredentialArgs', 'RegistryTaskRegistryCredentialArgsDict']]] = None,
            source_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegistryTaskSourceTriggerArgs', 'RegistryTaskSourceTriggerArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            timer_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegistryTaskTimerTriggerArgs', 'RegistryTaskTimerTriggerArgsDict']]]]] = None) -> 'RegistryTask':
        """
        Get an existing RegistryTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_pool_name: The name of the dedicated Container Registry Agent Pool for this Container Registry Task.
        :param pulumi.Input[Union['RegistryTaskAgentSettingArgs', 'RegistryTaskAgentSettingArgsDict']] agent_setting: A `agent_setting` block as defined below.
               
               > **Note:** Only one of `agent_pool_name` and `agent_setting` can be specified.
        :param pulumi.Input[Union['RegistryTaskBaseImageTriggerArgs', 'RegistryTaskBaseImageTriggerArgsDict']] base_image_trigger: A `base_image_trigger` block as defined below.
        :param pulumi.Input[_builtins.str] container_registry_id: The ID of the Container Registry that this Container Registry Task resides in. Changing this forces a new Container Registry Task to be created.
        :param pulumi.Input[Union['RegistryTaskDockerStepArgs', 'RegistryTaskDockerStepArgsDict']] docker_step: A `docker_step` block as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Should this Container Registry Task be enabled? Defaults to `true`.
        :param pulumi.Input[Union['RegistryTaskEncodedStepArgs', 'RegistryTaskEncodedStepArgsDict']] encoded_step: A `encoded_step` block as defined below.
        :param pulumi.Input[Union['RegistryTaskFileStepArgs', 'RegistryTaskFileStepArgsDict']] file_step: A `file_step` block as defined below.
               
               > **Note:** For non-system task (when `is_system_task` is set to `false`), one and only one of the `docker_step`, `encoded_step` and `file_step` should be specified.
        :param pulumi.Input[Union['RegistryTaskIdentityArgs', 'RegistryTaskIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] is_system_task: Whether this Container Registry Task is a system task. Changing this forces a new Container Registry Task to be created. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Container Registry Task. Changing this forces a new Container Registry Task to be created.
        :param pulumi.Input[Union['RegistryTaskPlatformArgs', 'RegistryTaskPlatformArgsDict']] platform: A `platform` block as defined below.
               
               > **Note:** The `platform` is required for non-system task (when `is_system_task` is set to `false`).
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegistryTaskSourceTriggerArgs', 'RegistryTaskSourceTriggerArgsDict']]]] source_triggers: One or more `source_trigger` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegistryTaskTimerTriggerArgs', 'RegistryTaskTimerTriggerArgsDict']]]] timer_triggers: One or more `timer_trigger` blocks as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryTaskState.__new__(_RegistryTaskState)

        __props__.__dict__["agent_pool_name"] = agent_pool_name
        __props__.__dict__["agent_setting"] = agent_setting
        __props__.__dict__["base_image_trigger"] = base_image_trigger
        __props__.__dict__["container_registry_id"] = container_registry_id
        __props__.__dict__["docker_step"] = docker_step
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["encoded_step"] = encoded_step
        __props__.__dict__["file_step"] = file_step
        __props__.__dict__["identity"] = identity
        __props__.__dict__["is_system_task"] = is_system_task
        __props__.__dict__["log_template"] = log_template
        __props__.__dict__["name"] = name
        __props__.__dict__["platform"] = platform
        __props__.__dict__["registry_credential"] = registry_credential
        __props__.__dict__["source_triggers"] = source_triggers
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timeout_in_seconds"] = timeout_in_seconds
        __props__.__dict__["timer_triggers"] = timer_triggers
        return RegistryTask(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentPoolName")
    def agent_pool_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the dedicated Container Registry Agent Pool for this Container Registry Task.
        """
        return pulumi.get(self, "agent_pool_name")

    @_builtins.property
    @pulumi.getter(name="agentSetting")
    def agent_setting(self) -> pulumi.Output[Optional['outputs.RegistryTaskAgentSetting']]:
        """
        A `agent_setting` block as defined below.

        > **Note:** Only one of `agent_pool_name` and `agent_setting` can be specified.
        """
        return pulumi.get(self, "agent_setting")

    @_builtins.property
    @pulumi.getter(name="baseImageTrigger")
    def base_image_trigger(self) -> pulumi.Output[Optional['outputs.RegistryTaskBaseImageTrigger']]:
        """
        A `base_image_trigger` block as defined below.
        """
        return pulumi.get(self, "base_image_trigger")

    @_builtins.property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container Registry that this Container Registry Task resides in. Changing this forces a new Container Registry Task to be created.
        """
        return pulumi.get(self, "container_registry_id")

    @_builtins.property
    @pulumi.getter(name="dockerStep")
    def docker_step(self) -> pulumi.Output[Optional['outputs.RegistryTaskDockerStep']]:
        """
        A `docker_step` block as defined below.
        """
        return pulumi.get(self, "docker_step")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should this Container Registry Task be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="encodedStep")
    def encoded_step(self) -> pulumi.Output[Optional['outputs.RegistryTaskEncodedStep']]:
        """
        A `encoded_step` block as defined below.
        """
        return pulumi.get(self, "encoded_step")

    @_builtins.property
    @pulumi.getter(name="fileStep")
    def file_step(self) -> pulumi.Output[Optional['outputs.RegistryTaskFileStep']]:
        """
        A `file_step` block as defined below.

        > **Note:** For non-system task (when `is_system_task` is set to `false`), one and only one of the `docker_step`, `encoded_step` and `file_step` should be specified.
        """
        return pulumi.get(self, "file_step")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.RegistryTaskIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="isSystemTask")
    def is_system_task(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether this Container Registry Task is a system task. Changing this forces a new Container Registry Task to be created. Defaults to `false`.
        """
        return pulumi.get(self, "is_system_task")

    @_builtins.property
    @pulumi.getter(name="logTemplate")
    def log_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "log_template")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Container Registry Task. Changing this forces a new Container Registry Task to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> pulumi.Output[Optional['outputs.RegistryTaskPlatform']]:
        """
        A `platform` block as defined below.

        > **Note:** The `platform` is required for non-system task (when `is_system_task` is set to `false`).
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="registryCredential")
    def registry_credential(self) -> pulumi.Output[Optional['outputs.RegistryTaskRegistryCredential']]:
        return pulumi.get(self, "registry_credential")

    @_builtins.property
    @pulumi.getter(name="sourceTriggers")
    def source_triggers(self) -> pulumi.Output[Optional[Sequence['outputs.RegistryTaskSourceTrigger']]]:
        """
        One or more `source_trigger` blocks as defined below.
        """
        return pulumi.get(self, "source_triggers")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="timerTriggers")
    def timer_triggers(self) -> pulumi.Output[Optional[Sequence['outputs.RegistryTaskTimerTrigger']]]:
        """
        One or more `timer_trigger` blocks as defined below.
        """
        return pulumi.get(self, "timer_triggers")

