# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PortalTenantConfigurationArgs', 'PortalTenantConfiguration']

@pulumi.input_type
class PortalTenantConfigurationArgs:
    def __init__(__self__, *,
                 private_markdown_storage_enforced: pulumi.Input[_builtins.bool]):
        """
        The set of arguments for constructing a PortalTenantConfiguration resource.
        :param pulumi.Input[_builtins.bool] private_markdown_storage_enforced: Is the private tile markdown storage which used to display custom dynamic and static content enabled?
               
               > **Note:** When `private_markdown_storage_enforced` is set to `true`, only external storage configuration (URI) is allowed for Markdown tiles. Inline content configuration will be prohibited.
        """
        pulumi.set(__self__, "private_markdown_storage_enforced", private_markdown_storage_enforced)

    @_builtins.property
    @pulumi.getter(name="privateMarkdownStorageEnforced")
    def private_markdown_storage_enforced(self) -> pulumi.Input[_builtins.bool]:
        """
        Is the private tile markdown storage which used to display custom dynamic and static content enabled?

        > **Note:** When `private_markdown_storage_enforced` is set to `true`, only external storage configuration (URI) is allowed for Markdown tiles. Inline content configuration will be prohibited.
        """
        return pulumi.get(self, "private_markdown_storage_enforced")

    @private_markdown_storage_enforced.setter
    def private_markdown_storage_enforced(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "private_markdown_storage_enforced", value)


@pulumi.input_type
class _PortalTenantConfigurationState:
    def __init__(__self__, *,
                 private_markdown_storage_enforced: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering PortalTenantConfiguration resources.
        :param pulumi.Input[_builtins.bool] private_markdown_storage_enforced: Is the private tile markdown storage which used to display custom dynamic and static content enabled?
               
               > **Note:** When `private_markdown_storage_enforced` is set to `true`, only external storage configuration (URI) is allowed for Markdown tiles. Inline content configuration will be prohibited.
        """
        if private_markdown_storage_enforced is not None:
            pulumi.set(__self__, "private_markdown_storage_enforced", private_markdown_storage_enforced)

    @_builtins.property
    @pulumi.getter(name="privateMarkdownStorageEnforced")
    def private_markdown_storage_enforced(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the private tile markdown storage which used to display custom dynamic and static content enabled?

        > **Note:** When `private_markdown_storage_enforced` is set to `true`, only external storage configuration (URI) is allowed for Markdown tiles. Inline content configuration will be prohibited.
        """
        return pulumi.get(self, "private_markdown_storage_enforced")

    @private_markdown_storage_enforced.setter
    def private_markdown_storage_enforced(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_markdown_storage_enforced", value)


@pulumi.type_token("azure:core/portalTenantConfiguration:PortalTenantConfiguration")
class PortalTenantConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 private_markdown_storage_enforced: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages Portal Tenant Configuration.

        > **Note:** User has to be `Contributor` or `Owner` at scope `/` for managing this resource.

        > **Note:** The Service Principal with Tenant Admin can be created by `az ad sp create-for-rbac --name "<sp name>" --role="Contributor" --scopes="/"`.

        > **Note:** The Service Principal can be granted Tenant Admin permission by `az role assignment create --assignee "<app id>" --role "Contributor" --scope "/"`.

        > **Note:** While assigning the role to the existing/new Service Principal at the Tenant Scope, the user assigning role must already have the `Owner` role assigned at the Tenant Scope.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.PortalTenantConfiguration("example", private_markdown_storage_enforced=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Portal`: 2019-01-01-preview

        ## Import

        Portal Tenant Configurations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:core/portalTenantConfiguration:PortalTenantConfiguration example /providers/Microsoft.Portal/tenantConfigurations/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] private_markdown_storage_enforced: Is the private tile markdown storage which used to display custom dynamic and static content enabled?
               
               > **Note:** When `private_markdown_storage_enforced` is set to `true`, only external storage configuration (URI) is allowed for Markdown tiles. Inline content configuration will be prohibited.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PortalTenantConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Portal Tenant Configuration.

        > **Note:** User has to be `Contributor` or `Owner` at scope `/` for managing this resource.

        > **Note:** The Service Principal with Tenant Admin can be created by `az ad sp create-for-rbac --name "<sp name>" --role="Contributor" --scopes="/"`.

        > **Note:** The Service Principal can be granted Tenant Admin permission by `az role assignment create --assignee "<app id>" --role "Contributor" --scope "/"`.

        > **Note:** While assigning the role to the existing/new Service Principal at the Tenant Scope, the user assigning role must already have the `Owner` role assigned at the Tenant Scope.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.PortalTenantConfiguration("example", private_markdown_storage_enforced=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Portal`: 2019-01-01-preview

        ## Import

        Portal Tenant Configurations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:core/portalTenantConfiguration:PortalTenantConfiguration example /providers/Microsoft.Portal/tenantConfigurations/default
        ```

        :param str resource_name: The name of the resource.
        :param PortalTenantConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PortalTenantConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 private_markdown_storage_enforced: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PortalTenantConfigurationArgs.__new__(PortalTenantConfigurationArgs)

            if private_markdown_storage_enforced is None and not opts.urn:
                raise TypeError("Missing required property 'private_markdown_storage_enforced'")
            __props__.__dict__["private_markdown_storage_enforced"] = private_markdown_storage_enforced
        super(PortalTenantConfiguration, __self__).__init__(
            'azure:core/portalTenantConfiguration:PortalTenantConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            private_markdown_storage_enforced: Optional[pulumi.Input[_builtins.bool]] = None) -> 'PortalTenantConfiguration':
        """
        Get an existing PortalTenantConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] private_markdown_storage_enforced: Is the private tile markdown storage which used to display custom dynamic and static content enabled?
               
               > **Note:** When `private_markdown_storage_enforced` is set to `true`, only external storage configuration (URI) is allowed for Markdown tiles. Inline content configuration will be prohibited.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PortalTenantConfigurationState.__new__(_PortalTenantConfigurationState)

        __props__.__dict__["private_markdown_storage_enforced"] = private_markdown_storage_enforced
        return PortalTenantConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="privateMarkdownStorageEnforced")
    def private_markdown_storage_enforced(self) -> pulumi.Output[_builtins.bool]:
        """
        Is the private tile markdown storage which used to display custom dynamic and static content enabled?

        > **Note:** When `private_markdown_storage_enforced` is set to `true`, only external storage configuration (URI) is allowed for Markdown tiles. Inline content configuration will be prohibited.
        """
        return pulumi.get(self, "private_markdown_storage_enforced")

