# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubscriptionCostManagementViewArgs', 'SubscriptionCostManagementView']

@pulumi.input_type
class SubscriptionCostManagementViewArgs:
    def __init__(__self__, *,
                 accumulated: pulumi.Input[_builtins.bool],
                 chart_type: pulumi.Input[_builtins.str],
                 dataset: pulumi.Input['SubscriptionCostManagementViewDatasetArgs'],
                 display_name: pulumi.Input[_builtins.str],
                 report_type: pulumi.Input[_builtins.str],
                 subscription_id: pulumi.Input[_builtins.str],
                 timeframe: pulumi.Input[_builtins.str],
                 kpis: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewKpiArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pivots: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewPivotArgs']]]] = None):
        """
        The set of arguments for constructing a SubscriptionCostManagementView resource.
        :param pulumi.Input[_builtins.bool] accumulated: Whether the costs data in the Cost Management View are accumulated over time. Changing this forces a new Cost Management View for a Subscription to be created.
        :param pulumi.Input[_builtins.str] chart_type: Chart type of the main view in Cost Analysis. Possible values are `Area`, `GroupedColumn`, `Line`, `StackedColumn` and `Table`.
        :param pulumi.Input['SubscriptionCostManagementViewDatasetArgs'] dataset: A `dataset` block as defined below.
        :param pulumi.Input[_builtins.str] display_name: User visible input name of the Cost Management View.
        :param pulumi.Input[_builtins.str] report_type: The type of the report. The only possible value is `Usage`.
        :param pulumi.Input[_builtins.str] subscription_id: The ID of the Subscription this View is scoped to. Changing this forces a new Cost Management View for a Subscription to be created.
        :param pulumi.Input[_builtins.str] timeframe: The time frame for pulling data for the report. Possible values are `Custom`, `MonthToDate`, `WeekToDate` and `YearToDate`.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewKpiArgs']]] kpis: One or more `kpi` blocks as defined below, to show in Cost Analysis UI.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cost Management View for a Subscription. Changing this forces a new Cost Management View for a Subscription to be created.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewPivotArgs']]] pivots: One or more `pivot` blocks as defined below, containing the configuration of 3 sub-views in the Cost Analysis UI. Non table views should have three pivots.
        """
        pulumi.set(__self__, "accumulated", accumulated)
        pulumi.set(__self__, "chart_type", chart_type)
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "report_type", report_type)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "timeframe", timeframe)
        if kpis is not None:
            pulumi.set(__self__, "kpis", kpis)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pivots is not None:
            pulumi.set(__self__, "pivots", pivots)

    @_builtins.property
    @pulumi.getter
    def accumulated(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the costs data in the Cost Management View are accumulated over time. Changing this forces a new Cost Management View for a Subscription to be created.
        """
        return pulumi.get(self, "accumulated")

    @accumulated.setter
    def accumulated(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "accumulated", value)

    @_builtins.property
    @pulumi.getter(name="chartType")
    def chart_type(self) -> pulumi.Input[_builtins.str]:
        """
        Chart type of the main view in Cost Analysis. Possible values are `Area`, `GroupedColumn`, `Line`, `StackedColumn` and `Table`.
        """
        return pulumi.get(self, "chart_type")

    @chart_type.setter
    def chart_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "chart_type", value)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> pulumi.Input['SubscriptionCostManagementViewDatasetArgs']:
        """
        A `dataset` block as defined below.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input['SubscriptionCostManagementViewDatasetArgs']):
        pulumi.set(self, "dataset", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        User visible input name of the Cost Management View.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="reportType")
    def report_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the report. The only possible value is `Usage`.
        """
        return pulumi.get(self, "report_type")

    @report_type.setter
    def report_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "report_type", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Subscription this View is scoped to. Changing this forces a new Cost Management View for a Subscription to be created.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subscription_id", value)

    @_builtins.property
    @pulumi.getter
    def timeframe(self) -> pulumi.Input[_builtins.str]:
        """
        The time frame for pulling data for the report. Possible values are `Custom`, `MonthToDate`, `WeekToDate` and `YearToDate`.
        """
        return pulumi.get(self, "timeframe")

    @timeframe.setter
    def timeframe(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "timeframe", value)

    @_builtins.property
    @pulumi.getter
    def kpis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewKpiArgs']]]]:
        """
        One or more `kpi` blocks as defined below, to show in Cost Analysis UI.
        """
        return pulumi.get(self, "kpis")

    @kpis.setter
    def kpis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewKpiArgs']]]]):
        pulumi.set(self, "kpis", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Cost Management View for a Subscription. Changing this forces a new Cost Management View for a Subscription to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def pivots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewPivotArgs']]]]:
        """
        One or more `pivot` blocks as defined below, containing the configuration of 3 sub-views in the Cost Analysis UI. Non table views should have three pivots.
        """
        return pulumi.get(self, "pivots")

    @pivots.setter
    def pivots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewPivotArgs']]]]):
        pulumi.set(self, "pivots", value)


@pulumi.input_type
class _SubscriptionCostManagementViewState:
    def __init__(__self__, *,
                 accumulated: Optional[pulumi.Input[_builtins.bool]] = None,
                 chart_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset: Optional[pulumi.Input['SubscriptionCostManagementViewDatasetArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kpis: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewKpiArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pivots: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewPivotArgs']]]] = None,
                 report_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeframe: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SubscriptionCostManagementView resources.
        :param pulumi.Input[_builtins.bool] accumulated: Whether the costs data in the Cost Management View are accumulated over time. Changing this forces a new Cost Management View for a Subscription to be created.
        :param pulumi.Input[_builtins.str] chart_type: Chart type of the main view in Cost Analysis. Possible values are `Area`, `GroupedColumn`, `Line`, `StackedColumn` and `Table`.
        :param pulumi.Input['SubscriptionCostManagementViewDatasetArgs'] dataset: A `dataset` block as defined below.
        :param pulumi.Input[_builtins.str] display_name: User visible input name of the Cost Management View.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewKpiArgs']]] kpis: One or more `kpi` blocks as defined below, to show in Cost Analysis UI.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cost Management View for a Subscription. Changing this forces a new Cost Management View for a Subscription to be created.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewPivotArgs']]] pivots: One or more `pivot` blocks as defined below, containing the configuration of 3 sub-views in the Cost Analysis UI. Non table views should have three pivots.
        :param pulumi.Input[_builtins.str] report_type: The type of the report. The only possible value is `Usage`.
        :param pulumi.Input[_builtins.str] subscription_id: The ID of the Subscription this View is scoped to. Changing this forces a new Cost Management View for a Subscription to be created.
        :param pulumi.Input[_builtins.str] timeframe: The time frame for pulling data for the report. Possible values are `Custom`, `MonthToDate`, `WeekToDate` and `YearToDate`.
        """
        if accumulated is not None:
            pulumi.set(__self__, "accumulated", accumulated)
        if chart_type is not None:
            pulumi.set(__self__, "chart_type", chart_type)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if kpis is not None:
            pulumi.set(__self__, "kpis", kpis)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pivots is not None:
            pulumi.set(__self__, "pivots", pivots)
        if report_type is not None:
            pulumi.set(__self__, "report_type", report_type)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if timeframe is not None:
            pulumi.set(__self__, "timeframe", timeframe)

    @_builtins.property
    @pulumi.getter
    def accumulated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the costs data in the Cost Management View are accumulated over time. Changing this forces a new Cost Management View for a Subscription to be created.
        """
        return pulumi.get(self, "accumulated")

    @accumulated.setter
    def accumulated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accumulated", value)

    @_builtins.property
    @pulumi.getter(name="chartType")
    def chart_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Chart type of the main view in Cost Analysis. Possible values are `Area`, `GroupedColumn`, `Line`, `StackedColumn` and `Table`.
        """
        return pulumi.get(self, "chart_type")

    @chart_type.setter
    def chart_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chart_type", value)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input['SubscriptionCostManagementViewDatasetArgs']]:
        """
        A `dataset` block as defined below.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input['SubscriptionCostManagementViewDatasetArgs']]):
        pulumi.set(self, "dataset", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User visible input name of the Cost Management View.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def kpis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewKpiArgs']]]]:
        """
        One or more `kpi` blocks as defined below, to show in Cost Analysis UI.
        """
        return pulumi.get(self, "kpis")

    @kpis.setter
    def kpis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewKpiArgs']]]]):
        pulumi.set(self, "kpis", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Cost Management View for a Subscription. Changing this forces a new Cost Management View for a Subscription to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def pivots(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewPivotArgs']]]]:
        """
        One or more `pivot` blocks as defined below, containing the configuration of 3 sub-views in the Cost Analysis UI. Non table views should have three pivots.
        """
        return pulumi.get(self, "pivots")

    @pivots.setter
    def pivots(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubscriptionCostManagementViewPivotArgs']]]]):
        pulumi.set(self, "pivots", value)

    @_builtins.property
    @pulumi.getter(name="reportType")
    def report_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the report. The only possible value is `Usage`.
        """
        return pulumi.get(self, "report_type")

    @report_type.setter
    def report_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "report_type", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subscription this View is scoped to. Changing this forces a new Cost Management View for a Subscription to be created.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_id", value)

    @_builtins.property
    @pulumi.getter
    def timeframe(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time frame for pulling data for the report. Possible values are `Custom`, `MonthToDate`, `WeekToDate` and `YearToDate`.
        """
        return pulumi.get(self, "timeframe")

    @timeframe.setter
    def timeframe(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timeframe", value)


@pulumi.type_token("azure:core/subscriptionCostManagementView:SubscriptionCostManagementView")
class SubscriptionCostManagementView(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accumulated: Optional[pulumi.Input[_builtins.bool]] = None,
                 chart_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset: Optional[pulumi.Input[Union['SubscriptionCostManagementViewDatasetArgs', 'SubscriptionCostManagementViewDatasetArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kpis: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionCostManagementViewKpiArgs', 'SubscriptionCostManagementViewKpiArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pivots: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionCostManagementViewPivotArgs', 'SubscriptionCostManagementViewPivotArgsDict']]]]] = None,
                 report_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeframe: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Cost Management View for a Subscription.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.SubscriptionCostManagementView("example",
            name="example",
            display_name="Cost View per Month",
            chart_type="StackedColumn",
            accumulated=False,
            subscription_id="/subscription/00000000-0000-0000-0000-000000000000",
            report_type="Usage",
            timeframe="MonthToDate",
            dataset={
                "granularity": "Monthly",
                "aggregations": [{
                    "name": "totalCost",
                    "column_name": "Cost",
                }],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CostManagement`: 2023-08-01

        ## Import

        Cost Management View for a Subscriptions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:core/subscriptionCostManagementView:SubscriptionCostManagementView example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/views/costmanagementview
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] accumulated: Whether the costs data in the Cost Management View are accumulated over time. Changing this forces a new Cost Management View for a Subscription to be created.
        :param pulumi.Input[_builtins.str] chart_type: Chart type of the main view in Cost Analysis. Possible values are `Area`, `GroupedColumn`, `Line`, `StackedColumn` and `Table`.
        :param pulumi.Input[Union['SubscriptionCostManagementViewDatasetArgs', 'SubscriptionCostManagementViewDatasetArgsDict']] dataset: A `dataset` block as defined below.
        :param pulumi.Input[_builtins.str] display_name: User visible input name of the Cost Management View.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionCostManagementViewKpiArgs', 'SubscriptionCostManagementViewKpiArgsDict']]]] kpis: One or more `kpi` blocks as defined below, to show in Cost Analysis UI.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cost Management View for a Subscription. Changing this forces a new Cost Management View for a Subscription to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionCostManagementViewPivotArgs', 'SubscriptionCostManagementViewPivotArgsDict']]]] pivots: One or more `pivot` blocks as defined below, containing the configuration of 3 sub-views in the Cost Analysis UI. Non table views should have three pivots.
        :param pulumi.Input[_builtins.str] report_type: The type of the report. The only possible value is `Usage`.
        :param pulumi.Input[_builtins.str] subscription_id: The ID of the Subscription this View is scoped to. Changing this forces a new Cost Management View for a Subscription to be created.
        :param pulumi.Input[_builtins.str] timeframe: The time frame for pulling data for the report. Possible values are `Custom`, `MonthToDate`, `WeekToDate` and `YearToDate`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionCostManagementViewArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Cost Management View for a Subscription.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.SubscriptionCostManagementView("example",
            name="example",
            display_name="Cost View per Month",
            chart_type="StackedColumn",
            accumulated=False,
            subscription_id="/subscription/00000000-0000-0000-0000-000000000000",
            report_type="Usage",
            timeframe="MonthToDate",
            dataset={
                "granularity": "Monthly",
                "aggregations": [{
                    "name": "totalCost",
                    "column_name": "Cost",
                }],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CostManagement`: 2023-08-01

        ## Import

        Cost Management View for a Subscriptions can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:core/subscriptionCostManagementView:SubscriptionCostManagementView example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/views/costmanagementview
        ```

        :param str resource_name: The name of the resource.
        :param SubscriptionCostManagementViewArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionCostManagementViewArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accumulated: Optional[pulumi.Input[_builtins.bool]] = None,
                 chart_type: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset: Optional[pulumi.Input[Union['SubscriptionCostManagementViewDatasetArgs', 'SubscriptionCostManagementViewDatasetArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kpis: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionCostManagementViewKpiArgs', 'SubscriptionCostManagementViewKpiArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pivots: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionCostManagementViewPivotArgs', 'SubscriptionCostManagementViewPivotArgsDict']]]]] = None,
                 report_type: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeframe: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionCostManagementViewArgs.__new__(SubscriptionCostManagementViewArgs)

            if accumulated is None and not opts.urn:
                raise TypeError("Missing required property 'accumulated'")
            __props__.__dict__["accumulated"] = accumulated
            if chart_type is None and not opts.urn:
                raise TypeError("Missing required property 'chart_type'")
            __props__.__dict__["chart_type"] = chart_type
            if dataset is None and not opts.urn:
                raise TypeError("Missing required property 'dataset'")
            __props__.__dict__["dataset"] = dataset
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["kpis"] = kpis
            __props__.__dict__["name"] = name
            __props__.__dict__["pivots"] = pivots
            if report_type is None and not opts.urn:
                raise TypeError("Missing required property 'report_type'")
            __props__.__dict__["report_type"] = report_type
            if subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'subscription_id'")
            __props__.__dict__["subscription_id"] = subscription_id
            if timeframe is None and not opts.urn:
                raise TypeError("Missing required property 'timeframe'")
            __props__.__dict__["timeframe"] = timeframe
        super(SubscriptionCostManagementView, __self__).__init__(
            'azure:core/subscriptionCostManagementView:SubscriptionCostManagementView',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accumulated: Optional[pulumi.Input[_builtins.bool]] = None,
            chart_type: Optional[pulumi.Input[_builtins.str]] = None,
            dataset: Optional[pulumi.Input[Union['SubscriptionCostManagementViewDatasetArgs', 'SubscriptionCostManagementViewDatasetArgsDict']]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            kpis: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionCostManagementViewKpiArgs', 'SubscriptionCostManagementViewKpiArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pivots: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionCostManagementViewPivotArgs', 'SubscriptionCostManagementViewPivotArgsDict']]]]] = None,
            report_type: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
            timeframe: Optional[pulumi.Input[_builtins.str]] = None) -> 'SubscriptionCostManagementView':
        """
        Get an existing SubscriptionCostManagementView resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] accumulated: Whether the costs data in the Cost Management View are accumulated over time. Changing this forces a new Cost Management View for a Subscription to be created.
        :param pulumi.Input[_builtins.str] chart_type: Chart type of the main view in Cost Analysis. Possible values are `Area`, `GroupedColumn`, `Line`, `StackedColumn` and `Table`.
        :param pulumi.Input[Union['SubscriptionCostManagementViewDatasetArgs', 'SubscriptionCostManagementViewDatasetArgsDict']] dataset: A `dataset` block as defined below.
        :param pulumi.Input[_builtins.str] display_name: User visible input name of the Cost Management View.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionCostManagementViewKpiArgs', 'SubscriptionCostManagementViewKpiArgsDict']]]] kpis: One or more `kpi` blocks as defined below, to show in Cost Analysis UI.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Cost Management View for a Subscription. Changing this forces a new Cost Management View for a Subscription to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionCostManagementViewPivotArgs', 'SubscriptionCostManagementViewPivotArgsDict']]]] pivots: One or more `pivot` blocks as defined below, containing the configuration of 3 sub-views in the Cost Analysis UI. Non table views should have three pivots.
        :param pulumi.Input[_builtins.str] report_type: The type of the report. The only possible value is `Usage`.
        :param pulumi.Input[_builtins.str] subscription_id: The ID of the Subscription this View is scoped to. Changing this forces a new Cost Management View for a Subscription to be created.
        :param pulumi.Input[_builtins.str] timeframe: The time frame for pulling data for the report. Possible values are `Custom`, `MonthToDate`, `WeekToDate` and `YearToDate`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriptionCostManagementViewState.__new__(_SubscriptionCostManagementViewState)

        __props__.__dict__["accumulated"] = accumulated
        __props__.__dict__["chart_type"] = chart_type
        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["kpis"] = kpis
        __props__.__dict__["name"] = name
        __props__.__dict__["pivots"] = pivots
        __props__.__dict__["report_type"] = report_type
        __props__.__dict__["subscription_id"] = subscription_id
        __props__.__dict__["timeframe"] = timeframe
        return SubscriptionCostManagementView(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def accumulated(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the costs data in the Cost Management View are accumulated over time. Changing this forces a new Cost Management View for a Subscription to be created.
        """
        return pulumi.get(self, "accumulated")

    @_builtins.property
    @pulumi.getter(name="chartType")
    def chart_type(self) -> pulumi.Output[_builtins.str]:
        """
        Chart type of the main view in Cost Analysis. Possible values are `Area`, `GroupedColumn`, `Line`, `StackedColumn` and `Table`.
        """
        return pulumi.get(self, "chart_type")

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> pulumi.Output['outputs.SubscriptionCostManagementViewDataset']:
        """
        A `dataset` block as defined below.
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        User visible input name of the Cost Management View.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def kpis(self) -> pulumi.Output[Optional[Sequence['outputs.SubscriptionCostManagementViewKpi']]]:
        """
        One or more `kpi` blocks as defined below, to show in Cost Analysis UI.
        """
        return pulumi.get(self, "kpis")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Cost Management View for a Subscription. Changing this forces a new Cost Management View for a Subscription to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def pivots(self) -> pulumi.Output[Optional[Sequence['outputs.SubscriptionCostManagementViewPivot']]]:
        """
        One or more `pivot` blocks as defined below, containing the configuration of 3 sub-views in the Cost Analysis UI. Non table views should have three pivots.
        """
        return pulumi.get(self, "pivots")

    @_builtins.property
    @pulumi.getter(name="reportType")
    def report_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the report. The only possible value is `Usage`.
        """
        return pulumi.get(self, "report_type")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Subscription this View is scoped to. Changing this forces a new Cost Management View for a Subscription to be created.
        """
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter
    def timeframe(self) -> pulumi.Output[_builtins.str]:
        """
        The time frame for pulling data for the report. Possible values are `Custom`, `MonthToDate`, `WeekToDate` and `YearToDate`.
        """
        return pulumi.get(self, "timeframe")

