# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitorArgs', 'Monitor']

@pulumi.input_type
class MonitorArgs:
    def __init__(__self__, *,
                 datadog_organization: pulumi.Input['MonitorDatadogOrganizationArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 user: pulumi.Input['MonitorUserArgs'],
                 identity: Optional[pulumi.Input['MonitorIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Monitor resource.
        :param pulumi.Input['MonitorDatadogOrganizationArgs'] datadog_organization: A `datadog_organization` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[_builtins.str] sku_name: The name which should be used for this sku.
        :param pulumi.Input['MonitorUserArgs'] user: A `user` block as defined below.
        :param pulumi.Input['MonitorIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[_builtins.bool] monitoring_enabled: Is monitoring enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name of the user that will be associated with the Datadog Monitor. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Datadog Monitor.
        """
        pulumi.set(__self__, "datadog_organization", datadog_organization)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        pulumi.set(__self__, "user", user)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if monitoring_enabled is not None:
            pulumi.set(__self__, "monitoring_enabled", monitoring_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="datadogOrganization")
    def datadog_organization(self) -> pulumi.Input['MonitorDatadogOrganizationArgs']:
        """
        A `datadog_organization` block as defined below.
        """
        return pulumi.get(self, "datadog_organization")

    @datadog_organization.setter
    def datadog_organization(self, value: pulumi.Input['MonitorDatadogOrganizationArgs']):
        pulumi.set(self, "datadog_organization", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name which should be used for this sku.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input['MonitorUserArgs']:
        """
        A `user` block as defined below.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input['MonitorUserArgs']):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['MonitorIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['MonitorIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="monitoringEnabled")
    def monitoring_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is monitoring enabled? Defaults to `true`.
        """
        return pulumi.get(self, "monitoring_enabled")

    @monitoring_enabled.setter
    def monitoring_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monitoring_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user that will be associated with the Datadog Monitor. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Datadog Monitor.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _MonitorState:
    def __init__(__self__, *,
                 datadog_organization: Optional[pulumi.Input['MonitorDatadogOrganizationArgs']] = None,
                 identity: Optional[pulumi.Input['MonitorIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 marketplace_subscription_status: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user: Optional[pulumi.Input['MonitorUserArgs']] = None):
        """
        Input properties used for looking up and filtering Monitor resources.
        :param pulumi.Input['MonitorDatadogOrganizationArgs'] datadog_organization: A `datadog_organization` block as defined below.
        :param pulumi.Input['MonitorIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[_builtins.str] marketplace_subscription_status: Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state.
        :param pulumi.Input[_builtins.bool] monitoring_enabled: Is monitoring enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name of the user that will be associated with the Datadog Monitor. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[_builtins.str] sku_name: The name which should be used for this sku.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Datadog Monitor.
        :param pulumi.Input['MonitorUserArgs'] user: A `user` block as defined below.
        """
        if datadog_organization is not None:
            pulumi.set(__self__, "datadog_organization", datadog_organization)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if marketplace_subscription_status is not None:
            pulumi.set(__self__, "marketplace_subscription_status", marketplace_subscription_status)
        if monitoring_enabled is not None:
            pulumi.set(__self__, "monitoring_enabled", monitoring_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter(name="datadogOrganization")
    def datadog_organization(self) -> Optional[pulumi.Input['MonitorDatadogOrganizationArgs']]:
        """
        A `datadog_organization` block as defined below.
        """
        return pulumi.get(self, "datadog_organization")

    @datadog_organization.setter
    def datadog_organization(self, value: Optional[pulumi.Input['MonitorDatadogOrganizationArgs']]):
        pulumi.set(self, "datadog_organization", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['MonitorIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['MonitorIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="marketplaceSubscriptionStatus")
    def marketplace_subscription_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state.
        """
        return pulumi.get(self, "marketplace_subscription_status")

    @marketplace_subscription_status.setter
    def marketplace_subscription_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "marketplace_subscription_status", value)

    @_builtins.property
    @pulumi.getter(name="monitoringEnabled")
    def monitoring_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is monitoring enabled? Defaults to `true`.
        """
        return pulumi.get(self, "monitoring_enabled")

    @monitoring_enabled.setter
    def monitoring_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monitoring_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user that will be associated with the Datadog Monitor. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this sku.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Datadog Monitor.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input['MonitorUserArgs']]:
        """
        A `user` block as defined below.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input['MonitorUserArgs']]):
        pulumi.set(self, "user", value)


@pulumi.type_token("azure:datadog/monitor:Monitor")
class Monitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datadog_organization: Optional[pulumi.Input[Union['MonitorDatadogOrganizationArgs', 'MonitorDatadogOrganizationArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user: Optional[pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']]] = None,
                 __props__=None):
        """
        Manages a datadog Monitor.

        ## Example Usage

        ### Monitor creation with linking to Datadog organization

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-datadog",
            location="West US 2")
        example_monitor = azure.datadog.Monitor("example",
            name="example-monitor",
            resource_group_name=example.name,
            location=example.location,
            datadog_organization={
                "api_key": "XXXX",
                "application_key": "XXXX",
            },
            user={
                "name": "Example",
                "email": "abc@xyz.com",
            },
            sku_name="Linked",
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## Role Assignment

        To enable metrics flow, perform role assignment on the identity created above. `Monitoring reader(43d0d8ad-25c7-4714-9337-8ba259a9fe05)` role is required .

        ### Role assignment on the monitor created

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.get_subscription()
        monitoring_reader = azure.authorization.get_role_definition(name="Monitoring Reader")
        example = azure.authorization.Assignment("example",
            scope=primary.id,
            role_definition_id=monitoring_reader.role_definition_id,
            principal_id=example_azurerm_datadog_monitor["identity"][0]["principalId"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Datadog`: 2021-03-01

        ## Import

        Datadog Monitors can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datadog/monitor:Monitor example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Datadog/monitors/monitor1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MonitorDatadogOrganizationArgs', 'MonitorDatadogOrganizationArgsDict']] datadog_organization: A `datadog_organization` block as defined below.
        :param pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[_builtins.bool] monitoring_enabled: Is monitoring enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name of the user that will be associated with the Datadog Monitor. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[_builtins.str] sku_name: The name which should be used for this sku.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Datadog Monitor.
        :param pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']] user: A `user` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a datadog Monitor.

        ## Example Usage

        ### Monitor creation with linking to Datadog organization

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-datadog",
            location="West US 2")
        example_monitor = azure.datadog.Monitor("example",
            name="example-monitor",
            resource_group_name=example.name,
            location=example.location,
            datadog_organization={
                "api_key": "XXXX",
                "application_key": "XXXX",
            },
            user={
                "name": "Example",
                "email": "abc@xyz.com",
            },
            sku_name="Linked",
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## Role Assignment

        To enable metrics flow, perform role assignment on the identity created above. `Monitoring reader(43d0d8ad-25c7-4714-9337-8ba259a9fe05)` role is required .

        ### Role assignment on the monitor created

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.get_subscription()
        monitoring_reader = azure.authorization.get_role_definition(name="Monitoring Reader")
        example = azure.authorization.Assignment("example",
            scope=primary.id,
            role_definition_id=monitoring_reader.role_definition_id,
            principal_id=example_azurerm_datadog_monitor["identity"][0]["principalId"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Datadog`: 2021-03-01

        ## Import

        Datadog Monitors can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datadog/monitor:Monitor example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Datadog/monitors/monitor1
        ```

        :param str resource_name: The name of the resource.
        :param MonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datadog_organization: Optional[pulumi.Input[Union['MonitorDatadogOrganizationArgs', 'MonitorDatadogOrganizationArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user: Optional[pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorArgs.__new__(MonitorArgs)

            if datadog_organization is None and not opts.urn:
                raise TypeError("Missing required property 'datadog_organization'")
            __props__.__dict__["datadog_organization"] = datadog_organization
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["monitoring_enabled"] = monitoring_enabled
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["tags"] = tags
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
            __props__.__dict__["marketplace_subscription_status"] = None
        super(Monitor, __self__).__init__(
            'azure:datadog/monitor:Monitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            datadog_organization: Optional[pulumi.Input[Union['MonitorDatadogOrganizationArgs', 'MonitorDatadogOrganizationArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            marketplace_subscription_status: Optional[pulumi.Input[_builtins.str]] = None,
            monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            user: Optional[pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']]] = None) -> 'Monitor':
        """
        Get an existing Monitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MonitorDatadogOrganizationArgs', 'MonitorDatadogOrganizationArgsDict']] datadog_organization: A `datadog_organization` block as defined below.
        :param pulumi.Input[Union['MonitorIdentityArgs', 'MonitorIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[_builtins.str] marketplace_subscription_status: Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state.
        :param pulumi.Input[_builtins.bool] monitoring_enabled: Is monitoring enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name of the user that will be associated with the Datadog Monitor. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        :param pulumi.Input[_builtins.str] sku_name: The name which should be used for this sku.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Datadog Monitor.
        :param pulumi.Input[Union['MonitorUserArgs', 'MonitorUserArgsDict']] user: A `user` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorState.__new__(_MonitorState)

        __props__.__dict__["datadog_organization"] = datadog_organization
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["marketplace_subscription_status"] = marketplace_subscription_status
        __props__.__dict__["monitoring_enabled"] = monitoring_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user"] = user
        return Monitor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="datadogOrganization")
    def datadog_organization(self) -> pulumi.Output['outputs.MonitorDatadogOrganization']:
        """
        A `datadog_organization` block as defined below.
        """
        return pulumi.get(self, "datadog_organization")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.MonitorIdentity']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="marketplaceSubscriptionStatus")
    def marketplace_subscription_status(self) -> pulumi.Output[_builtins.str]:
        """
        Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state.
        """
        return pulumi.get(self, "marketplace_subscription_status")

    @_builtins.property
    @pulumi.getter(name="monitoringEnabled")
    def monitoring_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is monitoring enabled? Defaults to `true`.
        """
        return pulumi.get(self, "monitoring_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the user that will be associated with the Datadog Monitor. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Datadog Monitor should exist. Changing this forces a new Datadog Monitor to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this sku.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Datadog Monitor.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output['outputs.MonitorUser']:
        """
        A `user` block as defined below.
        """
        return pulumi.get(self, "user")

