# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFactoryResult',
    'AwaitableGetFactoryResult',
    'get_factory',
    'get_factory_output',
]

@pulumi.output_type
class GetFactoryResult:
    """
    A collection of values returned by getFactory.
    """
    def __init__(__self__, github_configurations=None, id=None, identities=None, location=None, name=None, resource_group_name=None, tags=None, vsts_configurations=None):
        if github_configurations and not isinstance(github_configurations, list):
            raise TypeError("Expected argument 'github_configurations' to be a list")
        pulumi.set(__self__, "github_configurations", github_configurations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vsts_configurations and not isinstance(vsts_configurations, list):
            raise TypeError("Expected argument 'vsts_configurations' to be a list")
        pulumi.set(__self__, "vsts_configurations", vsts_configurations)

    @_builtins.property
    @pulumi.getter(name="githubConfigurations")
    def github_configurations(self) -> Sequence['outputs.GetFactoryGithubConfigurationResult']:
        """
        A `github_configuration` block as defined below.
        """
        return pulumi.get(self, "github_configurations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetFactoryIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Azure Data Factory exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Azure Data Factory.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vstsConfigurations")
    def vsts_configurations(self) -> Sequence['outputs.GetFactoryVstsConfigurationResult']:
        """
        A `vsts_configuration` block as defined below.
        """
        return pulumi.get(self, "vsts_configurations")


class AwaitableGetFactoryResult(GetFactoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFactoryResult(
            github_configurations=self.github_configurations,
            id=self.id,
            identities=self.identities,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags,
            vsts_configurations=self.vsts_configurations)


def get_factory(name: Optional[_builtins.str] = None,
                resource_group_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFactoryResult:
    """
    Use this data source to access information about an existing Azure Data Factory (Version 2).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.datafactory.get_factory(name="existing-adf",
        resource_group_name="existing-rg")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DataFactory`: 2018-06-01


    :param _builtins.str name: The name of this Azure Data Factory.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Azure Data Factory exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:datafactory/getFactory:getFactory', __args__, opts=opts, typ=GetFactoryResult).value

    return AwaitableGetFactoryResult(
        github_configurations=pulumi.get(__ret__, 'github_configurations'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'),
        vsts_configurations=pulumi.get(__ret__, 'vsts_configurations'))
def get_factory_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFactoryResult]:
    """
    Use this data source to access information about an existing Azure Data Factory (Version 2).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.datafactory.get_factory(name="existing-adf",
        resource_group_name="existing-rg")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DataFactory`: 2018-06-01


    :param _builtins.str name: The name of this Azure Data Factory.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Azure Data Factory exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:datafactory/getFactory:getFactory', __args__, opts=opts, typ=GetFactoryResult)
    return __ret__.apply(lambda __response__: GetFactoryResult(
        github_configurations=pulumi.get(__response__, 'github_configurations'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags'),
        vsts_configurations=pulumi.get(__response__, 'vsts_configurations')))
