# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TriggerBlobEventArgs', 'TriggerBlobEvent']

@pulumi.input_type
class TriggerBlobEventArgs:
    def __init__(__self__, *,
                 data_factory_id: pulumi.Input[_builtins.str],
                 events: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 pipelines: pulumi.Input[Sequence[pulumi.Input['TriggerBlobEventPipelineArgs']]],
                 storage_account_id: pulumi.Input[_builtins.str],
                 activated: Optional[pulumi.Input[_builtins.bool]] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blob_path_begins_with: Optional[pulumi.Input[_builtins.str]] = None,
                 blob_path_ends_with: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_empty_blobs: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TriggerBlobEvent resource.
        :param pulumi.Input[_builtins.str] data_factory_id: The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] events: List of events that will fire this trigger. Possible values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobDeleted`.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBlobEventPipelineArgs']]] pipelines: One or more `pipeline` blocks as defined below.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of Storage Account in which blob event will be listened. Changing this forces a new resource.
        :param pulumi.Input[_builtins.bool] activated: Specifies if the Data Factory Blob Event Trigger is activated. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Blob Event Trigger.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Blob Event Trigger.
        :param pulumi.Input[_builtins.str] blob_path_begins_with: The pattern that blob path starts with for trigger to fire.
        :param pulumi.Input[_builtins.str] blob_path_ends_with: The pattern that blob path ends with for trigger to fire.
               
               > **Note:** At least one of `blob_path_begins_with` and `blob_path_ends_with` must be set.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Blob Event Trigger.
        :param pulumi.Input[_builtins.bool] ignore_empty_blobs: are blobs with zero bytes ignored?
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Blob Event Trigger. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "pipelines", pipelines)
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if activated is not None:
            pulumi.set(__self__, "activated", activated)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if blob_path_begins_with is not None:
            pulumi.set(__self__, "blob_path_begins_with", blob_path_begins_with)
        if blob_path_ends_with is not None:
            pulumi.set(__self__, "blob_path_ends_with", blob_path_ends_with)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ignore_empty_blobs is not None:
            pulumi.set(__self__, "ignore_empty_blobs", ignore_empty_blobs)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter
    def events(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of events that will fire this trigger. Possible values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobDeleted`.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "events", value)

    @_builtins.property
    @pulumi.getter
    def pipelines(self) -> pulumi.Input[Sequence[pulumi.Input['TriggerBlobEventPipelineArgs']]]:
        """
        One or more `pipeline` blocks as defined below.
        """
        return pulumi.get(self, "pipelines")

    @pipelines.setter
    def pipelines(self, value: pulumi.Input[Sequence[pulumi.Input['TriggerBlobEventPipelineArgs']]]):
        pulumi.set(self, "pipelines", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of Storage Account in which blob event will be listened. Changing this forces a new resource.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter
    def activated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the Data Factory Blob Event Trigger is activated. Defaults to `true`.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "activated", value)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Blob Event Trigger.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Blob Event Trigger.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="blobPathBeginsWith")
    def blob_path_begins_with(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pattern that blob path starts with for trigger to fire.
        """
        return pulumi.get(self, "blob_path_begins_with")

    @blob_path_begins_with.setter
    def blob_path_begins_with(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blob_path_begins_with", value)

    @_builtins.property
    @pulumi.getter(name="blobPathEndsWith")
    def blob_path_ends_with(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pattern that blob path ends with for trigger to fire.

        > **Note:** At least one of `blob_path_begins_with` and `blob_path_ends_with` must be set.
        """
        return pulumi.get(self, "blob_path_ends_with")

    @blob_path_ends_with.setter
    def blob_path_ends_with(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blob_path_ends_with", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Blob Event Trigger.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ignoreEmptyBlobs")
    def ignore_empty_blobs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        are blobs with zero bytes ignored?
        """
        return pulumi.get(self, "ignore_empty_blobs")

    @ignore_empty_blobs.setter
    def ignore_empty_blobs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_empty_blobs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Blob Event Trigger. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _TriggerBlobEventState:
    def __init__(__self__, *,
                 activated: Optional[pulumi.Input[_builtins.bool]] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blob_path_begins_with: Optional[pulumi.Input[_builtins.str]] = None,
                 blob_path_ends_with: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ignore_empty_blobs: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBlobEventPipelineArgs']]]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TriggerBlobEvent resources.
        :param pulumi.Input[_builtins.bool] activated: Specifies if the Data Factory Blob Event Trigger is activated. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Blob Event Trigger.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Blob Event Trigger.
        :param pulumi.Input[_builtins.str] blob_path_begins_with: The pattern that blob path starts with for trigger to fire.
        :param pulumi.Input[_builtins.str] blob_path_ends_with: The pattern that blob path ends with for trigger to fire.
               
               > **Note:** At least one of `blob_path_begins_with` and `blob_path_ends_with` must be set.
        :param pulumi.Input[_builtins.str] data_factory_id: The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Blob Event Trigger.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] events: List of events that will fire this trigger. Possible values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobDeleted`.
        :param pulumi.Input[_builtins.bool] ignore_empty_blobs: are blobs with zero bytes ignored?
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Blob Event Trigger. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBlobEventPipelineArgs']]] pipelines: One or more `pipeline` blocks as defined below.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of Storage Account in which blob event will be listened. Changing this forces a new resource.
        """
        if activated is not None:
            pulumi.set(__self__, "activated", activated)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if blob_path_begins_with is not None:
            pulumi.set(__self__, "blob_path_begins_with", blob_path_begins_with)
        if blob_path_ends_with is not None:
            pulumi.set(__self__, "blob_path_ends_with", blob_path_ends_with)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if ignore_empty_blobs is not None:
            pulumi.set(__self__, "ignore_empty_blobs", ignore_empty_blobs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipelines is not None:
            pulumi.set(__self__, "pipelines", pipelines)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)

    @_builtins.property
    @pulumi.getter
    def activated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the Data Factory Blob Event Trigger is activated. Defaults to `true`.
        """
        return pulumi.get(self, "activated")

    @activated.setter
    def activated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "activated", value)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Blob Event Trigger.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Blob Event Trigger.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="blobPathBeginsWith")
    def blob_path_begins_with(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pattern that blob path starts with for trigger to fire.
        """
        return pulumi.get(self, "blob_path_begins_with")

    @blob_path_begins_with.setter
    def blob_path_begins_with(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blob_path_begins_with", value)

    @_builtins.property
    @pulumi.getter(name="blobPathEndsWith")
    def blob_path_ends_with(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pattern that blob path ends with for trigger to fire.

        > **Note:** At least one of `blob_path_begins_with` and `blob_path_ends_with` must be set.
        """
        return pulumi.get(self, "blob_path_ends_with")

    @blob_path_ends_with.setter
    def blob_path_ends_with(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blob_path_ends_with", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Blob Event Trigger.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of events that will fire this trigger. Possible values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobDeleted`.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "events", value)

    @_builtins.property
    @pulumi.getter(name="ignoreEmptyBlobs")
    def ignore_empty_blobs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        are blobs with zero bytes ignored?
        """
        return pulumi.get(self, "ignore_empty_blobs")

    @ignore_empty_blobs.setter
    def ignore_empty_blobs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_empty_blobs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Blob Event Trigger. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def pipelines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBlobEventPipelineArgs']]]]:
        """
        One or more `pipeline` blocks as defined below.
        """
        return pulumi.get(self, "pipelines")

    @pipelines.setter
    def pipelines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBlobEventPipelineArgs']]]]):
        pulumi.set(self, "pipelines", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Storage Account in which blob event will be listened. Changing this forces a new resource.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)


@pulumi.type_token("azure:datafactory/triggerBlobEvent:TriggerBlobEvent")
class TriggerBlobEvent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[_builtins.bool]] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blob_path_begins_with: Optional[pulumi.Input[_builtins.str]] = None,
                 blob_path_ends_with: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ignore_empty_blobs: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerBlobEventPipelineArgs', 'TriggerBlobEventPipelineArgsDict']]]]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Blob Event Trigger inside an Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_pipeline = azure.datafactory.Pipeline("example",
            name="example",
            data_factory_id=example_factory.id)
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_trigger_blob_event = azure.datafactory.TriggerBlobEvent("example",
            name="example",
            data_factory_id=example_factory.id,
            storage_account_id=example_account.id,
            events=[
                "Microsoft.Storage.BlobCreated",
                "Microsoft.Storage.BlobDeleted",
            ],
            blob_path_ends_with=".txt",
            ignore_empty_blobs=True,
            activated=True,
            annotations=[
                "test1",
                "test2",
                "test3",
            ],
            description="example description",
            pipelines=[{
                "name": example_pipeline.name,
                "parameters": {
                    "Env": "Prod",
                },
            }],
            additional_properties={
                "foo": "foo1",
                "bar": "bar2",
            })
        ```

        ## Import

        Data Factory Blob Event Trigger can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/triggerBlobEvent:TriggerBlobEvent example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/triggers/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] activated: Specifies if the Data Factory Blob Event Trigger is activated. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Blob Event Trigger.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Blob Event Trigger.
        :param pulumi.Input[_builtins.str] blob_path_begins_with: The pattern that blob path starts with for trigger to fire.
        :param pulumi.Input[_builtins.str] blob_path_ends_with: The pattern that blob path ends with for trigger to fire.
               
               > **Note:** At least one of `blob_path_begins_with` and `blob_path_ends_with` must be set.
        :param pulumi.Input[_builtins.str] data_factory_id: The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Blob Event Trigger.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] events: List of events that will fire this trigger. Possible values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobDeleted`.
        :param pulumi.Input[_builtins.bool] ignore_empty_blobs: are blobs with zero bytes ignored?
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Blob Event Trigger. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TriggerBlobEventPipelineArgs', 'TriggerBlobEventPipelineArgsDict']]]] pipelines: One or more `pipeline` blocks as defined below.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of Storage Account in which blob event will be listened. Changing this forces a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TriggerBlobEventArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Blob Event Trigger inside an Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_pipeline = azure.datafactory.Pipeline("example",
            name="example",
            data_factory_id=example_factory.id)
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_trigger_blob_event = azure.datafactory.TriggerBlobEvent("example",
            name="example",
            data_factory_id=example_factory.id,
            storage_account_id=example_account.id,
            events=[
                "Microsoft.Storage.BlobCreated",
                "Microsoft.Storage.BlobDeleted",
            ],
            blob_path_ends_with=".txt",
            ignore_empty_blobs=True,
            activated=True,
            annotations=[
                "test1",
                "test2",
                "test3",
            ],
            description="example description",
            pipelines=[{
                "name": example_pipeline.name,
                "parameters": {
                    "Env": "Prod",
                },
            }],
            additional_properties={
                "foo": "foo1",
                "bar": "bar2",
            })
        ```

        ## Import

        Data Factory Blob Event Trigger can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/triggerBlobEvent:TriggerBlobEvent example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/triggers/example
        ```

        :param str resource_name: The name of the resource.
        :param TriggerBlobEventArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TriggerBlobEventArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activated: Optional[pulumi.Input[_builtins.bool]] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 blob_path_begins_with: Optional[pulumi.Input[_builtins.str]] = None,
                 blob_path_ends_with: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ignore_empty_blobs: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerBlobEventPipelineArgs', 'TriggerBlobEventPipelineArgsDict']]]]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TriggerBlobEventArgs.__new__(TriggerBlobEventArgs)

            __props__.__dict__["activated"] = activated
            __props__.__dict__["additional_properties"] = additional_properties
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["blob_path_begins_with"] = blob_path_begins_with
            __props__.__dict__["blob_path_ends_with"] = blob_path_ends_with
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["description"] = description
            if events is None and not opts.urn:
                raise TypeError("Missing required property 'events'")
            __props__.__dict__["events"] = events
            __props__.__dict__["ignore_empty_blobs"] = ignore_empty_blobs
            __props__.__dict__["name"] = name
            if pipelines is None and not opts.urn:
                raise TypeError("Missing required property 'pipelines'")
            __props__.__dict__["pipelines"] = pipelines
            if storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_id'")
            __props__.__dict__["storage_account_id"] = storage_account_id
        super(TriggerBlobEvent, __self__).__init__(
            'azure:datafactory/triggerBlobEvent:TriggerBlobEvent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated: Optional[pulumi.Input[_builtins.bool]] = None,
            additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            blob_path_begins_with: Optional[pulumi.Input[_builtins.str]] = None,
            blob_path_ends_with: Optional[pulumi.Input[_builtins.str]] = None,
            data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            events: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ignore_empty_blobs: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerBlobEventPipelineArgs', 'TriggerBlobEventPipelineArgsDict']]]]] = None,
            storage_account_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TriggerBlobEvent':
        """
        Get an existing TriggerBlobEvent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] activated: Specifies if the Data Factory Blob Event Trigger is activated. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Blob Event Trigger.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Blob Event Trigger.
        :param pulumi.Input[_builtins.str] blob_path_begins_with: The pattern that blob path starts with for trigger to fire.
        :param pulumi.Input[_builtins.str] blob_path_ends_with: The pattern that blob path ends with for trigger to fire.
               
               > **Note:** At least one of `blob_path_begins_with` and `blob_path_ends_with` must be set.
        :param pulumi.Input[_builtins.str] data_factory_id: The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Blob Event Trigger.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] events: List of events that will fire this trigger. Possible values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobDeleted`.
        :param pulumi.Input[_builtins.bool] ignore_empty_blobs: are blobs with zero bytes ignored?
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Blob Event Trigger. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TriggerBlobEventPipelineArgs', 'TriggerBlobEventPipelineArgsDict']]]] pipelines: One or more `pipeline` blocks as defined below.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of Storage Account in which blob event will be listened. Changing this forces a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TriggerBlobEventState.__new__(_TriggerBlobEventState)

        __props__.__dict__["activated"] = activated
        __props__.__dict__["additional_properties"] = additional_properties
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["blob_path_begins_with"] = blob_path_begins_with
        __props__.__dict__["blob_path_ends_with"] = blob_path_ends_with
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["description"] = description
        __props__.__dict__["events"] = events
        __props__.__dict__["ignore_empty_blobs"] = ignore_empty_blobs
        __props__.__dict__["name"] = name
        __props__.__dict__["pipelines"] = pipelines
        __props__.__dict__["storage_account_id"] = storage_account_id
        return TriggerBlobEvent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def activated(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the Data Factory Blob Event Trigger is activated. Defaults to `true`.
        """
        return pulumi.get(self, "activated")

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of additional properties to associate with the Data Factory Blob Event Trigger.
        """
        return pulumi.get(self, "additional_properties")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags that can be used for describing the Data Factory Blob Event Trigger.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="blobPathBeginsWith")
    def blob_path_begins_with(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The pattern that blob path starts with for trigger to fire.
        """
        return pulumi.get(self, "blob_path_begins_with")

    @_builtins.property
    @pulumi.getter(name="blobPathEndsWith")
    def blob_path_ends_with(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The pattern that blob path ends with for trigger to fire.

        > **Note:** At least one of `blob_path_begins_with` and `blob_path_ends_with` must be set.
        """
        return pulumi.get(self, "blob_path_ends_with")

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of Data Factory in which to associate the Trigger with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the Data Factory Blob Event Trigger.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def events(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of events that will fire this trigger. Possible values are `Microsoft.Storage.BlobCreated` and `Microsoft.Storage.BlobDeleted`.
        """
        return pulumi.get(self, "events")

    @_builtins.property
    @pulumi.getter(name="ignoreEmptyBlobs")
    def ignore_empty_blobs(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        are blobs with zero bytes ignored?
        """
        return pulumi.get(self, "ignore_empty_blobs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Data Factory Blob Event Trigger. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def pipelines(self) -> pulumi.Output[Sequence['outputs.TriggerBlobEventPipeline']]:
        """
        One or more `pipeline` blocks as defined below.
        """
        return pulumi.get(self, "pipelines")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of Storage Account in which blob event will be listened. Changing this forces a new resource.
        """
        return pulumi.get(self, "storage_account_id")

