# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BackupInstanceKubernetesClusterBackupDatasourceParameters',
    'BackupPolicyBlobStorageRetentionRule',
    'BackupPolicyBlobStorageRetentionRuleCriteria',
    'BackupPolicyBlobStorageRetentionRuleLifeCycle',
    'BackupPolicyDiskRetentionRule',
    'BackupPolicyDiskRetentionRuleCriteria',
    'BackupPolicyKubernetesClusterDefaultRetentionRule',
    'BackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle',
    'BackupPolicyKubernetesClusterRetentionRule',
    'BackupPolicyKubernetesClusterRetentionRuleCriteria',
    'BackupPolicyKubernetesClusterRetentionRuleLifeCycle',
    'BackupPolicyMysqlFlexibleServerDefaultRetentionRule',
    'BackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle',
    'BackupPolicyMysqlFlexibleServerRetentionRule',
    'BackupPolicyMysqlFlexibleServerRetentionRuleCriteria',
    'BackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle',
    'BackupPolicyPostgresqlFlexibleServerDefaultRetentionRule',
    'BackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle',
    'BackupPolicyPostgresqlFlexibleServerRetentionRule',
    'BackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria',
    'BackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle',
    'BackupPolicyPostgresqlRetentionRule',
    'BackupPolicyPostgresqlRetentionRuleCriteria',
    'BackupVaultIdentity',
    'GetBackupVaultIdentityResult',
]

@pulumi.output_type
class BackupInstanceKubernetesClusterBackupDatasourceParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterScopedResourcesEnabled":
            suggest = "cluster_scoped_resources_enabled"
        elif key == "excludedNamespaces":
            suggest = "excluded_namespaces"
        elif key == "excludedResourceTypes":
            suggest = "excluded_resource_types"
        elif key == "includedNamespaces":
            suggest = "included_namespaces"
        elif key == "includedResourceTypes":
            suggest = "included_resource_types"
        elif key == "labelSelectors":
            suggest = "label_selectors"
        elif key == "volumeSnapshotEnabled":
            suggest = "volume_snapshot_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupInstanceKubernetesClusterBackupDatasourceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupInstanceKubernetesClusterBackupDatasourceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupInstanceKubernetesClusterBackupDatasourceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_scoped_resources_enabled: Optional[_builtins.bool] = None,
                 excluded_namespaces: Optional[Sequence[_builtins.str]] = None,
                 excluded_resource_types: Optional[Sequence[_builtins.str]] = None,
                 included_namespaces: Optional[Sequence[_builtins.str]] = None,
                 included_resource_types: Optional[Sequence[_builtins.str]] = None,
                 label_selectors: Optional[Sequence[_builtins.str]] = None,
                 volume_snapshot_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool cluster_scoped_resources_enabled: Whether to include cluster scope resources during backup. Default to `false`. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] excluded_namespaces: Specifies the namespaces to be excluded during backup. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] excluded_resource_types: Specifies the resource types to be excluded during backup. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] included_namespaces: Specifies the namespaces to be included during backup. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] included_resource_types: Specifies the resource types to be included during backup. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] label_selectors: Specifies the resources with such label selectors to be included during backup. Changing this forces a new resource to be created.
        :param _builtins.bool volume_snapshot_enabled: Whether to take volume snapshots during backup. Default to `false`. Changing this forces a new resource to be created.
        """
        if cluster_scoped_resources_enabled is not None:
            pulumi.set(__self__, "cluster_scoped_resources_enabled", cluster_scoped_resources_enabled)
        if excluded_namespaces is not None:
            pulumi.set(__self__, "excluded_namespaces", excluded_namespaces)
        if excluded_resource_types is not None:
            pulumi.set(__self__, "excluded_resource_types", excluded_resource_types)
        if included_namespaces is not None:
            pulumi.set(__self__, "included_namespaces", included_namespaces)
        if included_resource_types is not None:
            pulumi.set(__self__, "included_resource_types", included_resource_types)
        if label_selectors is not None:
            pulumi.set(__self__, "label_selectors", label_selectors)
        if volume_snapshot_enabled is not None:
            pulumi.set(__self__, "volume_snapshot_enabled", volume_snapshot_enabled)

    @_builtins.property
    @pulumi.getter(name="clusterScopedResourcesEnabled")
    def cluster_scoped_resources_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to include cluster scope resources during backup. Default to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_scoped_resources_enabled")

    @_builtins.property
    @pulumi.getter(name="excludedNamespaces")
    def excluded_namespaces(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the namespaces to be excluded during backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "excluded_namespaces")

    @_builtins.property
    @pulumi.getter(name="excludedResourceTypes")
    def excluded_resource_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the resource types to be excluded during backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "excluded_resource_types")

    @_builtins.property
    @pulumi.getter(name="includedNamespaces")
    def included_namespaces(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the namespaces to be included during backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "included_namespaces")

    @_builtins.property
    @pulumi.getter(name="includedResourceTypes")
    def included_resource_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the resource types to be included during backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "included_resource_types")

    @_builtins.property
    @pulumi.getter(name="labelSelectors")
    def label_selectors(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the resources with such label selectors to be included during backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "label_selectors")

    @_builtins.property
    @pulumi.getter(name="volumeSnapshotEnabled")
    def volume_snapshot_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to take volume snapshots during backup. Default to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "volume_snapshot_enabled")


@pulumi.output_type
class BackupPolicyBlobStorageRetentionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifeCycle":
            suggest = "life_cycle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyBlobStorageRetentionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyBlobStorageRetentionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyBlobStorageRetentionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 criteria: 'outputs.BackupPolicyBlobStorageRetentionRuleCriteria',
                 life_cycle: 'outputs.BackupPolicyBlobStorageRetentionRuleLifeCycle',
                 name: _builtins.str,
                 priority: _builtins.int):
        """
        :param 'BackupPolicyBlobStorageRetentionRuleCriteriaArgs' criteria: A `criteria` block as defined below. Changing this forces a new Backup Policy Blob Storage to be created.
        :param 'BackupPolicyBlobStorageRetentionRuleLifeCycleArgs' life_cycle: A `life_cycle` block as defined below. Changing this forces a new Backup Policy Blob Storage to be created.
        :param _builtins.str name: The name which should be used for this retention rule. Changing this forces a new Backup Policy Blob Storage to be created.
        :param _builtins.int priority: Specifies the priority of the rule. The priority number must be unique for each rule. The lower the priority number, the higher the priority of the rule. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        pulumi.set(__self__, "criteria", criteria)
        pulumi.set(__self__, "life_cycle", life_cycle)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter
    def criteria(self) -> 'outputs.BackupPolicyBlobStorageRetentionRuleCriteria':
        """
        A `criteria` block as defined below. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        return pulumi.get(self, "criteria")

    @_builtins.property
    @pulumi.getter(name="lifeCycle")
    def life_cycle(self) -> 'outputs.BackupPolicyBlobStorageRetentionRuleLifeCycle':
        """
        A `life_cycle` block as defined below. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        return pulumi.get(self, "life_cycle")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name which should be used for this retention rule. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Specifies the priority of the rule. The priority number must be unique for each rule. The lower the priority number, the higher the priority of the rule. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class BackupPolicyBlobStorageRetentionRuleCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "absoluteCriteria":
            suggest = "absolute_criteria"
        elif key == "daysOfMonths":
            suggest = "days_of_months"
        elif key == "daysOfWeeks":
            suggest = "days_of_weeks"
        elif key == "monthsOfYears":
            suggest = "months_of_years"
        elif key == "scheduledBackupTimes":
            suggest = "scheduled_backup_times"
        elif key == "weeksOfMonths":
            suggest = "weeks_of_months"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyBlobStorageRetentionRuleCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyBlobStorageRetentionRuleCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyBlobStorageRetentionRuleCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 absolute_criteria: Optional[_builtins.str] = None,
                 days_of_months: Optional[Sequence[_builtins.int]] = None,
                 days_of_weeks: Optional[Sequence[_builtins.str]] = None,
                 months_of_years: Optional[Sequence[_builtins.str]] = None,
                 scheduled_backup_times: Optional[Sequence[_builtins.str]] = None,
                 weeks_of_months: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str absolute_criteria: Possible values are `AllBackup`, `FirstOfDay`, `FirstOfWeek`, `FirstOfMonth` and `FirstOfYear`. These values mean the first successful backup of the day/week/month/year. Changing this forces a new Backup Policy Blob Storage to be created.
        :param Sequence[_builtins.int] days_of_months: Must be between `0` and `28`. `0` for last day within the month. Changing this forces a new Backup Policy Blob Storage to be created.
        :param Sequence[_builtins.str] days_of_weeks: Possible values are `Monday`, `Tuesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`. Changing this forces a new Backup Policy Blob Storage to be created.
        :param Sequence[_builtins.str] months_of_years: Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`. Changing this forces a new Backup Policy Blob Storage to be created.
        :param Sequence[_builtins.str] scheduled_backup_times: Specifies a list of backup times for backup in the `RFC3339` format. Changing this forces a new Backup Policy Blob Storage to be created.
        :param Sequence[_builtins.str] weeks_of_months: Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        if absolute_criteria is not None:
            pulumi.set(__self__, "absolute_criteria", absolute_criteria)
        if days_of_months is not None:
            pulumi.set(__self__, "days_of_months", days_of_months)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        if months_of_years is not None:
            pulumi.set(__self__, "months_of_years", months_of_years)
        if scheduled_backup_times is not None:
            pulumi.set(__self__, "scheduled_backup_times", scheduled_backup_times)
        if weeks_of_months is not None:
            pulumi.set(__self__, "weeks_of_months", weeks_of_months)

    @_builtins.property
    @pulumi.getter(name="absoluteCriteria")
    def absolute_criteria(self) -> Optional[_builtins.str]:
        """
        Possible values are `AllBackup`, `FirstOfDay`, `FirstOfWeek`, `FirstOfMonth` and `FirstOfYear`. These values mean the first successful backup of the day/week/month/year. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        return pulumi.get(self, "absolute_criteria")

    @_builtins.property
    @pulumi.getter(name="daysOfMonths")
    def days_of_months(self) -> Optional[Sequence[_builtins.int]]:
        """
        Must be between `0` and `28`. `0` for last day within the month. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        return pulumi.get(self, "days_of_months")

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `Monday`, `Tuesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        return pulumi.get(self, "days_of_weeks")

    @_builtins.property
    @pulumi.getter(name="monthsOfYears")
    def months_of_years(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        return pulumi.get(self, "months_of_years")

    @_builtins.property
    @pulumi.getter(name="scheduledBackupTimes")
    def scheduled_backup_times(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of backup times for backup in the `RFC3339` format. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        return pulumi.get(self, "scheduled_backup_times")

    @_builtins.property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        return pulumi.get(self, "weeks_of_months")


@pulumi.output_type
class BackupPolicyBlobStorageRetentionRuleLifeCycle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStoreType":
            suggest = "data_store_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyBlobStorageRetentionRuleLifeCycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyBlobStorageRetentionRuleLifeCycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyBlobStorageRetentionRuleLifeCycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_store_type: _builtins.str,
                 duration: _builtins.str):
        """
        :param _builtins.str data_store_type: The type of data store. The only possible value is `VaultStore`. Changing this forces a new Backup Policy Blob Storage to be created.
        :param _builtins.str duration: The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        pulumi.set(__self__, "data_store_type", data_store_type)
        pulumi.set(__self__, "duration", duration)

    @_builtins.property
    @pulumi.getter(name="dataStoreType")
    def data_store_type(self) -> _builtins.str:
        """
        The type of data store. The only possible value is `VaultStore`. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        return pulumi.get(self, "data_store_type")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new Backup Policy Blob Storage to be created.
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class BackupPolicyDiskRetentionRule(dict):
    def __init__(__self__, *,
                 criteria: 'outputs.BackupPolicyDiskRetentionRuleCriteria',
                 duration: _builtins.str,
                 name: _builtins.str,
                 priority: _builtins.int):
        """
        :param 'BackupPolicyDiskRetentionRuleCriteriaArgs' criteria: A `criteria` block as defined below. Changing this forces a new Backup Policy Disk to be created.
        :param _builtins.str duration: Duration of deletion after given timespan. It should follow `ISO 8601` duration format. Changing this forces a new Backup Policy Disk to be created.
        :param _builtins.str name: The name which should be used for this retention rule. Changing this forces a new Backup Policy Disk to be created.
        :param _builtins.int priority: Retention Tag priority. Changing this forces a new Backup Policy Disk to be created.
        """
        pulumi.set(__self__, "criteria", criteria)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter
    def criteria(self) -> 'outputs.BackupPolicyDiskRetentionRuleCriteria':
        """
        A `criteria` block as defined below. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "criteria")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        Duration of deletion after given timespan. It should follow `ISO 8601` duration format. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name which should be used for this retention rule. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Retention Tag priority. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class BackupPolicyDiskRetentionRuleCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "absoluteCriteria":
            suggest = "absolute_criteria"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyDiskRetentionRuleCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyDiskRetentionRuleCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyDiskRetentionRuleCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 absolute_criteria: Optional[_builtins.str] = None):
        """
        :param _builtins.str absolute_criteria: Possible values are `FirstOfDay` and `FirstOfWeek`. Changing this forces a new Backup Policy Disk to be created.
        """
        if absolute_criteria is not None:
            pulumi.set(__self__, "absolute_criteria", absolute_criteria)

    @_builtins.property
    @pulumi.getter(name="absoluteCriteria")
    def absolute_criteria(self) -> Optional[_builtins.str]:
        """
        Possible values are `FirstOfDay` and `FirstOfWeek`. Changing this forces a new Backup Policy Disk to be created.
        """
        return pulumi.get(self, "absolute_criteria")


@pulumi.output_type
class BackupPolicyKubernetesClusterDefaultRetentionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifeCycles":
            suggest = "life_cycles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyKubernetesClusterDefaultRetentionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyKubernetesClusterDefaultRetentionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyKubernetesClusterDefaultRetentionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 life_cycles: Sequence['outputs.BackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle']):
        """
        :param Sequence['BackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycleArgs'] life_cycles: A `life_cycle` block as defined below. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "life_cycles", life_cycles)

    @_builtins.property
    @pulumi.getter(name="lifeCycles")
    def life_cycles(self) -> Sequence['outputs.BackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle']:
        """
        A `life_cycle` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "life_cycles")


@pulumi.output_type
class BackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStoreType":
            suggest = "data_store_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_store_type: _builtins.str,
                 duration: _builtins.str):
        """
        :param _builtins.str data_store_type: The type of data store. The only possible value is `OperationalStore`. Changing this forces a new resource to be created.
        :param _builtins.str duration: The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "data_store_type", data_store_type)
        pulumi.set(__self__, "duration", duration)

    @_builtins.property
    @pulumi.getter(name="dataStoreType")
    def data_store_type(self) -> _builtins.str:
        """
        The type of data store. The only possible value is `OperationalStore`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_store_type")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class BackupPolicyKubernetesClusterRetentionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifeCycles":
            suggest = "life_cycles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyKubernetesClusterRetentionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyKubernetesClusterRetentionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyKubernetesClusterRetentionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 criteria: 'outputs.BackupPolicyKubernetesClusterRetentionRuleCriteria',
                 life_cycles: Sequence['outputs.BackupPolicyKubernetesClusterRetentionRuleLifeCycle'],
                 name: _builtins.str,
                 priority: _builtins.int):
        """
        :param 'BackupPolicyKubernetesClusterRetentionRuleCriteriaArgs' criteria: A `criteria` block as defined below. Changing this forces a new resource to be created.
        :param Sequence['BackupPolicyKubernetesClusterRetentionRuleLifeCycleArgs'] life_cycles: A `life_cycle` block as defined below. Changing this forces a new resource to be created.
        :param _builtins.str name: The name which should be used for this retention rule. Changing this forces a new resource to be created.
        :param _builtins.int priority: Specifies the priority of the rule. The priority number must be unique for each rule. The lower the priority number, the higher the priority of the rule. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "criteria", criteria)
        pulumi.set(__self__, "life_cycles", life_cycles)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter
    def criteria(self) -> 'outputs.BackupPolicyKubernetesClusterRetentionRuleCriteria':
        """
        A `criteria` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "criteria")

    @_builtins.property
    @pulumi.getter(name="lifeCycles")
    def life_cycles(self) -> Sequence['outputs.BackupPolicyKubernetesClusterRetentionRuleLifeCycle']:
        """
        A `life_cycle` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "life_cycles")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name which should be used for this retention rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Specifies the priority of the rule. The priority number must be unique for each rule. The lower the priority number, the higher the priority of the rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class BackupPolicyKubernetesClusterRetentionRuleCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "absoluteCriteria":
            suggest = "absolute_criteria"
        elif key == "daysOfWeeks":
            suggest = "days_of_weeks"
        elif key == "monthsOfYears":
            suggest = "months_of_years"
        elif key == "scheduledBackupTimes":
            suggest = "scheduled_backup_times"
        elif key == "weeksOfMonths":
            suggest = "weeks_of_months"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyKubernetesClusterRetentionRuleCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyKubernetesClusterRetentionRuleCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyKubernetesClusterRetentionRuleCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 absolute_criteria: Optional[_builtins.str] = None,
                 days_of_weeks: Optional[Sequence[_builtins.str]] = None,
                 months_of_years: Optional[Sequence[_builtins.str]] = None,
                 scheduled_backup_times: Optional[Sequence[_builtins.str]] = None,
                 weeks_of_months: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str absolute_criteria: Possible values are `AllBackup`, `FirstOfDay`, `FirstOfWeek`, `FirstOfMonth` and `FirstOfYear`. These values mean the first successful backup of the day/week/month/year. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] days_of_weeks: Possible values are `Monday`, `Tuesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] months_of_years: Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] scheduled_backup_times: Specifies a list of backup times for backup in the `RFC3339` format. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] weeks_of_months: Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`. Changing this forces a new resource to be created.
        """
        if absolute_criteria is not None:
            pulumi.set(__self__, "absolute_criteria", absolute_criteria)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        if months_of_years is not None:
            pulumi.set(__self__, "months_of_years", months_of_years)
        if scheduled_backup_times is not None:
            pulumi.set(__self__, "scheduled_backup_times", scheduled_backup_times)
        if weeks_of_months is not None:
            pulumi.set(__self__, "weeks_of_months", weeks_of_months)

    @_builtins.property
    @pulumi.getter(name="absoluteCriteria")
    def absolute_criteria(self) -> Optional[_builtins.str]:
        """
        Possible values are `AllBackup`, `FirstOfDay`, `FirstOfWeek`, `FirstOfMonth` and `FirstOfYear`. These values mean the first successful backup of the day/week/month/year. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "absolute_criteria")

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `Monday`, `Tuesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "days_of_weeks")

    @_builtins.property
    @pulumi.getter(name="monthsOfYears")
    def months_of_years(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "months_of_years")

    @_builtins.property
    @pulumi.getter(name="scheduledBackupTimes")
    def scheduled_backup_times(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of backup times for backup in the `RFC3339` format. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scheduled_backup_times")

    @_builtins.property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "weeks_of_months")


@pulumi.output_type
class BackupPolicyKubernetesClusterRetentionRuleLifeCycle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStoreType":
            suggest = "data_store_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyKubernetesClusterRetentionRuleLifeCycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyKubernetesClusterRetentionRuleLifeCycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyKubernetesClusterRetentionRuleLifeCycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_store_type: _builtins.str,
                 duration: _builtins.str):
        """
        :param _builtins.str data_store_type: The type of data store. The only possible value is `OperationalStore`. Changing this forces a new resource to be created.
        :param _builtins.str duration: The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "data_store_type", data_store_type)
        pulumi.set(__self__, "duration", duration)

    @_builtins.property
    @pulumi.getter(name="dataStoreType")
    def data_store_type(self) -> _builtins.str:
        """
        The type of data store. The only possible value is `OperationalStore`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_store_type")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class BackupPolicyMysqlFlexibleServerDefaultRetentionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifeCycles":
            suggest = "life_cycles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyMysqlFlexibleServerDefaultRetentionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyMysqlFlexibleServerDefaultRetentionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyMysqlFlexibleServerDefaultRetentionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 life_cycles: Sequence['outputs.BackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle']):
        """
        :param Sequence['BackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycleArgs'] life_cycles: A `life_cycle` block as defined below. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "life_cycles", life_cycles)

    @_builtins.property
    @pulumi.getter(name="lifeCycles")
    def life_cycles(self) -> Sequence['outputs.BackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle']:
        """
        A `life_cycle` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "life_cycles")


@pulumi.output_type
class BackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStoreType":
            suggest = "data_store_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyMysqlFlexibleServerDefaultRetentionRuleLifeCycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_store_type: _builtins.str,
                 duration: _builtins.str):
        """
        :param _builtins.str data_store_type: The type of data store. The only possible value is `VaultStore`. Changing this forces a new resource to be created.
        :param _builtins.str duration: The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "data_store_type", data_store_type)
        pulumi.set(__self__, "duration", duration)

    @_builtins.property
    @pulumi.getter(name="dataStoreType")
    def data_store_type(self) -> _builtins.str:
        """
        The type of data store. The only possible value is `VaultStore`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_store_type")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class BackupPolicyMysqlFlexibleServerRetentionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifeCycles":
            suggest = "life_cycles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyMysqlFlexibleServerRetentionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyMysqlFlexibleServerRetentionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyMysqlFlexibleServerRetentionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 criteria: 'outputs.BackupPolicyMysqlFlexibleServerRetentionRuleCriteria',
                 life_cycles: Sequence['outputs.BackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle'],
                 name: _builtins.str,
                 priority: _builtins.int):
        """
        :param 'BackupPolicyMysqlFlexibleServerRetentionRuleCriteriaArgs' criteria: A `criteria` block as defined below. Changing this forces a new resource to be created.
        :param Sequence['BackupPolicyMysqlFlexibleServerRetentionRuleLifeCycleArgs'] life_cycles: A `life_cycle` block as defined below. Changing this forces a new resource to be created.
        :param _builtins.str name: Specifies the name of the retention rule. Changing this forces a new resource to be created.
        :param _builtins.int priority: Specifies the priority of the rule. The priority number must be unique for each rule. The lower the priority number, the higher the priority of the rule. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "criteria", criteria)
        pulumi.set(__self__, "life_cycles", life_cycles)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter
    def criteria(self) -> 'outputs.BackupPolicyMysqlFlexibleServerRetentionRuleCriteria':
        """
        A `criteria` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "criteria")

    @_builtins.property
    @pulumi.getter(name="lifeCycles")
    def life_cycles(self) -> Sequence['outputs.BackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle']:
        """
        A `life_cycle` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "life_cycles")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the retention rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Specifies the priority of the rule. The priority number must be unique for each rule. The lower the priority number, the higher the priority of the rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class BackupPolicyMysqlFlexibleServerRetentionRuleCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "absoluteCriteria":
            suggest = "absolute_criteria"
        elif key == "daysOfWeeks":
            suggest = "days_of_weeks"
        elif key == "monthsOfYears":
            suggest = "months_of_years"
        elif key == "scheduledBackupTimes":
            suggest = "scheduled_backup_times"
        elif key == "weeksOfMonths":
            suggest = "weeks_of_months"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyMysqlFlexibleServerRetentionRuleCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyMysqlFlexibleServerRetentionRuleCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyMysqlFlexibleServerRetentionRuleCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 absolute_criteria: Optional[_builtins.str] = None,
                 days_of_weeks: Optional[Sequence[_builtins.str]] = None,
                 months_of_years: Optional[Sequence[_builtins.str]] = None,
                 scheduled_backup_times: Optional[Sequence[_builtins.str]] = None,
                 weeks_of_months: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str absolute_criteria: Possible values are `AllBackup`, `FirstOfDay`, `FirstOfWeek`, `FirstOfMonth` and `FirstOfYear`. These values mean the first successful backup of the day/week/month/year. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] days_of_weeks: Possible values are `Monday`, `Tuesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] months_of_years: Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] scheduled_backup_times: Specifies a list of backup times for backup in the `RFC3339` format. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] weeks_of_months: Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`. Changing this forces a new resource to be created.
        """
        if absolute_criteria is not None:
            pulumi.set(__self__, "absolute_criteria", absolute_criteria)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        if months_of_years is not None:
            pulumi.set(__self__, "months_of_years", months_of_years)
        if scheduled_backup_times is not None:
            pulumi.set(__self__, "scheduled_backup_times", scheduled_backup_times)
        if weeks_of_months is not None:
            pulumi.set(__self__, "weeks_of_months", weeks_of_months)

    @_builtins.property
    @pulumi.getter(name="absoluteCriteria")
    def absolute_criteria(self) -> Optional[_builtins.str]:
        """
        Possible values are `AllBackup`, `FirstOfDay`, `FirstOfWeek`, `FirstOfMonth` and `FirstOfYear`. These values mean the first successful backup of the day/week/month/year. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "absolute_criteria")

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `Monday`, `Tuesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "days_of_weeks")

    @_builtins.property
    @pulumi.getter(name="monthsOfYears")
    def months_of_years(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "months_of_years")

    @_builtins.property
    @pulumi.getter(name="scheduledBackupTimes")
    def scheduled_backup_times(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of backup times for backup in the `RFC3339` format. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scheduled_backup_times")

    @_builtins.property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "weeks_of_months")


@pulumi.output_type
class BackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStoreType":
            suggest = "data_store_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyMysqlFlexibleServerRetentionRuleLifeCycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_store_type: _builtins.str,
                 duration: _builtins.str):
        """
        :param _builtins.str data_store_type: The type of data store. The only possible value is `VaultStore`. Changing this forces a new resource to be created.
        :param _builtins.str duration: The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "data_store_type", data_store_type)
        pulumi.set(__self__, "duration", duration)

    @_builtins.property
    @pulumi.getter(name="dataStoreType")
    def data_store_type(self) -> _builtins.str:
        """
        The type of data store. The only possible value is `VaultStore`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_store_type")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class BackupPolicyPostgresqlFlexibleServerDefaultRetentionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifeCycles":
            suggest = "life_cycles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyPostgresqlFlexibleServerDefaultRetentionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyPostgresqlFlexibleServerDefaultRetentionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyPostgresqlFlexibleServerDefaultRetentionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 life_cycles: Sequence['outputs.BackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle']):
        """
        :param Sequence['BackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycleArgs'] life_cycles: A `life_cycle` block as defined below. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "life_cycles", life_cycles)

    @_builtins.property
    @pulumi.getter(name="lifeCycles")
    def life_cycles(self) -> Sequence['outputs.BackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle']:
        """
        A `life_cycle` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "life_cycles")


@pulumi.output_type
class BackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStoreType":
            suggest = "data_store_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyPostgresqlFlexibleServerDefaultRetentionRuleLifeCycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_store_type: _builtins.str,
                 duration: _builtins.str):
        """
        :param _builtins.str data_store_type: The type of data store. The only possible value is `VaultStore`. Changing this forces a new resource to be created.
        :param _builtins.str duration: The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "data_store_type", data_store_type)
        pulumi.set(__self__, "duration", duration)

    @_builtins.property
    @pulumi.getter(name="dataStoreType")
    def data_store_type(self) -> _builtins.str:
        """
        The type of data store. The only possible value is `VaultStore`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_store_type")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class BackupPolicyPostgresqlFlexibleServerRetentionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifeCycles":
            suggest = "life_cycles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyPostgresqlFlexibleServerRetentionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyPostgresqlFlexibleServerRetentionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyPostgresqlFlexibleServerRetentionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 criteria: 'outputs.BackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria',
                 life_cycles: Sequence['outputs.BackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle'],
                 name: _builtins.str,
                 priority: _builtins.int):
        """
        :param 'BackupPolicyPostgresqlFlexibleServerRetentionRuleCriteriaArgs' criteria: A `criteria` block as defined below. Changing this forces a new resource to be created.
        :param Sequence['BackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycleArgs'] life_cycles: A `life_cycle` block as defined below. Changing this forces a new resource to be created.
        :param _builtins.str name: Specifies the name of the retention rule. Changing this forces a new resource to be created.
        :param _builtins.int priority: Specifies the priority of the rule. The priority number must be unique for each rule. The lower the priority number, the higher the priority of the rule. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "criteria", criteria)
        pulumi.set(__self__, "life_cycles", life_cycles)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter
    def criteria(self) -> 'outputs.BackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria':
        """
        A `criteria` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "criteria")

    @_builtins.property
    @pulumi.getter(name="lifeCycles")
    def life_cycles(self) -> Sequence['outputs.BackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle']:
        """
        A `life_cycle` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "life_cycles")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the retention rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Specifies the priority of the rule. The priority number must be unique for each rule. The lower the priority number, the higher the priority of the rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class BackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "absoluteCriteria":
            suggest = "absolute_criteria"
        elif key == "daysOfWeeks":
            suggest = "days_of_weeks"
        elif key == "monthsOfYears":
            suggest = "months_of_years"
        elif key == "scheduledBackupTimes":
            suggest = "scheduled_backup_times"
        elif key == "weeksOfMonths":
            suggest = "weeks_of_months"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyPostgresqlFlexibleServerRetentionRuleCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 absolute_criteria: Optional[_builtins.str] = None,
                 days_of_weeks: Optional[Sequence[_builtins.str]] = None,
                 months_of_years: Optional[Sequence[_builtins.str]] = None,
                 scheduled_backup_times: Optional[Sequence[_builtins.str]] = None,
                 weeks_of_months: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str absolute_criteria: Possible values are `AllBackup`, `FirstOfDay`, `FirstOfWeek`, `FirstOfMonth` and `FirstOfYear`. These values mean the first successful backup of the day/week/month/year. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] days_of_weeks: Possible values are `Monday`, `Tuesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] months_of_years: Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] scheduled_backup_times: Specifies a list of backup times for backup in the `RFC3339` format. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] weeks_of_months: Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`. Changing this forces a new resource to be created.
        """
        if absolute_criteria is not None:
            pulumi.set(__self__, "absolute_criteria", absolute_criteria)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        if months_of_years is not None:
            pulumi.set(__self__, "months_of_years", months_of_years)
        if scheduled_backup_times is not None:
            pulumi.set(__self__, "scheduled_backup_times", scheduled_backup_times)
        if weeks_of_months is not None:
            pulumi.set(__self__, "weeks_of_months", weeks_of_months)

    @_builtins.property
    @pulumi.getter(name="absoluteCriteria")
    def absolute_criteria(self) -> Optional[_builtins.str]:
        """
        Possible values are `AllBackup`, `FirstOfDay`, `FirstOfWeek`, `FirstOfMonth` and `FirstOfYear`. These values mean the first successful backup of the day/week/month/year. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "absolute_criteria")

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `Monday`, `Tuesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "days_of_weeks")

    @_builtins.property
    @pulumi.getter(name="monthsOfYears")
    def months_of_years(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "months_of_years")

    @_builtins.property
    @pulumi.getter(name="scheduledBackupTimes")
    def scheduled_backup_times(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of backup times for backup in the `RFC3339` format. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scheduled_backup_times")

    @_builtins.property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "weeks_of_months")


@pulumi.output_type
class BackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStoreType":
            suggest = "data_store_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyPostgresqlFlexibleServerRetentionRuleLifeCycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_store_type: _builtins.str,
                 duration: _builtins.str):
        """
        :param _builtins.str data_store_type: The type of data store. The only possible value is `VaultStore`. Changing this forces a new resource to be created.
        :param _builtins.str duration: The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "data_store_type", data_store_type)
        pulumi.set(__self__, "duration", duration)

    @_builtins.property
    @pulumi.getter(name="dataStoreType")
    def data_store_type(self) -> _builtins.str:
        """
        The type of data store. The only possible value is `VaultStore`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_store_type")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        The retention duration up to which the backups are to be retained in the data stores. It should follow `ISO 8601` duration format. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class BackupPolicyPostgresqlRetentionRule(dict):
    def __init__(__self__, *,
                 criteria: 'outputs.BackupPolicyPostgresqlRetentionRuleCriteria',
                 duration: _builtins.str,
                 name: _builtins.str,
                 priority: _builtins.int):
        """
        :param 'BackupPolicyPostgresqlRetentionRuleCriteriaArgs' criteria: A `criteria` block as defined below. Changing this forces a new Backup Policy PostgreSQL to be created.
        :param _builtins.str duration: Duration after which the backup is deleted. It should follow `ISO 8601` duration format. Changing this forces a new Backup Policy PostgreSQL to be created.
        :param _builtins.str name: The name which should be used for this retention rule. Changing this forces a new Backup Policy PostgreSQL to be created.
        :param _builtins.int priority: Specifies the priority of the rule. The priority number must be unique for each rule. The lower the priority number, the higher the priority of the rule. Changing this forces a new Backup Policy PostgreSQL to be created.
        """
        pulumi.set(__self__, "criteria", criteria)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter
    def criteria(self) -> 'outputs.BackupPolicyPostgresqlRetentionRuleCriteria':
        """
        A `criteria` block as defined below. Changing this forces a new Backup Policy PostgreSQL to be created.
        """
        return pulumi.get(self, "criteria")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        Duration after which the backup is deleted. It should follow `ISO 8601` duration format. Changing this forces a new Backup Policy PostgreSQL to be created.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name which should be used for this retention rule. Changing this forces a new Backup Policy PostgreSQL to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Specifies the priority of the rule. The priority number must be unique for each rule. The lower the priority number, the higher the priority of the rule. Changing this forces a new Backup Policy PostgreSQL to be created.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class BackupPolicyPostgresqlRetentionRuleCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "absoluteCriteria":
            suggest = "absolute_criteria"
        elif key == "daysOfWeeks":
            suggest = "days_of_weeks"
        elif key == "monthsOfYears":
            suggest = "months_of_years"
        elif key == "scheduledBackupTimes":
            suggest = "scheduled_backup_times"
        elif key == "weeksOfMonths":
            suggest = "weeks_of_months"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPolicyPostgresqlRetentionRuleCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPolicyPostgresqlRetentionRuleCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPolicyPostgresqlRetentionRuleCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 absolute_criteria: Optional[_builtins.str] = None,
                 days_of_weeks: Optional[Sequence[_builtins.str]] = None,
                 months_of_years: Optional[Sequence[_builtins.str]] = None,
                 scheduled_backup_times: Optional[Sequence[_builtins.str]] = None,
                 weeks_of_months: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str absolute_criteria: Possible values are `AllBackup`, `FirstOfDay`, `FirstOfWeek`, `FirstOfMonth` and `FirstOfYear`. These values mean the first successful backup of the day/week/month/year. Changing this forces a new Backup Policy PostgreSQL to be created.
        :param Sequence[_builtins.str] days_of_weeks: Possible values are `Monday`, `Tuesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`. Changing this forces a new Backup Policy PostgreSQL to be created.
        :param Sequence[_builtins.str] months_of_years: Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`. Changing this forces a new Backup Policy PostgreSQL to be created.
        :param Sequence[_builtins.str] scheduled_backup_times: Specifies a list of backup times for backup in the `RFC3339` format. Changing this forces a new Backup Policy PostgreSQL to be created.
        :param Sequence[_builtins.str] weeks_of_months: Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`. Changing this forces a new Backup Policy PostgreSQL to be created.
        """
        if absolute_criteria is not None:
            pulumi.set(__self__, "absolute_criteria", absolute_criteria)
        if days_of_weeks is not None:
            pulumi.set(__self__, "days_of_weeks", days_of_weeks)
        if months_of_years is not None:
            pulumi.set(__self__, "months_of_years", months_of_years)
        if scheduled_backup_times is not None:
            pulumi.set(__self__, "scheduled_backup_times", scheduled_backup_times)
        if weeks_of_months is not None:
            pulumi.set(__self__, "weeks_of_months", weeks_of_months)

    @_builtins.property
    @pulumi.getter(name="absoluteCriteria")
    def absolute_criteria(self) -> Optional[_builtins.str]:
        """
        Possible values are `AllBackup`, `FirstOfDay`, `FirstOfWeek`, `FirstOfMonth` and `FirstOfYear`. These values mean the first successful backup of the day/week/month/year. Changing this forces a new Backup Policy PostgreSQL to be created.
        """
        return pulumi.get(self, "absolute_criteria")

    @_builtins.property
    @pulumi.getter(name="daysOfWeeks")
    def days_of_weeks(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `Monday`, `Tuesday`, `Thursday`, `Friday`, `Saturday` and `Sunday`. Changing this forces a new Backup Policy PostgreSQL to be created.
        """
        return pulumi.get(self, "days_of_weeks")

    @_builtins.property
    @pulumi.getter(name="monthsOfYears")
    def months_of_years(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`. Changing this forces a new Backup Policy PostgreSQL to be created.
        """
        return pulumi.get(self, "months_of_years")

    @_builtins.property
    @pulumi.getter(name="scheduledBackupTimes")
    def scheduled_backup_times(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of backup times for backup in the `RFC3339` format. Changing this forces a new Backup Policy PostgreSQL to be created.
        """
        return pulumi.get(self, "scheduled_backup_times")

    @_builtins.property
    @pulumi.getter(name="weeksOfMonths")
    def weeks_of_months(self) -> Optional[Sequence[_builtins.str]]:
        """
        Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`. Changing this forces a new Backup Policy PostgreSQL to be created.
        """
        return pulumi.get(self, "weeks_of_months")


@pulumi.output_type
class BackupVaultIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupVaultIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupVaultIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupVaultIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Backup Vault. The only possible value is `SystemAssigned`.
        :param _builtins.str principal_id: The Principal ID for the Service Principal associated with the Identity of this Backup Vault.
        :param _builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Identity of this Backup Vault.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Backup Vault. The only possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Identity of this Backup Vault.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Identity of this Backup Vault.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class GetBackupVaultIdentityResult(dict):
    def __init__(__self__, *,
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this Backup Vault.
        :param _builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on this Backup Vault.
        :param _builtins.str type: The type of Managed Service Identity that is configured on this Backup Vault.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this Backup Vault.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on this Backup Vault.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of Managed Service Identity that is configured on this Backup Vault.
        """
        return pulumi.get(self, "type")


