# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DevBoxDefinitionArgs', 'DevBoxDefinition']

@pulumi.input_type
class DevBoxDefinitionArgs:
    def __init__(__self__, *,
                 dev_center_id: pulumi.Input[_builtins.str],
                 image_reference_id: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DevBoxDefinition resource.
        :param pulumi.Input[_builtins.str] dev_center_id: The ID of the associated Dev Center. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] image_reference_id: The ID of the image for the Dev Center Dev Box Definition.
        :param pulumi.Input[_builtins.str] sku_name: The name of the SKU for the Dev Center Dev Box Definition.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Dev Box Definition should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Dev Box Definition. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Dev Box Definition.
        """
        pulumi.set(__self__, "dev_center_id", dev_center_id)
        pulumi.set(__self__, "image_reference_id", image_reference_id)
        pulumi.set(__self__, "sku_name", sku_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="devCenterId")
    def dev_center_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the associated Dev Center. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dev_center_id")

    @dev_center_id.setter
    def dev_center_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dev_center_id", value)

    @_builtins.property
    @pulumi.getter(name="imageReferenceId")
    def image_reference_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the image for the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "image_reference_id")

    @image_reference_id.setter
    def image_reference_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image_reference_id", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the SKU for the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dev Center Dev Box Definition should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center Dev Box Definition. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DevBoxDefinitionState:
    def __init__(__self__, *,
                 dev_center_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DevBoxDefinition resources.
        :param pulumi.Input[_builtins.str] dev_center_id: The ID of the associated Dev Center. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] image_reference_id: The ID of the image for the Dev Center Dev Box Definition.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Dev Box Definition should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Dev Box Definition. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The name of the SKU for the Dev Center Dev Box Definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Dev Box Definition.
        """
        if dev_center_id is not None:
            pulumi.set(__self__, "dev_center_id", dev_center_id)
        if image_reference_id is not None:
            pulumi.set(__self__, "image_reference_id", image_reference_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="devCenterId")
    def dev_center_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the associated Dev Center. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dev_center_id")

    @dev_center_id.setter
    def dev_center_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dev_center_id", value)

    @_builtins.property
    @pulumi.getter(name="imageReferenceId")
    def image_reference_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the image for the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "image_reference_id")

    @image_reference_id.setter
    def image_reference_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_reference_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dev Center Dev Box Definition should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center Dev Box Definition. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SKU for the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:devcenter/devBoxDefinition:DevBoxDefinition")
class DevBoxDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dev_center_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Dev Center Dev Box Definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_dev_center = azure.devcenter.DevCenter("example",
            name="example-dc",
            resource_group_name=example.name,
            location=example.location,
            identity={
                "type": "SystemAssigned",
            })
        example_dev_box_definition = azure.devcenter.DevBoxDefinition("example",
            name="example-dcet",
            location=example.location,
            dev_center_id=example_dev_center.id,
            image_reference_id=example_dev_center.id.apply(lambda id: f"{id}/galleries/default/images/microsoftvisualstudio_visualstudioplustools_vs-2022-ent-general-win10-m365-gen2"),
            sku_name="general_i_8c32gb256ssd_v2")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter`: 2025-02-01

        ## Import

        An existing Dev Center Dev Box Definition can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/devBoxDefinition:DevBoxDefinition example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DevCenter/devCenters/dc1/devBoxDefinitions/et1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dev_center_id: The ID of the associated Dev Center. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] image_reference_id: The ID of the image for the Dev Center Dev Box Definition.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Dev Box Definition should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Dev Box Definition. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The name of the SKU for the Dev Center Dev Box Definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Dev Box Definition.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DevBoxDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dev Center Dev Box Definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_dev_center = azure.devcenter.DevCenter("example",
            name="example-dc",
            resource_group_name=example.name,
            location=example.location,
            identity={
                "type": "SystemAssigned",
            })
        example_dev_box_definition = azure.devcenter.DevBoxDefinition("example",
            name="example-dcet",
            location=example.location,
            dev_center_id=example_dev_center.id,
            image_reference_id=example_dev_center.id.apply(lambda id: f"{id}/galleries/default/images/microsoftvisualstudio_visualstudioplustools_vs-2022-ent-general-win10-m365-gen2"),
            sku_name="general_i_8c32gb256ssd_v2")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter`: 2025-02-01

        ## Import

        An existing Dev Center Dev Box Definition can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/devBoxDefinition:DevBoxDefinition example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DevCenter/devCenters/dc1/devBoxDefinitions/et1
        ```

        :param str resource_name: The name of the resource.
        :param DevBoxDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DevBoxDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dev_center_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DevBoxDefinitionArgs.__new__(DevBoxDefinitionArgs)

            if dev_center_id is None and not opts.urn:
                raise TypeError("Missing required property 'dev_center_id'")
            __props__.__dict__["dev_center_id"] = dev_center_id
            if image_reference_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_reference_id'")
            __props__.__dict__["image_reference_id"] = image_reference_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["tags"] = tags
        super(DevBoxDefinition, __self__).__init__(
            'azure:devcenter/devBoxDefinition:DevBoxDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dev_center_id: Optional[pulumi.Input[_builtins.str]] = None,
            image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'DevBoxDefinition':
        """
        Get an existing DevBoxDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dev_center_id: The ID of the associated Dev Center. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] image_reference_id: The ID of the image for the Dev Center Dev Box Definition.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Dev Box Definition should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Dev Box Definition. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The name of the SKU for the Dev Center Dev Box Definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Dev Box Definition.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DevBoxDefinitionState.__new__(_DevBoxDefinitionState)

        __props__.__dict__["dev_center_id"] = dev_center_id
        __props__.__dict__["image_reference_id"] = image_reference_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["tags"] = tags
        return DevBoxDefinition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="devCenterId")
    def dev_center_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the associated Dev Center. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dev_center_id")

    @_builtins.property
    @pulumi.getter(name="imageReferenceId")
    def image_reference_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the image for the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "image_reference_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Dev Center Dev Box Definition should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Dev Center Dev Box Definition. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the SKU for the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Dev Box Definition.
        """
        return pulumi.get(self, "tags")

